<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kartu Tagihan - MMU A-39 REJOSARI</title>
    <!-- <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/css/bootstrap.min.css" rel="stylesheet"> -->
    
    <style>
        :root {
            --primary-gradient: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            --success-gradient: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
            --warning-gradient: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
            --dark-gradient: linear-gradient(135deg, #2c3e50 0%, #34495e 100%);
            --glass-bg: rgba(255, 255, 255, 0.25);
            --glass-border: rgba(255, 255, 255, 0.18);
            --shadow-light: 0 8px 32px rgba(31, 38, 135, 0.37);
            --shadow-heavy: 0 20px 40px rgba(0, 0, 0, 0.1);
            --border-radius: 20px;
            --transition: all 0.4s cubic-bezier(0.165, 0.84, 0.44, 1);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

       /*  body {
            background: linear-gradient(135deg,rgb(196, 203, 231) 0%,rgb(189, 172, 206) 50%,rgb(223, 209, 224) 100%);
            background-attachment: fixed;
            min-height: 100vh;
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
            position: relative;
            overflow-x: hidden;
        } */

        body::before {
            content: '';
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: 
                radial-gradient(circle at 20% 80%, rgba(120, 119, 198, 0.3) 0%, transparent 50%),
                radial-gradient(circle at 80% 20%, rgba(255, 119, 198, 0.3) 0%, transparent 50%),
                radial-gradient(circle at 40% 40%, rgba(120, 219, 226, 0.3) 0%, transparent 50%);
            pointer-events: none;
            z-index: -1;
        }

        .main-container {
            background: var(--glass-bg);
            backdrop-filter: blur(20px);
            border: 1px solid var(--glass-border);
            border-radius: var(--border-radius);
            box-shadow: var(--shadow-light);
            margin: 2rem auto;
            max-width: 1400px;
            overflow: hidden;
            position: relative;
        }

        .page-header {
            background: var(--primary-gradient);
            color: white;
            padding: 1rem 1rem;
            position: relative;
            overflow: hidden;
        }

        .page-header::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: repeating-linear-gradient(
                45deg,
                transparent,
                transparent 2px,
                rgba(67, 115, 163, 0.05) 2px,
                rgba(255, 255, 255, 0.05) 4px
            );
            animation: shimmer 20s linear infinite;
            pointer-events: none;
        }

        @keyframes shimmer {
            0% { transform: translateX(-100%) translateY(-100%) rotate(45deg); }
            100% { transform: translateX(100%) translateY(100%) rotate(45deg); }
        }

        .page-header h1 {
            font-size: 1.5rem;
            font-weight: 800;
            margin-bottom: 0.5rem;
            position: relative;
            z-index: 2;
            text-shadow: 2px 2px 4px rgba(171, 171, 225, 0.3);
        }

        .page-header .subtitle {
            font-size: 1rem;
            opacity: 0.9;
            position: relative;
            z-index: 2;
            font-weight: 200;
        }

        .floating-icon {
            position: absolute;
            right: 2rem;
            top: 50%;
            transform: translateY(-50%);
            font-size: 4rem;
            opacity: 0.1;
            z-index: 1;
        }

        .search-section {
            padding: 1rem 1rem;
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
        }

        .glass-card {
            background: var(--glass-bg);
            backdrop-filter: blur(15px);
            border: 1px solid var(--glass-border);
            border-radius: var(--border-radius);
            box-shadow: var(--shadow-light);
            transition: var(--transition);
            overflow: hidden;
            position: relative;
        }

        .glass-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 50%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
            transition: left 0.5s;
        }

        .glass-card:hover::before {
            left: 100%;
        }

        .glass-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.2);
        }

        .form-control {
            background: rgba(255, 255, 255, 0.9);
            border: 2px solid rgba(206, 43, 43, 0.3);
            border-radius: 15px;
            padding: 1rem 1.5rem;
            font-size: 1rem;
            transition: var(--transition);
            box-shadow: inset 0 2px 4px rgba(210, 48, 48, 0.1);
        }

        .form-control:focus {
            background: rgba(255, 255, 255, 1);
            border-color:rgb(36, 67, 201);
            box-shadow: 0 0 20px rgba(102, 126, 234, 0.3);
            transform: scale(1.02);
        }

        .btn-modern {
            background: var(--primary-gradient);
            border: none;
            border-radius: 15px;
            padding: 1rem 2rem;
            font-weight: 600;
            color: white;
            transition: var(--transition);
            position: relative;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(102, 126, 234, 0.4);
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        .btn-modern::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.3), transparent);
            transition: left 0.5s;
        }

        .btn-modern:hover::before {
            left: 100%;
        }

        .btn-modern:hover {
            transform: translateY(-3px);
            box-shadow: 0 15px 40px rgba(102, 126, 234, 0.6);
        }

        .btn-success-modern {
            background: var(--success-gradient);
            box-shadow: 0 10px 30px rgba(17, 153, 142, 0.4);
        }

        .btn-success-modern:hover {
            box-shadow: 0 15px 40px rgba(17, 153, 142, 0.6);
        }

        .info-section {
            padding: 3rem 2rem;
        }

        .info-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 2rem;
            margin-bottom: 3rem;
        }

        .info-item {
            background: rgba(255, 255, 255, 0.9);
            padding: 2rem;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            transition: var(--transition);
            position: relative;
            overflow: hidden;
        }

        .info-item::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: var(--primary-gradient);
        }

        .info-item:hover {
            transform: translateY(-5px);
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.15);
        }

        .info-label {
            font-size: 0.9rem;
            color: #666;
            font-weight: 500;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 0.5rem;
        }

        .info-value {
            font-size: 1.3rem;
            font-weight: 700;
            color: #2c3e50;
            word-break: break-word;
        }

        .data-table-section {
            padding: 2rem;
            background: rgba(255, 255, 255, 0.05);
        }

        .table-container {
            background: rgba(255, 255, 255, 0.95);
            border-radius: var(--border-radius);
            overflow: hidden;
            box-shadow: var(--shadow-heavy);
            backdrop-filter: blur(10px);
        }

        .table {
            margin: 0;
            font-size: 0.95rem;
        }

        .table thead th {
            background: var(--primary-gradient);
            color: white;
            border: none;
            padding: 1.5rem 1rem;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            position: relative;
        }

        .table thead th::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            height: 2px;
            background: var(--primary-gradient);
        }

        .table tbody td {
            padding: 1.2rem 1rem;
            border-bottom: 1px solid rgba(220, 148, 148, 0.05);
            vertical-align: middle;
            transition: var(--transition);
        }

        .table tbody tr {
            transition: var(--transition);
        }

        .table tbody tr:hover {
            background: linear-gradient(90deg, rgba(102, 126, 234, 0.1), rgba(118, 75, 162, 0.1));
            transform: scale(1.01);
        }

        .table tfoot th {
            background: var(--primary-gradient);
            color: white;
            padding: 1.5rem 1rem;
            font-weight: 700;
            border: none;
            font-size: 1.1rem;
        }

        .currency {
            font-family: 'JetBrains Mono', 'Courier New', monospace;
            font-weight: 600;
            background: linear-gradient(45deg, #667eea, #764ba2);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .badge-modern {
            background: var(--primary-gradient);
            color: white;
            padding: 0.5rem 1rem;
            border-radius: 25px;
            font-weight: 600;
            font-size: 0.85rem;
            letter-spacing: 0.5px;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
        }

        .no-data {
            text-align: center;
            padding: 5rem 2rem;
            color: rgba(255, 255, 255, 0.8);
        }

        .no-data i {
            font-size: 5rem;
            margin-bottom: 2rem;
            opacity: 0.5;
        }

        .fade-in-up {
            animation: fadeInUp 0.8s ease-out;
        }

        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .stagger-1 { animation-delay: 0.1s; }
        .stagger-2 { animation-delay: 0.2s; }
        .stagger-3 { animation-delay: 0.3s; }
        .stagger-4 { animation-delay: 0.4s; }

        @media (max-width: 768px) {
            .main-container {
                margin: 1rem;
                border-radius: 15px;
            }
            
            .page-header {
                padding: 2rem 1.5rem;
            }
            
            .page-header h1 {
                font-size: 1.8rem;
            }
            
            .search-section,
            .info-section,
            .data-table-section {
                padding: 2rem 1.5rem;
            }
            
            .info-grid {
                grid-template-columns: 1fr;
                gap: 1rem;
            }
            
            .floating-icon {
                display: none;
            }
        }

        /* Scrollbar styling */
        ::-webkit-scrollbar {
            width: 8px;
        }

        ::-webkit-scrollbar-track {
            background: rgba(255, 255, 255, 0.1);
        }

        ::-webkit-scrollbar-thumb {
            background: var(--primary-gradient);
            border-radius: 10px;
        }

        ::-webkit-scrollbar-thumb:hover {
            background: var(--dark-gradient);
        }
    </style>
</head>
<body>
    <div class="container-fluid p-0">
        <div class="main-container fade-in-up">
            <!-- Page Header -->
            <div class="page-header">
                <div class="floating-icon">
                    <i class="fas fa-credit-card"></i>
                </div>
                <h1><i class="fas fa-credit-card1 me-3"></i>Kartu Tagihan</h1>
                <p class="subtitle">MMU A-39 REJOSARI - Sistem Informasi Pembayaran</p>
            </div>

            <?php     
            error_reporting(E_ALL^(E_NOTICE|E_WARNING));
            ini_set('display_errors',1);
            error_reporting(0);
            
            require './kalenderhijriah.php';     
            $kode = $_SESSION['kode'];
            if(isset($_POST['rekening'])){
                $rekening = $_POST['rekening'];
                $tglmasehi = date('Y-m-d', strtotime($_POST['tglmasehi']));
                if($_POST['rekening'] == 'Pilih')
                    $where = "where id='0'";
                else
                    $where = "where id='$rekening'";
            } else {
                $par1 = "";
                $par2 = "";
                $rekening = "";
                $where = "where id='$rekening'";
            }
            ?>

            <!-- Search Section -->
            <div class="search-section">
                <div class="glass-card p-0 fade-in-up stagger-1">
                    <div class="p-4">
                        <h5 class="mb-4 text-white">
                            <i class="fas fa-search me-2"></i>Pencarian Data Tagihan
                        </h5>
                        <form role="form" id="quickForm" action="" method="POST">
                            <div class="row g-4">
                                <div class="col-md-3">
                                    <label class="form-label text-white">
                                        <i class="fas fa-user me-2"></i>Nomor Rekening
                                    </label>
                                    <input type="text" id="rekening" name="rekening" maxlength="16" 
                                           value="<?php echo isset($_POST['rekening']) ? $_POST['rekening'] : ''; ?>" 
                                           class="form-control" placeholder="Masukkan nomor rekening" autofocus>
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label text-white">
                                        <i class="fas fa-calendar me-2"></i>Tanggal
                                    </label>
                                    <input type="text" name="tglmasehi" id="tglmasehi" class="form-control"
                                           value="<?php echo sprintf('%02d', $hijri[1]) . '-' . $calendar->monthName($hijri[0]) . '-' . $hijri[2]; ?>">
                                </div>
                                <div class="col-md-3 d-flex align-items-end">
                                    <button type="submit" name="proses" class="btn btn-modern w-100" value="Cari">
                                        <i class="fas fa-search me-2"></i>Cari Data
                                    </button>
                                </div>
                                <?php if(isset($_POST['rekening'])): ?>
                                <div class="col-md-3 d-flex align-items-end">
                                    <a href="pdf/lap_kartu_tagihan_pdf.php" target="_blank" class="btn btn-success-modern btn-modern w-100">
                                        <i class="fas fa-file-pdf me-2"></i>Cetak PDF
                                    </a>
                                </div>
                                <?php endif; ?>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <?php
            function buatrp($angka){
                $jadi = "Rp " . number_format($angka, 0, ',', '.');
                return $jadi;
            }

            include 'koneksi.php';
            
            $querya = "SELECT tgl as tgl, nama AS nama, alamat AS alamat, rtrw as rtrw from registrasi $where";
            $query = mysqli_query($koneksi, $querya);
            
            $nama = "";
            $alamat = "";
            $rtrw = "";
            $tgl = "";
            $blokir = 0;
            $saldotab = 0;
            
            if(mysqli_num_rows($query)){
                while ($data = mysqli_fetch_assoc($query)) {
                    $tgl = $data['tgl'];
                    $nama = $data['nama'];
                    $alamat = $data['alamat'];
                    $rtrw = $data['rtrw'];
                }
            }
            
            if(isset($_POST['rekening'])){
                $_SESSION['ktagihan']['judul'] = "KARTU TAGIHAN";
                $_SESSION['ktagihan']['unit'] = "MMU A-39 REJOSARI";
                $_SESSION['ktagihan']['rekening'] = $_POST['rekening'];
                
                if($_POST['rekening'] == 'Pilih')
                    $_SESSION['laporan']['rekening'] = 'Pilih';
                else
                    $_SESSION['laporan']['rekening'] = "SELECT * FROM mutasiTAGIHAN where rekening='" . $_POST['rekening'] . "'";
            ?>

            <!-- Customer Information Section -->
            <div class="info-section fade-in-up">
                <div class="info-grid">
                    <div class="info-item fade-in-up stagger-2">
                        <div class="info-label">
                            <i class="fas fa-user me-2"></i>Nama Lengkap
                        </div>
                        <div class="info-value"><?php echo $nama; ?></div>
                    </div>
                    <div class="info-item fade-in-up stagger-3">
                        <div class="info-label">
                            <i class="fas fa-credit-card me-2"></i>Nomor Rekening
                        </div>
                        <div class="info-value"><?php echo $_POST['rekening']; ?></div>
                    </div>
                    <div class="info-item fade-in-up stagger-4">
                        <div class="info-label">
                            <i class="fas fa-map-marker-alt me-2"></i>Alamat
                        </div>
                        <div class="info-value"><?php echo $alamat . " " . $rtrw; ?></div>
                    </div>
                    
                </div>
            </div>

            <!-- Transaction Table Section -->
            <div class="data-table-section fade-in-up">
                <div class="table-container">
                    <div class="table-responsive">
                        <table id="example3" class="table table-hover mb-0">
                            <thead>
                                <tr>
                                    <th width="5%" class="text-center">No</th>
                                    <th width="12%" class="text-center">Tanggal</th>
                                    <th width="15%" class="text-center">No Bukti</th>
                                    <th width="20%" class="text-center">Tagihan</th>
                                    <th width="20%" class="text-center">Pembayaran</th>
                                    <th width="28%">Keterangan</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $no = 1;
                                $queryp = "
                                SELECT YEAR(tgl) AS tahun,MONTH(tgl) AS bulan,MONTHNAME(tgl) AS nama_bulan,DATE_FORMAT(tgl, '%Y-%m') AS periode,
                        tgl,no_bukti,id,nim,kewajiban,bayar,(kewajiban - bayar) AS sisa,keterangan,source_table
                    FROM (
                        SELECT tglmasehi AS tgl, no_bukti, id, nim, kewajiban, bayar, keterangan, 'bulanan' AS source_table
                        FROM bulanan 
                        WHERE id='$rekening' AND tglmasehi<='$tglmasehi'
                        
                        UNION ALL
                        
                        SELECT tglmasehi AS tgl, no_bukti, id, nim, kewajiban, bayar, keterangan, 'kitab' AS source_table
                        FROM kitab 
                        WHERE id='$rekening' AND tglmasehi<='$tglmasehi'
                        
                        UNION ALL
                        
                        SELECT tglmasehi AS tgl, no_bukti, id, nim, kewajiban, bayar, keterangan, 'seragam' AS source_table
                        FROM seragam 
                        WHERE id='$rekening' AND tglmasehi<='$tglmasehi'
                        
                        UNION ALL
                        
                        SELECT tglmasehi AS tgl, no_bukti, id, nim, kewajiban, bayar, keterangan, 'ikhtibar' AS source_table
                        FROM ikhtibar 
                        WHERE id='$rekening' AND tglmasehi<='$tglmasehi'
                        
                        UNION ALL
                        
                        SELECT tglmasehi AS tgl, no_bukti, id, nim, kewajiban, bayar, keterangan, 'imni' AS source_table
                        FROM imni 
                        WHERE id='$rekening' AND tglmasehi<='$tglmasehi'
                        
                        UNION ALL
                        
                        SELECT tglmasehi AS tgl, no_bukti, id, nim, kewajiban, bayar, keterangan, 'iuran' AS source_table
                        FROM iuran 
                        WHERE id='$rekening' AND tglmasehi<='$tglmasehi'
                        
                        UNION ALL
                        
                        SELECT tglmasehi AS tgl, no_bukti, id, nim, kewajiban, bayar, keterangan, 'imda1' AS source_table
                        FROM imda1 
                        WHERE id='$rekening' AND tglmasehi<='$tglmasehi'
                        UNION ALL
                        SELECT tglmasehi AS tgl, no_bukti, id, nim, kewajiban, bayar, keterangan, 'imda2' AS source_table
                        FROM imda2 
                        WHERE id='$rekening' AND tglmasehi<='$tglmasehi'
                        UNION ALL
                        SELECT tglmasehi AS tgl, no_bukti, id, nim, kewajiban, bayar, keterangan, 'imda3' AS source_table
                        FROM imda3 
                        WHERE id='$rekening' AND tglmasehi<='$tglmasehi'
                    ) AS combined_data
                    ORDER BY SUBSTR(no_bukti, 1, 2),tahun ASC, bulan ASC, tgl ASC, source_table ASC ";
                                
                                $query = mysqli_query($koneksi, $queryp);
                                $t_kwajiban = 0;
                                $t_bayar = 0;
                                
                                if(mysqli_num_rows($query)){
                                    while ($data = mysqli_fetch_assoc($query)) {
                                        $tgl = $data['tgl'];
                                        $no_bukti = $data['no_bukti'];
                                        $keterangan = $data['keterangan'];
                                        $kewajiban = $data['kewajiban'];
                                        $bayar = $data['bayar'];
                                        $t_kwajiban += $kewajiban;
                                        $t_bayar += $bayar;
                                        ?>
                                        <tr>
                                            <td class="text-center"><?php echo $no++; ?></td>
                                            <td class="text-center"><?php echo date('d/m/Y', strtotime($tgl)); ?></td>
                                            <td class="text-center">
                                                <span class="badge-modern"><?php echo $no_bukti; ?></span>
                                            </td>
                                            <td class="text-end currency"><?php echo buatrp($kewajiban); ?></td>
                                            <td class="text-end currency"><?php echo buatrp($bayar); ?></td>
                                            <td><?php echo $keterangan; ?></td>
                                        </tr>
                                        <?php
                                    }
                                } else {
                                    echo '<tr><td colspan="6" class="text-center py-5">
                                        <div class="no-data">
                                            <i class="fas fa-inbox"></i>
                                            <h5>Tidak ada data transaksi ditemukan</h5>
                                            <p>Silakan coba dengan nomor rekening atau tanggal yang berbeda</p>
                                        </div>
                                    </td></tr>';
                                }
                                ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th colspan="3" class="text-center">TOTAL</th>
                                    <th class="text-end currency"><?php echo buatrp($t_kwajiban); ?></th>
                                    <th class="text-end currency"><?php echo buatrp($t_bayar); ?></th>
                                    <th></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>

            <?php
            $_SESSION['ktagihan']['sql1'] = $querya;
            $_SESSION['ktagihan']['sql2'] = $queryp;
            } else {
            ?>
            <!-- No Data Message -->
            <div class="no-data fade-in-up">
                <i class="fas fa-search"></i>
                <h3>Cari Data Tagihan Nasabah</h3>
                <p>Masukkan nomor rekening dan tanggal untuk menampilkan riwayat transaksi pembayaran</p>
                <div class="mt-4">
                    <small class="text-white-50">
                        <i class="fas fa-info-circle me-1"></i>
                        Sistem akan mengambil data dari tabel: bulanan, kitab, seragam, ikhtibar, imni, iuran, imda1, imda2, imda3
                    </small>
                </div>
            </div>
            <?php } ?>
        </div>
    </div>

    <!-- <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script> -->
    
    <script>
        $(document).ready(function() {
            // Auto-focus on rekening input
            $('#rekening').focus();

            // Form validation
            $('#quickForm').on('submit', function(e) {
                const rekening = $('#rekening').val().trim();
                const tanggal = $('#tglmasehi').val();
                
                if (rekening === '') {
                    e.preventDefault();
                    alert('Nomor rekening harus diisi!');
                   }
                   
                   <script/>