<?php
session_start();
error_reporting(0);
include('../koneksi.php');

// Pastikan semua output adalah JSON
header('Content-Type: application/json');

try {
    // Validasi input
    if (!isset($_POST['rekening'])) {
        throw new Exception('Data rekening tidak ditemukan');
    }

    $cekrek = strlen($_POST['rekening']);
    if ($cekrek !== 13) {
        throw new Exception('Register yang diinput salah! Cek ulang registernya');
    }

    // Set variabel dasar
    $kode = $_SESSION['kode'];
    $username = $_SESSION['username'];
    $no_bukti = "PP" . $_SESSION['nokode'] . substr(date("YmdHis"), 2, 15);
    $register = $_POST['register'];
    $rekening = $_POST['rekening'];
    $tgl = date('Y-m-d', strtotime($_POST['tgl']));
    $plafond = str_replace(",", "", $_POST['plafond']);
    $jcair = $_POST['jcair'];
    $pbarang = $_POST['pbarang'];
    $jbarang = $_POST['jbarang'];
    $kelengkapan = $_POST['kelengkapan'];
    $jaminan = $_POST['jaminan'];
    $taksasi = str_replace(",", "", $_POST['taksasi']);
    $jwaktu = (int)$_POST['jwaktu'];
    $margin = $_POST['margin'];
    $noseri = $_POST['noseri'];
    $kondisi = $_POST['kondisi'];
    $keterangan = $_POST['keterangan'];
    //$otp_gadai = rand(100000, 999999);
    
    // Retrieve registrant data
    $jumlah = ($margin * $plafond / 100);
    $pesan = mysqli_fetch_assoc(mysqli_query($koneksi, "SELECT a.nama AS nama, a.nohp AS nohp FROM registrasi a LEFT JOIN pinjaman b ON a.id = b.register WHERE a.id = '$register' "));

    if (!$pesan) {
        throw new Exception('Data registrasi tidak ditemukan.');
    }

    $nohp = $pesan['nohp'];
    $nama = $pesan['nama'];
    $plafondpsn = number_format($plafond, 0);
    $barang = $jaminan;
    $judul = "*PENCAIRAN GADAI*";
    $tglpsn = $tgl;
    $metodebayar = "angsur";
    $jmlangsuran = number_format($jumlah, 0);
    $kantor = "*TOP GADAI " . strtoupper($_SESSION['kantor']) . "*";
    $rekeningpesan = $rekening;
    $hasilket = preg_replace('/104.*$/', '', $keterangan);
    $keteranganpesan = trim($hasilket);


// Cek apakah transaksi sudah ada
    $check_query = mysqli_query($koneksi, "SELECT * FROM pinjaman WHERE no_bukti='$no_bukti'");
    if (mysqli_num_rows($check_query) > 0) {
        throw new Exception('Transaksi dengan no_bukti ini sudah ada. Tidak dapat melakukan double transaksi.');
    }
    // Cek apakah transaksi sudah ada
 mysqli_begin_transaction($koneksi);

    // Persiapkan semua statement
    $stmt_pinjaman = mysqli_prepare($koneksi, "INSERT INTO pinjaman (register, rekening, no_bukti, tgl, plafond, jeniscair, barang, jenisbarang, kelengkapan, jaminan, taksasi, jangkawaktu, flat, margin, noseri, kondisi, bakidebet, keterangan, username) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 0, ?, ?, ?, ?, ?, ?)");
    
    mysqli_stmt_bind_param($stmt_pinjaman, "ssssdssssssddssdss", 
        $register, $rekening, $no_bukti, $tgl, $plafond, $jcair, $pbarang, $jbarang, 
        $kelengkapan, $jaminan, $taksasi, $jwaktu, $margin, $noseri, $kondisi, 
        $plafond, $keterangan, $username
    );
    
    if (!mysqli_stmt_execute($stmt_pinjaman)) {
        throw new Exception(mysqli_stmt_error($stmt_pinjaman));
    }
    mysqli_stmt_close($stmt_pinjaman);

    // Query angsuran
    $stmt_angsuran = mysqli_prepare($koneksi, "INSERT INTO angsuran (rekening, no_bukti, tgl, plafond, pokok, margin, keterangan, username) VALUES (?, ?, ?, ?, 0, 0, ?, ?)");
    
    mysqli_stmt_bind_param($stmt_angsuran, "sssdss", 
        $rekening, $no_bukti, $tgl, $plafond, $keterangan, $username
    );
    
    if (!mysqli_stmt_execute($stmt_angsuran)) {
        throw new Exception(mysqli_stmt_error($stmt_angsuran));
    }
    mysqli_stmt_close($stmt_angsuran);

    // Query buku besar debet
    $stmt_bukubesar_debet = mysqli_prepare($koneksi, "INSERT INTO bukubesar (id_jurnal, no_bukti, tanggal, kode_akun, debet, kredit, keterangan, kode, tglsystem, username) VALUES (0, ?, ?, '1.120.10', ?, 0, ?, ?, NOW(), ?)");
    
    mysqli_stmt_bind_param($stmt_bukubesar_debet, "ssdsss", 
        $no_bukti, $tgl, $plafond, $keterangan, $kode, $username
    );
    
    if (!mysqli_stmt_execute($stmt_bukubesar_debet)) {
        throw new Exception(mysqli_stmt_error($stmt_bukubesar_debet));
    }
    mysqli_stmt_close($stmt_bukubesar_debet);

    // Query buku besar kredit
    $stmt_bukubesar_kredit = mysqli_prepare($koneksi, "INSERT INTO bukubesar (id_jurnal, no_bukti, tanggal, kode_akun, debet, kredit, keterangan, kode, tglsystem, username) VALUES (0, ?, ?, '1.100.10', 0, ?, ?, ?, NOW(), ?)");
    
    mysqli_stmt_bind_param($stmt_bukubesar_kredit, "ssdsss", 
        $no_bukti, $tgl, $plafond, $keterangan, $kode, $username
    );
    
    if (!mysqli_stmt_execute($stmt_bukubesar_kredit)) {
        throw new Exception(mysqli_stmt_error($stmt_bukubesar_kredit));
    }
    mysqli_stmt_close($stmt_bukubesar_kredit);
   
// Update jatuh tempo
    $jtempo = mysqli_fetch_assoc(mysqli_query($koneksi, "SELECT rekening, DATE_ADD('$tgl', INTERVAL $jwaktu DAY) AS jtempo2 FROM pinjaman WHERE rekening='$rekening'"));
    
    if (!$jtempo) {
        throw new Exception("Gagal menghitung tanggal jatuh tempo");
    }

    $update_jtempo = mysqli_query($koneksi, "UPDATE pinjaman SET jtempo='{$jtempo['jtempo2']}' WHERE rekening='$rekening'");
    
    if (!$update_jtempo) {
        throw new Exception(mysqli_error($koneksi));
    }
    // Query untuk memasukkan pesan
    $query6 = mysqli_query($koneksi, "INSERT INTO message SET 
        number='$nohp',
        tgl='$tglpsn',
        judul='$judul', 
        penErima='$nama', 
        PenGirim='$kantor', 
        rekening='$rekeningpesan',
        barangGadai='$barang',
        plafond='$plafondpsn', 
        nominal='$jmlangsuran', 
        keterangan='$keteranganpesan', 
        metodeBayar='$metodebayar',
        kodeFilTer='cair'
    ");

    if (!$query6) {
        throw new Exception(mysqli_error($koneksi));
    }
   
    // Commit transaksi
    mysqli_commit($koneksi);

    // Return success response
    echo json_encode([
        'success' => true,
        'message' => 'Data berhasil disimpan',
        'no_bukti' => $no_bukti
    ]);

} catch (Exception $e) {
    // Rollback transaksi jika ada error
    mysqli_rollback($koneksi);
    
    // Return error response
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>
