<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Modern Sidebar Navigation</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }

        .sidebar {
            width: 280px;
            height: 100vh;
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            border-right: 1px solid rgba(255, 255, 255, 0.2);
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            position: fixed;
            left: 0;
            top: 0;
            overflow-y: auto;
            transition: all 0.3s ease;
        }

        .sidebar::-webkit-scrollbar {
            width: 6px;
        }

        .sidebar::-webkit-scrollbar-track {
            background: rgba(0, 0, 0, 0.05);
        }

        .sidebar::-webkit-scrollbar-thumb {
            background: rgba(0, 0, 0, 0.2);
            border-radius: 3px;
        }

        .sidebar-header {
            padding: 25px 20px;
            text-align: center;
            border-bottom: 1px solid rgba(0, 0, 0, 0.1);
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }

        .sidebar-header h2 {
            font-size: 20px;
            font-weight: 600;
            margin-bottom: 5px;
        }

        .sidebar-header p {
            font-size: 12px;
            opacity: 0.8;
        }

        .nav {
            list-style: none;
            padding: 15px 0;
        }

        .nav-item {
            margin: 2px 12px;
        }

        .nav-link {
            display: flex;
            align-items: center;
            padding: 12px 20px;
            color: #4a5568;
            text-decoration: none;
            border-radius: 12px;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            font-weight: 500;
            font-size: 14px;
        }

        .nav-link:hover {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            transform: translateX(5px);
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
        }

        .nav-link.active {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
        }

        .nav-icon {
            width: 20px;
            height: 20px;
            margin-right: 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 16px;
        }

        .nav-link p {
            margin: 0;
            flex: 1;
        }

        .nav-arrow {
            transition: transform 0.3s ease;
            font-size: 12px;
        }

        .has-treeview.menu-open .nav-arrow {
            transform: rotate(-90deg);
        }

        .nav-treeview {
            list-style: none;
            padding: 0;
            margin: 8px 0 0 0;
            max-height: 0;
            overflow: hidden;
            transition: all 0.3s ease;
        }

        .has-treeview.menu-open .nav-treeview {
            max-height: 500px;
        }

        .nav-treeview .nav-item {
            margin: 1px 0;
        }

        .nav-treeview .nav-link {
            padding: 10px 20px 10px 55px;
            font-size: 13px;
            background: rgba(0, 0, 0, 0.02);
            border-radius: 8px;
            position: relative;
        }

        .nav-treeview .nav-link::before {
            content: '';
            position: absolute;
            left: 35px;
            top: 50%;
            width: 6px;
            height: 6px;
            background: #cbd5e0;
            border-radius: 50%;
            transform: translateY(-50%);
            transition: all 0.3s ease;
        }

        .nav-treeview .nav-link:hover::before {
            background: white;
            transform: translateY(-50%) scale(1.3);
        }

        .nav-treeview .nav-link:hover {
            background: linear-gradient(135deg, rgba(102, 126, 234, 0.8) 0%, rgba(118, 75, 162, 0.8) 100%);
            transform: translateX(8px);
        }

        .section-divider {
            height: 1px;
            background: linear-gradient(90deg, transparent, rgba(0, 0, 0, 0.1), transparent);
            margin: 20px 15px 15px 15px;
        }

        .nav-section-title {
            padding: 15px 20px 5px 20px;
            font-size: 11px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
            color: #a0aec0;
        }

        .privilege-badge {
            background: linear-gradient(135deg, #ff6b6b, #ee5a52);
            color: white;
            font-size: 10px;
            padding: 2px 8px;
            border-radius: 10px;
            margin-left: 8px;
            font-weight: 600;
        }

        @media (max-width: 768px) {
            .sidebar {
                width: 100%;
                transform: translateX(-100%);
            }
            
            .sidebar.open {
                transform: translateX(0);
            }
        }

        .content-area {
            margin-left: 280px;
            padding: 20px;
            color: white;
        }

        @media (max-width: 768px) {
            .content-area {
                margin-left: 0;
            }
        }

        .menu-toggle {
            display: none;
            position: fixed;
            top: 20px;
            left: 20px;
            z-index: 1000;
            background: white;
            border: none;
            padding: 10px;
            border-radius: 8px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        }

        @media (max-width: 768px) {
            .menu-toggle {
                display: block;
            }
        }
    </style>
</head>
<body>
    <button class="menu-toggle" onclick="toggleSidebar()">
        <i class="fas fa-bars"></i>
    </button>

    <nav class="sidebar" id="sidebar">
        <div class="sidebar-header">
            <h2><i class="fas fa-graduation-cap"></i> Sistem Sekolah</h2>
            <p>Management System</p>
        </div>

        <ul class="nav">
            <!-- Pencarian Section -->
            <li class="nav-section-title">Pencarian Data</li>
            <li class="nav-item has-treeview">
                <a href="#" class="nav-link" onclick="toggleSubmenu(this)">
                    <i class="nav-icon fas fa-search"></i>
                    <p>Pencarian</p>
                    <i class="nav-arrow fas fa-chevron-right"></i>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="home.php?home=<?php echo md5('cariregister');?>" class="nav-link">
                            <i class="fas fa-user-graduate nav-icon"></i>
                            <p>Cari Murid</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="home.php?home=<?php echo md5('caripenabung');?>" class="nav-link">
                            <i class="fas fa-piggy-bank nav-icon"></i>
                            <p>Cari Penabung</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="home.php?home=<?php echo md5('cariprofile');?>" class="nav-link">
                            <i class="fas fa-id-card nav-icon"></i>
                            <p>Cari Profile</p>
                        </a>
                    </li>
                </ul>
            </li>

            <div class="section-divider"></div>

            <!-- Setup Section -->
            <li class="nav-section-title">Konfigurasi</li>
            <li class="nav-item has-treeview">
                <a href="#" class="nav-link" onclick="toggleSubmenu(this)">
                    <i class="nav-icon fas fa-cogs"></i>
                    <p>Setup</p>
                    <i class="nav-arrow fas fa-chevron-right"></i>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="home.php?home=<?php echo md5('master_kenaikan_kls');?>" class="nav-link">
                            <i class="fas fa-level-up-alt nav-icon"></i>
                            <p>Kenaikan Kelas</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="home.php?home=<?php echo md5('master_syahriah_murid');?>" class="nav-link">
                            <i class="fas fa-receipt nav-icon"></i>
                            <p>Tagihan Syahriah</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="home.php?home=<?php echo md5('master_nonSyahriah_murid');?>" class="nav-link">
                            <i class="fas fa-file-invoice nav-icon"></i>
                            <p>Tagihan Non Syahriah</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="home.php?home=<?php echo md5('master_bukutabungan_murid');?>" class="nav-link">
                            <i class="fas fa-book nav-icon"></i>
                            <p>Buku Tabungan</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="home.php?home=<?php echo md5('userlogin');?>" class="nav-link">
                            <i class="fas fa-users-cog nav-icon"></i>
                            <p>User Login</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="home.php?home=<?php echo md5('buatalamat');?>" class="nav-link">
                            <i class="fas fa-map-marker-alt nav-icon"></i>
                            <p>Master Alamat</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="home.php?home=<?php echo md5('kode_akun');?>" class="nav-link">
                            <i class="fas fa-list-alt nav-icon"></i>
                            <p>Nama Akun</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="home.php?home=<?php echo md5('bukutabungan');?>" class="nav-link">
                            <i class="fas fa-book-open nav-icon"></i>
                            <p>Buku Tabungan Non Murid</p>
                        </a>
                    </li>
                </ul>
            </li>

            <div class="section-divider"></div>

            <!-- Transaksi Section -->
            <li class="nav-section-title">Transaksi</li>
            <li class="nav-item has-treeview">
                <a href="#" class="nav-link" onclick="toggleSubmenu(this)">
                    <i class="nav-icon fas fa-exchange-alt"></i>
                    <p>Transaksi</p>
                    <i class="nav-arrow fas fa-chevron-right"></i>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="home.php?home=<?php echo md5('tabungan');?>" class="nav-link">
                            <i class="fas fa-piggy-bank nav-icon"></i>
                            <p>Tabungan</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="home.php?home=<?php echo md5('tabungan_scan');?>" class="nav-link">
                            <i class="fas fa-qrcode nav-icon"></i>
                            <p>Tabungan Scan</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="home.php?home=<?php echo md5('pembayaran_Syahriah');?>" class="nav-link">
                            <i class="fas fa-money-bill-wave nav-icon"></i>
                            <p>Syahriah</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="home.php?home=<?php echo md5('pembayaran_Syahriah_scan');?>" class="nav-link">
                            <i class="fas fa-mobile-alt nav-icon"></i>
                            <p>Syahriah Scan</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="home.php?home=<?php echo md5('pembayaran_nonSyahriah');?>" class="nav-link">
                            <i class="fas fa-credit-card nav-icon"></i>
                            <p>Non Syahriah</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="home.php?home=<?php echo md5('registrasi');?>" class="nav-link">
                            <i class="fas fa-user-plus nav-icon"></i>
                            <p>Registrasi</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="home.php?home=<?php echo md5('registrasi_umum');?>" class="nav-link">
                            <i class="fas fa-users nav-icon"></i>
                            <p>Registrasi Umum</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="home.php?home=<?php echo md5('inputjurnal');?>" class="nav-link">
                            <i class="fas fa-journal-whills nav-icon"></i>
                            <p>Jurnal</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="home.php?home=<?php echo md5('kM');?>" class="nav-link">
                            <i class="fas fa-arrow-circle-down nav-icon"></i>
                            <p>Kas Masuk</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="home.php?home=<?php echo md5('kK');?>" class="nav-link">
                            <i class="fas fa-arrow-circle-up nav-icon"></i>
                            <p>Kas Keluar</p>
                        </a>
                    </li>
                </ul>
            </li>

            <!-- Admin Only Section -->
            <div id="adminSection" style="display: none;">
                <div class="section-divider"></div>
                <li class="nav-section-title">
                    Administrator 
                    <span class="privilege-badge">ADMIN</span>
                </li>
                <li class="nav-item">
                    <a href="home.php?home=<?php echo md5('editjurnal');?>" class="nav-link">
                        <i class="fas fa-edit nav-icon"></i>
                        <p>Edit Jurnal</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="home.php?home=<?php echo md5('deletjurnal');?>" class="nav-link">
                        <i class="fas fa-trash nav-icon"></i>
                        <p>Hapus Jurnal</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="home.php?home=<?php echo md5('edit_mutasitabungan');?>" class="nav-link">
                        <i class="fas fa-edit nav-icon"></i>
                        <p>Edit Tabungan</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="home.php?home=<?php echo md5('delete_mutasitabungan');?>" class="nav-link">
                        <i class="fas fa-trash nav-icon"></i>
                        <p>Hapus Tabungan</p>
                    </a>
                </li>
            </div>

            <div class="section-divider"></div>

            <!-- Laporan Section -->
            <li class="nav-section-title">Pelaporan</li>
            <li class="nav-item has-treeview">
                <a href="#" class="nav-link" onclick="toggleSubmenu(this)">
                    <i class="nav-icon fas fa-chart-bar"></i>
                    <p>Laporan</p>
                    <i class="nav-arrow fas fa-chevron-right"></i>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="home.php?home=<?php echo md5('mutasi_tabungan');?>" class="nav-link">
                            <i class="fas fa-exchange-alt nav-icon"></i>
                            <p>Mutasi Tabungan</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="home.php?home=<?php echo md5('rekap_saldo_tabungan');?>" class="nav-link">
                            <i class="fas fa-calculator nav-icon"></i>
                            <p>Rekap Tabungan</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="home.php?home=<?php echo md5('lapbayar_syahriah');?>" class="nav-link">
                            <i class="fas fa-file-invoice-dollar nav-icon"></i>
                            <p>Laporan Syahriah</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="home.php?home=<?php echo md5('lapbayar_nonsyahriah');?>" class="nav-link">
                            <i class="fas fa-file-alt nav-icon"></i>
                            <p>Laporan Non Syahriah</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="home.php?home=<?php echo md5('kartu_tagihan');?>" class="nav-link">
                            <i class="fas fa-id-badge nav-icon"></i>
                            <p>Kartu Tagihan</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="home.php?home=<?php echo md5('kartu_tabungan');?>" class="nav-link">
                            <i class="fas fa-credit-card nav-icon"></i>
                            <p>Kartu Tabungan</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="home.php?home=<?php echo md5('backup_database');?>" class="nav-link">
                            <i class="fas fa-database nav-icon"></i>
                            <p>Backup Database</p>
                        </a>
                    </li>
                </ul>
            </li>

            <div class="section-divider"></div>

            <!-- Akuntansi Section -->
            <li class="nav-section-title">Keuangan</li>
            <li class="nav-item has-treeview">
                <a href="#" class="nav-link" onclick="toggleSubmenu(this)">
                    <i class="nav-icon fas fa-calculator"></i>
                    <p>Akuntansi</p>
                    <i class="nav-arrow fas fa-chevron-right"></i>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="home.php?home=<?php echo md5('lapkodeakun');?>" class="nav-link">
                            <i class="fas fa-list nav-icon"></i>
                            <p>COA [Nama Akun]</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="home.php?home=<?php echo md5('jurnal_umum');?>" class="nav-link">
                            <i class="fas fa-book nav-icon"></i>
                            <p>Jurnal Umum</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="home.php?home=<?php echo md5('buku_besar');?>" class="nav-link">
                            <i class="fas fa-book-open nav-icon"></i>
                            <p>Buku Besar</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="home.php?home=<?php echo md5('lap_arus_kas');?>" class="nav-link">
                            <i class="fas fa-coins nav-icon"></i>
                            <p>Arus Kas</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="home.php?home=<?php echo md5('labarugi');?>" class="nav-link">
                            <i class="fas fa-chart-line nav-icon"></i>
                            <p>Penerimaan Dana</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="home.php?home=<?php echo md5('neraca');?>" class="nav-link">
                            <i class="fas fa-balance-scale nav-icon"></i>
                            <p>Neraca</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="home.php?home=<?php echo md5('lap_rekap');?>" class="nav-link">
                            <i class="fas fa-calendar-day nav-icon"></i>
                            <p>Rekap Harian</p>
                        </a>
                    </li>
                </ul>
            </li>
        </ul>
    </nav>

    <div class="content-area">
        <h1>Selamat Datang di Sistem Management Sekolah</h1>
        <p>Sidebar navigation telah diperbaiki dengan desain modern dan elegan.</p>
    </div>

    <script>
        function toggleSubmenu(element) {
            const parent = element.parentElement;
            const isOpen = parent.classList.contains('menu-open');
            
            // Close all open submenus
            document.querySelectorAll('.has-treeview.menu-open').forEach(item => {
                item.classList.remove('menu-open');
            });
            
            // Toggle current submenu
            if (!isOpen) {
                parent.classList.add('menu-open');
            }
        }

        function toggleSidebar() {
            const sidebar = document.getElementById('sidebar');
            sidebar.classList.toggle('open');
        }

        // Simulate user level check (replace with actual PHP session check)
        const userLevel = '100'; // Change this to test different levels
        
        if (userLevel === '100') {
            document.getElementById('adminSection').style.display = 'block';
        }

        // Close sidebar on mobile when clicking outside
        document.addEventListener('click', function(event) {
            const sidebar = document.getElementById('sidebar');
            const toggle = document.querySelector('.menu-toggle');
            
            if (window.innerWidth <= 768 && 
                !sidebar.contains(event.target) && 
                !toggle.contains(event.target) &&
                sidebar.classList.contains('open')) {
                sidebar.classList.remove('open');
            }
        });

        // Handle active states
        document.querySelectorAll('.nav-link').forEach(link => {
            link.addEventListener('click', function(e) {
                if (!this.closest('.has-treeview')) {
                    // Remove active class from all links
                    document.querySelectorAll('.nav-link').forEach(l => l.classList.remove('active'));
                    // Add active class to clicked link
                    this.classList.add('active');
                }
            });
        });
    </script>
</body>
</html>