<?php
session_start();
error_reporting(0);

// Load konfigurasi database
include_once '../koneksi.php';

// Pastikan variabel $querybt sudah didefinisikan sebelumnya sesuai kebutuhan Anda
// Contoh: $querybt = "SELECT * FROM tabel_yang_dipilih"; 

// Include library untuk generate Excel
require_once '../exportexcell/PhpXlsxGenerator.php';

// Nama file untuk diunduh
$fileName = "Data Tagihan Non Syahriah Murid MMU-A39" . date('Y-m-d') . ".xlsx";

// Mengambil data dari session jika diperlukan
$querybt = isset( $_SESSION['bayar_syahriah']['kode']['sqlbyr']) ?  $_SESSION['bayar_syahriah']['kode']['sqlbyr'] : array();
$BulanH = [
  "10" => "Syawal",
  "11" => "Dz. Qodah",
  "12" => "Dz Hijjah",
  "01" =>  "Muharram",
  "02"=>  "Shafar",
  "03" => "R. Awal",
  "04" => "R. Tsani",
  "05" => "J. Ula",
  "06" => "J. Tsani",
  "07" => "Rajab",
  "08" => "Sy`aban",
  "09" => "Ramadhan", // Menambahkan bulan September yang hilang
];
// Mendefinisikan header kolom
$excelData = array(
    array('ID','NIM', 'Tahun', 'Bulan', 'Nama', 'Tagihan', 'Bayar', 'Kelas', 'Keterangan')
);

// Pastikan variabel $querybt sudah didefinisikan dan memiliki query SQL yang valid
$query = $koneksi->query($querybt);

if ($query && $query->num_rows > 0) {
    while ($row = $query->fetch_assoc()) {
        $lineData = array(
            $row['id'] ?? '',
            $row['nim'] ?? '',
            $row['tahun'] ?? '',
            $BulanH[$row['bulan']] ?? '',
            $row['nama'] ?? '',
            $row['kewajiban'] ?? 0,
            $row['bayar'] ?? 0,
            $row['no_kls'] ?? '',
            $row['keterangan'] ?? '',
        );
        $excelData[] = $lineData;
    }
}

// Membuat file Excel dari data array
$xlsx = \CodexWorld\PhpXlsxGenerator::fromArray($excelData);

// Mengunduh file Excel
$xlsx->downloadAs($fileName);

exit;
?>
