<?php
 error_reporting(E_ALL^(E_NOTICE|E_WARNING));
ini_set('display_errors',1);
error_reporting(0); 
require './kalenderhijriah.php';
?>

<!-- Custom Styles -->
<style>
.Korksi_financial-report {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    min-height: 100vh;
    padding: 20px 0;
}

.report-card {
    background: #fff;
    border-radius: 20px;
    box-shadow: 0 20px 40px rgba(0,0,0,0.1);
    overflow: hidden;
    margin-bottom: 30px;
}

.report-header {
    background: linear-gradient(135deg, #2c3e50 0%, #3498db 100%);
    color: white;
    padding: 25px 30px;
    position: relative;
    overflow: hidden;
}

.report-header::before {
    content: '';
    position: absolute;
    top: -50%;
    right: -50%;
    width: 200%;
    height: 200%;
    background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
    transform: rotate(45deg);
}

.report-title {
    font-size: 1.8rem;
    font-weight: 700;
    margin: 0;
    position: relative;
    z-index: 2;
}

.date-filter-section {
    background: #f8f9fa;
    padding: 25px 30px;
    border-bottom: 3px solid #e3f2fd;
}

.date-picker-container {
    background: white;
    border-radius: 12px;
    padding: 20px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.05);
    margin-bottom: 20px;
}

.date-input-group {
    position: relative;
    display: inline-block;
    margin-right: 20px;
}

.date-input {
    border: 2px solid #e1e8ed;
    border-radius: 8px;
    padding: 12px 40px 12px 15px;
    font-size: 14px;
    font-weight: 500;
    transition: all 0.3s ease;
    width: 150px;
    height: 44px;
}

.date-input:focus {
    border-color: #3498db;
    box-shadow: 0 0 0 3px rgba(52, 152, 219, 0.1);
    outline: none;
}

.date-icon {
    position: absolute;
    right: 12px;
    top: 50%;
    transform: translateY(-50%);
    cursor: pointer;
    transition: all 0.3s ease;
    width: 20px;
    height: 20px;
    opacity: 0.7;
}

.date-icon:hover {
    transform: translateY(-50%) scale(1.1);
    opacity: 1;
}

.preview-btn {
    background: linear-gradient(135deg, #27ae60 0%, #2ecc71 100%);
    border: none;
    border-radius: 8px;
    padding: 12px 25px;
    color: white;
    font-weight: 600;
    transition: all 0.3s ease;
    box-shadow: 0 4px 12px rgba(46, 204, 113, 0.3);
    height: 44px;
}

.preview-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(46, 204, 113, 0.4);
}

.financial-table {
    margin: 0;
    border-collapse: separate;
    border-spacing: 0;
    border-radius: 12px;
    overflow: hidden;
    box-shadow: 0 4px 12px rgba(0,0,0,0.05);
}

.financial-table thead {
    background: linear-gradient(135deg, #34495e 0%, #2c3e50 100%);
    color: white;
}

.financial-table th {
    padding: 18px 15px;
    font-weight: 600;
    text-transform: uppercase;
    font-size: 12px;
    letter-spacing: 0.5px;
    border: none;
    
}

.financial-table td {
    padding: 15px;
    border-bottom: 1px solid #f1f3f5;
    vertical-align: middle;
    transition: background-color 0.3s ease;
    

}

.financial-table tbody tr:hover {
    background-color: #f8f9fa;
}

.section-header {
    background: linear-gradient(135deg, #8e44ad 0%, #9b59b6 100%);
    color: white;
    font-weight: 700;
    padding: 15px;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.section-income .section-header {
    background: linear-gradient(135deg, #27ae60 0%, #2ecc71 100%);
}

.section-expense .section-header {
    background: linear-gradient(135deg, #e74c3c 0%, #c0392b 100%);
}

.group-header {
    background: linear-gradient(135deg, #3498db 0%, #2980b9 100%);
    color: white;
    font-weight: 600;
    padding: 12px 15px;
    font-size: 0.9em;
}

.group-total {
   /* background: linear-gradient(135deg,rgb(69, 224, 235) 0%, #7f8c8d 100%);*/
    color: black;
    font-weight: 600;
    font-style: italic;

    
}

.total-row {
    background: linear-gradient(135deg, #ecf0f1 0%, #bdc3c7 100%);
    font-weight: 700;
    color: #2c3e50;
}

.profit-row {
    background: linear-gradient(135deg, #f39c12 0%, #e67e22 100%);
    color: white;
    font-weight: 700;
    font-size: 1.1em;
}

.amount {
    font-family: 'Monaco', 'Menlo', monospace;
    font-weight: 600;
    text-align: right;
}

.positive-amount {
    color: #27ae60;
    text-align: right;
}

.negative-amount {
    color: #e74c3c;
    text-align: right;
}

.pdf-download {
    background: linear-gradient(135deg, #e74c3c 0%, #c0392b 100%);
    border: none;
    border-radius: 8px;
    padding: 12px 25px;
    color: white;
    font-weight: 600;
    text-decoration: none;
    display: inline-block;
    transition: all 0.3s ease;
    box-shadow: 0 4px 12px rgba(231, 76, 60, 0.3);
    margin-top: 20px;
}

.pdf-download:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(231, 76, 60, 0.4);
    color: white;
    text-decoration: none;
}

.report-footer {
    background: #2c3e50;
    color: white;
    text-align: center;
    padding: 20px;
    font-weight: 600;
    letter-spacing: 1px;
}

.datepicker {
    position: absolute !important;
    z-index: 1000 !important;
    border-radius: 12px !important;
    box-shadow: 0 10px 30px rgba(0,0,0,0.2) !important;
    border: none !important;
}

@media (max-width: 768px) {
    .date-input-group {
        display: block;
        margin-bottom: 15px;
        margin-right: 0;
    }
    
    .date-input {
        width: 100%;
    }
    
    .financial-table {
        font-size: 12px;
    }
    
    .financial-table th,
    .financial-table td {
        padding: 10px 8px;
    }
    
    .date-icon {
        width: 18px;
        height: 18px;
    }
}
</style>

<!-- Content Header -->
<div class="financial-report">
    <div class="container-fluid">
        <div class="row justify-content-center">
            <div class="col-xl-10 col-lg-11 col-md-12">
                <!-- Main Report Card -->
                <div class="report-card">
                    <div class="report-header">
                        <h1 class="report-title">
                            <i class="fas fa-chart-line me-3"></i>
                            Laporan Penerimaan & Pengeluaran
                        </h1>
                        <p class="mb-0 mt-2 opacity-75">Hasil Laporan Periode Berjalan</p>
                    </div>

                    <!-- Date Filter Section -->
                    <div class="date-filter-section">
                        <?php
                        $kode=$_SESSION['kode'];
                        if(isset($_POST['par1'])){
                          $par1 = isset($_POST['par1']) ? date('Y-m-d',strtotime($_POST['par1'])) : "";
                          $par2 = isset($_POST['par2']) ? date('Y-m-d',strtotime($_POST['par2'])) : "";
                           
                        }else{
                            $par1="";
                            $par2="";
                        }
                        ?>
                        
                        <div class="date-picker-container">
                            <form action="home.php?home=<?php echo md5("labarugi");?>" method="post">
                                <div class="row align-items-center">
                                    <div class="col-md-8">
                                        <div class="d-flex flex-wrap align-items-center">
                                            <label class="form-label me-3 mb-0 fw-bold">Periode:</label>
                                            
                                            <div class="date-input-group" id="datepicker1">
                                                <input id="par1" name="par1" type="text" class="form-control date-input" 
                                                       value="<?php if(isset($_POST['par1'])){ echo $_POST['par1']; }else{ echo sprintf('%02d', $hijri[1]) . '-' . $calendar->monthName($hijri[0]) . '-' . $hijri[2];} ?>" 
                                                       placeholder="Tanggal Mulai"  />
                                                <img class="date-icon" src="kalender.png" alt="Pick Date"  onclick="pickADate1();" />
                                                <div id="calendar-popup1" class="datepicker" style="display:none;"></div>
                                            </div>

                                            <span class="mx-2 fw-bold text-muted">sampai</span>

                                            <div class="date-input-group" id="datepicker2">
                                                <input id="par2" name="par2" type="text" class="form-control date-input" 
                                                       value="<?php if(isset($_POST['par2'])){ echo $_POST['par2']; }else{ echo sprintf('%02d', $hijri[1]) . '-' . $calendar->monthName($hijri[0]) . '-' . $hijri[2];} ?>" 
                                                       placeholder="Tanggal Akhir"  />
                                                <img class="date-icon" src="kalender.png" alt="Pick Date" onclick="pickADate2();" />
                                                <div id="calendar-popup2" class="datepicker" style="display:none;"></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4 text-end">
                                        <button type="submit" name="proses" class="preview-btn">
                                            <i class="fas fa-search me-2"></i>Tampilkan Laporan
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <!-- Report Content -->
                    <div class="p-4">
                        <?php if(isset($_POST['par1'])){ ?>
                            
                            <!-- Income Section -->
                            <div class="section-income mb-4">
                                <table class="table financial-table">
                                    <thead>
                                        <tr class="section-header">
                                            <th colspan="5">
                                                <i class="fas fa-arrow-up me-2"></i>PENERIMAAN
                                            </th>
                                        </tr>
                                        <tr>
                                            <th style="width: 15%">Kode</th>
                                            <th style="width: 40%">Nama Akun</th>
                                            <th style="width: 15%; text-align: center">
                                                <?php echo date('d M Y', strtotime('-1 days', strtotime($_POST['par1'])));?>
                                            </th>
                                            <th style="width: 15%; text-align: center">Mutasi</th>
                                            <th style="width: 15%; text-align: center">
                                                <?php echo date('d M Y',strtotime($_POST['par2']));?>
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        include 'koneksi.php';
                                        
                                        // Definisi kelompok penerimaan
                                        $income_groups = array(
                                            '4.400' => 'DANSOS',
                                            '4.410' => 'Bisnis IASS',
                                            '4.420' => 'Bonus',
                                            '4.430' => 'Keuntungan',
                                            '4.450' => 'Lain-lain',
                                            '4.460' => 'PW'
                                        );
                                        
                                        $grand_saldoAwal = 0;
                                        $grand_mutasi = 0;
                                        $grand_saldoAkhir = 0;
                                        
                                        foreach($income_groups as $group_code => $group_name) {
                                            // Query untuk setiap kelompok
                                            $queryl1 = "SELECT tanggal AS tanggal,kode_akun AS kode_akun,kode_akun.n_akun AS nama_akun,saldo.saldoAwal AS saldoAwal,SUM(kredit - debet)-saldo.saldoAwal AS mutasi,SUM(kredit - debet) AS saldoAkhir 
                                                       FROM bukubesar 
                                                       LEFT JOIN (SELECT kode_akun AS kode2,SUM(kredit - debet) AS saldoAwal FROM bukubesar WHERE tanggal <'$par1' and bukubesar.kode='$kode' and kode_akun LIKE '$group_code%' GROUP BY kode_akun) AS saldo ON bukubesar.kode_akun = saldo.kode2 
                                                       LEFT JOIN (SELECT n_akun,k_akun FROM kode_akun)AS kode_akun ON bukubesar.kode_akun=kode_akun.k_akun 
                                                       WHERE bukubesar.tanggal <='$par2' and bukubesar.kode='$kode' and bukubesar.kode_akun LIKE '$group_code%' 
                                                       GROUP BY kode_akun 
                                                       HAVING saldoAkhir<>0 
                                                       ORDER BY kode_akun";
                                            
                                            $resultz = mysqli_query($koneksi, $queryl1);
                                            $row_count = mysqli_num_rows($resultz);
                                            
                                            if ($row_count > 0) {
                                                // Header kelompok
                                                ?>
                                                <tr>
                                                    <td colspan="5" class="group-header">
                                                        <i class="fas faB-folder-open me-2"></i><?php echo $group_name; ?>
                                                    </td>
                                                </tr>
                                                <?php
                                                
                                                $group_saldoAwal = 0;
                                                $group_mutasi = 0;
                                                $group_saldoAkhir = 0;
                                                
                                                while ($datal = mysqli_fetch_assoc($resultz)) {
                                                    $group_saldoAwal += $datal['saldoAwal'];
                                                    $group_mutasi += $datal['mutasi'];
                                                    $group_saldoAkhir += $datal['saldoAkhir'];
                                                    ?>
                                                    <tr>
                                                        <td class="fw-bold" style="padding-left: 25px;"><?php echo $datal['kode_akun']; ?></td>
                                                        <td style="padding-left: 25px;"><?php echo $datal['nama_akun']; ?></td>
                                                        <td class="text-end amount positive-amount">
                                                            <?php echo number_format($datal['saldoAwal'],0); ?>
                                                        </td>
                                                        <td class="text-end amount positive-amount">
                                                            <?php echo number_format($datal['mutasi'],0); ?>
                                                        </td>
                                                        <td class="text-end amount positive-amount">
                                                            <?php echo number_format($datal['saldoAkhir'],0); ?>
                                                        </td>
                                                    </tr>
                                                    <?php 
                                                }
                                                
                                                // Subtotal kelompok
                                                ?>
                                                <tr class="group-total">
                                                    <td colspan="2" class="fw-bold" style="padding-left: 25px;">
                                                        <i class="fas faB-plus-circle me-2"></i>Jumlah <?php echo $group_name; ?>
                                                    </td>
                                                    <td class="text-end amount fw-bold">
                                                        <?php echo number_format($group_saldoAwal,0); ?>
                                                    </td>
                                                    <td class="text-end amount fw-bold">
                                                        <?php echo number_format($group_mutasi,0); ?>
                                                    </td>
                                                    <td class="text-end amount fw-bold">
                                                        <?php echo number_format($group_saldoAkhir,0); ?>
                                                    </td>
                                                </tr>
                                                <?php
                                                
                                                $grand_saldoAwal += $group_saldoAwal;
                                                $grand_mutasi += $group_mutasi;
                                                $grand_saldoAkhir += $group_saldoAkhir;
                                            }
                                        }
                                        ?>
                                        <tr class="total-row">
                                            <td colspan="2" class="fw-bold">
                                                <i class="fas faB-calculator me-2"></i>TOTAL PENERIMAAN
                                            </td>
                                            <td class="text-end amount fw-bold">
                                                <?php echo number_format($grand_saldoAwal,0); ?>
                                            </td>
                                            <td class="text-end amount fw-bold">
                                                <?php echo number_format($grand_mutasi,0); ?>
                                            </td>
                                            <td class="text-end amount fw-bold">
                                                <?php echo number_format($grand_saldoAkhir,0); ?>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                            <!-- Expense Section -->
                            <div class="section-expense mb-4">
                                <table class="table financial-table">
                                    <thead>
                                        <tr class="section-header">
                                            <th colspan="5">
                                                <i class="fas fa-arrow-down me-2"></i>PENGELUARAN
                                            </th>
                                        </tr>
                                        <tr>
                                            <th style="width: 15%">Kode</th>
                                            <th style="width: 40%">Nama Akun</th>
                                            <th style="width: 15%; text-align: center">
                                                <?php echo date('d M Y', strtotime('-1 days', strtotime($_POST['par1'])));?>
                                            </th>
                                            <th style="width: 15%; text-align: center">Mutasi</th>
                                            <th style="width: 15%; text-align: center">
                                                <?php echo date('d M Y',strtotime($_POST['par2']));?>
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        // Definisi kelompok pengeluaran
                                        $expense_groups = array(
                                            '5.500' => 'Angsuran Pinjaman',
                                            '5.510' => 'Bisyaroh',
                                            '5.520' => 'THR',
                                            '5.530' => 'Belanja Dapur',
                                            '5.540' => 'Lain-lain',
                                            '5.560' => 'Operasional',
                                            '5.570' => 'Divisi',
                                            '5.580' => 'Penyusutan & Amortisasi'
                                        );
                                        
                                        $grand_saldoAwal_exp = 0;
                                        $grand_mutasi_exp = 0;
                                        $grand_saldoAkhir_exp = 0;
                                        
                                        foreach($expense_groups as $group_code => $group_name) {
                                            // Query untuk setiap kelompok
                                            $queryl3 = "SELECT tanggal AS tanggal,kode_akun AS kode_akun,kode_akun.n_akun AS nama_akun,saldo.saldoAwal AS saldoAwal,SUM(debet-kredit)-saldo.saldoAwal AS mutasi,SUM(debet - kredit) AS saldoAkhir 
                                                       FROM bukubesar 
                                                       LEFT JOIN (SELECT kode_akun AS kode2,SUM(debet - kredit) AS saldoAwal FROM bukubesar WHERE tanggal <'$par1' and bukubesar.kode='$kode' and kode_akun LIKE '$group_code%' GROUP BY kode_akun) AS saldo ON bukubesar.kode_akun = saldo.kode2 
                                                       LEFT JOIN (SELECT n_akun,k_akun FROM kode_akun)AS kode_akun ON bukubesar.kode_akun=kode_akun.k_akun 
                                                       WHERE bukubesar.tanggal <='$par2' and bukubesar.kode='$kode' and bukubesar.kode_akun LIKE '$group_code%' 
                                                       GROUP BY kode_akun 
                                                       HAVING saldoAkhir<>0 
                                                       ORDER BY kode_akun";
                                            
                                            $resultz3 = mysqli_query($koneksi, $queryl3);
                                            $row_count = mysqli_num_rows($resultz3);
                                            
                                            if ($row_count > 0) {
                                                // Header kelompok
                                                ?>
                                                <tr>
                                                    <td colspan="5" class="group-header">
                                                        <i class="fas faB-folder-open me-2"></i><?php echo $group_name; ?>
                                                    </td>
                                                </tr>
                                                <?php
                                                
                                                $group_saldoAwal = 0;
                                                $group_mutasi = 0;
                                                $group_saldoAkhir = 0;
                                                
                                                while ($datal3 = mysqli_fetch_assoc($resultz3)) {
                                                    $group_saldoAwal += $datal3['saldoAwal'];
                                                    $group_mutasi += $datal3['mutasi'];
                                                    $group_saldoAkhir += $datal3['saldoAkhir'];
                                                    ?>
                                                    <tr>
                                                        <td class="fw-bold" style="padding-left: 25px;"><?php echo $datal3['kode_akun']; ?></td>
                                                        <td style="padding-left: 25px;"><?php echo $datal3['nama_akun']; ?></td>
                                                        <td class="text-end amount negative-amount">
                                                            <?php echo number_format($datal3['saldoAwal'],0); ?>
                                                        </td>
                                                        <td class="text-end amount negative-amount">
                                                            <?php echo number_format($datal3['mutasi'],0); ?>
                                                        </td>
                                                        <td class="text-end amount negative-amount">
                                                            <?php echo number_format($datal3['saldoAkhir'],0); ?>
                                                        </td>
                                                    </tr>
                                                    <?php 
                                                }
                                                
                                                // Subtotal kelompok
                                                ?>
                                                <tr class="group-total">
                                                    <td colspan="2" class="fw-bold" style="padding-left: 25px;">
                                                        <i class="fas faB-plus-circle me-2"></i>Jumlah <?php echo $group_name; ?>
                                                    </td>
                                                    <td class="text-end amount fw-bold">
                                                        <?php echo number_format($group_saldoAwal,0); ?>
                                                    </td>
                                                    <td class="text-end amount fw-bold">
                                                        <?php echo number_format($group_mutasi,0); ?>
                                                    </td>
                                                    <td class="text-end amount fw-bold">
                                                        <?php echo number_format($group_saldoAkhir,0); ?>
                                                    </td>
                                                </tr>
                                                <?php
                                                
                                                $grand_saldoAwal_exp += $group_saldoAwal;
                                                $grand_mutasi_exp += $group_mutasi;
                                                $grand_saldoAkhir_exp += $group_saldoAkhir;
                                            }
                                        }
                                        ?>
                                        <tr class="total-row">
                                            <td colspan="2" class="fw-bold">
                                                <i class="fas faB-calculator me-2"></i>TOTAL PENGELUARAN
                                            </td>
                                            <td class="text-end amount fw-bold">
                                                <?php echo number_format($grand_saldoAwal_exp,0); ?>
                                            </td>
                                            <td class="text-end amount fw-bold">
                                                <?php echo number_format($grand_mutasi_exp,0); ?>
                                            </td>
                                            <td class="text-end amount fw-bold">
                                                <?php echo number_format($grand_saldoAkhir_exp,0); ?>
                                            </td>
                                        </tr>
                                        <tr class="profit-row">
                                            <td colspan="2" class="fw-bold">
                                                <i class="fas faB-trophy me-2"></i>KENAIKAN/PENURUNAN ASET
                                            </td>
                                            <td class="text-end amount fw-bold">
                                                <?php echo number_format(($grand_saldoAwal - $grand_saldoAwal_exp),0); ?>
                                            </td>
                                            <td class="text-end amount fw-bold">
                                                <?php echo number_format(($grand_mutasi - $grand_mutasi_exp),0); ?>
                                            </td>
                                            <td class="text-end amount fw-bold">
                                                <?php echo number_format(($grand_saldoAkhir - $grand_saldoAkhir_exp),0); ?>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                            <?php
                            $_SESSION['neraca']['periode1'] = date('Y-m-d',strtotime($_POST['par1']));
                            $_SESSION['neraca']['periode2'] = date('Y-m-d',strtotime($_POST['par2']));
                            $_SESSION['neraca']['judul']= "Laporan Laba Rugi";
                            ?>
                            
                            <div class="text-end">
                                <a href="pdf/lap_labarugi_pdf.php" target="_blank" class="pdf-download">
                                    <i class="fas fa-file-pdf me-2"></i>Download PDF
                                </a>
                            </div>
                            
                        <?php } ?>
                    </div>

                    <div class="report-footer">
                        <i class="fas fa-shield-alt me-2"></i>SAK-EP
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- External Dependencies -->
<link rel="stylesheet" href="calendar.css"/>
<script type="text/javascript" src="hijri-date.js"></script>
<script type="text/javascript" src="calendar.js"></script>

<script type="text/javascript">
    // Enhanced Date Picker 1
    var pickedTxt1 = document.getElementById('par1'),
        datepicker1 = new Calendar(true, 0, false, true);
    document.getElementById('datepicker1').appendChild(datepicker1.getElement());
    datepicker1.getElement().style.marginTop = '10px';
    
    datepicker1.callback = function() {
        var selectedDate = datepicker1.getDate();
        var day = selectedDate.getDate().toString().padStart(2, '0');
        var month = (selectedDate.getMonth() + 1).toString().padStart(2, '0');
        var year = selectedDate.getFullYear();
        pickedTxt1.value = day + '-' + month + '-' + year;
        pickedTxt1.selectionStart = 0;
        pickedTxt1.selectionEnd = pickedTxt1.value.length;
        pickedTxt1.focus();
        datepicker1.hide();
        
        // Add smooth transition effect
        pickedTxt1.style.transform = 'scale(1.02)';
        setTimeout(() => {
            pickedTxt1.style.transform = 'scale(1)';
        }, 150);
    };

    function pickADate1() {
        datepicker1.show();
        datepicker1.getElement().style.position = 'absolute';
        datepicker1.getElement().style.zIndex = '1000';
        addClickOutsideListener(datepicker1, 'calendar-popup1');
    }

    // Enhanced Date Picker 2
    var pickedTxt2 = document.getElementById('par2'),
        datepicker2 = new Calendar(true, 0, false, true);
    document.getElementById('datepicker2').appendChild(datepicker2.getElement());
    datepicker2.getElement().style.marginTop = '10px';
    
    datepicker2.callback = function() {
        var selectedDate = datepicker2.getDate();
        var day = selectedDate.getDate().toString().padStart(2, '0');
        var month = (selectedDate.getMonth() + 1).toString().padStart(2, '0');
        var year = selectedDate.getFullYear();
        pickedTxt2.value = day + '-' + month + '-' + year;
        pickedTxt2.selectionStart = 0;
        pickedTxt2.selectionEnd = pickedTxt2.value.length;
        pickedTxt2.focus();
        datepicker2.hide();
        
        // Add smooth transition effect
        pickedTxt2.style.transform = 'scale(1.02)';
        setTimeout(() => {
            pickedTxt2.style.transform = 'scale(1)';
        }, 150);
    };

    function pickADate2() {
        datepicker2.show();
        datepicker2.getElement().style.position = 'absolute';
        datepicker2.getElement().style.zIndex = '1000';
        addClickOutsideListener(datepicker2, 'calendar-popup2');
    }

    // Enhanced click outside handler
    function addClickOutsideListener(datepicker, popupId) {
        function onClick(event) {
            var popup = document.getElementById(popupId);
            if (popup && !popup.contains(event.target) && !datepicker.getElement().contains(event.target)) {
                datepicker.hide();
                document.removeEventListener('click', onClick);
            }
        }
        
        setTimeout(() => {
            document.addEventListener('click', onClick);
        }, 100);
    }

    // Enhanced form validation
    document.querySelector('form').addEventListener('submit', function(e) {
        var startDate = document.getElementById('par1').value;
        var endDate = document.getElementById('par2').value;
        
        if (!startDate || !endDate) {
            e.preventDefault();
            alert('⚠️ Harap pilih tanggal mulai dan tanggal akhir!');
            return false;
        }
        
        // Add loading state
        var submitBtn = document.querySelector('.btn-preview');
        submitBtn.innerHTML = '⏳ Memproses...';
        submitBtn.disabled = true;
    });

    // Add smooth scrolling to sections
    document.addEventListener('DOMContentLoaded', function() {
        // Animate tables on load
        const tables = document.querySelectorAll('.modern-table');
        tables.forEach((table, index) => {
            table.style.opacity = '0';
            table.style.transform = 'translateY(20px)';
            setTimeout(() => {
                table.style.transition = 'all 0.6s ease';
                table.style.opacity = '1';
                table.style.transform = 'translateY(0)';
            }, index * 200);
        });
    });

    // Enhanced accessibility
    document.addEventListener('keydown', function(e) {
        if (e.key === 'Escape') {
            datepicker1.hide();
            datepicker2.hide();
        }
    });
</script>