<?php
// Uncomment for error reporting if needed
error_reporting(E_ALL^(E_NOTICE|E_WARNING));
error_reporting(0);
//ini_set('display_errors', 1); 
require './kalenderhijriah.php';
?>

<!-- Modern CSS Styling -->
<style>
:root {
  --primary-color: #1f2937;
  --secondary-color: #3b82f6;
  --accent-color: #10b981;
  --success-color: #059669;
  --warning-color: #f59e0b;
  --danger-color: #dc2626;
  --light-bg: #f8fafc;
  --white: #ffffff;
  --gray-50: #f9fafb;
  --gray-100: #f3f4f6;
  --gray-200: #e5e7eb;
  --gray-300: #d1d5db;
  --gray-600: #4b5563;
  --gray-700: #374151;
  --gray-800: #1f2937;
  --shadow-sm: 0 1px 2px 0 rgb(0 0 0 / 0.05);
  --shadow-md: 0 4px 6px -1px rgb(0 0 0 / 0.1), 0 2px 4px -2px rgb(0 0 0 / 0.1);
  --shadow-lg: 0 10px 15px -3px rgb(0 0 0 / 0.1), 0 4px 6px -4px rgb(0 0 0 / 0.1);
  --radius-sm: 0.375rem;
  --radius-md: 0.5rem;
  --radius-lg: 0.75rem;
}

* {
  box-sizing: border-box;
}

body {
  font-family: 'Inter', 'Segoe UI', system-ui, -apple-system, sans-serif;
  line-height: 1.6;
  color: var(--gray-700);
  background-color: var(--light-bg);
}

.modern-container {
  max-width: 1200px;
  margin: 0 auto;
  padding: 2rem;
}

.modern-card {
  background: var(--white);
  border-radius: var(--radius-lg);
  box-shadow: var(--shadow-lg);
  overflow: hidden;
  margin-bottom: 2rem;
  border: 1px solid var(--gray-100);
}

.modern-header {
  background: linear-gradient(135deg, var(--secondary-color) 0%, var(--primary-color) 100%);
  color: var(--white);
  padding: 2rem;
  text-align: center;
  position: relative;
  overflow: hidden;
}

.modern-header::before {
  content: '';
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="20" cy="20" r="1" fill="white" opacity="0.1"/><circle cx="80" cy="40" r="1" fill="white" opacity="0.1"/><circle cx="40" cy="70" r="1" fill="white" opacity="0.1"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>');
  pointer-events: none;
}

.modern-header h3 {
  margin: 0;
  font-size: 2rem;
  font-weight: 700;
  text-shadow: 0 2px 4px rgba(0,0,0,0.1);
  position: relative;
  z-index: 1;
}

.modern-body {
  padding: 2rem;
}

.form-section {
  background: var(--gray-50);
  border-radius: var(--radius-md);
  padding: 1.5rem;
  margin-bottom: 2rem;
  border: 1px solid var(--gray-200);
}

.form-controls {
  display: flex;
  gap: 1rem;
  align-items: end;
  flex-wrap: wrap;
  margin-bottom: 1rem;
}

.date-input-group {
  display: flex;
  flex-direction: column;
  gap: 0.5rem;
  min-width: 160px;
}

.date-input-group label {
  font-size: 0.875rem;
  font-weight: 600;
  color: var(--gray-700);
  margin-bottom: 0.25rem;
}

.date-container {
  display: flex;
  align-items: center;
  background: var(--white);
  border: 1px solid var(--gray-300);
  border-radius: var(--radius-sm);
  overflow: hidden;
  transition: all 0.2s ease;
  box-shadow: var(--shadow-sm);
}

.date-container:hover {
  border-color: var(--secondary-color);
  box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
}

.date-container:focus-within {
  border-color: var(--secondary-color);
  box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
}

.date-input {
  border: none;
  padding: 0.75rem 1rem;
  font-size: 0.875rem;
  background: transparent;
  color: var(--gray-700);
  width: 120px;
  outline: none;
}

.date-picker-btn {
  background: var(--gray-100);
  border: none;
  padding: 0.75rem;
  cursor: pointer;
  transition: background-color 0.2s ease;
  display: flex;
  align-items: center;
  justify-content: center;
}

.date-picker-btn:hover {
  background: var(--gray-200);
}

.date-picker-btn img {
  width: 20px;
  height: 20px;
  opacity: 0.7;
}

.btn-preview {
  background: linear-gradient(135deg, var(--secondary-color), var(--accent-color));
  color: var(--white);
  border: none;
  padding: 0.75rem 2rem;
  border-radius: var(--radius-sm);
  font-weight: 600;
  font-size: 0.875rem;
  cursor: pointer;
  transition: all 0.2s ease;
  box-shadow: var(--shadow-sm);
  text-transform: uppercase;
  letter-spacing: 0.025em;
}

.btn-preview:hover {
  transform: translateY(-1px);
  box-shadow: var(--shadow-md);
}

.btn-preview:active {
  transform: translateY(0);
}

.section-divider {
  height: 1px;
  background: linear-gradient(90deg, transparent, var(--gray-300), transparent);
  margin: 2rem 0;
}

.section-title {
  font-size: 1.5rem;
  font-weight: 700;
  color: var(--primary-color);
  margin: 2rem 0 1rem 0;
  text-transform: uppercase;
  letter-spacing: 0.05em;
  position: relative;
  padding-bottom: 0.5rem;
}

.section-title::after {
  content: '';
  position: absolute;
  bottom: 0;
  left: 0;
  width: 60px;
  height: 3px;
  background: linear-gradient(90deg, var(--secondary-color), var(--accent-color));
  border-radius: 2px;
}

.modern-table {
  width: 100%;
  border-collapse: separate;
  border-spacing: 0;
  background: var(--white);
  border-radius: var(--radius-md);
  overflow: hidden;
  box-shadow: var(--shadow-sm);
  margin-bottom: 2rem;
  border: 1px solid var(--gray-200);
}

.modern-table thead th {
  background: linear-gradient(135deg, var(--gray-800), var(--gray-700));
  color: var(--white);
  padding: 1rem;
  text-align: left;
  font-weight: 600;
  font-size: 0.875rem;
  text-transform: uppercase;
  letter-spacing: 0.025em;
  border-bottom: 2px solid var(--gray-600);
}

.modern-table thead th:first-child {
  border-top-left-radius: var(--radius-md);
}

.modern-table thead th:last-child {
  border-top-right-radius: var(--radius-md);
  text-align: center;
}

.modern-table thead th:nth-child(3),
.modern-table thead th:nth-child(4),
.modern-table thead th:nth-child(5) {
  text-align: center;
}

.modern-table tbody tr {
  transition: all 0.2s ease;
  border-bottom: 1px solid var(--gray-100);
}

.modern-table tbody tr:hover {
  background: var(--gray-50);
  transform: translateY(-1px);
  box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.modern-table tbody tr:last-child {
  border-bottom: none;
}

.modern-table tbody td {
  padding: 1rem;
  vertical-align: middle;
  font-size: 0.875rem;
  color: var(--gray-700);
}

.modern-table tbody td:first-child {
  font-weight: 600;
  color: var(--primary-color);
  font-family: 'JetBrains Mono', 'Courier New', monospace;
}

.modern-table tbody td:nth-child(3),
.modern-table tbody td:nth-child(4),
.modern-table tbody td:nth-child(5) {
  text-align: right;
  font-weight: 600;
  font-family: 'JetBrains Mono', 'Courier New', monospace;
}

.group-header {
  background: linear-gradient(135deg, var(--accent-color), var(--success-color)) !important;
  color: var(--white) !important;
  font-weight: 700 !important;
  text-transform: uppercase !important;
  letter-spacing: 0.05em !important;
}

.group-header:hover {
  background: linear-gradient(135deg, var(--accent-color), var(--success-color)) !important;
  transform: none !important;
  box-shadow: none !important;
}

.subtotal-row {
  background: var(--gray-100) !important;
  font-weight: 700 !important;
  color: var(--primary-color) !important;
  border-top: 2px solid var(--gray-300) !important;
}

.subtotal-row:hover {
  background: var(--gray-200) !important;
}
.total-row {
  background:rgb(33, 164, 234) !important; /* Ganti background menjadi hitam */
  color: #ffffff !important; /* Warna teks putih */
  font-weight: 700 !important;
  font-size: 1rem !important;
  border-top: 3px solid var(--secondary-color) !important;
}

/* Bagian hover dihapus */


/* .total-row {
  background: linear-gradient(135deg, var(--primary-color), var(--gray-800)) !important;
  color: var(--white) !important;
  font-weight: 700 !important;
  font-size: 1rem !important;
  border-top: 3px solid var(--secondary-color) !important;
} */

/* 
.total-row:hover {
  background: linear-gradient(135deg, var(--gray-50), var(--gray-200)) !important;
  color: var(--gray-800) !important;
  transform: none !important;
  box-shadow: 0 6px 8px -1px rgba(0, 0, 0, 0.15), 0 4px 6px -2px rgba(0, 0, 0, 0.1) !important;
}
 */
.amount-positive {
  color: var(--success-color);
}

.amount-negative {
  color: var(--danger-color);
}

.datepicker {
  position: absolute !important;
  z-index: 1000 !important;
  background: var(--white);
  border: 1px solid var(--gray-300);
  border-radius: var(--radius-md);
  box-shadow: var(--shadow-lg);
  padding: 1rem;
  margin-top: 0.5rem;
}

.btn-pdf {
  background: linear-gradient(135deg, var(--success-color), var(--accent-color));
  color: var(--white);
  border: none;
  padding: 0.75rem 1.5rem;
  border-radius: var(--radius-sm);
  font-weight: 600;
  text-decoration: none;
  display: inline-flex;
  align-items: center;
  gap: 0.5rem;
  transition: all 0.2s ease;
  box-shadow: var(--shadow-sm);
  float: right;
  margin-top: 1rem;
}

.btn-pdf:hover {
  transform: translateY(-2px);
  box-shadow: var(--shadow-md);
  text-decoration: none;
  color: var(--white);
}

.modern-footer {
  background: linear-gradient(135deg, var(--gray-700), var(--gray-800));
  color: var(--white);
  padding: 1rem 2rem;
  text-align: center;
  font-weight: 600;
  font-size: 0.875rem;
  letter-spacing: 0.025em;
}

@media (max-width: 768px) {
  .modern-container {
    padding: 1rem;
  }
  
  .modern-header h3 {
    font-size: 1.5rem;
  }
  
  .modern-body {
    padding: 1rem;
  }
  
  .form-controls {
    flex-direction: column;
    align-items: stretch;
  }
  
  .date-input-group {
    min-width: auto;
  }
  
  .modern-table {
    font-size: 0.75rem;
  }
  
  .modern-table th,
  .modern-table td {
    padding: 0.5rem;
  }
  
  .section-title {
    font-size: 1.25rem;
  }
}

@media print {
  .form-section,
  .btn-preview,
  .btn-pdf {
    display: none;
  }
  
  .modern-card {
    box-shadow: none;
    border: 1px solid #000;
  }
  
  .modern-header {
    background: #000 !important;
    color: #fff !important;
  }
}

/* Animation untuk loading state */
@keyframes shimmer {
  0% { background-position: -200px 0; }
  100% { background-position: calc(200px + 100%) 0; }
}

.loading-shimmer {
  background: linear-gradient(90deg, #f0f0f0 0px, #e0e0e0 40px, #f0f0f0 80px);
  background-size: 200px;
  animation: shimmer 1.5s linear infinite;
}
</style>

<!-- Content Header (Page header) -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-12">
        <!-- <h1 class="m-0 text-dark">Laporan Neraca []</h1> -->
      </div><!-- /.col -->
    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<!-- Main content -->
<section class="content">
  <div class="modern-container">
    <div class="modern-card">
      <div class="modern-header">
        <h3>📊 Laporan Posisi Keuangan</h3>
      </div>
      
      <div class="modern-body">
        <?php
        $kode = $_SESSION['kode'];
        $par1 = isset($_POST['par1']) ? date('Y-m-d',strtotime($_POST['par1'])) : "";
        $par2 = isset($_POST['par2']) ? date('Y-m-d',strtotime($_POST['par2'])) : "";
        ?>
        
        <div class="form-section">
          <form action="home.php?home=<?php echo md5("neraca"); ?>" method="post">
            <div class="form-controls">
              <!-- Input tanggal pertama -->
              <div class="date-input-group">
                <label for="par1">📅 Tanggal Mulai</label>
                <div id="datepicker1" class="date-container">
                  <input id="par1" name="par1" type="text" class="date-input" 
                         value="<?php if(isset($_POST['par1'])){ echo $_POST['par1']; }else{ echo sprintf('%02d', $hijri[1]) . '-' . $calendar->monthName($hijri[0]) . '-' . $hijri[2];} ?>" 
                         placeholder="DD-MM-YYYY" />
                  <button type="button" class="date-picker-btn" onclick="pickADate1();">
                    <img src="kalender.png" alt="Pick Date" />
                  </button>
                  <div id="calendar-popup1" class="datepicker" style="display:none;"></div>
                </div>
              </div>

              <!-- Input tanggal kedua -->
              <div class="date-input-group">
                <label for="par2">📅 Tanggal Akhir</label>
                <div id="datepicker2" class="date-container">
                  <input id="par2" name="par2" type="text" class="date-input" 
                         value="<?php if(isset($_POST['par2'])){ echo $_POST['par2']; }else{ echo sprintf('%02d', $hijri[1]) . '-' . $calendar->monthName($hijri[0]) . '-' . $hijri[2];} ?>" 
                         placeholder="DD-MM-YYYY" />
                  <button type="button" class="date-picker-btn" onclick="pickADate2();">
                    <img src="kalender.png" alt="Pick Date" />
                  </button>
                  <div id="calendar-popup2" class="datepicker" style="display:none;"></div>
                </div>
              </div>

              <button type="submit" name="proses" class="btn-preview">
                🔍 Tampilkan Laporan
              </button>
            </div>
          </form>
        </div>

        <div class="section-divider"></div>

        <?php if (!empty($par1)) { ?>    

        <h5 class="section-title">💰 AKTIVA</h5>
        <table class="modern-table">
          <thead>
            <tr>
              <th style="width: 12%;">Kode</th>
              <th>Nama Akun</th>
              <th style="width: 15%;"><?php echo date('d-m-Y', strtotime('-1 days', strtotime($par1))); ?></th>
              <th style="width: 15%;">Mutasi</th>
              <th style="width: 15%;"><?php echo date('d-m-Y', strtotime($par2)); ?></th>
            </tr>
          </thead>
          <tbody>
            <?php
            $accountGroups = [
                ['range' => "1.10", 'label' => "💵 Kas & Bank"],
                ['range' => "1.11", 'label' => "📈 Penyertaan"],
                ['range' => "1.12", 'label' => "💎 Piutang Gadai"],
                ['range' => "1.14,1.15,1.16,1.17,1.180,1.190", 'label' => "🏢 Aktiva Tetap"],
            ];

            $totalSaldoAwal = 0;
            $totalMutasi = 0;
            $totalSaldoAkhir = 0;

            foreach ($accountGroups as $group) {
                $ranges = explode(',', $group['range']);
                $likeConditions = [];

                foreach ($ranges as $range) {
                    $likeConditions[] = "kode_akun LIKE '{$range}%'";
                }
                $likeSQL = implode(' OR ', $likeConditions);

                $query = "SELECT 
                          bukubesar.kode_akun, 
                          kode_akun.n_akun AS nama_akun, 
                          saldo.saldoAwal, 
                          SUM(bukubesar.debet - bukubesar.kredit) AS saldoAkhir,
                          SUM(bukubesar.debet - bukubesar.kredit) - saldo.saldoAwal AS mutasi 
                        FROM 
                          bukubesar 
                        LEFT JOIN (
                          SELECT 
                            kode_akun AS kode2, 
                            SUM(debet - kredit) AS saldoAwal 
                          FROM 
                            bukubesar 
                          WHERE kode ='$kode' AND
                            tanggal < '$par1' AND ($likeSQL) 
                          GROUP BY 
                            kode_akun
                        ) AS saldo ON bukubesar.kode_akun = saldo.kode2 
                        LEFT JOIN kode_akun ON bukubesar.kode_akun = kode_akun.k_akun
                        WHERE bukubesar.kode ='$kode' AND
                          bukubesar.tanggal <= '$par2' AND ($likeSQL) 
                        GROUP BY 
                          bukubesar.kode_akun 
                        HAVING 
                          saldoAkhir <> 0";
                          
                $_SESSION['neracagab']['sql1'] = $query;

                $result = $mysqli->query($query);
                $tsaldoAwal = $tmutasi = $tsaldoAkhir = 0;

                if ($result && $result->num_rows > 0) {
                    echo "<tr class='group-header'><td colspan='5'>{$group['label']}</td></tr>";

                    while ($data = $result->fetch_assoc()) {
                        $tsaldoAwal += $data['saldoAwal'];
                        $tmutasi += $data['mutasi'];
                        $tsaldoAkhir += $data['saldoAkhir'];
                        
                        $mutasiClass = $data['mutasi'] >= 0 ? 'amount-positive' : 'amount-negative';
                        ?>
                        <tr>
                            <td><?php echo $data['kode_akun']; ?></td>
                            <td><?php echo $data['nama_akun']; ?></td>
                            <td><?php echo number_format($data['saldoAwal'], 0, ',', '.'); ?></td>
                            <td class="<?php echo $mutasiClass; ?>"><?php echo number_format($data['mutasi'], 0, ',', '.'); ?></td>
                            <td><?php echo number_format($data['saldoAkhir'], 0, ',', '.'); ?></td>
                        </tr>
                        <?php
                    }
                    $totalSaldoAwal += $tsaldoAwal;
                    $totalMutasi += $tmutasi;
                    $totalSaldoAkhir += $tsaldoAkhir;
                    ?>
                    <tr class="subtotal-row">
                        <td colspan="2">Jumlah <?php echo str_replace(['💵', '📈', '💎', '🏢'], '', $group['label']); ?></td>
                        <td><?= number_format($tsaldoAwal, 0, ',', '.') ?></td>
                        <td><?= number_format($tmutasi, 0, ',', '.') ?></td>
                        <td><?= number_format($tsaldoAkhir, 0, ',', '.') ?></td>
                    </tr>
                    <?php
                }
            }
            if ($totalSaldoAwal > 0) {
            ?>
            <tr class="total-row">
                <td colspan="2">💰 TOTAL AKTIVA</td>
                <td><?= number_format($totalSaldoAwal, 0, ',', '.') ?></td>
                <td><?= number_format($totalMutasi, 0, ',', '.') ?></td>
                <td><?= number_format($totalSaldoAkhir, 0, ',', '.') ?></td>
            </tr>
            <?php } ?>
          </tbody>
        </table>

        <!-- Laba Rugi Section -->
        <?php
        $tsaldoAwals = 0;
        $tmutasis = 0;
        $tsaldoAkhirs = 0;
        
        $queryzs = "SELECT tanggal AS tanggal, 
            '3.320.60' AS kode_akun, 
            'LABA BERJALAN' AS nama_akun,
            saldo.saldoAwal AS saldoAwal,
            SUM(kredit - debet) - saldo.saldoAwal AS mutasi,
            SUM(kredit - debet) AS saldoAkhir 
        FROM bukubesar 
        LEFT JOIN (
        SELECT kode_akun AS kode2, 
               SUM(kredit - debet) AS saldoAwal 
        FROM bukubesar 
        WHERE kode='$kode' AND tanggal < '$par1' AND kode_akun >= '4.400' 
        GROUP BY kode_akun
        ) AS saldo ON bukubesar.kode_akun = saldo.kode2 
        LEFT JOIN (SELECT n_akun, k_akun FROM kode_akun) AS kode_akun 
        ON bukubesar.kode_akun = kode_akun.k_akun 
        WHERE bukubesar.kode='$kode' AND bukubesar.tanggal <= '$par2' AND bukubesar.kode_akun >= '4.400'";
                               
        $_SESSION['neraca']['sqls'] = $queryzs;
        $resultz = $mysqli->query($queryzs);
        $num_resultz = $resultz->num_rows;

        if ($num_resultz > 0) {
          while ($datazs = mysqli_fetch_assoc($resultz)) {
            $tsaldoAwals += $datazs['saldoAwal'];
            $tmutasis += $datazs['mutasi'];
            $tsaldoAkhirs += $datazs['saldoAkhir'];
          }
        }
        ?>

        <h5 class="section-title">🏦 PASIVA</h5>
        <table class="modern-table">
          <thead>
            <tr>
              <th style="width: 12%;">Kode</th>
              <th>Nama Akun</th>
              <th style="width: 15%;"><?php echo date('d-m-Y', strtotime('-1 days', strtotime($par1))); ?></th>
              <th style="width: 15%;">Mutasi</th>
              <th style="width: 15%;"><?php echo date('d-m-Y', strtotime($par2)); ?></th>
            </tr>
          </thead>
          <tbody>
            <?php
            $accountGroups = [
                ['range' => "2.2", 'label' => "💳 Pasiva Lancar"],
                ['range' => "2.310", 'label' => "💰 Modal"],
                ['range' => "2.320", 'label' => "📊 Kenaikan Aset"],
            ];

            $totalsaldoAwal22 = 0;
            $totalmutasi2 = 0;
            $totalsaldoAkhir22 = 0;

            foreach ($accountGroups as $group) {
                $query2 = "SELECT 
                            bukubesar.kode_akun, 
                            kode_akun.n_akun AS nama_akun, 
                            saldo.saldoAwal2, 
                            SUM(bukubesar.kredit - bukubesar.debet) AS saldoAkhir2,
                            SUM(bukubesar.kredit - bukubesar.debet) - saldo.saldoAwal2 AS mutasi2 
                          FROM 
                            bukubesar 
                          LEFT JOIN (
                            SELECT 
                              kode_akun AS kode2, 
                              SUM(kredit - debet) AS saldoAwal2 
                            FROM 
                              bukubesar 
                            WHERE kode = '$kode' AND
                              tanggal < '$par1' AND kode_akun LIKE '{$group['range']}%' 
                            GROUP BY kode_akun
                          ) AS saldo ON bukubesar.kode_akun = saldo.kode2 
                          LEFT JOIN kode_akun ON bukubesar.kode_akun = kode_akun.k_akun
                          WHERE bukubesar.kode = '$kode' AND
                            bukubesar.tanggal <= '$par2' AND bukubesar.kode_akun LIKE '{$group['range']}%' 
                          GROUP BY 
                            bukubesar.kode_akun 
                          HAVING 
                            saldoAkhir2 <> 0";
                            
                $_SESSION['neracagab']['sql2'] = $query2;

                $result = $mysqli->query($query2);
                $tsaldoAwal2 = $tmutasi2 = $tsaldoAkhir2 = 0;

                if ($result && $result->num_rows > 0) {
                    echo "<tr class='group-header'><td colspan='5'>{$group['label']}</td></tr>";

                    while ($data = $result->fetch_assoc()) {
                        $tsaldoAwal2 += $data['saldoAwal2'];
                        $tmutasi2 += $data['mutasi2'];
                        $tsaldoAkhir2 += $data['saldoAkhir2'];
                        
                        $mutasiClass = $data['mutasi2'] >= 0 ? 'amount-positive' : 'amount-negative';
                        ?>
                        <tr>
                            <td><?php echo $data['kode_akun']; ?></td>
                            <td><?php echo $data['nama_akun']; ?></td>
                            <td><?php echo number_format($data['saldoAwal2'], 0, ',', '.'); ?></td>
                            <td class="<?php echo $mutasiClass; ?>"><?php echo number_format($data['mutasi2'], 0, ',', '.'); ?></td>
                            <td><?php echo number_format($data['saldoAkhir2'], 0, ',', '.'); ?></td>
                        </tr>
                        <?php
                    }
                    $totalsaldoAwal22 += $tsaldoAwal2;
                    $totalmutasi2 += $tmutasi2;
                    $totalsaldoAkhir22 += $tsaldoAkhir2;
                    ?>
                    <tr class="subtotal-row">
                        <td colspan="2">Jumlah <?php echo str_replace(['💳', '💰', '📊'], '', $group['label']); ?></td>
                        <td><?= number_format($tsaldoAwal2, 0, ',', '.') ?></td>
                        <td><?= number_format($tmutasi2, 0, ',', '.') ?></td>
                        <td><?= number_format($tsaldoAkhir2, 0, ',', '.') ?></td>
                    </tr>
                    <?php
                }
            }
            ?>
            <tr>
                <td>2.320.60</td>
                <td>📈 KENAIKAN ASET BERSIH</td>
                <td><?= number_format($tsaldoAwals, 0, ',', '.') ?></td>
                <td class="<?= $tmutasis >= 0 ? 'amount-positive' : 'amount-negative' ?>"><?= number_format($tmutasis, 0, ',', '.') ?></td>
                <td><?= number_format($tsaldoAkhirs, 0, ',', '.') ?></td>
            </tr>
            
            <?php if ($totalsaldoAwal22 > 0) { ?>
            <tr class="total-row">
                <td colspan="2">🏦 TOTAL PASIVA</td>
                <td><?= number_format($totalsaldoAwal22 + $tsaldoAwals, 0, ',', '.') ?></td>
                <td><?= number_format($totalmutasi2 + $tmutasis, 0, ',', '.') ?></td>
                <td><?= number_format($totalsaldoAkhir22 + $tsaldoAkhirs, 0, ',', '.') ?></td>
            </tr>
            <?php } ?>
          </tbody>
        </table>
        
        <?php } ?>

        <?php if(isset($_POST['par1'])){
            $_SESSION['neracagab']['periode1'] = date('Y-m-d',strtotime($_POST['par1']));
            $_SESSION['neracagab']['periode2'] = date('Y-m-d',strtotime($_POST['par2']));
        ?>
        <a href="pdf/lap_neraca_pdf.php" target="_blank" class="btn-pdf">
            <i class="fa fa-print"></i> 📄 Export PDF
        </a>
        <?php } ?>

      </div>

      <div class="modern-footer">
        📊 SAK-EP - Standar Akuntansi Keuangan Entitas Privat
      </div>
    </div>
  </div>
</section>

<!-- External Dependencies -->
<link rel="stylesheet" href="calendar.css"/>
<script type="text/javascript" src="hijri-date.js"></script>
<script type="text/javascript" src="calendar.js"></script>

<script type="text/javascript">
    // Enhanced Date Picker 1
    var pickedTxt1 = document.getElementById('par1'),
        datepicker1 = new Calendar(true, 0, false, true);
    document.getElementById('datepicker1').appendChild(datepicker1.getElement());
    datepicker1.getElement().style.marginTop = '10px';
    
    datepicker1.callback = function() {
        var selectedDate = datepicker1.getDate();
        var day = selectedDate.getDate().toString().padStart(2, '0');
        var month = (selectedDate.getMonth() + 1).toString().padStart(2, '0');
        var year = selectedDate.getFullYear();
        pickedTxt1.value = day + '-' + month + '-' + year;
        pickedTxt1.selectionStart = 0;
        pickedTxt1.selectionEnd = pickedTxt1.value.length;
        pickedTxt1.focus();
        datepicker1.hide();
        
        // Add smooth transition effect
        pickedTxt1.style.transform = 'scale(1.02)';
        setTimeout(() => {
            pickedTxt1.style.transform = 'scale(1)';
        }, 150);
    };

    function pickADate1() {
        datepicker1.show();
        datepicker1.getElement().style.position = 'absolute';
        datepicker1.getElement().style.zIndex = '1000';
        addClickOutsideListener(datepicker1, 'calendar-popup1');
    }

    // Enhanced Date Picker 2
    var pickedTxt2 = document.getElementById('par2'),
        datepicker2 = new Calendar(true, 0, false, true);
    document.getElementById('datepicker2').appendChild(datepicker2.getElement());
    datepicker2.getElement().style.marginTop = '10px';
    
    datepicker2.callback = function() {
        var selectedDate = datepicker2.getDate();
        var day = selectedDate.getDate().toString().padStart(2, '0');
        var month = (selectedDate.getMonth() + 1).toString().padStart(2, '0');
        var year = selectedDate.getFullYear();
        pickedTxt2.value = day + '-' + month + '-' + year;
        pickedTxt2.selectionStart = 0;
        pickedTxt2.selectionEnd = pickedTxt2.value.length;
        pickedTxt2.focus();
        datepicker2.hide();
        
        // Add smooth transition effect
        pickedTxt2.style.transform = 'scale(1.02)';
        setTimeout(() => {
            pickedTxt2.style.transform = 'scale(1)';
        }, 150);
    };

    function pickADate2() {
        datepicker2.show();
        datepicker2.getElement().style.position = 'absolute';
        datepicker2.getElement().style.zIndex = '1000';
        addClickOutsideListener(datepicker2, 'calendar-popup2');
    }

    // Enhanced click outside handler
    function addClickOutsideListener(datepicker, popupId) {
        function onClick(event) {
            var popup = document.getElementById(popupId);
            if (popup && !popup.contains(event.target) && !datepicker.getElement().contains(event.target)) {
                datepicker.hide();
                document.removeEventListener('click', onClick);
            }
        }
        
        setTimeout(() => {
            document.addEventListener('click', onClick);
        }, 100);
    }

    // Enhanced form validation
    document.querySelector('form').addEventListener('submit', function(e) {
        var startDate = document.getElementById('par1').value;
        var endDate = document.getElementById('par2').value;
        
        if (!startDate || !endDate) {
            e.preventDefault();
            alert('⚠️ Harap pilih tanggal mulai dan tanggal akhir!');
            return false;
        }
        
        // Add loading state
        var submitBtn = document.querySelector('.btn-preview');
        submitBtn.innerHTML = '⏳ Memproses...';
        submitBtn.disabled = true;
    });

    // Add smooth scrolling to sections
    document.addEventListener('DOMContentLoaded', function() {
        // Animate tables on load
        const tables = document.querySelectorAll('.modern-table');
        tables.forEach((table, index) => {
            table.style.opacity = '0';
            table.style.transform = 'translateY(20px)';
            setTimeout(() => {
                table.style.transition = 'all 0.6s ease';
                table.style.opacity = '1';
                table.style.transform = 'translateY(0)';
            }, index * 200);
        });
    });

    // Enhanced accessibility
    document.addEventListener('keydown', function(e) {
        if (e.key === 'Escape') {
            datepicker1.hide();
            datepicker2.hide();
        }
    });
</script>