-- Database Backup untuk murid_sekolah
-- Dibuat pada: 2025-12-09 01:45:02
-- Generator: PHP MySQL Backup Script

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET AUTOCOMMIT = 0;
START TRANSACTION;
SET time_zone = "+00:00";

-- --------------------------------------------------------
-- Structure for table `alamat`
-- --------------------------------------------------------

DROP TABLE IF EXISTS `alamat`;
CREATE TABLE `alamat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `k_prov` varchar(30) DEFAULT NULL,
  `provinsi` varchar(30) DEFAULT NULL,
  `kode` varchar(30) DEFAULT NULL,
  `k_dusun` varchar(30) DEFAULT NULL,
  `dusun` varchar(90) DEFAULT NULL,
  `k_rtrw` varchar(8) DEFAULT NULL,
  `rtrw` varchar(8) DEFAULT NULL,
  `k_desa` varchar(10) DEFAULT NULL,
  `desa` varchar(90) DEFAULT NULL,
  `k_kec` varchar(10) DEFAULT NULL,
  `kec` varchar(90) DEFAULT NULL,
  `k_kab` varchar(10) DEFAULT NULL,
  `kab` varchar(90) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=689 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

-- Dumping data for table `alamat`
-- Records: 31
-- --------------------------------------------------------

INSERT INTO `alamat` (`id`, `k_prov`, `provinsi`, `kode`, `k_dusun`, `dusun`, `k_rtrw`, `rtrw`, `k_desa`, `desa`, `k_kec`, `kec`, `k_kab`, `kab`) VALUES
('658', '35', 'JAWA TIMUR', '35.14.16.2017.03.07', '07', 'KRAJAN II', '03', '03/02', '2017', 'REJOSARI', '16', 'KRATON', '14', 'PASURUAN'),
('659', '35', 'JAWA TIMUR', '35.14.16.2017.04.07', '07', 'KRAJAN II', '04', '04/02', '2017', 'REJOSARI', '16', 'KRATON', '14', 'PASURUAN'),
('660', '35', 'JAWA TIMUR', '35.14.16.2024.01.01', '01', 'BENDUNGAN', '01', '01/01', '2024', 'BENDUNGAN', '16', 'KRATON', '14', 'PASURUAN'),
('661', '35', 'JAWA TIMUR', '35.14.16.2017.07.06', '07', 'KRAJAN 2', '06', '03/02', '2017', 'REJOSARI', '16', 'KRATON', '14', 'PASURUAN'),
('662', '35', 'JAWA TIMUR', '35.14.16.2016.13.03', '13', 'CURAH DUKUH', '03', '01/02', '2016', 'CURAH DUKUH', '16', 'KRATON', '14', 'PASURUAN'),
('663', '35', 'JAWA TIMUR', '35.14.15.2003.14.23', '14', 'PEJATEN', '23', '03/05', '2003', 'PAJARAN', '15', 'REMBANG', '14', 'PASURUAN'),
('664', '35', 'JAWA TIMUR', '35.14.16.2024.15.22', '15', 'WISMOKERTO', '22', '01/09', '2024', 'BENDUNGAN', '16', 'KRATON', '14', 'PASURUAN'),
('665', '35', 'JAWA TIMUR', '35.14.16.2017.07.06', '07', 'KRAJAN 2', '06', '01/02', '2017', 'REJOSARI', '16', 'KRATON', '14', 'PASURUAN'),
('666', '35', 'JAWA TIMUR', '35.14.16.2017.12.19', '12', 'TALANGAN', '19', '01/03', '2017', 'REJOSARI', '16', 'KRATON', '14', 'PASURUAN'),
('667', '35', 'JAWA TIMUR', '35.14.16.2015.11.21', '11', 'SELOTAMBAK UTARA', '21', '09/05', '2015', 'SELOTAMBAK', '16', 'KRATON', '14', 'PASURUAN'),
('668', '35', 'JAWA TIMUR', '35.14.16.2017.07.06', '07', 'KRAJAN 2', '06', '02/02', '2017', 'REJOSARI', '16', 'KRATON', '14', 'PASURUAN'),
('669', '35', 'JAWA TIMUR', '35.14.16.2017.07.05', '07', 'KRAJAN 2', '05', '01/01', '2017', 'REJOSARI', '16', 'KRATON', '14', 'PASURUAN'),
('670', '35', 'JAWA TIMUR', '35.14.16.2017.06.03', '06', 'KRAJAN 1', '03', '01/01', '2017', 'REJOSARI', '16', 'KRATON', '14', 'PASURUAN'),
('671', '35', 'JAWA TIMUR', '35.14.16.2015.11.21', '11', 'SELOTAMBAK UTARA', '21', '04/05', '2015', 'SELOTAMBAK', '16', 'KRATON', '14', 'PASURUAN'),
('672', '35', 'JAWA TIMUR', '35.14.16.2017.05.02', '05', 'KRAJAN', '02', '01/02', '2017', 'REJOSARI', '16', 'KRATON', '14', 'PASURUAN'),
('673', '35', 'JAWA TIMUR', '35.14.16.2017.12.19', '12', 'TALANGAN', '19', '04/03', '2017', 'REJOSARI', '16', 'KRATON', '14', 'PASURUAN'),
('674', '35', 'JAWA TIMUR', '35.14.16.2017.07.06', '07', 'KRAJAN 2', '06', '04/02', '2017', 'REJOSARI', '16', 'KRATON', '14', 'PASURUAN'),
('675', '35', 'JAWA TIMUR', '35.14.16.2017.06.04', '06', 'KRAJAN 1', '04', '02/02', '2017', 'REJOSARI', '16', 'KRATON', '14', 'PASURUAN'),
('676', '35', 'JAWA TIMUR', '35.14.07.2013.03.14', '03', 'KARANGPOH', '14', '01/03', '2013', 'KLUWUT', '07', 'WONOREJO', '14', 'PASURUAN'),
('677', '35', 'JAWA TIMUR', '35.14.16.2017.05.01', '05', 'KRAJAN', '01', '01/01', '2017', 'REJOSARI', '16', 'KRATON', '14', 'PASURUAN'),
('678', '35', 'JAWA TIMUR', '35.14.16.2024.01.12', '01', 'BENDUNGAN', '12', '03/02', '2024', 'BENDUNGAN', '16', 'KRATON', '14', 'PASURUAN'),
('679', '35', 'JAWA TIMUR', '35.14.16.2017.05.02', '05', 'KRAJAN', '02', '02/02', '2017', 'REJOSARI', '16', 'KRATON', '14', 'PASURUAN'),
('680', '35', 'JAWA TIMUR', '35.14.16.2017.07.05', '07', 'KRAJAN 2', '05', '02/01', '2017', 'REJOSARI', '16', 'KRATON', '14', 'PASURUAN'),
('681', '35', 'JAWA TIMUR', '35.14.16.2017.12.19', '12', 'TALANGAN', '19', '02/03', '2017', 'REJOSARI', '16', 'KRATON', '14', 'PASURUAN'),
('682', '35', 'JAWA TIMUR', '35.14.16.2017.06.03', '06', 'KRAJAN 1', '03', '02/01', '2017', 'REJOSARI', '16', 'KRATON', '14', 'PASURUAN'),
('683', '35', 'JAWA TIMUR', '35.14.16.2016.02.13', '02', 'CURAH JARAK', '13', '03/03', '2016', 'CURAH DUKUH', '16', 'KRATON', '14', 'PASURUAN'),
('684', '35', 'JAWA TIMUR', '35.14.16.2015.10.20', '10', 'SELOTAMBAK', '20', '07/04', '2015', 'SELOTAMBAK', '16', 'KRATON', '14', 'PASURUAN'),
('685', '35', 'JAWA TIMUR', '35.14.16.2017.04.06', '04', 'KEDUNGREJO', '06', '04/04', '2017', 'REJOSARI', '16', 'KRATON', '14', 'PASURUAN'),
('686', '35', 'JAWA TIMUR', '35.14.16.2017.05.02', '05', 'KRAJAN', '02', '03/02', '2017', 'REJOSARI', '16', 'KRATON', '14', 'PASURUAN'),
('687', '35', 'JAWA TIMUR', '35.14.06.2006.08.15', '08', 'LOROKAN UTARA', '15', '02/01', '2006', 'LOROKAN', '06', 'KEJAYAN', '14', 'PASURUAN'),
('688', '35', 'JAWA TIMUR', '35.14.16.2017.09.16', '09', 'PAYAMAN', '16', '01/05', '2017', 'REJOSARI', '16', 'KRATON', '14', 'PASURUAN');

-- --------------------------------------------------------
-- Structure for table `alquran`
-- --------------------------------------------------------

DROP TABLE IF EXISTS `alquran`;
CREATE TABLE `alquran` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(50) DEFAULT NULL,
  `nim` varchar(50) DEFAULT NULL,
  `no_bukti` varchar(50) DEFAULT NULL,
  `tglmasehi` date DEFAULT NULL,
  `tgl` date DEFAULT NULL,
  `no_kls` varchar(50) DEFAULT NULL,
  `tahun` varchar(50) DEFAULT NULL,
  `kewajiban` double DEFAULT 0,
  `bayar` double DEFAULT 0,
  `keterangan` varchar(100) DEFAULT NULL,
  `username` varchar(100) DEFAULT NULL,
  `koreksi` varchar(100) DEFAULT NULL,
  `rekGab` varchar(50) GENERATED ALWAYS AS (concat(`id`,'.',`tahun`)) STORED,
  `tglsystem` timestamp NULL DEFAULT current_timestamp(),
  `kode` int(3) GENERATED ALWAYS AS (substr(`id`,1,3)) STORED,
  PRIMARY KEY (`no`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=246 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

-- Dumping data for table `alquran`
-- Records: 10
-- --------------------------------------------------------

INSERT INTO `alquran` (`no`, `id`, `nim`, `no_bukti`, `tglmasehi`, `tgl`, `no_kls`, `tahun`, `kewajiban`, `bayar`, `keterangan`, `username`, `koreksi`, `rekGab`, `tglsystem`, `kode`) VALUES
('236', '101.000093', '002193', 'AQ10100220251106090116000', '1447-05-01', '2025-11-06', '5', '1446-1447', '45000', '0', 'Tagihan alquran', 'Ipul', 'Ipul', '101.000093.1446-1447', '2025-11-06 09:01:16', '101'),
('237', '101.000094', '002119', 'AQ10100220251106090116001', '1447-05-01', '2025-11-06', '5', '1446-1447', '45000', '0', 'Tagihan alquran', 'Ipul', 'Ipul', '101.000094.1446-1447', '2025-11-06 09:01:16', '101'),
('238', '101.000095', '006125', 'AQ10100220251106090116002', '1447-05-01', '2025-11-06', '5', '1446-1447', '45000', '0', 'Tagihan alquran', 'Ipul', 'Ipul', '101.000095.1446-1447', '2025-11-06 09:01:16', '101'),
('239', '101.000096', '002116', 'AQ10100220251106090116003', '1447-05-01', '2025-11-06', '5', '1446-1447', '45000', '0', 'Tagihan alquran', 'Ipul', 'Ipul', '101.000096.1446-1447', '2025-11-06 09:01:16', '101'),
('240', '101.000097', '002118', 'AQ10100220251106090116004', '1447-05-01', '2025-11-06', '5', '1446-1447', '45000', '0', 'Tagihan alquran', 'Ipul', 'Ipul', '101.000097.1446-1447', '2025-11-06 09:01:16', '101'),
('241', '101.000098', '002112', 'AQ10100220251106090116005', '1447-05-01', '2025-11-06', '5', '1446-1447', '45000', '0', 'Tagihan alquran', 'Ipul', 'Ipul', '101.000098.1446-1447', '2025-11-06 09:01:16', '101'),
('242', '101.000099', '002121', 'AQ10100220251106090116006', '1447-05-01', '2025-11-06', '5', '1446-1447', '45000', '0', 'Tagihan alquran', 'Ipul', 'Ipul', '101.000099.1446-1447', '2025-11-06 09:01:16', '101'),
('243', '101.000100', '002114', 'AQ10100220251106090116007', '1447-05-01', '2025-11-06', '5', '1446-1447', '45000', '0', 'Tagihan alquran', 'Ipul', 'Ipul', '101.000100.1446-1447', '2025-11-06 09:01:16', '101'),
('244', '101.000101', '002104', 'AQ10100220251106090116008', '1447-05-01', '2025-11-06', '5', '1446-1447', '45000', '0', 'Tagihan alquran', 'Ipul', 'Ipul', '101.000101.1446-1447', '2025-11-06 09:01:16', '101'),
('245', '101.000102', '002110', 'AQ10100220251106090116009', '1447-05-01', '2025-11-06', '5', '1446-1447', '45000', '0', 'Tagihan alquran', 'Ipul', 'Ipul', '101.000102.1446-1447', '2025-11-06 09:01:16', '101');

-- --------------------------------------------------------
-- Structure for table `angsuran`
-- --------------------------------------------------------

DROP TABLE IF EXISTS `angsuran`;
CREATE TABLE `angsuran` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `rekening` varchar(50) DEFAULT NULL,
  `no_bukti` varchar(50) DEFAULT NULL,
  `tgl` date DEFAULT NULL,
  `plafond` int(11) NOT NULL,
  `pokok` double NOT NULL,
  `margin` double NOT NULL,
  `keterangan` varchar(100) DEFAULT NULL,
  `username` varchar(100) DEFAULT NULL,
  `tglsystem` timestamp NULL DEFAULT current_timestamp(),
  `tglAuto` date DEFAULT current_timestamp(),
  `carabayar` enum('t','j','a') DEFAULT NULL,
  `kode` varchar(3) GENERATED ALWAYS AS (substr(`rekening`,1,3)) STORED,
  PRIMARY KEY (`no`)
) ENGINE=MyISAM AUTO_INCREMENT=33244 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

-- No data found for table `angsuran`

-- --------------------------------------------------------
-- Structure for table `bukubesar`
-- --------------------------------------------------------

DROP TABLE IF EXISTS `bukubesar`;
CREATE TABLE `bukubesar` (
  `id_jurnal` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `no_bukti` varchar(50) NOT NULL DEFAULT '0',
  `tanggal` date DEFAULT NULL,
  `kode_akun` varchar(20) NOT NULL,
  `kode` varchar(3) NOT NULL,
  `keterangan` varchar(255) NOT NULL,
  `debet` double NOT NULL DEFAULT 0,
  `kredit` double NOT NULL DEFAULT 0,
  `username` varchar(255) NOT NULL,
  `tglsystem` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_jurnal`)
) ENGINE=InnoDB AUTO_INCREMENT=18511 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

-- Dumping data for table `bukubesar`
-- Records: 18240
-- --------------------------------------------------------

INSERT INTO `bukubesar` (`id_jurnal`, `no_bukti`, `tanggal`, `kode_akun`, `kode`, `keterangan`, `debet`, `kredit`, `username`, `tglsystem`) VALUES
('1', 'KM10100220250425215753', '1446-10-26', '1.100.10', '101', 'M. ADIBIL ARIKIN KELAS SIFIR B', '20000', '0', 'Ipul', '2025-04-26 04:58:16'),
('2', 'KM10100220250425215753', '1446-10-26', '4.400.10', '101', 'M. ADIBIL ARIKIN KELAS SIFIR B', '0', '20000', 'Ipul', '2025-04-26 04:58:16'),
('3', 'KM10100220250425220056', '1446-10-26', '1.100.10', '101', 'KAS BON ke INDUK IBTIDAIYAH', '8339000', '0', 'Ipul', '2025-04-26 05:02:43'),
('4', 'KM10100220250425220056', '1446-10-26', '2.310.10', '101', 'KAS BON ke INDUK IBTIDAIYAH', '0', '8339000', 'Ipul', '2025-04-26 05:02:43'),
('5', 'KM10100220250426120742', '1446-10-27', '1.100.10', '101', 'KAS BON 20 Kitab Ghorib Ke Induk Ibtidaiyah', '140000', '0', 'Ipul', '2025-04-26 19:08:12'),
('6', 'KM10100220250426120742', '1446-10-27', '2.310.10', '101', 'KAS BON 20 Kitab Ghorib Ke Induk Ibtidaiyah', '0', '140000', 'Ipul', '2025-04-26 19:08:12'),
('7', 'KK10100320250426152946', '1446-10-27', '5.520.42', '101', 'Beli cilok', '6000', '0', 'Chuwez', '2025-04-26 22:30:33'),
('8', 'KK10100320250426152946', '1446-10-27', '1.100.10', '101', 'Beli cilok', '0', '6000', 'Chuwez', '2025-04-26 22:30:33'),
('11', 'KM10100320250429132554', '1446-11-01', '1.100.10', '101', 'Uang Pendaftaran murid', '180000', '0', 'Chuwez', '2025-04-29 20:28:45'),
('12', 'KM10100320250429132554', '1446-11-01', '4.400.10', '101', 'Uang Pendaftaran murid', '0', '180000', 'Chuwez', '2025-04-29 20:28:45'),
('13', 'ST10100220250429063600', '1446-11-01', '1.100.10', '101', 'an.M. ALIFIN FIKRI', '3000', '0', 'Ipul', '2025-04-29 20:36:00'),
('14', 'ST10100220250429063600', '1446-11-01', '2.220.10', '101', 'an.M. ALIFIN FIKRI', '0', '3000', 'Ipul', '2025-04-29 20:36:00'),
('15', 'KK10100520250429152642', '1446-11-01', '5.520.42', '101', 'Beli cilok', '5000', '0', 'Arif', '2025-04-29 22:27:24'),
('16', 'KK10100520250429152642', '1446-11-01', '1.100.10', '101', 'Beli cilok', '0', '5000', 'Arif', '2025-04-29 22:27:24'),
('17', 'ST10100320250430073207', '1446-11-02', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '5000', '0', 'Chuwez', '2025-04-30 21:32:07'),
('18', 'ST10100320250430073207', '1446-11-02', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '5000', 'Chuwez', '2025-04-30 21:32:07'),
('19', 'ST10100320250430073258', '1446-11-02', '1.100.10', '101', 'an.MUHAMMAD NAZHIRUL ASROFI', '20000', '0', 'Chuwez', '2025-04-30 21:32:58'),
('20', 'ST10100320250430073258', '1446-11-02', '2.220.10', '101', 'an.MUHAMMAD NAZHIRUL ASROFI', '0', '20000', 'Chuwez', '2025-04-30 21:32:58'),
('21', 'ST10100320250430073354', '1446-11-02', '1.100.10', '101', 'an.NAURA BILADINA', '5000', '0', 'Chuwez', '2025-04-30 21:33:54'),
('22', 'ST10100320250430073354', '1446-11-02', '2.220.10', '101', 'an.NAURA BILADINA', '0', '5000', 'Chuwez', '2025-04-30 21:33:54'),
('23', 'ST10100320250430073431', '1446-11-02', '1.100.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '5000', '0', 'Chuwez', '2025-04-30 21:34:31'),
('24', 'ST10100320250430073431', '1446-11-02', '2.220.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '0', '5000', 'Chuwez', '2025-04-30 21:34:31'),
('25', 'ST10100320250430073508', '1446-11-02', '1.100.10', '101', 'an.HAIKAL SHOMADANI', '2000', '0', 'Chuwez', '2025-04-30 21:35:08'),
('26', 'ST10100320250430073508', '1446-11-02', '2.220.10', '101', 'an.HAIKAL SHOMADANI', '0', '2000', 'Chuwez', '2025-04-30 21:35:08'),
('27', 'ST10100320250430073630', '1446-11-02', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'Chuwez', '2025-04-30 21:36:30'),
('28', 'ST10100320250430073630', '1446-11-02', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'Chuwez', '2025-04-30 21:36:30'),
('29', 'ST10100320250430073707', '1446-11-02', '1.100.10', '101', 'an.AULIA AZZAHRA', '5000', '0', 'Chuwez', '2025-04-30 21:37:07'),
('30', 'ST10100320250430073707', '1446-11-02', '2.220.10', '101', 'an.AULIA AZZAHRA', '0', '5000', 'Chuwez', '2025-04-30 21:37:07'),
('31', 'ST10100320250430073838', '1446-11-02', '1.100.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '10000', '0', 'Chuwez', '2025-04-30 21:38:38'),
('32', 'ST10100320250430073838', '1446-11-02', '2.220.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '0', '10000', 'Chuwez', '2025-04-30 21:38:38'),
('33', 'ST10100320250430073940', '1446-11-02', '1.100.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '10000', '0', 'Chuwez', '2025-04-30 21:39:40'),
('34', 'ST10100320250430073940', '1446-11-02', '2.220.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '0', '10000', 'Chuwez', '2025-04-30 21:39:40'),
('35', 'ST10100320250430074036', '1446-11-02', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'Chuwez', '2025-04-30 21:40:36'),
('36', 'ST10100320250430074036', '1446-11-02', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'Chuwez', '2025-04-30 21:40:36'),
('37', 'ST10100320250430074226', '1446-11-02', '1.100.10', '101', 'an.NAILATUN NIAMI', '10000', '0', 'Chuwez', '2025-04-30 21:42:26'),
('38', 'ST10100320250430074226', '1446-11-02', '2.220.10', '101', 'an.NAILATUN NIAMI', '0', '10000', 'Chuwez', '2025-04-30 21:42:29'),
('39', 'ST10100320250430074337', '1446-11-02', '1.100.10', '101', 'an.UBAIDAH', '10000', '0', 'Chuwez', '2025-04-30 21:43:37'),
('40', 'ST10100320250430074337', '1446-11-02', '2.220.10', '101', 'an.UBAIDAH', '0', '10000', 'Chuwez', '2025-04-30 21:43:37'),
('41', 'ST10100320250430074424', '1446-11-02', '1.100.10', '101', 'an.RAISA ANNISA', '5000', '0', 'Chuwez', '2025-04-30 21:44:24'),
('42', 'ST10100320250430074424', '1446-11-02', '2.220.10', '101', 'an.RAISA ANNISA', '0', '5000', 'Chuwez', '2025-04-30 21:44:24'),
('43', 'ST10100320250430074455', '1446-11-02', '1.100.10', '101', 'an.MUHAMMAD ALWI', '5000', '0', 'Chuwez', '2025-04-30 21:44:55'),
('44', 'ST10100320250430074455', '1446-11-02', '2.220.10', '101', 'an.MUHAMMAD ALWI', '0', '5000', 'Chuwez', '2025-04-30 21:44:55'),
('45', 'ST10100320250430074536', '1446-11-02', '1.100.10', '101', 'an.ROHMATULLOH', '5000', '0', 'Chuwez', '2025-04-30 21:45:36'),
('46', 'ST10100320250430074536', '1446-11-02', '2.220.10', '101', 'an.ROHMATULLOH', '0', '5000', 'Chuwez', '2025-04-30 21:45:36'),
('47', 'ST10100320250430074622', '1446-11-02', '1.100.10', '101', 'an.FAIZAH NURUL LITA', '10000', '0', 'Chuwez', '2025-04-30 21:46:22'),
('48', 'ST10100320250430074622', '1446-11-02', '2.220.10', '101', 'an.FAIZAH NURUL LITA', '0', '10000', 'Chuwez', '2025-04-30 21:46:22'),
('49', 'ST10100320250430074650', '1446-11-02', '1.100.10', '101', 'an.ROFIQOTUS SARIROH', '5000', '0', 'Chuwez', '2025-04-30 21:46:50'),
('50', 'ST10100320250430074650', '1446-11-02', '2.220.10', '101', 'an.ROFIQOTUS SARIROH', '0', '5000', 'Chuwez', '2025-04-30 21:46:50'),
('51', 'ST10100320250430074733', '1446-11-02', '1.100.10', '101', 'an.AHMAD ADITIYA', '5000', '0', 'Chuwez', '2025-04-30 21:47:33'),
('52', 'ST10100320250430074733', '1446-11-02', '2.220.10', '101', 'an.AHMAD ADITIYA', '0', '5000', 'Chuwez', '2025-04-30 21:47:33'),
('53', 'ST10100320250430074804', '1446-11-02', '1.100.10', '101', 'an.DIANA RIFQOTUL QOLBI', '5000', '0', 'Chuwez', '2025-04-30 21:48:04'),
('54', 'ST10100320250430074804', '1446-11-02', '2.220.10', '101', 'an.DIANA RIFQOTUL QOLBI', '0', '5000', 'Chuwez', '2025-04-30 21:48:04'),
('55', 'ST10100320250430075001', '1446-11-02', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '50000', '0', 'Chuwez', '2025-04-30 21:50:01'),
('56', 'ST10100320250430075001', '1446-11-02', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '50000', 'Chuwez', '2025-04-30 21:50:01'),
('57', 'ST10100320250430075029', '1446-11-02', '1.100.10', '101', 'an.M. DESTRA MAULANA', '30000', '0', 'Chuwez', '2025-04-30 21:50:29'),
('58', 'ST10100320250430075029', '1446-11-02', '2.220.10', '101', 'an.M. DESTRA MAULANA', '0', '30000', 'Chuwez', '2025-04-30 21:50:29'),
('59', 'ST10100320250430075110', '1446-11-02', '1.100.10', '101', 'an.AISYAH', '2000', '0', 'Chuwez', '2025-04-30 21:51:10'),
('60', 'ST10100320250430075110', '1446-11-02', '2.220.10', '101', 'an.AISYAH', '0', '2000', 'Chuwez', '2025-04-30 21:51:10'),
('61', 'ST10100320250430075145', '1446-11-02', '1.100.10', '101', 'an.AZKA AUFARIL MINAN', '20000', '0', 'Chuwez', '2025-04-30 21:51:45'),
('62', 'ST10100320250430075145', '1446-11-02', '2.220.10', '101', 'an.AZKA AUFARIL MINAN', '0', '20000', 'Chuwez', '2025-04-30 21:51:45'),
('63', 'ST10100320250430075220', '1446-11-02', '1.100.10', '101', 'an.IFTITAHUL IZZA', '150000', '0', 'Chuwez', '2025-04-30 21:52:20'),
('64', 'ST10100320250430075220', '1446-11-02', '2.220.10', '101', 'an.IFTITAHUL IZZA', '0', '150000', 'Chuwez', '2025-04-30 21:52:20'),
('65', 'ST10100320250430075259', '1446-11-02', '1.100.10', '101', 'an.LAILATUL MAGHFIROH', '5000', '0', 'Chuwez', '2025-04-30 21:52:59'),
('66', 'ST10100320250430075259', '1446-11-02', '2.220.10', '101', 'an.LAILATUL MAGHFIROH', '0', '5000', 'Chuwez', '2025-04-30 21:52:59'),
('67', 'ST10100320250430080001', '1446-11-02', '1.100.10', '101', 'an.ALFI NURDIANA', '50000', '0', 'Chuwez', '2025-04-30 22:00:01'),
('68', 'ST10100320250430080001', '1446-11-02', '2.220.10', '101', 'an.ALFI NURDIANA', '0', '50000', 'Chuwez', '2025-04-30 22:00:01'),
('69', 'ST10100320250430080041', '1446-11-02', '1.100.10', '101', 'an.MASRUROTUL MAULUDIYAH', '5000', '0', 'Chuwez', '2025-04-30 22:00:41'),
('70', 'ST10100320250430080041', '1446-11-02', '2.220.10', '101', 'an.MASRUROTUL MAULUDIYAH', '0', '5000', 'Chuwez', '2025-04-30 22:00:41'),
('71', 'ST10100320250430080129', '1446-11-02', '1.100.10', '101', 'an.AHMAD SYAHRU ROMADHONI', '10000', '0', 'Chuwez', '2025-04-30 22:01:29'),
('72', 'ST10100320250430080129', '1446-11-02', '2.220.10', '101', 'an.AHMAD SYAHRU ROMADHONI', '0', '10000', 'Chuwez', '2025-04-30 22:01:29'),
('73', 'ST10100320250430080410', '1446-11-02', '1.100.10', '101', 'an.ABDUL HAMID', '5000', '0', 'Chuwez', '2025-04-30 22:04:10'),
('74', 'ST10100320250430080410', '1446-11-02', '2.220.10', '101', 'an.ABDUL HAMID', '0', '5000', 'Chuwez', '2025-04-30 22:04:10'),
('75', 'ST10100320250430080526', '1446-11-02', '1.100.10', '101', 'an.HIKMIAH PUTRI NIKMATUNNAFILAH', '5000', '0', 'Chuwez', '2025-04-30 22:05:26'),
('76', 'ST10100320250430080526', '1446-11-02', '2.220.10', '101', 'an.HIKMIAH PUTRI NIKMATUNNAFILAH', '0', '5000', 'Chuwez', '2025-04-30 22:05:26'),
('77', 'ST10100320250430080609', '1446-11-02', '1.100.10', '101', 'an.WARDATUL JANNAH', '7000', '0', 'Chuwez', '2025-04-30 22:06:09'),
('78', 'ST10100320250430080609', '1446-11-02', '2.220.10', '101', 'an.WARDATUL JANNAH', '0', '7000', 'Chuwez', '2025-04-30 22:06:09'),
('79', 'ST10100320250430080640', '1446-11-02', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '10000', '0', 'Chuwez', '2025-04-30 22:06:40'),
('80', 'ST10100320250430080640', '1446-11-02', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '10000', 'Chuwez', '2025-04-30 22:06:40'),
('81', 'ST10100320250430080717', '1446-11-02', '1.100.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '10000', '0', 'Chuwez', '2025-04-30 22:07:17'),
('82', 'ST10100320250430080717', '1446-11-02', '2.220.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '0', '10000', 'Chuwez', '2025-04-30 22:07:17'),
('83', 'ST10100320250430080759', '1446-11-02', '1.100.10', '101', 'an.SITI ATHIUR ROHMAH', '5000', '0', 'Chuwez', '2025-04-30 22:07:59'),
('84', 'ST10100320250430080759', '1446-11-02', '2.220.10', '101', 'an.SITI ATHIUR ROHMAH', '0', '5000', 'Chuwez', '2025-04-30 22:07:59'),
('85', 'ST10100320250430080850', '1446-11-02', '1.100.10', '101', 'an.NABILATUN NISAUL UMMAH', '50000', '0', 'Chuwez', '2025-04-30 22:08:50'),
('86', 'ST10100320250430080850', '1446-11-02', '2.220.10', '101', 'an.NABILATUN NISAUL UMMAH', '0', '50000', 'Chuwez', '2025-04-30 22:08:50'),
('87', 'ST10100320250430080930', '1446-11-02', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Chuwez', '2025-04-30 22:09:30'),
('88', 'ST10100320250430080930', '1446-11-02', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Chuwez', '2025-04-30 22:09:30'),
('89', 'ST10100320250430081005', '1446-11-02', '1.100.10', '101', 'an.IZZA BILLAH', '10000', '0', 'Chuwez', '2025-04-30 22:10:05'),
('90', 'ST10100320250430081005', '1446-11-02', '2.220.10', '101', 'an.IZZA BILLAH', '0', '10000', 'Chuwez', '2025-04-30 22:10:05'),
('91', 'ST10100320250430081044', '1446-11-02', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '10000', '0', 'Chuwez', '2025-04-30 22:10:44'),
('92', 'ST10100320250430081044', '1446-11-02', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '10000', 'Chuwez', '2025-04-30 22:10:44'),
('93', 'ST10100320250430081132', '1446-11-02', '1.100.10', '101', 'an.RAUDHOTUL JANNAH', '20000', '0', 'Chuwez', '2025-04-30 22:11:32'),
('94', 'ST10100320250430081132', '1446-11-02', '2.220.10', '101', 'an.RAUDHOTUL JANNAH', '0', '20000', 'Chuwez', '2025-04-30 22:11:32'),
('95', 'ST10100320250430081336', '1446-11-02', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '2000', '0', 'Chuwez', '2025-04-30 22:13:36'),
('96', 'ST10100320250430081336', '1446-11-02', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '2000', 'Chuwez', '2025-04-30 22:13:36'),
('97', 'ST10100320250430081455', '1446-11-02', '1.100.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '5000', '0', 'Chuwez', '2025-04-30 22:14:55'),
('98', 'ST10100320250430081455', '1446-11-02', '2.220.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '0', '5000', 'Chuwez', '2025-04-30 22:14:55'),
('99', 'ST10100320250430081534', '1446-11-02', '1.100.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '5000', '0', 'Chuwez', '2025-04-30 22:15:34'),
('100', 'ST10100320250430081534', '1446-11-02', '2.220.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '0', '5000', 'Chuwez', '2025-04-30 22:15:34'),
('101', 'ST10100320250430081618', '1446-11-02', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '25000', '0', 'Chuwez', '2025-04-30 22:16:18'),
('102', 'ST10100320250430081618', '1446-11-02', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '25000', 'Chuwez', '2025-04-30 22:16:18'),
('103', 'ST10100320250430081651', '1446-11-02', '1.100.10', '101', 'an.SINDI RAISA PUTRI', '10000', '0', 'Chuwez', '2025-04-30 22:16:51'),
('104', 'ST10100320250430081651', '1446-11-02', '2.220.10', '101', 'an.SINDI RAISA PUTRI', '0', '10000', 'Chuwez', '2025-04-30 22:16:51'),
('105', 'ST10100320250430081754', '1446-11-02', '1.100.10', '101', 'an.M. ROFIQ', '10000', '0', 'Chuwez', '2025-04-30 22:17:54'),
('106', 'ST10100320250430081754', '1446-11-02', '2.220.10', '101', 'an.M. ROFIQ', '0', '10000', 'Chuwez', '2025-04-30 22:17:54'),
('107', 'ST10100320250430081822', '1446-11-02', '1.100.10', '101', 'an.AKHMAD FIKRI HAIKAL', '25000', '0', 'Chuwez', '2025-04-30 22:18:22'),
('108', 'ST10100320250430081822', '1446-11-02', '2.220.10', '101', 'an.AKHMAD FIKRI HAIKAL', '0', '25000', 'Chuwez', '2025-04-30 22:18:22'),
('109', 'ST10100320250430081855', '1446-11-02', '1.100.10', '101', 'an.BILQIS THALIA HASNA', '250000', '0', 'Chuwez', '2025-04-30 22:18:55'),
('110', 'ST10100320250430081855', '1446-11-02', '2.220.10', '101', 'an.BILQIS THALIA HASNA', '0', '250000', 'Chuwez', '2025-04-30 22:18:55'),
('111', 'ST10100320250430082011', '1446-11-02', '1.100.10', '101', 'an.ZAKIYATUL UMMAH', '2000', '0', 'Chuwez', '2025-04-30 22:20:11'),
('112', 'ST10100320250430082011', '1446-11-02', '2.220.10', '101', 'an.ZAKIYATUL UMMAH', '0', '2000', 'Chuwez', '2025-04-30 22:20:11'),
('113', 'ST10100320250430082100', '1446-11-02', '1.100.10', '101', 'an.MUHAMMAD YAHYA SYAKARUDDIN', '5000', '0', 'Chuwez', '2025-04-30 22:21:00'),
('114', 'ST10100320250430082100', '1446-11-02', '2.220.10', '101', 'an.MUHAMMAD YAHYA SYAKARUDDIN', '0', '5000', 'Chuwez', '2025-04-30 22:21:00'),
('115', 'ST10100320250430082141', '1446-11-02', '1.100.10', '101', 'an.AFANDI', '5000', '0', 'Chuwez', '2025-04-30 22:21:41'),
('116', 'ST10100320250430082141', '1446-11-02', '2.220.10', '101', 'an.AFANDI', '0', '5000', 'Chuwez', '2025-04-30 22:21:41'),
('117', 'ST10100320250430082215', '1446-11-02', '1.100.10', '101', 'an.ANA SALSABILA', '100000', '0', 'Chuwez', '2025-04-30 22:22:15'),
('118', 'ST10100320250430082215', '1446-11-02', '2.220.10', '101', 'an.ANA SALSABILA', '0', '100000', 'Chuwez', '2025-04-30 22:22:15'),
('119', 'ST10100320250430082319', '1446-11-02', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '5000', '0', 'Chuwez', '2025-04-30 22:23:19'),
('120', 'ST10100320250430082319', '1446-11-02', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '5000', 'Chuwez', '2025-04-30 22:23:19'),
('121', 'ST10100320250430082347', '1446-11-02', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '2000', '0', 'Chuwez', '2025-04-30 22:23:47'),
('122', 'ST10100320250430082347', '1446-11-02', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '2000', 'Chuwez', '2025-04-30 22:23:47'),
('123', 'ST10100320250430082410', '1446-11-02', '1.100.10', '101', 'an.MUHAMMAD KHOIRON', '5000', '0', 'Chuwez', '2025-04-30 22:24:10'),
('124', 'ST10100320250430082410', '1446-11-02', '2.220.10', '101', 'an.MUHAMMAD KHOIRON', '0', '5000', 'Chuwez', '2025-04-30 22:24:10'),
('125', 'ST10100320250430082441', '1446-11-02', '1.100.10', '101', 'an.MUHAMMAD KANZUL KAROMI', '10000', '0', 'Chuwez', '2025-04-30 22:24:41'),
('126', 'ST10100320250430082441', '1446-11-02', '2.220.10', '101', 'an.MUHAMMAD KANZUL KAROMI', '0', '10000', 'Chuwez', '2025-04-30 22:24:41'),
('127', 'ST10100320250430082510', '1446-11-02', '1.100.10', '101', 'an.ACH. JUNAIDI', '5000', '0', 'Chuwez', '2025-04-30 22:25:10'),
('128', 'ST10100320250430082510', '1446-11-02', '2.220.10', '101', 'an.ACH. JUNAIDI', '0', '5000', 'Chuwez', '2025-04-30 22:25:10'),
('129', 'ST10100320250430082559', '1446-11-02', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '5000', '0', 'Chuwez', '2025-04-30 22:25:59'),
('130', 'ST10100320250430082559', '1446-11-02', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '5000', 'Chuwez', '2025-04-30 22:25:59'),
('131', 'KM10100320250430153602', '1446-11-02', '1.100.10', '101', 'Beli tabungan', '2000', '0', 'Chuwez', '2025-04-30 22:36:35'),
('132', 'KM10100320250430153602', '1446-11-02', '4.400.21', '101', 'Beli tabungan', '0', '2000', 'Chuwez', '2025-04-30 22:36:35'),
('133', 'ST10100320250501080242', '1446-11-03', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '5000', '0', 'Chuwez', '2025-05-01 22:02:42'),
('134', 'ST10100320250501080242', '1446-11-03', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '5000', 'Chuwez', '2025-05-01 22:02:42'),
('135', 'ST10100320250501080339', '1446-11-03', '1.100.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '10000', '0', 'Chuwez', '2025-05-01 22:03:39'),
('136', 'ST10100320250501080339', '1446-11-03', '2.220.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '0', '10000', 'Chuwez', '2025-05-01 22:03:39'),
('137', 'ST10100320250501080411', '1446-11-03', '1.100.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '5000', '0', 'Chuwez', '2025-05-01 22:04:11'),
('138', 'ST10100320250501080411', '1446-11-03', '2.220.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '0', '5000', 'Chuwez', '2025-05-01 22:04:11'),
('139', 'ST10100320250501080441', '1446-11-03', '1.100.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '5000', '0', 'Chuwez', '2025-05-01 22:04:41'),
('140', 'ST10100320250501080441', '1446-11-03', '2.220.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '0', '5000', 'Chuwez', '2025-05-01 22:04:41'),
('141', 'ST10100320250501080512', '1446-11-03', '1.100.10', '101', 'an.NAURA BILADINA', '3000', '0', 'Chuwez', '2025-05-01 22:05:12'),
('142', 'ST10100320250501080512', '1446-11-03', '2.220.10', '101', 'an.NAURA BILADINA', '0', '3000', 'Chuwez', '2025-05-01 22:05:12'),
('143', 'ST10100320250501080554', '1446-11-03', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'Chuwez', '2025-05-01 22:05:54'),
('144', 'ST10100320250501080554', '1446-11-03', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'Chuwez', '2025-05-01 22:05:54'),
('145', 'ST10100320250501080619', '1446-11-03', '1.100.10', '101', 'an.HAIKAL SHOMADANI', '2000', '0', 'Chuwez', '2025-05-01 22:06:19'),
('146', 'ST10100320250501080619', '1446-11-03', '2.220.10', '101', 'an.HAIKAL SHOMADANI', '0', '2000', 'Chuwez', '2025-05-01 22:06:19'),
('147', 'ST10100320250501080724', '1446-11-03', '1.100.10', '101', 'an.MOCH.ANDIE FIRMANSYAH', '2000', '0', 'Chuwez', '2025-05-01 22:07:24'),
('148', 'ST10100320250501080724', '1446-11-03', '2.220.10', '101', 'an.MOCH.ANDIE FIRMANSYAH', '0', '2000', 'Chuwez', '2025-05-01 22:07:24'),
('149', 'ST10100320250501080753', '1446-11-03', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'Chuwez', '2025-05-01 22:07:53'),
('150', 'ST10100320250501080753', '1446-11-03', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'Chuwez', '2025-05-01 22:07:53'),
('151', 'ST10100320250501080824', '1446-11-03', '1.100.10', '101', 'an.MUHAMMAD ARDIANSYAH', '5000', '0', 'Chuwez', '2025-05-01 22:08:24'),
('152', 'ST10100320250501080824', '1446-11-03', '2.220.10', '101', 'an.MUHAMMAD ARDIANSYAH', '0', '5000', 'Chuwez', '2025-05-01 22:08:24'),
('153', 'ST10100320250501080859', '1446-11-03', '1.100.10', '101', 'an.M. ABDIL ARIKIN', '7000', '0', 'Chuwez', '2025-05-01 22:08:59'),
('154', 'ST10100320250501080859', '1446-11-03', '2.220.10', '101', 'an.M. ABDIL ARIKIN', '0', '7000', 'Chuwez', '2025-05-01 22:08:59'),
('155', 'ST10100320250501080929', '1446-11-03', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '10000', '0', 'Chuwez', '2025-05-01 22:09:29'),
('156', 'ST10100320250501080929', '1446-11-03', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '10000', 'Chuwez', '2025-05-01 22:09:29'),
('157', 'ST10100320250501081000', '1446-11-03', '1.100.10', '101', 'an.RAISA ANNISA', '5000', '0', 'Chuwez', '2025-05-01 22:10:00'),
('158', 'ST10100320250501081000', '1446-11-03', '2.220.10', '101', 'an.RAISA ANNISA', '0', '5000', 'Chuwez', '2025-05-01 22:10:00'),
('159', 'ST10100320250501081030', '1446-11-03', '1.100.10', '101', 'an.UBAIDAH', '10000', '0', 'Chuwez', '2025-05-01 22:10:30'),
('160', 'ST10100320250501081030', '1446-11-03', '2.220.10', '101', 'an.UBAIDAH', '0', '10000', 'Chuwez', '2025-05-01 22:10:30'),
('161', 'ST10100320250501081058', '1446-11-03', '1.100.10', '101', 'an.SITI ISTIFAIYAH', '5000', '0', 'Chuwez', '2025-05-01 22:10:58'),
('162', 'ST10100320250501081058', '1446-11-03', '2.220.10', '101', 'an.SITI ISTIFAIYAH', '0', '5000', 'Chuwez', '2025-05-01 22:10:58'),
('163', 'ST10100320250501081123', '1446-11-03', '1.100.10', '101', 'an.MARIATUL QIBTIYAH', '4000', '0', 'Chuwez', '2025-05-01 22:11:23'),
('164', 'ST10100320250501081123', '1446-11-03', '2.220.10', '101', 'an.MARIATUL QIBTIYAH', '0', '4000', 'Chuwez', '2025-05-01 22:11:23'),
('165', 'ST10100320250501081150', '1446-11-03', '1.100.10', '101', 'an.ADIBA QONITA', '5000', '0', 'Chuwez', '2025-05-01 22:11:50'),
('166', 'ST10100320250501081150', '1446-11-03', '2.220.10', '101', 'an.ADIBA QONITA', '0', '5000', 'Chuwez', '2025-05-01 22:11:51'),
('167', 'ST10100320250501081251', '1446-11-03', '1.100.10', '101', 'an.FAIZAH NURUL LITA', '5000', '0', 'Chuwez', '2025-05-01 22:12:51'),
('168', 'ST10100320250501081251', '1446-11-03', '2.220.10', '101', 'an.FAIZAH NURUL LITA', '0', '5000', 'Chuwez', '2025-05-01 22:12:51'),
('169', 'ST10100320250501081426', '1446-11-03', '1.100.10', '101', 'an.AISYAH', '2000', '0', 'Chuwez', '2025-05-01 22:14:26'),
('170', 'ST10100320250501081426', '1446-11-03', '2.220.10', '101', 'an.AISYAH', '0', '2000', 'Chuwez', '2025-05-01 22:14:26'),
('171', 'ST10100320250501081449', '1446-11-03', '1.100.10', '101', 'an.M. DESTRA MAULANA', '5000', '0', 'Chuwez', '2025-05-01 22:14:49'),
('172', 'ST10100320250501081449', '1446-11-03', '2.220.10', '101', 'an.M. DESTRA MAULANA', '0', '5000', 'Chuwez', '2025-05-01 22:14:49'),
('173', 'ST10100320250501081611', '1446-11-03', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '10000', '0', 'Chuwez', '2025-05-01 22:16:11'),
('174', 'ST10100320250501081611', '1446-11-03', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '10000', 'Chuwez', '2025-05-01 22:16:11'),
('175', 'ST10100320250501081631', '1446-11-03', '1.100.10', '101', 'an.DIANA RIFQOTUL QOLBI', '5000', '0', 'Chuwez', '2025-05-01 22:16:31'),
('176', 'ST10100320250501081631', '1446-11-03', '2.220.10', '101', 'an.DIANA RIFQOTUL QOLBI', '0', '5000', 'Chuwez', '2025-05-01 22:16:31'),
('177', 'ST10100320250501081721', '1446-11-03', '1.100.10', '101', 'an.KHOIRIYAH', '15000', '0', 'Chuwez', '2025-05-01 22:17:21'),
('178', 'ST10100320250501081721', '1446-11-03', '2.220.10', '101', 'an.KHOIRIYAH', '0', '15000', 'Chuwez', '2025-05-01 22:17:22'),
('179', 'ST10100320250501081752', '1446-11-03', '1.100.10', '101', 'an.WARDATUL JANNAH', '5000', '0', 'Chuwez', '2025-05-01 22:17:52'),
('180', 'ST10100320250501081752', '1446-11-03', '2.220.10', '101', 'an.WARDATUL JANNAH', '0', '5000', 'Chuwez', '2025-05-01 22:17:52'),
('181', 'ST10100320250501081813', '1446-11-03', '1.100.10', '101', 'an.DIYANAH KAMALIYAH', '5000', '0', 'Chuwez', '2025-05-01 22:18:13'),
('182', 'ST10100320250501081813', '1446-11-03', '2.220.10', '101', 'an.DIYANAH KAMALIYAH', '0', '5000', 'Chuwez', '2025-05-01 22:18:13'),
('183', 'ST10100320250501081835', '1446-11-03', '1.100.10', '101', 'an.M. FAHMI NURUL ANAM', '10000', '0', 'Chuwez', '2025-05-01 22:18:35'),
('184', 'ST10100320250501081835', '1446-11-03', '2.220.10', '101', 'an.M. FAHMI NURUL ANAM', '0', '10000', 'Chuwez', '2025-05-01 22:18:35'),
('185', 'ST10100320250501081903', '1446-11-03', '1.100.10', '101', 'an.ABDUL HAMID', '5000', '0', 'Chuwez', '2025-05-01 22:19:03'),
('186', 'ST10100320250501081903', '1446-11-03', '2.220.10', '101', 'an.ABDUL HAMID', '0', '5000', 'Chuwez', '2025-05-01 22:19:03'),
('187', 'ST10100320250501081944', '1446-11-03', '1.100.10', '101', 'an.SITI ATHIUR ROHMAH', '5000', '0', 'Chuwez', '2025-05-01 22:19:44'),
('188', 'ST10100320250501081944', '1446-11-03', '2.220.10', '101', 'an.SITI ATHIUR ROHMAH', '0', '5000', 'Chuwez', '2025-05-01 22:19:44'),
('189', 'ST10100320250501082115', '1446-11-03', '1.100.10', '101', 'an.SITI QURROTUL AINI', '2000', '0', 'Chuwez', '2025-05-01 22:21:15'),
('190', 'ST10100320250501082115', '1446-11-03', '2.220.10', '101', 'an.SITI QURROTUL AINI', '0', '2000', 'Chuwez', '2025-05-01 22:21:15'),
('191', 'ST10100320250501082251', '1446-11-03', '1.100.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '10000', '0', 'Chuwez', '2025-05-01 22:22:51'),
('192', 'ST10100320250501082251', '1446-11-03', '2.220.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '0', '10000', 'Chuwez', '2025-05-01 22:22:51'),
('193', 'ST10100320250501082311', '1446-11-03', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '10000', '0', 'Chuwez', '2025-05-01 22:23:11'),
('194', 'ST10100320250501082311', '1446-11-03', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '10000', 'Chuwez', '2025-05-01 22:23:11'),
('195', 'ST10100320250501082422', '1446-11-03', '1.100.10', '101', 'an.AHMAD SYAHRU ROMADHONI', '10000', '0', 'Chuwez', '2025-05-01 22:24:22'),
('196', 'ST10100320250501082422', '1446-11-03', '2.220.10', '101', 'an.AHMAD SYAHRU ROMADHONI', '0', '10000', 'Chuwez', '2025-05-01 22:24:22'),
('197', 'ST10100320250501082454', '1446-11-03', '1.100.10', '101', 'an.AHMAD RAFI SALIM', '5000', '0', 'Chuwez', '2025-05-01 22:24:54'),
('198', 'ST10100320250501082454', '1446-11-03', '2.220.10', '101', 'an.AHMAD RAFI SALIM', '0', '5000', 'Chuwez', '2025-05-01 22:24:54'),
('199', 'ST10100320250501082531', '1446-11-03', '1.100.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '10000', '0', 'Chuwez', '2025-05-01 22:25:31'),
('200', 'ST10100320250501082531', '1446-11-03', '2.220.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '0', '10000', 'Chuwez', '2025-05-01 22:25:31'),
('201', 'ST10100320250501082558', '1446-11-03', '1.100.10', '101', 'an.NABILATUN NISAUL UMMAH', '20000', '0', 'Chuwez', '2025-05-01 22:25:58'),
('202', 'ST10100320250501082558', '1446-11-03', '2.220.10', '101', 'an.NABILATUN NISAUL UMMAH', '0', '20000', 'Chuwez', '2025-05-01 22:25:58'),
('203', 'ST10100320250501082624', '1446-11-03', '1.100.10', '101', 'an.RAUDHOTUL JANNAH', '20000', '0', 'Chuwez', '2025-05-01 22:26:24'),
('204', 'ST10100320250501082624', '1446-11-03', '2.220.10', '101', 'an.RAUDHOTUL JANNAH', '0', '20000', 'Chuwez', '2025-05-01 22:26:24'),
('205', 'ST10100320250501082645', '1446-11-03', '1.100.10', '101', 'an.M. KAMALUDDIN', '10000', '0', 'Chuwez', '2025-05-01 22:26:45'),
('206', 'ST10100320250501082645', '1446-11-03', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '10000', 'Chuwez', '2025-05-01 22:26:45'),
('207', 'ST10100320250501082722', '1446-11-03', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '50000', '0', 'Chuwez', '2025-05-01 22:27:22'),
('208', 'ST10100320250501082722', '1446-11-03', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '50000', 'Chuwez', '2025-05-01 22:27:22'),
('209', 'ST10100320250501082750', '1446-11-03', '1.100.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '10000', '0', 'Chuwez', '2025-05-01 22:27:50'),
('210', 'ST10100320250501082750', '1446-11-03', '2.220.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '0', '10000', 'Chuwez', '2025-05-01 22:27:50'),
('211', 'ST10100320250501082811', '1446-11-03', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '2000', '0', 'Chuwez', '2025-05-01 22:28:11'),
('212', 'ST10100320250501082811', '1446-11-03', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '2000', 'Chuwez', '2025-05-01 22:28:11'),
('213', 'ST10100320250501082850', '1446-11-03', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Chuwez', '2025-05-01 22:28:50'),
('214', 'ST10100320250501082850', '1446-11-03', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Chuwez', '2025-05-01 22:28:50'),
('215', 'ST10100320250501083014', '1446-11-03', '1.100.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '20000', '0', 'Chuwez', '2025-05-01 22:30:14'),
('216', 'ST10100320250501083014', '1446-11-03', '2.220.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '0', '20000', 'Chuwez', '2025-05-01 22:30:14'),
('217', 'ST10100320250501083039', '1446-11-03', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '5000', '0', 'Chuwez', '2025-05-01 22:30:39'),
('218', 'ST10100320250501083039', '1446-11-03', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '5000', 'Chuwez', '2025-05-01 22:30:39'),
('219', 'ST10100320250501083220', '1446-11-03', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '25000', '0', 'Chuwez', '2025-05-01 22:32:20'),
('220', 'ST10100320250501083220', '1446-11-03', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '25000', 'Chuwez', '2025-05-01 22:32:20'),
('221', 'ST10100320250501083314', '1446-11-03', '1.100.10', '101', 'an.BILQIS THALIA HASNA', '100000', '0', 'Chuwez', '2025-05-01 22:33:14'),
('222', 'ST10100320250501083314', '1446-11-03', '2.220.10', '101', 'an.BILQIS THALIA HASNA', '0', '100000', 'Chuwez', '2025-05-01 22:33:15'),
('223', 'ST10100320250501083341', '1446-11-03', '1.100.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '10000', '0', 'Chuwez', '2025-05-01 22:33:41'),
('224', 'ST10100320250501083341', '1446-11-03', '2.220.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '0', '10000', 'Chuwez', '2025-05-01 22:33:41'),
('225', 'ST10100320250501083413', '1446-11-03', '1.100.10', '101', 'an.M. HAIKAL NASRULLOH', '10000', '0', 'Chuwez', '2025-05-01 22:34:13'),
('226', 'ST10100320250501083413', '1446-11-03', '2.220.10', '101', 'an.M. HAIKAL NASRULLOH', '0', '10000', 'Chuwez', '2025-05-01 22:34:13'),
('227', 'ST10100320250501083457', '1446-11-03', '1.100.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '20000', '0', 'Chuwez', '2025-05-01 22:34:57'),
('228', 'ST10100320250501083457', '1446-11-03', '2.220.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '0', '20000', 'Chuwez', '2025-05-01 22:34:57'),
('229', 'ST10100320250501083520', '1446-11-03', '1.100.10', '101', 'an.SINDI RAISA PUTRI', '10000', '0', 'Chuwez', '2025-05-01 22:35:20'),
('230', 'ST10100320250501083520', '1446-11-03', '2.220.10', '101', 'an.SINDI RAISA PUTRI', '0', '10000', 'Chuwez', '2025-05-01 22:35:20'),
('231', 'ST10100320250501083606', '1446-11-03', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '2000', '0', 'Chuwez', '2025-05-01 22:36:06'),
('232', 'ST10100320250501083606', '1446-11-03', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '2000', 'Chuwez', '2025-05-01 22:36:06'),
('233', 'ST10100320250501083625', '1446-11-03', '1.100.10', '101', 'an.M. ALIFIN FIKRI', '2000', '0', 'Chuwez', '2025-05-01 22:36:25'),
('234', 'ST10100320250501083625', '1446-11-03', '2.220.10', '101', 'an.M. ALIFIN FIKRI', '0', '2000', 'Chuwez', '2025-05-01 22:36:25'),
('235', 'ST10100320250501083650', '1446-11-03', '1.100.10', '101', 'an.MUHAMMAD KHOIRON', '5000', '0', 'Chuwez', '2025-05-01 22:36:50'),
('236', 'ST10100320250501083650', '1446-11-03', '2.220.10', '101', 'an.MUHAMMAD KHOIRON', '0', '5000', 'Chuwez', '2025-05-01 22:36:50'),
('237', 'ST10100320250501083710', '1446-11-03', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '5000', '0', 'Chuwez', '2025-05-01 22:37:10'),
('238', 'ST10100320250501083710', '1446-11-03', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '5000', 'Chuwez', '2025-05-01 22:37:10'),
('239', 'ST10100320250501083727', '1446-11-03', '1.100.10', '101', 'an.ROBIATUL ADAWIYAH', '5000', '0', 'Chuwez', '2025-05-01 22:37:27'),
('240', 'ST10100320250501083727', '1446-11-03', '2.220.10', '101', 'an.ROBIATUL ADAWIYAH', '0', '5000', 'Chuwez', '2025-05-01 22:37:27'),
('241', 'ST10100320250501083750', '1446-11-03', '1.100.10', '101', 'an.ANA SALSABILA', '25000', '0', 'Chuwez', '2025-05-01 22:37:50'),
('242', 'ST10100320250501083750', '1446-11-03', '2.220.10', '101', 'an.ANA SALSABILA', '0', '25000', 'Chuwez', '2025-05-01 22:37:50'),
('243', 'ST10100320250501083838', '1446-11-03', '1.100.10', '101', 'an.ZAKIYATUL UMMAH', '2000', '0', 'Chuwez', '2025-05-01 22:38:38'),
('244', 'ST10100320250501083838', '1446-11-03', '2.220.10', '101', 'an.ZAKIYATUL UMMAH', '0', '2000', 'Chuwez', '2025-05-01 22:38:38'),
('245', 'ST10100320250501083857', '1446-11-03', '1.100.10', '101', 'an.MUHAMMAD HAMDANI', '5000', '0', 'Chuwez', '2025-05-01 22:38:57'),
('246', 'ST10100320250501083857', '1446-11-03', '2.220.10', '101', 'an.MUHAMMAD HAMDANI', '0', '5000', 'Chuwez', '2025-05-01 22:38:57'),
('249', 'KK10100320250501154048', '1446-11-03', '5.520.42', '101', 'Cilok', '10000', '0', 'Chuwez', '2025-05-01 22:41:09'),
('250', 'KK10100320250501154048', '1446-11-03', '1.100.10', '101', 'Cilok', '0', '10000', 'Chuwez', '2025-05-01 22:41:09'),
('251', 'ST10100320250501090821', '1446-11-03', '1.100.10', '101', 'an.HIKMIAH PUTRI NIKMATUNNAFILAH', '5000', '0', 'Chuwez', '2025-05-01 23:08:21'),
('252', 'ST10100320250501090821', '1446-11-03', '2.220.10', '101', 'an.HIKMIAH PUTRI NIKMATUNNAFILAH', '0', '5000', 'Chuwez', '2025-05-01 23:08:21'),
('253', 'KK10100320250503144417', '1446-11-05', '4.400.21', '101', 'Kitab pegangan guru dan foto kopi', '38000', '0', 'Chuwez', '2025-05-03 21:46:13'),
('254', 'KK10100320250503144417', '1446-11-05', '1.100.10', '101', 'Kitab pegangan guru dan foto kopi', '0', '38000', 'Chuwez', '2025-05-03 21:46:13'),
('255', 'ST10100320250503075604', '1446-11-05', '1.100.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '10000', '0', 'Chuwez', '2025-05-03 21:56:04'),
('256', 'ST10100320250503075604', '1446-11-05', '2.220.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '0', '10000', 'Chuwez', '2025-05-03 21:56:04'),
('257', 'ST10100320250503075638', '1446-11-05', '1.100.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '5000', '0', 'Chuwez', '2025-05-03 21:56:38'),
('258', 'ST10100320250503075638', '1446-11-05', '2.220.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '0', '5000', 'Chuwez', '2025-05-03 21:56:38'),
('259', 'ST10100320250503075711', '1446-11-05', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'Chuwez', '2025-05-03 21:57:11'),
('260', 'ST10100320250503075711', '1446-11-05', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'Chuwez', '2025-05-03 21:57:11'),
('261', 'ST10100320250503075734', '1446-11-05', '1.100.10', '101', 'an.M. ABD. HADI', '3000', '0', 'Chuwez', '2025-05-03 21:57:34'),
('262', 'ST10100320250503075734', '1446-11-05', '2.220.10', '101', 'an.M. ABD. HADI', '0', '3000', 'Chuwez', '2025-05-03 21:57:34'),
('263', 'ST10100220250503075812', '1446-11-03', '1.100.10', '101', 'an.M. KAMALUDDIN', '30000', '0', 'Ipul', '2025-05-03 21:58:12'),
('264', 'ST10100220250503075812', '1446-11-03', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '30000', 'Ipul', '2025-05-03 21:58:12'),
('265', 'ST10100320250503075816', '1446-11-05', '1.100.10', '101', 'an.ELOK WARDATUN NAFISAH', '10000', '0', 'Chuwez', '2025-05-03 21:58:16'),
('266', 'ST10100320250503075816', '1446-11-05', '2.220.10', '101', 'an.ELOK WARDATUN NAFISAH', '0', '10000', 'Chuwez', '2025-05-03 21:58:16'),
('267', 'ST10100220250503075830', '1446-11-05', '1.100.10', '101', 'an.M. KAMALUDDIN', '50000', '0', 'Ipul', '2025-05-03 21:58:30'),
('268', 'ST10100220250503075830', '1446-11-05', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '50000', 'Ipul', '2025-05-03 21:58:30'),
('269', 'ST10100320250503075907', '1446-11-05', '1.100.10', '101', 'an.AULIA AZZAHRA', '5000', '0', 'Chuwez', '2025-05-03 21:59:07'),
('270', 'ST10100320250503075907', '1446-11-05', '2.220.10', '101', 'an.AULIA AZZAHRA', '0', '5000', 'Chuwez', '2025-05-03 21:59:07'),
('271', 'ST10100320250503075943', '1446-11-05', '1.100.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '2000', '0', 'Chuwez', '2025-05-03 21:59:43'),
('272', 'ST10100320250503075943', '1446-11-05', '2.220.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '0', '2000', 'Chuwez', '2025-05-03 21:59:43'),
('273', 'ST10100320250503080004', '1446-11-05', '1.100.10', '101', 'an.NAURA BILADINA', '5000', '0', 'Chuwez', '2025-05-03 22:00:04'),
('274', 'ST10100320250503080004', '1446-11-05', '2.220.10', '101', 'an.NAURA BILADINA', '0', '5000', 'Chuwez', '2025-05-03 22:00:04'),
('275', 'ST10100320250503080036', '1446-11-05', '1.100.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '5000', '0', 'Chuwez', '2025-05-03 22:00:36'),
('276', 'ST10100320250503080036', '1446-11-05', '2.220.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '0', '5000', 'Chuwez', '2025-05-03 22:00:36'),
('277', 'ST10100320250503080101', '1446-11-05', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '5000', '0', 'Chuwez', '2025-05-03 22:01:01'),
('278', 'ST10100320250503080101', '1446-11-05', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '5000', 'Chuwez', '2025-05-03 22:01:01'),
('279', 'ST10100320250503080143', '1446-11-05', '1.100.10', '101', 'an.ROHMATULLOH', '5000', '0', 'Chuwez', '2025-05-03 22:01:43'),
('280', 'ST10100320250503080143', '1446-11-05', '2.220.10', '101', 'an.ROHMATULLOH', '0', '5000', 'Chuwez', '2025-05-03 22:01:43'),
('281', 'ST10100320250503080218', '1446-11-05', '1.100.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '8000', '0', 'Chuwez', '2025-05-03 22:02:18'),
('282', 'ST10100320250503080218', '1446-11-05', '2.220.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '0', '8000', 'Chuwez', '2025-05-03 22:02:18'),
('283', 'ST10100320250503080246', '1446-11-05', '1.100.10', '101', 'an.MUHAMMAD ALWI', '10000', '0', 'Chuwez', '2025-05-03 22:02:46'),
('284', 'ST10100320250503080246', '1446-11-05', '2.220.10', '101', 'an.MUHAMMAD ALWI', '0', '10000', 'Chuwez', '2025-05-03 22:02:46'),
('285', 'ST10100320250503080309', '1446-11-05', '1.100.10', '101', 'an.ROFIQOTUS SARIROH', '5000', '0', 'Chuwez', '2025-05-03 22:03:09'),
('286', 'ST10100320250503080309', '1446-11-05', '2.220.10', '101', 'an.ROFIQOTUS SARIROH', '0', '5000', 'Chuwez', '2025-05-03 22:03:09'),
('287', 'ST10100320250503080329', '1446-11-05', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'Chuwez', '2025-05-03 22:03:29'),
('288', 'ST10100320250503080329', '1446-11-05', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'Chuwez', '2025-05-03 22:03:29'),
('289', 'ST10100320250503080349', '1446-11-05', '1.100.10', '101', 'an.FAIZAH NURUL LITA', '5000', '0', 'Chuwez', '2025-05-03 22:03:49'),
('290', 'ST10100320250503080349', '1446-11-05', '2.220.10', '101', 'an.FAIZAH NURUL LITA', '0', '5000', 'Chuwez', '2025-05-03 22:03:49'),
('291', 'ST10100320250503080413', '1446-11-05', '1.100.10', '101', 'an.MARIATUL QIBTIYAH', '2000', '0', 'Chuwez', '2025-05-03 22:04:13'),
('292', 'ST10100320250503080413', '1446-11-05', '2.220.10', '101', 'an.MARIATUL QIBTIYAH', '0', '2000', 'Chuwez', '2025-05-03 22:04:13'),
('293', 'ST10100320250503080436', '1446-11-05', '1.100.10', '101', 'an.UBAIDAH', '10000', '0', 'Chuwez', '2025-05-03 22:04:36'),
('294', 'ST10100320250503080436', '1446-11-05', '2.220.10', '101', 'an.UBAIDAH', '0', '10000', 'Chuwez', '2025-05-03 22:04:36'),
('295', 'ST10100320250503080532', '1446-11-05', '1.100.10', '101', 'an.UMAR FARUQ', '60000', '0', 'Chuwez', '2025-05-03 22:05:32'),
('296', 'ST10100320250503080532', '1446-11-05', '2.220.10', '101', 'an.UMAR FARUQ', '0', '60000', 'Chuwez', '2025-05-03 22:05:32'),
('297', 'ST10100320250503080554', '1446-11-05', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '10000', '0', 'Chuwez', '2025-05-03 22:05:54'),
('298', 'ST10100320250503080554', '1446-11-05', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '10000', 'Chuwez', '2025-05-03 22:05:55'),
('299', 'ST10100320250503080614', '1446-11-05', '1.100.10', '101', 'an.ABDULLOH BAHAR', '5000', '0', 'Chuwez', '2025-05-03 22:06:14'),
('300', 'ST10100320250503080614', '1446-11-05', '2.220.10', '101', 'an.ABDULLOH BAHAR', '0', '5000', 'Chuwez', '2025-05-03 22:06:14'),
('301', 'ST10100320250503080636', '1446-11-05', '1.100.10', '101', 'an.NAILATUN NIAMI', '5000', '0', 'Chuwez', '2025-05-03 22:06:36'),
('302', 'ST10100320250503080636', '1446-11-05', '2.220.10', '101', 'an.NAILATUN NIAMI', '0', '5000', 'Chuwez', '2025-05-03 22:06:36'),
('303', 'ST10100320250503081118', '1446-11-05', '1.100.10', '101', 'an.DIANA RIFQOTUL QOLBI', '5000', '0', 'chuwez', '2025-05-03 22:11:18'),
('304', 'ST10100320250503081118', '1446-11-05', '2.220.10', '101', 'an.DIANA RIFQOTUL QOLBI', '0', '5000', 'chuwez', '2025-05-03 22:11:18'),
('305', 'ST10100320250503081240', '1446-11-05', '1.100.10', '101', 'an.M. DESTRA MAULANA', '6000', '0', 'chuwez', '2025-05-03 22:12:40'),
('306', 'ST10100320250503081240', '1446-11-05', '2.220.10', '101', 'an.M. DESTRA MAULANA', '0', '6000', 'chuwez', '2025-05-03 22:12:40'),
('307', 'ST10100320250503081306', '1446-11-05', '1.100.10', '101', 'an.AZKA AUFARIL MINAN', '10000', '0', 'chuwez', '2025-05-03 22:13:06'),
('308', 'ST10100320250503081306', '1446-11-05', '2.220.10', '101', 'an.AZKA AUFARIL MINAN', '0', '10000', 'chuwez', '2025-05-03 22:13:06'),
('309', 'ST10100320250503081330', '1446-11-05', '1.100.10', '101', 'an.AISYAH', '5000', '0', 'chuwez', '2025-05-03 22:13:30'),
('310', 'ST10100320250503081330', '1446-11-05', '2.220.10', '101', 'an.AISYAH', '0', '5000', 'chuwez', '2025-05-03 22:13:30'),
('311', 'ST10100320250503081403', '1446-11-05', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '10000', '0', 'chuwez', '2025-05-03 22:14:03'),
('312', 'ST10100320250503081403', '1446-11-05', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '10000', 'chuwez', '2025-05-03 22:14:03'),
('313', 'ST10100320250503081441', '1446-11-05', '1.100.10', '101', 'an.IFTITAHUL IZZA', '100000', '0', 'chuwez', '2025-05-03 22:14:41'),
('314', 'ST10100320250503081441', '1446-11-05', '2.220.10', '101', 'an.IFTITAHUL IZZA', '0', '100000', 'chuwez', '2025-05-03 22:14:41'),
('315', 'ST10100320250503081508', '1446-11-05', '1.100.10', '101', 'an.MASRUROTUL MAULUDIYAH', '10000', '0', 'chuwez', '2025-05-03 22:15:08'),
('316', 'ST10100320250503081508', '1446-11-05', '2.220.10', '101', 'an.MASRUROTUL MAULUDIYAH', '0', '10000', 'chuwez', '2025-05-03 22:15:08'),
('317', 'ST10100320250503081610', '1446-11-05', '1.100.10', '101', 'an.ABDUL HAMID', '5000', '0', 'chuwez', '2025-05-03 22:16:10'),
('318', 'ST10100320250503081610', '1446-11-05', '2.220.10', '101', 'an.ABDUL HAMID', '0', '5000', 'chuwez', '2025-05-03 22:16:10'),
('319', 'ST10100320250503081641', '1446-11-05', '1.100.10', '101', 'an.AHMAD SYAHRU ROMADHONI', '10000', '0', 'Chuwez', '2025-05-03 22:16:41'),
('320', 'ST10100320250503081641', '1446-11-05', '2.220.10', '101', 'an.AHMAD SYAHRU ROMADHONI', '0', '10000', 'Chuwez', '2025-05-03 22:16:41'),
('321', 'ST10100320250503081658', '1446-11-05', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '10000', '0', 'Chuwez', '2025-05-03 22:16:58'),
('322', 'ST10100320250503081658', '1446-11-05', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '10000', 'Chuwez', '2025-05-03 22:16:58'),
('323', 'ST10100320250503081718', '1446-11-05', '1.100.10', '101', 'an.SITI ATHIUR ROHMAH', '5000', '0', 'Chuwez', '2025-05-03 22:17:18'),
('324', 'ST10100320250503081718', '1446-11-05', '2.220.10', '101', 'an.SITI ATHIUR ROHMAH', '0', '5000', 'Chuwez', '2025-05-03 22:17:18'),
('325', 'ST10100320250503081738', '1446-11-05', '1.100.10', '101', 'an.SITI QURROTUL AINI', '2000', '0', 'Chuwez', '2025-05-03 22:17:38'),
('326', 'ST10100320250503081738', '1446-11-05', '2.220.10', '101', 'an.SITI QURROTUL AINI', '0', '2000', 'Chuwez', '2025-05-03 22:17:38'),
('327', 'ST10100320250503081754', '1446-11-05', '1.100.10', '101', 'an.HIKMIAH PUTRI NIKMATUNNAFILAH', '5000', '0', 'Chuwez', '2025-05-03 22:17:54'),
('328', 'ST10100320250503081754', '1446-11-05', '2.220.10', '101', 'an.HIKMIAH PUTRI NIKMATUNNAFILAH', '0', '5000', 'Chuwez', '2025-05-03 22:17:55'),
('329', 'ST10100320250503081819', '1446-11-05', '1.100.10', '101', 'an.M. FAHMI NURUL ANAM', '10000', '0', 'Chuwez', '2025-05-03 22:18:19'),
('330', 'ST10100320250503081819', '1446-11-05', '2.220.10', '101', 'an.M. FAHMI NURUL ANAM', '0', '10000', 'Chuwez', '2025-05-03 22:18:19'),
('331', 'ST10100320250503081841', '1446-11-05', '1.100.10', '101', 'an.DIYANAH KAMALIYAH', '4000', '0', 'Chuwez', '2025-05-03 22:18:41'),
('332', 'ST10100320250503081841', '1446-11-05', '2.220.10', '101', 'an.DIYANAH KAMALIYAH', '0', '4000', 'Chuwez', '2025-05-03 22:18:41'),
('333', 'ST10100320250503081902', '1446-11-05', '1.100.10', '101', 'an.AHMAD RAFI SALIM', '2000', '0', 'Chuwez', '2025-05-03 22:19:02'),
('334', 'ST10100320250503081902', '1446-11-05', '2.220.10', '101', 'an.AHMAD RAFI SALIM', '0', '2000', 'Chuwez', '2025-05-03 22:19:03'),
('335', 'ST10100320250503081924', '1446-11-05', '1.100.10', '101', 'an.WARDATUL JANNAH', '2000', '0', 'Chuwez', '2025-05-03 22:19:24'),
('336', 'ST10100320250503081924', '1446-11-05', '2.220.10', '101', 'an.WARDATUL JANNAH', '0', '2000', 'Chuwez', '2025-05-03 22:19:24'),
('337', 'ST10100320250503081954', '1446-11-05', '1.100.10', '101', 'an.RAUDHOTUL JANNAH', '20000', '0', 'Chuwez', '2025-05-03 22:19:54'),
('338', 'ST10100320250503081954', '1446-11-05', '2.220.10', '101', 'an.RAUDHOTUL JANNAH', '0', '20000', 'Chuwez', '2025-05-03 22:19:55'),
('339', 'ST10100320250503082014', '1446-11-05', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '10000', '0', 'Chuwez', '2025-05-03 22:20:14'),
('340', 'ST10100320250503082014', '1446-11-05', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '10000', 'Chuwez', '2025-05-03 22:20:14'),
('341', 'ST10100320250503082032', '1446-11-05', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '2000', '0', 'Chuwez', '2025-05-03 22:20:32'),
('342', 'ST10100320250503082032', '1446-11-05', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '2000', 'Chuwez', '2025-05-03 22:20:32'),
('343', 'ST10100320250503082052', '1446-11-05', '1.100.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '10000', '0', 'Chuwez', '2025-05-03 22:20:52'),
('344', 'ST10100320250503082052', '1446-11-05', '2.220.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '0', '10000', 'Chuwez', '2025-05-03 22:20:52'),
('345', 'ST10100320250503082131', '1446-11-05', '1.100.10', '101', 'an.IZZA BILLAH', '20000', '0', 'Chuwez', '2025-05-03 22:21:31'),
('346', 'ST10100320250503082131', '1446-11-05', '2.220.10', '101', 'an.IZZA BILLAH', '0', '20000', 'Chuwez', '2025-05-03 22:21:31'),
('347', 'ST10100320250503082154', '1446-11-05', '1.100.10', '101', 'an.NIKMATUL MAULIDAH', '5000', '0', 'Chuwez', '2025-05-03 22:21:54'),
('348', 'ST10100320250503082154', '1446-11-05', '2.220.10', '101', 'an.NIKMATUL MAULIDAH', '0', '5000', 'Chuwez', '2025-05-03 22:21:54'),
('349', 'ST10100320250503082214', '1446-11-05', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Chuwez', '2025-05-03 22:22:14'),
('350', 'ST10100320250503082214', '1446-11-05', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Chuwez', '2025-05-03 22:22:14'),
('351', 'ST10100320250503082259', '1446-11-05', '1.100.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '20000', '0', 'Chuwez', '2025-05-03 22:22:59'),
('352', 'ST10100320250503082259', '1446-11-05', '2.220.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '0', '20000', 'Chuwez', '2025-05-03 22:22:59'),
('353', 'ST10100320250503082316', '1446-11-05', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '5000', '0', 'Chuwez', '2025-05-03 22:23:16'),
('354', 'ST10100320250503082316', '1446-11-05', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '5000', 'Chuwez', '2025-05-03 22:23:16'),
('355', 'ST10100320250503082349', '1446-11-05', '1.100.10', '101', 'an.MIFTAHUL JANNAH', '50000', '0', 'Chuwez', '2025-05-03 22:23:49'),
('356', 'ST10100320250503082349', '1446-11-05', '2.220.10', '101', 'an.MIFTAHUL JANNAH', '0', '50000', 'Chuwez', '2025-05-03 22:23:49'),
('357', 'ST10100320250503082430', '1446-11-05', '1.100.10', '101', 'an.AKHMAD FIKRI HAIKAL', '25000', '0', 'Chuwez', '2025-05-03 22:24:30'),
('358', 'ST10100320250503082430', '1446-11-05', '2.220.10', '101', 'an.AKHMAD FIKRI HAIKAL', '0', '25000', 'Chuwez', '2025-05-03 22:24:30'),
('359', 'ST10100320250503082449', '1446-11-05', '1.100.10', '101', 'an.BILQIS THALIA HASNA', '50000', '0', 'Chuwez', '2025-05-03 22:24:49'),
('360', 'ST10100320250503082449', '1446-11-05', '2.220.10', '101', 'an.BILQIS THALIA HASNA', '0', '50000', 'Chuwez', '2025-05-03 22:24:49'),
('361', 'ST10100320250503082504', '1446-11-05', '1.100.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '5000', '0', 'Chuwez', '2025-05-03 22:25:04'),
('362', 'ST10100320250503082504', '1446-11-05', '2.220.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '0', '5000', 'Chuwez', '2025-05-03 22:25:04'),
('363', 'ST10100320250503082524', '1446-11-05', '1.100.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '5000', '0', 'Chuwez', '2025-05-03 22:25:24'),
('364', 'ST10100320250503082524', '1446-11-05', '2.220.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '0', '5000', 'Chuwez', '2025-05-03 22:25:24'),
('365', 'ST10100320250503082541', '1446-11-05', '1.100.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '10000', '0', 'Chuwez', '2025-05-03 22:25:41'),
('366', 'ST10100320250503082541', '1446-11-05', '2.220.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '0', '10000', 'Chuwez', '2025-05-03 22:25:41'),
('367', 'ST10100320250503082559', '1446-11-05', '1.100.10', '101', 'an.M. HAIKAL NASRULLOH', '5000', '0', 'Chuwez', '2025-05-03 22:25:59'),
('368', 'ST10100320250503082559', '1446-11-05', '2.220.10', '101', 'an.M. HAIKAL NASRULLOH', '0', '5000', 'Chuwez', '2025-05-03 22:25:59'),
('369', 'ST10100320250503082636', '1446-11-05', '1.100.10', '101', 'an.SINDI RAISA PUTRI', '10000', '0', 'Chuwez', '2025-05-03 22:26:36'),
('370', 'ST10100320250503082636', '1446-11-05', '2.220.10', '101', 'an.SINDI RAISA PUTRI', '0', '10000', 'Chuwez', '2025-05-03 22:26:36'),
('371', 'ST10100320250503082655', '1446-11-05', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '40000', '0', 'Chuwez', '2025-05-03 22:26:55'),
('372', 'ST10100320250503082655', '1446-11-05', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '40000', 'Chuwez', '2025-05-03 22:26:55'),
('373', 'ST10100320250503082829', '1446-11-05', '1.100.10', '101', 'an.AHMAD JAMALUL MAIMUN', '5000', '0', 'Chuwez', '2025-05-03 22:28:29'),
('374', 'ST10100320250503082829', '1446-11-05', '2.220.10', '101', 'an.AHMAD JAMALUL MAIMUN', '0', '5000', 'Chuwez', '2025-05-03 22:28:29'),
('375', 'ST10100320250503083118', '1446-11-05', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '5000', '0', 'Chuwez', '2025-05-03 22:31:18'),
('376', 'ST10100320250503083118', '1446-11-05', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '5000', 'Chuwez', '2025-05-03 22:31:18'),
('377', 'ST10100320250503083252', '1446-11-05', '1.100.10', '101', 'an.ZAKIYATUL UMMAH', '2000', '0', 'Chuwez', '2025-05-03 22:32:52'),
('378', 'ST10100320250503083252', '1446-11-05', '2.220.10', '101', 'an.ZAKIYATUL UMMAH', '0', '2000', 'Chuwez', '2025-05-03 22:32:52'),
('379', 'ST10100320250503083315', '1446-11-05', '1.100.10', '101', 'an.M. ALIFIN FIKRI', '2000', '0', 'Chuwez', '2025-05-03 22:33:15'),
('380', 'ST10100320250503083315', '1446-11-05', '2.220.10', '101', 'an.M. ALIFIN FIKRI', '0', '2000', 'Chuwez', '2025-05-03 22:33:15'),
('381', 'ST10100320250503083344', '1446-11-05', '1.100.10', '101', 'an.AFANDI', '3000', '0', 'Chuwez', '2025-05-03 22:33:44'),
('382', 'ST10100320250503083344', '1446-11-05', '2.220.10', '101', 'an.AFANDI', '0', '3000', 'Chuwez', '2025-05-03 22:33:44'),
('383', 'ST10100320250503083414', '1446-11-05', '1.100.10', '101', 'an.ROBIATUL ADAWIYAH', '10000', '0', 'Chuwez', '2025-05-03 22:34:14'),
('384', 'ST10100320250503083414', '1446-11-05', '2.220.10', '101', 'an.ROBIATUL ADAWIYAH', '0', '10000', 'Chuwez', '2025-05-03 22:34:14'),
('385', 'ST10100320250503083433', '1446-11-05', '1.100.10', '101', 'an.ANA SALSABILA', '7000', '0', 'Chuwez', '2025-05-03 22:34:33'),
('386', 'ST10100320250503083433', '1446-11-05', '2.220.10', '101', 'an.ANA SALSABILA', '0', '7000', 'Chuwez', '2025-05-03 22:34:34'),
('387', 'ST10100320250503083507', '1446-11-05', '1.100.10', '101', 'an.M.AKMALUL HIMAM', '10000', '0', 'Chuwez', '2025-05-03 22:35:07'),
('388', 'ST10100320250503083507', '1446-11-05', '2.220.10', '101', 'an.M.AKMALUL HIMAM', '0', '10000', 'Chuwez', '2025-05-03 22:35:07'),
('389', 'ST10100320250503083526', '1446-11-05', '1.100.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '2000', '0', 'Chuwez', '2025-05-03 22:35:26'),
('390', 'ST10100320250503083526', '1446-11-05', '2.220.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '0', '2000', 'Chuwez', '2025-05-03 22:35:26'),
('391', 'ST10100320250503083557', '1446-11-05', '1.100.10', '101', 'an.ACH. JUNAIDI', '5000', '0', 'Chuwez', '2025-05-03 22:35:57'),
('392', 'ST10100320250503083557', '1446-11-05', '2.220.10', '101', 'an.ACH. JUNAIDI', '0', '5000', 'Chuwez', '2025-05-03 22:35:57'),
('393', 'ST10100320250503083716', '1446-11-05', '1.100.10', '101', 'an.ALFIN HIDAYAT', '5000', '0', 'Chuwez', '2025-05-03 22:37:16'),
('394', 'ST10100320250503083716', '1446-11-05', '2.220.10', '101', 'an.ALFIN HIDAYAT', '0', '5000', 'Chuwez', '2025-05-03 22:37:16'),
('395', 'ST10100320250503083753', '1446-11-05', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '10000', '0', 'Chuwez', '2025-05-03 22:37:53'),
('396', 'ST10100320250503083753', '1446-11-05', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '10000', 'Chuwez', '2025-05-03 22:37:53'),
('397', 'ST10100320250503083814', '1446-11-05', '1.100.10', '101', 'an.SAFIRATUL JANNAH', '20000', '0', 'Chuwez', '2025-05-03 22:38:14'),
('398', 'ST10100320250503083814', '1446-11-05', '2.220.10', '101', 'an.SAFIRATUL JANNAH', '0', '20000', 'Chuwez', '2025-05-03 22:38:14'),
('399', 'ST10100320250503084034', '1446-11-02', '1.100.10', '101', 'an.HILYA', '60000', '0', 'Chuwez', '2025-05-03 22:40:34'),
('400', 'ST10100320250503084034', '1446-11-02', '2.220.10', '101', 'an.HILYA', '0', '60000', 'Chuwez', '2025-05-03 22:40:34'),
('401', 'ST10100320250503084902', '1446-11-05', '1.100.10', '101', 'an.NABILATUN NISAUL UMMAH', '30000', '0', 'Chuwez', '2025-05-03 22:49:02'),
('402', 'ST10100320250503084902', '1446-11-05', '2.220.10', '101', 'an.NABILATUN NISAUL UMMAH', '0', '30000', 'Chuwez', '2025-05-03 22:49:02'),
('403', 'ST10100320250504074708', '1446-11-06', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'Chuwez', '2025-05-04 21:47:08'),
('404', 'ST10100320250504074708', '1446-11-06', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'Chuwez', '2025-05-04 21:47:09'),
('405', 'ST10100320250504074730', '1446-11-06', '1.100.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '5000', '0', 'Chuwez', '2025-05-04 21:47:30'),
('406', 'ST10100320250504074730', '1446-11-06', '2.220.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '0', '5000', 'Chuwez', '2025-05-04 21:47:30'),
('407', 'ST10100320250504074749', '1446-11-06', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '5000', '0', 'Chuwez', '2025-05-04 21:47:49'),
('408', 'ST10100320250504074749', '1446-11-06', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '5000', 'Chuwez', '2025-05-04 21:47:49'),
('409', 'ST10100320250504074808', '1446-11-06', '1.100.10', '101', 'an.NAURA BILADINA', '5000', '0', 'Chuwez', '2025-05-04 21:48:08'),
('410', 'ST10100320250504074808', '1446-11-06', '2.220.10', '101', 'an.NAURA BILADINA', '0', '5000', 'Chuwez', '2025-05-04 21:48:08'),
('411', 'ST10100320250504074834', '1446-11-06', '1.100.10', '101', 'an.M. ABD. HADI', '2000', '0', 'Chuwez', '2025-05-04 21:48:34'),
('412', 'ST10100320250504074834', '1446-11-06', '2.220.10', '101', 'an.M. ABD. HADI', '0', '2000', 'Chuwez', '2025-05-04 21:48:34'),
('413', 'ST10100320250504074852', '1446-11-06', '1.100.10', '101', 'an.HAIKAL SHOMADANI', '10000', '0', 'Chuwez', '2025-05-04 21:48:52'),
('414', 'ST10100320250504074852', '1446-11-06', '2.220.10', '101', 'an.HAIKAL SHOMADANI', '0', '10000', 'Chuwez', '2025-05-04 21:48:52'),
('415', 'ST10100320250504074913', '1446-11-06', '1.100.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '10000', '0', 'Chuwez', '2025-05-04 21:49:13'),
('416', 'ST10100320250504074913', '1446-11-06', '2.220.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '0', '10000', 'Chuwez', '2025-05-04 21:49:13'),
('417', 'ST10100320250504074937', '1446-11-06', '1.100.10', '101', 'an.MUHAMMAD NAZHIRUL ASROFI', '20000', '0', 'Chuwez', '2025-05-04 21:49:37'),
('418', 'ST10100320250504074937', '1446-11-06', '2.220.10', '101', 'an.MUHAMMAD NAZHIRUL ASROFI', '0', '20000', 'Chuwez', '2025-05-04 21:49:37'),
('419', 'ST10100320250504075010', '1446-11-06', '1.100.10', '101', 'an.MARIATUL QIBTIYAH', '4000', '0', 'Chuwez', '2025-05-04 21:50:10'),
('420', 'ST10100320250504075010', '1446-11-06', '2.220.10', '101', 'an.MARIATUL QIBTIYAH', '0', '4000', 'Chuwez', '2025-05-04 21:50:10'),
('421', 'ST10100320250504075038', '1446-11-06', '1.100.10', '101', 'an.NAILATUN NIAMI', '5000', '0', 'Chuwez', '2025-05-04 21:50:38'),
('422', 'ST10100320250504075038', '1446-11-06', '2.220.10', '101', 'an.NAILATUN NIAMI', '0', '5000', 'Chuwez', '2025-05-04 21:50:38'),
('423', 'ST10100320250504075058', '1446-11-06', '1.100.10', '101', 'an.SITI ISTIFAIYAH', '20000', '0', 'Chuwez', '2025-05-04 21:50:58'),
('424', 'ST10100320250504075058', '1446-11-06', '2.220.10', '101', 'an.SITI ISTIFAIYAH', '0', '20000', 'Chuwez', '2025-05-04 21:50:58'),
('425', 'ST10100320250504075125', '1446-11-06', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'Chuwez', '2025-05-04 21:51:25'),
('426', 'ST10100320250504075125', '1446-11-06', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'Chuwez', '2025-05-04 21:51:25'),
('427', 'ST10100320250504075154', '1446-11-06', '1.100.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '4000', '0', 'Chuwez', '2025-05-04 21:51:54'),
('428', 'ST10100320250504075154', '1446-11-06', '2.220.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '0', '4000', 'Chuwez', '2025-05-04 21:51:54'),
('429', 'ST10100320250504075213', '1446-11-06', '1.100.10', '101', 'an.ROFIQOTUS SARIROH', '10000', '0', 'Chuwez', '2025-05-04 21:52:13'),
('430', 'ST10100320250504075213', '1446-11-06', '2.220.10', '101', 'an.ROFIQOTUS SARIROH', '0', '10000', 'Chuwez', '2025-05-04 21:52:13'),
('431', 'ST10100320250504075233', '1446-11-06', '1.100.10', '101', 'an.M. ABDIL ARIKIN', '20000', '0', 'Chuwez', '2025-05-04 21:52:33'),
('432', 'ST10100320250504075233', '1446-11-06', '2.220.10', '101', 'an.M. ABDIL ARIKIN', '0', '20000', 'Chuwez', '2025-05-04 21:52:33'),
('433', 'ST10100320250504075250', '1446-11-06', '1.100.10', '101', 'an.UBAIDAH', '10000', '0', 'Chuwez', '2025-05-04 21:52:50'),
('434', 'ST10100320250504075250', '1446-11-06', '2.220.10', '101', 'an.UBAIDAH', '0', '10000', 'Chuwez', '2025-05-04 21:52:50'),
('435', 'ST10100320250504075305', '1446-11-06', '1.100.10', '101', 'an.FAIZAH NURUL LITA', '5000', '0', 'Chuwez', '2025-05-04 21:53:05'),
('436', 'ST10100320250504075305', '1446-11-06', '2.220.10', '101', 'an.FAIZAH NURUL LITA', '0', '5000', 'Chuwez', '2025-05-04 21:53:05'),
('437', 'ST10100320250504075347', '1446-11-06', '1.100.10', '101', 'an.MARIYATUL QIBTIYAH', '5000', '0', 'Chuwez', '2025-05-04 21:53:47'),
('438', 'ST10100320250504075347', '1446-11-06', '2.220.10', '101', 'an.MARIYATUL QIBTIYAH', '0', '5000', 'Chuwez', '2025-05-04 21:53:47'),
('439', 'ST10100320250504075405', '1446-11-06', '1.100.10', '101', 'an.ABDULLOH BAHAR', '5000', '0', 'Chuwez', '2025-05-04 21:54:05'),
('440', 'ST10100320250504075405', '1446-11-06', '2.220.10', '101', 'an.ABDULLOH BAHAR', '0', '5000', 'Chuwez', '2025-05-04 21:54:05'),
('441', 'ST10100320250504075424', '1446-11-06', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '5000', '0', 'Chuwez', '2025-05-04 21:54:24'),
('442', 'ST10100320250504075424', '1446-11-06', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '5000', 'Chuwez', '2025-05-04 21:54:24'),
('443', 'ST10100320250504075447', '1446-11-06', '1.100.10', '101', 'an.AHMAD ADITIYA', '5000', '0', 'Chuwez', '2025-05-04 21:54:47'),
('444', 'ST10100320250504075447', '1446-11-06', '2.220.10', '101', 'an.AHMAD ADITIYA', '0', '5000', 'Chuwez', '2025-05-04 21:54:47'),
('445', 'ST10100320250504075507', '1446-11-06', '1.100.10', '101', 'an.M. DESTRA MAULANA', '30000', '0', 'Chuwez', '2025-05-04 21:55:07'),
('446', 'ST10100320250504075507', '1446-11-06', '2.220.10', '101', 'an.M. DESTRA MAULANA', '0', '30000', 'Chuwez', '2025-05-04 21:55:07'),
('447', 'ST10100320250504075525', '1446-11-06', '1.100.10', '101', 'an.MASRUROTUL MAULUDIYAH', '5000', '0', 'Chuwez', '2025-05-04 21:55:25'),
('448', 'ST10100320250504075525', '1446-11-06', '2.220.10', '101', 'an.MASRUROTUL MAULUDIYAH', '0', '5000', 'Chuwez', '2025-05-04 21:55:25'),
('449', 'ST10100320250504075541', '1446-11-06', '1.100.10', '101', 'an.LAILATUL MAGHFIROH', '10000', '0', 'Chuwez', '2025-05-04 21:55:41'),
('450', 'ST10100320250504075541', '1446-11-06', '2.220.10', '101', 'an.LAILATUL MAGHFIROH', '0', '10000', 'Chuwez', '2025-05-04 21:55:41'),
('451', 'ST10100320250504075601', '1446-11-06', '1.100.10', '101', 'an.ALFI NURDIANA', '10000', '0', 'Chuwez', '2025-05-04 21:56:01'),
('452', 'ST10100320250504075601', '1446-11-06', '2.220.10', '101', 'an.ALFI NURDIANA', '0', '10000', 'Chuwez', '2025-05-04 21:56:01'),
('453', 'ST10100320250504075625', '1446-11-06', '1.100.10', '101', 'an.IFTITAHUL IZZA', '50000', '0', 'Chuwez', '2025-05-04 21:56:25'),
('454', 'ST10100320250504075625', '1446-11-06', '2.220.10', '101', 'an.IFTITAHUL IZZA', '0', '50000', 'Chuwez', '2025-05-04 21:56:25'),
('455', 'ST10100320250504075642', '1446-11-06', '1.100.10', '101', 'an.AZKA AUFARIL MINAN', '5000', '0', 'Chuwez', '2025-05-04 21:56:42'),
('456', 'ST10100320250504075642', '1446-11-06', '2.220.10', '101', 'an.AZKA AUFARIL MINAN', '0', '5000', 'Chuwez', '2025-05-04 21:56:42'),
('457', 'ST10100320250504075656', '1446-11-06', '1.100.10', '101', 'an.DIANA RIFQOTUL QOLBI', '5000', '0', 'Chuwez', '2025-05-04 21:56:56'),
('458', 'ST10100320250504075656', '1446-11-06', '2.220.10', '101', 'an.DIANA RIFQOTUL QOLBI', '0', '5000', 'Chuwez', '2025-05-04 21:56:56'),
('459', 'ST10100320250504075715', '1446-11-06', '1.100.10', '101', 'an.SAHILA MAFATIHATUL JANNAH', '5000', '0', 'Chuwez', '2025-05-04 21:57:15'),
('460', 'ST10100320250504075715', '1446-11-06', '2.220.10', '101', 'an.SAHILA MAFATIHATUL JANNAH', '0', '5000', 'Chuwez', '2025-05-04 21:57:15'),
('461', 'ST10100320250504075731', '1446-11-06', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '10000', '0', 'Chuwez', '2025-05-04 21:57:31'),
('462', 'ST10100320250504075731', '1446-11-06', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '10000', 'Chuwez', '2025-05-04 21:57:31'),
('463', 'ST10100320250504075751', '1446-11-06', '1.100.10', '101', 'an.AISYAH', '5000', '0', 'Chuwez', '2025-05-04 21:57:51'),
('464', 'ST10100320250504075751', '1446-11-06', '2.220.10', '101', 'an.AISYAH', '0', '5000', 'Chuwez', '2025-05-04 21:57:51'),
('465', 'ST10100320250504075816', '1446-11-06', '1.100.10', '101', 'an.AHMAD SYAHRU ROMADHONI', '10000', '0', 'Chuwez', '2025-05-04 21:58:16'),
('466', 'ST10100320250504075816', '1446-11-06', '2.220.10', '101', 'an.AHMAD SYAHRU ROMADHONI', '0', '10000', 'Chuwez', '2025-05-04 21:58:16'),
('467', 'ST10100320250504075847', '1446-11-06', '1.100.10', '101', 'an.M. FAHMI NURUL ANAM', '10000', '0', 'Chuwez', '2025-05-04 21:58:47'),
('468', 'ST10100320250504075847', '1446-11-06', '2.220.10', '101', 'an.M. FAHMI NURUL ANAM', '0', '10000', 'Chuwez', '2025-05-04 21:58:47'),
('469', 'ST10100320250504075904', '1446-11-06', '1.100.10', '101', 'an.HIKMIAH PUTRI NIKMATUNNAFILAH', '5000', '0', 'Chuwez', '2025-05-04 21:59:04'),
('470', 'ST10100320250504075904', '1446-11-06', '2.220.10', '101', 'an.HIKMIAH PUTRI NIKMATUNNAFILAH', '0', '5000', 'Chuwez', '2025-05-04 21:59:04'),
('471', 'ST10100320250504075922', '1446-11-06', '1.100.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '20000', '0', 'Chuwez', '2025-05-04 21:59:22'),
('472', 'ST10100320250504075922', '1446-11-06', '2.220.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '0', '20000', 'Chuwez', '2025-05-04 21:59:22'),
('473', 'ST10100320250504075940', '1446-11-06', '1.100.10', '101', 'an.WARDATUL JANNAH', '3000', '0', 'Chuwez', '2025-05-04 21:59:40'),
('474', 'ST10100320250504075940', '1446-11-06', '2.220.10', '101', 'an.WARDATUL JANNAH', '0', '3000', 'Chuwez', '2025-05-04 21:59:40'),
('475', 'ST10100320250504075957', '1446-11-06', '1.100.10', '101', 'an.KHOIRIYAH', '10000', '0', 'Chuwez', '2025-05-04 21:59:57'),
('476', 'ST10100320250504075957', '1446-11-06', '2.220.10', '101', 'an.KHOIRIYAH', '0', '10000', 'Chuwez', '2025-05-04 21:59:57'),
('477', 'ST10100320250504080013', '1446-11-06', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '10000', '0', 'Chuwez', '2025-05-04 22:00:13'),
('478', 'ST10100320250504080013', '1446-11-06', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '10000', 'Chuwez', '2025-05-04 22:00:14'),
('479', 'ST10100320250504080030', '1446-11-06', '1.100.10', '101', 'an.DIYANAH KAMALIYAH', '5000', '0', 'Chuwez', '2025-05-04 22:00:30'),
('480', 'ST10100320250504080030', '1446-11-06', '2.220.10', '101', 'an.DIYANAH KAMALIYAH', '0', '5000', 'Chuwez', '2025-05-04 22:00:30'),
('481', 'ST10100320250504080050', '1446-11-06', '1.100.10', '101', 'an.SITI ATHIUR ROHMAH', '5000', '0', 'Chuwez', '2025-05-04 22:00:50'),
('482', 'ST10100320250504080050', '1446-11-06', '2.220.10', '101', 'an.SITI ATHIUR ROHMAH', '0', '5000', 'Chuwez', '2025-05-04 22:00:50'),
('483', 'ST10100320250504080106', '1446-11-06', '1.100.10', '101', 'an.SITI QURROTUL AINI', '2000', '0', 'Chuwez', '2025-05-04 22:01:06'),
('484', 'ST10100320250504080106', '1446-11-06', '2.220.10', '101', 'an.SITI QURROTUL AINI', '0', '2000', 'Chuwez', '2025-05-04 22:01:06'),
('485', 'ST10100320250504080139', '1446-11-06', '1.100.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '10000', '0', 'Chuwez', '2025-05-04 22:01:39'),
('486', 'ST10100320250504080139', '1446-11-06', '2.220.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '0', '10000', 'Chuwez', '2025-05-04 22:01:39'),
('487', 'ST10100320250504080203', '1446-11-06', '1.100.10', '101', 'an.NABILATUN NISAUL UMMAH', '20000', '0', 'Chuwez', '2025-05-04 22:02:03'),
('488', 'ST10100320250504080203', '1446-11-06', '2.220.10', '101', 'an.NABILATUN NISAUL UMMAH', '0', '20000', 'Chuwez', '2025-05-04 22:02:03'),
('489', 'ST10100320250504075326', '1446-11-06', '1.100.10', '101', 'an.MUHAMMAD ALWI', '10000', '0', 'Ipul', '2025-05-04 22:02:11'),
('490', 'ST10100320250504075326', '1446-11-06', '2.220.10', '101', 'an.MUHAMMAD ALWI', '0', '10000', 'Ipul', '2025-05-04 22:02:11'),
('491', 'ST10100320250504080220', '1446-11-06', '1.100.10', '101', 'an.IZZA BILLAH', '20000', '0', 'Chuwez', '2025-05-04 22:02:20'),
('492', 'ST10100320250504080220', '1446-11-06', '2.220.10', '101', 'an.IZZA BILLAH', '0', '20000', 'Chuwez', '2025-05-04 22:02:20'),
('493', 'ST10100320250504080244', '1446-11-06', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Chuwez', '2025-05-04 22:02:44'),
('494', 'ST10100320250504080244', '1446-11-06', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Chuwez', '2025-05-04 22:02:44'),
('495', 'ST10100320250504080259', '1446-11-06', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '5000', '0', 'Chuwez', '2025-05-04 22:02:59'),
('496', 'ST10100320250504080259', '1446-11-06', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '5000', 'Chuwez', '2025-05-04 22:02:59'),
('497', 'ST10100320250504080315', '1446-11-06', '1.100.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '5000', '0', 'Chuwez', '2025-05-04 22:03:15'),
('498', 'ST10100320250504080315', '1446-11-06', '2.220.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '0', '5000', 'Chuwez', '2025-05-04 22:03:15'),
('499', 'ST10100320250504080334', '1446-11-06', '1.100.10', '101', 'an.M. KAMALUDDIN', '20000', '0', 'Chuwez', '2025-05-04 22:03:34'),
('500', 'ST10100320250504080334', '1446-11-06', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '20000', 'Chuwez', '2025-05-04 22:03:34'),
('501', 'ST10100320250504080354', '1446-11-06', '1.100.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '20000', '0', 'Chuwez', '2025-05-04 22:03:54'),
('502', 'ST10100320250504080354', '1446-11-06', '2.220.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '0', '20000', 'Chuwez', '2025-05-04 22:03:54'),
('503', 'ST10100320250504080415', '1446-11-06', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '10000', '0', 'Chuwez', '2025-05-04 22:04:15'),
('504', 'ST10100320250504080415', '1446-11-06', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '10000', 'Chuwez', '2025-05-04 22:04:15'),
('505', 'ST10100320250504080433', '1446-11-06', '1.100.10', '101', 'an.NIKMATUL MAULIDAH', '5000', '0', 'Chuwez', '2025-05-04 22:04:33'),
('506', 'ST10100320250504080433', '1446-11-06', '2.220.10', '101', 'an.NIKMATUL MAULIDAH', '0', '5000', 'Chuwez', '2025-05-04 22:04:33'),
('507', 'ST10100320250504080449', '1446-11-06', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '2000', '0', 'Chuwez', '2025-05-04 22:04:49'),
('508', 'ST10100320250504080449', '1446-11-06', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '2000', 'Chuwez', '2025-05-04 22:04:49'),
('509', 'ST10100320250504080512', '1446-11-06', '1.100.10', '101', 'an.SINDI RAISA PUTRI', '10000', '0', 'Chuwez', '2025-05-04 22:05:12'),
('510', 'ST10100320250504080512', '1446-11-06', '2.220.10', '101', 'an.SINDI RAISA PUTRI', '0', '10000', 'Chuwez', '2025-05-04 22:05:12'),
('511', 'ST10100320250504080536', '1446-11-06', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '25000', '0', 'Chuwez', '2025-05-04 22:05:36'),
('512', 'ST10100320250504080536', '1446-11-06', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '25000', 'Chuwez', '2025-05-04 22:05:36'),
('513', 'ST10100320250504080602', '1446-11-06', '1.100.10', '101', 'an.BILQIS THALIA HASNA', '75000', '0', 'Chuwez', '2025-05-04 22:06:02'),
('514', 'ST10100320250504080602', '1446-11-06', '2.220.10', '101', 'an.BILQIS THALIA HASNA', '0', '75000', 'Chuwez', '2025-05-04 22:06:02'),
('515', 'ST10100320250504080618', '1446-11-06', '1.100.10', '101', 'an.M. ROFIQ HIDAYATULLOH', '10000', '0', 'Chuwez', '2025-05-04 22:06:18'),
('516', 'ST10100320250504080618', '1446-11-06', '2.220.10', '101', 'an.M. ROFIQ HIDAYATULLOH', '0', '10000', 'Chuwez', '2025-05-04 22:06:18'),
('517', 'ST10100320250504080634', '1446-11-06', '1.100.10', '101', 'an.AHMAD JAMALUL MAIMUN', '5000', '0', 'Chuwez', '2025-05-04 22:06:34'),
('518', 'ST10100320250504080634', '1446-11-06', '2.220.10', '101', 'an.AHMAD JAMALUL MAIMUN', '0', '5000', 'Chuwez', '2025-05-04 22:06:34'),
('519', 'ST10100320250504080650', '1446-11-06', '1.100.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '5000', '0', 'Chuwez', '2025-05-04 22:06:50'),
('520', 'ST10100320250504080650', '1446-11-06', '2.220.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '0', '5000', 'Chuwez', '2025-05-04 22:06:50'),
('521', 'ST10100320250504080714', '1446-11-06', '1.100.10', '101', 'an.ANA SALSABILA', '12000', '0', 'Chuwez', '2025-05-04 22:07:14'),
('522', 'ST10100320250504080714', '1446-11-06', '2.220.10', '101', 'an.ANA SALSABILA', '0', '12000', 'Chuwez', '2025-05-04 22:07:14'),
('523', 'ST10100320250504080732', '1446-11-06', '1.100.10', '101', 'an.ZAKIYATUL UMMAH', '2000', '0', 'Chuwez', '2025-05-04 22:07:32'),
('524', 'ST10100320250504080732', '1446-11-06', '2.220.10', '101', 'an.ZAKIYATUL UMMAH', '0', '2000', 'Chuwez', '2025-05-04 22:07:32'),
('525', 'ST10100320250504080749', '1446-11-06', '1.100.10', '101', 'an.M. ALIFIN FIKRI', '2000', '0', 'Chuwez', '2025-05-04 22:07:49'),
('526', 'ST10100320250504080749', '1446-11-06', '2.220.10', '101', 'an.M. ALIFIN FIKRI', '0', '2000', 'Chuwez', '2025-05-04 22:07:49'),
('527', 'ST10100320250504080805', '1446-11-06', '1.100.10', '101', 'an.AFANDI', '2000', '0', 'Chuwez', '2025-05-04 22:08:05'),
('528', 'ST10100320250504080805', '1446-11-06', '2.220.10', '101', 'an.AFANDI', '0', '2000', 'Chuwez', '2025-05-04 22:08:05'),
('529', 'ST10100320250504080821', '1446-11-06', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '5000', '0', 'Chuwez', '2025-05-04 22:08:21'),
('530', 'ST10100320250504080821', '1446-11-06', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '5000', 'Chuwez', '2025-05-04 22:08:21'),
('531', 'ST10100320250504080836', '1446-11-06', '1.100.10', '101', 'an.MUHAMMAD YAHYA SYAKARUDDIN', '10000', '0', 'Chuwez', '2025-05-04 22:08:36'),
('532', 'ST10100320250504080836', '1446-11-06', '2.220.10', '101', 'an.MUHAMMAD YAHYA SYAKARUDDIN', '0', '10000', 'Chuwez', '2025-05-04 22:08:36'),
('533', 'ST10100320250504080854', '1446-11-06', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '5000', '0', 'Chuwez', '2025-05-04 22:08:54'),
('534', 'ST10100320250504080854', '1446-11-06', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '5000', 'Chuwez', '2025-05-04 22:08:54'),
('535', 'ST10100320250504080922', '1446-11-06', '1.100.10', '101', 'an.MUHAMMAD KHOIRON', '5000', '0', 'Chuwez', '2025-05-04 22:09:22'),
('536', 'ST10100320250504080922', '1446-11-06', '2.220.10', '101', 'an.MUHAMMAD KHOIRON', '0', '5000', 'Chuwez', '2025-05-04 22:09:22'),
('537', 'ST10100320250504081000', '1446-11-06', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '5000', '0', 'Chuwez', '2025-05-04 22:10:00'),
('538', 'ST10100320250504081000', '1446-11-06', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '5000', 'Chuwez', '2025-05-04 22:10:00'),
('539', 'ST10100320250504081017', '1446-11-06', '1.100.10', '101', 'an.MUHAMMAD KANZUL KAROMI', '10000', '0', 'Chuwez', '2025-05-04 22:10:17'),
('540', 'ST10100320250504081017', '1446-11-06', '2.220.10', '101', 'an.MUHAMMAD KANZUL KAROMI', '0', '10000', 'Chuwez', '2025-05-04 22:10:17'),
('541', 'ST10100320250504081038', '1446-11-06', '1.100.10', '101', 'an.SAFIRATUL JANNAH', '10000', '0', 'Chuwez', '2025-05-04 22:10:38'),
('542', 'ST10100320250504081038', '1446-11-06', '2.220.10', '101', 'an.SAFIRATUL JANNAH', '0', '10000', 'Chuwez', '2025-05-04 22:10:39'),
('543', 'ST10100320250504081053', '1446-11-06', '1.100.10', '101', 'an.ALFIN HIDAYAT', '5000', '0', 'Chuwez', '2025-05-04 22:10:53'),
('544', 'ST10100320250504081053', '1446-11-06', '2.220.10', '101', 'an.ALFIN HIDAYAT', '0', '5000', 'Chuwez', '2025-05-04 22:10:54'),
('545', 'KK10100320250505132132', '1446-11-06', '5.520.41', '101', 'Kursus almiftah', '75000', '0', 'Chuwez', '2025-05-05 20:22:22'),
('546', 'KK10100320250505132132', '1446-11-06', '1.100.10', '101', 'Kursus almiftah', '0', '75000', 'Chuwez', '2025-05-05 20:22:22'),
('547', 'ST10100320250505063308', '1446-11-07', '1.100.10', '101', 'an.M.AKMALUL HIMAM', '5000', '0', 'Chuwez', '2025-05-05 20:33:08'),
('548', 'ST10100320250505063308', '1446-11-07', '2.220.10', '101', 'an.M.AKMALUL HIMAM', '0', '5000', 'Chuwez', '2025-05-05 20:33:08'),
('549', 'ST10100320250505063328', '1446-11-07', '1.100.10', '101', 'an.ALFIN HIDAYAT', '5000', '0', 'Chuwez', '2025-05-05 20:33:28'),
('550', 'ST10100320250505063328', '1446-11-07', '2.220.10', '101', 'an.ALFIN HIDAYAT', '0', '5000', 'Chuwez', '2025-05-05 20:33:29'),
('551', 'ST10100320250505063351', '1446-11-07', '1.100.10', '101', 'an.MUHAMMAD KANZUL KAROMI', '5000', '0', 'Chuwez', '2025-05-05 20:33:51'),
('552', 'ST10100320250505063351', '1446-11-07', '2.220.10', '101', 'an.MUHAMMAD KANZUL KAROMI', '0', '5000', 'Chuwez', '2025-05-05 20:33:51'),
('553', 'ST10100320250505063409', '1446-11-07', '1.100.10', '101', 'an.ACH. JUNAIDI', '5000', '0', 'Chuwez', '2025-05-05 20:34:09'),
('554', 'ST10100320250505063409', '1446-11-07', '2.220.10', '101', 'an.ACH. JUNAIDI', '0', '5000', 'Chuwez', '2025-05-05 20:34:09'),
('555', 'ST10100320250505063429', '1446-11-07', '1.100.10', '101', 'an.M. ZIDAN RIZQI SALIM', '10000', '0', 'Chuwez', '2025-05-05 20:34:29'),
('556', 'ST10100320250505063429', '1446-11-07', '2.220.10', '101', 'an.M. ZIDAN RIZQI SALIM', '0', '10000', 'Chuwez', '2025-05-05 20:34:29'),
('557', 'KI10100220250427163445003', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Alfiyah', '107000', '0', 'Ipul', '2025-05-05 20:46:37'),
('558', 'KI10100220250427163445003', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Alfiyah', '0', '107000', 'Ipul', '2025-05-05 20:46:37'),
('559', 'KI10100220250505064709', '1446-11-07', '1.100.10', '101', 'Lunas[M. WAFA BAHRUN NAJA]', '107000', '0', 'Ipul', '2025-05-05 20:47:09'),
('560', 'KI10100220250505064709', '1446-11-07', '4.400.21', '101', 'Lunas[M. WAFA BAHRUN NAJA]', '0', '107000', 'Ipul', '2025-05-05 20:47:09'),
('561', 'KI10100220250427163445006', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Alfiyah dan Kifayatul Awam', '92000', '0', 'Ipul', '2025-05-05 20:49:25'),
('562', 'KI10100220250427163445006', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Alfiyah dan Kifayatul Awam', '0', '92000', 'Ipul', '2025-05-05 20:49:25'),
('563', 'KI10100220250505064953', '1446-11-07', '1.100.10', '101', 'Lunas[MUHAMMAD KANZUL KAROMI]', '92000', '0', 'Ipul', '2025-05-05 20:49:53'),
('564', 'KI10100220250505064953', '1446-11-07', '4.400.21', '101', 'Lunas[MUHAMMAD KANZUL KAROMI]', '0', '92000', 'Ipul', '2025-05-05 20:49:53'),
('565', 'KI10100220250505065050', '1446-11-07', '1.100.10', '101', 'Bayar[M. ALI FIKRI]', '140000', '0', 'Ipul', '2025-05-05 20:50:50'),
('566', 'KI10100220250505065050', '1446-11-07', '4.400.21', '101', 'Bayar[M. ALI FIKRI]', '0', '140000', 'Ipul', '2025-05-05 20:50:50'),
('567', 'KI10100220250427163445009', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Alfiyah dan Kifayatul Awam', '92000', '0', 'Ipul', '2025-05-05 20:52:17'),
('568', 'KI10100220250427163445009', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Alfiyah dan Kifayatul Awam', '0', '92000', 'Ipul', '2025-05-05 20:52:17'),
('569', 'KI10100220250505065243', '1446-11-07', '1.100.10', '101', 'Lunas[NAYLA FITRI AULIA]', '92000', '0', 'Ipul', '2025-05-05 20:52:43'),
('570', 'KI10100220250505065243', '1446-11-07', '4.400.21', '101', 'Lunas[NAYLA FITRI AULIA]', '0', '92000', 'Ipul', '2025-05-05 20:52:43'),
('571', 'KI10100220250505065314', '1446-11-07', '1.100.10', '101', 'Lunas[SAFIRATUL JANNAH]', '145000', '0', 'Ipul', '2025-05-05 20:53:14'),
('572', 'KI10100220250505065314', '1446-11-07', '4.400.21', '101', 'Lunas[SAFIRATUL JANNAH]', '0', '145000', 'Ipul', '2025-05-05 20:53:14'),
('573', 'KI10100220250505065559', '1446-11-07', '1.100.10', '101', 'Bayar[IMROATUS SOLIHAH]', '100000', '0', 'Ipul', '2025-05-05 20:55:59'),
('574', 'KI10100220250505065559', '1446-11-07', '4.400.21', '101', 'Bayar[IMROATUS SOLIHAH]', '0', '100000', 'Ipul', '2025-05-05 20:55:59'),
('575', 'KI10100220250427163424008', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Shorrof, Tauhid, Tafsir dan Fathul Qorib', '69000', '0', 'Ipul', '2025-05-05 21:02:31'),
('576', 'KI10100220250427163424008', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Shorrof, Tauhid, Tafsir dan Fathul Qorib', '0', '69000', 'Ipul', '2025-05-05 21:02:31'),
('577', 'KI10100220250427163424002', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Fathul Qorib', '100000', '0', 'Ipul', '2025-05-05 21:05:29'),
('578', 'KI10100220250427163424002', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Fathul Qorib', '0', '100000', 'Ipul', '2025-05-05 21:05:29'),
('579', 'KI10100220250427163424001', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Fathul Qorib', '100000', '0', 'Ipul', '2025-05-05 21:06:17'),
('580', 'KI10100220250427163424001', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Fathul Qorib', '0', '100000', 'Ipul', '2025-05-05 21:06:17'),
('581', 'KI10100220250427163424003', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Fathul Qorib', '100000', '0', 'Ipul', '2025-05-05 21:06:59'),
('582', 'KI10100220250427163424003', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Fathul Qorib', '0', '100000', 'Ipul', '2025-05-05 21:06:59'),
('583', 'KI10100220250427163424009', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Fathul Qorib', '100000', '0', 'Ipul', '2025-05-05 21:07:31'),
('584', 'KI10100220250427163424009', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Fathul Qorib', '0', '100000', 'Ipul', '2025-05-05 21:07:31'),
('585', 'KI10100220250427163424006', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Fathul Qorib, Shorrof dan Tafsir', '78000', '0', 'Ipul', '2025-05-05 21:08:49'),
('586', 'KI10100220250427163424006', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Fathul Qorib, Shorrof dan Tafsir', '0', '78000', 'Ipul', '2025-05-05 21:08:49'),
('587', 'KI10100220250427163424000', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Fathul Qorib', '100000', '0', 'Ipul', '2025-05-05 21:09:27'),
('588', 'KI10100220250427163424000', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Fathul Qorib', '0', '100000', 'Ipul', '2025-05-05 21:09:27'),
('589', 'KI10100220250427163424005', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Fathul Qorib', '100000', '0', 'Ipul', '2025-05-05 21:09:55'),
('590', 'KI10100220250427163424005', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Fathul Qorib', '0', '100000', 'Ipul', '2025-05-05 21:09:55'),
('591', 'KI10100220250427163424007', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Fathul Qorib, Shorrof dan Tafsir', '79000', '0', 'Ipul', '2025-05-05 21:10:58'),
('592', 'KI10100220250427163424007', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Fathul Qorib, Shorrof dan Tafsir', '0', '79000', 'Ipul', '2025-05-05 21:10:58'),
('593', 'MB10100220250505071701', '1446-11-07', '1.100.10', '101', 'Daftar murid baru.101.000116', '20000', '0', 'Ipul', '2025-05-05 21:17:01'),
('594', 'MB10100220250505071701', '1446-11-07', '4.400.10', '101', 'Daftar murid baru.101.000116', '0', '20000', 'Ipul', '2025-05-05 21:17:01'),
('595', 'KI10100220250427163321016', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Tarekh', '75000', '0', 'Ipul', '2025-05-05 21:27:06'),
('596', 'KI10100220250427163321016', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Tarekh', '0', '75000', 'Ipul', '2025-05-05 21:27:06'),
('597', 'KI10100220250427163337010', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Fathul Qorib, Tajwid dan Tarekh', '151000', '0', 'Ipul', '2025-05-05 21:28:22'),
('598', 'KI10100220250427163337010', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Fathul Qorib, Tajwid dan Tarekh', '0', '151000', 'Ipul', '2025-05-05 21:28:22'),
('599', 'KI10100220250427163321005', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Tarekh', '75000', '0', 'Ipul', '2025-05-05 21:29:26'),
('600', 'KI10100220250427163321005', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Tarekh', '0', '75000', 'Ipul', '2025-05-05 21:29:26'),
('601', 'KI10100220250427163321000', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Tarekh', '75000', '0', 'Ipul', '2025-05-05 21:30:39'),
('602', 'KI10100220250427163321000', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Tarekh', '0', '75000', 'Ipul', '2025-05-05 21:30:39'),
('603', 'KI10100220250427163321015', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Fiqih, Tarekh dan Akhlaq', '54000', '0', 'Ipul', '2025-05-05 21:32:21'),
('604', 'KI10100220250427163321015', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Fiqih, Tarekh dan Akhlaq', '0', '54000', 'Ipul', '2025-05-05 21:32:21'),
('605', 'KI10100220250427163321010', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Tarekh', '75000', '0', 'Ipul', '2025-05-05 21:34:28'),
('606', 'KI10100220250427163321010', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Tarekh', '0', '75000', 'Ipul', '2025-05-05 21:34:28'),
('607', 'ST10100320250505073450', '1446-11-07', '1.100.10', '101', 'an.SAFIRATUL JANNAH', '10000', '0', 'Chuwez', '2025-05-05 21:34:50'),
('608', 'ST10100320250505073450', '1446-11-07', '2.220.10', '101', 'an.SAFIRATUL JANNAH', '0', '10000', 'Chuwez', '2025-05-05 21:34:51'),
('609', 'KI10100220250427163321006', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Tarekh', '75000', '0', 'Ipul', '2025-05-05 21:35:04'),
('610', 'KI10100220250427163321006', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Tarekh', '0', '75000', 'Ipul', '2025-05-05 21:35:04'),
('611', 'ST10100320250505073649', '1446-11-07', '1.100.10', '101', 'an.MUHAMMAD HAMDANI', '5000', '0', 'Chuwez', '2025-05-05 21:36:49'),
('612', 'ST10100320250505073649', '1446-11-07', '2.220.10', '101', 'an.MUHAMMAD HAMDANI', '0', '5000', 'Chuwez', '2025-05-05 21:36:49'),
('613', 'KI10100220250427163321007', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Fiqih, Tauhid, Tarekh dan Akhlaq', '46000', '0', 'Ipul', '2025-05-05 21:37:29'),
('614', 'KI10100220250427163321007', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Fiqih, Tauhid, Tarekh dan Akhlaq', '0', '46000', 'Ipul', '2025-05-05 21:37:29'),
('615', 'ST10100320250505073754', '1446-11-07', '1.100.10', '101', 'an.MUHAMMAD YAHYA SYAKARUDDIN', '5000', '0', 'Chuwez', '2025-05-05 21:37:54'),
('616', 'ST10100320250505073754', '1446-11-07', '2.220.10', '101', 'an.MUHAMMAD YAHYA SYAKARUDDIN', '0', '5000', 'Chuwez', '2025-05-05 21:37:54'),
('617', 'ST10100320250505073821', '1446-11-07', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '10000', '0', 'Chuwez', '2025-05-05 21:38:21'),
('618', 'ST10100320250505073821', '1446-11-07', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '10000', 'Chuwez', '2025-05-05 21:38:21'),
('619', 'KI10100220250427163321012', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Tarekh', '75000', '0', 'Ipul', '2025-05-05 21:38:22'),
('620', 'KI10100220250427163321012', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Tarekh', '0', '75000', 'Ipul', '2025-05-05 21:38:22'),
('621', 'ST10100320250505073847', '1446-11-07', '1.100.10', '101', 'an.MUHAMMAD KHOIRON', '10000', '0', 'Chuwez', '2025-05-05 21:38:47'),
('622', 'ST10100320250505073847', '1446-11-07', '2.220.10', '101', 'an.MUHAMMAD KHOIRON', '0', '10000', 'Chuwez', '2025-05-05 21:38:47'),
('623', 'KI10100220250427163321008', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Tarekh', '75000', '0', 'Ipul', '2025-05-05 21:38:58'),
('624', 'KI10100220250427163321008', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Tarekh', '0', '75000', 'Ipul', '2025-05-05 21:38:58'),
('625', 'ST10100320250505073912', '1446-11-07', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '5000', '0', 'Chuwez', '2025-05-05 21:39:12'),
('626', 'ST10100320250505073912', '1446-11-07', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '5000', 'Chuwez', '2025-05-05 21:39:12'),
('629', 'ST10100320250505073950', '1446-11-07', '1.100.10', '101', 'an.ZAKIYATUL UMMAH', '2000', '0', 'Chuwez', '2025-05-05 21:39:50'),
('630', 'ST10100320250505073950', '1446-11-07', '2.220.10', '101', 'an.ZAKIYATUL UMMAH', '0', '2000', 'Chuwez', '2025-05-05 21:39:50'),
('631', 'ST10100320250505074019', '1446-11-07', '1.100.10', '101', 'an.ANA SALSABILA', '7000', '0', 'Chuwez', '2025-05-05 21:40:19'),
('632', 'ST10100320250505074019', '1446-11-07', '2.220.10', '101', 'an.ANA SALSABILA', '0', '7000', 'Chuwez', '2025-05-05 21:40:19'),
('633', 'KI10100220250427163321009', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Tarekh', '75000', '0', 'Ipul', '2025-05-05 21:40:20'),
('634', 'KI10100220250427163321009', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Tarekh', '0', '75000', 'Ipul', '2025-05-05 21:40:20'),
('635', 'KI10100220250427163321013', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Tarekh', '75000', '0', 'Ipul', '2025-05-05 21:40:57'),
('636', 'KI10100220250427163321013', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Tarekh', '0', '75000', 'Ipul', '2025-05-05 21:40:57'),
('637', 'ST10100320250505074201', '1446-11-07', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '25000', '0', 'Chuwez', '2025-05-05 21:42:01'),
('638', 'ST10100320250505074201', '1446-11-07', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '25000', 'Chuwez', '2025-05-05 21:42:01'),
('639', 'ST10100320250505074236', '1446-11-07', '1.100.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '5000', '0', 'Chuwez', '2025-05-05 21:42:36'),
('640', 'ST10100320250505074236', '1446-11-07', '2.220.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '0', '5000', 'Chuwez', '2025-05-05 21:42:38'),
('641', 'ST10100320250505074300', '1446-11-07', '1.100.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '5000', '0', 'Chuwez', '2025-05-05 21:43:00'),
('642', 'ST10100320250505074300', '1446-11-07', '2.220.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '0', '5000', 'Chuwez', '2025-05-05 21:43:01'),
('643', 'ST10100320250505074330', '1446-11-07', '1.100.10', '101', 'an.AHMAD JAMALUL MAIMUN', '5000', '0', 'Chuwez', '2025-05-05 21:43:30'),
('644', 'ST10100320250505074330', '1446-11-07', '2.220.10', '101', 'an.AHMAD JAMALUL MAIMUN', '0', '5000', 'Chuwez', '2025-05-05 21:43:30'),
('645', 'ST10100320250505074414', '1446-11-07', '1.100.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '20000', '0', 'Chuwez', '2025-05-05 21:44:14'),
('646', 'ST10100320250505074414', '1446-11-07', '2.220.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '0', '20000', 'Chuwez', '2025-05-05 21:44:14'),
('647', 'KI10100220250427163337011', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Tauhid, Tajwid, Fiqih, Akhlaq dan Tarekh', '136000', '0', 'Ipul', '2025-05-05 21:44:40'),
('648', 'KI10100220250427163337011', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Tauhid, Tajwid, Fiqih, Akhlaq dan Tarekh', '0', '136000', 'Ipul', '2025-05-05 21:44:40'),
('649', 'KK10100320250505144422', '1446-11-07', '5.520.42', '101', 'Air dan kopi', '30000', '0', 'Ipul', '2025-05-05 21:45:09'),
('650', 'KK10100320250505144422', '1446-11-07', '1.100.10', '101', 'Air dan kopi', '0', '30000', 'Ipul', '2025-05-05 21:45:09'),
('651', 'KI10100220250427163321011', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Tarekh', '75000', '0', 'Ipul', '2025-05-05 21:45:16'),
('652', 'KI10100220250427163321011', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Tarekh', '0', '75000', 'Ipul', '2025-05-05 21:45:16'),
('653', 'ST10100320250505074551', '1446-11-07', '1.100.10', '101', 'an.AKHMAD FIKRI HAIKAL', '75000', '0', 'Chuwez', '2025-05-05 21:45:51'),
('654', 'ST10100320250505074551', '1446-11-07', '2.220.10', '101', 'an.AKHMAD FIKRI HAIKAL', '0', '75000', 'Chuwez', '2025-05-05 21:45:51'),
('655', 'KI10100220250427163321002', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Tarekh', '75000', '0', 'Ipul', '2025-05-05 21:45:51'),
('656', 'KI10100220250427163321002', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Tarekh', '0', '75000', 'Ipul', '2025-05-05 21:45:51'),
('657', 'KI10100220250427163321001', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Tarekh', '75000', '0', 'Ipul', '2025-05-05 21:46:18'),
('658', 'KI10100220250427163321001', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Tarekh', '0', '75000', 'Ipul', '2025-05-05 21:46:18'),
('659', 'ST10100320250505074634', '1446-11-07', '1.100.10', '101', 'an.BILQIS THALIA HASNA', '75000', '0', 'Chuwez', '2025-05-05 21:46:34'),
('660', 'ST10100320250505074634', '1446-11-07', '2.220.10', '101', 'an.BILQIS THALIA HASNA', '0', '75000', 'Chuwez', '2025-05-05 21:46:34'),
('661', 'KI10100220250427163337003', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Tarekh', '189000', '0', 'Ipul', '2025-05-05 21:47:01'),
('662', 'KI10100220250427163337003', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Tarekh', '0', '189000', 'Ipul', '2025-05-05 21:47:01'),
('663', 'ST10100320250505074707', '1446-11-07', '1.100.10', '101', 'an.M. ROFIQ', '50000', '0', 'Chuwez', '2025-05-05 21:47:07'),
('664', 'ST10100320250505074707', '1446-11-07', '2.220.10', '101', 'an.M. ROFIQ', '0', '50000', 'Chuwez', '2025-05-05 21:47:08'),
('665', 'ST10100320250505074737', '1446-11-07', '1.100.10', '101', 'an.M. HAIKAL NASRULLOH', '5000', '0', 'Chuwez', '2025-05-05 21:47:37'),
('666', 'ST10100320250505074737', '1446-11-07', '2.220.10', '101', 'an.M. HAIKAL NASRULLOH', '0', '5000', 'Chuwez', '2025-05-05 21:47:37'),
('667', 'ST10100320250505074804', '1446-11-07', '1.100.10', '101', 'an.SINDI RAISA PUTRI', '10000', '0', 'Chuwez', '2025-05-05 21:48:04'),
('668', 'ST10100320250505074804', '1446-11-07', '2.220.10', '101', 'an.SINDI RAISA PUTRI', '0', '10000', 'Chuwez', '2025-05-05 21:48:04'),
('669', 'ST10100320250505074906', '1446-11-07', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Chuwez', '2025-05-05 21:49:06'),
('670', 'ST10100320250505074906', '1446-11-07', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Chuwez', '2025-05-05 21:49:06'),
('671', 'ST10100320250505075018', '1446-11-07', '1.100.10', '101', 'an.NABILATUN NISAUL UMMAH', '20000', '0', 'Chuwez', '2025-05-05 21:50:18'),
('672', 'ST10100320250505075018', '1446-11-07', '2.220.10', '101', 'an.NABILATUN NISAUL UMMAH', '0', '20000', 'Chuwez', '2025-05-05 21:50:18'),
('673', 'ST10100320250505075036', '1446-11-07', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '5000', '0', 'Chuwez', '2025-05-05 21:50:36'),
('674', 'ST10100320250505075036', '1446-11-07', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '5000', 'Chuwez', '2025-05-05 21:50:36'),
('675', 'ST10100320250505075108', '1446-11-07', '1.100.10', '101', 'an.MUTHIMATUS SHOLIHAH', '10000', '0', 'Chuwez', '2025-05-05 21:51:08'),
('676', 'ST10100320250505075108', '1446-11-07', '2.220.10', '101', 'an.MUTHIMATUS SHOLIHAH', '0', '10000', 'Chuwez', '2025-05-05 21:51:08'),
('677', 'ST10100320250505075136', '1446-11-07', '1.100.10', '101', 'an.MIFTAHUL JANNAH', '50000', '0', 'Chuwez', '2025-05-05 21:51:36'),
('678', 'ST10100320250505075136', '1446-11-07', '2.220.10', '101', 'an.MIFTAHUL JANNAH', '0', '50000', 'Chuwez', '2025-05-05 21:51:36'),
('679', 'ST10100320250505075156', '1446-11-07', '1.100.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '20000', '0', 'Chuwez', '2025-05-05 21:51:56'),
('680', 'ST10100320250505075156', '1446-11-07', '2.220.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '0', '20000', 'Chuwez', '2025-05-05 21:51:57'),
('681', 'ST10100320250505075441', '1446-11-07', '1.100.10', '101', 'an.NIKMATUL MAULIDAH', '5000', '0', 'Chuwez', '2025-05-05 21:54:41'),
('682', 'ST10100320250505075441', '1446-11-07', '2.220.10', '101', 'an.NIKMATUL MAULIDAH', '0', '5000', 'Chuwez', '2025-05-05 21:54:42'),
('683', 'ST10100320250505075503', '1446-11-07', '1.100.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '5000', '0', 'Chuwez', '2025-05-05 21:55:03'),
('684', 'ST10100320250505075503', '1446-11-07', '2.220.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '0', '5000', 'Chuwez', '2025-05-05 21:55:03'),
('685', 'ST10100320250505075527', '1446-11-07', '1.100.10', '101', 'an.M. KAMALUDDIN', '20000', '0', 'Chuwez', '2025-05-05 21:55:27'),
('686', 'ST10100320250505075527', '1446-11-07', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '20000', 'Chuwez', '2025-05-05 21:55:27'),
('687', 'ST10100320250505075547', '1446-11-07', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '5000', '0', 'Chuwez', '2025-05-05 21:55:47'),
('688', 'ST10100320250505075547', '1446-11-07', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '5000', 'Chuwez', '2025-05-05 21:55:48'),
('689', 'ST10100320250505075614', '1446-11-07', '1.100.10', '101', 'an.RENI FARIDA', '2000', '0', 'Chuwez', '2025-05-05 21:56:14'),
('690', 'ST10100320250505075614', '1446-11-07', '2.220.10', '101', 'an.RENI FARIDA', '0', '2000', 'Chuwez', '2025-05-05 21:56:14'),
('691', 'ST10100320250505075636', '1446-11-07', '1.100.10', '101', 'an.RAUDHOTUL JANNAH', '20000', '0', 'Chuwez', '2025-05-05 21:56:36'),
('692', 'ST10100320250505075636', '1446-11-07', '2.220.10', '101', 'an.RAUDHOTUL JANNAH', '0', '20000', 'Chuwez', '2025-05-05 21:56:36'),
('693', 'ST10100320250505075731', '1446-11-07', '1.100.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '10000', '0', 'Chuwez', '2025-05-05 21:57:31'),
('694', 'ST10100320250505075731', '1446-11-07', '2.220.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '0', '10000', 'Chuwez', '2025-05-05 21:57:31'),
('695', 'ST10100320250505080052', '1446-11-07', '1.100.10', '101', 'an.DIYANAH KAMALIYAH', '3000', '0', 'Chuwez', '2025-05-05 22:00:52'),
('696', 'ST10100320250505080052', '1446-11-07', '2.220.10', '101', 'an.DIYANAH KAMALIYAH', '0', '3000', 'Chuwez', '2025-05-05 22:00:52'),
('697', 'ST10100320250505080111', '1446-11-07', '1.100.10', '101', 'an.KHOIRIYAH', '20000', '0', 'Chuwez', '2025-05-05 22:01:11'),
('698', 'ST10100320250505080111', '1446-11-07', '2.220.10', '101', 'an.KHOIRIYAH', '0', '20000', 'Chuwez', '2025-05-05 22:01:11'),
('699', 'ST10100320250505080142', '1446-11-07', '1.100.10', '101', 'an.M. FAHMI NURUL ANAM', '10000', '0', 'Chuwez', '2025-05-05 22:01:42'),
('700', 'ST10100320250505080142', '1446-11-07', '2.220.10', '101', 'an.M. FAHMI NURUL ANAM', '0', '10000', 'Chuwez', '2025-05-05 22:01:42'),
('701', 'ST10100320250505080207', '1446-11-07', '1.100.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '10000', '0', 'Chuwez', '2025-05-05 22:02:07'),
('702', 'ST10100320250505080207', '1446-11-07', '2.220.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '0', '10000', 'Chuwez', '2025-05-05 22:02:07'),
('703', 'ST10100320250505080226', '1446-11-07', '1.100.10', '101', 'an.WARDATUL JANNAH', '2000', '0', 'Chuwez', '2025-05-05 22:02:26'),
('704', 'ST10100320250505080226', '1446-11-07', '2.220.10', '101', 'an.WARDATUL JANNAH', '0', '2000', 'Chuwez', '2025-05-05 22:02:26'),
('705', 'ST10100320250505080244', '1446-11-07', '1.100.10', '101', 'an.SITI ATHIUR ROHMAH', '5000', '0', 'Chuwez', '2025-05-05 22:02:44'),
('706', 'ST10100320250505080244', '1446-11-07', '2.220.10', '101', 'an.SITI ATHIUR ROHMAH', '0', '5000', 'Chuwez', '2025-05-05 22:02:44'),
('707', 'ST10100320250505080304', '1446-11-07', '1.100.10', '101', 'an.ABDUL HAMID', '5000', '0', 'Chuwez', '2025-05-05 22:03:04'),
('708', 'ST10100320250505080304', '1446-11-07', '2.220.10', '101', 'an.ABDUL HAMID', '0', '5000', 'Chuwez', '2025-05-05 22:03:04'),
('709', 'ST10100320250505080321', '1446-11-07', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '10000', '0', 'Chuwez', '2025-05-05 22:03:21'),
('710', 'ST10100320250505080321', '1446-11-07', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '10000', 'Chuwez', '2025-05-05 22:03:21'),
('711', 'ST10100320250505080348', '1446-11-07', '1.100.10', '101', 'an.SITI QURROTUL AINI', '2000', '0', 'Chuwez', '2025-05-05 22:03:48'),
('712', 'ST10100320250505080348', '1446-11-07', '2.220.10', '101', 'an.SITI QURROTUL AINI', '0', '2000', 'Chuwez', '2025-05-05 22:03:48'),
('713', 'ST10100320250505080409', '1446-11-07', '1.100.10', '101', 'an.AHMAD RAFI SALIM', '5000', '0', 'Chuwez', '2025-05-05 22:04:09'),
('714', 'ST10100320250505080409', '1446-11-07', '2.220.10', '101', 'an.AHMAD RAFI SALIM', '0', '5000', 'Chuwez', '2025-05-05 22:04:09'),
('715', 'ST10100320250505080431', '1446-11-07', '1.100.10', '101', 'an.HIKMIAH PUTRI NIKMATUNNAFILAH', '5000', '0', 'Chuwez', '2025-05-05 22:04:31'),
('716', 'ST10100320250505080431', '1446-11-07', '2.220.10', '101', 'an.HIKMIAH PUTRI NIKMATUNNAFILAH', '0', '5000', 'Chuwez', '2025-05-05 22:04:32'),
('717', 'ST10100320250505080515', '1446-11-07', '1.100.10', '101', 'an.MASRUROTUL MAULUDIYAH', '5000', '0', 'Chuwez', '2025-05-05 22:05:15'),
('718', 'ST10100320250505080515', '1446-11-07', '2.220.10', '101', 'an.MASRUROTUL MAULUDIYAH', '0', '5000', 'Chuwez', '2025-05-05 22:05:15'),
('719', 'ST10100320250505080547', '1446-11-07', '1.100.10', '101', 'an.M. DESTRA MAULANA', '25000', '0', 'Chuwez', '2025-05-05 22:05:47'),
('720', 'ST10100320250505080547', '1446-11-07', '2.220.10', '101', 'an.M. DESTRA MAULANA', '0', '25000', 'Chuwez', '2025-05-05 22:05:47'),
('721', 'ST10100320250505080607', '1446-11-07', '1.100.10', '101', 'an.DIANA RIFQOTUL QOLBI', '5000', '0', 'Chuwez', '2025-05-05 22:06:07'),
('722', 'ST10100320250505080607', '1446-11-07', '2.220.10', '101', 'an.DIANA RIFQOTUL QOLBI', '0', '5000', 'Chuwez', '2025-05-05 22:06:07'),
('723', 'ST10100320250505080626', '1446-11-07', '1.100.10', '101', 'an.AHMAD ADITIYA', '5000', '0', 'Chuwez', '2025-05-05 22:06:26'),
('724', 'ST10100320250505080626', '1446-11-07', '2.220.10', '101', 'an.AHMAD ADITIYA', '0', '5000', 'Chuwez', '2025-05-05 22:06:26'),
('725', 'ST10100320250505080641', '1446-11-07', '1.100.10', '101', 'an.AZKA AUFARIL MINAN', '10000', '0', 'Chuwez', '2025-05-05 22:06:41'),
('726', 'ST10100320250505080641', '1446-11-07', '2.220.10', '101', 'an.AZKA AUFARIL MINAN', '0', '10000', 'Chuwez', '2025-05-05 22:06:41'),
('727', 'ST10100320250505080658', '1446-11-07', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '10000', '0', 'Chuwez', '2025-05-05 22:06:58'),
('728', 'ST10100320250505080658', '1446-11-07', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '10000', 'Chuwez', '2025-05-05 22:06:58'),
('729', 'ST10100320250505080722', '1446-11-07', '1.100.10', '101', 'an.SAHILA MAFATIHATUL JANNAH', '5000', '0', 'Chuwez', '2025-05-05 22:07:22'),
('730', 'ST10100320250505080722', '1446-11-07', '2.220.10', '101', 'an.SAHILA MAFATIHATUL JANNAH', '0', '5000', 'Chuwez', '2025-05-05 22:07:22'),
('731', 'ST10100320250505080740', '1446-11-07', '1.100.10', '101', 'an.AISYAH', '5000', '0', 'Chuwez', '2025-05-05 22:07:40'),
('732', 'ST10100320250505080740', '1446-11-07', '2.220.10', '101', 'an.AISYAH', '0', '5000', 'Chuwez', '2025-05-05 22:07:40'),
('733', 'ST10100320250505080759', '1446-11-07', '1.100.10', '101', 'an.ALFI NURDIANA', '5000', '0', 'Chuwez', '2025-05-05 22:07:59'),
('734', 'ST10100320250505080759', '1446-11-07', '2.220.10', '101', 'an.ALFI NURDIANA', '0', '5000', 'Chuwez', '2025-05-05 22:07:59'),
('735', 'ST10100320250505080838', '1446-11-07', '1.100.10', '101', 'an.MUHAMMAD ARDIANSYAH', '5000', '0', 'Chuwez', '2025-05-05 22:08:38'),
('736', 'ST10100320250505080838', '1446-11-07', '2.220.10', '101', 'an.MUHAMMAD ARDIANSYAH', '0', '5000', 'Chuwez', '2025-05-05 22:08:38'),
('737', 'ST10100320250505080853', '1446-11-07', '1.100.10', '101', 'an.MUHAMMAD ALWI', '10000', '0', 'Chuwez', '2025-05-05 22:08:53'),
('738', 'ST10100320250505080853', '1446-11-07', '2.220.10', '101', 'an.MUHAMMAD ALWI', '0', '10000', 'Chuwez', '2025-05-05 22:08:53'),
('739', 'ST10100320250505080908', '1446-11-07', '1.100.10', '101', 'an.M. ABDIL ARIKIN', '5000', '0', 'Chuwez', '2025-05-05 22:09:08'),
('740', 'ST10100320250505080908', '1446-11-07', '2.220.10', '101', 'an.M. ABDIL ARIKIN', '0', '5000', 'Chuwez', '2025-05-05 22:09:09'),
('741', 'ST10100320250505080925', '1446-11-07', '1.100.10', '101', 'an.UBAIDAH', '10000', '0', 'Chuwez', '2025-05-05 22:09:25'),
('742', 'ST10100320250505080925', '1446-11-07', '2.220.10', '101', 'an.UBAIDAH', '0', '10000', 'Chuwez', '2025-05-05 22:09:26'),
('743', 'ST10100320250505080941', '1446-11-07', '1.100.10', '101', 'an.ABDULLOH BAHAR', '5000', '0', 'Chuwez', '2025-05-05 22:09:41'),
('744', 'ST10100320250505080941', '1446-11-07', '2.220.10', '101', 'an.ABDULLOH BAHAR', '0', '5000', 'Chuwez', '2025-05-05 22:09:41'),
('745', 'ST10100320250505081030', '1446-11-07', '1.100.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '4000', '0', 'Chuwez', '2025-05-05 22:10:30'),
('746', 'ST10100320250505081030', '1446-11-07', '2.220.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '0', '4000', 'Chuwez', '2025-05-05 22:10:30'),
('747', 'ST10100320250505081059', '1446-11-07', '1.100.10', '101', 'an.RAISA ANNISA', '15000', '0', 'Chuwez', '2025-05-05 22:10:59'),
('748', 'ST10100320250505081059', '1446-11-07', '2.220.10', '101', 'an.RAISA ANNISA', '0', '15000', 'Chuwez', '2025-05-05 22:10:59'),
('749', 'ST10100320250505081115', '1446-11-07', '1.100.10', '101', 'an.MARIATUL QIBTIYAH', '2000', '0', 'Chuwez', '2025-05-05 22:11:15'),
('750', 'ST10100320250505081115', '1446-11-07', '2.220.10', '101', 'an.MARIATUL QIBTIYAH', '0', '2000', 'Chuwez', '2025-05-05 22:11:15'),
('751', 'ST10100320250505081132', '1446-11-07', '1.100.10', '101', 'an.ADIBA QONITA', '10000', '0', 'Chuwez', '2025-05-05 22:11:32'),
('752', 'ST10100320250505081132', '1446-11-07', '2.220.10', '101', 'an.ADIBA QONITA', '0', '10000', 'Chuwez', '2025-05-05 22:11:33'),
('753', 'ST10100320250505081152', '1446-11-07', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'Chuwez', '2025-05-05 22:11:52'),
('754', 'ST10100320250505081152', '1446-11-07', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'Chuwez', '2025-05-05 22:11:52'),
('755', 'ST10100320250505081207', '1446-11-07', '1.100.10', '101', 'an.NAILATUN NIAMI', '2000', '0', 'Chuwez', '2025-05-05 22:12:07'),
('756', 'ST10100320250505081207', '1446-11-07', '2.220.10', '101', 'an.NAILATUN NIAMI', '0', '2000', 'Chuwez', '2025-05-05 22:12:07'),
('757', 'ST10100320250505081226', '1446-11-07', '1.100.10', '101', 'an.ROFIQOTUS SARIROH', '5000', '0', 'Chuwez', '2025-05-05 22:12:26'),
('758', 'ST10100320250505081226', '1446-11-07', '2.220.10', '101', 'an.ROFIQOTUS SARIROH', '0', '5000', 'Chuwez', '2025-05-05 22:12:26'),
('759', 'ST10100320250505081239', '1446-11-07', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '5000', '0', 'Chuwez', '2025-05-05 22:12:39'),
('760', 'ST10100320250505081239', '1446-11-07', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '5000', 'Chuwez', '2025-05-05 22:12:39'),
('761', 'ST10100320250505081255', '1446-11-07', '1.100.10', '101', 'an.UMAR FARUQ', '10000', '0', 'Chuwez', '2025-05-05 22:12:55'),
('762', 'ST10100320250505081255', '1446-11-07', '2.220.10', '101', 'an.UMAR FARUQ', '0', '10000', 'Chuwez', '2025-05-05 22:12:55'),
('763', 'ST10100320250505081312', '1446-11-07', '1.100.10', '101', 'an.FAIZAH NURUL LITA', '5000', '0', 'Chuwez', '2025-05-05 22:13:12'),
('764', 'ST10100320250505081312', '1446-11-07', '2.220.10', '101', 'an.FAIZAH NURUL LITA', '0', '5000', 'Chuwez', '2025-05-05 22:13:12'),
('765', 'ST10100320250505081329', '1446-11-07', '1.100.10', '101', 'an.MARIYATUL QIBTIYAH', '5000', '0', 'Chuwez', '2025-05-05 22:13:29'),
('766', 'ST10100320250505081329', '1446-11-07', '2.220.10', '101', 'an.MARIYATUL QIBTIYAH', '0', '5000', 'Chuwez', '2025-05-05 22:13:29'),
('767', 'ST10100320250505081402', '1446-11-07', '1.100.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '10000', '0', 'Chuwez', '2025-05-05 22:14:02'),
('768', 'ST10100320250505081402', '1446-11-07', '2.220.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '0', '10000', 'Chuwez', '2025-05-05 22:14:02'),
('769', 'ST10100320250505081418', '1446-11-07', '1.100.10', '101', 'an.HAIKAL SHOMADANI', '2000', '0', 'Chuwez', '2025-05-05 22:14:18'),
('770', 'ST10100320250505081418', '1446-11-07', '2.220.10', '101', 'an.HAIKAL SHOMADANI', '0', '2000', 'Chuwez', '2025-05-05 22:14:18'),
('771', 'ST10100320250505081437', '1446-11-07', '1.100.10', '101', 'an.ELOK WARDATUN NAFISAH', '10000', '0', 'Chuwez', '2025-05-05 22:14:37'),
('772', 'ST10100320250505081437', '1446-11-07', '2.220.10', '101', 'an.ELOK WARDATUN NAFISAH', '0', '10000', 'Chuwez', '2025-05-05 22:14:37'),
('773', 'ST10100320250505081454', '1446-11-07', '1.100.10', '101', 'an.NAURA BILADINA', '5000', '0', 'Chuwez', '2025-05-05 22:14:54'),
('774', 'ST10100320250505081454', '1446-11-07', '2.220.10', '101', 'an.NAURA BILADINA', '0', '5000', 'Chuwez', '2025-05-05 22:14:54'),
('775', 'ST10100320250505081515', '1446-11-07', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'Chuwez', '2025-05-05 22:15:15'),
('776', 'ST10100320250505081515', '1446-11-07', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'Chuwez', '2025-05-05 22:15:15'),
('777', 'ST10100320250505081531', '1446-11-07', '1.100.10', '101', 'an.AULIA AZZAHRA', '5000', '0', 'Chuwez', '2025-05-05 22:15:31'),
('778', 'ST10100320250505081531', '1446-11-07', '2.220.10', '101', 'an.AULIA AZZAHRA', '0', '5000', 'Chuwez', '2025-05-05 22:15:31'),
('779', 'ST10100320250505081546', '1446-11-07', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '5000', '0', 'Chuwez', '2025-05-05 22:15:46'),
('780', 'ST10100320250505081546', '1446-11-07', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '5000', 'Chuwez', '2025-05-05 22:15:46'),
('781', 'ST10100320250505081603', '1446-11-07', '1.100.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '5000', '0', 'Chuwez', '2025-05-05 22:16:03'),
('782', 'ST10100320250505081603', '1446-11-07', '2.220.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '0', '5000', 'Chuwez', '2025-05-05 22:16:03'),
('783', 'ST10100320250505081620', '1446-11-07', '1.100.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '5000', '0', 'Chuwez', '2025-05-05 22:16:20'),
('784', 'ST10100320250505081620', '1446-11-07', '2.220.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '0', '5000', 'Chuwez', '2025-05-05 22:16:21'),
('785', 'ST10100320250505074933', '1446-11-07', '1.100.10', '101', 'Koreksi tabungan an.ABDUL MUTHOLLIB', '3000', '0', 'Ipul', '2025-05-05 22:33:41'),
('786', 'ST10100320250505074933', '1446-11-07', '2.220.10', '101', 'Koreksi tabungan an.ABDUL MUTHOLLIB', '0', '3000', 'Ipul', '2025-05-05 22:33:41'),
('787', 'KI10100220250427163237011', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Tauhid dan Tajwid', '70000', '0', 'Ipul', '2025-05-05 22:49:14'),
('788', 'KI10100220250427163237011', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Tauhid dan Tajwid', '0', '70000', 'Ipul', '2025-05-05 22:49:14'),
('789', 'KI10100220250427163219007', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Tauhid, Fasholatan dan BHS Arab', '42000', '0', 'Ipul', '2025-05-05 22:50:24'),
('790', 'KI10100220250427163219007', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Tauhid, Fasholatan dan BHS Arab', '0', '42000', 'Ipul', '2025-05-05 22:50:24'),
('791', 'KI10100220250427163237008', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Fiqih, Tauhid, Tajwid, Terjemah tarekh dan Ghorib', '49000', '0', 'Ipul', '2025-05-05 22:52:31'),
('792', 'KI10100220250427163237008', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Fiqih, Tauhid, Tajwid, Terjemah tarekh dan Ghorib', '0', '49000', 'Ipul', '2025-05-05 22:52:31'),
('793', 'KI10100220250427163219011', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Tauhid, Fasholatan dan BHS Arab', '42000', '0', 'Ipul', '2025-05-05 22:56:49'),
('794', 'KI10100220250427163219011', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Tauhid, Fasholatan dan BHS Arab', '0', '42000', 'Ipul', '2025-05-05 22:56:49'),
('795', 'ST10100320250506072956', '1446-11-08', '1.100.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '2000', '0', 'Chuwez', '2025-05-06 21:29:56'),
('796', 'ST10100320250506072956', '1446-11-08', '2.220.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '0', '2000', 'Chuwez', '2025-05-06 21:29:56'),
('797', 'ST10100320250506073019', '1446-11-08', '1.100.10', '101', 'an.M. ABD. HADI', '2000', '0', 'Chuwez', '2025-05-06 21:30:19'),
('798', 'ST10100320250506073019', '1446-11-08', '2.220.10', '101', 'an.M. ABD. HADI', '0', '2000', 'Chuwez', '2025-05-06 21:30:19'),
('799', 'ST10100320250506073045', '1446-11-08', '1.100.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '5000', '0', 'Chuwez', '2025-05-06 21:30:45'),
('800', 'ST10100320250506073045', '1446-11-08', '2.220.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '0', '5000', 'Chuwez', '2025-05-06 21:30:45'),
('801', 'ST10100320250506073130', '1446-11-08', '1.100.10', '101', 'an.UBAIDAH', '10000', '0', 'Chuwez', '2025-05-06 21:31:30'),
('802', 'ST10100320250506073130', '1446-11-08', '2.220.10', '101', 'an.UBAIDAH', '0', '10000', 'Chuwez', '2025-05-06 21:31:30'),
('803', 'ST10100320250506073151', '1446-11-08', '1.100.10', '101', 'an.ADIBA QONITA', '10000', '0', 'Chuwez', '2025-05-06 21:31:51'),
('804', 'ST10100320250506073151', '1446-11-08', '2.220.10', '101', 'an.ADIBA QONITA', '0', '10000', 'Chuwez', '2025-05-06 21:31:51'),
('805', 'ST10100320250506073211', '1446-11-08', '1.100.10', '101', 'an.RAISA ANNISA', '5000', '0', 'Chuwez', '2025-05-06 21:32:11'),
('806', 'ST10100320250506073211', '1446-11-08', '2.220.10', '101', 'an.RAISA ANNISA', '0', '5000', 'Chuwez', '2025-05-06 21:32:11'),
('807', 'ST10100320250506073234', '1446-11-08', '1.100.10', '101', 'an.FAIZAH NURUL LITA', '5000', '0', 'Chuwez', '2025-05-06 21:32:34'),
('808', 'ST10100320250506073234', '1446-11-08', '2.220.10', '101', 'an.FAIZAH NURUL LITA', '0', '5000', 'Chuwez', '2025-05-06 21:32:34'),
('809', 'ST10100320250506073307', '1446-11-08', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '5000', '0', 'Chuwez', '2025-05-06 21:33:07'),
('810', 'ST10100320250506073307', '1446-11-08', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '5000', 'Chuwez', '2025-05-06 21:33:07'),
('811', 'ST10100320250506073439', '1446-11-08', '1.100.10', '101', 'an.AULIA AZZAHRA', '5000', '0', 'Chuwez', '2025-05-06 21:34:39'),
('812', 'ST10100320250506073439', '1446-11-08', '2.220.10', '101', 'an.AULIA AZZAHRA', '0', '5000', 'Chuwez', '2025-05-06 21:34:39'),
('813', 'ST10100320250506073501', '1446-11-08', '1.100.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '5000', '0', 'Chuwez', '2025-05-06 21:35:01'),
('814', 'ST10100320250506073501', '1446-11-08', '2.220.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '0', '5000', 'Chuwez', '2025-05-06 21:35:01'),
('815', 'ST10100320250506073526', '1446-11-08', '1.100.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '4000', '0', 'Chuwez', '2025-05-06 21:35:26'),
('816', 'ST10100320250506073526', '1446-11-08', '2.220.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '0', '4000', 'Chuwez', '2025-05-06 21:35:26'),
('817', 'ST10100320250506073710', '1446-11-08', '1.100.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '10000', '0', 'Chuwez', '2025-05-06 21:37:10'),
('818', 'ST10100320250506073710', '1446-11-08', '2.220.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '0', '10000', 'Chuwez', '2025-05-06 21:37:10'),
('819', 'ST10100320250506073746', '1446-11-08', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '5000', '0', 'Chuwez', '2025-05-06 21:37:46'),
('820', 'ST10100320250506073746', '1446-11-08', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '5000', 'Chuwez', '2025-05-06 21:37:46'),
('821', 'ST10100320250506073804', '1446-11-08', '1.100.10', '101', 'an.HAIKAL SHOMADANI', '2000', '0', 'Chuwez', '2025-05-06 21:38:04'),
('822', 'ST10100320250506073804', '1446-11-08', '2.220.10', '101', 'an.HAIKAL SHOMADANI', '0', '2000', 'Chuwez', '2025-05-06 21:38:04'),
('823', 'ST10100320250506073826', '1446-11-08', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'Chuwez', '2025-05-06 21:38:26'),
('824', 'ST10100320250506073826', '1446-11-08', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'Chuwez', '2025-05-06 21:38:26'),
('825', 'ST10100320250506073851', '1446-11-08', '1.100.10', '101', 'an.NAURA BILADINA', '7000', '0', 'Chuwez', '2025-05-06 21:38:51'),
('826', 'ST10100320250506073851', '1446-11-08', '2.220.10', '101', 'an.NAURA BILADINA', '0', '7000', 'Chuwez', '2025-05-06 21:38:51'),
('827', 'ST10100320250506073952', '1446-11-08', '1.100.10', '101', 'an.UMAR FARUQ', '10000', '0', 'Chuwez', '2025-05-06 21:39:52'),
('828', 'ST10100320250506073952', '1446-11-08', '2.220.10', '101', 'an.UMAR FARUQ', '0', '10000', 'Chuwez', '2025-05-06 21:39:52'),
('829', 'ST10100320250506074025', '1446-11-08', '1.100.10', '101', 'an.MARIATUL QIBTIYAH', '4000', '0', 'Chuwez', '2025-05-06 21:40:25'),
('830', 'ST10100320250506074025', '1446-11-08', '2.220.10', '101', 'an.MARIATUL QIBTIYAH', '0', '4000', 'Chuwez', '2025-05-06 21:40:25'),
('831', 'ST10100320250506074046', '1446-11-08', '1.100.10', '101', 'an.NAILATUN NIAMI', '2000', '0', 'Chuwez', '2025-05-06 21:40:46'),
('832', 'ST10100320250506074046', '1446-11-08', '2.220.10', '101', 'an.NAILATUN NIAMI', '0', '2000', 'Chuwez', '2025-05-06 21:40:46'),
('833', 'ST10100320250506074106', '1446-11-08', '1.100.10', '101', 'an.ROFIQOTUS SARIROH', '5000', '0', 'Chuwez', '2025-05-06 21:41:06'),
('834', 'ST10100320250506074106', '1446-11-08', '2.220.10', '101', 'an.ROFIQOTUS SARIROH', '0', '5000', 'Chuwez', '2025-05-06 21:41:06'),
('835', 'ST10100320250506074125', '1446-11-08', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'Chuwez', '2025-05-06 21:41:25'),
('836', 'ST10100320250506074125', '1446-11-08', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'Chuwez', '2025-05-06 21:41:25'),
('837', 'ST10100320250506074154', '1446-11-08', '1.100.10', '101', 'an.MUHAMMAD ARDIANSYAH', '10000', '0', 'Chuwez', '2025-05-06 21:41:54'),
('838', 'ST10100320250506074154', '1446-11-08', '2.220.10', '101', 'an.MUHAMMAD ARDIANSYAH', '0', '10000', 'Chuwez', '2025-05-06 21:41:54'),
('839', 'ST10100320250506074217', '1446-11-08', '1.100.10', '101', 'an.ABDULLOH BAHAR', '5000', '0', 'Chuwez', '2025-05-06 21:42:17'),
('840', 'ST10100320250506074217', '1446-11-08', '2.220.10', '101', 'an.ABDULLOH BAHAR', '0', '5000', 'Chuwez', '2025-05-06 21:42:17'),
('841', 'ST10100320250506074234', '1446-11-08', '1.100.10', '101', 'an.MARIYATUL QIBTIYAH', '5000', '0', 'Chuwez', '2025-05-06 21:42:34'),
('842', 'ST10100320250506074234', '1446-11-08', '2.220.10', '101', 'an.MARIYATUL QIBTIYAH', '0', '5000', 'Chuwez', '2025-05-06 21:42:35'),
('843', 'ST10100320250506074307', '1446-11-08', '1.100.10', '101', 'an.AISYAH', '5000', '0', 'Chuwez', '2025-05-06 21:43:07'),
('844', 'ST10100320250506074307', '1446-11-08', '2.220.10', '101', 'an.AISYAH', '0', '5000', 'Chuwez', '2025-05-06 21:43:07'),
('845', 'ST10100320250506074328', '1446-11-08', '1.100.10', '101', 'an.AZKA AUFARIL MINAN', '10000', '0', 'Chuwez', '2025-05-06 21:43:28'),
('846', 'ST10100320250506074328', '1446-11-08', '2.220.10', '101', 'an.AZKA AUFARIL MINAN', '0', '10000', 'Chuwez', '2025-05-06 21:43:28'),
('847', 'ST10100320250506074355', '1446-11-08', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '10000', '0', 'Chuwez', '2025-05-06 21:43:55'),
('848', 'ST10100320250506074355', '1446-11-08', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '10000', 'Chuwez', '2025-05-06 21:43:55'),
('849', 'ST10100320250506074425', '1446-11-08', '1.100.10', '101', 'an.M. DESTRA MAULANA', '25000', '0', 'Chuwez', '2025-05-06 21:44:25'),
('850', 'ST10100320250506074425', '1446-11-08', '2.220.10', '101', 'an.M. DESTRA MAULANA', '0', '25000', 'Chuwez', '2025-05-06 21:44:25'),
('851', 'ST10100320250506074442', '1446-11-08', '1.100.10', '101', 'an.AHMAD ADITIYA', '5000', '0', 'Chuwez', '2025-05-06 21:44:42'),
('852', 'ST10100320250506074442', '1446-11-08', '2.220.10', '101', 'an.AHMAD ADITIYA', '0', '5000', 'Chuwez', '2025-05-06 21:44:42'),
('853', 'ST10100320250506074644', '1446-11-08', '1.100.10', '101', 'an.ALFI NURDIANA', '5000', '0', 'Chuwez', '2025-05-06 21:46:44'),
('854', 'ST10100320250506074644', '1446-11-08', '2.220.10', '101', 'an.ALFI NURDIANA', '0', '5000', 'Chuwez', '2025-05-06 21:46:44'),
('855', 'ST10100320250506074725', '1446-11-08', '1.100.10', '101', 'an.LAILATUL MAGHFIROH', '15000', '0', 'Chuwez', '2025-05-06 21:47:25'),
('856', 'ST10100320250506074725', '1446-11-08', '2.220.10', '101', 'an.LAILATUL MAGHFIROH', '0', '15000', 'Chuwez', '2025-05-06 21:47:25'),
('857', 'ST10100320250506074747', '1446-11-08', '1.100.10', '101', 'an.MASRUROTUL MAULUDIYAH', '5000', '0', 'Chuwez', '2025-05-06 21:47:47'),
('858', 'ST10100320250506074747', '1446-11-08', '2.220.10', '101', 'an.MASRUROTUL MAULUDIYAH', '0', '5000', 'Chuwez', '2025-05-06 21:47:47'),
('859', 'ST10100320250506074905', '1446-11-08', '1.100.10', '101', 'an.WARDATUL JANNAH', '3000', '0', 'Chuwez', '2025-05-06 21:49:05'),
('860', 'ST10100320250506074905', '1446-11-08', '2.220.10', '101', 'an.WARDATUL JANNAH', '0', '3000', 'Chuwez', '2025-05-06 21:49:05'),
('861', 'ST10100320250506074927', '1446-11-08', '1.100.10', '101', 'an.M. FAHMI NURUL ANAM', '10000', '0', 'Chuwez', '2025-05-06 21:49:27'),
('862', 'ST10100320250506074927', '1446-11-08', '2.220.10', '101', 'an.M. FAHMI NURUL ANAM', '0', '10000', 'Chuwez', '2025-05-06 21:49:27'),
('863', 'ST10100320250506074953', '1446-11-08', '1.100.10', '101', 'an.KHOIRIYAH', '10000', '0', 'Chuwez', '2025-05-06 21:49:53'),
('864', 'ST10100320250506074953', '1446-11-08', '2.220.10', '101', 'an.KHOIRIYAH', '0', '10000', 'Chuwez', '2025-05-06 21:49:53'),
('865', 'ST10100320250506075016', '1446-11-08', '1.100.10', '101', 'an.AHMAD RAFI SALIM', '2000', '0', 'Chuwez', '2025-05-06 21:50:16'),
('866', 'ST10100320250506075016', '1446-11-08', '2.220.10', '101', 'an.AHMAD RAFI SALIM', '0', '2000', 'Chuwez', '2025-05-06 21:50:16'),
('867', 'ST10100320250506075119', '1446-11-08', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '10000', '0', 'Chuwez', '2025-05-06 21:51:19'),
('868', 'ST10100320250506075119', '1446-11-08', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '10000', 'Chuwez', '2025-05-06 21:51:19'),
('869', 'ST10100320250506075155', '1446-11-08', '1.100.10', '101', 'an.HIKMIAH PUTRI NIKMATUNNAFILAH', '5000', '0', 'Chuwez', '2025-05-06 21:51:55'),
('870', 'ST10100320250506075155', '1446-11-08', '2.220.10', '101', 'an.HIKMIAH PUTRI NIKMATUNNAFILAH', '0', '5000', 'Chuwez', '2025-05-06 21:51:55'),
('871', 'ST10100320250506075214', '1446-11-08', '1.100.10', '101', 'an.SITI ATHIUR ROHMAH', '5000', '0', 'Chuwez', '2025-05-06 21:52:14'),
('872', 'ST10100320250506075214', '1446-11-08', '2.220.10', '101', 'an.SITI ATHIUR ROHMAH', '0', '5000', 'Chuwez', '2025-05-06 21:52:14'),
('873', 'ST10100320250506075233', '1446-11-08', '1.100.10', '101', 'an.DIYANAH KAMALIYAH', '5000', '0', 'Chuwez', '2025-05-06 21:52:33'),
('874', 'ST10100320250506075233', '1446-11-08', '2.220.10', '101', 'an.DIYANAH KAMALIYAH', '0', '5000', 'Chuwez', '2025-05-06 21:52:33'),
('875', 'ST10100320250506075255', '1446-11-08', '1.100.10', '101', 'an.SITI QURROTUL AINI', '2000', '0', 'Chuwez', '2025-05-06 21:52:55'),
('876', 'ST10100320250506075255', '1446-11-08', '2.220.10', '101', 'an.SITI QURROTUL AINI', '0', '2000', 'Chuwez', '2025-05-06 21:52:55'),
('877', 'ST10100320250506075339', '1446-11-08', '1.100.10', '101', 'an.M. KAMALUDDIN', '50000', '0', 'Chuwez', '2025-05-06 21:53:39'),
('878', 'ST10100320250506075339', '1446-11-08', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '50000', 'Chuwez', '2025-05-06 21:53:39'),
('879', 'ST10100320250506075402', '1446-11-08', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '10000', '0', 'Chuwez', '2025-05-06 21:54:02'),
('880', 'ST10100320250506075402', '1446-11-08', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '10000', 'Chuwez', '2025-05-06 21:54:02'),
('881', 'ST10100320250506075519', '1446-11-08', '1.100.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '10000', '0', 'Chuwez', '2025-05-06 21:55:19'),
('882', 'ST10100320250506075519', '1446-11-08', '2.220.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '0', '10000', 'Chuwez', '2025-05-06 21:55:19'),
('883', 'ST10100320250506075538', '1446-11-08', '1.100.10', '101', 'an.IZZA BILLAH', '10000', '0', 'Chuwez', '2025-05-06 21:55:38'),
('884', 'ST10100320250506075538', '1446-11-08', '2.220.10', '101', 'an.IZZA BILLAH', '0', '10000', 'Chuwez', '2025-05-06 21:55:39'),
('885', 'ST10100320250506075600', '1446-11-08', '1.100.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '20000', '0', 'Chuwez', '2025-05-06 21:56:00'),
('886', 'ST10100320250506075600', '1446-11-08', '2.220.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '0', '20000', 'Chuwez', '2025-05-06 21:56:00'),
('887', 'ST10100320250506075623', '1446-11-08', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '4000', '0', 'Chuwez', '2025-05-06 21:56:23'),
('888', 'ST10100320250506075623', '1446-11-08', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '4000', 'Chuwez', '2025-05-06 21:56:23'),
('889', 'ST10100320250506075649', '1446-11-08', '1.100.10', '101', 'an.MIFTAHUL JANNAH', '50000', '0', 'Chuwez', '2025-05-06 21:56:49'),
('890', 'ST10100320250506075649', '1446-11-08', '2.220.10', '101', 'an.MIFTAHUL JANNAH', '0', '50000', 'Chuwez', '2025-05-06 21:56:49'),
('891', 'ST10100320250506075711', '1446-11-08', '1.100.10', '101', 'an.RAUDHOTUL JANNAH', '20000', '0', 'Chuwez', '2025-05-06 21:57:11'),
('892', 'ST10100320250506075711', '1446-11-08', '2.220.10', '101', 'an.RAUDHOTUL JANNAH', '0', '20000', 'Chuwez', '2025-05-06 21:57:11'),
('893', 'ST10100320250506075731', '1446-11-08', '1.100.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '5000', '0', 'Chuwez', '2025-05-06 21:57:31'),
('894', 'ST10100320250506075731', '1446-11-08', '2.220.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '0', '5000', 'Chuwez', '2025-05-06 21:57:31'),
('895', 'ST10100320250506075753', '1446-11-08', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '10000', '0', 'Chuwez', '2025-05-06 21:57:53'),
('896', 'ST10100320250506075753', '1446-11-08', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '10000', 'Chuwez', '2025-05-06 21:57:54'),
('897', 'ST10100320250506075815', '1446-11-08', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Chuwez', '2025-05-06 21:58:15'),
('898', 'ST10100320250506075815', '1446-11-08', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Chuwez', '2025-05-06 21:58:15'),
('899', 'ST10100320250506075846', '1446-11-08', '1.100.10', '101', 'an.NABILATUN NISAUL UMMAH', '20000', '0', 'Chuwez', '2025-05-06 21:58:46'),
('900', 'ST10100320250506075846', '1446-11-08', '2.220.10', '101', 'an.NABILATUN NISAUL UMMAH', '0', '20000', 'Chuwez', '2025-05-06 21:58:46'),
('901', 'ST10100320250506080106', '1446-11-08', '1.100.10', '101', 'an.M. HAIKAL NASRULLOH', '4000', '0', 'Chuwez', '2025-05-06 22:01:06'),
('902', 'ST10100320250506080106', '1446-11-08', '2.220.10', '101', 'an.M. HAIKAL NASRULLOH', '0', '4000', 'Chuwez', '2025-05-06 22:01:06'),
('903', 'ST10100320250506080125', '1446-11-08', '1.100.10', '101', 'an.SINDI RAISA PUTRI', '10000', '0', 'Chuwez', '2025-05-06 22:01:25'),
('904', 'ST10100320250506080125', '1446-11-08', '2.220.10', '101', 'an.SINDI RAISA PUTRI', '0', '10000', 'Chuwez', '2025-05-06 22:01:25'),
('905', 'ST10100320250506080147', '1446-11-08', '1.100.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '5000', '0', 'Chuwez', '2025-05-06 22:01:47'),
('906', 'ST10100320250506080147', '1446-11-08', '2.220.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '0', '5000', 'Chuwez', '2025-05-06 22:01:47'),
('907', 'ST10100320250506080205', '1446-11-08', '1.100.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '5000', '0', 'Chuwez', '2025-05-06 22:02:05'),
('908', 'ST10100320250506080205', '1446-11-08', '2.220.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '0', '5000', 'Chuwez', '2025-05-06 22:02:05'),
('909', 'ST10100320250506080223', '1446-11-08', '1.100.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '10000', '0', 'Chuwez', '2025-05-06 22:02:23'),
('910', 'ST10100320250506080223', '1446-11-08', '2.220.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '0', '10000', 'Chuwez', '2025-05-06 22:02:23'),
('911', 'ST10100320250506080241', '1446-11-08', '1.100.10', '101', 'an.AHMAD JAMALUL MAIMUN', '5000', '0', 'Chuwez', '2025-05-06 22:02:41'),
('912', 'ST10100320250506080241', '1446-11-08', '2.220.10', '101', 'an.AHMAD JAMALUL MAIMUN', '0', '5000', 'Chuwez', '2025-05-06 22:02:41'),
('913', 'ST10100320250506080306', '1446-11-08', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '25000', '0', 'Chuwez', '2025-05-06 22:03:06'),
('914', 'ST10100320250506080306', '1446-11-08', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '25000', 'Chuwez', '2025-05-06 22:03:06'),
('915', 'ST10100320250506080327', '1446-11-08', '1.100.10', '101', 'an.AKHMAD FIKRI HAIKAL', '50000', '0', 'Chuwez', '2025-05-06 22:03:27'),
('916', 'ST10100320250506080327', '1446-11-08', '2.220.10', '101', 'an.AKHMAD FIKRI HAIKAL', '0', '50000', 'Chuwez', '2025-05-06 22:03:27'),
('917', 'ST10100320250506080352', '1446-11-08', '1.100.10', '101', 'an.MUHAMMAD HAMDANI', '5000', '0', 'Chuwez', '2025-05-06 22:03:52'),
('918', 'ST10100320250506080352', '1446-11-08', '2.220.10', '101', 'an.MUHAMMAD HAMDANI', '0', '5000', 'Chuwez', '2025-05-06 22:03:52'),
('919', 'ST10100320250506080422', '1446-11-08', '1.100.10', '101', 'an.ROBIATUL ADAWIYAH', '2000', '0', 'Chuwez', '2025-05-06 22:04:22'),
('920', 'ST10100320250506080422', '1446-11-08', '2.220.10', '101', 'an.ROBIATUL ADAWIYAH', '0', '2000', 'Chuwez', '2025-05-06 22:04:22'),
('921', 'ST10100320250506080444', '1446-11-08', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '5000', '0', 'Chuwez', '2025-05-06 22:04:44'),
('922', 'ST10100320250506080444', '1446-11-08', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '5000', 'Chuwez', '2025-05-06 22:04:44'),
('923', 'ST10100320250506080520', '1446-11-08', '1.100.10', '101', 'an.ZAKIYATUL UMMAH', '2000', '0', 'Chuwez', '2025-05-06 22:05:20'),
('924', 'ST10100320250506080520', '1446-11-08', '2.220.10', '101', 'an.ZAKIYATUL UMMAH', '0', '2000', 'Chuwez', '2025-05-06 22:05:20'),
('925', 'ST10100320250506080540', '1446-11-08', '1.100.10', '101', 'an.MUHAMMAD KHOIRON', '5000', '0', 'Chuwez', '2025-05-06 22:05:40'),
('926', 'ST10100320250506080540', '1446-11-08', '2.220.10', '101', 'an.MUHAMMAD KHOIRON', '0', '5000', 'Chuwez', '2025-05-06 22:05:40'),
('927', 'ST10100320250506080600', '1446-11-08', '1.100.10', '101', 'an.M. ALIFIN FIKRI', '2000', '0', 'Chuwez', '2025-05-06 22:06:00'),
('928', 'ST10100320250506080600', '1446-11-08', '2.220.10', '101', 'an.M. ALIFIN FIKRI', '0', '2000', 'Chuwez', '2025-05-06 22:06:00'),
('929', 'ST10100320250506080617', '1446-11-08', '1.100.10', '101', 'an.MUHAMMAD YAHYA SYAKARUDDIN', '5000', '0', 'Chuwez', '2025-05-06 22:06:17'),
('930', 'ST10100320250506080617', '1446-11-08', '2.220.10', '101', 'an.MUHAMMAD YAHYA SYAKARUDDIN', '0', '5000', 'Chuwez', '2025-05-06 22:06:17'),
('931', 'ST10100320250506080700', '1446-11-08', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '10000', '0', 'Chuwez', '2025-05-06 22:07:00'),
('932', 'ST10100320250506080700', '1446-11-08', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '10000', 'Chuwez', '2025-05-06 22:07:00'),
('933', 'ST10100320250506080717', '1446-11-08', '1.100.10', '101', 'an.AFANDI', '2000', '0', 'Chuwez', '2025-05-06 22:07:17'),
('934', 'ST10100320250506080717', '1446-11-08', '2.220.10', '101', 'an.AFANDI', '0', '2000', 'Chuwez', '2025-05-06 22:07:17'),
('935', 'ST10100320250506080734', '1446-11-08', '1.100.10', '101', 'an.ANA SALSABILA', '5000', '0', 'Chuwez', '2025-05-06 22:07:34'),
('936', 'ST10100320250506080734', '1446-11-08', '2.220.10', '101', 'an.ANA SALSABILA', '0', '5000', 'Chuwez', '2025-05-06 22:07:34'),
('937', 'ST10100320250506080757', '1446-11-08', '1.100.10', '101', 'an.SAFIRATUL JANNAH', '10000', '0', 'Chuwez', '2025-05-06 22:07:57'),
('938', 'ST10100320250506080757', '1446-11-08', '2.220.10', '101', 'an.SAFIRATUL JANNAH', '0', '10000', 'Chuwez', '2025-05-06 22:07:57'),
('939', 'ST10100320250506080820', '1446-11-08', '1.100.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '2000', '0', 'Chuwez', '2025-05-06 22:08:20'),
('940', 'ST10100320250506080820', '1446-11-08', '2.220.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '0', '2000', 'Chuwez', '2025-05-06 22:08:20'),
('941', 'ST10100320250506080843', '1446-11-08', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '20000', '0', 'Chuwez', '2025-05-06 22:08:43'),
('942', 'ST10100320250506080843', '1446-11-08', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '20000', 'Chuwez', '2025-05-06 22:08:43'),
('943', 'ST10100320250506080855', '1446-11-08', '1.100.10', '101', 'an.M. ZIDAN RIZQI SALIM', '10000', '0', 'Chuwez', '2025-05-06 22:08:55'),
('944', 'ST10100320250506080855', '1446-11-08', '2.220.10', '101', 'an.M. ZIDAN RIZQI SALIM', '0', '10000', 'Chuwez', '2025-05-06 22:08:55'),
('945', 'ST10100320250506080914', '1446-11-08', '1.100.10', '101', 'an.ACH. JUNAIDI', '5000', '0', 'Chuwez', '2025-05-06 22:09:14'),
('946', 'ST10100320250506080914', '1446-11-08', '2.220.10', '101', 'an.ACH. JUNAIDI', '0', '5000', 'Chuwez', '2025-05-06 22:09:14'),
('947', 'ST10100320250506082855', '1446-11-08', '1.100.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '10000', '0', 'Chuwez', '2025-05-06 22:28:55'),
('948', 'ST10100320250506082855', '1446-11-08', '2.220.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '0', '10000', 'Chuwez', '2025-05-06 22:28:55'),
('949', 'ST10100320250506082920', '1446-11-08', '1.100.10', '101', 'an.NAYLA FITRI AULIA', '10000', '0', 'Chuwez', '2025-05-06 22:29:20'),
('950', 'ST10100320250506082920', '1446-11-08', '2.220.10', '101', 'an.NAYLA FITRI AULIA', '0', '10000', 'Chuwez', '2025-05-06 22:29:20'),
('951', 'ST10100320250506084007', '1446-11-08', '1.100.10', '101', 'an.MOCH KHOTIBUL UMAM', '50000', '0', 'Chuwez', '2025-05-06 22:40:07'),
('952', 'ST10100320250506084007', '1446-11-08', '2.220.10', '101', 'an.MOCH KHOTIBUL UMAM', '0', '50000', 'Chuwez', '2025-05-06 22:40:07'),
('953', 'KK10100320250506160340', '1446-11-08', '5.520.42', '101', 'Beli cilok', '10000', '0', 'Chuwez', '2025-05-06 23:03:57'),
('954', 'KK10100320250506160340', '1446-11-08', '1.100.10', '101', 'Beli cilok', '0', '10000', 'Chuwez', '2025-05-06 23:03:57'),
('955', 'ST10100320250506142937', '1446-11-03', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'Chuwez', '2025-05-07 04:29:37'),
('956', 'ST10100320250506142937', '1446-11-03', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'Chuwez', '2025-05-07 04:29:37'),
('957', 'ST10100320250506143228', '1446-11-05', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'Chuwez', '2025-05-07 04:32:28'),
('958', 'ST10100320250506143228', '1446-11-05', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'Chuwez', '2025-05-07 04:32:28'),
('959', 'ST10100320250506143308', '1446-11-06', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'Chuwez', '2025-05-07 04:33:08'),
('960', 'ST10100320250506143308', '1446-11-06', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'Chuwez', '2025-05-07 04:33:08'),
('961', 'ST10100320250506143345', '1446-11-07', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'Chuwez', '2025-05-07 04:33:45'),
('962', 'ST10100320250506143345', '1446-11-07', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'Chuwez', '2025-05-07 04:33:45'),
('963', 'ST10100320250506143430', '1446-11-08', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'Chuwez', '2025-05-07 04:34:30'),
('964', 'ST10100320250506143430', '1446-11-08', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'Chuwez', '2025-05-07 04:34:30'),
('965', 'ST10100320250506143956', '1446-11-03', '1.100.10', '101', 'an.HALIMAH', '10000', '0', 'Chuwez', '2025-05-07 04:39:56'),
('966', 'ST10100320250506143956', '1446-11-03', '2.220.10', '101', 'an.HALIMAH', '0', '10000', 'Chuwez', '2025-05-07 04:39:56'),
('967', 'ST10100320250506144943', '1446-11-05', '1.100.10', '101', 'an.HALIMAH', '5000', '0', 'Chuwez', '2025-05-07 04:49:43'),
('968', 'ST10100320250506144943', '1446-11-05', '2.220.10', '101', 'an.HALIMAH', '0', '5000', 'Chuwez', '2025-05-07 04:49:43'),
('969', 'ST10100320250506145023', '1446-11-07', '1.100.10', '101', 'an.HALIMAH', '15000', '0', 'Chuwez', '2025-05-07 04:50:23'),
('970', 'ST10100320250506145023', '1446-11-07', '2.220.10', '101', 'an.HALIMAH', '0', '15000', 'Chuwez', '2025-05-07 04:50:23'),
('971', 'ST10100320250506145054', '1446-11-08', '1.100.10', '101', 'an.HALIMAH', '5000', '0', 'Chuwez', '2025-05-07 04:50:54'),
('972', 'ST10100320250506145054', '1446-11-08', '2.220.10', '101', 'an.HALIMAH', '0', '5000', 'Chuwez', '2025-05-07 04:50:54'),
('973', 'ST10100320250506145248', '1446-11-05', '1.100.10', '101', 'an.HAMIDAH', '100000', '0', 'Chuwez', '2025-05-07 04:52:48'),
('974', 'ST10100320250506145248', '1446-11-05', '2.220.10', '101', 'an.HAMIDAH', '0', '100000', 'Chuwez', '2025-05-07 04:52:48'),
('975', 'ST10100320250506145323', '1446-11-06', '1.100.10', '101', 'an.HAMIDAH', '5000', '0', 'Chuwez', '2025-05-07 04:53:23'),
('976', 'ST10100320250506145323', '1446-11-06', '2.220.10', '101', 'an.HAMIDAH', '0', '5000', 'Chuwez', '2025-05-07 04:53:23'),
('977', 'ST10100320250506145356', '1446-11-07', '1.100.10', '101', 'an.HAMIDAH', '5000', '0', 'Chuwez', '2025-05-07 04:53:56'),
('978', 'ST10100320250506145356', '1446-11-07', '2.220.10', '101', 'an.HAMIDAH', '0', '5000', 'Chuwez', '2025-05-07 04:53:56'),
('979', 'ST10100320250506145423', '1446-11-08', '1.100.10', '101', 'an.HAMIDAH', '10000', '0', 'Chuwez', '2025-05-07 04:54:23'),
('980', 'ST10100320250506145423', '1446-11-08', '2.220.10', '101', 'an.HAMIDAH', '0', '10000', 'Chuwez', '2025-05-07 04:54:23'),
('981', 'ST10100320250506145819', '1446-11-03', '1.100.10', '101', 'an.HILYA', '20000', '0', 'Chuwez', '2025-05-07 04:58:19'),
('982', 'ST10100320250506145819', '1446-11-03', '2.220.10', '101', 'an.HILYA', '0', '20000', 'Chuwez', '2025-05-07 04:58:19'),
('983', 'ST10100320250506145951', '1446-11-06', '1.100.10', '101', 'an.HILYA', '100000', '0', 'Chuwez', '2025-05-07 04:59:51'),
('984', 'ST10100320250506145951', '1446-11-06', '2.220.10', '101', 'an.HILYA', '0', '100000', 'Chuwez', '2025-05-07 04:59:51'),
('985', 'SY10100320250506162907', '1446-11-08', '1.100.10', '101', 'Bayar Syahriah bulan syawal - shofar[MOCH KHOTIBUL UMAM]', '150000', '0', 'Chuwez', '2025-05-07 06:29:07'),
('986', 'SY10100320250506162907', '1446-11-08', '4.400.20', '101', 'Bayar Syahriah bulan syawal - shofar[MOCH KHOTIBUL UMAM]', '0', '150000', 'Chuwez', '2025-05-07 06:29:07'),
('987', 'SY10100320250506164556', '1446-11-08', '1.100.10', '101', 'Bayar Syahriah bulan syawal dan dz qodah[NAYLA FITRI AULIA]', '60000', '0', 'Chuwez', '2025-05-07 06:45:56'),
('988', 'SY10100320250506164556', '1446-11-08', '4.400.20', '101', 'Bayar Syahriah bulan syawal dan dz qodah[NAYLA FITRI AULIA]', '0', '60000', 'Chuwez', '2025-05-07 06:45:56'),
('991', 'KI10100220250506170000', '1446-11-08', '1.100.10', '101', 'Bayar[M.AKMALUL HIMAM]', '50000', '0', 'Ipul', '2025-05-07 07:00:00'),
('992', 'KI10100220250506170000', '1446-11-08', '4.400.21', '101', 'Bayar[M.AKMALUL HIMAM]', '0', '50000', 'Ipul', '2025-05-07 07:00:00'),
('993', 'SY10100320250506171429', '1446-11-09', '1.100.10', '101', 'Bayar syahriyah bulan syawal - robiul awal[M. ZAINURI AZIZ SINATRIA]', '180000', '0', 'Chuwez', '2025-05-07 07:14:29'),
('994', 'SY10100320250506171429', '1446-11-09', '4.400.20', '101', 'Bayar syahriyah bulan syawal - robiul awal[M. ZAINURI AZIZ SINATRIA]', '0', '180000', 'Chuwez', '2025-05-07 07:14:29'),
('995', 'SY10100320250506172944', '1446-11-09', '1.100.10', '101', 'Bayar Syahriah bulan dz qodah[MUTHIMATUS SHOLIHAH]', '30000', '0', 'Chuwez', '2025-05-07 07:29:44'),
('996', 'SY10100320250506172944', '1446-11-09', '4.400.20', '101', 'Bayar Syahriah bulan dz qodah[MUTHIMATUS SHOLIHAH]', '0', '30000', 'Chuwez', '2025-05-07 07:29:44'),
('997', 'SY10100320250506173052', '1446-11-09', '1.100.10', '101', 'Bayar Syahriyah bulan syawal - dz hijjah[MUHAMMAD YAQUB HAMDANI]', '90000', '0', 'Chuwez', '2025-05-07 07:30:52'),
('998', 'SY10100320250506173052', '1446-11-09', '4.400.20', '101', 'Bayar Syahriyah bulan syawal - dz hijjah[MUHAMMAD YAQUB HAMDANI]', '0', '90000', 'Chuwez', '2025-05-07 07:30:52'),
('999', 'SY10100320250506173221', '1446-11-09', '1.100.10', '101', 'Bayar Syahriyah bulan dz qodah[SALWA LAILI]', '30000', '0', 'Chuwez', '2025-05-07 07:32:21'),
('1000', 'SY10100320250506173221', '1446-11-09', '4.400.20', '101', 'Bayar Syahriyah bulan dz qodah[SALWA LAILI]', '0', '30000', 'Chuwez', '2025-05-07 07:32:21'),
('1001', 'ST10100320250507063534', '1446-11-09', '1.100.10', '101', 'an.MARIATUL QIBTIYAH', '4000', '0', 'chuwez', '2025-05-07 20:35:34'),
('1002', 'ST10100320250507063534', '1446-11-09', '2.220.10', '101', 'an.MARIATUL QIBTIYAH', '0', '4000', 'chuwez', '2025-05-07 20:35:34'),
('1003', 'ST10100320250507063630', '1446-11-09', '1.100.10', '101', 'an.SAUQY AHMAD', '10000', '0', 'chuwez', '2025-05-07 20:36:30'),
('1004', 'ST10100320250507063630', '1446-11-09', '2.220.10', '101', 'an.SAUQY AHMAD', '0', '10000', 'chuwez', '2025-05-07 20:36:30'),
('1005', 'ST10100320250507063748', '1446-11-09', '1.100.10', '101', 'an.RAISA ANNISA', '5000', '0', 'chuwez', '2025-05-07 20:37:48'),
('1006', 'ST10100320250507063748', '1446-11-09', '2.220.10', '101', 'an.RAISA ANNISA', '0', '5000', 'chuwez', '2025-05-07 20:37:48'),
('1007', 'ST10100320250507063900', '1446-11-09', '1.100.10', '101', 'an.MUHAMMAD ARDIANSYAH', '10000', '0', 'chuwez', '2025-05-07 20:39:00'),
('1008', 'ST10100320250507063900', '1446-11-09', '2.220.10', '101', 'an.MUHAMMAD ARDIANSYAH', '0', '10000', 'chuwez', '2025-05-07 20:39:00'),
('1009', 'ST10100320250507064010', '1446-11-09', '1.100.10', '101', 'an.MILLAH KAMILAH', '50000', '0', 'chuwez', '2025-05-07 20:40:10'),
('1010', 'ST10100320250507064010', '1446-11-09', '2.220.10', '101', 'an.MILLAH KAMILAH', '0', '50000', 'chuwez', '2025-05-07 20:40:10'),
('1011', 'ST10100320250507064248', '1446-11-09', '1.100.10', '101', 'an.ROFIQOTUS SARIROH', '5000', '0', 'chuwez', '2025-05-07 20:42:48'),
('1012', 'ST10100320250507064248', '1446-11-09', '2.220.10', '101', 'an.ROFIQOTUS SARIROH', '0', '5000', 'chuwez', '2025-05-07 20:42:48'),
('1013', 'ST10100320250507064406', '1446-11-09', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'chuwez', '2025-05-07 20:44:06'),
('1014', 'ST10100320250507064406', '1446-11-09', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'chuwez', '2025-05-07 20:44:06'),
('1015', 'ST10100320250507064457', '1446-11-09', '1.100.10', '101', 'an.UBAIDAH', '20000', '0', 'chuwez', '2025-05-07 20:44:57'),
('1016', 'ST10100320250507064457', '1446-11-09', '2.220.10', '101', 'an.UBAIDAH', '0', '20000', 'chuwez', '2025-05-07 20:44:57'),
('1017', 'ST10100320250507064537', '1446-11-09', '1.100.10', '101', 'an.NAILATUN NIAMI', '5000', '0', 'chuwez', '2025-05-07 20:45:37'),
('1018', 'ST10100320250507064537', '1446-11-09', '2.220.10', '101', 'an.NAILATUN NIAMI', '0', '5000', 'chuwez', '2025-05-07 20:45:37'),
('1019', 'ST10100320250507064631', '1446-11-09', '1.100.10', '101', 'an.UMAR FARUQ', '5000', '0', 'chuwez', '2025-05-07 20:46:31'),
('1020', 'ST10100320250507064631', '1446-11-09', '2.220.10', '101', 'an.UMAR FARUQ', '0', '5000', 'chuwez', '2025-05-07 20:46:31'),
('1021', 'ST10100320250507064714', '1446-11-09', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '5000', '0', 'chuwez', '2025-05-07 20:47:14'),
('1022', 'ST10100320250507064714', '1446-11-09', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '5000', 'chuwez', '2025-05-07 20:47:14'),
('1023', 'ST10100320250507064808', '1446-11-09', '1.100.10', '101', 'an.MUHAMMAD ALWI', '10000', '0', 'chuwez', '2025-05-07 20:48:08'),
('1024', 'ST10100320250507064808', '1446-11-09', '2.220.10', '101', 'an.MUHAMMAD ALWI', '0', '10000', 'chuwez', '2025-05-07 20:48:08'),
('1025', 'ST10100320250507064920', '1446-11-09', '1.100.10', '101', 'an.ROHMATULLOH', '5000', '0', 'chuwez', '2025-05-07 20:49:20'),
('1026', 'ST10100320250507064920', '1446-11-09', '2.220.10', '101', 'an.ROHMATULLOH', '0', '5000', 'chuwez', '2025-05-07 20:49:21'),
('1027', 'ST10100320250507065023', '1446-11-09', '1.100.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '7000', '0', 'chuwez', '2025-05-07 20:50:23'),
('1028', 'ST10100320250507065023', '1446-11-09', '2.220.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '0', '7000', 'chuwez', '2025-05-07 20:50:23'),
('1029', 'ST10100320250507070701', '1446-11-09', '1.100.10', '101', 'an.WARDATUL JANNAH', '2000', '0', 'chuwez', '2025-05-07 21:07:01'),
('1030', 'ST10100320250507070701', '1446-11-09', '2.220.10', '101', 'an.WARDATUL JANNAH', '0', '2000', 'chuwez', '2025-05-07 21:07:01'),
('1031', 'ST10100320250507070747', '1446-11-09', '1.100.10', '101', 'an.SITI QURROTUL AINI', '2000', '0', 'chuwez', '2025-05-07 21:07:47'),
('1032', 'ST10100320250507070747', '1446-11-09', '2.220.10', '101', 'an.SITI QURROTUL AINI', '0', '2000', 'chuwez', '2025-05-07 21:07:48'),
('1033', 'ST10100320250507070949', '1446-11-09', '1.100.10', '101', 'an.ABDUL HAMID', '2000', '0', 'chuwez', '2025-05-07 21:09:49'),
('1034', 'ST10100320250507070949', '1446-11-09', '2.220.10', '101', 'an.ABDUL HAMID', '0', '2000', 'chuwez', '2025-05-07 21:09:49'),
('1035', 'ST10100320250507071112', '1446-11-09', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '10000', '0', 'chuwez', '2025-05-07 21:11:12'),
('1036', 'ST10100320250507071112', '1446-11-09', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '10000', 'chuwez', '2025-05-07 21:11:12'),
('1037', 'ST10100320250507071152', '1446-11-09', '1.100.10', '101', 'an.AHMAD SYAHRU ROMADHONI', '20000', '0', 'chuwez', '2025-05-07 21:11:52'),
('1038', 'ST10100320250507071152', '1446-11-09', '2.220.10', '101', 'an.AHMAD SYAHRU ROMADHONI', '0', '20000', 'chuwez', '2025-05-07 21:11:52'),
('1039', 'ST10100320250507071248', '1446-11-09', '1.100.10', '101', 'an.SITI ATHIUR ROHMAH', '5000', '0', 'chuwez', '2025-05-07 21:12:48'),
('1040', 'ST10100320250507071248', '1446-11-09', '2.220.10', '101', 'an.SITI ATHIUR ROHMAH', '0', '5000', 'chuwez', '2025-05-07 21:12:48'),
('1041', 'ST10100320250507071325', '1446-11-09', '1.100.10', '101', 'an.DIYANAH KAMALIYAH', '5000', '0', 'chuwez', '2025-05-07 21:13:25'),
('1042', 'ST10100320250507071325', '1446-11-09', '2.220.10', '101', 'an.DIYANAH KAMALIYAH', '0', '5000', 'chuwez', '2025-05-07 21:13:25'),
('1043', 'ST10100320250507071408', '1446-11-09', '1.100.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '10000', '0', 'chuwez', '2025-05-07 21:14:08'),
('1044', 'ST10100320250507071408', '1446-11-09', '2.220.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '0', '10000', 'chuwez', '2025-05-07 21:14:08'),
('1045', 'ST10100320250507071456', '1446-11-09', '1.100.10', '101', 'an.HIKMIAH PUTRI NIKMATUNNAFILAH', '5000', '0', 'chuwez', '2025-05-07 21:14:56'),
('1046', 'ST10100320250507071456', '1446-11-09', '2.220.10', '101', 'an.HIKMIAH PUTRI NIKMATUNNAFILAH', '0', '5000', 'chuwez', '2025-05-07 21:14:56'),
('1047', 'ST10100320250507071542', '1446-11-09', '1.100.10', '101', 'an.M. DESTRA MAULANA', '20000', '0', 'chuwez', '2025-05-07 21:15:42'),
('1048', 'ST10100320250507071542', '1446-11-09', '2.220.10', '101', 'an.M. DESTRA MAULANA', '0', '20000', 'chuwez', '2025-05-07 21:15:42'),
('1049', 'ST10100320250507071851', '1446-11-09', '1.100.10', '101', 'an.AZKA AUFARIL MINAN', '10000', '0', 'chuwez', '2025-05-07 21:18:51'),
('1050', 'ST10100320250507071851', '1446-11-09', '2.220.10', '101', 'an.AZKA AUFARIL MINAN', '0', '10000', 'chuwez', '2025-05-07 21:18:52'),
('1051', 'ST10100320250507071947', '1446-11-09', '1.100.10', '101', 'an.AHMAD ADITIYA', '5000', '0', 'chuwez', '2025-05-07 21:19:47'),
('1052', 'ST10100320250507071947', '1446-11-09', '2.220.10', '101', 'an.AHMAD ADITIYA', '0', '5000', 'chuwez', '2025-05-07 21:19:47'),
('1053', 'ST10100320250507072058', '1446-11-09', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '10000', '0', 'chuwez', '2025-05-07 21:20:58'),
('1054', 'ST10100320250507072058', '1446-11-09', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '10000', 'chuwez', '2025-05-07 21:20:58'),
('1055', 'ST10100320250507072136', '1446-11-09', '1.100.10', '101', 'an.AISYAH', '2000', '0', 'chuwez', '2025-05-07 21:21:36'),
('1056', 'ST10100320250507072136', '1446-11-09', '2.220.10', '101', 'an.AISYAH', '0', '2000', 'chuwez', '2025-05-07 21:21:36'),
('1057', 'ST10100320250507072928', '1446-11-09', '1.100.10', '101', 'an.MARIYATUL QIBTIYAH', '5000', '0', 'chuwez', '2025-05-07 21:29:28'),
('1058', 'ST10100320250507072928', '1446-11-09', '2.220.10', '101', 'an.MARIYATUL QIBTIYAH', '0', '5000', 'chuwez', '2025-05-07 21:29:28'),
('1059', 'ST10100320250507073000', '1446-11-09', '1.100.10', '101', 'an.ELOK WARDATUN NAFISAH', '5000', '0', 'chuwez', '2025-05-07 21:30:00'),
('1060', 'ST10100320250507073000', '1446-11-09', '2.220.10', '101', 'an.ELOK WARDATUN NAFISAH', '0', '5000', 'chuwez', '2025-05-07 21:30:00'),
('1061', 'ST10100320250507073048', '1446-11-09', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'chuwez', '2025-05-07 21:30:48'),
('1062', 'ST10100320250507073048', '1446-11-09', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'chuwez', '2025-05-07 21:30:48'),
('1063', 'ST10100320250507073113', '1446-11-09', '1.100.10', '101', 'an.NAURA BILADINA', '5000', '0', 'chuwez', '2025-05-07 21:31:13'),
('1064', 'ST10100320250507073113', '1446-11-09', '2.220.10', '101', 'an.NAURA BILADINA', '0', '5000', 'chuwez', '2025-05-07 21:31:13'),
('1065', 'ST10100320250507073133', '1446-11-09', '1.100.10', '101', 'an.M. ABD. HADI', '2000', '0', 'chuwez', '2025-05-07 21:31:33'),
('1066', 'ST10100320250507073133', '1446-11-09', '2.220.10', '101', 'an.M. ABD. HADI', '0', '2000', 'chuwez', '2025-05-07 21:31:33'),
('1067', 'ST10100320250507073153', '1446-11-09', '1.100.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '2000', '0', 'chuwez', '2025-05-07 21:31:53'),
('1068', 'ST10100320250507073153', '1446-11-09', '2.220.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '0', '2000', 'chuwez', '2025-05-07 21:31:53'),
('1069', 'ST10100320250507073215', '1446-11-09', '1.100.10', '101', 'an.AULIA AZZAHRA', '2000', '0', 'chuwez', '2025-05-07 21:32:15'),
('1070', 'ST10100320250507073215', '1446-11-09', '2.220.10', '101', 'an.AULIA AZZAHRA', '0', '2000', 'chuwez', '2025-05-07 21:32:15'),
('1071', 'ST10100320250507073235', '1446-11-09', '1.100.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '5000', '0', 'chuwez', '2025-05-07 21:32:35'),
('1072', 'ST10100320250507073235', '1446-11-09', '2.220.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '0', '5000', 'chuwez', '2025-05-07 21:32:35'),
('1073', 'ST10100320250507073259', '1446-11-09', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '5000', '0', 'chuwez', '2025-05-07 21:32:59'),
('1074', 'ST10100320250507073259', '1446-11-09', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '5000', 'chuwez', '2025-05-07 21:32:59'),
('1075', 'ST10100320250507073327', '1446-11-09', '1.100.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '5000', '0', 'chuwez', '2025-05-07 21:33:27'),
('1076', 'ST10100320250507073327', '1446-11-09', '2.220.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '0', '5000', 'chuwez', '2025-05-07 21:33:27'),
('1077', 'ST10100320250507073427', '1446-11-09', '1.100.10', '101', 'an.NIKMATUL MAULIDAH', '5000', '0', 'chuwez', '2025-05-07 21:34:27'),
('1078', 'ST10100320250507073427', '1446-11-09', '2.220.10', '101', 'an.NIKMATUL MAULIDAH', '0', '5000', 'chuwez', '2025-05-07 21:34:27'),
('1079', 'ST10100320250507073502', '1446-11-09', '1.100.10', '101', 'an.RENI FARIDA', '2000', '0', 'chuwez', '2025-05-07 21:35:02'),
('1080', 'ST10100320250507073502', '1446-11-09', '2.220.10', '101', 'an.RENI FARIDA', '0', '2000', 'chuwez', '2025-05-07 21:35:02'),
('1081', 'ST10100320250507073524', '1446-11-09', '1.100.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '5000', '0', 'chuwez', '2025-05-07 21:35:24'),
('1082', 'ST10100320250507073524', '1446-11-09', '2.220.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '0', '5000', 'chuwez', '2025-05-07 21:35:25'),
('1083', 'ST10100320250507073548', '1446-11-09', '1.100.10', '101', 'an.IZZA BILLAH', '20000', '0', 'chuwez', '2025-05-07 21:35:48'),
('1084', 'ST10100320250507073548', '1446-11-09', '2.220.10', '101', 'an.IZZA BILLAH', '0', '20000', 'chuwez', '2025-05-07 21:35:48'),
('1085', 'ST10100320250507073653', '1446-11-09', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '2000', '0', 'chuwez', '2025-05-07 21:36:53'),
('1086', 'ST10100320250507073653', '1446-11-09', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '2000', 'chuwez', '2025-05-07 21:36:53'),
('1087', 'ST10100320250507073723', '1446-11-09', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '5000', '0', 'chuwez', '2025-05-07 21:37:23'),
('1088', 'ST10100320250507073723', '1446-11-09', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '5000', 'chuwez', '2025-05-07 21:37:24'),
('1089', 'ST10100320250507073744', '1446-11-09', '1.100.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '5000', '0', 'chuwez', '2025-05-07 21:37:44'),
('1090', 'ST10100320250507073744', '1446-11-09', '2.220.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '0', '5000', 'chuwez', '2025-05-07 21:37:44'),
('1091', 'ST10100320250507073803', '1446-11-09', '1.100.10', '101', 'an.M. KAMALUDDIN', '20000', '0', 'chuwez', '2025-05-07 21:38:03'),
('1092', 'ST10100320250507073803', '1446-11-09', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '20000', 'chuwez', '2025-05-07 21:38:03'),
('1093', 'ST10100320250507073831', '1446-11-09', '1.100.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '20000', '0', 'chuwez', '2025-05-07 21:38:31'),
('1094', 'ST10100320250507073831', '1446-11-09', '2.220.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '0', '20000', 'chuwez', '2025-05-07 21:38:31'),
('1095', 'ST10100320250507073907', '1446-11-09', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '5000', '0', 'chuwez', '2025-05-07 21:39:07'),
('1096', 'ST10100320250507073907', '1446-11-09', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '5000', 'chuwez', '2025-05-07 21:39:07'),
('1097', 'ST10100320250507073933', '1446-11-09', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'chuwez', '2025-05-07 21:39:33'),
('1098', 'ST10100320250507073933', '1446-11-09', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'chuwez', '2025-05-07 21:39:33'),
('1099', 'ST10100320250507073959', '1446-11-09', '1.100.10', '101', 'an.NABILATUN NISAUL UMMAH', '20000', '0', 'chuwez', '2025-05-07 21:39:59'),
('1100', 'ST10100320250507073959', '1446-11-09', '2.220.10', '101', 'an.NABILATUN NISAUL UMMAH', '0', '20000', 'chuwez', '2025-05-07 21:39:59'),
('1101', 'ST10100320250507074055', '1446-11-09', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '25000', '0', 'chuwez', '2025-05-07 21:40:55'),
('1102', 'ST10100320250507074055', '1446-11-09', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '25000', 'chuwez', '2025-05-07 21:40:55'),
('1103', 'ST10100320250507074127', '1446-11-09', '1.100.10', '101', 'an.SINDI RAISA PUTRI', '10000', '0', 'chuwez', '2025-05-07 21:41:27'),
('1104', 'ST10100320250507074127', '1446-11-09', '2.220.10', '101', 'an.SINDI RAISA PUTRI', '0', '10000', 'chuwez', '2025-05-07 21:41:27'),
('1105', 'ST10100320250507074159', '1446-11-09', '1.100.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '5000', '0', 'chuwez', '2025-05-07 21:41:59'),
('1106', 'ST10100320250507074159', '1446-11-09', '2.220.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '0', '5000', 'chuwez', '2025-05-07 21:41:59'),
('1107', 'ST10100320250507074226', '1446-11-09', '1.100.10', '101', 'an.AHMAD JAMALUL MAIMUN', '5000', '0', 'chuwez', '2025-05-07 21:42:26'),
('1108', 'ST10100320250507074226', '1446-11-09', '2.220.10', '101', 'an.AHMAD JAMALUL MAIMUN', '0', '5000', 'chuwez', '2025-05-07 21:42:26'),
('1109', 'ST10100320250507074247', '1446-11-09', '1.100.10', '101', 'an.M. ROFIQ', '10000', '0', 'chuwez', '2025-05-07 21:42:47'),
('1110', 'ST10100320250507074247', '1446-11-09', '2.220.10', '101', 'an.M. ROFIQ', '0', '10000', 'chuwez', '2025-05-07 21:42:47'),
('1111', 'ST10100320250507074430', '1446-11-09', '1.100.10', '101', 'an.AKHMAD FIKRI HAIKAL', '50000', '0', 'chuwez', '2025-05-07 21:44:30'),
('1112', 'ST10100320250507074430', '1446-11-09', '2.220.10', '101', 'an.AKHMAD FIKRI HAIKAL', '0', '50000', 'chuwez', '2025-05-07 21:44:30'),
('1113', 'ST10100320250507074510', '1446-11-09', '1.100.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '5000', '0', 'chuwez', '2025-05-07 21:45:10'),
('1114', 'ST10100320250507074510', '1446-11-09', '2.220.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '0', '5000', 'chuwez', '2025-05-07 21:45:10'),
('1115', 'ST10100320250507074604', '1446-11-09', '1.100.10', '101', 'an.MUHAMMAD HAMDANI', '5000', '0', 'chuwez', '2025-05-07 21:46:04'),
('1116', 'ST10100320250507074604', '1446-11-09', '2.220.10', '101', 'an.MUHAMMAD HAMDANI', '0', '5000', 'chuwez', '2025-05-07 21:46:04'),
('1117', 'ST10100320250507074642', '1446-11-09', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '5000', '0', 'chuwez', '2025-05-07 21:46:42'),
('1118', 'ST10100320250507074642', '1446-11-09', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '5000', 'chuwez', '2025-05-07 21:46:42'),
('1119', 'ST10100320250507074720', '1446-11-09', '1.100.10', '101', 'an.AFANDI', '2000', '0', 'chuwez', '2025-05-07 21:47:20'),
('1120', 'ST10100320250507074720', '1446-11-09', '2.220.10', '101', 'an.AFANDI', '0', '2000', 'chuwez', '2025-05-07 21:47:20'),
('1121', 'ST10100320250507074810', '1446-11-09', '1.100.10', '101', 'an.ZAKIYATUL UMMAH', '2000', '0', 'chuwez', '2025-05-07 21:48:10'),
('1122', 'ST10100320250507074810', '1446-11-09', '2.220.10', '101', 'an.ZAKIYATUL UMMAH', '0', '2000', 'chuwez', '2025-05-07 21:48:10'),
('1123', 'ST10100320250507074833', '1446-11-09', '1.100.10', '101', 'an.ANA SALSABILA', '5000', '0', 'chuwez', '2025-05-07 21:48:33'),
('1124', 'ST10100320250507074833', '1446-11-09', '2.220.10', '101', 'an.ANA SALSABILA', '0', '5000', 'chuwez', '2025-05-07 21:48:33'),
('1125', 'ST10100320250507074858', '1446-11-09', '1.100.10', '101', 'an.ROBIATUL ADAWIYAH', '3000', '0', 'chuwez', '2025-05-07 21:48:58'),
('1126', 'ST10100320250507074858', '1446-11-09', '2.220.10', '101', 'an.ROBIATUL ADAWIYAH', '0', '3000', 'chuwez', '2025-05-07 21:48:58'),
('1127', 'ST10100320250507074926', '1446-11-09', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '2000', '0', 'chuwez', '2025-05-07 21:49:26'),
('1128', 'ST10100320250507074926', '1446-11-09', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '2000', 'chuwez', '2025-05-07 21:49:26'),
('1129', 'ST10100320250507075012', '1446-11-09', '1.100.10', '101', 'an.ACH. JUNAIDI', '5000', '0', 'chuwez', '2025-05-07 21:50:12'),
('1130', 'ST10100320250507075012', '1446-11-09', '2.220.10', '101', 'an.ACH. JUNAIDI', '0', '5000', 'chuwez', '2025-05-07 21:50:12'),
('1131', 'ST10100320250507075036', '1446-11-09', '1.100.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '2000', '0', 'chuwez', '2025-05-07 21:50:36'),
('1132', 'ST10100320250507075036', '1446-11-09', '2.220.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '0', '2000', 'chuwez', '2025-05-07 21:50:36'),
('1133', 'ST10100320250507075054', '1446-11-09', '1.100.10', '101', 'an.M. ZIDAN RIZQI SALIM', '5000', '0', 'chuwez', '2025-05-07 21:50:54'),
('1134', 'ST10100320250507075054', '1446-11-09', '2.220.10', '101', 'an.M. ZIDAN RIZQI SALIM', '0', '5000', 'chuwez', '2025-05-07 21:50:54'),
('1135', 'ST10100320250507075116', '1446-11-09', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '15000', '0', 'chuwez', '2025-05-07 21:51:16'),
('1136', 'ST10100320250507075116', '1446-11-09', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '15000', 'chuwez', '2025-05-07 21:51:16'),
('1137', 'ST10100320250507075246', '1446-11-07', '1.100.10', '101', 'an.HILYA', '10000', '0', 'chuwez', '2025-05-07 21:52:46'),
('1138', 'ST10100320250507075246', '1446-11-07', '2.220.10', '101', 'an.HILYA', '0', '10000', 'chuwez', '2025-05-07 21:52:46'),
('1139', 'ST10100320250507075338', '1446-11-09', '1.100.10', '101', 'an.HILYA', '20000', '0', 'chuwez', '2025-05-07 21:53:38'),
('1140', 'ST10100320250507075338', '1446-11-09', '2.220.10', '101', 'an.HILYA', '0', '20000', 'chuwez', '2025-05-07 21:53:38'),
('1141', 'ST10100320250507075419', '1446-11-09', '1.100.10', '101', 'an.HALIMAH', '5000', '0', 'chuwez', '2025-05-07 21:54:19'),
('1142', 'ST10100320250507075419', '1446-11-09', '2.220.10', '101', 'an.HALIMAH', '0', '5000', 'chuwez', '2025-05-07 21:54:19'),
('1143', 'ST10100320250507075459', '1446-11-09', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'chuwez', '2025-05-07 21:54:59'),
('1144', 'ST10100320250507075459', '1446-11-09', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'chuwez', '2025-05-07 21:54:59'),
('1145', 'ST10100320250507075546', '1446-11-09', '1.100.10', '101', 'an.HAMIDAH', '10000', '0', 'chuwez', '2025-05-07 21:55:46'),
('1146', 'ST10100320250507075546', '1446-11-09', '2.220.10', '101', 'an.HAMIDAH', '0', '10000', 'chuwez', '2025-05-07 21:55:46'),
('1147', 'ST10100320250507080630', '1446-11-06', '1.100.10', '101', 'an.MACHMUDAH', '30000', '0', 'chuwez', '2025-05-07 22:06:30'),
('1148', 'ST10100320250507080630', '1446-11-06', '2.220.10', '101', 'an.MACHMUDAH', '0', '30000', 'chuwez', '2025-05-07 22:06:30'),
('1149', 'ST10100320250507080700', '1446-11-08', '1.100.10', '101', 'an.MACHMUDAH', '10000', '0', 'chuwez', '2025-05-07 22:07:00'),
('1150', 'ST10100320250507080700', '1446-11-08', '2.220.10', '101', 'an.MACHMUDAH', '0', '10000', 'chuwez', '2025-05-07 22:07:01'),
('1151', 'ST10100320250507080808', '1446-11-09', '1.100.10', '101', 'an.MACHMUDAH', '10000', '0', 'chuwez', '2025-05-07 22:08:08'),
('1152', 'ST10100320250507080808', '1446-11-09', '2.220.10', '101', 'an.MACHMUDAH', '0', '10000', 'chuwez', '2025-05-07 22:08:08'),
('1153', 'KK10100320250507151850', '1446-11-09', '5.520.42', '101', 'Gorengan', '10000', '0', 'chuwez', '2025-05-07 22:19:20'),
('1154', 'KK10100320250507151850', '1446-11-09', '1.100.10', '101', 'Gorengan', '0', '10000', 'chuwez', '2025-05-07 22:19:20'),
('1159', 'ST10100320250508084034', '1446-11-10', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'Chuwez', '2025-05-08 22:40:34'),
('1160', 'ST10100320250508084034', '1446-11-10', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'Chuwez', '2025-05-08 22:40:34'),
('1161', 'ST10100320250508084122', '1446-11-10', '1.100.10', '101', 'an.NAURA BILADINA', '7000', '0', 'Chuwez', '2025-05-08 22:41:22'),
('1162', 'ST10100320250508084122', '1446-11-10', '2.220.10', '101', 'an.NAURA BILADINA', '0', '7000', 'Chuwez', '2025-05-08 22:41:22'),
('1163', 'ST10100320250508084141', '1446-11-10', '1.100.10', '101', 'an.AULIA AZZAHRA', '2000', '0', 'Chuwez', '2025-05-08 22:41:41'),
('1164', 'ST10100320250508084141', '1446-11-10', '2.220.10', '101', 'an.AULIA AZZAHRA', '0', '2000', 'Chuwez', '2025-05-08 22:41:41'),
('1165', 'ST10100320250508084200', '1446-11-10', '1.100.10', '101', 'an.ELOK WARDATUN NAFISAH', '5000', '0', 'Chuwez', '2025-05-08 22:42:00'),
('1166', 'ST10100320250508084200', '1446-11-10', '2.220.10', '101', 'an.ELOK WARDATUN NAFISAH', '0', '5000', 'Chuwez', '2025-05-08 22:42:00'),
('1167', 'ST10100320250508084219', '1446-11-10', '1.100.10', '101', 'an.M. ABD. HADI', '2000', '0', 'Chuwez', '2025-05-08 22:42:19'),
('1168', 'ST10100320250508084219', '1446-11-10', '2.220.10', '101', 'an.M. ABD. HADI', '0', '2000', 'Chuwez', '2025-05-08 22:42:19'),
('1169', 'ST10100320250508084236', '1446-11-10', '1.100.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '5000', '0', 'Chuwez', '2025-05-08 22:42:36'),
('1170', 'ST10100320250508084236', '1446-11-10', '2.220.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '0', '5000', 'Chuwez', '2025-05-08 22:42:36'),
('1171', 'ST10100320250508084252', '1446-11-10', '1.100.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '5000', '0', 'Chuwez', '2025-05-08 22:42:52'),
('1172', 'ST10100320250508084252', '1446-11-10', '2.220.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '0', '5000', 'Chuwez', '2025-05-08 22:42:52'),
('1173', 'ST10100320250508084320', '1446-11-10', '1.100.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '2000', '0', 'Chuwez', '2025-05-08 22:43:20'),
('1174', 'ST10100320250508084320', '1446-11-10', '2.220.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '0', '2000', 'Chuwez', '2025-05-08 22:43:20'),
('1175', 'ST10100320250508084340', '1446-11-10', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '5000', '0', 'Chuwez', '2025-05-08 22:43:40'),
('1176', 'ST10100320250508084340', '1446-11-10', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '5000', 'Chuwez', '2025-05-08 22:43:40'),
('1177', 'ST10100320250508084408', '1446-11-10', '1.100.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '4000', '0', 'Chuwez', '2025-05-08 22:44:08'),
('1178', 'ST10100320250508084408', '1446-11-10', '2.220.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '0', '4000', 'Chuwez', '2025-05-08 22:44:08'),
('1179', 'ST10100320250508084425', '1446-11-10', '1.100.10', '101', 'an.FAIZAH NURUL LITA', '5000', '0', 'Chuwez', '2025-05-08 22:44:25'),
('1180', 'ST10100320250508084425', '1446-11-10', '2.220.10', '101', 'an.FAIZAH NURUL LITA', '0', '5000', 'Chuwez', '2025-05-08 22:44:25'),
('1181', 'ST10100320250508084447', '1446-11-10', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '5000', '0', 'Chuwez', '2025-05-08 22:44:47'),
('1182', 'ST10100320250508084447', '1446-11-10', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '5000', 'Chuwez', '2025-05-08 22:44:47'),
('1183', 'ST10100320250508084505', '1446-11-10', '1.100.10', '101', 'an.UBAIDAH', '10000', '0', 'Chuwez', '2025-05-08 22:45:05'),
('1184', 'ST10100320250508084505', '1446-11-10', '2.220.10', '101', 'an.UBAIDAH', '0', '10000', 'Chuwez', '2025-05-08 22:45:05'),
('1185', 'ST10100320250508084526', '1446-11-10', '1.100.10', '101', 'an.RAISA ANNISA', '5000', '0', 'Chuwez', '2025-05-08 22:45:26'),
('1186', 'ST10100320250508084526', '1446-11-10', '2.220.10', '101', 'an.RAISA ANNISA', '0', '5000', 'Chuwez', '2025-05-08 22:45:26'),
('1187', 'ST10100320250508084811', '1446-11-10', '1.100.10', '101', 'an.HILYA', '10000', '0', 'Chuwez', '2025-05-08 22:48:11'),
('1188', 'ST10100320250508084811', '1446-11-10', '2.220.10', '101', 'an.HILYA', '0', '10000', 'Chuwez', '2025-05-08 22:48:11'),
('1189', 'ST10100320250508084932', '1446-11-10', '1.100.10', '101', 'an.DIANA RIFQOTUL QOLBI', '10000', '0', 'Chuwez', '2025-05-08 22:49:32'),
('1190', 'ST10100320250508084932', '1446-11-10', '2.220.10', '101', 'an.DIANA RIFQOTUL QOLBI', '0', '10000', 'Chuwez', '2025-05-08 22:49:32'),
('1191', 'ST10100320250508084946', '1446-11-10', '1.100.10', '101', 'an.ALFI NURDIANA', '5000', '0', 'Chuwez', '2025-05-08 22:49:46'),
('1192', 'ST10100320250508084946', '1446-11-10', '2.220.10', '101', 'an.ALFI NURDIANA', '0', '5000', 'Chuwez', '2025-05-08 22:49:46'),
('1193', 'ST10100320250508085004', '1446-11-10', '1.100.10', '101', 'an.LAILATUL MAGHFIROH', '10000', '0', 'Chuwez', '2025-05-08 22:50:04'),
('1194', 'ST10100320250508085004', '1446-11-10', '2.220.10', '101', 'an.LAILATUL MAGHFIROH', '0', '10000', 'Chuwez', '2025-05-08 22:50:04'),
('1195', 'ST10100320250508085019', '1446-11-10', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '10000', '0', 'Chuwez', '2025-05-08 22:50:19'),
('1196', 'ST10100320250508085019', '1446-11-10', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '10000', 'Chuwez', '2025-05-08 22:50:19'),
('1197', 'ST10100320250508085040', '1446-11-10', '1.100.10', '101', 'an.M. DESTRA MAULANA', '5000', '0', 'Chuwez', '2025-05-08 22:50:40'),
('1198', 'ST10100320250508085040', '1446-11-10', '2.220.10', '101', 'an.M. DESTRA MAULANA', '0', '5000', 'Chuwez', '2025-05-08 22:50:40'),
('1199', 'ST10100320250508085054', '1446-11-10', '1.100.10', '101', 'an.AHMAD ADITIYA', '5000', '0', 'Chuwez', '2025-05-08 22:50:54'),
('1200', 'ST10100320250508085054', '1446-11-10', '2.220.10', '101', 'an.AHMAD ADITIYA', '0', '5000', 'Chuwez', '2025-05-08 22:50:54'),
('1201', 'ST10100320250508085108', '1446-11-10', '1.100.10', '101', 'an.AZKA AUFARIL MINAN', '10000', '0', 'Chuwez', '2025-05-08 22:51:08'),
('1202', 'ST10100320250508085108', '1446-11-10', '2.220.10', '101', 'an.AZKA AUFARIL MINAN', '0', '10000', 'Chuwez', '2025-05-08 22:51:09'),
('1203', 'ST10100320250508085126', '1446-11-10', '1.100.10', '101', 'an.AISYAH', '2000', '0', 'Chuwez', '2025-05-08 22:51:26'),
('1204', 'ST10100320250508085126', '1446-11-10', '2.220.10', '101', 'an.AISYAH', '0', '2000', 'Chuwez', '2025-05-08 22:51:27'),
('1205', 'ST10100320250508085146', '1446-11-10', '1.100.10', '101', 'an.SITI ATHIUR ROHMAH', '5000', '0', 'Chuwez', '2025-05-08 22:51:46'),
('1206', 'ST10100320250508085146', '1446-11-10', '2.220.10', '101', 'an.SITI ATHIUR ROHMAH', '0', '5000', 'Chuwez', '2025-05-08 22:51:47'),
('1207', 'ST10100320250508085205', '1446-11-10', '1.100.10', '101', 'an.WARDATUL JANNAH', '3000', '0', 'Chuwez', '2025-05-08 22:52:05'),
('1208', 'ST10100320250508085205', '1446-11-10', '2.220.10', '101', 'an.WARDATUL JANNAH', '0', '3000', 'Chuwez', '2025-05-08 22:52:05'),
('1209', 'ST10100320250508085218', '1446-11-10', '1.100.10', '101', 'an.DIYANAH KAMALIYAH', '3000', '0', 'Chuwez', '2025-05-08 22:52:18'),
('1210', 'ST10100320250508085218', '1446-11-10', '2.220.10', '101', 'an.DIYANAH KAMALIYAH', '0', '3000', 'Chuwez', '2025-05-08 22:52:19'),
('1213', 'ST10100320250508085246', '1446-11-10', '1.100.10', '101', 'an.SITI QURROTUL AINI', '2000', '0', 'Chuwez', '2025-05-08 22:52:46'),
('1214', 'ST10100320250508085246', '1446-11-10', '2.220.10', '101', 'an.SITI QURROTUL AINI', '0', '2000', 'Chuwez', '2025-05-08 22:52:46'),
('1215', 'ST10100320250508085301', '1446-11-10', '1.100.10', '101', 'an.HIKMIAH PUTRI NIKMATUNNAFILAH', '5000', '0', 'Chuwez', '2025-05-08 22:53:01'),
('1216', 'ST10100320250508085301', '1446-11-10', '2.220.10', '101', 'an.HIKMIAH PUTRI NIKMATUNNAFILAH', '0', '5000', 'Chuwez', '2025-05-08 22:53:01'),
('1217', 'ST10100320250508085316', '1446-11-10', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '10000', '0', 'Chuwez', '2025-05-08 22:53:16'),
('1218', 'ST10100320250508085316', '1446-11-10', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '10000', 'Chuwez', '2025-05-08 22:53:16'),
('1219', 'ST10100320250508085335', '1446-11-10', '1.100.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '10000', '0', 'Chuwez', '2025-05-08 22:53:35'),
('1220', 'ST10100320250508085335', '1446-11-10', '2.220.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '0', '10000', 'Chuwez', '2025-05-08 22:53:35'),
('1221', 'ST10100320250508085352', '1446-11-10', '1.100.10', '101', 'an.M. KAMALUDDIN', '20000', '0', 'Chuwez', '2025-05-08 22:53:52'),
('1222', 'ST10100320250508085352', '1446-11-10', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '20000', 'Chuwez', '2025-05-08 22:53:52'),
('1223', 'ST10100320250508085407', '1446-11-10', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '2000', '0', 'Chuwez', '2025-05-08 22:54:07'),
('1224', 'ST10100320250508085407', '1446-11-10', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '2000', 'Chuwez', '2025-05-08 22:54:07'),
('1225', 'ST10100320250508085425', '1446-11-10', '1.100.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '5000', '0', 'Chuwez', '2025-05-08 22:54:25'),
('1226', 'ST10100320250508085425', '1446-11-10', '2.220.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '0', '5000', 'Chuwez', '2025-05-08 22:54:25'),
('1227', 'ST10100320250508085439', '1446-11-10', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '5000', '0', 'Chuwez', '2025-05-08 22:54:39'),
('1228', 'ST10100320250508085439', '1446-11-10', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '5000', 'Chuwez', '2025-05-08 22:54:39'),
('1229', 'ST10100320250508085458', '1446-11-10', '1.100.10', '101', 'an.RAUDHOTUL JANNAH', '60000', '0', 'Chuwez', '2025-05-08 22:54:58'),
('1230', 'ST10100320250508085458', '1446-11-10', '2.220.10', '101', 'an.RAUDHOTUL JANNAH', '0', '60000', 'Chuwez', '2025-05-08 22:54:58'),
('1231', 'ST10100320250508085517', '1446-11-10', '1.100.10', '101', 'an.NABILATUN NISAUL UMMAH', '20000', '0', 'Chuwez', '2025-05-08 22:55:17'),
('1232', 'ST10100320250508085517', '1446-11-10', '2.220.10', '101', 'an.NABILATUN NISAUL UMMAH', '0', '20000', 'Chuwez', '2025-05-08 22:55:17'),
('1233', 'ST10100320250508085531', '1446-11-10', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Chuwez', '2025-05-08 22:55:31'),
('1234', 'ST10100320250508085531', '1446-11-10', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Chuwez', '2025-05-08 22:55:31'),
('1235', 'ST10100320250508085622', '1446-11-10', '1.100.10', '101', 'an.BILQIS THALIA HASNA', '250000', '0', 'Chuwez', '2025-05-08 22:56:22'),
('1236', 'ST10100320250508085622', '1446-11-10', '2.220.10', '101', 'an.BILQIS THALIA HASNA', '0', '250000', 'Chuwez', '2025-05-08 22:56:22'),
('1237', 'ST10100320250508085651', '1446-11-10', '1.100.10', '101', 'an.AHMAD JAMALUL MAIMUN', '5000', '0', 'Chuwez', '2025-05-08 22:56:51'),
('1238', 'ST10100320250508085651', '1446-11-10', '2.220.10', '101', 'an.AHMAD JAMALUL MAIMUN', '0', '5000', 'Chuwez', '2025-05-08 22:56:51'),
('1239', 'ST10100320250508085706', '1446-11-10', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '25000', '0', 'Chuwez', '2025-05-08 22:57:06'),
('1240', 'ST10100320250508085706', '1446-11-10', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '25000', 'Chuwez', '2025-05-08 22:57:06'),
('1241', 'ST10100320250508085719', '1446-11-10', '1.100.10', '101', 'an.SINDI RAISA PUTRI', '10000', '0', 'Chuwez', '2025-05-08 22:57:19'),
('1242', 'ST10100320250508085719', '1446-11-10', '2.220.10', '101', 'an.SINDI RAISA PUTRI', '0', '10000', 'Chuwez', '2025-05-08 22:57:19'),
('1243', 'ST10100320250508085732', '1446-11-10', '1.100.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '5000', '0', 'Chuwez', '2025-05-08 22:57:32'),
('1244', 'ST10100320250508085732', '1446-11-10', '2.220.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '0', '5000', 'Chuwez', '2025-05-08 22:57:32'),
('1245', 'ST10100320250508085750', '1446-11-10', '1.100.10', '101', 'an.AKHMAD FIKRI HAIKAL', '50000', '0', 'Chuwez', '2025-05-08 22:57:50'),
('1246', 'ST10100320250508085750', '1446-11-10', '2.220.10', '101', 'an.AKHMAD FIKRI HAIKAL', '0', '50000', 'Chuwez', '2025-05-08 22:57:50'),
('1247', 'ST10100320250508085810', '1446-11-10', '1.100.10', '101', 'an.AHMAD ABBAS MAULANA', '20000', '0', 'Chuwez', '2025-05-08 22:58:10'),
('1248', 'ST10100320250508085810', '1446-11-10', '2.220.10', '101', 'an.AHMAD ABBAS MAULANA', '0', '20000', 'Chuwez', '2025-05-08 22:58:10'),
('1249', 'ST10100320250508085826', '1446-11-10', '1.100.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '20000', '0', 'Chuwez', '2025-05-08 22:58:26'),
('1250', 'ST10100320250508085826', '1446-11-10', '2.220.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '0', '20000', 'Chuwez', '2025-05-08 22:58:26'),
('1251', 'ST10100320250508085853', '1446-11-10', '1.100.10', '101', 'an.AFANDI', '2000', '0', 'Chuwez', '2025-05-08 22:58:53'),
('1252', 'ST10100320250508085853', '1446-11-10', '2.220.10', '101', 'an.AFANDI', '0', '2000', 'Chuwez', '2025-05-08 22:58:53'),
('1253', 'ST10100320250508085907', '1446-11-10', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '5000', '0', 'Chuwez', '2025-05-08 22:59:07'),
('1254', 'ST10100320250508085907', '1446-11-10', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '5000', 'Chuwez', '2025-05-08 22:59:07'),
('1255', 'ST10100320250508085921', '1446-11-10', '1.100.10', '101', 'an.MUHAMMAD KHOIRON', '5000', '0', 'Chuwez', '2025-05-08 22:59:21'),
('1256', 'ST10100320250508085921', '1446-11-10', '2.220.10', '101', 'an.MUHAMMAD KHOIRON', '0', '5000', 'Chuwez', '2025-05-08 22:59:21'),
('1257', 'ST10100320250508085937', '1446-11-10', '1.100.10', '101', 'an.ROBIATUL ADAWIYAH', '2000', '0', 'Chuwez', '2025-05-08 22:59:37'),
('1258', 'ST10100320250508085937', '1446-11-10', '2.220.10', '101', 'an.ROBIATUL ADAWIYAH', '0', '2000', 'Chuwez', '2025-05-08 22:59:37'),
('1259', 'ST10100320250508085949', '1446-11-10', '1.100.10', '101', 'an.ANA SALSABILA', '10000', '0', 'Chuwez', '2025-05-08 22:59:49'),
('1260', 'ST10100320250508085949', '1446-11-10', '2.220.10', '101', 'an.ANA SALSABILA', '0', '10000', 'Chuwez', '2025-05-08 22:59:49'),
('1261', 'ST10100320250508090003', '1446-11-10', '1.100.10', '101', 'an.M. ALIFIN FIKRI', '2000', '0', 'Chuwez', '2025-05-08 23:00:03'),
('1262', 'ST10100320250508090003', '1446-11-10', '2.220.10', '101', 'an.M. ALIFIN FIKRI', '0', '2000', 'Chuwez', '2025-05-08 23:00:03'),
('1263', 'ST10100320250508090016', '1446-11-10', '1.100.10', '101', 'an.ZAKIYATUL UMMAH', '2000', '0', 'Chuwez', '2025-05-08 23:00:16'),
('1264', 'ST10100320250508090016', '1446-11-10', '2.220.10', '101', 'an.ZAKIYATUL UMMAH', '0', '2000', 'Chuwez', '2025-05-08 23:00:16'),
('1265', 'ST10100320250508090033', '1446-11-10', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '2000', '0', 'Chuwez', '2025-05-08 23:00:33'),
('1266', 'ST10100320250508090033', '1446-11-10', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '2000', 'Chuwez', '2025-05-08 23:00:33'),
('1267', 'ST10100320250508090122', '1446-11-10', '1.100.10', '101', 'an.HALIMAH', '5000', '0', 'Chuwez', '2025-05-08 23:01:22'),
('1268', 'ST10100320250508090122', '1446-11-10', '2.220.10', '101', 'an.HALIMAH', '0', '5000', 'Chuwez', '2025-05-08 23:01:22'),
('1269', 'ST10100320250508090141', '1446-11-10', '1.100.10', '101', 'an.HAMIDAH', '10000', '0', 'Chuwez', '2025-05-08 23:01:41'),
('1270', 'ST10100320250508090141', '1446-11-10', '2.220.10', '101', 'an.HAMIDAH', '0', '10000', 'Chuwez', '2025-05-08 23:01:41'),
('1271', 'ST10100320250508090159', '1446-11-10', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'Chuwez', '2025-05-08 23:01:59'),
('1272', 'ST10100320250508090159', '1446-11-10', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'Chuwez', '2025-05-08 23:01:59'),
('1273', 'ST10100320250508090217', '1446-11-10', '1.100.10', '101', 'an.MACHMUDAH', '5000', '0', 'Chuwez', '2025-05-08 23:02:17'),
('1274', 'ST10100320250508090217', '1446-11-10', '2.220.10', '101', 'an.MACHMUDAH', '0', '5000', 'Chuwez', '2025-05-08 23:02:17'),
('1275', 'ST10100320250508091848', '1446-11-10', '1.100.10', '101', 'an.SAFIRATUL JANNAH', '20000', '0', 'Chuwez', '2025-05-08 23:18:48'),
('1276', 'ST10100320250508091848', '1446-11-10', '2.220.10', '101', 'an.SAFIRATUL JANNAH', '0', '20000', 'Chuwez', '2025-05-08 23:18:48'),
('1277', 'ST10100320250508091911', '1446-11-10', '1.100.10', '101', 'an.ALFIN HIDAYAT', '20000', '0', 'Chuwez', '2025-05-08 23:19:11'),
('1278', 'ST10100320250508091911', '1446-11-10', '2.220.10', '101', 'an.ALFIN HIDAYAT', '0', '20000', 'Chuwez', '2025-05-08 23:19:11'),
('1279', 'ST10100320250508091933', '1446-11-10', '1.100.10', '101', 'an.MUHAMMAD KANZUL KAROMI', '5000', '0', 'Chuwez', '2025-05-08 23:19:33'),
('1280', 'ST10100320250508091933', '1446-11-10', '2.220.10', '101', 'an.MUHAMMAD KANZUL KAROMI', '0', '5000', 'Chuwez', '2025-05-08 23:19:33'),
('1281', 'ST10100320250508091953', '1446-11-10', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '5000', '0', 'Chuwez', '2025-05-08 23:19:53'),
('1282', 'ST10100320250508091953', '1446-11-10', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '5000', 'Chuwez', '2025-05-08 23:19:53'),
('1283', 'ST10100320250508092011', '1446-11-10', '1.100.10', '101', 'an.M. ZIDAN RIZQI SALIM', '10000', '0', 'Chuwez', '2025-05-08 23:20:11'),
('1284', 'ST10100320250508092011', '1446-11-10', '2.220.10', '101', 'an.M. ZIDAN RIZQI SALIM', '0', '10000', 'Chuwez', '2025-05-08 23:20:11'),
('1285', 'ST10100320250508092038', '1446-11-10', '1.100.10', '101', 'an.ACH. JUNAIDI', '5000', '0', 'Chuwez', '2025-05-08 23:20:38'),
('1286', 'ST10100320250508092038', '1446-11-10', '2.220.10', '101', 'an.ACH. JUNAIDI', '0', '5000', 'Chuwez', '2025-05-08 23:20:38'),
('1287', 'ST10100320250508085232', '1446-11-10', '1.100.10', '101', 'an.KHOIRIYAH', '20000', '0', 'Chuwez', '2025-05-08 23:22:53'),
('1288', 'ST10100320250508085232', '1446-11-10', '2.220.10', '101', 'an.KHOIRIYAH', '0', '20000', 'Chuwez', '2025-05-08 23:22:53'),
('1289', 'ST10100320250508092755', '1446-11-10', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '10000', '0', 'Chuwez', '2025-05-08 23:27:55'),
('1290', 'ST10100320250508092755', '1446-11-10', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '10000', 'Chuwez', '2025-05-08 23:27:56'),
('1291', 'ST10100320250510092921', '1446-11-12', '1.100.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '5000', '0', 'Chuwez', '2025-05-10 23:29:21'),
('1292', 'ST10100320250510092921', '1446-11-12', '2.220.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '0', '5000', 'Chuwez', '2025-05-10 23:29:21'),
('1293', 'ST10100320250510092943', '1446-11-12', '1.100.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '5000', '0', 'Chuwez', '2025-05-10 23:29:43'),
('1294', 'ST10100320250510092943', '1446-11-12', '2.220.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '0', '5000', 'Chuwez', '2025-05-10 23:29:43'),
('1295', 'ST10100320250510092959', '1446-11-12', '1.100.10', '101', 'an.M. ABD. HADI', '2000', '0', 'Chuwez', '2025-05-10 23:29:59'),
('1296', 'ST10100320250510092959', '1446-11-12', '2.220.10', '101', 'an.M. ABD. HADI', '0', '2000', 'Chuwez', '2025-05-10 23:29:59'),
('1297', 'ST10100320250510093013', '1446-11-12', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '5000', '0', 'Chuwez', '2025-05-10 23:30:13'),
('1298', 'ST10100320250510093013', '1446-11-12', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '5000', 'Chuwez', '2025-05-10 23:30:13'),
('1299', 'ST10100320250510093029', '1446-11-12', '1.100.10', '101', 'an.ELOK WARDATUN NAFISAH', '10000', '0', 'Chuwez', '2025-05-10 23:30:29'),
('1300', 'ST10100320250510093029', '1446-11-12', '2.220.10', '101', 'an.ELOK WARDATUN NAFISAH', '0', '10000', 'Chuwez', '2025-05-10 23:30:29'),
('1301', 'ST10100320250510093043', '1446-11-12', '1.100.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '2000', '0', 'Chuwez', '2025-05-10 23:30:43'),
('1302', 'ST10100320250510093043', '1446-11-12', '2.220.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '0', '2000', 'Chuwez', '2025-05-10 23:30:43'),
('1303', 'ST10100320250510093058', '1446-11-12', '1.100.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '15000', '0', 'Chuwez', '2025-05-10 23:30:58'),
('1304', 'ST10100320250510093058', '1446-11-12', '2.220.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '0', '15000', 'Chuwez', '2025-05-10 23:30:58'),
('1305', 'ST10100320250510093121', '1446-11-12', '1.100.10', '101', 'an.AKHMAD FIKRI HAIKAL', '50000', '0', 'Chuwez', '2025-05-10 23:31:21'),
('1306', 'ST10100320250510093121', '1446-11-12', '2.220.10', '101', 'an.AKHMAD FIKRI HAIKAL', '0', '50000', 'Chuwez', '2025-05-10 23:31:21'),
('1307', 'ST10100320250510093154', '1446-11-12', '1.100.10', '101', 'an.M. ROFIQ', '50000', '0', 'Chuwez', '2025-05-10 23:31:54'),
('1308', 'ST10100320250510093154', '1446-11-12', '2.220.10', '101', 'an.M. ROFIQ', '0', '50000', 'Chuwez', '2025-05-10 23:31:54'),
('1309', 'ST10100320250510093215', '1446-11-12', '1.100.10', '101', 'an.AHMAD ABBAS MAULANA', '3000', '0', 'Chuwez', '2025-05-10 23:32:15'),
('1310', 'ST10100320250510093215', '1446-11-12', '2.220.10', '101', 'an.AHMAD ABBAS MAULANA', '0', '3000', 'Chuwez', '2025-05-10 23:32:15'),
('1311', 'ST10100320250510093229', '1446-11-12', '1.100.10', '101', 'an.AHMAD JAMALUL MAIMUN', '5000', '0', 'Chuwez', '2025-05-10 23:32:29'),
('1312', 'ST10100320250510093229', '1446-11-12', '2.220.10', '101', 'an.AHMAD JAMALUL MAIMUN', '0', '5000', 'Chuwez', '2025-05-10 23:32:29'),
('1313', 'ST10100320250510093243', '1446-11-12', '1.100.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '5000', '0', 'Chuwez', '2025-05-10 23:32:43'),
('1314', 'ST10100320250510093243', '1446-11-12', '2.220.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '0', '5000', 'Chuwez', '2025-05-10 23:32:43'),
('1315', 'ST10100320250510093259', '1446-11-12', '1.100.10', '101', 'an.AULIA AZZAHRA', '5000', '0', 'Chuwez', '2025-05-10 23:32:59'),
('1316', 'ST10100320250510093259', '1446-11-12', '2.220.10', '101', 'an.AULIA AZZAHRA', '0', '5000', 'Chuwez', '2025-05-10 23:32:59'),
('1317', 'ST10100320250510093314', '1446-11-12', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'Chuwez', '2025-05-10 23:33:14'),
('1318', 'ST10100320250510093314', '1446-11-12', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'Chuwez', '2025-05-10 23:33:14'),
('1319', 'ST10100320250510093330', '1446-11-12', '1.100.10', '101', 'an.NAURA BILADINA', '15000', '0', 'Chuwez', '2025-05-10 23:33:30'),
('1320', 'ST10100320250510093330', '1446-11-12', '2.220.10', '101', 'an.NAURA BILADINA', '0', '15000', 'Chuwez', '2025-05-10 23:33:30'),
('1321', 'ST10100320250510093355', '1446-11-12', '1.100.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '5000', '0', 'Chuwez', '2025-05-10 23:33:55'),
('1322', 'ST10100320250510093355', '1446-11-12', '2.220.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '0', '5000', 'Chuwez', '2025-05-10 23:33:56'),
('1323', 'ST10100320250510093430', '1446-11-12', '1.100.10', '101', 'an.M.AKMALUL HIMAM', '10000', '0', 'Chuwez', '2025-05-10 23:34:30'),
('1324', 'ST10100320250510093430', '1446-11-12', '2.220.10', '101', 'an.M.AKMALUL HIMAM', '0', '10000', 'Chuwez', '2025-05-10 23:34:30'),
('1325', 'ST10100320250510093448', '1446-11-12', '1.100.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '2000', '0', 'Chuwez', '2025-05-10 23:34:48'),
('1326', 'ST10100320250510093448', '1446-11-12', '2.220.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '0', '2000', 'Chuwez', '2025-05-10 23:34:48'),
('1327', 'ST10100320250510093507', '1446-11-12', '1.100.10', '101', 'an.MUHAMMAD KANZUL KAROMI', '5000', '0', 'Chuwez', '2025-05-10 23:35:07'),
('1328', 'ST10100320250510093507', '1446-11-12', '2.220.10', '101', 'an.MUHAMMAD KANZUL KAROMI', '0', '5000', 'Chuwez', '2025-05-10 23:35:07'),
('1329', 'ST10100320250510093533', '1446-11-12', '1.100.10', '101', 'an.ACH. JUNAIDI', '5000', '0', 'Chuwez', '2025-05-10 23:35:33'),
('1330', 'ST10100320250510093533', '1446-11-12', '2.220.10', '101', 'an.ACH. JUNAIDI', '0', '5000', 'Chuwez', '2025-05-10 23:35:33'),
('1331', 'ST10100320250510093548', '1446-11-12', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '10000', '0', 'Chuwez', '2025-05-10 23:35:48'),
('1332', 'ST10100320250510093548', '1446-11-12', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '10000', 'Chuwez', '2025-05-10 23:35:48'),
('1333', 'ST10100320250510093612', '1446-11-12', '1.100.10', '101', 'an.M. ZIDAN RIZQI SALIM', '3000', '0', 'Chuwez', '2025-05-10 23:36:12'),
('1334', 'ST10100320250510093612', '1446-11-12', '2.220.10', '101', 'an.M. ZIDAN RIZQI SALIM', '0', '3000', 'Chuwez', '2025-05-10 23:36:12'),
('1335', 'ST10100320250510093704', '1446-11-12', '1.100.10', '101', 'an.BILQIS THALIA HASNA', '60000', '0', 'Chuwez', '2025-05-10 23:37:04'),
('1336', 'ST10100320250510093704', '1446-11-12', '2.220.10', '101', 'an.BILQIS THALIA HASNA', '0', '60000', 'Chuwez', '2025-05-10 23:37:04'),
('1337', 'ST10100320250510093722', '1446-11-12', '1.100.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '10000', '0', 'Chuwez', '2025-05-10 23:37:22'),
('1338', 'ST10100320250510093722', '1446-11-12', '2.220.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '0', '10000', 'Chuwez', '2025-05-10 23:37:22'),
('1339', 'ST10100320250510093745', '1446-11-12', '1.100.10', '101', 'an.SINDI RAISA PUTRI', '10000', '0', 'Chuwez', '2025-05-10 23:37:45'),
('1340', 'ST10100320250510093745', '1446-11-12', '2.220.10', '101', 'an.SINDI RAISA PUTRI', '0', '10000', 'Chuwez', '2025-05-10 23:37:45'),
('1341', 'ST10100320250510093824', '1446-11-12', '1.100.10', '101', 'an.MARIYATUL QIBTIYAH', '5000', '0', 'Chuwez', '2025-05-10 23:38:24'),
('1342', 'ST10100320250510093824', '1446-11-12', '2.220.10', '101', 'an.MARIYATUL QIBTIYAH', '0', '5000', 'Chuwez', '2025-05-10 23:38:24'),
('1343', 'ST10100320250510093843', '1446-11-12', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '25000', '0', 'Chuwez', '2025-05-10 23:38:43'),
('1344', 'ST10100320250510093843', '1446-11-12', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '25000', 'Chuwez', '2025-05-10 23:38:43'),
('1345', 'ST10100320250510093900', '1446-11-12', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'Chuwez', '2025-05-10 23:39:00'),
('1346', 'ST10100320250510093900', '1446-11-12', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'Chuwez', '2025-05-10 23:39:00'),
('1347', 'ST10100320250510093916', '1446-11-12', '1.100.10', '101', 'an.FAIZAH NURUL LITA', '5000', '0', 'Chuwez', '2025-05-10 23:39:16'),
('1348', 'ST10100320250510093916', '1446-11-12', '2.220.10', '101', 'an.FAIZAH NURUL LITA', '0', '5000', 'Chuwez', '2025-05-10 23:39:16'),
('1349', 'ST10100320250510093940', '1446-11-12', '1.100.10', '101', 'an.MUHAMMAD ALWI', '10000', '0', 'Chuwez', '2025-05-10 23:39:40'),
('1350', 'ST10100320250510093940', '1446-11-12', '2.220.10', '101', 'an.MUHAMMAD ALWI', '0', '10000', 'Chuwez', '2025-05-10 23:39:40'),
('1351', 'ST10100320250510093957', '1446-11-12', '1.100.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '4000', '0', 'Chuwez', '2025-05-10 23:39:57'),
('1352', 'ST10100320250510093957', '1446-11-12', '2.220.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '0', '4000', 'Chuwez', '2025-05-10 23:39:57'),
('1353', 'ST10100320250510094012', '1446-11-12', '1.100.10', '101', 'an.UBAIDAH', '20000', '0', 'Chuwez', '2025-05-10 23:40:12'),
('1354', 'ST10100320250510094012', '1446-11-12', '2.220.10', '101', 'an.UBAIDAH', '0', '20000', 'Chuwez', '2025-05-10 23:40:12'),
('1355', 'ST10100320250510094025', '1446-11-12', '1.100.10', '101', 'an.ABDULLOH BAHAR', '5000', '0', 'Chuwez', '2025-05-10 23:40:25'),
('1356', 'ST10100320250510094025', '1446-11-12', '2.220.10', '101', 'an.ABDULLOH BAHAR', '0', '5000', 'Chuwez', '2025-05-10 23:40:25'),
('1357', 'ST10100320250510094037', '1446-11-12', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '5000', '0', 'Chuwez', '2025-05-10 23:40:37'),
('1358', 'ST10100320250510094037', '1446-11-12', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '5000', 'Chuwez', '2025-05-10 23:40:37'),
('1359', 'ST10100320250510094051', '1446-11-12', '1.100.10', '101', 'an.NAILATUN NIAMI', '10000', '0', 'Chuwez', '2025-05-10 23:40:51'),
('1360', 'ST10100320250510094051', '1446-11-12', '2.220.10', '101', 'an.NAILATUN NIAMI', '0', '10000', 'Chuwez', '2025-05-10 23:40:51'),
('1361', 'ST10100320250510094108', '1446-11-12', '1.100.10', '101', 'an.MARIATUL QIBTIYAH', '4000', '0', 'Chuwez', '2025-05-10 23:41:08'),
('1362', 'ST10100320250510094108', '1446-11-12', '2.220.10', '101', 'an.MARIATUL QIBTIYAH', '0', '4000', 'Chuwez', '2025-05-10 23:41:08'),
('1363', 'ST10100320250510094123', '1446-11-12', '1.100.10', '101', 'an.RAISA ANNISA', '5000', '0', 'Chuwez', '2025-05-10 23:41:23'),
('1364', 'ST10100320250510094123', '1446-11-12', '2.220.10', '101', 'an.RAISA ANNISA', '0', '5000', 'Chuwez', '2025-05-10 23:41:23'),
('1365', 'ST10100320250510094137', '1446-11-12', '1.100.10', '101', 'an.UMAR FARUQ', '15000', '0', 'Chuwez', '2025-05-10 23:41:37'),
('1366', 'ST10100320250510094137', '1446-11-12', '2.220.10', '101', 'an.UMAR FARUQ', '0', '15000', 'Chuwez', '2025-05-10 23:41:37'),
('1367', 'ST10100320250510094158', '1446-11-12', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '10000', '0', 'Chuwez', '2025-05-10 23:41:58'),
('1368', 'ST10100320250510094158', '1446-11-12', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '10000', 'Chuwez', '2025-05-10 23:41:58'),
('1369', 'ST10100320250510094213', '1446-11-12', '1.100.10', '101', 'an.AISYAH', '2000', '0', 'Chuwez', '2025-05-10 23:42:13'),
('1370', 'ST10100320250510094213', '1446-11-12', '2.220.10', '101', 'an.AISYAH', '0', '2000', 'Chuwez', '2025-05-10 23:42:13'),
('1371', 'ST10100320250510094227', '1446-11-12', '1.100.10', '101', 'an.LAILATUL MAGHFIROH', '5000', '0', 'Chuwez', '2025-05-10 23:42:27'),
('1372', 'ST10100320250510094227', '1446-11-12', '2.220.10', '101', 'an.LAILATUL MAGHFIROH', '0', '5000', 'Chuwez', '2025-05-10 23:42:27'),
('1373', 'ST10100320250510094245', '1446-11-12', '1.100.10', '101', 'an.M. DESTRA MAULANA', '30000', '0', 'Chuwez', '2025-05-10 23:42:45'),
('1374', 'ST10100320250510094245', '1446-11-12', '2.220.10', '101', 'an.M. DESTRA MAULANA', '0', '30000', 'Chuwez', '2025-05-10 23:42:45'),
('1375', 'ST10100320250510094304', '1446-11-12', '1.100.10', '101', 'an.MUHAMMAD KHOIRON', '10000', '0', 'Chuwez', '2025-05-10 23:43:04'),
('1376', 'ST10100320250510094304', '1446-11-12', '2.220.10', '101', 'an.MUHAMMAD KHOIRON', '0', '10000', 'Chuwez', '2025-05-10 23:43:04'),
('1377', 'ST10100320250510094318', '1446-11-12', '1.100.10', '101', 'an.M. ALIFIN FIKRI', '5000', '0', 'Chuwez', '2025-05-10 23:43:18'),
('1378', 'ST10100320250510094318', '1446-11-12', '2.220.10', '101', 'an.M. ALIFIN FIKRI', '0', '5000', 'Chuwez', '2025-05-10 23:43:18'),
('1379', 'ST10100320250510094337', '1446-11-12', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '5000', '0', 'Chuwez', '2025-05-10 23:43:37'),
('1380', 'ST10100320250510094337', '1446-11-12', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '5000', 'Chuwez', '2025-05-10 23:43:37'),
('1381', 'ST10100320250510094350', '1446-11-12', '1.100.10', '101', 'an.ANA SALSABILA', '50000', '0', 'Chuwez', '2025-05-10 23:43:50'),
('1382', 'ST10100320250510094350', '1446-11-12', '2.220.10', '101', 'an.ANA SALSABILA', '0', '50000', 'Chuwez', '2025-05-10 23:43:50'),
('1383', 'ST10100320250510094403', '1446-11-12', '1.100.10', '101', 'an.ZAKIYATUL UMMAH', '2000', '0', 'Chuwez', '2025-05-10 23:44:03'),
('1384', 'ST10100320250510094403', '1446-11-12', '2.220.10', '101', 'an.ZAKIYATUL UMMAH', '0', '2000', 'Chuwez', '2025-05-10 23:44:03'),
('1385', 'ST10100320250510094418', '1446-11-12', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '2000', '0', 'Chuwez', '2025-05-10 23:44:18'),
('1386', 'ST10100320250510094418', '1446-11-12', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '2000', 'Chuwez', '2025-05-10 23:44:18'),
('1387', 'ST10100320250510094431', '1446-11-12', '1.100.10', '101', 'an.AFANDI', '2000', '0', 'Chuwez', '2025-05-10 23:44:31'),
('1388', 'ST10100320250510094431', '1446-11-12', '2.220.10', '101', 'an.AFANDI', '0', '2000', 'Chuwez', '2025-05-10 23:44:31'),
('1389', 'ST10100320250510094448', '1446-11-12', '1.100.10', '101', 'an.WARDATUL JANNAH', '2000', '0', 'Chuwez', '2025-05-10 23:44:48'),
('1390', 'ST10100320250510094448', '1446-11-12', '2.220.10', '101', 'an.WARDATUL JANNAH', '0', '2000', 'Chuwez', '2025-05-10 23:44:48'),
('1391', 'ST10100320250510094504', '1446-11-12', '1.100.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '10000', '0', 'Chuwez', '2025-05-10 23:45:04'),
('1392', 'ST10100320250510094504', '1446-11-12', '2.220.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '0', '10000', 'Chuwez', '2025-05-10 23:45:04'),
('1393', 'ST10100320250510094522', '1446-11-12', '1.100.10', '101', 'an.HIKMIAH PUTRI NIKMATUNNAFILAH', '5000', '0', 'Chuwez', '2025-05-10 23:45:22'),
('1394', 'ST10100320250510094522', '1446-11-12', '2.220.10', '101', 'an.HIKMIAH PUTRI NIKMATUNNAFILAH', '0', '5000', 'Chuwez', '2025-05-10 23:45:22'),
('1395', 'ST10100320250510094535', '1446-11-12', '1.100.10', '101', 'an.AHMAD SYAHRU ROMADHONI', '10000', '0', 'Chuwez', '2025-05-10 23:45:35'),
('1396', 'ST10100320250510094535', '1446-11-12', '2.220.10', '101', 'an.AHMAD SYAHRU ROMADHONI', '0', '10000', 'Chuwez', '2025-05-10 23:45:35'),
('1397', 'ST10100320250510094553', '1446-11-12', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '10000', '0', 'Chuwez', '2025-05-10 23:45:53'),
('1398', 'ST10100320250510094553', '1446-11-12', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '10000', 'Chuwez', '2025-05-10 23:45:53'),
('1399', 'ST10100320250510094607', '1446-11-12', '1.100.10', '101', 'an.M. FAHMI NURUL ANAM', '10000', '0', 'Chuwez', '2025-05-10 23:46:07'),
('1400', 'ST10100320250510094607', '1446-11-12', '2.220.10', '101', 'an.M. FAHMI NURUL ANAM', '0', '10000', 'Chuwez', '2025-05-10 23:46:07'),
('1401', 'ST10100320250510094620', '1446-11-12', '1.100.10', '101', 'an.ABDUL HAMID', '2000', '0', 'Chuwez', '2025-05-10 23:46:20'),
('1402', 'ST10100320250510094620', '1446-11-12', '2.220.10', '101', 'an.ABDUL HAMID', '0', '2000', 'Chuwez', '2025-05-10 23:46:20'),
('1403', 'ST10100320250510094634', '1446-11-12', '1.100.10', '101', 'an.SITI ATHIUR ROHMAH', '5000', '0', 'Chuwez', '2025-05-10 23:46:34'),
('1404', 'ST10100320250510094634', '1446-11-12', '2.220.10', '101', 'an.SITI ATHIUR ROHMAH', '0', '5000', 'Chuwez', '2025-05-10 23:46:34'),
('1405', 'ST10100320250510094646', '1446-11-12', '1.100.10', '101', 'an.SITI QURROTUL AINI', '2000', '0', 'Chuwez', '2025-05-10 23:46:46'),
('1406', 'ST10100320250510094646', '1446-11-12', '2.220.10', '101', 'an.SITI QURROTUL AINI', '0', '2000', 'Chuwez', '2025-05-10 23:46:46'),
('1407', 'ST10100320250510094710', '1446-11-12', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Chuwez', '2025-05-10 23:47:10'),
('1408', 'ST10100320250510094710', '1446-11-12', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Chuwez', '2025-05-10 23:47:10'),
('1409', 'ST10100320250510094727', '1446-11-12', '1.100.10', '101', 'an.NIKMATUL MAULIDAH', '5000', '0', 'Chuwez', '2025-05-10 23:47:27'),
('1410', 'ST10100320250510094727', '1446-11-12', '2.220.10', '101', 'an.NIKMATUL MAULIDAH', '0', '5000', 'Chuwez', '2025-05-10 23:47:27'),
('1411', 'ST10100320250510094740', '1446-11-12', '1.100.10', '101', 'an.MIFTAHUL JANNAH', '50000', '0', 'Chuwez', '2025-05-10 23:47:40'),
('1412', 'ST10100320250510094740', '1446-11-12', '2.220.10', '101', 'an.MIFTAHUL JANNAH', '0', '50000', 'Chuwez', '2025-05-10 23:47:40'),
('1413', 'ST10100320250510094759', '1446-11-12', '1.100.10', '101', 'an.IZZA BILLAH', '20000', '0', 'Chuwez', '2025-05-10 23:47:59'),
('1414', 'ST10100320250510094759', '1446-11-12', '2.220.10', '101', 'an.IZZA BILLAH', '0', '20000', 'Chuwez', '2025-05-10 23:47:59'),
('1415', 'ST10100320250510094812', '1446-11-12', '1.100.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '10000', '0', 'Chuwez', '2025-05-10 23:48:12'),
('1416', 'ST10100320250510094812', '1446-11-12', '2.220.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '0', '10000', 'Chuwez', '2025-05-10 23:48:12'),
('1417', 'ST10100320250510094826', '1446-11-12', '1.100.10', '101', 'an.M. KAMALUDDIN', '20000', '0', 'Chuwez', '2025-05-10 23:48:26'),
('1418', 'ST10100320250510094826', '1446-11-12', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '20000', 'Chuwez', '2025-05-10 23:48:28'),
('1419', 'ST10100320250510094842', '1446-11-12', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '5000', '0', 'Chuwez', '2025-05-10 23:48:42'),
('1420', 'ST10100320250510094842', '1446-11-12', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '5000', 'Chuwez', '2025-05-10 23:48:42'),
('1421', 'ST10100320250510094857', '1446-11-12', '1.100.10', '101', 'an.MUHAMMAD ILHAM', '5000', '0', 'Chuwez', '2025-05-10 23:48:57'),
('1422', 'ST10100320250510094857', '1446-11-12', '2.220.10', '101', 'an.MUHAMMAD ILHAM', '0', '5000', 'Chuwez', '2025-05-10 23:48:58'),
('1423', 'ST10100320250510094914', '1446-11-12', '1.100.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '10000', '0', 'Chuwez', '2025-05-10 23:49:14'),
('1424', 'ST10100320250510094914', '1446-11-12', '2.220.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '0', '10000', 'Chuwez', '2025-05-10 23:49:14'),
('1425', 'ST10100320250510094928', '1446-11-12', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '3000', '0', 'Chuwez', '2025-05-10 23:49:28'),
('1426', 'ST10100320250510094928', '1446-11-12', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '3000', 'Chuwez', '2025-05-10 23:49:28'),
('1427', 'ST10100320250510094943', '1446-11-12', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '10000', '0', 'Chuwez', '2025-05-10 23:49:43'),
('1428', 'ST10100320250510094943', '1446-11-12', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '10000', 'Chuwez', '2025-05-10 23:49:43'),
('1429', 'ST10100320250510094957', '1446-11-12', '1.100.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '5000', '0', 'Chuwez', '2025-05-10 23:49:57'),
('1430', 'ST10100320250510094957', '1446-11-12', '2.220.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '0', '5000', 'Chuwez', '2025-05-10 23:49:57'),
('1431', 'ST10100320250510095012', '1446-11-12', '1.100.10', '101', 'an.NABILATUN NISAUL UMMAH', '20000', '0', 'Chuwez', '2025-05-10 23:50:12'),
('1432', 'ST10100320250510095012', '1446-11-12', '2.220.10', '101', 'an.NABILATUN NISAUL UMMAH', '0', '20000', 'Chuwez', '2025-05-10 23:50:12'),
('1433', 'ST10100320250510095035', '1446-11-12', '1.100.10', '101', 'an.HILYA', '10000', '0', 'Chuwez', '2025-05-10 23:50:35'),
('1434', 'ST10100320250510095035', '1446-11-12', '2.220.10', '101', 'an.HILYA', '0', '10000', 'Chuwez', '2025-05-10 23:50:35'),
('1435', 'ST10100320250510095050', '1446-11-12', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'Chuwez', '2025-05-10 23:50:50'),
('1436', 'ST10100320250510095050', '1446-11-12', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'Chuwez', '2025-05-10 23:50:50'),
('1437', 'ST10100320250510095108', '1446-11-12', '1.100.10', '101', 'an.HAMIDAH', '110000', '0', 'Chuwez', '2025-05-10 23:51:08'),
('1438', 'ST10100320250510095108', '1446-11-12', '2.220.10', '101', 'an.HAMIDAH', '0', '110000', 'Chuwez', '2025-05-10 23:51:08'),
('1439', 'ST10100320250510095126', '1446-11-12', '1.100.10', '101', 'an.HALIMAH', '5000', '0', 'Chuwez', '2025-05-10 23:51:26'),
('1440', 'ST10100320250510095126', '1446-11-12', '2.220.10', '101', 'an.HALIMAH', '0', '5000', 'Chuwez', '2025-05-10 23:51:26'),
('1441', 'ST10100320250511061859', '1446-11-13', '1.100.10', '101', 'an.UMAR FARUQ', '10000', '0', 'Chuwez', '2025-05-11 20:18:59'),
('1442', 'ST10100320250511061859', '1446-11-13', '2.220.10', '101', 'an.UMAR FARUQ', '0', '10000', 'Chuwez', '2025-05-11 20:18:59'),
('1443', 'ST10100320250511061925', '1446-11-13', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '5000', '0', 'Chuwez', '2025-05-11 20:19:25'),
('1444', 'ST10100320250511061925', '1446-11-13', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '5000', 'Chuwez', '2025-05-11 20:19:25'),
('1445', 'ST10100320250511062037', '1446-11-13', '1.100.10', '101', 'an.RAISA ANNISA', '5000', '0', 'Chuwez', '2025-05-11 20:20:37'),
('1446', 'ST10100320250511062037', '1446-11-13', '2.220.10', '101', 'an.RAISA ANNISA', '0', '5000', 'Chuwez', '2025-05-11 20:20:37'),
('1447', 'ST10100320250511062105', '1446-11-13', '1.100.10', '101', 'an.ROFIQOTUS SARIROH', '10000', '0', 'Chuwez', '2025-05-11 20:21:05'),
('1448', 'ST10100320250511062105', '1446-11-13', '2.220.10', '101', 'an.ROFIQOTUS SARIROH', '0', '10000', 'Chuwez', '2025-05-11 20:21:06'),
('1449', 'ST10100320250511062127', '1446-11-13', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'Chuwez', '2025-05-11 20:21:27'),
('1450', 'ST10100320250511062127', '1446-11-13', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'Chuwez', '2025-05-11 20:21:27'),
('1451', 'ST10100320250511062146', '1446-11-13', '1.100.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '5000', '0', 'Chuwez', '2025-05-11 20:21:46'),
('1452', 'ST10100320250511062146', '1446-11-13', '2.220.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '0', '5000', 'Chuwez', '2025-05-11 20:21:46'),
('1453', 'ST10100320250511062214', '1446-11-13', '1.100.10', '101', 'an.AHMAD ADITIYA', '10000', '0', 'Chuwez', '2025-05-11 20:22:14'),
('1454', 'ST10100320250511062214', '1446-11-13', '2.220.10', '101', 'an.AHMAD ADITIYA', '0', '10000', 'Chuwez', '2025-05-11 20:22:14'),
('1455', 'ST10100320250511062235', '1446-11-13', '1.100.10', '101', 'an.AZKA AUFARIL MINAN', '10000', '0', 'Chuwez', '2025-05-11 20:22:35'),
('1456', 'ST10100320250511062235', '1446-11-13', '2.220.10', '101', 'an.AZKA AUFARIL MINAN', '0', '10000', 'Chuwez', '2025-05-11 20:22:35'),
('1457', 'ST10100320250511062257', '1446-11-13', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '10000', '0', 'Chuwez', '2025-05-11 20:22:57'),
('1458', 'ST10100320250511062257', '1446-11-13', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '10000', 'Chuwez', '2025-05-11 20:22:57'),
('1459', 'ST10100320250511062319', '1446-11-13', '1.100.10', '101', 'an.M. DESTRA MAULANA', '4000', '0', 'Chuwez', '2025-05-11 20:23:19'),
('1460', 'ST10100320250511062319', '1446-11-13', '2.220.10', '101', 'an.M. DESTRA MAULANA', '0', '4000', 'Chuwez', '2025-05-11 20:23:19'),
('1461', 'ST10100320250511062344', '1446-11-13', '1.100.10', '101', 'an.DIANA RIFQOTUL QOLBI', '5000', '0', 'Chuwez', '2025-05-11 20:23:44'),
('1462', 'ST10100320250511062344', '1446-11-13', '2.220.10', '101', 'an.DIANA RIFQOTUL QOLBI', '0', '5000', 'Chuwez', '2025-05-11 20:23:44'),
('1463', 'ST10100320250511062406', '1446-11-13', '1.100.10', '101', 'an.ALFI NURDIANA', '5000', '0', 'Chuwez', '2025-05-11 20:24:06'),
('1464', 'ST10100320250511062406', '1446-11-13', '2.220.10', '101', 'an.ALFI NURDIANA', '0', '5000', 'Chuwez', '2025-05-11 20:24:06'),
('1465', 'ST10100320250511062428', '1446-11-13', '1.100.10', '101', 'an.MASRUROTUL MAULUDIYAH', '10000', '0', 'Chuwez', '2025-05-11 20:24:28'),
('1466', 'ST10100320250511062428', '1446-11-13', '2.220.10', '101', 'an.MASRUROTUL MAULUDIYAH', '0', '10000', 'Chuwez', '2025-05-11 20:24:28'),
('1467', 'ST10100320250511062505', '1446-11-13', '1.100.10', '101', 'an.HIKMIAH PUTRI NIKMATUNNAFILAH', '5000', '0', 'Chuwez', '2025-05-11 20:25:05'),
('1468', 'ST10100320250511062505', '1446-11-13', '2.220.10', '101', 'an.HIKMIAH PUTRI NIKMATUNNAFILAH', '0', '5000', 'Chuwez', '2025-05-11 20:25:05'),
('1469', 'ST10100320250511062524', '1446-11-13', '1.100.10', '101', 'an.AISYAH', '5000', '0', 'Chuwez', '2025-05-11 20:25:24'),
('1470', 'ST10100320250511062524', '1446-11-13', '2.220.10', '101', 'an.AISYAH', '0', '5000', 'Chuwez', '2025-05-11 20:25:24'),
('1471', 'ST10100320250511062553', '1446-11-13', '1.100.10', '101', 'an.SITI ATHIUR ROHMAH', '5000', '0', 'Chuwez', '2025-05-11 20:25:54'),
('1472', 'ST10100320250511062553', '1446-11-13', '2.220.10', '101', 'an.SITI ATHIUR ROHMAH', '0', '5000', 'Chuwez', '2025-05-11 20:25:54'),
('1473', 'ST10100320250511062613', '1446-11-13', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '10000', '0', 'Chuwez', '2025-05-11 20:26:13'),
('1474', 'ST10100320250511062613', '1446-11-13', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '10000', 'Chuwez', '2025-05-11 20:26:13'),
('1475', 'ST10100320250511062634', '1446-11-13', '1.100.10', '101', 'an.SITI QURROTUL AINI', '2000', '0', 'Chuwez', '2025-05-11 20:26:34'),
('1476', 'ST10100320250511062634', '1446-11-13', '2.220.10', '101', 'an.SITI QURROTUL AINI', '0', '2000', 'Chuwez', '2025-05-11 20:26:34'),
('1477', 'ST10100320250511062652', '1446-11-13', '1.100.10', '101', 'an.DIYANAH KAMALIYAH', '10000', '0', 'Chuwez', '2025-05-11 20:26:52'),
('1478', 'ST10100320250511062652', '1446-11-13', '2.220.10', '101', 'an.DIYANAH KAMALIYAH', '0', '10000', 'Chuwez', '2025-05-11 20:26:52'),
('1479', 'ST10100320250511062710', '1446-11-13', '1.100.10', '101', 'an.M. FAHMI NURUL ANAM', '10000', '0', 'Chuwez', '2025-05-11 20:27:10'),
('1480', 'ST10100320250511062710', '1446-11-13', '2.220.10', '101', 'an.M. FAHMI NURUL ANAM', '0', '10000', 'Chuwez', '2025-05-11 20:27:10'),
('1481', 'ST10100320250511062733', '1446-11-13', '1.100.10', '101', 'an.AHMAD RAFI SALIM', '4000', '0', 'Chuwez', '2025-05-11 20:27:33'),
('1482', 'ST10100320250511062733', '1446-11-13', '2.220.10', '101', 'an.AHMAD RAFI SALIM', '0', '4000', 'Chuwez', '2025-05-11 20:27:33'),
('1483', 'ST10100320250511062755', '1446-11-13', '1.100.10', '101', 'an.ABDUL HAMID', '5000', '0', 'Chuwez', '2025-05-11 20:27:55'),
('1484', 'ST10100320250511062755', '1446-11-13', '2.220.10', '101', 'an.ABDUL HAMID', '0', '5000', 'Chuwez', '2025-05-11 20:27:55'),
('1485', 'ST10100320250511062816', '1446-11-13', '1.100.10', '101', 'an.KHOIRIYAH', '50000', '0', 'Chuwez', '2025-05-11 20:28:16'),
('1486', 'ST10100320250511062816', '1446-11-13', '2.220.10', '101', 'an.KHOIRIYAH', '0', '50000', 'Chuwez', '2025-05-11 20:28:16'),
('1487', 'ST10100320250511062843', '1446-11-13', '1.100.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '10000', '0', 'Chuwez', '2025-05-11 20:28:43'),
('1488', 'ST10100320250511062843', '1446-11-13', '2.220.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '0', '10000', 'Chuwez', '2025-05-11 20:28:43'),
('1489', 'ST10100320250511073232', '1446-11-13', '1.100.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '5000', '0', 'Chuwez', '2025-05-11 21:32:32'),
('1490', 'ST10100320250511073232', '1446-11-13', '2.220.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '0', '5000', 'Chuwez', '2025-05-11 21:32:32'),
('1491', 'ST10100320250511073316', '1446-11-13', '1.100.10', '101', 'an.HAIKAL SHOMADANI', '2000', '0', 'Chuwez', '2025-05-11 21:33:16'),
('1492', 'ST10100320250511073316', '1446-11-13', '2.220.10', '101', 'an.HAIKAL SHOMADANI', '0', '2000', 'Chuwez', '2025-05-11 21:33:16'),
('1493', 'ST10100320250511073347', '1446-11-13', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '5000', '0', 'Chuwez', '2025-05-11 21:33:47'),
('1494', 'ST10100320250511073347', '1446-11-13', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '5000', 'Chuwez', '2025-05-11 21:33:47'),
('1495', 'ST10100320250511073412', '1446-11-13', '1.100.10', '101', 'an.NAURA BILADINA', '5000', '0', 'Chuwez', '2025-05-11 21:34:12'),
('1496', 'ST10100320250511073412', '1446-11-13', '2.220.10', '101', 'an.NAURA BILADINA', '0', '5000', 'Chuwez', '2025-05-11 21:34:12'),
('1497', 'ST10100320250511073441', '1446-11-13', '1.100.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '5000', '0', 'Chuwez', '2025-05-11 21:34:41'),
('1498', 'ST10100320250511073441', '1446-11-13', '2.220.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '0', '5000', 'Chuwez', '2025-05-11 21:34:41'),
('1499', 'ST10100320250511073501', '1446-11-13', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'Chuwez', '2025-05-11 21:35:01'),
('1500', 'ST10100320250511073501', '1446-11-13', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'Chuwez', '2025-05-11 21:35:02'),
('1501', 'ST10100320250511073533', '1446-11-13', '1.100.10', '101', 'an.AULIA AZZAHRA', '5000', '0', 'Chuwez', '2025-05-11 21:35:33'),
('1502', 'ST10100320250511073533', '1446-11-13', '2.220.10', '101', 'an.AULIA AZZAHRA', '0', '5000', 'Chuwez', '2025-05-11 21:35:33'),
('1503', 'ST10100320250511073606', '1446-11-13', '1.100.10', '101', 'an.SAUQY AHMAD', '5000', '0', 'Chuwez', '2025-05-11 21:36:06'),
('1504', 'ST10100320250511073606', '1446-11-13', '2.220.10', '101', 'an.SAUQY AHMAD', '0', '5000', 'Chuwez', '2025-05-11 21:36:06'),
('1505', 'ST10100320250511073657', '1446-11-13', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Chuwez', '2025-05-11 21:36:57'),
('1506', 'ST10100320250511073657', '1446-11-13', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Chuwez', '2025-05-11 21:36:57'),
('1507', 'ST10100320250511073908', '1446-11-13', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '2000', '0', 'Chuwez', '2025-05-11 21:39:08'),
('1508', 'ST10100320250511073908', '1446-11-13', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '2000', 'Chuwez', '2025-05-11 21:39:08'),
('1509', 'ST10100320250511073925', '1446-11-13', '1.100.10', '101', 'an.NIKMATUL MAULIDAH', '5000', '0', 'Chuwez', '2025-05-11 21:39:25'),
('1510', 'ST10100320250511073925', '1446-11-13', '2.220.10', '101', 'an.NIKMATUL MAULIDAH', '0', '5000', 'Chuwez', '2025-05-11 21:39:25'),
('1511', 'ST10100320250511073952', '1446-11-13', '1.100.10', '101', 'an.RAUDHOTUL JANNAH', '40000', '0', 'Chuwez', '2025-05-11 21:39:52'),
('1512', 'ST10100320250511073952', '1446-11-13', '2.220.10', '101', 'an.RAUDHOTUL JANNAH', '0', '40000', 'Chuwez', '2025-05-11 21:39:52'),
('1513', 'ST10100320250511074101', '1446-11-13', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '5000', '0', 'Chuwez', '2025-05-11 21:41:01'),
('1514', 'ST10100320250511074101', '1446-11-13', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '5000', 'Chuwez', '2025-05-11 21:41:03'),
('1515', 'ST10100320250511074131', '1446-11-13', '1.100.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '20000', '0', 'Chuwez', '2025-05-11 21:41:31'),
('1516', 'ST10100320250511074131', '1446-11-13', '2.220.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '0', '20000', 'Chuwez', '2025-05-11 21:41:31'),
('1517', 'ST10100320250511074147', '1446-11-13', '1.100.10', '101', 'an.MUHAMMAD ILHAM', '5000', '0', 'Chuwez', '2025-05-11 21:41:47'),
('1518', 'ST10100320250511074147', '1446-11-13', '2.220.10', '101', 'an.MUHAMMAD ILHAM', '0', '5000', 'Chuwez', '2025-05-11 21:41:47'),
('1519', 'ST10100320250511074212', '1446-11-13', '1.100.10', '101', 'an.M. KAMALUDDIN', '20000', '0', 'Chuwez', '2025-05-11 21:42:12'),
('1520', 'ST10100320250511074212', '1446-11-13', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '20000', 'Chuwez', '2025-05-11 21:42:12'),
('1521', 'KK10100320250511148305', '1446-11-13', '5.520.38', '101', 'Beli kitab kitab yang kurang', '470000', '0', 'Chuwez', '2025-05-11 21:45:44'),
('1522', 'KK10100320250511144306', '1446-11-13', '1.130.40', '101', 'Beli Lampu dan Gunting', '27000', '0', 'mumuz', '2025-05-11 21:45:44'),
('1523', 'KK10100320250511144306', '1446-11-13', '1.100.10', '101', 'Beli Lampu dan Gunting', '0', '27000', 'mumuz', '2025-05-11 21:47:34'),
('1524', 'KK10100320250511148305', '1446-11-13', '1.100.10', '101', 'Beli kitab kitab yang kurang', '0', '470000', 'Chuwez', '2025-05-11 21:47:34'),
('1525', 'ST10100320250511081318', '1446-11-13', '1.100.10', '101', 'an.M. ABD. HADI', '2000', '0', 'Chuwez', '2025-05-11 22:13:18'),
('1526', 'ST10100320250511081318', '1446-11-13', '2.220.10', '101', 'an.M. ABD. HADI', '0', '2000', 'Chuwez', '2025-05-11 22:13:18'),
('1527', 'ST10100320250511081405', '1446-11-13', '1.100.10', '101', 'an.BILQIS THALIA HASNA', '10000', '0', 'Chuwez', '2025-05-11 22:14:05'),
('1528', 'ST10100320250511081405', '1446-11-13', '2.220.10', '101', 'an.BILQIS THALIA HASNA', '0', '10000', 'Chuwez', '2025-05-11 22:14:05'),
('1529', 'ST10100320250511081427', '1446-11-13', '1.100.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '5000', '0', 'Chuwez', '2025-05-11 22:14:27'),
('1530', 'ST10100320250511081427', '1446-11-13', '2.220.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '0', '5000', 'Chuwez', '2025-05-11 22:14:27'),
('1531', 'ST10100320250511081445', '1446-11-13', '1.100.10', '101', 'an.M. ROFIQ HIDAYATULLOH', '10000', '0', 'Chuwez', '2025-05-11 22:14:45'),
('1532', 'ST10100320250511081445', '1446-11-13', '2.220.10', '101', 'an.M. ROFIQ HIDAYATULLOH', '0', '10000', 'Chuwez', '2025-05-11 22:14:46'),
('1533', 'ST10100320250511081502', '1446-11-13', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '25000', '0', 'Chuwez', '2025-05-11 22:15:02'),
('1534', 'ST10100320250511081502', '1446-11-13', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '25000', 'Chuwez', '2025-05-11 22:15:02'),
('1535', 'ST10100320250511081540', '1446-11-13', '1.100.10', '101', 'an.ZAKIYATUL UMMAH', '2000', '0', 'Chuwez', '2025-05-11 22:15:40'),
('1536', 'ST10100320250511081540', '1446-11-13', '2.220.10', '101', 'an.ZAKIYATUL UMMAH', '0', '2000', 'Chuwez', '2025-05-11 22:15:40'),
('1537', 'ST10100320250511081556', '1446-11-13', '1.100.10', '101', 'an.ROBIATUL ADAWIYAH', '2000', '0', 'Chuwez', '2025-05-11 22:15:56'),
('1538', 'ST10100320250511081556', '1446-11-13', '2.220.10', '101', 'an.ROBIATUL ADAWIYAH', '0', '2000', 'Chuwez', '2025-05-11 22:15:56'),
('1539', 'ST10100320250511081614', '1446-11-13', '1.100.10', '101', 'an.MUHAMMAD KHOIRON', '2000', '0', 'Chuwez', '2025-05-11 22:16:14'),
('1540', 'ST10100320250511081614', '1446-11-13', '2.220.10', '101', 'an.MUHAMMAD KHOIRON', '0', '2000', 'Chuwez', '2025-05-11 22:16:14'),
('1541', 'ST10100320250511081644', '1446-11-13', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '5000', '0', 'Chuwez', '2025-05-11 22:16:44'),
('1542', 'ST10100320250511081644', '1446-11-13', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '5000', 'Chuwez', '2025-05-11 22:16:44'),
('1543', 'ST10100320250511081702', '1446-11-13', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '5000', '0', 'Chuwez', '2025-05-11 22:17:02'),
('1544', 'ST10100320250511081702', '1446-11-13', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '5000', 'Chuwez', '2025-05-11 22:17:02'),
('1545', 'ST10100320250511081716', '1446-11-13', '1.100.10', '101', 'an.AFANDI', '2000', '0', 'Chuwez', '2025-05-11 22:17:16'),
('1546', 'ST10100320250511081716', '1446-11-13', '2.220.10', '101', 'an.AFANDI', '0', '2000', 'Chuwez', '2025-05-11 22:17:16'),
('1547', 'ST10100320250511081732', '1446-11-13', '1.100.10', '101', 'an.M. ALIFIN FIKRI', '4000', '0', 'Chuwez', '2025-05-11 22:17:32'),
('1548', 'ST10100320250511081732', '1446-11-13', '2.220.10', '101', 'an.M. ALIFIN FIKRI', '0', '4000', 'Chuwez', '2025-05-11 22:17:32'),
('1549', 'ST10100320250511081749', '1446-11-13', '1.100.10', '101', 'an.ACH. JUNAIDI', '5000', '0', 'Chuwez', '2025-05-11 22:17:49'),
('1550', 'ST10100320250511081749', '1446-11-13', '2.220.10', '101', 'an.ACH. JUNAIDI', '0', '5000', 'Chuwez', '2025-05-11 22:17:49'),
('1551', 'ST10100320250511081805', '1446-11-13', '1.100.10', '101', 'an.M. ZIDAN RIZQI SALIM', '2000', '0', 'Chuwez', '2025-05-11 22:18:05'),
('1552', 'ST10100320250511081805', '1446-11-13', '2.220.10', '101', 'an.M. ZIDAN RIZQI SALIM', '0', '2000', 'Chuwez', '2025-05-11 22:18:05'),
('1553', 'ST10100320250511081820', '1446-11-13', '1.100.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '2000', '0', 'Chuwez', '2025-05-11 22:18:20'),
('1554', 'ST10100320250511081820', '1446-11-13', '2.220.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '0', '2000', 'Chuwez', '2025-05-11 22:18:20'),
('1555', 'ST10100320250511081852', '1446-11-13', '1.100.10', '101', 'an.ALFIN HIDAYAT', '5000', '0', 'Chuwez', '2025-05-11 22:18:52'),
('1556', 'ST10100320250511081852', '1446-11-13', '2.220.10', '101', 'an.ALFIN HIDAYAT', '0', '5000', 'Chuwez', '2025-05-11 22:18:52'),
('1557', 'ST10100320250511081906', '1446-11-13', '1.100.10', '101', 'an.SAFIRATUL JANNAH', '20000', '0', 'Chuwez', '2025-05-11 22:19:06'),
('1558', 'ST10100320250511081906', '1446-11-13', '2.220.10', '101', 'an.SAFIRATUL JANNAH', '0', '20000', 'Chuwez', '2025-05-11 22:19:06'),
('1559', 'ST10100320250511081950', '1446-11-13', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'Chuwez', '2025-05-11 22:19:50'),
('1560', 'ST10100320250511081950', '1446-11-13', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'Chuwez', '2025-05-11 22:19:50'),
('1561', 'ST10100320250511082011', '1446-11-13', '1.100.10', '101', 'an.HILYA', '10000', '0', 'Chuwez', '2025-05-11 22:20:11'),
('1562', 'ST10100320250511082011', '1446-11-13', '2.220.10', '101', 'an.HILYA', '0', '10000', 'Chuwez', '2025-05-11 22:20:11'),
('1563', 'ST10100320250511082344', '1446-11-13', '1.100.10', '101', 'an.AMARA', '10000', '0', 'Chuwez', '2025-05-11 22:23:44'),
('1564', 'ST10100320250511082344', '1446-11-13', '2.220.10', '101', 'an.AMARA', '0', '10000', 'Chuwez', '2025-05-11 22:23:44'),
('1565', 'ST10100320250512075215', '1446-11-14', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '5000', '0', 'Chuwez', '2025-05-12 21:52:15'),
('1566', 'ST10100320250512075215', '1446-11-14', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '5000', 'Chuwez', '2025-05-12 21:52:15'),
('1567', 'ST10100320250512075230', '1446-11-14', '1.100.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '5000', '0', 'Chuwez', '2025-05-12 21:52:30'),
('1568', 'ST10100320250512075230', '1446-11-14', '2.220.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '0', '5000', 'Chuwez', '2025-05-12 21:52:30'),
('1569', 'ST10100320250512075246', '1446-11-14', '1.100.10', '101', 'an.M. ABD. HADI', '2000', '0', 'Chuwez', '2025-05-12 21:52:46'),
('1570', 'ST10100320250512075246', '1446-11-14', '2.220.10', '101', 'an.M. ABD. HADI', '0', '2000', 'Chuwez', '2025-05-12 21:52:46'),
('1571', 'ST10100320250512075310', '1446-11-14', '1.100.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '10000', '0', 'Chuwez', '2025-05-12 21:53:10'),
('1572', 'ST10100320250512075310', '1446-11-14', '2.220.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '0', '10000', 'Chuwez', '2025-05-12 21:53:10'),
('1573', 'ST10100320250512075356', '1446-11-14', '1.100.10', '101', 'an.HAIKAL SHOMADANI', '2000', '0', 'Chuwez', '2025-05-12 21:53:56'),
('1574', 'ST10100320250512075356', '1446-11-14', '2.220.10', '101', 'an.HAIKAL SHOMADANI', '0', '2000', 'Chuwez', '2025-05-12 21:53:56'),
('1575', 'ST10100320250512075420', '1446-11-14', '1.100.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '5000', '0', 'Chuwez', '2025-05-12 21:54:20'),
('1576', 'ST10100320250512075420', '1446-11-14', '2.220.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '0', '5000', 'Chuwez', '2025-05-12 21:54:20'),
('1577', 'ST10100320250512075440', '1446-11-14', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'Chuwez', '2025-05-12 21:54:40'),
('1578', 'ST10100320250512075440', '1446-11-14', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'Chuwez', '2025-05-12 21:54:40'),
('1579', 'ST10100320250512075502', '1446-11-14', '1.100.10', '101', 'an.NAURA BILADINA', '5000', '0', 'Chuwez', '2025-05-12 21:55:02'),
('1580', 'ST10100320250512075502', '1446-11-14', '2.220.10', '101', 'an.NAURA BILADINA', '0', '5000', 'Chuwez', '2025-05-12 21:55:03'),
('1581', 'ST10100320250512075522', '1446-11-14', '1.100.10', '101', 'an.AULIA AZZAHRA', '4000', '0', 'Chuwez', '2025-05-12 21:55:22'),
('1582', 'ST10100320250512075522', '1446-11-14', '2.220.10', '101', 'an.AULIA AZZAHRA', '0', '4000', 'Chuwez', '2025-05-12 21:55:22'),
('1583', 'ST10100320250512075647', '1446-11-14', '1.100.10', '101', 'an.UMAR FARUQ', '10000', '0', 'Chuwez', '2025-05-12 21:56:47'),
('1584', 'ST10100320250512075647', '1446-11-14', '2.220.10', '101', 'an.UMAR FARUQ', '0', '10000', 'Chuwez', '2025-05-12 21:56:47'),
('1585', 'ST10100320250512075710', '1446-11-14', '1.100.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '4000', '0', 'Chuwez', '2025-05-12 21:57:10'),
('1586', 'ST10100320250512075710', '1446-11-14', '2.220.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '0', '4000', 'Chuwez', '2025-05-12 21:57:10'),
('1587', 'ST10100320250512075727', '1446-11-14', '1.100.10', '101', 'an.MARIATUL QIBTIYAH', '4000', '0', 'Chuwez', '2025-05-12 21:57:27'),
('1588', 'ST10100320250512075727', '1446-11-14', '2.220.10', '101', 'an.MARIATUL QIBTIYAH', '0', '4000', 'Chuwez', '2025-05-12 21:57:27'),
('1589', 'ST10100320250512075753', '1446-11-14', '1.100.10', '101', 'an.NAILATUN NIAMI', '6000', '0', 'Chuwez', '2025-05-12 21:57:53'),
('1590', 'ST10100320250512075753', '1446-11-14', '2.220.10', '101', 'an.NAILATUN NIAMI', '0', '6000', 'Chuwez', '2025-05-12 21:57:53'),
('1591', 'ST10100320250512075812', '1446-11-14', '1.100.10', '101', 'an.MUHAMMAD ARDIANSYAH', '10000', '0', 'Chuwez', '2025-05-12 21:58:12'),
('1592', 'ST10100320250512075812', '1446-11-14', '2.220.10', '101', 'an.MUHAMMAD ARDIANSYAH', '0', '10000', 'Chuwez', '2025-05-12 21:58:12'),
('1593', 'ST10100320250512075833', '1446-11-14', '1.100.10', '101', 'an.ABDULLOH BAHAR', '5000', '0', 'Chuwez', '2025-05-12 21:58:33'),
('1594', 'ST10100320250512075833', '1446-11-14', '2.220.10', '101', 'an.ABDULLOH BAHAR', '0', '5000', 'Chuwez', '2025-05-12 21:58:34'),
('1595', 'ST10100320250512075853', '1446-11-14', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'Chuwez', '2025-05-12 21:58:53'),
('1596', 'ST10100320250512075853', '1446-11-14', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'Chuwez', '2025-05-12 21:58:53'),
('1597', 'ST10100320250512075914', '1446-11-14', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '5000', '0', 'Chuwez', '2025-05-12 21:59:14'),
('1598', 'ST10100320250512075914', '1446-11-14', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '5000', 'Chuwez', '2025-05-12 21:59:15'),
('1599', 'ST10100320250512075935', '1446-11-14', '1.100.10', '101', 'an.RAISA ANNISA', '5000', '0', 'Chuwez', '2025-05-12 21:59:35'),
('1600', 'ST10100320250512075935', '1446-11-14', '2.220.10', '101', 'an.RAISA ANNISA', '0', '5000', 'Chuwez', '2025-05-12 21:59:35'),
('1601', 'ST10100320250512075959', '1446-11-14', '1.100.10', '101', 'an.FAIZAH NURUL LITA', '10000', '0', 'Chuwez', '2025-05-12 21:59:59'),
('1602', 'ST10100320250512075959', '1446-11-14', '2.220.10', '101', 'an.FAIZAH NURUL LITA', '0', '10000', 'Chuwez', '2025-05-12 21:59:59'),
('1603', 'ST10100320250512080019', '1446-11-14', '1.100.10', '101', 'an.MUHAMMAD ALWI', '10000', '0', 'Chuwez', '2025-05-12 22:00:19'),
('1604', 'ST10100320250512080019', '1446-11-14', '2.220.10', '101', 'an.MUHAMMAD ALWI', '0', '10000', 'Chuwez', '2025-05-12 22:00:19'),
('1605', 'ST10100320250512080036', '1446-11-14', '1.100.10', '101', 'an.MARIYATUL QIBTIYAH', '5000', '0', 'Chuwez', '2025-05-12 22:00:36'),
('1606', 'ST10100320250512080036', '1446-11-14', '2.220.10', '101', 'an.MARIYATUL QIBTIYAH', '0', '5000', 'Chuwez', '2025-05-12 22:00:36'),
('1607', 'ST10100320250512080144', '1446-11-14', '1.100.10', '101', 'an.M. DESTRA MAULANA', '20000', '0', 'Chuwez', '2025-05-12 22:01:44'),
('1608', 'ST10100320250512080144', '1446-11-14', '2.220.10', '101', 'an.M. DESTRA MAULANA', '0', '20000', 'Chuwez', '2025-05-12 22:01:44'),
('1609', 'ST10100320250512080202', '1446-11-14', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '10000', '0', 'Chuwez', '2025-05-12 22:02:02'),
('1610', 'ST10100320250512080202', '1446-11-14', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '10000', 'Chuwez', '2025-05-12 22:02:02'),
('1611', 'ST10100320250512080230', '1446-11-14', '1.100.10', '101', 'an.MASRUROTUL MAULUDIYAH', '5000', '0', 'Chuwez', '2025-05-12 22:02:30'),
('1612', 'ST10100320250512080230', '1446-11-14', '2.220.10', '101', 'an.MASRUROTUL MAULUDIYAH', '0', '5000', 'Chuwez', '2025-05-12 22:02:30'),
('1613', 'ST10100320250512080253', '1446-11-14', '1.100.10', '101', 'an.LAILATUL MAGHFIROH', '7000', '0', 'Chuwez', '2025-05-12 22:02:53'),
('1614', 'ST10100320250512080253', '1446-11-14', '2.220.10', '101', 'an.LAILATUL MAGHFIROH', '0', '7000', 'Chuwez', '2025-05-12 22:02:53'),
('1615', 'ST10100320250512080310', '1446-11-14', '1.100.10', '101', 'an.ALFI NURDIANA', '5000', '0', 'Chuwez', '2025-05-12 22:03:10'),
('1616', 'ST10100320250512080310', '1446-11-14', '2.220.10', '101', 'an.ALFI NURDIANA', '0', '5000', 'Chuwez', '2025-05-12 22:03:10'),
('1617', 'ST10100320250512080332', '1446-11-14', '1.100.10', '101', 'an.AISYAH', '2000', '0', 'Chuwez', '2025-05-12 22:03:32'),
('1618', 'ST10100320250512080332', '1446-11-14', '2.220.10', '101', 'an.AISYAH', '0', '2000', 'Chuwez', '2025-05-12 22:03:32'),
('1619', 'ST10100320250512080353', '1446-11-14', '1.100.10', '101', 'an.AHMAD ADITIYA', '5000', '0', 'Chuwez', '2025-05-12 22:03:53'),
('1620', 'ST10100320250512080353', '1446-11-14', '2.220.10', '101', 'an.AHMAD ADITIYA', '0', '5000', 'Chuwez', '2025-05-12 22:03:53'),
('1621', 'ST10100320250512080413', '1446-11-14', '1.100.10', '101', 'an.AZKA AUFARIL MINAN', '10000', '0', 'Chuwez', '2025-05-12 22:04:13'),
('1622', 'ST10100320250512080413', '1446-11-14', '2.220.10', '101', 'an.AZKA AUFARIL MINAN', '0', '10000', 'Chuwez', '2025-05-12 22:04:13'),
('1623', 'ST10100320250512080511', '1446-11-14', '1.100.10', '101', 'an.SAFIRATUL JANNAH', '10000', '0', 'Chuwez', '2025-05-12 22:05:11'),
('1624', 'ST10100320250512080511', '1446-11-14', '2.220.10', '101', 'an.SAFIRATUL JANNAH', '0', '10000', 'Chuwez', '2025-05-12 22:05:11'),
('1625', 'ST10100320250512080541', '1446-11-14', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '10000', '0', 'Chuwez', '2025-05-12 22:05:41'),
('1626', 'ST10100320250512080541', '1446-11-14', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '10000', 'Chuwez', '2025-05-12 22:05:41'),
('1627', 'ST10100320250512080558', '1446-11-14', '1.100.10', '101', 'an.M. ZIDAN RIZQI SALIM', '5000', '0', 'Chuwez', '2025-05-12 22:05:58'),
('1628', 'ST10100320250512080558', '1446-11-14', '2.220.10', '101', 'an.M. ZIDAN RIZQI SALIM', '0', '5000', 'Chuwez', '2025-05-12 22:05:58'),
('1629', 'ST10100320250512080624', '1446-11-14', '1.100.10', '101', 'an.ACH. JUNAIDI', '5000', '0', 'Chuwez', '2025-05-12 22:06:24'),
('1630', 'ST10100320250512080624', '1446-11-14', '2.220.10', '101', 'an.ACH. JUNAIDI', '0', '5000', 'Chuwez', '2025-05-12 22:06:24'),
('1631', 'ST10100320250512080646', '1446-11-14', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '10000', '0', 'Chuwez', '2025-05-12 22:06:46'),
('1632', 'ST10100320250512080646', '1446-11-14', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '10000', 'Chuwez', '2025-05-12 22:06:46'),
('1633', 'ST10100320250512080701', '1446-11-14', '1.100.10', '101', 'an.SITI ATHIUR ROHMAH', '5000', '0', 'Chuwez', '2025-05-12 22:07:01'),
('1634', 'ST10100320250512080701', '1446-11-14', '2.220.10', '101', 'an.SITI ATHIUR ROHMAH', '0', '5000', 'Chuwez', '2025-05-12 22:07:01'),
('1635', 'ST10100320250512080720', '1446-11-14', '1.100.10', '101', 'an.M. FAHMI NURUL ANAM', '30000', '0', 'Chuwez', '2025-05-12 22:07:20'),
('1636', 'ST10100320250512080720', '1446-11-14', '2.220.10', '101', 'an.M. FAHMI NURUL ANAM', '0', '30000', 'Chuwez', '2025-05-12 22:07:20'),
('1637', 'ST10100320250512080741', '1446-11-14', '1.100.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '10000', '0', 'Chuwez', '2025-05-12 22:07:41'),
('1638', 'ST10100320250512080741', '1446-11-14', '2.220.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '0', '10000', 'Chuwez', '2025-05-12 22:07:41'),
('1639', 'ST10100320250512080822', '1446-11-14', '1.100.10', '101', 'an.AHMAD RAFI SALIM', '2000', '0', 'Chuwez', '2025-05-12 22:08:22'),
('1640', 'ST10100320250512080822', '1446-11-14', '2.220.10', '101', 'an.AHMAD RAFI SALIM', '0', '2000', 'Chuwez', '2025-05-12 22:08:22'),
('1641', 'ST10100320250512080840', '1446-11-14', '1.100.10', '101', 'an.HIKMIAH PUTRI NIKMATUNNAFILAH', '5000', '0', 'Chuwez', '2025-05-12 22:08:40'),
('1642', 'ST10100320250512080840', '1446-11-14', '2.220.10', '101', 'an.HIKMIAH PUTRI NIKMATUNNAFILAH', '0', '5000', 'Chuwez', '2025-05-12 22:08:40'),
('1643', 'ST10100320250512080855', '1446-11-14', '1.100.10', '101', 'an.SITI QURROTUL AINI', '2000', '0', 'Chuwez', '2025-05-12 22:08:55'),
('1644', 'ST10100320250512080855', '1446-11-14', '2.220.10', '101', 'an.SITI QURROTUL AINI', '0', '2000', 'Chuwez', '2025-05-12 22:08:55'),
('1645', 'ST10100320250512080937', '1446-11-14', '1.100.10', '101', 'an.MUHAMMAD HAMDANI', '10000', '0', 'Chuwez', '2025-05-12 22:09:37'),
('1646', 'ST10100320250512080937', '1446-11-14', '2.220.10', '101', 'an.MUHAMMAD HAMDANI', '0', '10000', 'Chuwez', '2025-05-12 22:09:37'),
('1647', 'ST10100320250512081021', '1446-11-14', '1.100.10', '101', 'an.ANA SALSABILA', '2000', '0', 'Chuwez', '2025-05-12 22:10:21'),
('1648', 'ST10100320250512081021', '1446-11-14', '2.220.10', '101', 'an.ANA SALSABILA', '0', '2000', 'Chuwez', '2025-05-12 22:10:21'),
('1649', 'ST10100320250512081059', '1446-11-14', '1.100.10', '101', 'an.DIYANAH KAMALIYAH', '5000', '0', 'Chuwez', '2025-05-12 22:10:59'),
('1650', 'ST10100320250512081059', '1446-11-14', '2.220.10', '101', 'an.DIYANAH KAMALIYAH', '0', '5000', 'Chuwez', '2025-05-12 22:10:59'),
('1651', 'ST10100320250512081134', '1446-11-14', '1.100.10', '101', 'an.M. ALIFIN FIKRI', '2000', '0', 'Chuwez', '2025-05-12 22:11:34'),
('1652', 'ST10100320250512081134', '1446-11-14', '2.220.10', '101', 'an.M. ALIFIN FIKRI', '0', '2000', 'Chuwez', '2025-05-12 22:11:34'),
('1653', 'ST10100320250512081158', '1446-11-14', '1.100.10', '101', 'an.AFANDI', '2000', '0', 'Chuwez', '2025-05-12 22:11:58'),
('1654', 'ST10100320250512081158', '1446-11-14', '2.220.10', '101', 'an.AFANDI', '0', '2000', 'Chuwez', '2025-05-12 22:11:58'),
('1655', 'ST10100320250512081215', '1446-11-14', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '5000', '0', 'Chuwez', '2025-05-12 22:12:15'),
('1656', 'ST10100320250512081215', '1446-11-14', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '5000', 'Chuwez', '2025-05-12 22:12:15'),
('1657', 'ST10100320250512081239', '1446-11-14', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '2000', '0', 'Chuwez', '2025-05-12 22:12:39'),
('1658', 'ST10100320250512081239', '1446-11-14', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '2000', 'Chuwez', '2025-05-12 22:12:39'),
('1659', 'ST10100320250512081255', '1446-11-14', '1.100.10', '101', 'an.MUHAMMAD KHOIRON', '5000', '0', 'Chuwez', '2025-05-12 22:12:55'),
('1660', 'ST10100320250512081255', '1446-11-14', '2.220.10', '101', 'an.MUHAMMAD KHOIRON', '0', '5000', 'Chuwez', '2025-05-12 22:12:55'),
('1661', 'ST10100320250512081312', '1446-11-14', '1.100.10', '101', 'an.ZAKIYATUL UMMAH', '2000', '0', 'Chuwez', '2025-05-12 22:13:12'),
('1662', 'ST10100320250512081312', '1446-11-14', '2.220.10', '101', 'an.ZAKIYATUL UMMAH', '0', '2000', 'Chuwez', '2025-05-12 22:13:12'),
('1663', 'ST10100320250512081335', '1446-11-14', '1.100.10', '101', 'an.ROBIATUL ADAWIYAH', '3000', '0', 'Chuwez', '2025-05-12 22:13:35'),
('1664', 'ST10100320250512081335', '1446-11-14', '2.220.10', '101', 'an.ROBIATUL ADAWIYAH', '0', '3000', 'Chuwez', '2025-05-12 22:13:35'),
('1665', 'ST10100320250512081405', '1446-11-14', '1.100.10', '101', 'an.MUHAMMAD YAHYA SYAKARUDDIN', '10000', '0', 'Chuwez', '2025-05-12 22:14:05'),
('1666', 'ST10100320250512081405', '1446-11-14', '2.220.10', '101', 'an.MUHAMMAD YAHYA SYAKARUDDIN', '0', '10000', 'Chuwez', '2025-05-12 22:14:05'),
('1667', 'ST10100320250512081441', '1446-11-14', '1.100.10', '101', 'an.NIKMATUL MAULIDAH', '5000', '0', 'Chuwez', '2025-05-12 22:14:41'),
('1668', 'ST10100320250512081441', '1446-11-14', '2.220.10', '101', 'an.NIKMATUL MAULIDAH', '0', '5000', 'Chuwez', '2025-05-12 22:14:41'),
('1669', 'ST10100320250512081457', '1446-11-14', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Chuwez', '2025-05-12 22:14:57'),
('1670', 'ST10100320250512081457', '1446-11-14', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Chuwez', '2025-05-12 22:14:57'),
('1671', 'ST10100320250512081513', '1446-11-14', '1.100.10', '101', 'an.MIFTAHUL JANNAH', '50000', '0', 'Chuwez', '2025-05-12 22:15:13'),
('1672', 'ST10100320250512081513', '1446-11-14', '2.220.10', '101', 'an.MIFTAHUL JANNAH', '0', '50000', 'Chuwez', '2025-05-12 22:15:13'),
('1673', 'ST10100320250512081527', '1446-11-14', '1.100.10', '101', 'an.NABILATUN NISAUL UMMAH', '20000', '0', 'Chuwez', '2025-05-12 22:15:27'),
('1674', 'ST10100320250512081527', '1446-11-14', '2.220.10', '101', 'an.NABILATUN NISAUL UMMAH', '0', '20000', 'Chuwez', '2025-05-12 22:15:27'),
('1675', 'ST10100320250512081544', '1446-11-14', '1.100.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '10000', '0', 'Chuwez', '2025-05-12 22:15:44'),
('1676', 'ST10100320250512081544', '1446-11-14', '2.220.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '0', '10000', 'Chuwez', '2025-05-12 22:15:44'),
('1677', 'ST10100320250512081558', '1446-11-14', '1.100.10', '101', 'an.M. KAMALUDDIN', '20000', '0', 'Chuwez', '2025-05-12 22:15:58'),
('1678', 'ST10100320250512081558', '1446-11-14', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '20000', 'Chuwez', '2025-05-12 22:15:58'),
('1679', 'ST10100320250512081611', '1446-11-14', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '3000', '0', 'Chuwez', '2025-05-12 22:16:11'),
('1680', 'ST10100320250512081611', '1446-11-14', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '3000', 'Chuwez', '2025-05-12 22:16:11'),
('1681', 'ST10100320250512081630', '1446-11-14', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '5000', '0', 'Chuwez', '2025-05-12 22:16:30'),
('1682', 'ST10100320250512081630', '1446-11-14', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '5000', 'Chuwez', '2025-05-12 22:16:30'),
('1683', 'ST10100320250512081653', '1446-11-14', '1.100.10', '101', 'an.MOCH KHOTIBUL UMAM', '50000', '0', 'Chuwez', '2025-05-12 22:16:53'),
('1684', 'ST10100320250512081653', '1446-11-14', '2.220.10', '101', 'an.MOCH KHOTIBUL UMAM', '0', '50000', 'Chuwez', '2025-05-12 22:16:53'),
('1685', 'ST10100320250512081726', '1446-11-14', '1.100.10', '101', 'an.MUHAMMAD ILHAM', '5000', '0', 'Chuwez', '2025-05-12 22:17:26'),
('1686', 'ST10100320250512081726', '1446-11-14', '2.220.10', '101', 'an.MUHAMMAD ILHAM', '0', '5000', 'Chuwez', '2025-05-12 22:17:26'),
('1687', 'ST10100320250512081745', '1446-11-14', '1.100.10', '101', 'an.RAUDHOTUL JANNAH', '20000', '0', 'Chuwez', '2025-05-12 22:17:45'),
('1688', 'ST10100320250512081745', '1446-11-14', '2.220.10', '101', 'an.RAUDHOTUL JANNAH', '0', '20000', 'Chuwez', '2025-05-12 22:17:45'),
('1689', 'ST10100320250512081757', '1446-11-14', '1.100.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '10000', '0', 'Chuwez', '2025-05-12 22:17:57'),
('1690', 'ST10100320250512081757', '1446-11-14', '2.220.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '0', '10000', 'Chuwez', '2025-05-12 22:17:57'),
('1691', 'ST10100320250512081816', '1446-11-14', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '10000', '0', 'Chuwez', '2025-05-12 22:18:16'),
('1692', 'ST10100320250512081816', '1446-11-14', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '10000', 'Chuwez', '2025-05-12 22:18:16'),
('1693', 'ST10100320250512081855', '1446-11-14', '1.100.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '5000', '0', 'Chuwez', '2025-05-12 22:18:55'),
('1694', 'ST10100320250512081855', '1446-11-14', '2.220.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '0', '5000', 'Chuwez', '2025-05-12 22:18:55'),
('1695', 'ST10100320250512081923', '1446-11-14', '1.100.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '20000', '0', 'Chuwez', '2025-05-12 22:19:23'),
('1696', 'ST10100320250512081923', '1446-11-14', '2.220.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '0', '20000', 'Chuwez', '2025-05-12 22:19:23'),
('1697', 'ST10100320250512081956', '1446-11-14', '1.100.10', '101', 'an.BILQIS THALIA HASNA', '110000', '0', 'Chuwez', '2025-05-12 22:19:56'),
('1698', 'ST10100320250512081956', '1446-11-14', '2.220.10', '101', 'an.BILQIS THALIA HASNA', '0', '110000', 'Chuwez', '2025-05-12 22:19:56'),
('1699', 'ST10100320250512082056', '1446-11-14', '1.100.10', '101', 'an.AHMAD JAMALUL MAIMUN', '5000', '0', 'Chuwez', '2025-05-12 22:20:56'),
('1700', 'ST10100320250512082056', '1446-11-14', '2.220.10', '101', 'an.AHMAD JAMALUL MAIMUN', '0', '5000', 'Chuwez', '2025-05-12 22:20:56'),
('1701', 'ST10100320250512082117', '1446-11-14', '1.100.10', '101', 'an.M. ROFIQ', '65000', '0', 'Chuwez', '2025-05-12 22:21:17'),
('1702', 'ST10100320250512082117', '1446-11-14', '2.220.10', '101', 'an.M. ROFIQ', '0', '65000', 'Chuwez', '2025-05-12 22:21:17'),
('1703', 'ST10100320250512082135', '1446-11-14', '1.100.10', '101', 'an.AKHMAD FIKRI HAIKAL', '50000', '0', 'Chuwez', '2025-05-12 22:21:35'),
('1704', 'ST10100320250512082135', '1446-11-14', '2.220.10', '101', 'an.AKHMAD FIKRI HAIKAL', '0', '50000', 'Chuwez', '2025-05-12 22:21:35'),
('1705', 'ST10100320250512082200', '1446-11-14', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '25000', '0', 'Chuwez', '2025-05-12 22:22:00'),
('1706', 'ST10100320250512082200', '1446-11-14', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '25000', 'Chuwez', '2025-05-12 22:22:00'),
('1707', 'ST10100320250512082219', '1446-11-14', '1.100.10', '101', 'an.SINDI RAISA PUTRI', '10000', '0', 'Chuwez', '2025-05-12 22:22:19'),
('1708', 'ST10100320250512082219', '1446-11-14', '2.220.10', '101', 'an.SINDI RAISA PUTRI', '0', '10000', 'Chuwez', '2025-05-12 22:22:19'),
('1709', 'ST10100320250512082641', '1446-11-14', '1.100.10', '101', 'an.MACHMUDAH', '20000', '0', 'Chuwez', '2025-05-12 22:26:41'),
('1710', 'ST10100320250512082641', '1446-11-14', '2.220.10', '101', 'an.MACHMUDAH', '0', '20000', 'Chuwez', '2025-05-12 22:26:41'),
('1711', 'ST10100320250512082709', '1446-11-14', '1.100.10', '101', 'an.HALIMAH', '5000', '0', 'Chuwez', '2025-05-12 22:27:09'),
('1712', 'ST10100320250512082709', '1446-11-14', '2.220.10', '101', 'an.HALIMAH', '0', '5000', 'Chuwez', '2025-05-12 22:27:09'),
('1713', 'ST10100320250512082733', '1446-11-14', '1.100.10', '101', 'an.HAMIDAH', '10000', '0', 'Chuwez', '2025-05-12 22:27:33'),
('1714', 'ST10100320250512082733', '1446-11-14', '2.220.10', '101', 'an.HAMIDAH', '0', '10000', 'Chuwez', '2025-05-12 22:27:33'),
('1715', 'ST10100320250512082757', '1446-11-14', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'Chuwez', '2025-05-12 22:27:57'),
('1716', 'ST10100320250512082757', '1446-11-14', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'Chuwez', '2025-05-12 22:27:57'),
('1717', 'ST10100320250512082821', '1446-11-14', '1.100.10', '101', 'an.HILYA', '10000', '0', 'Chuwez', '2025-05-12 22:28:21'),
('1718', 'ST10100320250512082821', '1446-11-14', '2.220.10', '101', 'an.HILYA', '0', '10000', 'Chuwez', '2025-05-12 22:28:21'),
('1719', 'ST10100320250512083110', '1446-11-14', '1.100.10', '101', 'an.AMARA', '10000', '0', 'Chuwez', '2025-05-12 22:31:10'),
('1720', 'ST10100320250512083110', '1446-11-14', '2.220.10', '101', 'an.AMARA', '0', '10000', 'Chuwez', '2025-05-12 22:31:11'),
('1735', 'ST10100320250513061219', '1446-11-15', '1.100.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '4000', '0', 'Chuwez', '2025-05-13 20:12:19'),
('1736', 'ST10100320250513061219', '1446-11-15', '2.220.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '0', '4000', 'Chuwez', '2025-05-13 20:12:19'),
('1737', 'ST10100320250513061248', '1446-11-15', '1.100.10', '101', 'an.MUHAMMAD ALWI', '10000', '0', 'Chuwez', '2025-05-13 20:12:48'),
('1738', 'ST10100320250513061248', '1446-11-15', '2.220.10', '101', 'an.MUHAMMAD ALWI', '0', '10000', 'Chuwez', '2025-05-13 20:12:48'),
('1739', 'ST10100320250513061444', '1446-11-15', '1.100.10', '101', 'an.ANA SALSABILA', '5000', '0', 'Chuwez', '2025-05-13 20:14:44'),
('1740', 'ST10100320250513061444', '1446-11-15', '2.220.10', '101', 'an.ANA SALSABILA', '0', '5000', 'Chuwez', '2025-05-13 20:14:44'),
('1741', 'ST10100320250513061508', '1446-11-15', '1.100.10', '101', 'an.KHOIRIYAH', '50000', '0', 'Chuwez', '2025-05-13 20:15:08'),
('1742', 'ST10100320250513061508', '1446-11-15', '2.220.10', '101', 'an.KHOIRIYAH', '0', '50000', 'Chuwez', '2025-05-13 20:15:08'),
('1743', 'ST10100320250513061537', '1446-11-15', '1.100.10', '101', 'an.AHMAD SYAHRU ROMADHONI', '10000', '0', 'Chuwez', '2025-05-13 20:15:37'),
('1744', 'ST10100320250513061537', '1446-11-15', '2.220.10', '101', 'an.AHMAD SYAHRU ROMADHONI', '0', '10000', 'Chuwez', '2025-05-13 20:15:37'),
('1745', 'ST10100320250513061555', '1446-11-15', '1.100.10', '101', 'an.SITI QURROTUL AINI', '2000', '0', 'Chuwez', '2025-05-13 20:15:55'),
('1746', 'ST10100320250513061555', '1446-11-15', '2.220.10', '101', 'an.SITI QURROTUL AINI', '0', '2000', 'Chuwez', '2025-05-13 20:15:55'),
('1747', 'ST10100320250513061614', '1446-11-15', '1.100.10', '101', 'an.HIKMIAH PUTRI NIKMATUNNAFILAH', '5000', '0', 'Chuwez', '2025-05-13 20:16:14'),
('1748', 'ST10100320250513061614', '1446-11-15', '2.220.10', '101', 'an.HIKMIAH PUTRI NIKMATUNNAFILAH', '0', '5000', 'Chuwez', '2025-05-13 20:16:14'),
('1749', 'ST10100320250513061641', '1446-11-15', '1.100.10', '101', 'an.ABDUL HAMID', '5000', '0', 'Chuwez', '2025-05-13 20:16:41'),
('1750', 'ST10100320250513061641', '1446-11-15', '2.220.10', '101', 'an.ABDUL HAMID', '0', '5000', 'Chuwez', '2025-05-13 20:16:41'),
('1751', 'ST10100320250513061710', '1446-11-15', '1.100.10', '101', 'an.DIYANAH KAMALIYAH', '5000', '0', 'Chuwez', '2025-05-13 20:17:10'),
('1752', 'ST10100320250513061710', '1446-11-15', '2.220.10', '101', 'an.DIYANAH KAMALIYAH', '0', '5000', 'Chuwez', '2025-05-13 20:17:10'),
('1753', 'ST10100320250513061726', '1446-11-15', '1.100.10', '101', 'an.SITI ATHIUR ROHMAH', '5000', '0', 'Chuwez', '2025-05-13 20:17:26'),
('1754', 'ST10100320250513061726', '1446-11-15', '2.220.10', '101', 'an.SITI ATHIUR ROHMAH', '0', '5000', 'Chuwez', '2025-05-13 20:17:26'),
('1755', 'ST10100320250513061752', '1446-11-15', '1.100.10', '101', 'an.ROFIQOTUS SARIROH', '5000', '0', 'Chuwez', '2025-05-13 20:17:52'),
('1756', 'ST10100320250513061752', '1446-11-15', '2.220.10', '101', 'an.ROFIQOTUS SARIROH', '0', '5000', 'Chuwez', '2025-05-13 20:17:52'),
('1757', 'ST10100320250513061810', '1446-11-15', '1.100.10', '101', 'an.ACH. JUNAIDI', '5000', '0', 'Chuwez', '2025-05-13 20:18:10'),
('1758', 'ST10100320250513061810', '1446-11-15', '2.220.10', '101', 'an.ACH. JUNAIDI', '0', '5000', 'Chuwez', '2025-05-13 20:18:10'),
('1759', 'ST10100320250513061828', '1446-11-15', '1.100.10', '101', 'an.M. ZIDAN RIZQI SALIM', '10000', '0', 'Chuwez', '2025-05-13 20:18:28'),
('1760', 'ST10100320250513061828', '1446-11-15', '2.220.10', '101', 'an.M. ZIDAN RIZQI SALIM', '0', '10000', 'Chuwez', '2025-05-13 20:18:28'),
('1761', 'ST10100320250513061853', '1446-11-15', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '10000', '0', 'Chuwez', '2025-05-13 20:18:53'),
('1762', 'ST10100320250513061853', '1446-11-15', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '10000', 'Chuwez', '2025-05-13 20:18:53'),
('1765', 'ST10100320250513061947', '1446-11-15', '1.100.10', '101', 'an.ABDULLOH BAHAR', '3000', '0', 'Chuwez', '2025-05-13 20:19:47'),
('1766', 'ST10100320250513061947', '1446-11-15', '2.220.10', '101', 'an.ABDULLOH BAHAR', '0', '3000', 'Chuwez', '2025-05-13 20:19:47'),
('1767', 'ST10100320250513062008', '1446-11-15', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'Chuwez', '2025-05-13 20:20:08'),
('1768', 'ST10100320250513062008', '1446-11-15', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'Chuwez', '2025-05-13 20:20:08'),
('1769', 'ST10100320250513062028', '1446-11-15', '1.100.10', '101', 'an.RAISA ANNISA', '5000', '0', 'Chuwez', '2025-05-13 20:20:28'),
('1770', 'ST10100320250513062028', '1446-11-15', '2.220.10', '101', 'an.RAISA ANNISA', '0', '5000', 'Chuwez', '2025-05-13 20:20:28'),
('1771', 'ST10100320250513062048', '1446-11-15', '1.100.10', '101', 'an.MARIATUL QIBTIYAH', '2000', '0', 'Chuwez', '2025-05-13 20:20:48'),
('1772', 'ST10100320250513062048', '1446-11-15', '2.220.10', '101', 'an.MARIATUL QIBTIYAH', '0', '2000', 'Chuwez', '2025-05-13 20:20:49'),
('1773', 'ST10100320250513062108', '1446-11-15', '1.100.10', '101', 'an.ROHMATULLOH', '5000', '0', 'Chuwez', '2025-05-13 20:21:08'),
('1774', 'ST10100320250513062108', '1446-11-15', '2.220.10', '101', 'an.ROHMATULLOH', '0', '5000', 'Chuwez', '2025-05-13 20:21:08'),
('1775', 'ST10100320250513062128', '1446-11-15', '1.100.10', '101', 'an.UMAR FARUQ', '10000', '0', 'Chuwez', '2025-05-13 20:21:28'),
('1776', 'ST10100320250513062128', '1446-11-15', '2.220.10', '101', 'an.UMAR FARUQ', '0', '10000', 'Chuwez', '2025-05-13 20:21:28'),
('1777', 'ST10100320250513062155', '1446-11-15', '1.100.10', '101', 'an.MUHAMMAD ARDIANSYAH', '10000', '0', 'Chuwez', '2025-05-13 20:21:55'),
('1778', 'ST10100320250513062155', '1446-11-15', '2.220.10', '101', 'an.MUHAMMAD ARDIANSYAH', '0', '10000', 'Chuwez', '2025-05-13 20:21:55'),
('1779', 'ST10100320250513062213', '1446-11-15', '1.100.10', '101', 'an.MUHAMMAD HAMDANI', '10000', '0', 'Chuwez', '2025-05-13 20:22:13'),
('1780', 'ST10100320250513062213', '1446-11-15', '2.220.10', '101', 'an.MUHAMMAD HAMDANI', '0', '10000', 'Chuwez', '2025-05-13 20:22:13'),
('1781', 'ST10100320250513062232', '1446-11-15', '1.100.10', '101', 'an.ZAKIYATUL UMMAH', '2000', '0', 'Chuwez', '2025-05-13 20:22:32'),
('1782', 'ST10100320250513062232', '1446-11-15', '2.220.10', '101', 'an.ZAKIYATUL UMMAH', '0', '2000', 'Chuwez', '2025-05-13 20:22:32'),
('1783', 'ST10100320250513062251', '1446-11-15', '1.100.10', '101', 'an.MUHAMMAD KHOIRON', '10000', '0', 'Chuwez', '2025-05-13 20:22:51'),
('1784', 'ST10100320250513062251', '1446-11-15', '2.220.10', '101', 'an.MUHAMMAD KHOIRON', '0', '10000', 'Chuwez', '2025-05-13 20:22:51'),
('1785', 'ST10100320250513062312', '1446-11-15', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '5000', '0', 'Chuwez', '2025-05-13 20:23:12'),
('1786', 'ST10100320250513062312', '1446-11-15', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '5000', 'Chuwez', '2025-05-13 20:23:12'),
('1787', 'ST10100320250513062336', '1446-11-15', '1.100.10', '101', 'an.AFANDI', '2000', '0', 'Chuwez', '2025-05-13 20:23:36'),
('1788', 'ST10100320250513062336', '1446-11-15', '2.220.10', '101', 'an.AFANDI', '0', '2000', 'Chuwez', '2025-05-13 20:23:36'),
('1789', 'ST10100320250513062401', '1446-11-15', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '2000', '0', 'Chuwez', '2025-05-13 20:24:01'),
('1790', 'ST10100320250513062401', '1446-11-15', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '2000', 'Chuwez', '2025-05-13 20:24:02'),
('1791', 'ST10100320250513062427', '1446-11-15', '1.100.10', '101', 'an.ROBIATUL ADAWIYAH', '5000', '0', 'Chuwez', '2025-05-13 20:24:27'),
('1792', 'ST10100320250513062427', '1446-11-15', '2.220.10', '101', 'an.ROBIATUL ADAWIYAH', '0', '5000', 'Chuwez', '2025-05-13 20:24:27'),
('1793', 'ST10100320250513062448', '1446-11-15', '1.100.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '4000', '0', 'Chuwez', '2025-05-13 20:24:48'),
('1794', 'ST10100320250513062448', '1446-11-15', '2.220.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '0', '4000', 'Chuwez', '2025-05-13 20:24:48'),
('1795', 'ST10100320250513062508', '1446-11-15', '1.100.10', '101', 'an.M. ABDIL ARIKIN', '4000', '0', 'Chuwez', '2025-05-13 20:25:08'),
('1796', 'ST10100320250513062508', '1446-11-15', '2.220.10', '101', 'an.M. ABDIL ARIKIN', '0', '4000', 'Chuwez', '2025-05-13 20:25:08'),
('1797', 'ST10100320250513062605', '1446-11-15', '1.100.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '5000', '0', 'Chuwez', '2025-05-13 20:26:05'),
('1798', 'ST10100320250513062605', '1446-11-15', '2.220.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '0', '5000', 'Chuwez', '2025-05-13 20:26:05'),
('1799', 'ST10100320250513062628', '1446-11-15', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '10000', '0', 'Chuwez', '2025-05-13 20:26:28'),
('1800', 'ST10100320250513062628', '1446-11-15', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '10000', 'Chuwez', '2025-05-13 20:26:28'),
('1801', 'ST10100320250513062651', '1446-11-15', '1.100.10', '101', 'an.AZKA AUFARIL MINAN', '10000', '0', 'Chuwez', '2025-05-13 20:26:51'),
('1802', 'ST10100320250513062651', '1446-11-15', '2.220.10', '101', 'an.AZKA AUFARIL MINAN', '0', '10000', 'Chuwez', '2025-05-13 20:26:51'),
('1803', 'ST10100320250513062710', '1446-11-15', '1.100.10', '101', 'an.DIANA RIFQOTUL QOLBI', '10000', '0', 'Chuwez', '2025-05-13 20:27:10'),
('1804', 'ST10100320250513062710', '1446-11-15', '2.220.10', '101', 'an.DIANA RIFQOTUL QOLBI', '0', '10000', 'Chuwez', '2025-05-13 20:27:10'),
('1805', 'ST10100320250513062728', '1446-11-15', '1.100.10', '101', 'an.LAILATUL MAGHFIROH', '10000', '0', 'Chuwez', '2025-05-13 20:27:28'),
('1806', 'ST10100320250513062728', '1446-11-15', '2.220.10', '101', 'an.LAILATUL MAGHFIROH', '0', '10000', 'Chuwez', '2025-05-13 20:27:28'),
('1809', 'ST10100320250513062814', '1446-11-15', '1.100.10', '101', 'an.AHMAD ADITIYA', '5000', '0', 'Chuwez', '2025-05-13 20:28:14'),
('1810', 'ST10100320250513062814', '1446-11-15', '2.220.10', '101', 'an.AHMAD ADITIYA', '0', '5000', 'Chuwez', '2025-05-13 20:28:14'),
('1811', 'ST10100320250513062832', '1446-11-15', '1.100.10', '101', 'an.AISYAH', '2000', '0', 'Chuwez', '2025-05-13 20:28:32'),
('1812', 'ST10100320250513062832', '1446-11-15', '2.220.10', '101', 'an.AISYAH', '0', '2000', 'Chuwez', '2025-05-13 20:28:32'),
('1813', 'ST10100320250513062851', '1446-11-15', '1.100.10', '101', 'an.ALFI NURDIANA', '5000', '0', 'Chuwez', '2025-05-13 20:28:51'),
('1814', 'ST10100320250513062851', '1446-11-15', '2.220.10', '101', 'an.ALFI NURDIANA', '0', '5000', 'Chuwez', '2025-05-13 20:28:51'),
('1815', 'ST10100320250513062907', '1446-11-15', '1.100.10', '101', 'an.MASRUROTUL MAULUDIYAH', '5000', '0', 'Chuwez', '2025-05-13 20:29:07'),
('1816', 'ST10100320250513062907', '1446-11-15', '2.220.10', '101', 'an.MASRUROTUL MAULUDIYAH', '0', '5000', 'Chuwez', '2025-05-13 20:29:07'),
('1817', 'ST10100320250513063003', '1446-11-15', '1.100.10', '101', 'an.SINDI RAISA PUTRI', '10000', '0', 'Chuwez', '2025-05-13 20:30:04'),
('1818', 'ST10100320250513063003', '1446-11-15', '2.220.10', '101', 'an.SINDI RAISA PUTRI', '0', '10000', 'Chuwez', '2025-05-13 20:30:04'),
('1819', 'ST10100320250513063022', '1446-11-15', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '30000', '0', 'Chuwez', '2025-05-13 20:30:22'),
('1820', 'ST10100320250513063022', '1446-11-15', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '30000', 'Chuwez', '2025-05-13 20:30:22'),
('1821', 'ST10100320250513063041', '1446-11-15', '1.100.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '10000', '0', 'Chuwez', '2025-05-13 20:30:41'),
('1822', 'ST10100320250513063041', '1446-11-15', '2.220.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '0', '10000', 'Chuwez', '2025-05-13 20:30:41'),
('1823', 'ST10100320250513063101', '1446-11-15', '1.100.10', '101', 'an.AHMAD JAMALUL MAIMUN', '5000', '0', 'Chuwez', '2025-05-13 20:31:01'),
('1824', 'ST10100320250513063101', '1446-11-15', '2.220.10', '101', 'an.AHMAD JAMALUL MAIMUN', '0', '5000', 'Chuwez', '2025-05-13 20:31:03'),
('1825', 'ST10100320250513063126', '1446-11-15', '1.100.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '5000', '0', 'Chuwez', '2025-05-13 20:31:26'),
('1826', 'ST10100320250513063126', '1446-11-15', '2.220.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '0', '5000', 'Chuwez', '2025-05-13 20:31:26'),
('1827', 'ST10100320250513063346', '1446-11-15', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Chuwez', '2025-05-13 20:33:46'),
('1828', 'ST10100320250513063346', '1446-11-15', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Chuwez', '2025-05-13 20:33:46'),
('1829', 'ST10100320250513063451', '1446-11-15', '1.100.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '10000', '0', 'Chuwez', '2025-05-13 20:34:51'),
('1830', 'ST10100320250513063451', '1446-11-15', '2.220.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '0', '10000', 'Chuwez', '2025-05-13 20:34:51'),
('1831', 'ST10100320250513063515', '1446-11-15', '1.100.10', '101', 'an.IZZA BILLAH', '10000', '0', 'Chuwez', '2025-05-13 20:35:15'),
('1832', 'ST10100320250513063515', '1446-11-15', '2.220.10', '101', 'an.IZZA BILLAH', '0', '10000', 'Chuwez', '2025-05-13 20:35:15'),
('1833', 'ST10100320250513063540', '1446-11-15', '1.100.10', '101', 'an.RAUDHOTUL JANNAH', '20000', '0', 'Chuwez', '2025-05-13 20:35:40'),
('1834', 'ST10100320250513063540', '1446-11-15', '2.220.10', '101', 'an.RAUDHOTUL JANNAH', '0', '20000', 'Chuwez', '2025-05-13 20:35:40'),
('1835', 'ST10100320250513063607', '1446-11-15', '1.100.10', '101', 'an.NABILATUN NISAUL UMMAH', '20000', '0', 'Chuwez', '2025-05-13 20:36:07'),
('1836', 'ST10100320250513063607', '1446-11-15', '2.220.10', '101', 'an.NABILATUN NISAUL UMMAH', '0', '20000', 'Chuwez', '2025-05-13 20:36:07'),
('1837', 'ST10100320250513063632', '1446-11-15', '1.100.10', '101', 'an.MUHAMMAD ILHAM', '5000', '0', 'Chuwez', '2025-05-13 20:36:32'),
('1838', 'ST10100320250513063632', '1446-11-15', '2.220.10', '101', 'an.MUHAMMAD ILHAM', '0', '5000', 'Chuwez', '2025-05-13 20:36:32'),
('1839', 'ST10100320250513063654', '1446-11-15', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '5000', '0', 'Chuwez', '2025-05-13 20:36:54'),
('1840', 'ST10100320250513063654', '1446-11-15', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '5000', 'Chuwez', '2025-05-13 20:36:54'),
('1841', 'ST10100320250513063724', '1446-11-15', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '10000', '0', 'Chuwez', '2025-05-13 20:37:24'),
('1842', 'ST10100320250513063724', '1446-11-15', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '10000', 'Chuwez', '2025-05-13 20:37:24'),
('1843', 'ST10100320250513063755', '1446-11-15', '1.100.10', '101', 'an.RENI FARIDA', '6000', '0', 'Chuwez', '2025-05-13 20:37:55'),
('1844', 'ST10100320250513063755', '1446-11-15', '2.220.10', '101', 'an.RENI FARIDA', '0', '6000', 'Chuwez', '2025-05-13 20:37:56'),
('1845', 'ST10100320250513063813', '1446-11-15', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '2000', '0', 'Chuwez', '2025-05-13 20:38:13'),
('1846', 'ST10100320250513063813', '1446-11-15', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '2000', 'Chuwez', '2025-05-13 20:38:13'),
('1847', 'ST10100320250513063836', '1446-11-15', '1.100.10', '101', 'an.M. KAMALUDDIN', '20000', '0', 'Chuwez', '2025-05-13 20:38:36'),
('1848', 'ST10100320250513063836', '1446-11-15', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '20000', 'Chuwez', '2025-05-13 20:38:36'),
('1849', 'ST10100320250513063906', '1446-11-15', '1.100.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '10000', '0', 'Chuwez', '2025-05-13 20:39:06'),
('1850', 'ST10100320250513063906', '1446-11-15', '2.220.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '0', '10000', 'Chuwez', '2025-05-13 20:39:06'),
('1851', 'ST10100320250513072821', '1446-11-15', '1.100.10', '101', 'an.M. ABD. HADI', '2000', '0', 'Chuwez', '2025-05-13 21:28:21'),
('1852', 'ST10100320250513072821', '1446-11-15', '2.220.10', '101', 'an.M. ABD. HADI', '0', '2000', 'Chuwez', '2025-05-13 21:28:21'),
('1853', 'ST10100320250513072845', '1446-11-15', '1.100.10', '101', 'an.NAURA BILADINA', '5000', '0', 'Chuwez', '2025-05-13 21:28:45'),
('1854', 'ST10100320250513072845', '1446-11-15', '2.220.10', '101', 'an.NAURA BILADINA', '0', '5000', 'Chuwez', '2025-05-13 21:28:45'),
('1855', 'ST10100320250513072908', '1446-11-15', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '5000', '0', 'Chuwez', '2025-05-13 21:29:08'),
('1856', 'ST10100320250513072908', '1446-11-15', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '5000', 'Chuwez', '2025-05-13 21:29:08'),
('1857', 'ST10100320250513072930', '1446-11-15', '1.100.10', '101', 'an.ADIBA QONITA', '30000', '0', 'Chuwez', '2025-05-13 21:29:30'),
('1858', 'ST10100320250513072930', '1446-11-15', '2.220.10', '101', 'an.ADIBA QONITA', '0', '30000', 'Chuwez', '2025-05-13 21:29:30'),
('1859', 'ST10100320250513072949', '1446-11-15', '1.100.10', '101', 'an.HAIKAL SHOMADANI', '2000', '0', 'Chuwez', '2025-05-13 21:29:49'),
('1860', 'ST10100320250513072949', '1446-11-15', '2.220.10', '101', 'an.HAIKAL SHOMADANI', '0', '2000', 'Chuwez', '2025-05-13 21:29:49'),
('1861', 'ST10100320250513073013', '1446-11-15', '1.100.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '5000', '0', 'Chuwez', '2025-05-13 21:30:13'),
('1862', 'ST10100320250513073013', '1446-11-15', '2.220.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '0', '5000', 'Chuwez', '2025-05-13 21:30:13'),
('1863', 'ST10100320250513073029', '1446-11-15', '1.100.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '10000', '0', 'Chuwez', '2025-05-13 21:30:29'),
('1864', 'ST10100320250513073029', '1446-11-15', '2.220.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '0', '10000', 'Chuwez', '2025-05-13 21:30:29'),
('1865', 'ST10100320250513073047', '1446-11-15', '1.100.10', '101', 'an.AULIA AZZAHRA', '5000', '0', 'Chuwez', '2025-05-13 21:30:47'),
('1866', 'ST10100320250513073047', '1446-11-15', '2.220.10', '101', 'an.AULIA AZZAHRA', '0', '5000', 'Chuwez', '2025-05-13 21:30:47'),
('1867', 'ST10100320250513073106', '1446-11-15', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'Chuwez', '2025-05-13 21:31:06'),
('1868', 'ST10100320250513073106', '1446-11-15', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'Chuwez', '2025-05-13 21:31:06'),
('1869', 'ST10100320250513073135', '1446-11-15', '1.100.10', '101', 'an.SAFIRATUL JANNAH', '10000', '0', 'Chuwez', '2025-05-13 21:31:35'),
('1870', 'ST10100320250513073135', '1446-11-15', '2.220.10', '101', 'an.SAFIRATUL JANNAH', '0', '10000', 'Chuwez', '2025-05-13 21:31:35'),
('1871', 'ST10100320250513073246', '1446-11-15', '1.100.10', '101', 'an.FAIZAH NURUL LITA', '10000', '0', 'Chuwez', '2025-05-13 21:32:46'),
('1872', 'ST10100320250513073246', '1446-11-15', '2.220.10', '101', 'an.FAIZAH NURUL LITA', '0', '10000', 'Chuwez', '2025-05-13 21:32:46'),
('1873', 'ST10100320250513073309', '1446-11-15', '1.100.10', '101', 'an.NAILATUN NIAMI', '5000', '0', 'Chuwez', '2025-05-13 21:33:09'),
('1874', 'ST10100320250513073309', '1446-11-15', '2.220.10', '101', 'an.NAILATUN NIAMI', '0', '5000', 'Chuwez', '2025-05-13 21:33:10'),
('1875', 'ST10100320250513073337', '1446-11-15', '1.100.10', '101', 'an.MARIYATUL QIBTIYAH', '5000', '0', 'Chuwez', '2025-05-13 21:33:37'),
('1876', 'ST10100320250513073337', '1446-11-15', '2.220.10', '101', 'an.MARIYATUL QIBTIYAH', '0', '5000', 'Chuwez', '2025-05-13 21:33:37'),
('1877', 'ST10100320250513073417', '1446-11-15', '1.100.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '10000', '0', 'Chuwez', '2025-05-13 21:34:17'),
('1878', 'ST10100320250513073417', '1446-11-15', '2.220.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '0', '10000', 'Chuwez', '2025-05-13 21:34:17'),
('1879', 'ST10100320250513073444', '1446-11-15', '1.100.10', '101', 'an.AHMAD ABBAS MAULANA', '3000', '0', 'Chuwez', '2025-05-13 21:34:44'),
('1880', 'ST10100320250513073444', '1446-11-15', '2.220.10', '101', 'an.AHMAD ABBAS MAULANA', '0', '3000', 'Chuwez', '2025-05-13 21:34:44'),
('1881', 'ST10100320250513073514', '1446-11-15', '1.100.10', '101', 'an.BILQIS THALIA HASNA', '60000', '0', 'Chuwez', '2025-05-13 21:35:14'),
('1882', 'ST10100320250513073514', '1446-11-15', '2.220.10', '101', 'an.BILQIS THALIA HASNA', '0', '60000', 'Chuwez', '2025-05-13 21:35:14'),
('1883', 'ST10100320250513073550', '1446-11-15', '1.100.10', '101', 'an.HILYA', '10000', '0', 'Chuwez', '2025-05-13 21:35:50'),
('1884', 'ST10100320250513073550', '1446-11-15', '2.220.10', '101', 'an.HILYA', '0', '10000', 'Chuwez', '2025-05-13 21:35:50'),
('1885', 'ST10100320250513073614', '1446-11-15', '1.100.10', '101', 'an.HALIMAH', '10000', '0', 'Chuwez', '2025-05-13 21:36:14'),
('1886', 'ST10100320250513073614', '1446-11-15', '2.220.10', '101', 'an.HALIMAH', '0', '10000', 'Chuwez', '2025-05-13 21:36:14'),
('1887', 'ST10100320250513074017', '1446-11-15', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'Chuwez', '2025-05-13 21:40:17'),
('1888', 'ST10100320250513074017', '1446-11-15', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'Chuwez', '2025-05-13 21:40:18'),
('1889', 'ST10100320250513062754', '1446-11-15', '1.100.10', '101', 'an.M. DESTRA MAULANA', '54000', '0', 'Chuwez', '2025-05-13 22:09:30'),
('1890', 'ST10100320250513062754', '1446-11-15', '2.220.10', '101', 'an.M. DESTRA MAULANA', '0', '54000', 'Chuwez', '2025-05-13 22:09:30'),
('1891', 'KK10100320250513151828', '1446-11-15', '5.520.42', '101', 'Beli cilok', '10000', '0', 'Chuwez', '2025-05-13 15:18:58'),
('1892', 'KK10100320250513151828', '1446-11-15', '1.100.10', '101', 'Beli cilok', '0', '10000', 'Chuwez', '2025-05-13 15:18:58'),
('1893', 'SY10100220250513082343000', '1446-10-15', '1.100.10', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '30000', '0', 'Ipul', '2025-05-13 15:23:43'),
('1894', 'SY10100220250513082343000', '1446-10-15', '4.400.20', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '0', '30000', 'Ipul', '2025-05-13 15:23:43'),
('1895', 'SY10100220250513082343001', '1446-11-15', '1.100.10', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '30000', '0', 'Ipul', '2025-05-13 15:23:43'),
('1896', 'SY10100220250513082343001', '1446-11-15', '4.400.20', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '0', '30000', 'Ipul', '2025-05-13 15:23:43'),
('1897', 'SY10100220250513082344002', '1446-12-15', '1.100.10', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '30000', '0', 'Ipul', '2025-05-13 15:23:44'),
('1898', 'SY10100220250513082344002', '1446-12-15', '4.400.20', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '0', '30000', 'Ipul', '2025-05-13 15:23:44'),
('1899', 'SY10100220250513082344003', '1447-01-15', '1.100.10', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '30000', '0', 'Ipul', '2025-05-13 15:23:44'),
('1900', 'SY10100220250513082344003', '1447-01-15', '4.400.20', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '0', '30000', 'Ipul', '2025-05-13 15:23:44'),
('1901', 'SY10100220250513082344004', '1447-02-15', '1.100.10', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '30000', '0', 'Ipul', '2025-05-13 15:23:44'),
('1902', 'SY10100220250513082344004', '1447-02-15', '4.400.20', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '0', '30000', 'Ipul', '2025-05-13 15:23:44'),
('1903', 'SY10100220250513082344005', '1447-03-15', '1.100.10', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '30000', '0', 'Ipul', '2025-05-13 15:23:44'),
('1904', 'SY10100220250513082344005', '1447-03-15', '4.400.20', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '0', '30000', 'Ipul', '2025-05-13 15:23:44'),
('1905', 'SY10100220250513082344006', '1447-04-15', '1.100.10', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '30000', '0', 'Ipul', '2025-05-13 15:23:44'),
('1906', 'SY10100220250513082344006', '1447-04-15', '4.400.20', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '0', '30000', 'Ipul', '2025-05-13 15:23:44'),
('1907', 'SY10100220250513082344007', '1447-05-15', '1.100.10', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '30000', '0', 'Ipul', '2025-05-13 15:23:44'),
('1908', 'SY10100220250513082344007', '1447-05-15', '4.400.20', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '0', '30000', 'Ipul', '2025-05-13 15:23:44'),
('1909', 'SY10100220250513082344008', '1447-06-15', '1.100.10', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '30000', '0', 'Ipul', '2025-05-13 15:23:44'),
('1910', 'SY10100220250513082344008', '1447-06-15', '4.400.20', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '0', '30000', 'Ipul', '2025-05-13 15:23:44'),
('1911', 'SY10100220250513082344009', '1447-07-15', '1.100.10', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '30000', '0', 'Ipul', '2025-05-13 15:23:44'),
('1912', 'SY10100220250513082344009', '1447-07-15', '4.400.20', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '0', '30000', 'Ipul', '2025-05-13 15:23:44'),
('1913', 'SY10100220250513082344010', '1447-08-15', '1.100.10', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '30000', '0', 'Ipul', '2025-05-13 15:23:44'),
('1914', 'SY10100220250513082344010', '1447-08-15', '4.400.20', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '0', '30000', 'Ipul', '2025-05-13 15:23:44'),
('1915', 'ST10100320250513083618', '1446-11-15', '1.100.10', '101', 'an.AMARA', '10000', '0', 'Chuwez', '2025-05-13 22:36:18'),
('1916', 'ST10100320250513083618', '1446-11-15', '2.220.10', '101', 'an.AMARA', '0', '10000', 'Chuwez', '2025-05-13 22:36:18'),
('1917', 'ST10100320250514074734', '1446-11-13', '1.100.10', '101', 'an.UST THORIQUL HUDA', '20000', '0', 'Chuwez', '2025-05-14 21:47:34'),
('1918', 'ST10100320250514074734', '1446-11-13', '2.220.10', '101', 'an.UST THORIQUL HUDA', '0', '20000', 'Chuwez', '2025-05-14 21:47:34'),
('1919', 'ST10100320250514075228', '1446-11-16', '1.100.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '2000', '0', 'Chuwez', '2025-05-14 21:52:28'),
('1920', 'ST10100320250514075228', '1446-11-16', '2.220.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '0', '2000', 'Chuwez', '2025-05-14 21:52:28'),
('1921', 'ST10100320250514075314', '1446-11-16', '1.100.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '5000', '0', 'Chuwez', '2025-05-14 21:53:14'),
('1922', 'ST10100320250514075314', '1446-11-16', '2.220.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '0', '5000', 'Chuwez', '2025-05-14 21:53:14'),
('1923', 'ST10100320250514075423', '1446-11-16', '1.100.10', '101', 'an.NAURA BILADINA', '5000', '0', 'Chuwez', '2025-05-14 21:54:23'),
('1924', 'ST10100320250514075423', '1446-11-16', '2.220.10', '101', 'an.NAURA BILADINA', '0', '5000', 'Chuwez', '2025-05-14 21:54:23'),
('1925', 'ST10100320250514075436', '1446-11-16', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '5000', '0', 'Chuwez', '2025-05-14 21:54:36'),
('1926', 'ST10100320250514075436', '1446-11-16', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '5000', 'Chuwez', '2025-05-14 21:54:36'),
('1927', 'ST10100320250514075458', '1446-11-16', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'Chuwez', '2025-05-14 21:54:58'),
('1928', 'ST10100320250514075458', '1446-11-16', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'Chuwez', '2025-05-14 21:54:58'),
('1929', 'ST10100320250514075514', '1446-11-16', '1.100.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '10000', '0', 'Chuwez', '2025-05-14 21:55:14'),
('1930', 'ST10100320250514075514', '1446-11-16', '2.220.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '0', '10000', 'Chuwez', '2025-05-14 21:55:14'),
('1931', 'ST10100320250514075537', '1446-11-16', '1.100.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '5000', '0', 'Chuwez', '2025-05-14 21:55:37'),
('1932', 'ST10100320250514075537', '1446-11-16', '2.220.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '0', '5000', 'Chuwez', '2025-05-14 21:55:37'),
('1933', 'ST10100320250514075559', '1446-11-16', '1.100.10', '101', 'an.M. ABD. HADI', '2000', '0', 'Chuwez', '2025-05-14 21:55:59'),
('1934', 'ST10100320250514075559', '1446-11-16', '2.220.10', '101', 'an.M. ABD. HADI', '0', '2000', 'Chuwez', '2025-05-14 21:55:59'),
('1935', 'ST10100320250514075708', '1446-11-16', '1.100.10', '101', 'an.M. ABDIL ARIKIN', '5000', '0', 'Chuwez', '2025-05-14 21:57:08'),
('1936', 'ST10100320250514075708', '1446-11-16', '2.220.10', '101', 'an.M. ABDIL ARIKIN', '0', '5000', 'Chuwez', '2025-05-14 21:57:08'),
('1937', 'ST10100320250514075731', '1446-11-16', '1.100.10', '101', 'an.RAISA ANNISA', '5000', '0', 'Chuwez', '2025-05-14 21:57:31'),
('1938', 'ST10100320250514075731', '1446-11-16', '2.220.10', '101', 'an.RAISA ANNISA', '0', '5000', 'Chuwez', '2025-05-14 21:57:31'),
('1939', 'ST10100320250514075803', '1446-11-16', '1.100.10', '101', 'an.UBAIDAH', '20000', '0', 'Chuwez', '2025-05-14 21:58:03'),
('1940', 'ST10100320250514075803', '1446-11-16', '2.220.10', '101', 'an.UBAIDAH', '0', '20000', 'Chuwez', '2025-05-14 21:58:03'),
('1941', 'ST10100320250514075827', '1446-11-16', '1.100.10', '101', 'an.ABDULLOH BAHAR', '2000', '0', 'Chuwez', '2025-05-14 21:58:27'),
('1942', 'ST10100320250514075827', '1446-11-16', '2.220.10', '101', 'an.ABDULLOH BAHAR', '0', '2000', 'Chuwez', '2025-05-14 21:58:27'),
('1943', 'ST10100320250514075848', '1446-11-16', '1.100.10', '101', 'an.FAIZAH NURUL LITA', '5000', '0', 'Chuwez', '2025-05-14 21:58:48'),
('1944', 'ST10100320250514075848', '1446-11-16', '2.220.10', '101', 'an.FAIZAH NURUL LITA', '0', '5000', 'Chuwez', '2025-05-14 21:58:48'),
('1945', 'ST10100320250514075905', '1446-11-16', '1.100.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '4000', '0', 'Chuwez', '2025-05-14 21:59:05'),
('1946', 'ST10100320250514075905', '1446-11-16', '2.220.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '0', '4000', 'Chuwez', '2025-05-14 21:59:05'),
('1947', 'ST10100320250514075920', '1446-11-16', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'Chuwez', '2025-05-14 21:59:20'),
('1948', 'ST10100320250514075920', '1446-11-16', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'Chuwez', '2025-05-14 21:59:20'),
('1949', 'ST10100320250514075932', '1446-11-16', '1.100.10', '101', 'an.UMAR FARUQ', '10000', '0', 'Chuwez', '2025-05-14 21:59:32'),
('1950', 'ST10100320250514075932', '1446-11-16', '2.220.10', '101', 'an.UMAR FARUQ', '0', '10000', 'Chuwez', '2025-05-14 21:59:32'),
('1951', 'ST10100320250514075955', '1446-11-16', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '5000', '0', 'Chuwez', '2025-05-14 21:59:55'),
('1952', 'ST10100320250514075955', '1446-11-16', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '5000', 'Chuwez', '2025-05-14 21:59:55'),
('1953', 'ST10100320250514080011', '1446-11-16', '1.100.10', '101', 'an.MUHAMMAD ALWI', '5000', '0', 'Chuwez', '2025-05-14 22:00:11'),
('1954', 'ST10100320250514080011', '1446-11-16', '2.220.10', '101', 'an.MUHAMMAD ALWI', '0', '5000', 'Chuwez', '2025-05-14 22:00:11'),
('1955', 'ST10100320250514080027', '1446-11-16', '1.100.10', '101', 'an.NAILATUN NIAMI', '2000', '0', 'Chuwez', '2025-05-14 22:00:27'),
('1956', 'ST10100320250514080027', '1446-11-16', '2.220.10', '101', 'an.NAILATUN NIAMI', '0', '2000', 'Chuwez', '2025-05-14 22:00:27'),
('1957', 'ST10100320250514080041', '1446-11-16', '1.100.10', '101', 'an.MARIYATUL QIBTIYAH', '5000', '0', 'Chuwez', '2025-05-14 22:00:41'),
('1958', 'ST10100320250514080041', '1446-11-16', '2.220.10', '101', 'an.MARIYATUL QIBTIYAH', '0', '5000', 'Chuwez', '2025-05-14 22:00:41'),
('1959', 'ST10100320250514080118', '1446-11-16', '1.100.10', '101', 'an.AHMAD ADITIYA', '3000', '0', 'Chuwez', '2025-05-14 22:01:18'),
('1960', 'ST10100320250514080118', '1446-11-16', '2.220.10', '101', 'an.AHMAD ADITIYA', '0', '3000', 'Chuwez', '2025-05-14 22:01:18'),
('1961', 'ST10100320250514080132', '1446-11-16', '1.100.10', '101', 'an.AZKA AUFARIL MINAN', '10000', '0', 'Chuwez', '2025-05-14 22:01:32'),
('1962', 'ST10100320250514080132', '1446-11-16', '2.220.10', '101', 'an.AZKA AUFARIL MINAN', '0', '10000', 'Chuwez', '2025-05-14 22:01:32'),
('1963', 'ST10100320250514080147', '1446-11-16', '1.100.10', '101', 'an.AISYAH', '2000', '0', 'Chuwez', '2025-05-14 22:01:47'),
('1964', 'ST10100320250514080147', '1446-11-16', '2.220.10', '101', 'an.AISYAH', '0', '2000', 'Chuwez', '2025-05-14 22:01:47'),
('1965', 'ST10100320250514080159', '1446-11-16', '1.100.10', '101', 'an.ALFI NURDIANA', '5000', '0', 'Chuwez', '2025-05-14 22:01:59'),
('1966', 'ST10100320250514080159', '1446-11-16', '2.220.10', '101', 'an.ALFI NURDIANA', '0', '5000', 'Chuwez', '2025-05-14 22:01:59'),
('1967', 'ST10100320250514080218', '1446-11-16', '1.100.10', '101', 'an.IFTITAHUL IZZA', '100000', '0', 'Chuwez', '2025-05-14 22:02:18'),
('1968', 'ST10100320250514080218', '1446-11-16', '2.220.10', '101', 'an.IFTITAHUL IZZA', '0', '100000', 'Chuwez', '2025-05-14 22:02:19'),
('1969', 'ST10100320250514080236', '1446-11-16', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '10000', '0', 'Chuwez', '2025-05-14 22:02:36'),
('1970', 'ST10100320250514080236', '1446-11-16', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '10000', 'Chuwez', '2025-05-14 22:02:36'),
('1971', 'ST10100320250514080300', '1446-11-16', '1.100.10', '101', 'an.M. DESTRA MAULANA', '30000', '0', 'Chuwez', '2025-05-14 22:03:00'),
('1972', 'ST10100320250514080300', '1446-11-16', '2.220.10', '101', 'an.M. DESTRA MAULANA', '0', '30000', 'Chuwez', '2025-05-14 22:03:00'),
('1973', 'ST10100320250514080337', '1446-11-16', '1.100.10', '101', 'an.SITI QURROTUL AINI', '3000', '0', 'Chuwez', '2025-05-14 22:03:37'),
('1974', 'ST10100320250514080337', '1446-11-16', '2.220.10', '101', 'an.SITI QURROTUL AINI', '0', '3000', 'Chuwez', '2025-05-14 22:03:37'),
('1975', 'ST10100320250514080351', '1446-11-16', '1.100.10', '101', 'an.KHOIRIYAH', '15000', '0', 'Chuwez', '2025-05-14 22:03:51'),
('1976', 'ST10100320250514080351', '1446-11-16', '2.220.10', '101', 'an.KHOIRIYAH', '0', '15000', 'Chuwez', '2025-05-14 22:03:51'),
('1977', 'ST10100320250514080406', '1446-11-16', '1.100.10', '101', 'an.SITI ATHIUR ROHMAH', '5000', '0', 'Chuwez', '2025-05-14 22:04:06'),
('1978', 'ST10100320250514080406', '1446-11-16', '2.220.10', '101', 'an.SITI ATHIUR ROHMAH', '0', '5000', 'Chuwez', '2025-05-14 22:04:06'),
('1979', 'ST10100320250514080421', '1446-11-16', '1.100.10', '101', 'an.DIYANAH KAMALIYAH', '3000', '0', 'Chuwez', '2025-05-14 22:04:21'),
('1980', 'ST10100320250514080421', '1446-11-16', '2.220.10', '101', 'an.DIYANAH KAMALIYAH', '0', '3000', 'Chuwez', '2025-05-14 22:04:21'),
('1981', 'ST10100320250514080434', '1446-11-16', '1.100.10', '101', 'an.M. FAHMI NURUL ANAM', '20000', '0', 'Chuwez', '2025-05-14 22:04:34'),
('1982', 'ST10100320250514080434', '1446-11-16', '2.220.10', '101', 'an.M. FAHMI NURUL ANAM', '0', '20000', 'Chuwez', '2025-05-14 22:04:34'),
('1983', 'ST10100320250514080450', '1446-11-16', '1.100.10', '101', 'an.AHMAD RAFI SALIM', '2000', '0', 'Chuwez', '2025-05-14 22:04:50'),
('1984', 'ST10100320250514080450', '1446-11-16', '2.220.10', '101', 'an.AHMAD RAFI SALIM', '0', '2000', 'Chuwez', '2025-05-14 22:04:50'),
('1985', 'ST10100320250514080503', '1446-11-16', '1.100.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '10000', '0', 'Chuwez', '2025-05-14 22:05:03'),
('1986', 'ST10100320250514080503', '1446-11-16', '2.220.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '0', '10000', 'Chuwez', '2025-05-14 22:05:03'),
('1987', 'ST10100320250514080526', '1446-11-16', '1.100.10', '101', 'an.HIKMIAH PUTRI NIKMATUNNAFILAH', '5000', '0', 'Chuwez', '2025-05-14 22:05:26'),
('1988', 'ST10100320250514080526', '1446-11-16', '2.220.10', '101', 'an.HIKMIAH PUTRI NIKMATUNNAFILAH', '0', '5000', 'Chuwez', '2025-05-14 22:05:26'),
('1989', 'ST10100320250514080539', '1446-11-16', '1.100.10', '101', 'an.WARDATUL JANNAH', '3000', '0', 'Chuwez', '2025-05-14 22:05:39'),
('1990', 'ST10100320250514080539', '1446-11-16', '2.220.10', '101', 'an.WARDATUL JANNAH', '0', '3000', 'Chuwez', '2025-05-14 22:05:39'),
('1991', 'ST10100320250514080557', '1446-11-16', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '3000', '0', 'Chuwez', '2025-05-14 22:05:57'),
('1992', 'ST10100320250514080557', '1446-11-16', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '3000', 'Chuwez', '2025-05-14 22:05:57'),
('1993', 'ST10100320250514080623', '1446-11-16', '1.100.10', '101', 'an.M. KAMALUDDIN', '20000', '0', 'Chuwez', '2025-05-14 22:06:23'),
('1994', 'ST10100320250514080623', '1446-11-16', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '20000', 'Chuwez', '2025-05-14 22:06:23'),
('1995', 'ST10100320250514080649', '1446-11-16', '1.100.10', '101', 'an.NABILATUN NISAUL UMMAH', '20000', '0', 'Chuwez', '2025-05-14 22:06:49'),
('1996', 'ST10100320250514080649', '1446-11-16', '2.220.10', '101', 'an.NABILATUN NISAUL UMMAH', '0', '20000', 'Chuwez', '2025-05-14 22:06:49'),
('1997', 'ST10100320250514080703', '1446-11-16', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Chuwez', '2025-05-14 22:07:03'),
('1998', 'ST10100320250514080703', '1446-11-16', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Chuwez', '2025-05-14 22:07:03'),
('1999', 'ST10100320250514080716', '1446-11-16', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '5000', '0', 'Chuwez', '2025-05-14 22:07:16'),
('2000', 'ST10100320250514080716', '1446-11-16', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '5000', 'Chuwez', '2025-05-14 22:07:16'),
('2001', 'ST10100320250514080731', '1446-11-16', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '20000', '0', 'Chuwez', '2025-05-14 22:07:31'),
('2002', 'ST10100320250514080731', '1446-11-16', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '20000', 'Chuwez', '2025-05-14 22:07:31'),
('2003', 'ST10100320250514080744', '1446-11-16', '1.100.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '10000', '0', 'Chuwez', '2025-05-14 22:07:44'),
('2004', 'ST10100320250514080744', '1446-11-16', '2.220.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '0', '10000', 'Chuwez', '2025-05-14 22:07:44'),
('2005', 'ST10100320250514080757', '1446-11-16', '1.100.10', '101', 'an.RENI FARIDA', '2000', '0', 'Chuwez', '2025-05-14 22:07:57'),
('2006', 'ST10100320250514080757', '1446-11-16', '2.220.10', '101', 'an.RENI FARIDA', '0', '2000', 'Chuwez', '2025-05-14 22:07:57'),
('2007', 'ST10100320250514080809', '1446-11-16', '1.100.10', '101', 'an.MIFTAHUL JANNAH', '50000', '0', 'Chuwez', '2025-05-14 22:08:09'),
('2008', 'ST10100320250514080809', '1446-11-16', '2.220.10', '101', 'an.MIFTAHUL JANNAH', '0', '50000', 'Chuwez', '2025-05-14 22:08:09'),
('2009', 'ST10100320250514080819', '1446-11-16', '1.100.10', '101', 'an.RAUDHOTUL JANNAH', '20000', '0', 'Chuwez', '2025-05-14 22:08:19'),
('2010', 'ST10100320250514080819', '1446-11-16', '2.220.10', '101', 'an.RAUDHOTUL JANNAH', '0', '20000', 'Chuwez', '2025-05-14 22:08:19'),
('2011', 'ST10100320250514080832', '1446-11-16', '1.100.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '10000', '0', 'Chuwez', '2025-05-14 22:08:32'),
('2012', 'ST10100320250514080832', '1446-11-16', '2.220.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '0', '10000', 'Chuwez', '2025-05-14 22:08:32'),
('2013', 'ST10100320250514080857', '1446-11-16', '1.100.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '10000', '0', 'Chuwez', '2025-05-14 22:08:57'),
('2014', 'ST10100320250514080857', '1446-11-16', '2.220.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '0', '10000', 'Chuwez', '2025-05-14 22:08:57'),
('2015', 'ST10100320250514080910', '1446-11-16', '1.100.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '5000', '0', 'Chuwez', '2025-05-14 22:09:10'),
('2016', 'ST10100320250514080910', '1446-11-16', '2.220.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '0', '5000', 'Chuwez', '2025-05-14 22:09:10'),
('2017', 'ST10100320250514080931', '1446-11-16', '1.100.10', '101', 'an.BILQIS THALIA HASNA', '60000', '0', 'Chuwez', '2025-05-14 22:09:31'),
('2018', 'ST10100320250514080931', '1446-11-16', '2.220.10', '101', 'an.BILQIS THALIA HASNA', '0', '60000', 'Chuwez', '2025-05-14 22:09:31'),
('2019', 'ST10100320250514080942', '1446-11-16', '1.100.10', '101', 'an.SINDI RAISA PUTRI', '10000', '0', 'Chuwez', '2025-05-14 22:09:42'),
('2020', 'ST10100320250514080942', '1446-11-16', '2.220.10', '101', 'an.SINDI RAISA PUTRI', '0', '10000', 'Chuwez', '2025-05-14 22:09:42'),
('2021', 'ST10100320250514080959', '1446-11-16', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '25000', '0', 'Chuwez', '2025-05-14 22:09:59'),
('2022', 'ST10100320250514080959', '1446-11-16', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '25000', 'Chuwez', '2025-05-14 22:09:59'),
('2023', 'ST10100320250514081024', '1446-11-16', '1.100.10', '101', 'an.AHMAD ABBAS MAULANA', '4000', '0', 'Chuwez', '2025-05-14 22:10:24'),
('2024', 'ST10100320250514081024', '1446-11-16', '2.220.10', '101', 'an.AHMAD ABBAS MAULANA', '0', '4000', 'Chuwez', '2025-05-14 22:10:24'),
('2025', 'ST10100320250514081042', '1446-11-16', '1.100.10', '101', 'an.M. ROFIQ', '25000', '0', 'Chuwez', '2025-05-14 22:10:42'),
('2026', 'ST10100320250514081042', '1446-11-16', '2.220.10', '101', 'an.M. ROFIQ', '0', '25000', 'Chuwez', '2025-05-14 22:10:42'),
('2027', 'ST10100320250514081054', '1446-11-16', '1.100.10', '101', 'an.AHMAD JAMALUL MAIMUN', '5000', '0', 'Chuwez', '2025-05-14 22:10:54'),
('2028', 'ST10100320250514081054', '1446-11-16', '2.220.10', '101', 'an.AHMAD JAMALUL MAIMUN', '0', '5000', 'Chuwez', '2025-05-14 22:10:54'),
('2029', 'ST10100320250514081107', '1446-11-16', '1.100.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '4000', '0', 'Chuwez', '2025-05-14 22:11:07'),
('2030', 'ST10100320250514081107', '1446-11-16', '2.220.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '0', '4000', 'Chuwez', '2025-05-14 22:11:07'),
('2031', 'ST10100320250514081121', '1446-11-16', '1.100.10', '101', 'an.AKHMAD FIKRI HAIKAL', '50000', '0', 'Chuwez', '2025-05-14 22:11:21'),
('2032', 'ST10100320250514081121', '1446-11-16', '2.220.10', '101', 'an.AKHMAD FIKRI HAIKAL', '0', '50000', 'Chuwez', '2025-05-14 22:11:21'),
('2033', 'ST10100320250514081155', '1446-11-16', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '2000', '0', 'Chuwez', '2025-05-14 22:11:55'),
('2034', 'ST10100320250514081155', '1446-11-16', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '2000', 'Chuwez', '2025-05-14 22:11:55'),
('2035', 'ST10100320250514081210', '1446-11-16', '1.100.10', '101', 'an.ZAKIYATUL UMMAH', '2000', '0', 'Chuwez', '2025-05-14 22:12:10'),
('2036', 'ST10100320250514081210', '1446-11-16', '2.220.10', '101', 'an.ZAKIYATUL UMMAH', '0', '2000', 'Chuwez', '2025-05-14 22:12:10'),
('2037', 'ST10100320250514081231', '1446-11-16', '1.100.10', '101', 'an.ROBIATUL ADAWIYAH', '2000', '0', 'Chuwez', '2025-05-14 22:12:31'),
('2038', 'ST10100320250514081231', '1446-11-16', '2.220.10', '101', 'an.ROBIATUL ADAWIYAH', '0', '2000', 'Chuwez', '2025-05-14 22:12:31'),
('2039', 'ST10100320250514081247', '1446-11-16', '1.100.10', '101', 'an.ANA SALSABILA', '2000', '0', 'Chuwez', '2025-05-14 22:12:47'),
('2040', 'ST10100320250514081247', '1446-11-16', '2.220.10', '101', 'an.ANA SALSABILA', '0', '2000', 'Chuwez', '2025-05-14 22:12:47'),
('2041', 'ST10100320250514081304', '1446-11-16', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '5000', '0', 'Chuwez', '2025-05-14 22:13:04'),
('2042', 'ST10100320250514081304', '1446-11-16', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '5000', 'Chuwez', '2025-05-14 22:13:04'),
('2043', 'ST10100320250514081320', '1446-11-16', '1.100.10', '101', 'an.M. ALIFIN FIKRI', '2000', '0', 'Chuwez', '2025-05-14 22:13:20'),
('2044', 'ST10100320250514081320', '1446-11-16', '2.220.10', '101', 'an.M. ALIFIN FIKRI', '0', '2000', 'Chuwez', '2025-05-14 22:13:20'),
('2045', 'ST10100320250514081334', '1446-11-16', '1.100.10', '101', 'an.AFANDI', '2000', '0', 'Chuwez', '2025-05-14 22:13:34'),
('2046', 'ST10100320250514081334', '1446-11-16', '2.220.10', '101', 'an.AFANDI', '0', '2000', 'Chuwez', '2025-05-14 22:13:34'),
('2047', 'ST10100320250514081348', '1446-11-16', '1.100.10', '101', 'an.MUHAMMAD YAHYA SYAKARUDDIN', '25000', '0', 'Chuwez', '2025-05-14 22:13:48'),
('2048', 'ST10100320250514081348', '1446-11-16', '2.220.10', '101', 'an.MUHAMMAD YAHYA SYAKARUDDIN', '0', '25000', 'Chuwez', '2025-05-14 22:13:48'),
('2049', 'ST10100320250514081402', '1446-11-16', '1.100.10', '101', 'an.MUHAMMAD KHOIRON', '5000', '0', 'Chuwez', '2025-05-14 22:14:02'),
('2050', 'ST10100320250514081402', '1446-11-16', '2.220.10', '101', 'an.MUHAMMAD KHOIRON', '0', '5000', 'Chuwez', '2025-05-14 22:14:02'),
('2051', 'ST10100320250514081416', '1446-11-16', '1.100.10', '101', 'an.MUHAMMAD HAMDANI', '10000', '0', 'Chuwez', '2025-05-14 22:14:16'),
('2052', 'ST10100320250514081416', '1446-11-16', '2.220.10', '101', 'an.MUHAMMAD HAMDANI', '0', '10000', 'Chuwez', '2025-05-14 22:14:16'),
('2053', 'ST10100320250514081441', '1446-11-16', '1.100.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '2000', '0', 'Chuwez', '2025-05-14 22:14:41'),
('2054', 'ST10100320250514081441', '1446-11-16', '2.220.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '0', '2000', 'Chuwez', '2025-05-14 22:14:41'),
('2055', 'ST10100320250514081500', '1446-11-16', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '10000', '0', 'Chuwez', '2025-05-14 22:15:00'),
('2056', 'ST10100320250514081500', '1446-11-16', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '10000', 'Chuwez', '2025-05-14 22:15:00'),
('2057', 'ST10100320250514081518', '1446-11-16', '1.100.10', '101', 'an.M. ZIDAN RIZQI SALIM', '5000', '0', 'Chuwez', '2025-05-14 22:15:18'),
('2058', 'ST10100320250514081518', '1446-11-16', '2.220.10', '101', 'an.M. ZIDAN RIZQI SALIM', '0', '5000', 'Chuwez', '2025-05-14 22:15:18'),
('2059', 'ST10100320250514081534', '1446-11-16', '1.100.10', '101', 'an.ACH. JUNAIDI', '5000', '0', 'Chuwez', '2025-05-14 22:15:34'),
('2060', 'ST10100320250514081534', '1446-11-16', '2.220.10', '101', 'an.ACH. JUNAIDI', '0', '5000', 'Chuwez', '2025-05-14 22:15:35'),
('2061', 'ST10100320250514081601', '1446-11-16', '1.100.10', '101', 'an.AMARA', '10000', '0', 'Chuwez', '2025-05-14 22:16:01'),
('2062', 'ST10100320250514081601', '1446-11-16', '2.220.10', '101', 'an.AMARA', '0', '10000', 'Chuwez', '2025-05-14 22:16:01'),
('2063', 'ST10100320250514081624', '1446-11-16', '1.100.10', '101', 'an.HALIMAH', '5000', '0', 'Chuwez', '2025-05-14 22:16:24'),
('2064', 'ST10100320250514081624', '1446-11-16', '2.220.10', '101', 'an.HALIMAH', '0', '5000', 'Chuwez', '2025-05-14 22:16:24'),
('2065', 'ST10100320250514081648', '1446-11-16', '1.100.10', '101', 'an.HILYA', '20000', '0', 'Chuwez', '2025-05-14 22:16:48'),
('2066', 'ST10100320250514081648', '1446-11-16', '2.220.10', '101', 'an.HILYA', '0', '20000', 'Chuwez', '2025-05-14 22:16:48'),
('2067', 'ST10100320250514081710', '1446-11-16', '1.100.10', '101', 'an.MACHMUDAH', '10000', '0', 'Chuwez', '2025-05-14 22:17:10'),
('2068', 'ST10100320250514081710', '1446-11-16', '2.220.10', '101', 'an.MACHMUDAH', '0', '10000', 'Chuwez', '2025-05-14 22:17:10'),
('2069', 'ST10100320250514081735', '1446-11-16', '1.100.10', '101', 'an.HAMIDAH', '20000', '0', 'Chuwez', '2025-05-14 22:17:35'),
('2070', 'ST10100320250514081735', '1446-11-16', '2.220.10', '101', 'an.HAMIDAH', '0', '20000', 'Chuwez', '2025-05-14 22:17:35'),
('2071', 'ST10100320250514081757', '1446-11-16', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'Chuwez', '2025-05-14 22:17:57'),
('2072', 'ST10100320250514081757', '1446-11-16', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'Chuwez', '2025-05-14 22:17:57'),
('2073', 'KK10100320250514151837', '1446-11-16', '5.520.42', '101', 'Gorengan', '10000', '0', 'Chuwez', '2025-05-14 15:19:10'),
('2074', 'KK10100320250514151837', '1446-11-16', '1.100.10', '101', 'Gorengan', '0', '10000', 'Chuwez', '2025-05-14 15:19:10'),
('2075', 'ST10100320250514091653', '1446-11-16', '1.100.10', '101', 'an.DIANA RIFQOTUL QOLBI', '5000', '0', 'Chuwez', '2025-05-14 23:16:53'),
('2076', 'ST10100320250514091653', '1446-11-16', '2.220.10', '101', 'an.DIANA RIFQOTUL QOLBI', '0', '5000', 'Chuwez', '2025-05-14 23:16:53'),
('2077', 'ST10100320250514091739', '1446-11-16', '1.100.10', '101', 'an.NAYLA FITRI AULIA', '20000', '0', 'Chuwez', '2025-05-14 23:17:39'),
('2078', 'ST10100320250514091739', '1446-11-16', '2.220.10', '101', 'an.NAYLA FITRI AULIA', '0', '20000', 'Chuwez', '2025-05-14 23:17:39'),
('2079', 'ST10100320250514091833', '1446-11-16', '1.100.10', '101', 'an.SAFIRATUL JANNAH', '10000', '0', 'Chuwez', '2025-05-14 23:18:33'),
('2080', 'ST10100320250514091833', '1446-11-16', '2.220.10', '101', 'an.SAFIRATUL JANNAH', '0', '10000', 'Chuwez', '2025-05-14 23:18:33'),
('2083', 'ST10100320250501083934', '1446-11-03', '1.100.10', '101', 'an.SAFIRATUL JANNAH', '10000', '0', 'mumuz', '2025-05-14 23:35:08'),
('2084', 'ST10100320250501083934', '1446-11-03', '2.220.10', '101', 'an.SAFIRATUL JANNAH', '0', '10000', 'mumuz', '2025-05-14 23:35:08'),
('2085', 'ST10100320250515082449', '1446-11-17', '1.100.10', '101', 'an.DIYANAH KAMALIYAH', '2000', '0', 'Chuwez', '2025-05-15 22:24:49'),
('2086', 'ST10100320250515082449', '1446-11-17', '2.220.10', '101', 'an.DIYANAH KAMALIYAH', '0', '2000', 'Chuwez', '2025-05-15 22:24:49'),
('2087', 'ST10100320250515082510', '1446-11-17', '1.100.10', '101', 'an.WARDATUL JANNAH', '3000', '0', 'Chuwez', '2025-05-15 22:25:10'),
('2088', 'ST10100320250515082510', '1446-11-17', '2.220.10', '101', 'an.WARDATUL JANNAH', '0', '3000', 'Chuwez', '2025-05-15 22:25:10'),
('2089', 'ST10100320250515082528', '1446-11-17', '1.100.10', '101', 'an.M. FAHMI NURUL ANAM', '10000', '0', 'Chuwez', '2025-05-15 22:25:28'),
('2090', 'ST10100320250515082528', '1446-11-17', '2.220.10', '101', 'an.M. FAHMI NURUL ANAM', '0', '10000', 'Chuwez', '2025-05-15 22:25:28'),
('2091', 'ST10100320250515082542', '1446-11-17', '1.100.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '10000', '0', 'Chuwez', '2025-05-15 22:25:42'),
('2092', 'ST10100320250515082542', '1446-11-17', '2.220.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '0', '10000', 'Chuwez', '2025-05-15 22:25:42'),
('2093', 'ST10100320250515082557', '1446-11-17', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '20000', '0', 'Chuwez', '2025-05-15 22:25:57'),
('2094', 'ST10100320250515082557', '1446-11-17', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '20000', 'Chuwez', '2025-05-15 22:25:57'),
('2095', 'ST10100320250515082638', '1446-11-17', '1.100.10', '101', 'an.KHOIRIYAH', '10000', '0', 'Chuwez', '2025-05-15 22:26:38'),
('2096', 'ST10100320250515082638', '1446-11-17', '2.220.10', '101', 'an.KHOIRIYAH', '0', '10000', 'Chuwez', '2025-05-15 22:26:38'),
('2097', 'ST10100320250515082659', '1446-11-17', '1.100.10', '101', 'an.SITI QURROTUL AINI', '2000', '0', 'Chuwez', '2025-05-15 22:26:59'),
('2098', 'ST10100320250515082659', '1446-11-17', '2.220.10', '101', 'an.SITI QURROTUL AINI', '0', '2000', 'Chuwez', '2025-05-15 22:26:59'),
('2099', 'ST10100320250515082729', '1446-11-17', '1.100.10', '101', 'an.SITI ATHIUR ROHMAH', '5000', '0', 'Chuwez', '2025-05-15 22:27:29'),
('2100', 'ST10100320250515082729', '1446-11-17', '2.220.10', '101', 'an.SITI ATHIUR ROHMAH', '0', '5000', 'Chuwez', '2025-05-15 22:27:29'),
('2101', 'ST10100320250515082746', '1446-11-17', '1.100.10', '101', 'an.ABDUL HAMID', '5000', '0', 'Chuwez', '2025-05-15 22:27:46'),
('2102', 'ST10100320250515082746', '1446-11-17', '2.220.10', '101', 'an.ABDUL HAMID', '0', '5000', 'Chuwez', '2025-05-15 22:27:46'),
('2103', 'ST10100320250515082810', '1446-11-17', '1.100.10', '101', 'an.BILQIS THALIA HASNA', '110000', '0', 'Chuwez', '2025-05-15 22:28:10'),
('2104', 'ST10100320250515082810', '1446-11-17', '2.220.10', '101', 'an.BILQIS THALIA HASNA', '0', '110000', 'Chuwez', '2025-05-15 22:28:10'),
('2105', 'ST10100320250515082827', '1446-11-17', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '25000', '0', 'Chuwez', '2025-05-15 22:28:27'),
('2106', 'ST10100320250515082827', '1446-11-17', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '25000', 'Chuwez', '2025-05-15 22:28:27'),
('2107', 'ST10100320250515082842', '1446-11-17', '1.100.10', '101', 'an.SINDI RAISA PUTRI', '10000', '0', 'Chuwez', '2025-05-15 22:28:42'),
('2108', 'ST10100320250515082842', '1446-11-17', '2.220.10', '101', 'an.SINDI RAISA PUTRI', '0', '10000', 'Chuwez', '2025-05-15 22:28:42'),
('2109', 'ST10100320250515082910', '1446-11-17', '1.100.10', '101', 'an.AKHMAD FIKRI HAIKAL', '50000', '0', 'Chuwez', '2025-05-15 22:29:10'),
('2110', 'ST10100320250515082910', '1446-11-17', '2.220.10', '101', 'an.AKHMAD FIKRI HAIKAL', '0', '50000', 'Chuwez', '2025-05-15 22:29:10'),
('2111', 'ST10100320250515082927', '1446-11-17', '1.100.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '6000', '0', 'Chuwez', '2025-05-15 22:29:27'),
('2112', 'ST10100320250515082927', '1446-11-17', '2.220.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '0', '6000', 'Chuwez', '2025-05-15 22:29:27'),
('2113', 'ST10100320250515082941', '1446-11-17', '1.100.10', '101', 'an.AHMAD JAMALUL MAIMUN', '5000', '0', 'Chuwez', '2025-05-15 22:29:41'),
('2114', 'ST10100320250515082941', '1446-11-17', '2.220.10', '101', 'an.AHMAD JAMALUL MAIMUN', '0', '5000', 'Chuwez', '2025-05-15 22:29:42'),
('2115', 'ST10100320250515083002', '1446-11-17', '1.100.10', '101', 'an.AHMAD ABBAS MAULANA', '3000', '0', 'Chuwez', '2025-05-15 22:30:02'),
('2116', 'ST10100320250515083002', '1446-11-17', '2.220.10', '101', 'an.AHMAD ABBAS MAULANA', '0', '3000', 'Chuwez', '2025-05-15 22:30:02'),
('2117', 'ST10100320250515083028', '1446-11-17', '1.100.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '5000', '0', 'Chuwez', '2025-05-15 22:30:28'),
('2118', 'ST10100320250515083028', '1446-11-17', '2.220.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '0', '5000', 'Chuwez', '2025-05-15 22:30:28'),
('2119', 'ST10100320250515083043', '1446-11-17', '1.100.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '10000', '0', 'Chuwez', '2025-05-15 22:30:43'),
('2120', 'ST10100320250515083043', '1446-11-17', '2.220.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '0', '10000', 'Chuwez', '2025-05-15 22:30:43'),
('2121', 'ST10100320250515083105', '1446-11-17', '1.100.10', '101', 'an.HAIKAL SHOMADANI', '2000', '0', 'Chuwez', '2025-05-15 22:31:05'),
('2122', 'ST10100320250515083105', '1446-11-17', '2.220.10', '101', 'an.HAIKAL SHOMADANI', '0', '2000', 'Chuwez', '2025-05-15 22:31:05'),
('2123', 'ST10100320250515083120', '1446-11-17', '1.100.10', '101', 'an.NAURA BILADINA', '6000', '0', 'Chuwez', '2025-05-15 22:31:20'),
('2124', 'ST10100320250515083120', '1446-11-17', '2.220.10', '101', 'an.NAURA BILADINA', '0', '6000', 'Chuwez', '2025-05-15 22:31:20'),
('2125', 'ST10100320250515083136', '1446-11-17', '1.100.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '5000', '0', 'Chuwez', '2025-05-15 22:31:36'),
('2126', 'ST10100320250515083136', '1446-11-17', '2.220.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '0', '5000', 'Chuwez', '2025-05-15 22:31:36'),
('2127', 'ST10100320250515083151', '1446-11-17', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '5000', '0', 'Chuwez', '2025-05-15 22:31:51'),
('2128', 'ST10100320250515083151', '1446-11-17', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '5000', 'Chuwez', '2025-05-15 22:31:51'),
('2129', 'ST10100320250515083204', '1446-11-17', '1.100.10', '101', 'an.M. ABD. HADI', '2000', '0', 'Chuwez', '2025-05-15 22:32:04'),
('2130', 'ST10100320250515083204', '1446-11-17', '2.220.10', '101', 'an.M. ABD. HADI', '0', '2000', 'Chuwez', '2025-05-15 22:32:04'),
('2131', 'ST10100320250515083220', '1446-11-17', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'Chuwez', '2025-05-15 22:32:20'),
('2132', 'ST10100320250515083220', '1446-11-17', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'Chuwez', '2025-05-15 22:32:20'),
('2133', 'ST10100320250515083233', '1446-11-17', '1.100.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '10000', '0', 'Chuwez', '2025-05-15 22:32:33'),
('2134', 'ST10100320250515083233', '1446-11-17', '2.220.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '0', '10000', 'Chuwez', '2025-05-15 22:32:34'),
('2135', 'ST10100320250515083256', '1446-11-17', '1.100.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '5000', '0', 'Chuwez', '2025-05-15 22:32:56'),
('2136', 'ST10100320250515083256', '1446-11-17', '2.220.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '0', '5000', 'Chuwez', '2025-05-15 22:32:56'),
('2137', 'ST10100320250515083311', '1446-11-17', '1.100.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '2000', '0', 'Chuwez', '2025-05-15 22:33:11'),
('2138', 'ST10100320250515083311', '1446-11-17', '2.220.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '0', '2000', 'Chuwez', '2025-05-15 22:33:11'),
('2139', 'ST10100320250515083327', '1446-11-17', '1.100.10', '101', 'an.ELOK WARDATUN NAFISAH', '10000', '0', 'Chuwez', '2025-05-15 22:33:27'),
('2140', 'ST10100320250515083327', '1446-11-17', '2.220.10', '101', 'an.ELOK WARDATUN NAFISAH', '0', '10000', 'Chuwez', '2025-05-15 22:33:27'),
('2141', 'ST10100320250515083353', '1446-11-17', '1.100.10', '101', 'an.AHMAD ADITIYA', '7000', '0', 'Chuwez', '2025-05-15 22:33:53'),
('2142', 'ST10100320250515083353', '1446-11-17', '2.220.10', '101', 'an.AHMAD ADITIYA', '0', '7000', 'Chuwez', '2025-05-15 22:33:53'),
('2143', 'ST10100320250515083434', '1446-11-17', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '100000', '0', 'Chuwez', '2025-05-15 22:34:34'),
('2144', 'ST10100320250515083434', '1446-11-17', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '100000', 'Chuwez', '2025-05-15 22:34:34'),
('2145', 'ST10100320250515083458', '1446-11-17', '1.100.10', '101', 'an.M. DESTRA MAULANA', '30000', '0', 'Chuwez', '2025-05-15 22:34:58'),
('2146', 'ST10100320250515083458', '1446-11-17', '2.220.10', '101', 'an.M. DESTRA MAULANA', '0', '30000', 'Chuwez', '2025-05-15 22:34:58'),
('2147', 'ST10100320250515083513', '1446-11-17', '1.100.10', '101', 'an.AZKA AUFARIL MINAN', '10000', '0', 'Chuwez', '2025-05-15 22:35:13'),
('2148', 'ST10100320250515083513', '1446-11-17', '2.220.10', '101', 'an.AZKA AUFARIL MINAN', '0', '10000', 'Chuwez', '2025-05-15 22:35:13'),
('2149', 'ST10100320250515083526', '1446-11-17', '1.100.10', '101', 'an.LAILATUL MAGHFIROH', '10000', '0', 'Chuwez', '2025-05-15 22:35:26'),
('2150', 'ST10100320250515083526', '1446-11-17', '2.220.10', '101', 'an.LAILATUL MAGHFIROH', '0', '10000', 'Chuwez', '2025-05-15 22:35:26'),
('2151', 'ST10100320250515083541', '1446-11-17', '1.100.10', '101', 'an.IFTITAHUL IZZA', '100000', '0', 'Chuwez', '2025-05-15 22:35:41'),
('2152', 'ST10100320250515083541', '1446-11-17', '2.220.10', '101', 'an.IFTITAHUL IZZA', '0', '100000', 'Chuwez', '2025-05-15 22:35:41'),
('2153', 'ST10100320250515083556', '1446-11-17', '1.100.10', '101', 'an.ALFI NURDIANA', '5000', '0', 'Chuwez', '2025-05-15 22:35:56'),
('2154', 'ST10100320250515083556', '1446-11-17', '2.220.10', '101', 'an.ALFI NURDIANA', '0', '5000', 'Chuwez', '2025-05-15 22:35:56'),
('2155', 'ST10100320250515083613', '1446-11-17', '1.100.10', '101', 'an.AISYAH', '5000', '0', 'Chuwez', '2025-05-15 22:36:13'),
('2156', 'ST10100320250515083613', '1446-11-17', '2.220.10', '101', 'an.AISYAH', '0', '5000', 'Chuwez', '2025-05-15 22:36:13'),
('2157', 'ST10100320250515083636', '1446-11-17', '1.100.10', '101', 'an.NAILATUN NIAMI', '3000', '0', 'Chuwez', '2025-05-15 22:36:36'),
('2158', 'ST10100320250515083636', '1446-11-17', '2.220.10', '101', 'an.NAILATUN NIAMI', '0', '3000', 'Chuwez', '2025-05-15 22:36:36'),
('2159', 'ST10100320250515083652', '1446-11-17', '1.100.10', '101', 'an.MARIYATUL QIBTIYAH', '5000', '0', 'Chuwez', '2025-05-15 22:36:52'),
('2160', 'ST10100320250515083652', '1446-11-17', '2.220.10', '101', 'an.MARIYATUL QIBTIYAH', '0', '5000', 'Chuwez', '2025-05-15 22:36:52'),
('2161', 'ST10100320250515083714', '1446-11-17', '1.100.10', '101', 'an.MUHAMMAD ALWI', '5000', '0', 'Chuwez', '2025-05-15 22:37:14'),
('2162', 'ST10100320250515083714', '1446-11-17', '2.220.10', '101', 'an.MUHAMMAD ALWI', '0', '5000', 'Chuwez', '2025-05-15 22:37:14'),
('2163', 'ST10100320250515083727', '1446-11-17', '1.100.10', '101', 'an.RAISA ANNISA', '5000', '0', 'Chuwez', '2025-05-15 22:37:27'),
('2164', 'ST10100320250515083727', '1446-11-17', '2.220.10', '101', 'an.RAISA ANNISA', '0', '5000', 'Chuwez', '2025-05-15 22:37:27'),
('2165', 'ST10100320250515083739', '1446-11-17', '1.100.10', '101', 'an.FAIZAH NURUL LITA', '5000', '0', 'Chuwez', '2025-05-15 22:37:39'),
('2166', 'ST10100320250515083739', '1446-11-17', '2.220.10', '101', 'an.FAIZAH NURUL LITA', '0', '5000', 'Chuwez', '2025-05-15 22:37:39'),
('2167', 'ST10100320250515083750', '1446-11-17', '1.100.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '4000', '0', 'Chuwez', '2025-05-15 22:37:50'),
('2168', 'ST10100320250515083750', '1446-11-17', '2.220.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '0', '4000', 'Chuwez', '2025-05-15 22:37:50'),
('2169', 'ST10100320250515083808', '1446-11-17', '1.100.10', '101', 'an.UMAR FARUQ', '10000', '0', 'Chuwez', '2025-05-15 22:38:08'),
('2170', 'ST10100320250515083808', '1446-11-17', '2.220.10', '101', 'an.UMAR FARUQ', '0', '10000', 'Chuwez', '2025-05-15 22:38:08'),
('2171', 'ST10100320250515083820', '1446-11-17', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'Chuwez', '2025-05-15 22:38:20'),
('2172', 'ST10100320250515083820', '1446-11-17', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'Chuwez', '2025-05-15 22:38:20'),
('2173', 'ST10100320250515083844', '1446-11-17', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '5000', '0', 'Chuwez', '2025-05-15 22:38:44'),
('2174', 'ST10100320250515083844', '1446-11-17', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '5000', 'Chuwez', '2025-05-15 22:38:44'),
('2175', 'ST10100320250515083948', '1446-11-17', '1.100.10', '101', 'an.M. ABDIL ARIKIN', '5000', '0', 'Chuwez', '2025-05-15 22:39:48'),
('2176', 'ST10100320250515083948', '1446-11-17', '2.220.10', '101', 'an.M. ABDIL ARIKIN', '0', '5000', 'Chuwez', '2025-05-15 22:39:49'),
('2177', 'ST10100320250515084009', '1446-11-17', '1.100.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '10000', '0', 'Chuwez', '2025-05-15 22:40:09'),
('2178', 'ST10100320250515084009', '1446-11-17', '2.220.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '0', '10000', 'Chuwez', '2025-05-15 22:40:09'),
('2179', 'ST10100320250515084025', '1446-11-17', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '5000', '0', 'Chuwez', '2025-05-15 22:40:25'),
('2180', 'ST10100320250515084025', '1446-11-17', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '5000', 'Chuwez', '2025-05-15 22:40:25'),
('2181', 'ST10100320250515084039', '1446-11-17', '1.100.10', '101', 'an.M. KAMALUDDIN', '20000', '0', 'Chuwez', '2025-05-15 22:40:39'),
('2182', 'ST10100320250515084039', '1446-11-17', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '20000', 'Chuwez', '2025-05-15 22:40:40'),
('2183', 'ST10100320250515084055', '1446-11-17', '1.100.10', '101', 'an.MUHAMMAD ILHAM', '5000', '0', 'Chuwez', '2025-05-15 22:40:55'),
('2184', 'ST10100320250515084055', '1446-11-17', '2.220.10', '101', 'an.MUHAMMAD ILHAM', '0', '5000', 'Chuwez', '2025-05-15 22:40:55'),
('2185', 'ST10100320250515084111', '1446-11-17', '1.100.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '10000', '0', 'Chuwez', '2025-05-15 22:41:11'),
('2186', 'ST10100320250515084111', '1446-11-17', '2.220.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '0', '10000', 'Chuwez', '2025-05-15 22:41:11'),
('2187', 'ST10100320250515084124', '1446-11-17', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Chuwez', '2025-05-15 22:41:24'),
('2188', 'ST10100320250515084124', '1446-11-17', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Chuwez', '2025-05-15 22:41:24'),
('2189', 'ST10100320250515084137', '1446-11-17', '1.100.10', '101', 'an.NABILATUN NISAUL UMMAH', '20000', '0', 'Chuwez', '2025-05-15 22:41:37'),
('2190', 'ST10100320250515084137', '1446-11-17', '2.220.10', '101', 'an.NABILATUN NISAUL UMMAH', '0', '20000', 'Chuwez', '2025-05-15 22:41:37'),
('2191', 'ST10100320250515084151', '1446-11-17', '1.100.10', '101', 'an.RAUDHOTUL JANNAH', '20000', '0', 'Chuwez', '2025-05-15 22:41:51'),
('2192', 'ST10100320250515084151', '1446-11-17', '2.220.10', '101', 'an.RAUDHOTUL JANNAH', '0', '20000', 'Chuwez', '2025-05-15 22:41:51'),
('2193', 'ST10100320250515084206', '1446-11-17', '1.100.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '10000', '0', 'Chuwez', '2025-05-15 22:42:06'),
('2194', 'ST10100320250515084206', '1446-11-17', '2.220.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '0', '10000', 'Chuwez', '2025-05-15 22:42:06'),
('2195', 'ST10100320250515084226', '1446-11-17', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '2000', '0', 'Chuwez', '2025-05-15 22:42:26'),
('2196', 'ST10100320250515084226', '1446-11-17', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '2000', 'Chuwez', '2025-05-15 22:42:26'),
('2197', 'ST10100320250515084238', '1446-11-17', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '10000', '0', 'Chuwez', '2025-05-15 22:42:38'),
('2198', 'ST10100320250515084238', '1446-11-17', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '10000', 'Chuwez', '2025-05-15 22:42:39'),
('2199', 'ST10100320250515084303', '1446-11-17', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '5000', '0', 'Chuwez', '2025-05-15 22:43:03'),
('2200', 'ST10100320250515084303', '1446-11-17', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '5000', 'Chuwez', '2025-05-15 22:43:03'),
('2201', 'ST10100320250515084316', '1446-11-17', '1.100.10', '101', 'an.ANA SALSABILA', '2000', '0', 'Chuwez', '2025-05-15 22:43:16'),
('2202', 'ST10100320250515084316', '1446-11-17', '2.220.10', '101', 'an.ANA SALSABILA', '0', '2000', 'Chuwez', '2025-05-15 22:43:16'),
('2203', 'ST10100320250515084332', '1446-11-17', '1.100.10', '101', 'an.ZAKIYATUL UMMAH', '2000', '0', 'Chuwez', '2025-05-15 22:43:32'),
('2204', 'ST10100320250515084332', '1446-11-17', '2.220.10', '101', 'an.ZAKIYATUL UMMAH', '0', '2000', 'Chuwez', '2025-05-15 22:43:32'),
('2205', 'ST10100320250515084347', '1446-11-17', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '5000', '0', 'Chuwez', '2025-05-15 22:43:47'),
('2206', 'ST10100320250515084347', '1446-11-17', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '5000', 'Chuwez', '2025-05-15 22:43:47'),
('2207', 'ST10100320250515084403', '1446-11-17', '1.100.10', '101', 'an.MUHAMMAD KHOIRON', '5000', '0', 'Chuwez', '2025-05-15 22:44:03'),
('2208', 'ST10100320250515084403', '1446-11-17', '2.220.10', '101', 'an.MUHAMMAD KHOIRON', '0', '5000', 'Chuwez', '2025-05-15 22:44:03'),
('2209', 'ST10100320250515084418', '1446-11-17', '1.100.10', '101', 'an.AFANDI', '2000', '0', 'Chuwez', '2025-05-15 22:44:18'),
('2210', 'ST10100320250515084418', '1446-11-17', '2.220.10', '101', 'an.AFANDI', '0', '2000', 'Chuwez', '2025-05-15 22:44:18'),
('2211', 'ST10100320250515084430', '1446-11-17', '1.100.10', '101', 'an.M. ALIFIN FIKRI', '2000', '0', 'Chuwez', '2025-05-15 22:44:30'),
('2212', 'ST10100320250515084430', '1446-11-17', '2.220.10', '101', 'an.M. ALIFIN FIKRI', '0', '2000', 'Chuwez', '2025-05-15 22:44:30'),
('2213', 'ST10100320250515084446', '1446-11-17', '1.100.10', '101', 'an.SAFIRATUL JANNAH', '10000', '0', 'Chuwez', '2025-05-15 22:44:46'),
('2214', 'ST10100320250515084446', '1446-11-17', '2.220.10', '101', 'an.SAFIRATUL JANNAH', '0', '10000', 'Chuwez', '2025-05-15 22:44:46'),
('2215', 'ST10100320250515084500', '1446-11-17', '1.100.10', '101', 'an.M. ZIDAN RIZQI SALIM', '5000', '0', 'Chuwez', '2025-05-15 22:45:00'),
('2216', 'ST10100320250515084500', '1446-11-17', '2.220.10', '101', 'an.M. ZIDAN RIZQI SALIM', '0', '5000', 'Chuwez', '2025-05-15 22:45:00'),
('2217', 'ST10100320250515084513', '1446-11-17', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '5000', '0', 'Chuwez', '2025-05-15 22:45:13'),
('2218', 'ST10100320250515084513', '1446-11-17', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '5000', 'Chuwez', '2025-05-15 22:45:13'),
('2219', 'ST10100320250515084525', '1446-11-17', '1.100.10', '101', 'an.ACH. JUNAIDI', '5000', '0', 'Chuwez', '2025-05-15 22:45:25'),
('2220', 'ST10100320250515084525', '1446-11-17', '2.220.10', '101', 'an.ACH. JUNAIDI', '0', '5000', 'Chuwez', '2025-05-15 22:45:25'),
('2221', 'ST10100320250515084544', '1446-11-17', '1.100.10', '101', 'an.AMARA', '10000', '0', 'Chuwez', '2025-05-15 22:45:44'),
('2222', 'ST10100320250515084544', '1446-11-17', '2.220.10', '101', 'an.AMARA', '0', '10000', 'Chuwez', '2025-05-15 22:45:44'),
('2223', 'ST10100320250515084604', '1446-11-17', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'Chuwez', '2025-05-15 22:46:04'),
('2224', 'ST10100320250515084604', '1446-11-17', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'Chuwez', '2025-05-15 22:46:04'),
('2225', 'ST10100320250515084621', '1446-11-17', '1.100.10', '101', 'an.HALIMAH', '5000', '0', 'Chuwez', '2025-05-15 22:46:21'),
('2226', 'ST10100320250515084621', '1446-11-17', '2.220.10', '101', 'an.HALIMAH', '0', '5000', 'Chuwez', '2025-05-15 22:46:21'),
('2227', 'ST10100320250513061918', '1446-11-15', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '5000', '0', 'Chuwez', '2025-05-15 22:47:33'),
('2228', 'ST10100320250513061918', '1446-11-15', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '5000', 'Chuwez', '2025-05-15 22:47:33'),
('2229', 'ST10100320250517061209', '1446-11-19', '1.100.10', '101', 'an.MUHAMMAD KANZUL KAROMI', '10000', '0', 'Chuwez', '2025-05-17 20:12:09'),
('2230', 'ST10100320250517061209', '1446-11-19', '2.220.10', '101', 'an.MUHAMMAD KANZUL KAROMI', '0', '10000', 'Chuwez', '2025-05-17 20:12:09'),
('2231', 'ST10100320250517061232', '1446-11-19', '1.100.10', '101', 'an.ALFIN HIDAYAT', '7000', '0', 'Chuwez', '2025-05-17 20:12:32'),
('2232', 'ST10100320250517061232', '1446-11-19', '2.220.10', '101', 'an.ALFIN HIDAYAT', '0', '7000', 'Chuwez', '2025-05-17 20:12:32'),
('2233', 'ST10100320250517061257', '1446-11-19', '1.100.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '2000', '0', 'Chuwez', '2025-05-17 20:12:57'),
('2234', 'ST10100320250517061257', '1446-11-19', '2.220.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '0', '2000', 'Chuwez', '2025-05-17 20:12:57'),
('2235', 'ST10100320250517061314', '1446-11-19', '1.100.10', '101', 'an.ACH. JUNAIDI', '5000', '0', 'Chuwez', '2025-05-17 20:13:14'),
('2236', 'ST10100320250517061314', '1446-11-19', '2.220.10', '101', 'an.ACH. JUNAIDI', '0', '5000', 'Chuwez', '2025-05-17 20:13:14'),
('2237', 'ST10100320250517061337', '1446-11-19', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '5000', '0', 'Chuwez', '2025-05-17 20:13:37'),
('2238', 'ST10100320250517061337', '1446-11-19', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '5000', 'Chuwez', '2025-05-17 20:13:37'),
('2239', 'ST10100320250517061402', '1446-11-19', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '5000', '0', 'Chuwez', '2025-05-17 20:14:02'),
('2240', 'ST10100320250517061402', '1446-11-19', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '5000', 'Chuwez', '2025-05-17 20:14:02'),
('2241', 'ST10100320250517061425', '1446-11-19', '1.100.10', '101', 'an.ANA SALSABILA', '2000', '0', 'Chuwez', '2025-05-17 20:14:25'),
('2242', 'ST10100320250517061425', '1446-11-19', '2.220.10', '101', 'an.ANA SALSABILA', '0', '2000', 'Chuwez', '2025-05-17 20:14:25'),
('2243', 'ST10100320250517061446', '1446-11-19', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '5000', '0', 'Chuwez', '2025-05-17 20:14:46'),
('2244', 'ST10100320250517061446', '1446-11-19', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '5000', 'Chuwez', '2025-05-17 20:14:46'),
('2245', 'ST10100320250517061505', '1446-11-19', '1.100.10', '101', 'an.AFANDI', '2000', '0', 'Chuwez', '2025-05-17 20:15:05'),
('2246', 'ST10100320250517061505', '1446-11-19', '2.220.10', '101', 'an.AFANDI', '0', '2000', 'Chuwez', '2025-05-17 20:15:05'),
('2247', 'ST10100320250517061553', '1446-11-19', '1.100.10', '101', 'an.MUHAMMAD KHOIRON', '5000', '0', 'Chuwez', '2025-05-17 20:15:53'),
('2248', 'ST10100320250517061553', '1446-11-19', '2.220.10', '101', 'an.MUHAMMAD KHOIRON', '0', '5000', 'Chuwez', '2025-05-17 20:15:53'),
('2249', 'ST10100320250517061659', '1446-11-19', '1.100.10', '101', 'an.ZAKIYATUL UMMAH', '2000', '0', 'Chuwez', '2025-05-17 20:16:59'),
('2250', 'ST10100320250517061659', '1446-11-19', '2.220.10', '101', 'an.ZAKIYATUL UMMAH', '0', '2000', 'Chuwez', '2025-05-17 20:16:59'),
('2251', 'ST10100320250517061742', '1446-11-19', '1.100.10', '101', 'an.AKHMAD FIKRI HAIKAL', '75000', '0', 'Chuwez', '2025-05-17 20:17:42'),
('2252', 'ST10100320250517061742', '1446-11-19', '2.220.10', '101', 'an.AKHMAD FIKRI HAIKAL', '0', '75000', 'Chuwez', '2025-05-17 20:17:42'),
('2253', 'ST10100320250517061816', '1446-11-19', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '25000', '0', 'Chuwez', '2025-05-17 20:18:16'),
('2254', 'ST10100320250517061816', '1446-11-19', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '25000', 'Chuwez', '2025-05-17 20:18:16'),
('2255', 'ST10100320250517061842', '1446-11-19', '1.100.10', '101', 'an.SINDI RAISA PUTRI', '10000', '0', 'Chuwez', '2025-05-17 20:18:42'),
('2256', 'ST10100320250517061842', '1446-11-19', '2.220.10', '101', 'an.SINDI RAISA PUTRI', '0', '10000', 'Chuwez', '2025-05-17 20:18:42'),
('2257', 'ST10100320250517061909', '1446-11-19', '1.100.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '10000', '0', 'Chuwez', '2025-05-17 20:19:09'),
('2258', 'ST10100320250517061909', '1446-11-19', '2.220.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '0', '10000', 'Chuwez', '2025-05-17 20:19:09'),
('2259', 'ST10100320250517061934', '1446-11-19', '1.100.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '5000', '0', 'Chuwez', '2025-05-17 20:19:34'),
('2260', 'ST10100320250517061934', '1446-11-19', '2.220.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '0', '5000', 'Chuwez', '2025-05-17 20:19:34'),
('2261', 'ST10100320250517062008', '1446-11-19', '1.100.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '10000', '0', 'Chuwez', '2025-05-17 20:20:08'),
('2262', 'ST10100320250517062008', '1446-11-19', '2.220.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '0', '10000', 'Chuwez', '2025-05-17 20:20:09'),
('2263', 'ST10100320250517062057', '1446-11-19', '1.100.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '10000', '0', 'Chuwez', '2025-05-17 20:20:57'),
('2264', 'ST10100320250517062057', '1446-11-19', '2.220.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '0', '10000', 'Chuwez', '2025-05-17 20:20:59'),
('2265', 'ST10100320250517062128', '1446-11-19', '1.100.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '30000', '0', 'Chuwez', '2025-05-17 20:21:28'),
('2266', 'ST10100320250517062128', '1446-11-19', '2.220.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '0', '30000', 'Chuwez', '2025-05-17 20:21:28'),
('2267', 'ST10100320250517062215', '1446-11-19', '1.100.10', '101', 'an.M. KAMALUDDIN', '20000', '0', 'Chuwez', '2025-05-17 20:22:15'),
('2268', 'ST10100320250517062215', '1446-11-19', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '20000', 'Chuwez', '2025-05-17 20:22:15'),
('2269', 'ST10100320250517062237', '1446-11-19', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '5000', '0', 'Chuwez', '2025-05-17 20:22:37'),
('2270', 'ST10100320250517062237', '1446-11-19', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '5000', 'Chuwez', '2025-05-17 20:22:38'),
('2271', 'ST10100320250517062255', '1446-11-19', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '10000', '0', 'Chuwez', '2025-05-17 20:22:55'),
('2272', 'ST10100320250517062255', '1446-11-19', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '10000', 'Chuwez', '2025-05-17 20:22:55'),
('2273', 'ST10100320250517062322', '1446-11-19', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Chuwez', '2025-05-17 20:23:22'),
('2274', 'ST10100320250517062322', '1446-11-19', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Chuwez', '2025-05-17 20:23:22'),
('2275', 'ST10100320250517062358', '1446-11-19', '1.100.10', '101', 'an.NABILATUN NISAUL UMMAH', '70000', '0', 'Chuwez', '2025-05-17 20:23:58'),
('2276', 'ST10100320250517062358', '1446-11-19', '2.220.10', '101', 'an.NABILATUN NISAUL UMMAH', '0', '70000', 'Chuwez', '2025-05-17 20:23:58'),
('2277', 'ST10100320250517062540', '1446-11-19', '1.100.10', '101', 'an.RAUDHOTUL JANNAH', '20000', '0', 'Chuwez', '2025-05-17 20:25:40'),
('2278', 'ST10100320250517062540', '1446-11-19', '2.220.10', '101', 'an.RAUDHOTUL JANNAH', '0', '20000', 'Chuwez', '2025-05-17 20:25:40'),
('2279', 'ST10100320250517062558', '1446-11-19', '1.100.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '5000', '0', 'Chuwez', '2025-05-17 20:25:58'),
('2280', 'ST10100320250517062558', '1446-11-19', '2.220.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '0', '5000', 'Chuwez', '2025-05-17 20:25:58'),
('2281', 'ST10100320250517062618', '1446-11-19', '1.100.10', '101', 'an.RENI FARIDA', '2000', '0', 'Chuwez', '2025-05-17 20:26:18'),
('2282', 'ST10100320250517062618', '1446-11-19', '2.220.10', '101', 'an.RENI FARIDA', '0', '2000', 'Chuwez', '2025-05-17 20:26:18'),
('2283', 'ST10100320250517062636', '1446-11-19', '1.100.10', '101', 'an.MIFTAHUL JANNAH', '50000', '0', 'Chuwez', '2025-05-17 20:26:36'),
('2284', 'ST10100320250517062636', '1446-11-19', '2.220.10', '101', 'an.MIFTAHUL JANNAH', '0', '50000', 'Chuwez', '2025-05-17 20:26:36'),
('2285', 'ST10100320250517062658', '1446-11-19', '1.100.10', '101', 'an.SAFIRATUL JANNAH', '10000', '0', 'Chuwez', '2025-05-17 20:26:58'),
('2286', 'ST10100320250517062658', '1446-11-19', '2.220.10', '101', 'an.SAFIRATUL JANNAH', '0', '10000', 'Chuwez', '2025-05-17 20:26:59'),
('2287', 'ST10100320250517072644', '1446-11-19', '1.100.10', '101', 'an.AHMAD SYAHRU ROMADHONI', '10000', '0', 'Chuwez', '2025-05-17 21:26:44'),
('2288', 'ST10100320250517072644', '1446-11-19', '2.220.10', '101', 'an.AHMAD SYAHRU ROMADHONI', '0', '10000', 'Chuwez', '2025-05-17 21:26:45'),
('2289', 'ST10100320250517072711', '1446-11-19', '1.100.10', '101', 'an.M. FAHMI NURUL ANAM', '10000', '0', 'Chuwez', '2025-05-17 21:27:11'),
('2290', 'ST10100320250517072711', '1446-11-19', '2.220.10', '101', 'an.M. FAHMI NURUL ANAM', '0', '10000', 'Chuwez', '2025-05-17 21:27:11'),
('2291', 'ST10100320250517072736', '1446-11-19', '1.100.10', '101', 'an.SITI ATHIUR ROHMAH', '5000', '0', 'Chuwez', '2025-05-17 21:27:36'),
('2292', 'ST10100320250517072736', '1446-11-19', '2.220.10', '101', 'an.SITI ATHIUR ROHMAH', '0', '5000', 'Chuwez', '2025-05-17 21:27:36'),
('2293', 'ST10100320250517072802', '1446-11-19', '1.100.10', '101', 'an.HIKMIAH PUTRI NIKMATUNNAFILAH', '5000', '0', 'Chuwez', '2025-05-17 21:28:02'),
('2294', 'ST10100320250517072802', '1446-11-19', '2.220.10', '101', 'an.HIKMIAH PUTRI NIKMATUNNAFILAH', '0', '5000', 'Chuwez', '2025-05-17 21:28:02'),
('2295', 'ST10100320250517072829', '1446-11-19', '1.100.10', '101', 'an.SITI QURROTUL AINI', '2000', '0', 'Chuwez', '2025-05-17 21:28:29'),
('2296', 'ST10100320250517072829', '1446-11-19', '2.220.10', '101', 'an.SITI QURROTUL AINI', '0', '2000', 'Chuwez', '2025-05-17 21:28:30'),
('2297', 'ST10100320250517072856', '1446-11-19', '1.100.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '10000', '0', 'Chuwez', '2025-05-17 21:28:56'),
('2298', 'ST10100320250517072856', '1446-11-19', '2.220.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '0', '10000', 'Chuwez', '2025-05-17 21:28:56'),
('2299', 'ST10100320250517072920', '1446-11-19', '1.100.10', '101', 'an.WARDATUL JANNAH', '2000', '0', 'Chuwez', '2025-05-17 21:29:20'),
('2300', 'ST10100320250517072920', '1446-11-19', '2.220.10', '101', 'an.WARDATUL JANNAH', '0', '2000', 'Chuwez', '2025-05-17 21:29:20'),
('2301', 'ST10100320250517072944', '1446-11-19', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '10000', '0', 'Chuwez', '2025-05-17 21:29:44'),
('2302', 'ST10100320250517072944', '1446-11-19', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '10000', 'Chuwez', '2025-05-17 21:29:44'),
('2303', 'ST10100320250517073319', '1446-11-19', '1.100.10', '101', 'an.BILQIS THALIA HASNA', '60000', '0', 'Chuwez', '2025-05-17 21:33:19'),
('2304', 'ST10100320250517073319', '1446-11-19', '2.220.10', '101', 'an.BILQIS THALIA HASNA', '0', '60000', 'Chuwez', '2025-05-17 21:33:19'),
('2305', 'ST10100320250517073348', '1446-11-19', '1.100.10', '101', 'an.AHMAD ABBAS MAULANA', '4000', '0', 'Chuwez', '2025-05-17 21:33:48'),
('2306', 'ST10100320250517073348', '1446-11-19', '2.220.10', '101', 'an.AHMAD ABBAS MAULANA', '0', '4000', 'Chuwez', '2025-05-17 21:33:48'),
('2307', 'ST10100320250517074028', '1446-11-19', '1.100.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '5000', '0', 'Chuwez', '2025-05-17 21:40:28'),
('2308', 'ST10100320250517074028', '1446-11-19', '2.220.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '0', '5000', 'Chuwez', '2025-05-17 21:40:28'),
('2309', 'ST10100320250517074051', '1446-11-19', '1.100.10', '101', 'an.NAURA BILADINA', '5000', '0', 'Chuwez', '2025-05-17 21:40:51'),
('2310', 'ST10100320250517074051', '1446-11-19', '2.220.10', '101', 'an.NAURA BILADINA', '0', '5000', 'Chuwez', '2025-05-17 21:40:51'),
('2311', 'ST10100320250517074121', '1446-11-19', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'Chuwez', '2025-05-17 21:41:21'),
('2312', 'ST10100320250517074121', '1446-11-19', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'Chuwez', '2025-05-17 21:41:21'),
('2313', 'ST10100320250517074143', '1446-11-19', '1.100.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '5000', '0', 'Chuwez', '2025-05-17 21:41:43'),
('2314', 'ST10100320250517074143', '1446-11-19', '2.220.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '0', '5000', 'Chuwez', '2025-05-17 21:41:43'),
('2315', 'ST10100320250517074205', '1446-11-19', '1.100.10', '101', 'an.M. ABD. HADI', '2000', '0', 'Chuwez', '2025-05-17 21:42:05'),
('2316', 'ST10100320250517074205', '1446-11-19', '2.220.10', '101', 'an.M. ABD. HADI', '0', '2000', 'Chuwez', '2025-05-17 21:42:05'),
('2317', 'ST10100320250517074231', '1446-11-19', '1.100.10', '101', 'an.MUHAMMAD NAZHIRUL ASROFI', '10000', '0', 'Chuwez', '2025-05-17 21:42:31'),
('2318', 'ST10100320250517074231', '1446-11-19', '2.220.10', '101', 'an.MUHAMMAD NAZHIRUL ASROFI', '0', '10000', 'Chuwez', '2025-05-17 21:42:31'),
('2319', 'ST10100320250517074259', '1446-11-19', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '5000', '0', 'Chuwez', '2025-05-17 21:42:59'),
('2320', 'ST10100320250517074259', '1446-11-19', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '5000', 'Chuwez', '2025-05-17 21:42:59'),
('2321', 'ST10100320250517074328', '1446-11-19', '1.100.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '2000', '0', 'Chuwez', '2025-05-17 21:43:28'),
('2322', 'ST10100320250517074328', '1446-11-19', '2.220.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '0', '2000', 'Chuwez', '2025-05-17 21:43:28'),
('2323', 'ST10100320250517074350', '1446-11-19', '1.100.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '5000', '0', 'Chuwez', '2025-05-17 21:43:50'),
('2324', 'ST10100320250517074350', '1446-11-19', '2.220.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '0', '5000', 'Chuwez', '2025-05-17 21:43:51'),
('2325', 'ST10100320250517074448', '1446-11-19', '1.100.10', '101', 'an.ABDULLOH BAHAR', '2000', '0', 'Chuwez', '2025-05-17 21:44:48'),
('2326', 'ST10100320250517074448', '1446-11-19', '2.220.10', '101', 'an.ABDULLOH BAHAR', '0', '2000', 'Chuwez', '2025-05-17 21:44:48'),
('2327', 'ST10100320250517074510', '1446-11-19', '1.100.10', '101', 'an.ROFIQOTUS SARIROH', '5000', '0', 'Chuwez', '2025-05-17 21:45:10'),
('2328', 'ST10100320250517074510', '1446-11-19', '2.220.10', '101', 'an.ROFIQOTUS SARIROH', '0', '5000', 'Chuwez', '2025-05-17 21:45:10'),
('2329', 'ST10100320250517074534', '1446-11-19', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'Chuwez', '2025-05-17 21:45:34'),
('2330', 'ST10100320250517074534', '1446-11-19', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'Chuwez', '2025-05-17 21:45:34'),
('2331', 'ST10100320250517074600', '1446-11-19', '1.100.10', '101', 'an.RAISA ANNISA', '5000', '0', 'Chuwez', '2025-05-17 21:46:00'),
('2332', 'ST10100320250517074600', '1446-11-19', '2.220.10', '101', 'an.RAISA ANNISA', '0', '5000', 'Chuwez', '2025-05-17 21:46:00'),
('2333', 'ST10100320250517074623', '1446-11-19', '1.100.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '4000', '0', 'Chuwez', '2025-05-17 21:46:23'),
('2334', 'ST10100320250517074623', '1446-11-19', '2.220.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '0', '4000', 'Chuwez', '2025-05-17 21:46:23'),
('2335', 'ST10100320250517074646', '1446-11-19', '1.100.10', '101', 'an.MUHAMMAD ARDIANSYAH', '10000', '0', 'Chuwez', '2025-05-17 21:46:46'),
('2336', 'ST10100320250517074646', '1446-11-19', '2.220.10', '101', 'an.MUHAMMAD ARDIANSYAH', '0', '10000', 'Chuwez', '2025-05-17 21:46:46'),
('2337', 'ST10100320250517074703', '1446-11-19', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '5000', '0', 'Chuwez', '2025-05-17 21:47:03'),
('2338', 'ST10100320250517074703', '1446-11-19', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '5000', 'Chuwez', '2025-05-17 21:47:03'),
('2339', 'ST10100320250517074727', '1446-11-19', '1.100.10', '101', 'an.MUHAMMAD ALWI', '5000', '0', 'Chuwez', '2025-05-17 21:47:27'),
('2340', 'ST10100320250517074727', '1446-11-19', '2.220.10', '101', 'an.MUHAMMAD ALWI', '0', '5000', 'Chuwez', '2025-05-17 21:47:27'),
('2341', 'ST10100320250517074747', '1446-11-19', '1.100.10', '101', 'an.UMAR FARUQ', '10000', '0', 'Chuwez', '2025-05-17 21:47:47'),
('2342', 'ST10100320250517074747', '1446-11-19', '2.220.10', '101', 'an.UMAR FARUQ', '0', '10000', 'Chuwez', '2025-05-17 21:47:47'),
('2343', 'ST10100320250517074809', '1446-11-19', '1.100.10', '101', 'an.MARIYATUL QIBTIYAH', '5000', '0', 'Chuwez', '2025-05-17 21:48:09'),
('2344', 'ST10100320250517074809', '1446-11-19', '2.220.10', '101', 'an.MARIYATUL QIBTIYAH', '0', '5000', 'Chuwez', '2025-05-17 21:48:09'),
('2345', 'ST10100320250517074832', '1446-11-19', '1.100.10', '101', 'an.FAIZAH NURUL LITA', '5000', '0', 'Chuwez', '2025-05-17 21:48:32'),
('2346', 'ST10100320250517074832', '1446-11-19', '2.220.10', '101', 'an.FAIZAH NURUL LITA', '0', '5000', 'Chuwez', '2025-05-17 21:48:32'),
('2347', 'ST10100320250517074859', '1446-11-19', '1.100.10', '101', 'an.MARIATUL QIBTIYAH', '2000', '0', 'Chuwez', '2025-05-17 21:48:59'),
('2348', 'ST10100320250517074859', '1446-11-19', '2.220.10', '101', 'an.MARIATUL QIBTIYAH', '0', '2000', 'Chuwez', '2025-05-17 21:48:59'),
('2349', 'ST10100320250517074926', '1446-11-19', '1.100.10', '101', 'an.NAILATUN NIAMI', '5000', '0', 'Chuwez', '2025-05-17 21:49:26'),
('2350', 'ST10100320250517074926', '1446-11-19', '2.220.10', '101', 'an.NAILATUN NIAMI', '0', '5000', 'Chuwez', '2025-05-17 21:49:26'),
('2351', 'ST10100320250517075001', '1446-11-19', '1.100.10', '101', 'an.AZKA AUFARIL MINAN', '10000', '0', 'Chuwez', '2025-05-17 21:50:01'),
('2352', 'ST10100320250517075001', '1446-11-19', '2.220.10', '101', 'an.AZKA AUFARIL MINAN', '0', '10000', 'Chuwez', '2025-05-17 21:50:01'),
('2353', 'ST10100320250517075023', '1446-11-19', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '10000', '0', 'Chuwez', '2025-05-17 21:50:23'),
('2354', 'ST10100320250517075023', '1446-11-19', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '10000', 'Chuwez', '2025-05-17 21:50:23'),
('2355', 'ST10100320250517075101', '1446-11-19', '1.100.10', '101', 'an.M. DESTRA MAULANA', '45000', '0', 'Chuwez', '2025-05-17 21:51:01'),
('2356', 'ST10100320250517075101', '1446-11-19', '2.220.10', '101', 'an.M. DESTRA MAULANA', '0', '45000', 'Chuwez', '2025-05-17 21:51:01'),
('2357', 'ST10100320250517075125', '1446-11-19', '1.100.10', '101', 'an.AHMAD ADITIYA', '10000', '0', 'Chuwez', '2025-05-17 21:51:25'),
('2358', 'ST10100320250517075125', '1446-11-19', '2.220.10', '101', 'an.AHMAD ADITIYA', '0', '10000', 'Chuwez', '2025-05-17 21:51:25'),
('2359', 'ST10100320250517075153', '1446-11-19', '1.100.10', '101', 'an.DIANA RIFQOTUL QOLBI', '10000', '0', 'Chuwez', '2025-05-17 21:51:53'),
('2360', 'ST10100320250517075153', '1446-11-19', '2.220.10', '101', 'an.DIANA RIFQOTUL QOLBI', '0', '10000', 'Chuwez', '2025-05-17 21:51:53'),
('2361', 'ST10100320250517075217', '1446-11-19', '1.100.10', '101', 'an.AISYAH', '5000', '0', 'Chuwez', '2025-05-17 21:52:17'),
('2362', 'ST10100320250517075217', '1446-11-19', '2.220.10', '101', 'an.AISYAH', '0', '5000', 'Chuwez', '2025-05-17 21:52:17'),
('2363', 'ST10100320250517075308', '1446-11-19', '1.100.10', '101', 'an.HILYA', '10000', '0', 'Chuwez', '2025-05-17 21:53:08'),
('2364', 'ST10100320250517075308', '1446-11-19', '2.220.10', '101', 'an.HILYA', '0', '10000', 'Chuwez', '2025-05-17 21:53:08'),
('2365', 'ST10100320250517075336', '1446-11-19', '1.100.10', '101', 'an.MACHMUDAH', '10000', '0', 'Chuwez', '2025-05-17 21:53:36'),
('2366', 'ST10100320250517075336', '1446-11-19', '2.220.10', '101', 'an.MACHMUDAH', '0', '10000', 'Chuwez', '2025-05-17 21:53:36'),
('2367', 'ST10100320250517075414', '1446-11-19', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'Chuwez', '2025-05-17 21:54:14'),
('2368', 'ST10100320250517075414', '1446-11-19', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'Chuwez', '2025-05-17 21:54:14'),
('2369', 'ST10100320250517075454', '1446-11-19', '1.100.10', '101', 'an.HAMIDAH', '100000', '0', 'Chuwez', '2025-05-17 21:54:54'),
('2370', 'ST10100320250517075454', '1446-11-19', '2.220.10', '101', 'an.HAMIDAH', '0', '100000', 'Chuwez', '2025-05-17 21:54:54'),
('2371', 'ST10100320250517075649', '1446-11-19', '1.100.10', '101', 'an.AMARA', '25000', '0', 'Chuwez', '2025-05-17 21:56:49'),
('2372', 'ST10100320250517075649', '1446-11-19', '2.220.10', '101', 'an.AMARA', '0', '25000', 'Chuwez', '2025-05-17 21:56:49'),
('2373', 'KK10100320250517152339', '1446-11-18', '5.520.41', '101', 'Pembinaan almiftah', '75000', '0', 'Chuwez', '2025-05-17 15:24:22'),
('2374', 'KK10100320250517152339', '1446-11-18', '1.100.10', '101', 'Pembinaan almiftah', '0', '75000', 'Chuwez', '2025-05-17 15:24:22'),
('2375', 'ST10100320250518074036', '1446-11-20', '1.100.10', '101', 'an.ELOK WARDATUN NAFISAH', '10000', '0', 'Chuwez', '2025-05-18 21:40:36'),
('2376', 'ST10100320250518074036', '1446-11-20', '2.220.10', '101', 'an.ELOK WARDATUN NAFISAH', '0', '10000', 'Chuwez', '2025-05-18 21:40:36'),
('2377', 'ST10100320250518074055', '1446-11-20', '1.100.10', '101', 'an.HAIKAL SHOMADANI', '2000', '0', 'Chuwez', '2025-05-18 21:40:55'),
('2378', 'ST10100320250518074055', '1446-11-20', '2.220.10', '101', 'an.HAIKAL SHOMADANI', '0', '2000', 'Chuwez', '2025-05-18 21:40:55'),
('2379', 'ST10100320250518074117', '1446-11-20', '1.100.10', '101', 'an.AULIA AZZAHRA', '2000', '0', 'Chuwez', '2025-05-18 21:41:17'),
('2380', 'ST10100320250518074117', '1446-11-20', '2.220.10', '101', 'an.AULIA AZZAHRA', '0', '2000', 'Chuwez', '2025-05-18 21:41:17'),
('2381', 'ST10100320250518074138', '1446-11-20', '1.100.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '5000', '0', 'Chuwez', '2025-05-18 21:41:38'),
('2382', 'ST10100320250518074138', '1446-11-20', '2.220.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '0', '5000', 'Chuwez', '2025-05-18 21:41:38'),
('2383', 'ST10100320250518074156', '1446-11-20', '1.100.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '5000', '0', 'Chuwez', '2025-05-18 21:41:56'),
('2384', 'ST10100320250518074156', '1446-11-20', '2.220.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '0', '5000', 'Chuwez', '2025-05-18 21:41:57'),
('2385', 'ST10100320250518074221', '1446-11-20', '1.100.10', '101', 'an.NAURA BILADINA', '6000', '0', 'Chuwez', '2025-05-18 21:42:21'),
('2386', 'ST10100320250518074221', '1446-11-20', '2.220.10', '101', 'an.NAURA BILADINA', '0', '6000', 'Chuwez', '2025-05-18 21:42:21'),
('2387', 'ST10100320250518074237', '1446-11-20', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '5000', '0', 'Chuwez', '2025-05-18 21:42:37'),
('2388', 'ST10100320250518074237', '1446-11-20', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '5000', 'Chuwez', '2025-05-18 21:42:37'),
('2389', 'ST10100320250518074256', '1446-11-20', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'Chuwez', '2025-05-18 21:42:56'),
('2390', 'ST10100320250518074256', '1446-11-20', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'Chuwez', '2025-05-18 21:42:56'),
('2391', 'ST10100320250518074314', '1446-11-20', '1.100.10', '101', 'an.M. ABD. HADI', '2000', '0', 'Chuwez', '2025-05-18 21:43:14'),
('2392', 'ST10100320250518074314', '1446-11-20', '2.220.10', '101', 'an.M. ABD. HADI', '0', '2000', 'Chuwez', '2025-05-18 21:43:14'),
('2393', 'ST10100320250518074415', '1446-11-20', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'Chuwez', '2025-05-18 21:44:15'),
('2394', 'ST10100320250518074415', '1446-11-20', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'Chuwez', '2025-05-18 21:44:15'),
('2395', 'ST10100320250518074428', '1446-11-20', '1.100.10', '101', 'an.RAISA ANNISA', '5000', '0', 'Chuwez', '2025-05-18 21:44:28'),
('2396', 'ST10100320250518074428', '1446-11-20', '2.220.10', '101', 'an.RAISA ANNISA', '0', '5000', 'Chuwez', '2025-05-18 21:44:28'),
('2397', 'ST10100320250518074445', '1446-11-20', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '5000', '0', 'Chuwez', '2025-05-18 21:44:45'),
('2398', 'ST10100320250518074445', '1446-11-20', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '5000', 'Chuwez', '2025-05-18 21:44:45'),
('2399', 'ST10100320250518074459', '1446-11-20', '1.100.10', '101', 'an.ROFIQOTUS SARIROH', '5000', '0', 'Chuwez', '2025-05-18 21:44:59'),
('2400', 'ST10100320250518074459', '1446-11-20', '2.220.10', '101', 'an.ROFIQOTUS SARIROH', '0', '5000', 'Chuwez', '2025-05-18 21:45:00'),
('2401', 'ST10100320250518074523', '1446-11-20', '1.100.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '4000', '0', 'Chuwez', '2025-05-18 21:45:23'),
('2402', 'ST10100320250518074523', '1446-11-20', '2.220.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '0', '4000', 'Chuwez', '2025-05-18 21:45:23'),
('2403', 'ST10100320250518074551', '1446-11-20', '1.100.10', '101', 'an.M. ABDIL ARIKIN', '5000', '0', 'Chuwez', '2025-05-18 21:45:51'),
('2404', 'ST10100320250518074551', '1446-11-20', '2.220.10', '101', 'an.M. ABDIL ARIKIN', '0', '5000', 'Chuwez', '2025-05-18 21:45:51'),
('2405', 'ST10100320250518074609', '1446-11-20', '1.100.10', '101', 'an.MARIATUL QIBTIYAH', '2000', '0', 'Chuwez', '2025-05-18 21:46:09'),
('2406', 'ST10100320250518074609', '1446-11-20', '2.220.10', '101', 'an.MARIATUL QIBTIYAH', '0', '2000', 'Chuwez', '2025-05-18 21:46:09'),
('2407', 'ST10100320250518074622', '1446-11-20', '1.100.10', '101', 'an.UMAR FARUQ', '10000', '0', 'Chuwez', '2025-05-18 21:46:22'),
('2408', 'ST10100320250518074622', '1446-11-20', '2.220.10', '101', 'an.UMAR FARUQ', '0', '10000', 'Chuwez', '2025-05-18 21:46:22'),
('2409', 'ST10100320250518074643', '1446-11-20', '1.100.10', '101', 'an.MARIYATUL QIBTIYAH', '5000', '0', 'Chuwez', '2025-05-18 21:46:43'),
('2410', 'ST10100320250518074643', '1446-11-20', '2.220.10', '101', 'an.MARIYATUL QIBTIYAH', '0', '5000', 'Chuwez', '2025-05-18 21:46:43'),
('2411', 'ST10100320250518074708', '1446-11-20', '1.100.10', '101', 'an.MUHAMMAD ALWI', '10000', '0', 'Chuwez', '2025-05-18 21:47:08'),
('2412', 'ST10100320250518074708', '1446-11-20', '2.220.10', '101', 'an.MUHAMMAD ALWI', '0', '10000', 'Chuwez', '2025-05-18 21:47:08'),
('2413', 'ST10100320250518074821', '1446-11-20', '1.100.10', '101', 'an.AISYAH', '2000', '0', 'Chuwez', '2025-05-18 21:48:21'),
('2414', 'ST10100320250518074821', '1446-11-20', '2.220.10', '101', 'an.AISYAH', '0', '2000', 'Chuwez', '2025-05-18 21:48:21'),
('2415', 'ST10100320250518074846', '1446-11-20', '1.100.10', '101', 'an.MASRUROTUL MAULUDIYAH', '10000', '0', 'Chuwez', '2025-05-18 21:48:46'),
('2416', 'ST10100320250518074846', '1446-11-20', '2.220.10', '101', 'an.MASRUROTUL MAULUDIYAH', '0', '10000', 'Chuwez', '2025-05-18 21:48:46'),
('2417', 'ST10100320250518075054', '1446-11-20', '1.100.10', '101', 'an.AHMAD ADITIYA', '5000', '0', 'Chuwez', '2025-05-18 21:50:54'),
('2418', 'ST10100320250518075054', '1446-11-20', '2.220.10', '101', 'an.AHMAD ADITIYA', '0', '5000', 'Chuwez', '2025-05-18 21:50:54'),
('2419', 'ST10100320250518075133', '1446-11-20', '1.100.10', '101', 'an.SAFIRATUL JANNAH', '10000', '0', 'Chuwez', '2025-05-18 21:51:33'),
('2420', 'ST10100320250518075133', '1446-11-20', '2.220.10', '101', 'an.SAFIRATUL JANNAH', '0', '10000', 'Chuwez', '2025-05-18 21:51:33'),
('2421', 'ST10100320250518075158', '1446-11-20', '1.100.10', '101', 'an.M. ZIDAN RIZQI SALIM', '5000', '0', 'Chuwez', '2025-05-18 21:51:58'),
('2422', 'ST10100320250518075158', '1446-11-20', '2.220.10', '101', 'an.M. ZIDAN RIZQI SALIM', '0', '5000', 'Chuwez', '2025-05-18 21:51:58'),
('2423', 'ST10100320250518075222', '1446-11-20', '1.100.10', '101', 'an.ACH. JUNAIDI', '5000', '0', 'Chuwez', '2025-05-18 21:52:22'),
('2424', 'ST10100320250518075222', '1446-11-20', '2.220.10', '101', 'an.ACH. JUNAIDI', '0', '5000', 'Chuwez', '2025-05-18 21:52:22'),
('2425', 'ST10100320250518075250', '1446-11-20', '1.100.10', '101', 'an.MUHAMMAD KANZUL KAROMI', '5000', '0', 'Chuwez', '2025-05-18 21:52:50'),
('2426', 'ST10100320250518075250', '1446-11-20', '2.220.10', '101', 'an.MUHAMMAD KANZUL KAROMI', '0', '5000', 'Chuwez', '2025-05-18 21:52:50'),
('2427', 'ST10100320250518075314', '1446-11-20', '1.100.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '2000', '0', 'Chuwez', '2025-05-18 21:53:14'),
('2428', 'ST10100320250518075314', '1446-11-20', '2.220.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '0', '2000', 'Chuwez', '2025-05-18 21:53:14'),
('2429', 'ST10100320250518075337', '1446-11-20', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '5000', '0', 'Chuwez', '2025-05-18 21:53:37'),
('2430', 'ST10100320250518075337', '1446-11-20', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '5000', 'Chuwez', '2025-05-18 21:53:37'),
('2431', 'ST10100320250518075401', '1446-11-20', '1.100.10', '101', 'an.ALFIN HIDAYAT', '5000', '0', 'Chuwez', '2025-05-18 21:54:01'),
('2432', 'ST10100320250518075401', '1446-11-20', '2.220.10', '101', 'an.ALFIN HIDAYAT', '0', '5000', 'Chuwez', '2025-05-18 21:54:01'),
('2433', 'ST10100320250518075436', '1446-11-20', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '2000', '0', 'Chuwez', '2025-05-18 21:54:36'),
('2434', 'ST10100320250518075436', '1446-11-20', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '2000', 'Chuwez', '2025-05-18 21:54:36'),
('2435', 'ST10100320250518075508', '1446-11-20', '1.100.10', '101', 'an.ZAKIYATUL UMMAH', '2000', '0', 'Chuwez', '2025-05-18 21:55:08'),
('2436', 'ST10100320250518075508', '1446-11-20', '2.220.10', '101', 'an.ZAKIYATUL UMMAH', '0', '2000', 'Chuwez', '2025-05-18 21:55:08'),
('2437', 'ST10100320250518075530', '1446-11-20', '1.100.10', '101', 'an.ANA SALSABILA', '2000', '0', 'Chuwez', '2025-05-18 21:55:30'),
('2438', 'ST10100320250518075530', '1446-11-20', '2.220.10', '101', 'an.ANA SALSABILA', '0', '2000', 'Chuwez', '2025-05-18 21:55:30'),
('2439', 'ST10100320250518075559', '1446-11-20', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '5000', '0', 'Chuwez', '2025-05-18 21:55:59'),
('2440', 'ST10100320250518075559', '1446-11-20', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '5000', 'Chuwez', '2025-05-18 21:55:59'),
('2441', 'ST10100320250518075622', '1446-11-20', '1.100.10', '101', 'an.MUHAMMAD KHOIRON', '5000', '0', 'Chuwez', '2025-05-18 21:56:22'),
('2442', 'ST10100320250518075622', '1446-11-20', '2.220.10', '101', 'an.MUHAMMAD KHOIRON', '0', '5000', 'Chuwez', '2025-05-18 21:56:22'),
('2443', 'ST10100320250518075644', '1446-11-20', '1.100.10', '101', 'an.M. ALIFIN FIKRI', '2000', '0', 'Chuwez', '2025-05-18 21:56:44'),
('2444', 'ST10100320250518075644', '1446-11-20', '2.220.10', '101', 'an.M. ALIFIN FIKRI', '0', '2000', 'Chuwez', '2025-05-18 21:56:44'),
('2445', 'ST10100320250518075706', '1446-11-20', '1.100.10', '101', 'an.AFANDI', '2000', '0', 'Chuwez', '2025-05-18 21:57:06'),
('2446', 'ST10100320250518075706', '1446-11-20', '2.220.10', '101', 'an.AFANDI', '0', '2000', 'Chuwez', '2025-05-18 21:57:06'),
('2447', 'ST10100320250518075732', '1446-11-20', '1.100.10', '101', 'an.MUHAMMAD YAHYA SYAKARUDDIN', '5000', '0', 'Chuwez', '2025-05-18 21:57:32'),
('2448', 'ST10100320250518075732', '1446-11-20', '2.220.10', '101', 'an.MUHAMMAD YAHYA SYAKARUDDIN', '0', '5000', 'Chuwez', '2025-05-18 21:57:32'),
('2449', 'ST10100320250518075752', '1446-11-20', '1.100.10', '101', 'an.MUHAMMAD HAMDANI', '10000', '0', 'Chuwez', '2025-05-18 21:57:52'),
('2450', 'ST10100320250518075752', '1446-11-20', '2.220.10', '101', 'an.MUHAMMAD HAMDANI', '0', '10000', 'Chuwez', '2025-05-18 21:57:52'),
('2451', 'ST10100320250518075816', '1446-11-20', '1.100.10', '101', 'an.AZKA AUFARIL MINAN', '10000', '0', 'Chuwez', '2025-05-18 21:58:16'),
('2452', 'ST10100320250518075816', '1446-11-20', '2.220.10', '101', 'an.AZKA AUFARIL MINAN', '0', '10000', 'Chuwez', '2025-05-18 21:58:16'),
('2453', 'ST10100320250518075847', '1446-11-20', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '10000', '0', 'Chuwez', '2025-05-18 21:58:47'),
('2454', 'ST10100320250518075847', '1446-11-20', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '10000', 'Chuwez', '2025-05-18 21:58:47'),
('2455', 'ST10100320250518080134', '1446-11-20', '1.100.10', '101', 'an.AHMAD ABBAS MAULANA', '3000', '0', 'Chuwez', '2025-05-18 22:01:34'),
('2456', 'ST10100320250518080134', '1446-11-20', '2.220.10', '101', 'an.AHMAD ABBAS MAULANA', '0', '3000', 'Chuwez', '2025-05-18 22:01:34'),
('2457', 'ST10100320250518080205', '1446-11-20', '1.100.10', '101', 'an.M. ROFIQ HIDAYATULLOH', '10000', '0', 'Chuwez', '2025-05-18 22:02:05'),
('2458', 'ST10100320250518080205', '1446-11-20', '2.220.10', '101', 'an.M. ROFIQ HIDAYATULLOH', '0', '10000', 'Chuwez', '2025-05-18 22:02:05'),
('2459', 'ST10100320250518080231', '1446-11-20', '1.100.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '10000', '0', 'Chuwez', '2025-05-18 22:02:31'),
('2460', 'ST10100320250518080231', '1446-11-20', '2.220.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '0', '10000', 'Chuwez', '2025-05-18 22:02:31'),
('2461', 'ST10100320250518080307', '1446-11-20', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '25000', '0', 'Chuwez', '2025-05-18 22:03:07'),
('2462', 'ST10100320250518080307', '1446-11-20', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '25000', 'Chuwez', '2025-05-18 22:03:07'),
('2463', 'ST10100320250518080349', '1446-11-20', '1.100.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '5000', '0', 'Chuwez', '2025-05-18 22:03:49'),
('2464', 'ST10100320250518080349', '1446-11-20', '2.220.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '0', '5000', 'Chuwez', '2025-05-18 22:03:49'),
('2465', 'ST10100320250518080424', '1446-11-20', '1.100.10', '101', 'an.AKHMAD FIKRI HAIKAL', '50000', '0', 'Chuwez', '2025-05-18 22:04:24'),
('2466', 'ST10100320250518080424', '1446-11-20', '2.220.10', '101', 'an.AKHMAD FIKRI HAIKAL', '0', '50000', 'Chuwez', '2025-05-18 22:04:24'),
('2467', 'ST10100320250518080458', '1446-11-20', '1.100.10', '101', 'an.BILQIS THALIA HASNA', '60000', '0', 'Chuwez', '2025-05-18 22:04:58'),
('2468', 'ST10100320250518080458', '1446-11-20', '2.220.10', '101', 'an.BILQIS THALIA HASNA', '0', '60000', 'Chuwez', '2025-05-18 22:04:58'),
('2469', 'ST10100320250518080532', '1446-11-20', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Chuwez', '2025-05-18 22:05:32'),
('2470', 'ST10100320250518080532', '1446-11-20', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Chuwez', '2025-05-18 22:05:32'),
('2471', 'ST10100320250518080602', '1446-11-20', '1.100.10', '101', 'an.RENI FARIDA', '2000', '0', 'Chuwez', '2025-05-18 22:06:02'),
('2472', 'ST10100320250518080602', '1446-11-20', '2.220.10', '101', 'an.RENI FARIDA', '0', '2000', 'Chuwez', '2025-05-18 22:06:02'),
('2473', 'ST10100320250518080627', '1446-11-20', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '5000', '0', 'Chuwez', '2025-05-18 22:06:27'),
('2474', 'ST10100320250518080627', '1446-11-20', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '5000', 'Chuwez', '2025-05-18 22:06:27'),
('2475', 'ST10100320250518080701', '1446-11-20', '1.100.10', '101', 'an.RAUDHOTUL JANNAH', '40000', '0', 'Chuwez', '2025-05-18 22:07:01'),
('2476', 'ST10100320250518080701', '1446-11-20', '2.220.10', '101', 'an.RAUDHOTUL JANNAH', '0', '40000', 'Chuwez', '2025-05-18 22:07:01'),
('2477', 'ST10100320250518080725', '1446-11-20', '1.100.10', '101', 'an.M. KAMALUDDIN', '20000', '0', 'Chuwez', '2025-05-18 22:07:25'),
('2478', 'ST10100320250518080725', '1446-11-20', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '20000', 'Chuwez', '2025-05-18 22:07:25'),
('2479', 'ST10100320250518080746', '1446-11-20', '1.100.10', '101', 'an.MIFTAHUL JANNAH', '50000', '0', 'Chuwez', '2025-05-18 22:07:46'),
('2480', 'ST10100320250518080746', '1446-11-20', '2.220.10', '101', 'an.MIFTAHUL JANNAH', '0', '50000', 'Chuwez', '2025-05-18 22:07:46'),
('2481', 'ST10100320250518080809', '1446-11-20', '1.100.10', '101', 'an.NABILATUN NISAUL UMMAH', '20000', '0', 'Chuwez', '2025-05-18 22:08:09'),
('2482', 'ST10100320250518080809', '1446-11-20', '2.220.10', '101', 'an.NABILATUN NISAUL UMMAH', '0', '20000', 'Chuwez', '2025-05-18 22:08:09'),
('2483', 'ST10100320250518080839', '1446-11-20', '1.100.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '10000', '0', 'Chuwez', '2025-05-18 22:08:39'),
('2484', 'ST10100320250518080839', '1446-11-20', '2.220.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '0', '10000', 'Chuwez', '2025-05-18 22:08:39'),
('2485', 'ST10100320250518080904', '1446-11-20', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '2000', '0', 'Chuwez', '2025-05-18 22:09:04'),
('2486', 'ST10100320250518080904', '1446-11-20', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '2000', 'Chuwez', '2025-05-18 22:09:04'),
('2487', 'ST10100320250518080931', '1446-11-20', '1.100.10', '101', 'an.WARDATUL JANNAH', '5000', '0', 'Chuwez', '2025-05-18 22:09:31'),
('2488', 'ST10100320250518080931', '1446-11-20', '2.220.10', '101', 'an.WARDATUL JANNAH', '0', '5000', 'Chuwez', '2025-05-18 22:09:31'),
('2489', 'ST10100320250518080950', '1446-11-20', '1.100.10', '101', 'an.AHMAD SYAHRU ROMADHONI', '20000', '0', 'Chuwez', '2025-05-18 22:09:50'),
('2490', 'ST10100320250518080950', '1446-11-20', '2.220.10', '101', 'an.AHMAD SYAHRU ROMADHONI', '0', '20000', 'Chuwez', '2025-05-18 22:09:50'),
('2491', 'ST10100320250518081006', '1446-11-20', '1.100.10', '101', 'an.M. FAHMI NURUL ANAM', '10000', '0', 'Chuwez', '2025-05-18 22:10:06'),
('2492', 'ST10100320250518081006', '1446-11-20', '2.220.10', '101', 'an.M. FAHMI NURUL ANAM', '0', '10000', 'Chuwez', '2025-05-18 22:10:06'),
('2493', 'ST10100320250518081040', '1446-11-20', '1.100.10', '101', 'an.AHMAD RAFI SALIM', '5000', '0', 'Chuwez', '2025-05-18 22:10:40'),
('2494', 'ST10100320250518081040', '1446-11-20', '2.220.10', '101', 'an.AHMAD RAFI SALIM', '0', '5000', 'Chuwez', '2025-05-18 22:10:40'),
('2495', 'ST10100320250518081057', '1446-11-20', '1.100.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '10000', '0', 'Chuwez', '2025-05-18 22:10:57'),
('2496', 'ST10100320250518081057', '1446-11-20', '2.220.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '0', '10000', 'Chuwez', '2025-05-18 22:10:57'),
('2497', 'ST10100320250518081114', '1446-11-20', '1.100.10', '101', 'an.SITI QURROTUL AINI', '2000', '0', 'Chuwez', '2025-05-18 22:11:14'),
('2498', 'ST10100320250518081114', '1446-11-20', '2.220.10', '101', 'an.SITI QURROTUL AINI', '0', '2000', 'Chuwez', '2025-05-18 22:11:14'),
('2499', 'ST10100320250518081136', '1446-11-20', '1.100.10', '101', 'an.KHOIRIYAH', '10000', '0', 'Chuwez', '2025-05-18 22:11:36'),
('2500', 'ST10100320250518081136', '1446-11-20', '2.220.10', '101', 'an.KHOIRIYAH', '0', '10000', 'Chuwez', '2025-05-18 22:11:36'),
('2501', 'ST10100320250518081156', '1446-11-20', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '10000', '0', 'Chuwez', '2025-05-18 22:11:56'),
('2502', 'ST10100320250518081156', '1446-11-20', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '10000', 'Chuwez', '2025-05-18 22:11:56'),
('2503', 'ST10100320250518081212', '1446-11-20', '1.100.10', '101', 'an.HIKMIAH PUTRI NIKMATUNNAFILAH', '5000', '0', 'Chuwez', '2025-05-18 22:12:12'),
('2504', 'ST10100320250518081212', '1446-11-20', '2.220.10', '101', 'an.HIKMIAH PUTRI NIKMATUNNAFILAH', '0', '5000', 'Chuwez', '2025-05-18 22:12:13'),
('2505', 'ST10100320250518081234', '1446-11-20', '1.100.10', '101', 'an.DIYANAH KAMALIYAH', '10000', '0', 'Chuwez', '2025-05-18 22:12:34'),
('2506', 'ST10100320250518081234', '1446-11-20', '2.220.10', '101', 'an.DIYANAH KAMALIYAH', '0', '10000', 'Chuwez', '2025-05-18 22:12:34'),
('2507', 'ST10100320250518081249', '1446-11-20', '1.100.10', '101', 'an.SITI ATHIUR ROHMAH', '5000', '0', 'Chuwez', '2025-05-18 22:12:49'),
('2508', 'ST10100320250518081249', '1446-11-20', '2.220.10', '101', 'an.SITI ATHIUR ROHMAH', '0', '5000', 'Chuwez', '2025-05-18 22:12:49'),
('2509', 'ST10100320250518081303', '1446-11-20', '1.100.10', '101', 'an.ABDUL HAMID', '2000', '0', 'Chuwez', '2025-05-18 22:13:03'),
('2510', 'ST10100320250518081303', '1446-11-20', '2.220.10', '101', 'an.ABDUL HAMID', '0', '2000', 'Chuwez', '2025-05-18 22:13:03'),
('2511', 'ST10100320250518081350', '1446-11-20', '1.100.10', '101', 'an.HILYA', '10000', '0', 'Chuwez', '2025-05-18 22:13:50'),
('2512', 'ST10100320250518081350', '1446-11-20', '2.220.10', '101', 'an.HILYA', '0', '10000', 'Chuwez', '2025-05-18 22:13:50'),
('2513', 'ST10100320250518081423', '1446-11-20', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'Chuwez', '2025-05-18 22:14:23'),
('2514', 'ST10100320250518081423', '1446-11-20', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'Chuwez', '2025-05-18 22:14:23'),
('2515', 'ST10100320250518081456', '1446-11-20', '1.100.10', '101', 'an.UST THORIQUL HUDA', '100000', '0', 'Chuwez', '2025-05-18 22:14:56'),
('2516', 'ST10100320250518081456', '1446-11-20', '2.220.10', '101', 'an.UST THORIQUL HUDA', '0', '100000', 'Chuwez', '2025-05-18 22:14:56'),
('2517', 'ST10100320250518094218', '1446-11-20', '1.100.10', '101', 'an.AMARA', '10000', '0', 'Chuwez', '2025-05-18 23:42:18'),
('2518', 'ST10100320250518094218', '1446-11-20', '2.220.10', '101', 'an.AMARA', '0', '10000', 'Chuwez', '2025-05-18 23:42:18'),
('2519', 'ST10100320250519073621', '1446-11-21', '1.100.10', '101', 'an.MUHAMMAD ARDIANSYAH', '10000', '0', 'Chuwez', '2025-05-19 21:36:21'),
('2520', 'ST10100320250519073621', '1446-11-21', '2.220.10', '101', 'an.MUHAMMAD ARDIANSYAH', '0', '10000', 'Chuwez', '2025-05-19 21:36:21'),
('2521', 'ST10100320250519073638', '1446-11-21', '1.100.10', '101', 'an.FAIZAH NURUL LITA', '5000', '0', 'Chuwez', '2025-05-19 21:36:38'),
('2522', 'ST10100320250519073638', '1446-11-21', '2.220.10', '101', 'an.FAIZAH NURUL LITA', '0', '5000', 'Chuwez', '2025-05-19 21:36:38'),
('2523', 'ST10100320250519073652', '1446-11-21', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '5000', '0', 'Chuwez', '2025-05-19 21:36:52'),
('2524', 'ST10100320250519073652', '1446-11-21', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '5000', 'Chuwez', '2025-05-19 21:36:52'),
('2525', 'ST10100320250519073722', '1446-11-21', '1.100.10', '101', 'an.UBAIDAH', '20000', '0', 'Chuwez', '2025-05-19 21:37:22'),
('2526', 'ST10100320250519073722', '1446-11-21', '2.220.10', '101', 'an.UBAIDAH', '0', '20000', 'Chuwez', '2025-05-19 21:37:22'),
('2527', 'ST10100320250519073740', '1446-11-21', '1.100.10', '101', 'an.SAUQY AHMAD', '25000', '0', 'Chuwez', '2025-05-19 21:37:40'),
('2528', 'ST10100320250519073740', '1446-11-21', '2.220.10', '101', 'an.SAUQY AHMAD', '0', '25000', 'Chuwez', '2025-05-19 21:37:40'),
('2529', 'ST10100320250519073825', '1446-11-21', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'Chuwez', '2025-05-19 21:38:25'),
('2530', 'ST10100320250519073825', '1446-11-21', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'Chuwez', '2025-05-19 21:38:25'),
('2531', 'ST10100320250519073839', '1446-11-21', '1.100.10', '101', 'an.NAILATUN NIAMI', '5000', '0', 'Chuwez', '2025-05-19 21:38:39'),
('2532', 'ST10100320250519073839', '1446-11-21', '2.220.10', '101', 'an.NAILATUN NIAMI', '0', '5000', 'Chuwez', '2025-05-19 21:38:39'),
('2533', 'ST10100320250519073854', '1446-11-21', '1.100.10', '101', 'an.ROHMATULLOH', '10000', '0', 'Chuwez', '2025-05-19 21:38:54'),
('2534', 'ST10100320250519073854', '1446-11-21', '2.220.10', '101', 'an.ROHMATULLOH', '0', '10000', 'Chuwez', '2025-05-19 21:38:54'),
('2535', 'ST10100320250519073908', '1446-11-21', '1.100.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '4000', '0', 'Chuwez', '2025-05-19 21:39:08'),
('2536', 'ST10100320250519073908', '1446-11-21', '2.220.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '0', '4000', 'Chuwez', '2025-05-19 21:39:08'),
('2537', 'ST10100320250519073922', '1446-11-21', '1.100.10', '101', 'an.MARIATUL QIBTIYAH', '2000', '0', 'Chuwez', '2025-05-19 21:39:22'),
('2538', 'ST10100320250519073922', '1446-11-21', '2.220.10', '101', 'an.MARIATUL QIBTIYAH', '0', '2000', 'Chuwez', '2025-05-19 21:39:22'),
('2539', 'ST10100320250519073938', '1446-11-21', '1.100.10', '101', 'an.RAISA ANNISA', '5000', '0', 'Chuwez', '2025-05-19 21:39:38'),
('2540', 'ST10100320250519073938', '1446-11-21', '2.220.10', '101', 'an.RAISA ANNISA', '0', '5000', 'Chuwez', '2025-05-19 21:39:38'),
('2541', 'ST10100320250519073955', '1446-11-21', '1.100.10', '101', 'an.UMAR FARUQ', '5000', '0', 'Chuwez', '2025-05-19 21:39:55'),
('2542', 'ST10100320250519073955', '1446-11-21', '2.220.10', '101', 'an.UMAR FARUQ', '0', '5000', 'Chuwez', '2025-05-19 21:39:55'),
('2543', 'ST10100320250519074009', '1446-11-21', '1.100.10', '101', 'an.MARIYATUL QIBTIYAH', '5000', '0', 'Chuwez', '2025-05-19 21:40:09'),
('2544', 'ST10100320250519074009', '1446-11-21', '2.220.10', '101', 'an.MARIYATUL QIBTIYAH', '0', '5000', 'Chuwez', '2025-05-19 21:40:09'),
('2545', 'ST10100320250519074038', '1446-11-21', '1.100.10', '101', 'an.MUHAMMAD ALWI', '5000', '0', 'Chuwez', '2025-05-19 21:40:38'),
('2546', 'ST10100320250519074038', '1446-11-21', '2.220.10', '101', 'an.MUHAMMAD ALWI', '0', '5000', 'Chuwez', '2025-05-19 21:40:38'),
('2547', 'ST10100320250519074142', '1446-11-21', '1.100.10', '101', 'an.M. ABD. HADI', '3000', '0', 'Chuwez', '2025-05-19 21:41:42'),
('2548', 'ST10100320250519074142', '1446-11-21', '2.220.10', '101', 'an.M. ABD. HADI', '0', '3000', 'Chuwez', '2025-05-19 21:41:42'),
('2549', 'ST10100320250519074201', '1446-11-21', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '5000', '0', 'Chuwez', '2025-05-19 21:42:01'),
('2550', 'ST10100320250519074201', '1446-11-21', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '5000', 'Chuwez', '2025-05-19 21:42:01'),
('2551', 'ST10100320250519074222', '1446-11-21', '1.100.10', '101', 'an.HAIKAL SHOMADANI', '2000', '0', 'Chuwez', '2025-05-19 21:42:22'),
('2552', 'ST10100320250519074222', '1446-11-21', '2.220.10', '101', 'an.HAIKAL SHOMADANI', '0', '2000', 'Chuwez', '2025-05-19 21:42:22'),
('2553', 'ST10100320250519074249', '1446-11-21', '1.100.10', '101', 'an.NAURA BILADINA', '6000', '0', 'Chuwez', '2025-05-19 21:42:49'),
('2554', 'ST10100320250519074249', '1446-11-21', '2.220.10', '101', 'an.NAURA BILADINA', '0', '6000', 'Chuwez', '2025-05-19 21:42:49'),
('2555', 'ST10100320250519074311', '1446-11-21', '1.100.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '5000', '0', 'Chuwez', '2025-05-19 21:43:11'),
('2556', 'ST10100320250519074311', '1446-11-21', '2.220.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '0', '5000', 'Chuwez', '2025-05-19 21:43:11'),
('2557', 'ST10100320250519074330', '1446-11-21', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'Chuwez', '2025-05-19 21:43:30'),
('2558', 'ST10100320250519074330', '1446-11-21', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'Chuwez', '2025-05-19 21:43:30'),
('2559', 'ST10100320250519074344', '1446-11-21', '1.100.10', '101', 'an.SITI SHOFIYAH LABIBAH', '50000', '0', 'Chuwez', '2025-05-19 21:43:44'),
('2560', 'ST10100320250519074344', '1446-11-21', '2.220.10', '101', 'an.SITI SHOFIYAH LABIBAH', '0', '50000', 'Chuwez', '2025-05-19 21:43:44'),
('2561', 'ST10100320250519074358', '1446-11-21', '1.100.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '2000', '0', 'Chuwez', '2025-05-19 21:43:58'),
('2562', 'ST10100320250519074358', '1446-11-21', '2.220.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '0', '2000', 'Chuwez', '2025-05-19 21:43:58'),
('2563', 'ST10100320250519074413', '1446-11-21', '1.100.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '5000', '0', 'Chuwez', '2025-05-19 21:44:13'),
('2564', 'ST10100320250519074413', '1446-11-21', '2.220.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '0', '5000', 'Chuwez', '2025-05-19 21:44:13'),
('2565', 'ST10100320250519074437', '1446-11-21', '1.100.10', '101', 'an.MASRUROTUL MAULUDIYAH', '5000', '0', 'Chuwez', '2025-05-19 21:44:37'),
('2566', 'ST10100320250519074437', '1446-11-21', '2.220.10', '101', 'an.MASRUROTUL MAULUDIYAH', '0', '5000', 'Chuwez', '2025-05-19 21:44:37'),
('2567', 'ST10100320250519074453', '1446-11-21', '1.100.10', '101', 'an.AISYAH', '2000', '0', 'Chuwez', '2025-05-19 21:44:53'),
('2568', 'ST10100320250519074453', '1446-11-21', '2.220.10', '101', 'an.AISYAH', '0', '2000', 'Chuwez', '2025-05-19 21:44:53'),
('2569', 'ST10100320250519074506', '1446-11-21', '1.100.10', '101', 'an.DIANA RIFQOTUL QOLBI', '5000', '0', 'Chuwez', '2025-05-19 21:45:06'),
('2570', 'ST10100320250519074506', '1446-11-21', '2.220.10', '101', 'an.DIANA RIFQOTUL QOLBI', '0', '5000', 'Chuwez', '2025-05-19 21:45:06'),
('2571', 'ST10100320250519074522', '1446-11-21', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '5000', '0', 'Chuwez', '2025-05-19 21:45:22'),
('2572', 'ST10100320250519074522', '1446-11-21', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '5000', 'Chuwez', '2025-05-19 21:45:22'),
('2573', 'ST10100320250519074537', '1446-11-21', '1.100.10', '101', 'an.M. DESTRA MAULANA', '20000', '0', 'Chuwez', '2025-05-19 21:45:37'),
('2574', 'ST10100320250519074537', '1446-11-21', '2.220.10', '101', 'an.M. DESTRA MAULANA', '0', '20000', 'Chuwez', '2025-05-19 21:45:37'),
('2575', 'ST10100320250519074551', '1446-11-21', '1.100.10', '101', 'an.AHMAD ADITIYA', '5000', '0', 'Chuwez', '2025-05-19 21:45:51'),
('2576', 'ST10100320250519074551', '1446-11-21', '2.220.10', '101', 'an.AHMAD ADITIYA', '0', '5000', 'Chuwez', '2025-05-19 21:45:51'),
('2577', 'ST10100320250519074606', '1446-11-21', '1.100.10', '101', 'an.AZKA AUFARIL MINAN', '5000', '0', 'Chuwez', '2025-05-19 21:46:06'),
('2578', 'ST10100320250519074606', '1446-11-21', '2.220.10', '101', 'an.AZKA AUFARIL MINAN', '0', '5000', 'Chuwez', '2025-05-19 21:46:07'),
('2579', 'ST10100320250519074626', '1446-11-21', '1.100.10', '101', 'an.ABDUL HAMID', '2000', '0', 'Chuwez', '2025-05-19 21:46:26'),
('2580', 'ST10100320250519074626', '1446-11-21', '2.220.10', '101', 'an.ABDUL HAMID', '0', '2000', 'Chuwez', '2025-05-19 21:46:26'),
('2581', 'ST10100320250519074642', '1446-11-21', '1.100.10', '101', 'an.AHMAD RAFI SALIM', '3000', '0', 'Chuwez', '2025-05-19 21:46:42'),
('2582', 'ST10100320250519074642', '1446-11-21', '2.220.10', '101', 'an.AHMAD RAFI SALIM', '0', '3000', 'Chuwez', '2025-05-19 21:46:42'),
('2583', 'ST10100320250519074655', '1446-11-21', '1.100.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '10000', '0', 'Chuwez', '2025-05-19 21:46:55'),
('2584', 'ST10100320250519074655', '1446-11-21', '2.220.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '0', '10000', 'Chuwez', '2025-05-19 21:46:55'),
('2585', 'ST10100320250519074724', '1446-11-21', '1.100.10', '101', 'an.M. FAHMI NURUL ANAM', '10000', '0', 'Chuwez', '2025-05-19 21:47:24'),
('2586', 'ST10100320250519074724', '1446-11-21', '2.220.10', '101', 'an.M. FAHMI NURUL ANAM', '0', '10000', 'Chuwez', '2025-05-19 21:47:24'),
('2587', 'ST10100320250519074738', '1446-11-21', '1.100.10', '101', 'an.AHMAD SYAHRU ROMADHONI', '10000', '0', 'Chuwez', '2025-05-19 21:47:38'),
('2588', 'ST10100320250519074738', '1446-11-21', '2.220.10', '101', 'an.AHMAD SYAHRU ROMADHONI', '0', '10000', 'Chuwez', '2025-05-19 21:47:38'),
('2589', 'ST10100320250519074756', '1446-11-21', '1.100.10', '101', 'an.DIYANAH KAMALIYAH', '2000', '0', 'Chuwez', '2025-05-19 21:47:56'),
('2590', 'ST10100320250519074756', '1446-11-21', '2.220.10', '101', 'an.DIYANAH KAMALIYAH', '0', '2000', 'Chuwez', '2025-05-19 21:47:56'),
('2591', 'ST10100320250519074809', '1446-11-21', '1.100.10', '101', 'an.HIKMIAH PUTRI NIKMATUNNAFILAH', '5000', '0', 'Chuwez', '2025-05-19 21:48:09'),
('2592', 'ST10100320250519074809', '1446-11-21', '2.220.10', '101', 'an.HIKMIAH PUTRI NIKMATUNNAFILAH', '0', '5000', 'Chuwez', '2025-05-19 21:48:09'),
('2593', 'ST10100320250519074821', '1446-11-21', '1.100.10', '101', 'an.SITI QURROTUL AINI', '2000', '0', 'Chuwez', '2025-05-19 21:48:21'),
('2594', 'ST10100320250519074821', '1446-11-21', '2.220.10', '101', 'an.SITI QURROTUL AINI', '0', '2000', 'Chuwez', '2025-05-19 21:48:21'),
('2595', 'ST10100320250519074833', '1446-11-21', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '10000', '0', 'Chuwez', '2025-05-19 21:48:33'),
('2596', 'ST10100320250519074833', '1446-11-21', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '10000', 'Chuwez', '2025-05-19 21:48:33'),
('2597', 'ST10100320250519074847', '1446-11-21', '1.100.10', '101', 'an.SITI ATHIUR ROHMAH', '5000', '0', 'Chuwez', '2025-05-19 21:48:47'),
('2598', 'ST10100320250519074847', '1446-11-21', '2.220.10', '101', 'an.SITI ATHIUR ROHMAH', '0', '5000', 'Chuwez', '2025-05-19 21:48:47'),
('2599', 'ST10100320250519074910', '1446-11-21', '1.100.10', '101', 'an.MUHAMMAD ILHAM', '5000', '0', 'Chuwez', '2025-05-19 21:49:10'),
('2600', 'ST10100320250519074910', '1446-11-21', '2.220.10', '101', 'an.MUHAMMAD ILHAM', '0', '5000', 'Chuwez', '2025-05-19 21:49:10'),
('2601', 'ST10100320250519074922', '1446-11-21', '1.100.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '20000', '0', 'Chuwez', '2025-05-19 21:49:22'),
('2602', 'ST10100320250519074922', '1446-11-21', '2.220.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '0', '20000', 'Chuwez', '2025-05-19 21:49:22'),
('2603', 'ST10100320250519074934', '1446-11-21', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '2000', '0', 'Chuwez', '2025-05-19 21:49:34'),
('2604', 'ST10100320250519074934', '1446-11-21', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '2000', 'Chuwez', '2025-05-19 21:49:34'),
('2605', 'ST10100320250519074951', '1446-11-21', '1.100.10', '101', 'an.M. KAMALUDDIN', '20000', '0', 'Chuwez', '2025-05-19 21:49:51'),
('2606', 'ST10100320250519074951', '1446-11-21', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '20000', 'Chuwez', '2025-05-19 21:49:51'),
('2607', 'ST10100320250519075004', '1446-11-21', '1.100.10', '101', 'an.NABILATUN NISAUL UMMAH', '20000', '0', 'Chuwez', '2025-05-19 21:50:04'),
('2608', 'ST10100320250519075004', '1446-11-21', '2.220.10', '101', 'an.NABILATUN NISAUL UMMAH', '0', '20000', 'Chuwez', '2025-05-19 21:50:04'),
('2609', 'ST10100320250519075018', '1446-11-21', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '10000', '0', 'Chuwez', '2025-05-19 21:50:18'),
('2610', 'ST10100320250519075018', '1446-11-21', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '10000', 'Chuwez', '2025-05-19 21:50:18'),
('2611', 'ST10100320250519075033', '1446-11-21', '1.100.10', '101', 'an.IZZA BILLAH', '20000', '0', 'Chuwez', '2025-05-19 21:50:33'),
('2612', 'ST10100320250519075033', '1446-11-21', '2.220.10', '101', 'an.IZZA BILLAH', '0', '20000', 'Chuwez', '2025-05-19 21:50:33'),
('2613', 'ST10100320250519075048', '1446-11-21', '1.100.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '10000', '0', 'Chuwez', '2025-05-19 21:50:48'),
('2614', 'ST10100320250519075048', '1446-11-21', '2.220.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '0', '10000', 'Chuwez', '2025-05-19 21:50:48'),
('2615', 'ST10100320250519075100', '1446-11-21', '1.100.10', '101', 'an.RAUDHOTUL JANNAH', '20000', '0', 'Chuwez', '2025-05-19 21:51:00'),
('2616', 'ST10100320250519075100', '1446-11-21', '2.220.10', '101', 'an.RAUDHOTUL JANNAH', '0', '20000', 'Chuwez', '2025-05-19 21:51:00'),
('2617', 'ST10100320250519075118', '1446-11-21', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Chuwez', '2025-05-19 21:51:18'),
('2618', 'ST10100320250519075118', '1446-11-21', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Chuwez', '2025-05-19 21:51:18'),
('2619', 'ST10100320250519075152', '1446-11-21', '1.100.10', '101', 'an.MOCH KHOTIBUL UMAM', '50000', '0', 'Chuwez', '2025-05-19 21:51:52'),
('2620', 'ST10100320250519075152', '1446-11-21', '2.220.10', '101', 'an.MOCH KHOTIBUL UMAM', '0', '50000', 'Chuwez', '2025-05-19 21:51:52'),
('2621', 'ST10100320250519075205', '1446-11-21', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '5000', '0', 'Chuwez', '2025-05-19 21:52:05'),
('2622', 'ST10100320250519075205', '1446-11-21', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '5000', 'Chuwez', '2025-05-19 21:52:05'),
('2623', 'ST10100320250519075226', '1446-11-21', '1.100.10', '101', 'an.BILQIS THALIA HASNA', '60000', '0', 'Chuwez', '2025-05-19 21:52:26'),
('2624', 'ST10100320250519075226', '1446-11-21', '2.220.10', '101', 'an.BILQIS THALIA HASNA', '0', '60000', 'Chuwez', '2025-05-19 21:52:26'),
('2625', 'ST10100320250519075244', '1446-11-21', '1.100.10', '101', 'an.SINDI RAISA PUTRI', '10000', '0', 'Chuwez', '2025-05-19 21:52:44'),
('2626', 'ST10100320250519075244', '1446-11-21', '2.220.10', '101', 'an.SINDI RAISA PUTRI', '0', '10000', 'Chuwez', '2025-05-19 21:52:44'),
('2627', 'ST10100320250519075311', '1446-11-21', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '25000', '0', 'Chuwez', '2025-05-19 21:53:11'),
('2628', 'ST10100320250519075311', '1446-11-21', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '25000', 'Chuwez', '2025-05-19 21:53:11'),
('2629', 'ST10100320250519075334', '1446-11-21', '1.100.10', '101', 'an.AKHMAD FIKRI HAIKAL', '50000', '0', 'Chuwez', '2025-05-19 21:53:34'),
('2630', 'ST10100320250519075334', '1446-11-21', '2.220.10', '101', 'an.AKHMAD FIKRI HAIKAL', '0', '50000', 'Chuwez', '2025-05-19 21:53:34'),
('2631', 'ST10100320250519075359', '1446-11-21', '1.100.10', '101', 'an.M. ROFIQ', '50000', '0', 'Chuwez', '2025-05-19 21:53:59'),
('2632', 'ST10100320250519075359', '1446-11-21', '2.220.10', '101', 'an.M. ROFIQ', '0', '50000', 'Chuwez', '2025-05-19 21:53:59'),
('2633', 'ST10100320250519075414', '1446-11-21', '1.100.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '5000', '0', 'Chuwez', '2025-05-19 21:54:14'),
('2634', 'ST10100320250519075414', '1446-11-21', '2.220.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '0', '5000', 'Chuwez', '2025-05-19 21:54:14'),
('2635', 'ST10100320250519075428', '1446-11-21', '1.100.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '10000', '0', 'Chuwez', '2025-05-19 21:54:28'),
('2636', 'ST10100320250519075428', '1446-11-21', '2.220.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '0', '10000', 'Chuwez', '2025-05-19 21:54:28'),
('2637', 'ST10100320250519075445', '1446-11-21', '1.100.10', '101', 'an.AHMAD JAMALUL MAIMUN', '5000', '0', 'Chuwez', '2025-05-19 21:54:46'),
('2638', 'ST10100320250519075445', '1446-11-21', '2.220.10', '101', 'an.AHMAD JAMALUL MAIMUN', '0', '5000', 'Chuwez', '2025-05-19 21:54:46'),
('2639', 'ST10100320250519075459', '1446-11-21', '1.100.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '5000', '0', 'Chuwez', '2025-05-19 21:54:59'),
('2640', 'ST10100320250519075459', '1446-11-21', '2.220.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '0', '5000', 'Chuwez', '2025-05-19 21:54:59'),
('2641', 'ST10100320250519075513', '1446-11-21', '1.100.10', '101', 'an.AHMAD ABBAS MAULANA', '3000', '0', 'Chuwez', '2025-05-19 21:55:13'),
('2642', 'ST10100320250519075513', '1446-11-21', '2.220.10', '101', 'an.AHMAD ABBAS MAULANA', '0', '3000', 'Chuwez', '2025-05-19 21:55:13'),
('2643', 'ST10100320250519075531', '1446-11-21', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '2000', '0', 'Chuwez', '2025-05-19 21:55:31'),
('2644', 'ST10100320250519075531', '1446-11-21', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '2000', 'Chuwez', '2025-05-19 21:55:31'),
('2645', 'ST10100320250519075544', '1446-11-21', '1.100.10', '101', 'an.ANA SALSABILA', '5000', '0', 'Chuwez', '2025-05-19 21:55:44'),
('2646', 'ST10100320250519075544', '1446-11-21', '2.220.10', '101', 'an.ANA SALSABILA', '0', '5000', 'Chuwez', '2025-05-19 21:55:44'),
('2647', 'ST10100320250519075600', '1446-11-21', '1.100.10', '101', 'an.ZAKIYATUL UMMAH', '2000', '0', 'Chuwez', '2025-05-19 21:56:00'),
('2648', 'ST10100320250519075600', '1446-11-21', '2.220.10', '101', 'an.ZAKIYATUL UMMAH', '0', '2000', 'Chuwez', '2025-05-19 21:56:00'),
('2649', 'ST10100320250519075615', '1446-11-21', '1.100.10', '101', 'an.AFANDI', '2000', '0', 'Chuwez', '2025-05-19 21:56:15'),
('2650', 'ST10100320250519075615', '1446-11-21', '2.220.10', '101', 'an.AFANDI', '0', '2000', 'Chuwez', '2025-05-19 21:56:15'),
('2651', 'ST10100320250519075628', '1446-11-21', '1.100.10', '101', 'an.MUHAMMAD KHOIRON', '2000', '0', 'Chuwez', '2025-05-19 21:56:28'),
('2652', 'ST10100320250519075628', '1446-11-21', '2.220.10', '101', 'an.MUHAMMAD KHOIRON', '0', '2000', 'Chuwez', '2025-05-19 21:56:29'),
('2653', 'ST10100320250519075641', '1446-11-21', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '5000', '0', 'Chuwez', '2025-05-19 21:56:42'),
('2654', 'ST10100320250519075641', '1446-11-21', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '5000', 'Chuwez', '2025-05-19 21:56:42'),
('2655', 'ST10100320250519075657', '1446-11-21', '1.100.10', '101', 'an.MUHAMMAD YAHYA SYAKARUDDIN', '4000', '0', 'Chuwez', '2025-05-19 21:56:57'),
('2656', 'ST10100320250519075657', '1446-11-21', '2.220.10', '101', 'an.MUHAMMAD YAHYA SYAKARUDDIN', '0', '4000', 'Chuwez', '2025-05-19 21:56:57'),
('2657', 'ST10100320250519075719', '1446-11-21', '1.100.10', '101', 'an.SAFIRATUL JANNAH', '10000', '0', 'Chuwez', '2025-05-19 21:57:19'),
('2658', 'ST10100320250519075719', '1446-11-21', '2.220.10', '101', 'an.SAFIRATUL JANNAH', '0', '10000', 'Chuwez', '2025-05-19 21:57:19'),
('2659', 'ST10100320250519075733', '1446-11-21', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '5000', '0', 'Chuwez', '2025-05-19 21:57:33'),
('2660', 'ST10100320250519075733', '1446-11-21', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '5000', 'Chuwez', '2025-05-19 21:57:33'),
('2661', 'ST10100320250519075749', '1446-11-21', '1.100.10', '101', 'an.ACH. JUNAIDI', '5000', '0', 'Chuwez', '2025-05-19 21:57:49'),
('2662', 'ST10100320250519075749', '1446-11-21', '2.220.10', '101', 'an.ACH. JUNAIDI', '0', '5000', 'Chuwez', '2025-05-19 21:57:49'),
('2663', 'ST10100320250519075818', '1446-11-21', '1.100.10', '101', 'an.HILYA', '10000', '0', 'Chuwez', '2025-05-19 21:58:18'),
('2664', 'ST10100320250519075818', '1446-11-21', '2.220.10', '101', 'an.HILYA', '0', '10000', 'Chuwez', '2025-05-19 21:58:19'),
('2665', 'ST10100320250519075840', '1446-11-21', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'Chuwez', '2025-05-19 21:58:40'),
('2666', 'ST10100320250519075840', '1446-11-21', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'Chuwez', '2025-05-19 21:58:40'),
('2667', 'ST10100320250519075901', '1446-11-21', '1.100.10', '101', 'an.MACHMUDAH', '10000', '0', 'Chuwez', '2025-05-19 21:59:01'),
('2668', 'ST10100320250519075901', '1446-11-21', '2.220.10', '101', 'an.MACHMUDAH', '0', '10000', 'Chuwez', '2025-05-19 21:59:01'),
('2669', 'ST10100320250519080251', '1446-11-21', '1.100.10', '101', 'an.AMARA', '20000', '0', 'Chuwez', '2025-05-19 22:02:51'),
('2670', 'ST10100320250519080251', '1446-11-21', '2.220.10', '101', 'an.AMARA', '0', '20000', 'Chuwez', '2025-05-19 22:02:52'),
('2671', 'ST10100320250520073749', '1446-11-22', '1.100.10', '101', 'an.NAILATUN NIAMI', '2000', '0', 'Chuwez', '2025-05-20 21:37:49'),
('2672', 'ST10100320250520073749', '1446-11-22', '2.220.10', '101', 'an.NAILATUN NIAMI', '0', '2000', 'Chuwez', '2025-05-20 21:37:49'),
('2673', 'ST10100320250520073826', '1446-11-22', '1.100.10', '101', 'an.UMAR FARUQ', '5000', '0', 'Chuwez', '2025-05-20 21:38:26'),
('2674', 'ST10100320250520073826', '1446-11-22', '2.220.10', '101', 'an.UMAR FARUQ', '0', '5000', 'Chuwez', '2025-05-20 21:38:26'),
('2675', 'ST10100320250520073849', '1446-11-22', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'Chuwez', '2025-05-20 21:38:49'),
('2676', 'ST10100320250520073849', '1446-11-22', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'Chuwez', '2025-05-20 21:38:49'),
('2677', 'ST10100320250520073913', '1446-11-22', '1.100.10', '101', 'an.MARIATUL QIBTIYAH', '2000', '0', 'Chuwez', '2025-05-20 21:39:13'),
('2678', 'ST10100320250520073913', '1446-11-22', '2.220.10', '101', 'an.MARIATUL QIBTIYAH', '0', '2000', 'Chuwez', '2025-05-20 21:39:13'),
('2679', 'ST10100320250520073937', '1446-11-22', '1.100.10', '101', 'an.MARIYATUL QIBTIYAH', '5000', '0', 'Chuwez', '2025-05-20 21:39:37'),
('2680', 'ST10100320250520073937', '1446-11-22', '2.220.10', '101', 'an.MARIYATUL QIBTIYAH', '0', '5000', 'Chuwez', '2025-05-20 21:39:37'),
('2681', 'ST10100320250520074038', '1446-11-22', '1.100.10', '101', 'an.SITI ISTIFAIYAH', '100000', '0', 'Chuwez', '2025-05-20 21:40:38'),
('2682', 'ST10100320250520074038', '1446-11-22', '2.220.10', '101', 'an.SITI ISTIFAIYAH', '0', '100000', 'Chuwez', '2025-05-20 21:40:39'),
('2683', 'ST10100320250520074106', '1446-11-22', '1.100.10', '101', 'an.FAIZAH NURUL LITA', '10000', '0', 'Chuwez', '2025-05-20 21:41:06'),
('2684', 'ST10100320250520074106', '1446-11-22', '2.220.10', '101', 'an.FAIZAH NURUL LITA', '0', '10000', 'Chuwez', '2025-05-20 21:41:06'),
('2685', 'ST10100320250520074427', '1446-11-22', '1.100.10', '101', 'an.MUHAMMAD ALWI', '5000', '0', 'Chuwez', '2025-05-20 21:44:27'),
('2686', 'ST10100320250520074427', '1446-11-22', '2.220.10', '101', 'an.MUHAMMAD ALWI', '0', '5000', 'Chuwez', '2025-05-20 21:44:27'),
('2687', 'ST10100320250520074505', '1446-11-22', '1.100.10', '101', 'an.UBAIDAH', '10000', '0', 'Chuwez', '2025-05-20 21:45:05'),
('2688', 'ST10100320250520074505', '1446-11-22', '2.220.10', '101', 'an.UBAIDAH', '0', '10000', 'Chuwez', '2025-05-20 21:45:05'),
('2689', 'ST10100320250520074528', '1446-11-22', '1.100.10', '101', 'an.RAISA ANNISA', '5000', '0', 'Chuwez', '2025-05-20 21:45:28'),
('2690', 'ST10100320250520074528', '1446-11-22', '2.220.10', '101', 'an.RAISA ANNISA', '0', '5000', 'Chuwez', '2025-05-20 21:45:28'),
('2691', 'ST10100320250520074605', '1446-11-22', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '5000', '0', 'Chuwez', '2025-05-20 21:46:05'),
('2692', 'ST10100320250520074605', '1446-11-22', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '5000', 'Chuwez', '2025-05-20 21:46:06'),
('2693', 'ST10100320250520074643', '1446-11-22', '1.100.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '4000', '0', 'Chuwez', '2025-05-20 21:46:43'),
('2694', 'ST10100320250520074643', '1446-11-22', '2.220.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '0', '4000', 'Chuwez', '2025-05-20 21:46:43'),
('2695', 'ST10100320250520074721', '1446-11-22', '1.100.10', '101', 'an.SAUQY AHMAD', '15000', '0', 'Chuwez', '2025-05-20 21:47:21'),
('2696', 'ST10100320250520074721', '1446-11-22', '2.220.10', '101', 'an.SAUQY AHMAD', '0', '15000', 'Chuwez', '2025-05-20 21:47:21'),
('2697', 'ST10100320250520074910', '1446-11-22', '1.100.10', '101', 'an.SITI SHOFIYAH LABIBAH', '20000', '0', 'Chuwez', '2025-05-20 21:49:10'),
('2698', 'ST10100320250520074910', '1446-11-22', '2.220.10', '101', 'an.SITI SHOFIYAH LABIBAH', '0', '20000', 'Chuwez', '2025-05-20 21:49:10'),
('2699', 'ST10100320250520075009', '1446-11-22', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '5000', '0', 'Chuwez', '2025-05-20 21:50:09'),
('2700', 'ST10100320250520075009', '1446-11-22', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '5000', 'Chuwez', '2025-05-20 21:50:09'),
('2701', 'ST10100320250520075041', '1446-11-22', '1.100.10', '101', 'an.HAIKAL SHOMADANI', '2000', '0', 'Chuwez', '2025-05-20 21:50:41'),
('2702', 'ST10100320250520075041', '1446-11-22', '2.220.10', '101', 'an.HAIKAL SHOMADANI', '0', '2000', 'Chuwez', '2025-05-20 21:50:41'),
('2703', 'ST10100320250520075059', '1446-11-22', '1.100.10', '101', 'an.M. ABD. HADI', '2000', '0', 'Chuwez', '2025-05-20 21:50:59'),
('2704', 'ST10100320250520075059', '1446-11-22', '2.220.10', '101', 'an.M. ABD. HADI', '0', '2000', 'Chuwez', '2025-05-20 21:50:59'),
('2705', 'ST10100320250520075122', '1446-11-22', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'Chuwez', '2025-05-20 21:51:22'),
('2706', 'ST10100320250520075122', '1446-11-22', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'Chuwez', '2025-05-20 21:51:22'),
('2707', 'ST10100320250520075144', '1446-11-22', '1.100.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '5000', '0', 'Chuwez', '2025-05-20 21:51:44'),
('2708', 'ST10100320250520075144', '1446-11-22', '2.220.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '0', '5000', 'Chuwez', '2025-05-20 21:51:44'),
('2709', 'ST10100320250520075207', '1446-11-22', '1.100.10', '101', 'an.AULIA AZZAHRA', '2000', '0', 'Chuwez', '2025-05-20 21:52:07'),
('2710', 'ST10100320250520075207', '1446-11-22', '2.220.10', '101', 'an.AULIA AZZAHRA', '0', '2000', 'Chuwez', '2025-05-20 21:52:07'),
('2711', 'ST10100320250520075302', '1446-11-22', '1.100.10', '101', 'an.ALFI NURDIANA', '5000', '0', 'Chuwez', '2025-05-20 21:53:02'),
('2712', 'ST10100320250520075302', '1446-11-22', '2.220.10', '101', 'an.ALFI NURDIANA', '0', '5000', 'Chuwez', '2025-05-20 21:53:02'),
('2713', 'ST10100320250520075331', '1446-11-22', '1.100.10', '101', 'an.AZKA AUFARIL MINAN', '10000', '0', 'Chuwez', '2025-05-20 21:53:31'),
('2714', 'ST10100320250520075331', '1446-11-22', '2.220.10', '101', 'an.AZKA AUFARIL MINAN', '0', '10000', 'Chuwez', '2025-05-20 21:53:31'),
('2715', 'ST10100320250520075518', '1446-11-22', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '15000', '0', 'Chuwez', '2025-05-20 21:55:18'),
('2716', 'ST10100320250520075518', '1446-11-22', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '15000', 'Chuwez', '2025-05-20 21:55:18'),
('2717', 'ST10100320250520075546', '1446-11-22', '1.100.10', '101', 'an.M. DESTRA MAULANA', '30000', '0', 'Chuwez', '2025-05-20 21:55:46'),
('2718', 'ST10100320250520075546', '1446-11-22', '2.220.10', '101', 'an.M. DESTRA MAULANA', '0', '30000', 'Chuwez', '2025-05-20 21:55:46'),
('2719', 'ST10100320250520075613', '1446-11-22', '1.100.10', '101', 'an.AISYAH', '2000', '0', 'Chuwez', '2025-05-20 21:56:13'),
('2720', 'ST10100320250520075613', '1446-11-22', '2.220.10', '101', 'an.AISYAH', '0', '2000', 'Chuwez', '2025-05-20 21:56:13'),
('2721', 'ST10100320250520075638', '1446-11-22', '1.100.10', '101', 'an.LAILATUL MAGHFIROH', '15000', '0', 'Chuwez', '2025-05-20 21:56:38'),
('2722', 'ST10100320250520075638', '1446-11-22', '2.220.10', '101', 'an.LAILATUL MAGHFIROH', '0', '15000', 'Chuwez', '2025-05-20 21:56:38'),
('2723', 'ST10100320250520075806', '1446-11-22', '1.100.10', '101', 'an.M. FAHMI NURUL ANAM', '10000', '0', 'Chuwez', '2025-05-20 21:58:06'),
('2724', 'ST10100320250520075806', '1446-11-22', '2.220.10', '101', 'an.M. FAHMI NURUL ANAM', '0', '10000', 'Chuwez', '2025-05-20 21:58:07'),
('2725', 'ST10100320250520075835', '1446-11-22', '1.100.10', '101', 'an.WARDATUL JANNAH', '2000', '0', 'Chuwez', '2025-05-20 21:58:35'),
('2726', 'ST10100320250520075835', '1446-11-22', '2.220.10', '101', 'an.WARDATUL JANNAH', '0', '2000', 'Chuwez', '2025-05-20 21:58:35'),
('2727', 'ST10100320250520075904', '1446-11-22', '1.100.10', '101', 'an.SITI ATHIUR ROHMAH', '5000', '0', 'Chuwez', '2025-05-20 21:59:04'),
('2728', 'ST10100320250520075904', '1446-11-22', '2.220.10', '101', 'an.SITI ATHIUR ROHMAH', '0', '5000', 'Chuwez', '2025-05-20 21:59:04'),
('2729', 'ST10100320250520075934', '1446-11-22', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '10000', '0', 'Chuwez', '2025-05-20 21:59:34'),
('2730', 'ST10100320250520075934', '1446-11-22', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '10000', 'Chuwez', '2025-05-20 21:59:34'),
('2731', 'ST10100320250520075953', '1446-11-22', '1.100.10', '101', 'an.SITI QURROTUL AINI', '2000', '0', 'Chuwez', '2025-05-20 21:59:53'),
('2732', 'ST10100320250520075953', '1446-11-22', '2.220.10', '101', 'an.SITI QURROTUL AINI', '0', '2000', 'Chuwez', '2025-05-20 21:59:53'),
('2733', 'ST10100320250520080014', '1446-11-22', '1.100.10', '101', 'an.AHMAD SYAHRU ROMADHONI', '10000', '0', 'Chuwez', '2025-05-20 22:00:14'),
('2734', 'ST10100320250520080014', '1446-11-22', '2.220.10', '101', 'an.AHMAD SYAHRU ROMADHONI', '0', '10000', 'Chuwez', '2025-05-20 22:00:14'),
('2735', 'ST10100320250520080033', '1446-11-22', '1.100.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '10000', '0', 'Chuwez', '2025-05-20 22:00:33'),
('2736', 'ST10100320250520080033', '1446-11-22', '2.220.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '0', '10000', 'Chuwez', '2025-05-20 22:00:33'),
('2737', 'ST10100320250520080052', '1446-11-22', '1.100.10', '101', 'an.KHOIRIYAH', '10000', '0', 'Chuwez', '2025-05-20 22:00:52'),
('2738', 'ST10100320250520080052', '1446-11-22', '2.220.10', '101', 'an.KHOIRIYAH', '0', '10000', 'Chuwez', '2025-05-20 22:00:52'),
('2739', 'ST10100320250520080116', '1446-11-22', '1.100.10', '101', 'an.ABDUL HAMID', '2000', '0', 'Chuwez', '2025-05-20 22:01:16'),
('2740', 'ST10100320250520080116', '1446-11-22', '2.220.10', '101', 'an.ABDUL HAMID', '0', '2000', 'Chuwez', '2025-05-20 22:01:16'),
('2741', 'ST10100320250520080140', '1446-11-22', '1.100.10', '101', 'an.MIFTAHUL JANNAH', '50000', '0', 'Chuwez', '2025-05-20 22:01:40'),
('2742', 'ST10100320250520080140', '1446-11-22', '2.220.10', '101', 'an.MIFTAHUL JANNAH', '0', '50000', 'Chuwez', '2025-05-20 22:01:40'),
('2743', 'ST10100320250520080211', '1446-11-22', '1.100.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '10000', '0', 'Chuwez', '2025-05-20 22:02:11'),
('2744', 'ST10100320250520080211', '1446-11-22', '2.220.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '0', '10000', 'Chuwez', '2025-05-20 22:02:11'),
('2745', 'ST10100320250520080232', '1446-11-22', '1.100.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '5000', '0', 'Chuwez', '2025-05-20 22:02:32'),
('2746', 'ST10100320250520080232', '1446-11-22', '2.220.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '0', '5000', 'Chuwez', '2025-05-20 22:02:32'),
('2747', 'ST10100320250520080300', '1446-11-22', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '5000', '0', 'Chuwez', '2025-05-20 22:03:00'),
('2748', 'ST10100320250520080300', '1446-11-22', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '5000', 'Chuwez', '2025-05-20 22:03:00'),
('2749', 'ST10100320250520080330', '1446-11-22', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Chuwez', '2025-05-20 22:03:30'),
('2750', 'ST10100320250520080330', '1446-11-22', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Chuwez', '2025-05-20 22:03:31'),
('2751', 'ST10100320250520080407', '1446-11-22', '1.100.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '5000', '0', 'Chuwez', '2025-05-20 22:04:08'),
('2752', 'ST10100320250520080407', '1446-11-22', '2.220.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '0', '5000', 'Chuwez', '2025-05-20 22:04:08'),
('2753', 'ST10100320250520080431', '1446-11-22', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '2000', '0', 'Chuwez', '2025-05-20 22:04:31'),
('2754', 'ST10100320250520080431', '1446-11-22', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '2000', 'Chuwez', '2025-05-20 22:04:31'),
('2755', 'ST10100320250520080508', '1446-11-22', '1.100.10', '101', 'an.M. KAMALUDDIN', '20000', '0', 'Chuwez', '2025-05-20 22:05:08'),
('2756', 'ST10100320250520080508', '1446-11-22', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '20000', 'Chuwez', '2025-05-20 22:05:08'),
('2757', 'ST10100320250520080531', '1446-11-22', '1.100.10', '101', 'an.NABILATUN NISAUL UMMAH', '20000', '0', 'Chuwez', '2025-05-20 22:05:31'),
('2758', 'ST10100320250520080531', '1446-11-22', '2.220.10', '101', 'an.NABILATUN NISAUL UMMAH', '0', '20000', 'Chuwez', '2025-05-20 22:05:31'),
('2759', 'ST10100320250520080556', '1446-11-22', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '10000', '0', 'Chuwez', '2025-05-20 22:05:56'),
('2760', 'ST10100320250520080556', '1446-11-22', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '10000', 'Chuwez', '2025-05-20 22:05:56'),
('2761', 'ST10100320250520080659', '1446-11-22', '1.100.10', '101', 'an.AHMAD ABBAS MAULANA', '4000', '0', 'Chuwez', '2025-05-20 22:06:59'),
('2762', 'ST10100320250520080659', '1446-11-22', '2.220.10', '101', 'an.AHMAD ABBAS MAULANA', '0', '4000', 'Chuwez', '2025-05-20 22:06:59'),
('2763', 'ST10100320250520080731', '1446-11-22', '1.100.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '5000', '0', 'Chuwez', '2025-05-20 22:07:31'),
('2764', 'ST10100320250520080731', '1446-11-22', '2.220.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '0', '5000', 'Chuwez', '2025-05-20 22:07:31'),
('2765', 'ST10100320250520080750', '1446-11-22', '1.100.10', '101', 'an.AHMAD JAMALUL MAIMUN', '5000', '0', 'Chuwez', '2025-05-20 22:07:50'),
('2766', 'ST10100320250520080750', '1446-11-22', '2.220.10', '101', 'an.AHMAD JAMALUL MAIMUN', '0', '5000', 'Chuwez', '2025-05-20 22:07:50'),
('2767', 'ST10100320250520080813', '1446-11-22', '1.100.10', '101', 'an.SINDI RAISA PUTRI', '10000', '0', 'Chuwez', '2025-05-20 22:08:13'),
('2768', 'ST10100320250520080813', '1446-11-22', '2.220.10', '101', 'an.SINDI RAISA PUTRI', '0', '10000', 'Chuwez', '2025-05-20 22:08:13'),
('2769', 'ST10100320250520080837', '1446-11-22', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '25000', '0', 'Chuwez', '2025-05-20 22:08:37'),
('2770', 'ST10100320250520080837', '1446-11-22', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '25000', 'Chuwez', '2025-05-20 22:08:37'),
('2771', 'ST10100320250520080906', '1446-11-22', '1.100.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '5000', '0', 'Chuwez', '2025-05-20 22:09:06'),
('2772', 'ST10100320250520080906', '1446-11-22', '2.220.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '0', '5000', 'Chuwez', '2025-05-20 22:09:06'),
('2773', 'ST10100320250520080930', '1446-11-22', '1.100.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '10000', '0', 'Chuwez', '2025-05-20 22:09:30'),
('2774', 'ST10100320250520080930', '1446-11-22', '2.220.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '0', '10000', 'Chuwez', '2025-05-20 22:09:30'),
('2775', 'ST10100320250520080953', '1446-11-22', '1.100.10', '101', 'an.BILQIS THALIA HASNA', '60000', '0', 'Chuwez', '2025-05-20 22:09:53'),
('2776', 'ST10100320250520080953', '1446-11-22', '2.220.10', '101', 'an.BILQIS THALIA HASNA', '0', '60000', 'Chuwez', '2025-05-20 22:09:53'),
('2777', 'ST10100320250520081355', '1446-11-22', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '2000', '0', 'Chuwez', '2025-05-20 22:13:55'),
('2778', 'ST10100320250520081355', '1446-11-22', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '2000', 'Chuwez', '2025-05-20 22:13:55'),
('2779', 'ST10100320250520081415', '1446-11-22', '1.100.10', '101', 'an.ZAKIYATUL UMMAH', '2000', '0', 'Chuwez', '2025-05-20 22:14:15'),
('2780', 'ST10100320250520081415', '1446-11-22', '2.220.10', '101', 'an.ZAKIYATUL UMMAH', '0', '2000', 'Chuwez', '2025-05-20 22:14:15'),
('2781', 'ST10100320250520081438', '1446-11-22', '1.100.10', '101', 'an.AFANDI', '2000', '0', 'Chuwez', '2025-05-20 22:14:38'),
('2782', 'ST10100320250520081438', '1446-11-22', '2.220.10', '101', 'an.AFANDI', '0', '2000', 'Chuwez', '2025-05-20 22:14:38'),
('2783', 'ST10100320250520081500', '1446-11-22', '1.100.10', '101', 'an.M. ALIFIN FIKRI', '2000', '0', 'Chuwez', '2025-05-20 22:15:00'),
('2784', 'ST10100320250520081500', '1446-11-22', '2.220.10', '101', 'an.M. ALIFIN FIKRI', '0', '2000', 'Chuwez', '2025-05-20 22:15:00'),
('2785', 'ST10100320250520081529', '1446-11-22', '1.100.10', '101', 'an.MUHAMMAD KHOIRON', '2000', '0', 'Chuwez', '2025-05-20 22:15:29'),
('2786', 'ST10100320250520081529', '1446-11-22', '2.220.10', '101', 'an.MUHAMMAD KHOIRON', '0', '2000', 'Chuwez', '2025-05-20 22:15:29'),
('2787', 'ST10100320250520081616', '1446-11-22', '1.100.10', '101', 'an.SAFIRATUL JANNAH', '20000', '0', 'Chuwez', '2025-05-20 22:16:16'),
('2788', 'ST10100320250520081616', '1446-11-22', '2.220.10', '101', 'an.SAFIRATUL JANNAH', '0', '20000', 'Chuwez', '2025-05-20 22:16:16'),
('2789', 'ST10100320250520081642', '1446-11-22', '1.100.10', '101', 'an.ACH. JUNAIDI', '5000', '0', 'Chuwez', '2025-05-20 22:16:42'),
('2790', 'ST10100320250520081642', '1446-11-22', '2.220.10', '101', 'an.ACH. JUNAIDI', '0', '5000', 'Chuwez', '2025-05-20 22:16:42'),
('2791', 'ST10100320250520081700', '1446-11-22', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '5000', '0', 'Chuwez', '2025-05-20 22:17:00'),
('2792', 'ST10100320250520081700', '1446-11-22', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '5000', 'Chuwez', '2025-05-20 22:17:00'),
('2793', 'ST10100320250520081723', '1446-11-22', '1.100.10', '101', 'an.M. ZIDAN RIZQI SALIM', '5000', '0', 'Chuwez', '2025-05-20 22:17:23'),
('2794', 'ST10100320250520081723', '1446-11-22', '2.220.10', '101', 'an.M. ZIDAN RIZQI SALIM', '0', '5000', 'Chuwez', '2025-05-20 22:17:23'),
('2795', 'ST10100320250520081746', '1446-11-22', '1.100.10', '101', 'an.HILYA', '20000', '0', 'Chuwez', '2025-05-20 22:17:46'),
('2796', 'ST10100320250520081746', '1446-11-22', '2.220.10', '101', 'an.HILYA', '0', '20000', 'Chuwez', '2025-05-20 22:17:47'),
('2797', 'ST10100320250520081819', '1446-11-22', '1.100.10', '101', 'an.HAMIDAH', '20000', '0', 'Chuwez', '2025-05-20 22:18:19'),
('2798', 'ST10100320250520081819', '1446-11-22', '2.220.10', '101', 'an.HAMIDAH', '0', '20000', 'Chuwez', '2025-05-20 22:18:20'),
('2799', 'ST10100320250520081903', '1446-11-22', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'Chuwez', '2025-05-20 22:19:03'),
('2800', 'ST10100320250520081903', '1446-11-22', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'Chuwez', '2025-05-20 22:19:04'),
('2801', 'ST10100320250520093324', '1446-11-22', '1.100.10', '101', 'an.AMARA', '10000', '0', 'Chuwez', '2025-05-20 23:33:24'),
('2802', 'ST10100320250520093324', '1446-11-22', '2.220.10', '101', 'an.AMARA', '0', '10000', 'Chuwez', '2025-05-20 23:33:24'),
('2803', 'KK10100320250520165334', '1446-11-22', '5.520.42', '101', 'Gorengan dan cilok', '15000', '0', 'Chuwez', '2025-05-20 16:53:59'),
('2804', 'KK10100320250520165334', '1446-11-22', '1.100.10', '101', 'Gorengan dan cilok', '0', '15000', 'Chuwez', '2025-05-20 16:53:59'),
('2805', 'KK10100320250520165334', '1446-11-21', '5.520.42', '101', 'cilok', '5000', '0', 'Chuwez', '2025-05-20 16:54:18'),
('2806', 'KK10100320250520165334', '1446-11-21', '1.100.10', '101', 'cilok', '0', '5000', 'Chuwez', '2025-05-20 16:54:18'),
('2807', 'ST10100320250521074157', '1446-11-23', '1.100.10', '101', 'an.SITI SHOFIYAH LABIBAH', '130000', '0', 'Chuwez', '2025-05-21 21:41:57'),
('2808', 'ST10100320250521074157', '1446-11-23', '2.220.10', '101', 'an.SITI SHOFIYAH LABIBAH', '0', '130000', 'Chuwez', '2025-05-21 21:41:57'),
('2809', 'ST10100320250521074213', '1446-11-23', '1.100.10', '101', 'an.AULIA AZZAHRA', '2000', '0', 'Chuwez', '2025-05-21 21:42:13'),
('2810', 'ST10100320250521074213', '1446-11-23', '2.220.10', '101', 'an.AULIA AZZAHRA', '0', '2000', 'Chuwez', '2025-05-21 21:42:13'),
('2811', 'ST10100320250521074234', '1446-11-23', '1.100.10', '101', 'an.NAURA BILADINA', '7000', '0', 'Chuwez', '2025-05-21 21:42:34'),
('2812', 'ST10100320250521074234', '1446-11-23', '2.220.10', '101', 'an.NAURA BILADINA', '0', '7000', 'Chuwez', '2025-05-21 21:42:34'),
('2813', 'ST10100320250521074249', '1446-11-23', '1.100.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '10000', '0', 'Chuwez', '2025-05-21 21:42:49'),
('2814', 'ST10100320250521074249', '1446-11-23', '2.220.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '0', '10000', 'Chuwez', '2025-05-21 21:42:49'),
('2815', 'ST10100320250521074303', '1446-11-23', '1.100.10', '101', 'an.HAIKAL SHOMADANI', '2000', '0', 'Chuwez', '2025-05-21 21:43:03'),
('2816', 'ST10100320250521074303', '1446-11-23', '2.220.10', '101', 'an.HAIKAL SHOMADANI', '0', '2000', 'Chuwez', '2025-05-21 21:43:03'),
('2817', 'ST10100320250521074317', '1446-11-23', '1.100.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '5000', '0', 'Chuwez', '2025-05-21 21:43:17'),
('2818', 'ST10100320250521074317', '1446-11-23', '2.220.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '0', '5000', 'Chuwez', '2025-05-21 21:43:17'),
('2819', 'ST10100320250521074342', '1446-11-23', '1.100.10', '101', 'an.M. ABD. HADI', '2000', '0', 'Chuwez', '2025-05-21 21:43:42'),
('2820', 'ST10100320250521074342', '1446-11-23', '2.220.10', '101', 'an.M. ABD. HADI', '0', '2000', 'Chuwez', '2025-05-21 21:43:42'),
('2821', 'ST10100320250521074356', '1446-11-23', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '5000', '0', 'Chuwez', '2025-05-21 21:43:56'),
('2822', 'ST10100320250521074356', '1446-11-23', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '5000', 'Chuwez', '2025-05-21 21:43:56'),
('2823', 'ST10100320250521074410', '1446-11-23', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'Chuwez', '2025-05-21 21:44:10'),
('2824', 'ST10100320250521074410', '1446-11-23', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'Chuwez', '2025-05-21 21:44:10'),
('2825', 'ST10100320250521074431', '1446-11-23', '1.100.10', '101', 'an.MARIATUL QIBTIYAH', '2000', '0', 'Chuwez', '2025-05-21 21:44:31'),
('2826', 'ST10100320250521074431', '1446-11-23', '2.220.10', '101', 'an.MARIATUL QIBTIYAH', '0', '2000', 'Chuwez', '2025-05-21 21:44:31'),
('2827', 'ST10100320250521074447', '1446-11-23', '1.100.10', '101', 'an.ADIBA QONITA', '30000', '0', 'Chuwez', '2025-05-21 21:44:47'),
('2828', 'ST10100320250521074447', '1446-11-23', '2.220.10', '101', 'an.ADIBA QONITA', '0', '30000', 'Chuwez', '2025-05-21 21:44:47'),
('2829', 'ST10100320250521074501', '1446-11-23', '1.100.10', '101', 'an.RAISA ANNISA', '5000', '0', 'Chuwez', '2025-05-21 21:45:01'),
('2830', 'ST10100320250521074501', '1446-11-23', '2.220.10', '101', 'an.RAISA ANNISA', '0', '5000', 'Chuwez', '2025-05-21 21:45:01'),
('2831', 'ST10100320250521074531', '1446-11-23', '1.100.10', '101', 'an.M. ABDIL ARIKIN', '10000', '0', 'Chuwez', '2025-05-21 21:45:31'),
('2832', 'ST10100320250521074531', '1446-11-23', '2.220.10', '101', 'an.M. ABDIL ARIKIN', '0', '10000', 'Chuwez', '2025-05-21 21:45:31'),
('2833', 'ST10100320250521074546', '1446-11-23', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '5000', '0', 'Chuwez', '2025-05-21 21:45:46'),
('2834', 'ST10100320250521074546', '1446-11-23', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '5000', 'Chuwez', '2025-05-21 21:45:46'),
('2835', 'ST10100320250521074611', '1446-11-23', '1.100.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '4000', '0', 'Chuwez', '2025-05-21 21:46:11'),
('2836', 'ST10100320250521074611', '1446-11-23', '2.220.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '0', '4000', 'Chuwez', '2025-05-21 21:46:14'),
('2837', 'ST10100320250521074633', '1446-11-23', '1.100.10', '101', 'an.UBAIDAH', '10000', '0', 'Chuwez', '2025-05-21 21:46:33'),
('2838', 'ST10100320250521074633', '1446-11-23', '2.220.10', '101', 'an.UBAIDAH', '0', '10000', 'Chuwez', '2025-05-21 21:46:33'),
('2839', 'ST10100320250521074654', '1446-11-23', '1.100.10', '101', 'an.FAIZAH NURUL LITA', '5000', '0', 'Chuwez', '2025-05-21 21:46:54'),
('2840', 'ST10100320250521074654', '1446-11-23', '2.220.10', '101', 'an.FAIZAH NURUL LITA', '0', '5000', 'Chuwez', '2025-05-21 21:46:54'),
('2841', 'ST10100320250521074709', '1446-11-23', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'Chuwez', '2025-05-21 21:47:09'),
('2842', 'ST10100320250521074709', '1446-11-23', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'Chuwez', '2025-05-21 21:47:09'),
('2843', 'ST10100320250521074727', '1446-11-23', '1.100.10', '101', 'an.UMAR FARUQ', '10000', '0', 'Chuwez', '2025-05-21 21:47:27'),
('2844', 'ST10100320250521074727', '1446-11-23', '2.220.10', '101', 'an.UMAR FARUQ', '0', '10000', 'Chuwez', '2025-05-21 21:47:27'),
('2845', 'ST10100320250521074750', '1446-11-23', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '10000', '0', 'Chuwez', '2025-05-21 21:47:50'),
('2846', 'ST10100320250521074750', '1446-11-23', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '10000', 'Chuwez', '2025-05-21 21:47:50'),
('2847', 'ST10100320250521074822', '1446-11-23', '1.100.10', '101', 'an.M. DESTRA MAULANA', '25000', '0', 'Chuwez', '2025-05-21 21:48:22'),
('2848', 'ST10100320250521074822', '1446-11-23', '2.220.10', '101', 'an.M. DESTRA MAULANA', '0', '25000', 'Chuwez', '2025-05-21 21:48:22'),
('2849', 'ST10100320250521074838', '1446-11-23', '1.100.10', '101', 'an.DIANA RIFQOTUL QOLBI', '10000', '0', 'Chuwez', '2025-05-21 21:48:38'),
('2850', 'ST10100320250521074838', '1446-11-23', '2.220.10', '101', 'an.DIANA RIFQOTUL QOLBI', '0', '10000', 'Chuwez', '2025-05-21 21:48:38'),
('2851', 'ST10100320250521074908', '1446-11-23', '1.100.10', '101', 'an.LAILATUL MAGHFIROH', '5000', '0', 'Chuwez', '2025-05-21 21:49:08'),
('2852', 'ST10100320250521074908', '1446-11-23', '2.220.10', '101', 'an.LAILATUL MAGHFIROH', '0', '5000', 'Chuwez', '2025-05-21 21:49:08'),
('2853', 'ST10100320250521074944', '1446-11-23', '1.100.10', '101', 'an.ABDUL HAMID', '2000', '0', 'Chuwez', '2025-05-21 21:49:44'),
('2854', 'ST10100320250521074944', '1446-11-23', '2.220.10', '101', 'an.ABDUL HAMID', '0', '2000', 'Chuwez', '2025-05-21 21:49:44'),
('2855', 'ST10100320250521075000', '1446-11-23', '1.100.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '10000', '0', 'Chuwez', '2025-05-21 21:50:00'),
('2856', 'ST10100320250521075000', '1446-11-23', '2.220.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '0', '10000', 'Chuwez', '2025-05-21 21:50:00'),
('2857', 'ST10100320250521075016', '1446-11-23', '1.100.10', '101', 'an.DIYANAH KAMALIYAH', '5000', '0', 'Chuwez', '2025-05-21 21:50:16'),
('2858', 'ST10100320250521075016', '1446-11-23', '2.220.10', '101', 'an.DIYANAH KAMALIYAH', '0', '5000', 'Chuwez', '2025-05-21 21:50:16'),
('2859', 'ST10100320250521075031', '1446-11-23', '1.100.10', '101', 'an.WARDATUL JANNAH', '2000', '0', 'Chuwez', '2025-05-21 21:50:31'),
('2860', 'ST10100320250521075031', '1446-11-23', '2.220.10', '101', 'an.WARDATUL JANNAH', '0', '2000', 'Chuwez', '2025-05-21 21:50:31'),
('2861', 'ST10100320250521075048', '1446-11-23', '1.100.10', '101', 'an.M. FAHMI NURUL ANAM', '10000', '0', 'Chuwez', '2025-05-21 21:50:48'),
('2862', 'ST10100320250521075048', '1446-11-23', '2.220.10', '101', 'an.M. FAHMI NURUL ANAM', '0', '10000', 'Chuwez', '2025-05-21 21:50:48'),
('2863', 'ST10100320250521075103', '1446-11-23', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '10000', '0', 'Chuwez', '2025-05-21 21:51:03'),
('2864', 'ST10100320250521075103', '1446-11-23', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '10000', 'Chuwez', '2025-05-21 21:51:03'),
('2865', 'ST10100320250521075118', '1446-11-23', '1.100.10', '101', 'an.SITI QURROTUL AINI', '2000', '0', 'Chuwez', '2025-05-21 21:51:18'),
('2866', 'ST10100320250521075118', '1446-11-23', '2.220.10', '101', 'an.SITI QURROTUL AINI', '0', '2000', 'Chuwez', '2025-05-21 21:51:18'),
('2867', 'ST10100320250521075315', '1446-11-23', '1.100.10', '101', 'an.M. KAMALUDDIN', '20000', '0', 'Chuwez', '2025-05-21 21:53:15'),
('2868', 'ST10100320250521075315', '1446-11-23', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '20000', 'Chuwez', '2025-05-21 21:53:15'),
('2869', 'ST10100320250521075332', '1446-11-23', '1.100.10', '101', 'an.RAUDHOTUL JANNAH', '20000', '0', 'Chuwez', '2025-05-21 21:53:32'),
('2870', 'ST10100320250521075332', '1446-11-23', '2.220.10', '101', 'an.RAUDHOTUL JANNAH', '0', '20000', 'Chuwez', '2025-05-21 21:53:32'),
('2871', 'ST10100320250521075353', '1446-11-23', '1.100.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '10000', '0', 'Chuwez', '2025-05-21 21:53:53'),
('2872', 'ST10100320250521075353', '1446-11-23', '2.220.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '0', '10000', 'Chuwez', '2025-05-21 21:53:53'),
('2873', 'ST10100320250521075407', '1446-11-23', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '2000', '0', 'Chuwez', '2025-05-21 21:54:07'),
('2874', 'ST10100320250521075407', '1446-11-23', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '2000', 'Chuwez', '2025-05-21 21:54:07'),
('2875', 'ST10100320250521075433', '1446-11-23', '1.100.10', '101', 'an.MUHAMMAD ILHAM', '5000', '0', 'Chuwez', '2025-05-21 21:54:33'),
('2876', 'ST10100320250521075433', '1446-11-23', '2.220.10', '101', 'an.MUHAMMAD ILHAM', '0', '5000', 'Chuwez', '2025-05-21 21:54:33'),
('2877', 'ST10100320250521075450', '1446-11-23', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '10000', '0', 'Chuwez', '2025-05-21 21:54:50'),
('2878', 'ST10100320250521075450', '1446-11-23', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '10000', 'Chuwez', '2025-05-21 21:54:50'),
('2879', 'ST10100320250521075510', '1446-11-23', '1.100.10', '101', 'an.IZZA BILLAH', '10000', '0', 'Chuwez', '2025-05-21 21:55:10'),
('2880', 'ST10100320250521075510', '1446-11-23', '2.220.10', '101', 'an.IZZA BILLAH', '0', '10000', 'Chuwez', '2025-05-21 21:55:10'),
('2881', 'ST10100320250521075526', '1446-11-23', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Chuwez', '2025-05-21 21:55:26'),
('2882', 'ST10100320250521075526', '1446-11-23', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Chuwez', '2025-05-21 21:55:26'),
('2883', 'ST10100320250521075545', '1446-11-23', '1.100.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '5000', '0', 'Chuwez', '2025-05-21 21:55:45'),
('2884', 'ST10100320250521075545', '1446-11-23', '2.220.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '0', '5000', 'Chuwez', '2025-05-21 21:55:45'),
('2885', 'ST10100320250521075600', '1446-11-23', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '5000', '0', 'Chuwez', '2025-05-21 21:56:00'),
('2886', 'ST10100320250521075600', '1446-11-23', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '5000', 'Chuwez', '2025-05-21 21:56:00'),
('2887', 'ST10100320250521075618', '1446-11-23', '1.100.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '10000', '0', 'Chuwez', '2025-05-21 21:56:18'),
('2888', 'ST10100320250521075618', '1446-11-23', '2.220.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '0', '10000', 'Chuwez', '2025-05-21 21:56:18'),
('2889', 'ST10100320250521075821', '1446-11-23', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '25000', '0', 'Chuwez', '2025-05-21 21:58:21'),
('2890', 'ST10100320250521075821', '1446-11-23', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '25000', 'Chuwez', '2025-05-21 21:58:21'),
('2891', 'ST10100320250521075840', '1446-11-23', '1.100.10', '101', 'an.SINDI RAISA PUTRI', '10000', '0', 'Chuwez', '2025-05-21 21:58:40'),
('2892', 'ST10100320250521075840', '1446-11-23', '2.220.10', '101', 'an.SINDI RAISA PUTRI', '0', '10000', 'Chuwez', '2025-05-21 21:58:40'),
('2893', 'ST10100320250521075857', '1446-11-23', '1.100.10', '101', 'an.AHMAD JAMALUL MAIMUN', '5000', '0', 'Chuwez', '2025-05-21 21:58:57'),
('2894', 'ST10100320250521075857', '1446-11-23', '2.220.10', '101', 'an.AHMAD JAMALUL MAIMUN', '0', '5000', 'Chuwez', '2025-05-21 21:58:57'),
('2895', 'ST10100320250521075911', '1446-11-23', '1.100.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '5000', '0', 'Chuwez', '2025-05-21 21:59:11'),
('2896', 'ST10100320250521075911', '1446-11-23', '2.220.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '0', '5000', 'Chuwez', '2025-05-21 21:59:11'),
('2897', 'ST10100320250521075925', '1446-11-23', '1.100.10', '101', 'an.AKHMAD FIKRI HAIKAL', '50000', '0', 'Chuwez', '2025-05-21 21:59:25'),
('2898', 'ST10100320250521075925', '1446-11-23', '2.220.10', '101', 'an.AKHMAD FIKRI HAIKAL', '0', '50000', 'Chuwez', '2025-05-21 21:59:25'),
('2899', 'ST10100320250521075942', '1446-11-23', '1.100.10', '101', 'an.BILQIS THALIA HASNA', '60000', '0', 'Chuwez', '2025-05-21 21:59:42'),
('2900', 'ST10100320250521075942', '1446-11-23', '2.220.10', '101', 'an.BILQIS THALIA HASNA', '0', '60000', 'Chuwez', '2025-05-21 21:59:42'),
('2901', 'ST10100320250521080110', '1446-11-23', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '5000', '0', 'Chuwez', '2025-05-21 22:01:10'),
('2902', 'ST10100320250521080110', '1446-11-23', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '5000', 'Chuwez', '2025-05-21 22:01:10'),
('2903', 'ST10100320250521080125', '1446-11-23', '1.100.10', '101', 'an.ANA SALSABILA', '12000', '0', 'Chuwez', '2025-05-21 22:01:25'),
('2904', 'ST10100320250521080125', '1446-11-23', '2.220.10', '101', 'an.ANA SALSABILA', '0', '12000', 'Chuwez', '2025-05-21 22:01:25'),
('2905', 'ST10100320250521080147', '1446-11-23', '1.100.10', '101', 'an.ROBIATUL ADAWIYAH', '6000', '0', 'Chuwez', '2025-05-21 22:01:47'),
('2906', 'ST10100320250521080147', '1446-11-23', '2.220.10', '101', 'an.ROBIATUL ADAWIYAH', '0', '6000', 'Chuwez', '2025-05-21 22:01:47'),
('2907', 'ST10100320250521080205', '1446-11-23', '1.100.10', '101', 'an.M. ALIFIN FIKRI', '2000', '0', 'Chuwez', '2025-05-21 22:02:05'),
('2908', 'ST10100320250521080205', '1446-11-23', '2.220.10', '101', 'an.M. ALIFIN FIKRI', '0', '2000', 'Chuwez', '2025-05-21 22:02:05'),
('2909', 'ST10100320250521080220', '1446-11-23', '1.100.10', '101', 'an.MUHAMMAD KHOIRON', '2000', '0', 'Chuwez', '2025-05-21 22:02:20'),
('2910', 'ST10100320250521080220', '1446-11-23', '2.220.10', '101', 'an.MUHAMMAD KHOIRON', '0', '2000', 'Chuwez', '2025-05-21 22:02:20'),
('2911', 'ST10100320250521080234', '1446-11-23', '1.100.10', '101', 'an.AFANDI', '2000', '0', 'Chuwez', '2025-05-21 22:02:34'),
('2912', 'ST10100320250521080234', '1446-11-23', '2.220.10', '101', 'an.AFANDI', '0', '2000', 'Chuwez', '2025-05-21 22:02:34'),
('2913', 'ST10100320250521080303', '1446-11-23', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '2000', '0', 'Chuwez', '2025-05-21 22:03:03'),
('2914', 'ST10100320250521080303', '1446-11-23', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '2000', 'Chuwez', '2025-05-21 22:03:03'),
('2915', 'ST10100320250521080438', '1446-11-23', '1.100.10', '101', 'an.ACH. JUNAIDI', '5000', '0', 'Chuwez', '2025-05-21 22:04:38'),
('2916', 'ST10100320250521080438', '1446-11-23', '2.220.10', '101', 'an.ACH. JUNAIDI', '0', '5000', 'Chuwez', '2025-05-21 22:04:38'),
('2917', 'ST10100320250521080452', '1446-11-23', '1.100.10', '101', 'an.M. ZIDAN RIZQI SALIM', '4000', '0', 'Chuwez', '2025-05-21 22:04:52'),
('2918', 'ST10100320250521080452', '1446-11-23', '2.220.10', '101', 'an.M. ZIDAN RIZQI SALIM', '0', '4000', 'Chuwez', '2025-05-21 22:04:52'),
('2919', 'ST10100320250521080515', '1446-11-23', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '5000', '0', 'Chuwez', '2025-05-21 22:05:15'),
('2920', 'ST10100320250521080515', '1446-11-23', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '5000', 'Chuwez', '2025-05-21 22:05:15'),
('2921', 'ST10100320250521080535', '1446-11-23', '1.100.10', '101', 'an.SAFIRATUL JANNAH', '10000', '0', 'Chuwez', '2025-05-21 22:05:35'),
('2922', 'ST10100320250521080535', '1446-11-23', '2.220.10', '101', 'an.SAFIRATUL JANNAH', '0', '10000', 'Chuwez', '2025-05-21 22:05:35'),
('2923', 'ST10100320250521080634', '1446-11-23', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'Chuwez', '2025-05-21 22:06:34'),
('2924', 'ST10100320250521080634', '1446-11-23', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'Chuwez', '2025-05-21 22:06:35'),
('2925', 'ST10100320250521080657', '1446-11-23', '1.100.10', '101', 'an.HILYA', '20000', '0', 'Chuwez', '2025-05-21 22:06:57'),
('2926', 'ST10100320250521080657', '1446-11-23', '2.220.10', '101', 'an.HILYA', '0', '20000', 'Chuwez', '2025-05-21 22:06:57'),
('2927', 'ST10100320250522072441', '1446-11-24', '1.100.10', '101', 'an.MUHAMMAD ILHAM', '5000', '0', 'Chuwez', '2025-05-22 21:24:41'),
('2928', 'ST10100320250522072441', '1446-11-24', '2.220.10', '101', 'an.MUHAMMAD ILHAM', '0', '5000', 'Chuwez', '2025-05-22 21:24:42'),
('2929', 'ST10100320250522072502', '1446-11-24', '1.100.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '20000', '0', 'Chuwez', '2025-05-22 21:25:02'),
('2930', 'ST10100320250522072502', '1446-11-24', '2.220.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '0', '20000', 'Chuwez', '2025-05-22 21:25:02'),
('2931', 'ST10100320250522072529', '1446-11-24', '1.100.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '5000', '0', 'Chuwez', '2025-05-22 21:25:29'),
('2932', 'ST10100320250522072529', '1446-11-24', '2.220.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '0', '5000', 'Chuwez', '2025-05-22 21:25:29'),
('2933', 'ST10100320250522072611', '1446-11-24', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Chuwez', '2025-05-22 21:26:11'),
('2934', 'ST10100320250522072611', '1446-11-24', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Chuwez', '2025-05-22 21:26:11'),
('2935', 'ST10100320250522072644', '1446-11-24', '1.100.10', '101', 'an.M. KAMALUDDIN', '20000', '0', 'Chuwez', '2025-05-22 21:26:44'),
('2936', 'ST10100320250522072644', '1446-11-24', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '20000', 'Chuwez', '2025-05-22 21:26:44'),
('2937', 'ST10100320250522072714', '1446-11-24', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '5000', '0', 'Chuwez', '2025-05-22 21:27:14'),
('2938', 'ST10100320250522072714', '1446-11-24', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '5000', 'Chuwez', '2025-05-22 21:27:14'),
('2939', 'ST10100320250522072735', '1446-11-24', '1.100.10', '101', 'an.MIFTAHUL JANNAH', '50000', '0', 'Chuwez', '2025-05-22 21:27:35'),
('2940', 'ST10100320250522072735', '1446-11-24', '2.220.10', '101', 'an.MIFTAHUL JANNAH', '0', '50000', 'Chuwez', '2025-05-22 21:27:35'),
('2941', 'ST10100320250522072758', '1446-11-24', '1.100.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '5000', '0', 'Chuwez', '2025-05-22 21:27:58'),
('2942', 'ST10100320250522072758', '1446-11-24', '2.220.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '0', '5000', 'Chuwez', '2025-05-22 21:27:59'),
('2943', 'ST10100320250522072842', '1446-11-24', '1.100.10', '101', 'an.RENI FARIDA', '4000', '0', 'Chuwez', '2025-05-22 21:28:42'),
('2944', 'ST10100320250522072842', '1446-11-24', '2.220.10', '101', 'an.RENI FARIDA', '0', '4000', 'Chuwez', '2025-05-22 21:28:42'),
('2945', 'ST10100320250522073049', '1446-11-24', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '10000', '0', 'Chuwez', '2025-05-22 21:30:49'),
('2946', 'ST10100320250522073049', '1446-11-24', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '10000', 'Chuwez', '2025-05-22 21:30:49'),
('2947', 'ST10100320250522073110', '1446-11-24', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '2000', '0', 'Chuwez', '2025-05-22 21:31:10'),
('2948', 'ST10100320250522073110', '1446-11-24', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '2000', 'Chuwez', '2025-05-22 21:31:10'),
('2949', 'ST10100320250522073227', '1446-11-24', '1.100.10', '101', 'an.SITI SHOFIYAH LABIBAH', '20000', '0', 'Chuwez', '2025-05-22 21:32:27'),
('2950', 'ST10100320250522073227', '1446-11-24', '2.220.10', '101', 'an.SITI SHOFIYAH LABIBAH', '0', '20000', 'Chuwez', '2025-05-22 21:32:27'),
('2951', 'ST10100320250522073248', '1446-11-24', '1.100.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '2000', '0', 'Chuwez', '2025-05-22 21:32:48'),
('2952', 'ST10100320250522073248', '1446-11-24', '2.220.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '0', '2000', 'Chuwez', '2025-05-22 21:32:48'),
('2953', 'ST10100320250522073306', '1446-11-24', '1.100.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '5000', '0', 'Chuwez', '2025-05-22 21:33:06'),
('2954', 'ST10100320250522073306', '1446-11-24', '2.220.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '0', '5000', 'Chuwez', '2025-05-22 21:33:06'),
('2955', 'ST10100320250522073358', '1446-11-24', '1.100.10', '101', 'an.NAURA BILADINA', '5000', '0', 'Chuwez', '2025-05-22 21:33:58'),
('2956', 'ST10100320250522073358', '1446-11-24', '2.220.10', '101', 'an.NAURA BILADINA', '0', '5000', 'Chuwez', '2025-05-22 21:33:58'),
('2957', 'ST10100320250522073439', '1446-11-24', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'Chuwez', '2025-05-22 21:34:39'),
('2958', 'ST10100320250522073439', '1446-11-24', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'Chuwez', '2025-05-22 21:34:39'),
('2959', 'ST10100320250522073504', '1446-11-24', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '5000', '0', 'Chuwez', '2025-05-22 21:35:04'),
('2960', 'ST10100320250522073504', '1446-11-24', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '5000', 'Chuwez', '2025-05-22 21:35:04'),
('2961', 'ST10100320250522073528', '1446-11-24', '1.100.10', '101', 'an.HAIKAL SHOMADANI', '2000', '0', 'Chuwez', '2025-05-22 21:35:28'),
('2962', 'ST10100320250522073528', '1446-11-24', '2.220.10', '101', 'an.HAIKAL SHOMADANI', '0', '2000', 'Chuwez', '2025-05-22 21:35:28'),
('2963', 'ST10100320250522073543', '1446-11-24', '1.100.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '10000', '0', 'Chuwez', '2025-05-22 21:35:43'),
('2964', 'ST10100320250522073543', '1446-11-24', '2.220.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '0', '10000', 'Chuwez', '2025-05-22 21:35:43'),
('2965', 'ST10100320250522073712', '1446-11-24', '1.100.10', '101', 'an.FAIZAH NURUL LITA', '5000', '0', 'Chuwez', '2025-05-22 21:37:12'),
('2966', 'ST10100320250522073712', '1446-11-24', '2.220.10', '101', 'an.FAIZAH NURUL LITA', '0', '5000', 'Chuwez', '2025-05-22 21:37:12'),
('2967', 'ST10100320250522073825', '1446-11-24', '1.100.10', '101', 'an.MUHAMMAD ALWI', '10000', '0', 'Chuwez', '2025-05-22 21:38:25'),
('2968', 'ST10100320250522073825', '1446-11-24', '2.220.10', '101', 'an.MUHAMMAD ALWI', '0', '10000', 'Chuwez', '2025-05-22 21:38:25'),
('2969', 'ST10100320250522073851', '1446-11-24', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '5000', '0', 'Chuwez', '2025-05-22 21:38:51'),
('2970', 'ST10100320250522073851', '1446-11-24', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '5000', 'Chuwez', '2025-05-22 21:38:51'),
('2971', 'ST10100320250522073911', '1446-11-24', '1.100.10', '101', 'an.NAILATUN NIAMI', '5000', '0', 'Chuwez', '2025-05-22 21:39:11'),
('2972', 'ST10100320250522073911', '1446-11-24', '2.220.10', '101', 'an.NAILATUN NIAMI', '0', '5000', 'Chuwez', '2025-05-22 21:39:11'),
('2973', 'ST10100320250522073936', '1446-11-24', '1.100.10', '101', 'an.M. ABDIL ARIKIN', '10000', '0', 'Chuwez', '2025-05-22 21:39:36'),
('2974', 'ST10100320250522073936', '1446-11-24', '2.220.10', '101', 'an.M. ABDIL ARIKIN', '0', '10000', 'Chuwez', '2025-05-22 21:39:36'),
('2975', 'ST10100320250522074002', '1446-11-24', '1.100.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '4000', '0', 'Chuwez', '2025-05-22 21:40:02'),
('2976', 'ST10100320250522074002', '1446-11-24', '2.220.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '0', '4000', 'Chuwez', '2025-05-22 21:40:02'),
('2977', 'ST10100320250522074031', '1446-11-24', '1.100.10', '101', 'an.UBAIDAH', '20000', '0', 'Chuwez', '2025-05-22 21:40:31'),
('2978', 'ST10100320250522074031', '1446-11-24', '2.220.10', '101', 'an.UBAIDAH', '0', '20000', 'Chuwez', '2025-05-22 21:40:31'),
('2979', 'ST10100320250522074100', '1446-11-24', '1.100.10', '101', 'an.SAUQY AHMAD', '25000', '0', 'Chuwez', '2025-05-22 21:41:00'),
('2980', 'ST10100320250522074100', '1446-11-24', '2.220.10', '101', 'an.SAUQY AHMAD', '0', '25000', 'Chuwez', '2025-05-22 21:41:00'),
('2981', 'ST10100320250522074131', '1446-11-24', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'Chuwez', '2025-05-22 21:41:31'),
('2982', 'ST10100320250522074131', '1446-11-24', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'Chuwez', '2025-05-22 21:41:31'),
('2983', 'ST10100320250522074156', '1446-11-24', '1.100.10', '101', 'an.MARIATUL QIBTIYAH', '2000', '0', 'Chuwez', '2025-05-22 21:41:56'),
('2984', 'ST10100320250522074156', '1446-11-24', '2.220.10', '101', 'an.MARIATUL QIBTIYAH', '0', '2000', 'Chuwez', '2025-05-22 21:41:56'),
('2985', 'ST10100320250522074220', '1446-11-24', '1.100.10', '101', 'an.MARIYATUL QIBTIYAH', '5000', '0', 'Chuwez', '2025-05-22 21:42:20'),
('2986', 'ST10100320250522074220', '1446-11-24', '2.220.10', '101', 'an.MARIYATUL QIBTIYAH', '0', '5000', 'Chuwez', '2025-05-22 21:42:20'),
('2987', 'ST10100320250522074240', '1446-11-24', '1.100.10', '101', 'an.ALFI NURDIANA', '5000', '0', 'Chuwez', '2025-05-22 21:42:40'),
('2988', 'ST10100320250522074240', '1446-11-24', '2.220.10', '101', 'an.ALFI NURDIANA', '0', '5000', 'Chuwez', '2025-05-22 21:42:40'),
('2989', 'ST10100320250522074308', '1446-11-24', '1.100.10', '101', 'an.IFTITAHUL IZZA', '100000', '0', 'Chuwez', '2025-05-22 21:43:08'),
('2990', 'ST10100320250522074308', '1446-11-24', '2.220.10', '101', 'an.IFTITAHUL IZZA', '0', '100000', 'Chuwez', '2025-05-22 21:43:08'),
('2991', 'ST10100320250522074339', '1446-11-24', '1.100.10', '101', 'an.LAILATUL MAGHFIROH', '10000', '0', 'Chuwez', '2025-05-22 21:43:39'),
('2992', 'ST10100320250522074339', '1446-11-24', '2.220.10', '101', 'an.LAILATUL MAGHFIROH', '0', '10000', 'Chuwez', '2025-05-22 21:43:39'),
('2993', 'ST10100320250522074358', '1446-11-24', '1.100.10', '101', 'an.AZKA AUFARIL MINAN', '10000', '0', 'Chuwez', '2025-05-22 21:43:58'),
('2994', 'ST10100320250522074358', '1446-11-24', '2.220.10', '101', 'an.AZKA AUFARIL MINAN', '0', '10000', 'Chuwez', '2025-05-22 21:43:58'),
('2995', 'ST10100320250522074420', '1446-11-24', '1.100.10', '101', 'an.M. DESTRA MAULANA', '6000', '0', 'Chuwez', '2025-05-22 21:44:20'),
('2996', 'ST10100320250522074420', '1446-11-24', '2.220.10', '101', 'an.M. DESTRA MAULANA', '0', '6000', 'Chuwez', '2025-05-22 21:44:20'),
('2997', 'ST10100320250522074442', '1446-11-24', '1.100.10', '101', 'an.DIANA RIFQOTUL QOLBI', '5000', '0', 'Chuwez', '2025-05-22 21:44:42'),
('2998', 'ST10100320250522074442', '1446-11-24', '2.220.10', '101', 'an.DIANA RIFQOTUL QOLBI', '0', '5000', 'Chuwez', '2025-05-22 21:44:42'),
('2999', 'ST10100320250522074501', '1446-11-24', '1.100.10', '101', 'an.AHMAD ADITIYA', '5000', '0', 'Chuwez', '2025-05-22 21:45:01'),
('3000', 'ST10100320250522074501', '1446-11-24', '2.220.10', '101', 'an.AHMAD ADITIYA', '0', '5000', 'Chuwez', '2025-05-22 21:45:01'),
('3001', 'ST10100320250522074533', '1446-11-24', '1.100.10', '101', 'an.AISYAH', '5000', '0', 'Chuwez', '2025-05-22 21:45:33'),
('3002', 'ST10100320250522074533', '1446-11-24', '2.220.10', '101', 'an.AISYAH', '0', '5000', 'Chuwez', '2025-05-22 21:45:33'),
('3003', 'ST10100320250522074625', '1446-11-24', '1.100.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '10000', '0', 'Chuwez', '2025-05-22 21:46:25'),
('3004', 'ST10100320250522074625', '1446-11-24', '2.220.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '0', '10000', 'Chuwez', '2025-05-22 21:46:25'),
('3005', 'ST10100320250522074644', '1446-11-24', '1.100.10', '101', 'an.SITI QURROTUL AINI', '2000', '0', 'Chuwez', '2025-05-22 21:46:44'),
('3006', 'ST10100320250522074644', '1446-11-24', '2.220.10', '101', 'an.SITI QURROTUL AINI', '0', '2000', 'Chuwez', '2025-05-22 21:46:44'),
('3007', 'ST10100320250522074700', '1446-11-24', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '10000', '0', 'Chuwez', '2025-05-22 21:47:00'),
('3008', 'ST10100320250522074700', '1446-11-24', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '10000', 'Chuwez', '2025-05-22 21:47:00'),
('3009', 'ST10100320250522074719', '1446-11-24', '1.100.10', '101', 'an.SITI ATHIUR ROHMAH', '5000', '0', 'Chuwez', '2025-05-22 21:47:19'),
('3010', 'ST10100320250522074719', '1446-11-24', '2.220.10', '101', 'an.SITI ATHIUR ROHMAH', '0', '5000', 'Chuwez', '2025-05-22 21:47:19'),
('3011', 'ST10100320250522074748', '1446-11-24', '1.100.10', '101', 'an.BILQIS THALIA HASNA', '60000', '0', 'Chuwez', '2025-05-22 21:47:48'),
('3012', 'ST10100320250522074748', '1446-11-24', '2.220.10', '101', 'an.BILQIS THALIA HASNA', '0', '60000', 'Chuwez', '2025-05-22 21:47:49'),
('3013', 'ST10100320250522074812', '1446-11-24', '1.100.10', '101', 'an.AHMAD ABBAS MAULANA', '3000', '0', 'Chuwez', '2025-05-22 21:48:12'),
('3014', 'ST10100320250522074812', '1446-11-24', '2.220.10', '101', 'an.AHMAD ABBAS MAULANA', '0', '3000', 'Chuwez', '2025-05-22 21:48:12'),
('3015', 'ST10100320250522074903', '1446-11-24', '1.100.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '10000', '0', 'Chuwez', '2025-05-22 21:49:03'),
('3016', 'ST10100320250522074903', '1446-11-24', '2.220.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '0', '10000', 'Chuwez', '2025-05-22 21:49:03'),
('3017', 'ST10100320250522074928', '1446-11-24', '1.100.10', '101', 'an.AKHMAD FIKRI HAIKAL', '50000', '0', 'Chuwez', '2025-05-22 21:49:28'),
('3018', 'ST10100320250522074928', '1446-11-24', '2.220.10', '101', 'an.AKHMAD FIKRI HAIKAL', '0', '50000', 'Chuwez', '2025-05-22 21:49:28'),
('3019', 'ST10100320250522074949', '1446-11-24', '1.100.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '5000', '0', 'Chuwez', '2025-05-22 21:49:49'),
('3020', 'ST10100320250522074949', '1446-11-24', '2.220.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '0', '5000', 'Chuwez', '2025-05-22 21:49:49'),
('3021', 'ST10100320250522075010', '1446-11-24', '1.100.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '20000', '0', 'Chuwez', '2025-05-22 21:50:10'),
('3022', 'ST10100320250522075010', '1446-11-24', '2.220.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '0', '20000', 'Chuwez', '2025-05-22 21:50:10'),
('3023', 'ST10100320250522075029', '1446-11-24', '1.100.10', '101', 'an.M. HAIKAL NASRULLOH', '5000', '0', 'Chuwez', '2025-05-22 21:50:29'),
('3024', 'ST10100320250522075029', '1446-11-24', '2.220.10', '101', 'an.M. HAIKAL NASRULLOH', '0', '5000', 'Chuwez', '2025-05-22 21:50:29'),
('3025', 'ST10100320250522075050', '1446-11-24', '1.100.10', '101', 'an.SINDI RAISA PUTRI', '10000', '0', 'Chuwez', '2025-05-22 21:50:50'),
('3026', 'ST10100320250522075050', '1446-11-24', '2.220.10', '101', 'an.SINDI RAISA PUTRI', '0', '10000', 'Chuwez', '2025-05-22 21:50:50'),
('3027', 'ST10100320250522075111', '1446-11-24', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '25000', '0', 'Chuwez', '2025-05-22 21:51:11'),
('3028', 'ST10100320250522075111', '1446-11-24', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '25000', 'Chuwez', '2025-05-22 21:51:11'),
('3029', 'ST10100320250522075143', '1446-11-24', '1.100.10', '101', 'an.AFANDI', '2000', '0', 'Chuwez', '2025-05-22 21:51:43'),
('3030', 'ST10100320250522075143', '1446-11-24', '2.220.10', '101', 'an.AFANDI', '0', '2000', 'Chuwez', '2025-05-22 21:51:43'),
('3031', 'ST10100320250522075159', '1446-11-24', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '5000', '0', 'Chuwez', '2025-05-22 21:51:59'),
('3032', 'ST10100320250522075159', '1446-11-24', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '5000', 'Chuwez', '2025-05-22 21:52:00'),
('3033', 'ST10100320250522075218', '1446-11-24', '1.100.10', '101', 'an.MUHAMMAD KHOIRON', '5000', '0', 'Chuwez', '2025-05-22 21:52:18'),
('3034', 'ST10100320250522075218', '1446-11-24', '2.220.10', '101', 'an.MUHAMMAD KHOIRON', '0', '5000', 'Chuwez', '2025-05-22 21:52:18'),
('3035', 'ST10100320250522075240', '1446-11-24', '1.100.10', '101', 'an.ANA SALSABILA', '5000', '0', 'Chuwez', '2025-05-22 21:52:40'),
('3036', 'ST10100320250522075240', '1446-11-24', '2.220.10', '101', 'an.ANA SALSABILA', '0', '5000', 'Chuwez', '2025-05-22 21:52:40'),
('3037', 'ST10100320250522075302', '1446-11-24', '1.100.10', '101', 'an.MUHAMMAD HAMDANI', '10000', '0', 'Chuwez', '2025-05-22 21:53:02'),
('3038', 'ST10100320250522075302', '1446-11-24', '2.220.10', '101', 'an.MUHAMMAD HAMDANI', '0', '10000', 'Chuwez', '2025-05-22 21:53:02'),
('3039', 'ST10100320250522075342', '1446-11-24', '1.100.10', '101', 'an.ACH. JUNAIDI', '5000', '0', 'Chuwez', '2025-05-22 21:53:42'),
('3040', 'ST10100320250522075342', '1446-11-24', '2.220.10', '101', 'an.ACH. JUNAIDI', '0', '5000', 'Chuwez', '2025-05-22 21:53:42'),
('3041', 'ST10100320250522075402', '1446-11-24', '1.100.10', '101', 'an.ALFIN HIDAYAT', '20000', '0', 'Chuwez', '2025-05-22 21:54:02'),
('3042', 'ST10100320250522075402', '1446-11-24', '2.220.10', '101', 'an.ALFIN HIDAYAT', '0', '20000', 'Chuwez', '2025-05-22 21:54:02'),
('3043', 'ST10100320250522075429', '1446-11-24', '1.100.10', '101', 'an.SAFIRATUL JANNAH', '10000', '0', 'Chuwez', '2025-05-22 21:54:29'),
('3044', 'ST10100320250522075429', '1446-11-24', '2.220.10', '101', 'an.SAFIRATUL JANNAH', '0', '10000', 'Chuwez', '2025-05-22 21:54:29'),
('3045', 'ST10100320250522075500', '1446-11-24', '1.100.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '2000', '0', 'Chuwez', '2025-05-22 21:55:00'),
('3046', 'ST10100320250522075500', '1446-11-24', '2.220.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '0', '2000', 'Chuwez', '2025-05-22 21:55:00'),
('3047', 'ST10100320250522075521', '1446-11-24', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '5000', '0', 'Chuwez', '2025-05-22 21:55:21'),
('3048', 'ST10100320250522075521', '1446-11-24', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '5000', 'Chuwez', '2025-05-22 21:55:21'),
('3049', 'ST10100320250522075544', '1446-11-24', '1.100.10', '101', 'an.MUHAMMAD KANZUL KAROMI', '5000', '0', 'Chuwez', '2025-05-22 21:55:44'),
('3050', 'ST10100320250522075544', '1446-11-24', '2.220.10', '101', 'an.MUHAMMAD KANZUL KAROMI', '0', '5000', 'Chuwez', '2025-05-22 21:55:44'),
('3051', 'ST10100320250522075607', '1446-11-24', '1.100.10', '101', 'an.M. ZIDAN RIZQI SALIM', '6000', '0', 'Chuwez', '2025-05-22 21:56:07'),
('3052', 'ST10100320250522075607', '1446-11-24', '2.220.10', '101', 'an.M. ZIDAN RIZQI SALIM', '0', '6000', 'Chuwez', '2025-05-22 21:56:07'),
('3053', 'ST10100320250522075646', '1446-11-24', '1.100.10', '101', 'an.HILYA', '20000', '0', 'Chuwez', '2025-05-22 21:56:46'),
('3054', 'ST10100320250522075646', '1446-11-24', '2.220.10', '101', 'an.HILYA', '0', '20000', 'Chuwez', '2025-05-22 21:56:46'),
('3055', 'ST10100320250522075710', '1446-11-24', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'Chuwez', '2025-05-22 21:57:10'),
('3056', 'ST10100320250522075710', '1446-11-24', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'Chuwez', '2025-05-22 21:57:10'),
('3057', 'ST10100320250522075823', '1446-11-24', '1.100.10', '101', 'an.AMARA', '20000', '0', 'Chuwez', '2025-05-22 21:58:23'),
('3058', 'ST10100320250522075823', '1446-11-24', '2.220.10', '101', 'an.AMARA', '0', '20000', 'Chuwez', '2025-05-22 21:58:23'),
('3059', 'KK10100320250522145850', '1446-11-24', '5.520.42', '101', 'Cilok ,gorengan', '10000', '0', 'Chuwez', '2025-05-22 14:59:16'),
('3060', 'KK10100320250522145850', '1446-11-24', '1.100.10', '101', 'Cilok ,gorengan', '0', '10000', 'Chuwez', '2025-05-22 14:59:16'),
('3061', 'SY10100120250522084215000', '1446-10-24', '1.100.10', '101', 'Bayar [HAIKAL SHOMADANI]', '30000', '0', 'mumuz', '2025-05-22 15:42:15'),
('3062', 'SY10100120250522084215000', '1446-10-24', '4.400.20', '101', 'Bayar [HAIKAL SHOMADANI]', '0', '30000', 'mumuz', '2025-05-22 15:42:15'),
('3063', 'SY10100120250522084215001', '1446-11-24', '1.100.10', '101', 'Bayar [HAIKAL SHOMADANI]', '30000', '0', 'mumuz', '2025-05-22 15:42:15'),
('3064', 'SY10100120250522084215001', '1446-11-24', '4.400.20', '101', 'Bayar [HAIKAL SHOMADANI]', '0', '30000', 'mumuz', '2025-05-22 15:42:15'),
('3065', 'SY10100120250522084215002', '1446-12-24', '1.100.10', '101', 'Bayar [HAIKAL SHOMADANI]', '30000', '0', 'mumuz', '2025-05-22 15:42:15'),
('3066', 'SY10100120250522084215002', '1446-12-24', '4.400.20', '101', 'Bayar [HAIKAL SHOMADANI]', '0', '30000', 'mumuz', '2025-05-22 15:42:15'),
('3067', 'SY10100120250523074151000', '1446-10-25', '1.100.10', '101', 'Bayar[HAIKAL SHOMADANI]', '30000', '0', 'mumuz', '2025-05-23 14:41:51'),
('3068', 'SY10100120250523074151000', '1446-10-25', '4.400.20', '101', 'Bayar[HAIKAL SHOMADANI]', '0', '30000', 'mumuz', '2025-05-23 14:41:51'),
('3069', 'SY10100120250523074151001', '1446-11-25', '1.100.10', '101', 'Bayar[HAIKAL SHOMADANI]', '30000', '0', 'mumuz', '2025-05-23 14:41:51'),
('3070', 'SY10100120250523074151001', '1446-11-25', '4.400.20', '101', 'Bayar[HAIKAL SHOMADANI]', '0', '30000', 'mumuz', '2025-05-23 14:41:51'),
('3071', 'SY10100120250523074151002', '1446-12-25', '1.100.10', '101', 'Bayar[HAIKAL SHOMADANI]', '30000', '0', 'mumuz', '2025-05-23 14:41:51'),
('3072', 'SY10100120250523074151002', '1446-12-25', '4.400.20', '101', 'Bayar[HAIKAL SHOMADANI]', '0', '30000', 'mumuz', '2025-05-23 14:41:51'),
('3073', 'KK10100220250524144922', '1446-11-26', '5.520.37', '101', 'Wifi Bulan Syawal', '100000', '0', 'Ipul', '2025-05-24 14:50:20'),
('3074', 'KK10100220250524144922', '1446-11-26', '1.100.10', '101', 'Wifi Bulan Syawal', '0', '100000', 'Ipul', '2025-05-24 14:50:20'),
('3075', 'KK10100220250524145040', '1446-11-26', '5.520.42', '101', 'Beli cilok', '10000', '0', 'Ipul', '2025-05-24 14:50:56'),
('3076', 'KK10100220250524145040', '1446-11-26', '1.100.10', '101', 'Beli cilok', '0', '10000', 'Ipul', '2025-05-24 14:50:56'),
('3077', 'ST10100220250524075630', '1446-11-26', '1.100.10', '101', 'an.SITI SHOFIYAH LABIBAH', '50000', '0', 'Ipul', '2025-05-24 21:56:30'),
('3078', 'ST10100220250524075630', '1446-11-26', '2.220.10', '101', 'an.SITI SHOFIYAH LABIBAH', '0', '50000', 'Ipul', '2025-05-24 21:56:30'),
('3079', 'ST10100220250524075652', '1446-11-26', '1.100.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '2000', '0', 'Ipul', '2025-05-24 21:56:52'),
('3080', 'ST10100220250524075652', '1446-11-26', '2.220.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '0', '2000', 'Ipul', '2025-05-24 21:56:52'),
('3081', 'ST10100220250524075713', '1446-11-26', '1.100.10', '101', 'an.M. ABD. HADI', '2000', '0', 'Ipul', '2025-05-24 21:57:13'),
('3082', 'ST10100220250524075713', '1446-11-26', '2.220.10', '101', 'an.M. ABD. HADI', '0', '2000', 'Ipul', '2025-05-24 21:57:13'),
('3083', 'ST10100220250524075751', '1446-11-26', '1.100.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '5000', '0', 'Ipul', '2025-05-24 21:57:51'),
('3084', 'ST10100220250524075751', '1446-11-26', '2.220.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '0', '5000', 'Ipul', '2025-05-24 21:57:51'),
('3085', 'ST10100220250524075809', '1446-11-26', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '5000', '0', 'Ipul', '2025-05-24 21:58:09'),
('3086', 'ST10100220250524075809', '1446-11-26', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '5000', 'Ipul', '2025-05-24 21:58:09'),
('3087', 'ST10100220250524075856', '1446-11-26', '1.100.10', '101', 'an.MUHAMMAD ALWI', '10000', '0', 'Ipul', '2025-05-24 21:58:56'),
('3088', 'ST10100220250524075856', '1446-11-26', '2.220.10', '101', 'an.MUHAMMAD ALWI', '0', '10000', 'Ipul', '2025-05-24 21:58:56'),
('3089', 'ST10100220250524075914', '1446-11-26', '1.100.10', '101', 'an.SAUQY AHMAD', '10000', '0', 'Ipul', '2025-05-24 21:59:14'),
('3090', 'ST10100220250524075914', '1446-11-26', '2.220.10', '101', 'an.SAUQY AHMAD', '0', '10000', 'Ipul', '2025-05-24 21:59:14'),
('3091', 'ST10100220250524075930', '1446-11-26', '1.100.10', '101', 'an.UMAR FARUQ', '10000', '0', 'Ipul', '2025-05-24 21:59:30'),
('3092', 'ST10100220250524075930', '1446-11-26', '2.220.10', '101', 'an.UMAR FARUQ', '0', '10000', 'Ipul', '2025-05-24 21:59:30'),
('3093', 'ST10100220250524075947', '1446-11-26', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'Ipul', '2025-05-24 21:59:47'),
('3094', 'ST10100220250524075947', '1446-11-26', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'Ipul', '2025-05-24 21:59:47'),
('3095', 'ST10100220250524080005', '1446-11-26', '1.100.10', '101', 'an.RAISA ANNISA', '10000', '0', 'Ipul', '2025-05-24 22:00:05'),
('3096', 'ST10100220250524080005', '1446-11-26', '2.220.10', '101', 'an.RAISA ANNISA', '0', '10000', 'Ipul', '2025-05-24 22:00:05'),
('3097', 'ST10100220250524080031', '1446-11-26', '1.100.10', '101', 'an.UBAIDAH', '15000', '0', 'Ipul', '2025-05-24 22:00:31'),
('3098', 'ST10100220250524080031', '1446-11-26', '2.220.10', '101', 'an.UBAIDAH', '0', '15000', 'Ipul', '2025-05-24 22:00:31'),
('3099', 'ST10100220250524080108', '1446-11-26', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '5000', '0', 'Ipul', '2025-05-24 22:01:08'),
('3100', 'ST10100220250524080108', '1446-11-26', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '5000', 'Ipul', '2025-05-24 22:01:08'),
('3101', 'ST10100220250524080131', '1446-11-26', '1.100.10', '101', 'an.ABDULLOH BAHAR', '4000', '0', 'Ipul', '2025-05-24 22:01:31'),
('3102', 'ST10100220250524080131', '1446-11-26', '2.220.10', '101', 'an.ABDULLOH BAHAR', '0', '4000', 'Ipul', '2025-05-24 22:01:31'),
('3103', 'ST10100220250524080154', '1446-11-26', '1.100.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '4000', '0', 'Ipul', '2025-05-24 22:01:54'),
('3104', 'ST10100220250524080154', '1446-11-26', '2.220.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '0', '4000', 'Ipul', '2025-05-24 22:01:54'),
('3105', 'ST10100220250524080209', '1446-11-26', '1.100.10', '101', 'an.NAILATUN NIAMI', '5000', '0', 'Ipul', '2025-05-24 22:02:09'),
('3106', 'ST10100220250524080209', '1446-11-26', '2.220.10', '101', 'an.NAILATUN NIAMI', '0', '5000', 'Ipul', '2025-05-24 22:02:09'),
('3107', 'ST10100220250524080226', '1446-11-26', '1.100.10', '101', 'an.MARIYATUL QIBTIYAH', '5000', '0', 'Ipul', '2025-05-24 22:02:26'),
('3108', 'ST10100220250524080226', '1446-11-26', '2.220.10', '101', 'an.MARIYATUL QIBTIYAH', '0', '5000', 'Ipul', '2025-05-24 22:02:26'),
('3109', 'ST10100220250524080250', '1446-11-26', '1.100.10', '101', 'an.AZKA AUFARIL MINAN', '10000', '0', 'Ipul', '2025-05-24 22:02:50'),
('3110', 'ST10100220250524080250', '1446-11-26', '2.220.10', '101', 'an.AZKA AUFARIL MINAN', '0', '10000', 'Ipul', '2025-05-24 22:02:50'),
('3111', 'ST10100220250524080307', '1446-11-26', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '10000', '0', 'Ipul', '2025-05-24 22:03:07'),
('3112', 'ST10100220250524080307', '1446-11-26', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '10000', 'Ipul', '2025-05-24 22:03:07'),
('3113', 'ST10100220250524080322', '1446-11-26', '1.100.10', '101', 'an.ALFI NURDIANA', '5000', '0', 'Ipul', '2025-05-24 22:03:22'),
('3114', 'ST10100220250524080322', '1446-11-26', '2.220.10', '101', 'an.ALFI NURDIANA', '0', '5000', 'Ipul', '2025-05-24 22:03:22'),
('3115', 'ST10100220250524080336', '1446-11-26', '1.100.10', '101', 'an.LAILATUL MAGHFIROH', '10000', '0', 'Ipul', '2025-05-24 22:03:36'),
('3116', 'ST10100220250524080336', '1446-11-26', '2.220.10', '101', 'an.LAILATUL MAGHFIROH', '0', '10000', 'Ipul', '2025-05-24 22:03:36'),
('3117', 'ST10100220250524080352', '1446-11-26', '1.100.10', '101', 'an.M. DESTRA MAULANA', '50000', '0', 'Ipul', '2025-05-24 22:03:52'),
('3118', 'ST10100220250524080352', '1446-11-26', '2.220.10', '101', 'an.M. DESTRA MAULANA', '0', '50000', 'Ipul', '2025-05-24 22:03:52'),
('3119', 'ST10100220250524080407', '1446-11-26', '1.100.10', '101', 'an.MASRUROTUL MAULUDIYAH', '5000', '0', 'Ipul', '2025-05-24 22:04:07'),
('3120', 'ST10100220250524080407', '1446-11-26', '2.220.10', '101', 'an.MASRUROTUL MAULUDIYAH', '0', '5000', 'Ipul', '2025-05-24 22:04:07'),
('3121', 'ST10100220250524080423', '1446-11-26', '1.100.10', '101', 'an.SAHILA MAFATIHATUL JANNAH', '5000', '0', 'Ipul', '2025-05-24 22:04:23'),
('3122', 'ST10100220250524080423', '1446-11-26', '2.220.10', '101', 'an.SAHILA MAFATIHATUL JANNAH', '0', '5000', 'Ipul', '2025-05-24 22:04:23'),
('3123', 'ST10100220250524080439', '1446-11-26', '1.100.10', '101', 'an.AHMAD ADITIYA', '4000', '0', 'Ipul', '2025-05-24 22:04:39'),
('3124', 'ST10100220250524080439', '1446-11-26', '2.220.10', '101', 'an.AHMAD ADITIYA', '0', '4000', 'Ipul', '2025-05-24 22:04:39'),
('3125', 'ST10100220250524080505', '1446-11-26', '1.100.10', '101', 'an.M. FAHMI NURUL ANAM', '10000', '0', 'Ipul', '2025-05-24 22:05:05'),
('3126', 'ST10100220250524080505', '1446-11-26', '2.220.10', '101', 'an.M. FAHMI NURUL ANAM', '0', '10000', 'Ipul', '2025-05-24 22:05:05'),
('3127', 'ST10100220250524080533', '1446-11-26', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '10000', '0', 'Ipul', '2025-05-24 22:05:33'),
('3128', 'ST10100220250524080533', '1446-11-26', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '10000', 'Ipul', '2025-05-24 22:05:33'),
('3129', 'ST10100220250524080549', '1446-11-26', '1.100.10', '101', 'an.SITI ATHIUR ROHMAH', '5000', '0', 'Ipul', '2025-05-24 22:05:49'),
('3130', 'ST10100220250524080549', '1446-11-26', '2.220.10', '101', 'an.SITI ATHIUR ROHMAH', '0', '5000', 'Ipul', '2025-05-24 22:05:49'),
('3131', 'ST10100220250524080609', '1446-11-26', '1.100.10', '101', 'an.ABDUL HAMID', '2000', '0', 'Ipul', '2025-05-24 22:06:09'),
('3132', 'ST10100220250524080609', '1446-11-26', '2.220.10', '101', 'an.ABDUL HAMID', '0', '2000', 'Ipul', '2025-05-24 22:06:09'),
('3133', 'ST10100220250524080624', '1446-11-26', '1.100.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '10000', '0', 'Ipul', '2025-05-24 22:06:24'),
('3134', 'ST10100220250524080624', '1446-11-26', '2.220.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '0', '10000', 'Ipul', '2025-05-24 22:06:24'),
('3135', 'ST10100220250524080639', '1446-11-26', '1.100.10', '101', 'an.SITI QURROTUL AINI', '2000', '0', 'Ipul', '2025-05-24 22:06:39'),
('3136', 'ST10100220250524080639', '1446-11-26', '2.220.10', '101', 'an.SITI QURROTUL AINI', '0', '2000', 'Ipul', '2025-05-24 22:06:39'),
('3137', 'ST10100220250524080656', '1446-11-26', '1.100.10', '101', 'an.AHMAD RAFI SALIM', '2000', '0', 'Ipul', '2025-05-24 22:06:56'),
('3138', 'ST10100220250524080656', '1446-11-26', '2.220.10', '101', 'an.AHMAD RAFI SALIM', '0', '2000', 'Ipul', '2025-05-24 22:06:56'),
('3139', 'ST10100220250524080720', '1446-11-26', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '10000', '0', 'Ipul', '2025-05-24 22:07:20'),
('3140', 'ST10100220250524080720', '1446-11-26', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '10000', 'Ipul', '2025-05-24 22:07:20'),
('3141', 'ST10100220250524080737', '1446-11-26', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Ipul', '2025-05-24 22:07:37'),
('3142', 'ST10100220250524080737', '1446-11-26', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Ipul', '2025-05-24 22:07:37'),
('3143', 'ST10100220250524080800', '1446-11-26', '1.100.10', '101', 'an.MIFTAHUL JANNAH', '50000', '0', 'Ipul', '2025-05-24 22:08:00'),
('3144', 'ST10100220250524080800', '1446-11-26', '2.220.10', '101', 'an.MIFTAHUL JANNAH', '0', '50000', 'Ipul', '2025-05-24 22:08:00'),
('3145', 'ST10100220250524080819', '1446-11-26', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '2000', '0', 'Ipul', '2025-05-24 22:08:19'),
('3146', 'ST10100220250524080819', '1446-11-26', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '2000', 'Ipul', '2025-05-24 22:08:19'),
('3147', 'ST10100220250524080841', '1446-11-26', '1.100.10', '101', 'an.M. KAMALUDDIN', '20000', '0', 'Ipul', '2025-05-24 22:08:41'),
('3148', 'ST10100220250524080841', '1446-11-26', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '20000', 'Ipul', '2025-05-24 22:08:41'),
('3149', 'ST10100220250524080915', '1446-11-26', '1.100.10', '101', 'an.NABILATUN NISAUL UMMAH', '20000', '0', 'Ipul', '2025-05-24 22:09:15'),
('3150', 'ST10100220250524080915', '1446-11-26', '2.220.10', '101', 'an.NABILATUN NISAUL UMMAH', '0', '20000', 'Ipul', '2025-05-24 22:09:15'),
('3151', 'ST10100220250524080929', '1446-11-26', '1.100.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '5000', '0', 'Ipul', '2025-05-24 22:09:29'),
('3152', 'ST10100220250524080929', '1446-11-26', '2.220.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '0', '5000', 'Ipul', '2025-05-24 22:09:29'),
('3153', 'ST10100220250524080955', '1446-11-26', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '5000', '0', 'Ipul', '2025-05-24 22:09:55'),
('3154', 'ST10100220250524080955', '1446-11-26', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '5000', 'Ipul', '2025-05-24 22:09:55'),
('3155', 'ST10100220250524081010', '1446-11-26', '1.100.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '5000', '0', 'Ipul', '2025-05-24 22:10:10'),
('3156', 'ST10100220250524081010', '1446-11-26', '2.220.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '0', '5000', 'Ipul', '2025-05-24 22:10:10'),
('3157', 'ST10100220250524081030', '1446-11-26', '1.100.10', '101', 'an.RAUDHOTUL JANNAH', '60000', '0', 'Ipul', '2025-05-24 22:10:30'),
('3158', 'ST10100220250524081030', '1446-11-26', '2.220.10', '101', 'an.RAUDHOTUL JANNAH', '0', '60000', 'Ipul', '2025-05-24 22:10:30'),
('3159', 'ST10100220250524081054', '1446-11-26', '1.100.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '20000', '0', 'Ipul', '2025-05-24 22:10:54'),
('3160', 'ST10100220250524081054', '1446-11-26', '2.220.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '0', '20000', 'Ipul', '2025-05-24 22:10:54'),
('3161', 'ST10100220250524081110', '1446-11-26', '1.100.10', '101', 'an.MUHAMMAD ILHAM', '5000', '0', 'Ipul', '2025-05-24 22:11:10'),
('3162', 'ST10100220250524081110', '1446-11-26', '2.220.10', '101', 'an.MUHAMMAD ILHAM', '0', '5000', 'Ipul', '2025-05-24 22:11:10'),
('3165', 'ST10100220250524081410', '1446-11-26', '1.100.10', '101', 'an.SINDI RAISA PUTRI', '10000', '0', 'Ipul', '2025-05-24 22:14:10'),
('3166', 'ST10100220250524081410', '1446-11-26', '2.220.10', '101', 'an.SINDI RAISA PUTRI', '0', '10000', 'Ipul', '2025-05-24 22:14:10'),
('3167', 'ST10100220250524081429', '1446-11-26', '1.100.10', '101', 'an.AHMAD ABBAS MAULANA', '3000', '0', 'Ipul', '2025-05-24 22:14:29'),
('3168', 'ST10100220250524081429', '1446-11-26', '2.220.10', '101', 'an.AHMAD ABBAS MAULANA', '0', '3000', 'Ipul', '2025-05-24 22:14:29'),
('3169', 'ST10100220250524081449', '1446-11-26', '1.100.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '10000', '0', 'Ipul', '2025-05-24 22:14:49'),
('3170', 'ST10100220250524081449', '1446-11-26', '2.220.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '0', '10000', 'Ipul', '2025-05-24 22:14:49'),
('3171', 'ST10100220250524081507', '1446-11-26', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '25000', '0', 'Ipul', '2025-05-24 22:15:07'),
('3172', 'ST10100220250524081507', '1446-11-26', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '25000', 'Ipul', '2025-05-24 22:15:07'),
('3173', 'ST10100220250524081524', '1446-11-26', '1.100.10', '101', 'an.AKHMAD FIKRI HAIKAL', '50000', '0', 'Ipul', '2025-05-24 22:15:24'),
('3174', 'ST10100220250524081524', '1446-11-26', '2.220.10', '101', 'an.AKHMAD FIKRI HAIKAL', '0', '50000', 'Ipul', '2025-05-24 22:15:24'),
('3175', 'ST10100220250524081538', '1446-11-26', '1.100.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '5000', '0', 'Ipul', '2025-05-24 22:15:38'),
('3176', 'ST10100220250524081538', '1446-11-26', '2.220.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '0', '5000', 'Ipul', '2025-05-24 22:15:38'),
('3177', 'ST10100220250524081607', '1446-11-26', '1.100.10', '101', 'an.ZAKIYATUL UMMAH', '2000', '0', 'Ipul', '2025-05-24 22:16:07'),
('3178', 'ST10100220250524081607', '1446-11-26', '2.220.10', '101', 'an.ZAKIYATUL UMMAH', '0', '2000', 'Ipul', '2025-05-24 22:16:07'),
('3179', 'ST10100220250524081622', '1446-11-26', '1.100.10', '101', 'an.AFANDI', '2000', '0', 'Ipul', '2025-05-24 22:16:22'),
('3180', 'ST10100220250524081622', '1446-11-26', '2.220.10', '101', 'an.AFANDI', '0', '2000', 'Ipul', '2025-05-24 22:16:22'),
('3181', 'ST10100220250524081641', '1446-11-26', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '5000', '0', 'Ipul', '2025-05-24 22:16:41'),
('3182', 'ST10100220250524081641', '1446-11-26', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '5000', 'Ipul', '2025-05-24 22:16:41'),
('3183', 'ST10100220250524081705', '1446-11-26', '1.100.10', '101', 'an.M. ALIFIN FIKRI', '4000', '0', 'Ipul', '2025-05-24 22:17:05'),
('3184', 'ST10100220250524081705', '1446-11-26', '2.220.10', '101', 'an.M. ALIFIN FIKRI', '0', '4000', 'Ipul', '2025-05-24 22:17:05'),
('3185', 'ST10100220250524081721', '1446-11-26', '1.100.10', '101', 'an.MUHAMMAD KHOIRON', '2000', '0', 'Ipul', '2025-05-24 22:17:21'),
('3186', 'ST10100220250524081721', '1446-11-26', '2.220.10', '101', 'an.MUHAMMAD KHOIRON', '0', '2000', 'Ipul', '2025-05-24 22:17:21'),
('3187', 'ST10100220250524081930', '1446-11-26', '1.100.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '2000', '0', 'Ipul', '2025-05-24 22:19:30'),
('3188', 'ST10100220250524081930', '1446-11-26', '2.220.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '0', '2000', 'Ipul', '2025-05-24 22:19:30'),
('3189', 'ST10100220250524081952', '1446-11-26', '1.100.10', '101', 'an.ACH. JUNAIDI', '5000', '0', 'Ipul', '2025-05-24 22:19:52'),
('3190', 'ST10100220250524081952', '1446-11-26', '2.220.10', '101', 'an.ACH. JUNAIDI', '0', '5000', 'Ipul', '2025-05-24 22:19:52'),
('3191', 'ST10100220250524082024', '1446-11-26', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '5000', '0', 'Ipul', '2025-05-24 22:20:24'),
('3192', 'ST10100220250524082024', '1446-11-26', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '5000', 'Ipul', '2025-05-24 22:20:24'),
('3193', 'ST10100220250524082040', '1446-11-26', '1.100.10', '101', 'an.ALFIN HIDAYAT', '10000', '0', 'Ipul', '2025-05-24 22:20:40'),
('3194', 'ST10100220250524082040', '1446-11-26', '2.220.10', '101', 'an.ALFIN HIDAYAT', '0', '10000', 'Ipul', '2025-05-24 22:20:40'),
('3195', 'ST10100220250524082054', '1446-11-26', '1.100.10', '101', 'an.SAFIRATUL JANNAH', '10000', '0', 'Ipul', '2025-05-24 22:20:54'),
('3196', 'ST10100220250524082054', '1446-11-26', '2.220.10', '101', 'an.SAFIRATUL JANNAH', '0', '10000', 'Ipul', '2025-05-24 22:20:54'),
('3197', 'ST10100220250524082306', '1446-11-26', '1.100.10', '101', 'an.HAMIDAH', '100000', '0', 'Ipul', '2025-05-24 22:23:06'),
('3198', 'ST10100220250524082306', '1446-11-26', '2.220.10', '101', 'an.HAMIDAH', '0', '100000', 'Ipul', '2025-05-24 22:23:06'),
('3199', 'ST10100220250524082333', '1446-11-26', '1.100.10', '101', 'an.HILYA', '30000', '0', 'Ipul', '2025-05-24 22:23:33'),
('3200', 'ST10100220250524082333', '1446-11-26', '2.220.10', '101', 'an.HILYA', '0', '30000', 'Ipul', '2025-05-24 22:23:33'),
('3201', 'ST10100220250524082354', '1446-11-26', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'Ipul', '2025-05-24 22:23:54'),
('3202', 'ST10100220250524082354', '1446-11-26', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'Ipul', '2025-05-24 22:23:54'),
('3203', 'ST10100220250524082419', '1446-11-26', '1.100.10', '101', 'an.M.AKMALUL HIMAM', '10000', '0', 'Ipul', '2025-05-24 22:24:19'),
('3204', 'ST10100220250524082419', '1446-11-26', '2.220.10', '101', 'an.M.AKMALUL HIMAM', '0', '10000', 'Ipul', '2025-05-24 22:24:19'),
('3205', 'ST10100220250524081341', '1446-11-26', '1.100.10', '101', 'an.BILQIS THALIA HASNA', '230000', '0', 'Ipul', '2025-05-24 22:33:52'),
('3206', 'ST10100220250524081341', '1446-11-26', '2.220.10', '101', 'an.BILQIS THALIA HASNA', '0', '230000', 'Ipul', '2025-05-24 22:33:52'),
('3209', 'ST10100220250525081214', '1446-11-27', '1.100.10', '101', 'an.SITI SHOFIYAH LABIBAH', '30000', '0', 'Ipul', '2025-05-25 22:12:14'),
('3210', 'ST10100220250525081214', '1446-11-27', '2.220.10', '101', 'an.SITI SHOFIYAH LABIBAH', '0', '30000', 'Ipul', '2025-05-25 22:12:14'),
('3211', 'ST10100320250525081436', '1446-11-27', '1.100.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '2000', '0', 'Chuwez', '2025-05-25 22:14:36'),
('3212', 'ST10100320250525081436', '1446-11-27', '2.220.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '0', '2000', 'Chuwez', '2025-05-25 22:14:36'),
('3213', 'ST10100320250525081451', '1446-11-27', '1.100.10', '101', 'an.M. ABD. HADI', '4000', '0', 'Chuwez', '2025-05-25 22:14:51'),
('3214', 'ST10100320250525081451', '1446-11-27', '2.220.10', '101', 'an.M. ABD. HADI', '0', '4000', 'Chuwez', '2025-05-25 22:14:51'),
('3215', 'ST10100320250525081509', '1446-11-27', '1.100.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '5000', '0', 'Chuwez', '2025-05-25 22:15:09'),
('3216', 'ST10100320250525081509', '1446-11-27', '2.220.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '0', '5000', 'Chuwez', '2025-05-25 22:15:09'),
('3217', 'ST10100320250525081527', '1446-11-27', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'Chuwez', '2025-05-25 22:15:27'),
('3218', 'ST10100320250525081527', '1446-11-27', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'Chuwez', '2025-05-25 22:15:27'),
('3219', 'ST10100320250525081556', '1446-11-27', '1.100.10', '101', 'an.NAURA BILADINA', '10000', '0', 'Chuwez', '2025-05-25 22:15:56'),
('3220', 'ST10100320250525081556', '1446-11-27', '2.220.10', '101', 'an.NAURA BILADINA', '0', '10000', 'Chuwez', '2025-05-25 22:15:56'),
('3221', 'ST10100320250525081615', '1446-11-27', '1.100.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '5000', '0', 'Chuwez', '2025-05-25 22:16:15'),
('3222', 'ST10100320250525081615', '1446-11-27', '2.220.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '0', '5000', 'Chuwez', '2025-05-25 22:16:15'),
('3223', 'ST10100320250525081633', '1446-11-27', '1.100.10', '101', 'an.HAIKAL SHOMADANI', '6000', '0', 'Chuwez', '2025-05-25 22:16:33'),
('3224', 'ST10100320250525081633', '1446-11-27', '2.220.10', '101', 'an.HAIKAL SHOMADANI', '0', '6000', 'Chuwez', '2025-05-25 22:16:33'),
('3225', 'ST10100320250525081649', '1446-11-27', '1.100.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '10000', '0', 'Chuwez', '2025-05-25 22:16:49'),
('3226', 'ST10100320250525081649', '1446-11-27', '2.220.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '0', '10000', 'Chuwez', '2025-05-25 22:16:49'),
('3227', 'ST10100320250525081714', '1446-11-27', '1.100.10', '101', 'an.UBAIDAH', '10000', '0', 'Chuwez', '2025-05-25 22:17:14'),
('3228', 'ST10100320250525081714', '1446-11-27', '2.220.10', '101', 'an.UBAIDAH', '0', '10000', 'Chuwez', '2025-05-25 22:17:14'),
('3229', 'ST10100320250525081726', '1446-11-27', '1.100.10', '101', 'an.NAILATUN NIAMI', '5000', '0', 'Chuwez', '2025-05-25 22:17:26'),
('3230', 'ST10100320250525081726', '1446-11-27', '2.220.10', '101', 'an.NAILATUN NIAMI', '0', '5000', 'Chuwez', '2025-05-25 22:17:26'),
('3231', 'ST10100320250525081738', '1446-11-27', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'Chuwez', '2025-05-25 22:17:38'),
('3232', 'ST10100320250525081738', '1446-11-27', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'Chuwez', '2025-05-25 22:17:38'),
('3233', 'ST10100320250525081854', '1446-11-27', '1.100.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '4000', '0', 'Chuwez', '2025-05-25 22:18:54'),
('3234', 'ST10100320250525081854', '1446-11-27', '2.220.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '0', '4000', 'Chuwez', '2025-05-25 22:18:54'),
('3235', 'ST10100320250525081917', '1446-11-27', '1.100.10', '101', 'an.MARIATUL QIBTIYAH', '4000', '0', 'Chuwez', '2025-05-25 22:19:17'),
('3236', 'ST10100320250525081917', '1446-11-27', '2.220.10', '101', 'an.MARIATUL QIBTIYAH', '0', '4000', 'Chuwez', '2025-05-25 22:19:17'),
('3237', 'ST10100320250525081930', '1446-11-27', '1.100.10', '101', 'an.SAUQY AHMAD', '5000', '0', 'Chuwez', '2025-05-25 22:19:30'),
('3238', 'ST10100320250525081930', '1446-11-27', '2.220.10', '101', 'an.SAUQY AHMAD', '0', '5000', 'Chuwez', '2025-05-25 22:19:30'),
('3239', 'ST10100320250525081945', '1446-11-27', '1.100.10', '101', 'an.UMAR FARUQ', '10000', '0', 'Chuwez', '2025-05-25 22:19:45'),
('3240', 'ST10100320250525081945', '1446-11-27', '2.220.10', '101', 'an.UMAR FARUQ', '0', '10000', 'Chuwez', '2025-05-25 22:19:45'),
('3241', 'ST10100320250525081957', '1446-11-27', '1.100.10', '101', 'an.M. ABDIL ARIKIN', '5000', '0', 'Chuwez', '2025-05-25 22:19:57'),
('3242', 'ST10100320250525081957', '1446-11-27', '2.220.10', '101', 'an.M. ABDIL ARIKIN', '0', '5000', 'Chuwez', '2025-05-25 22:19:57'),
('3243', 'ST10100320250525082011', '1446-11-27', '1.100.10', '101', 'an.MARIYATUL QIBTIYAH', '5000', '0', 'Chuwez', '2025-05-25 22:20:11'),
('3244', 'ST10100320250525082011', '1446-11-27', '2.220.10', '101', 'an.MARIYATUL QIBTIYAH', '0', '5000', 'Chuwez', '2025-05-25 22:20:11'),
('3245', 'ST10100320250525082026', '1446-11-27', '1.100.10', '101', 'an.MUHAMMAD ALWI', '10000', '0', 'Chuwez', '2025-05-25 22:20:26'),
('3246', 'ST10100320250525082026', '1446-11-27', '2.220.10', '101', 'an.MUHAMMAD ALWI', '0', '10000', 'Chuwez', '2025-05-25 22:20:26'),
('3247', 'ST10100320250525082047', '1446-11-27', '1.100.10', '101', 'an.AISYAH', '2000', '0', 'Chuwez', '2025-05-25 22:20:47'),
('3248', 'ST10100320250525082047', '1446-11-27', '2.220.10', '101', 'an.AISYAH', '0', '2000', 'Chuwez', '2025-05-25 22:20:47'),
('3249', 'ST10100320250525082100', '1446-11-27', '1.100.10', '101', 'an.ALFI NURDIANA', '5000', '0', 'Chuwez', '2025-05-25 22:21:00'),
('3250', 'ST10100320250525082100', '1446-11-27', '2.220.10', '101', 'an.ALFI NURDIANA', '0', '5000', 'Chuwez', '2025-05-25 22:21:00'),
('3251', 'ST10100320250525082117', '1446-11-27', '1.100.10', '101', 'an.MASRUROTUL MAULUDIYAH', '5000', '0', 'Chuwez', '2025-05-25 22:21:17'),
('3252', 'ST10100320250525082117', '1446-11-27', '2.220.10', '101', 'an.MASRUROTUL MAULUDIYAH', '0', '5000', 'Chuwez', '2025-05-25 22:21:17'),
('3253', 'ST10100320250525082130', '1446-11-27', '1.100.10', '101', 'an.DIANA RIFQOTUL QOLBI', '5000', '0', 'Chuwez', '2025-05-25 22:21:30'),
('3254', 'ST10100320250525082130', '1446-11-27', '2.220.10', '101', 'an.DIANA RIFQOTUL QOLBI', '0', '5000', 'Chuwez', '2025-05-25 22:21:30'),
('3255', 'ST10100320250525082150', '1446-11-27', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '10000', '0', 'Chuwez', '2025-05-25 22:21:50'),
('3256', 'ST10100320250525082150', '1446-11-27', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '10000', 'Chuwez', '2025-05-25 22:21:50'),
('3257', 'ST10100320250525082212', '1446-11-27', '1.100.10', '101', 'an.AZKA AUFARIL MINAN', '10000', '0', 'Chuwez', '2025-05-25 22:22:12'),
('3258', 'ST10100320250525082212', '1446-11-27', '2.220.10', '101', 'an.AZKA AUFARIL MINAN', '0', '10000', 'Chuwez', '2025-05-25 22:22:12'),
('3259', 'ST10100320250525082243', '1446-11-27', '1.100.10', '101', 'an.AHMAD ADITIYA', '2000', '0', 'Chuwez', '2025-05-25 22:22:43'),
('3260', 'ST10100320250525082243', '1446-11-27', '2.220.10', '101', 'an.AHMAD ADITIYA', '0', '2000', 'Chuwez', '2025-05-25 22:22:43'),
('3261', 'ST10100320250525082308', '1446-11-27', '1.100.10', '101', 'an.WARDATUL JANNAH', '8000', '0', 'Chuwez', '2025-05-25 22:23:08'),
('3262', 'ST10100320250525082308', '1446-11-27', '2.220.10', '101', 'an.WARDATUL JANNAH', '0', '8000', 'Chuwez', '2025-05-25 22:23:08'),
('3263', 'ST10100320250525082321', '1446-11-27', '1.100.10', '101', 'an.SITI QURROTUL AINI', '2000', '0', 'Chuwez', '2025-05-25 22:23:21'),
('3264', 'ST10100320250525082321', '1446-11-27', '2.220.10', '101', 'an.SITI QURROTUL AINI', '0', '2000', 'Chuwez', '2025-05-25 22:23:21'),
('3265', 'ST10100320250525082334', '1446-11-27', '1.100.10', '101', 'an.HIKMIAH PUTRI NIKMATUNNAFILAH', '5000', '0', 'Chuwez', '2025-05-25 22:23:34'),
('3266', 'ST10100320250525082334', '1446-11-27', '2.220.10', '101', 'an.HIKMIAH PUTRI NIKMATUNNAFILAH', '0', '5000', 'Chuwez', '2025-05-25 22:23:34'),
('3267', 'ST10100320250525082350', '1446-11-27', '1.100.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '10000', '0', 'Chuwez', '2025-05-25 22:23:50'),
('3268', 'ST10100320250525082350', '1446-11-27', '2.220.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '0', '10000', 'Chuwez', '2025-05-25 22:23:50'),
('3269', 'ST10100320250525082407', '1446-11-27', '1.100.10', '101', 'an.M. FAHMI NURUL ANAM', '20000', '0', 'Chuwez', '2025-05-25 22:24:07'),
('3270', 'ST10100320250525082407', '1446-11-27', '2.220.10', '101', 'an.M. FAHMI NURUL ANAM', '0', '20000', 'Chuwez', '2025-05-25 22:24:07'),
('3271', 'ST10100320250525082419', '1446-11-27', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '10000', '0', 'Chuwez', '2025-05-25 22:24:19'),
('3272', 'ST10100320250525082419', '1446-11-27', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '10000', 'Chuwez', '2025-05-25 22:24:19'),
('3273', 'ST10100320250525082433', '1446-11-27', '1.100.10', '101', 'an.DIYANAH KAMALIYAH', '7000', '0', 'Chuwez', '2025-05-25 22:24:33'),
('3274', 'ST10100320250525082433', '1446-11-27', '2.220.10', '101', 'an.DIYANAH KAMALIYAH', '0', '7000', 'Chuwez', '2025-05-25 22:24:33'),
('3275', 'ST10100320250525082447', '1446-11-27', '1.100.10', '101', 'an.SITI ATHIUR ROHMAH', '5000', '0', 'Chuwez', '2025-05-25 22:24:47'),
('3276', 'ST10100320250525082447', '1446-11-27', '2.220.10', '101', 'an.SITI ATHIUR ROHMAH', '0', '5000', 'Chuwez', '2025-05-25 22:24:47'),
('3277', 'ST10100320250525082741', '1446-11-27', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '5000', '0', 'Chuwez', '2025-05-25 22:27:41'),
('3278', 'ST10100320250525082741', '1446-11-27', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '5000', 'Chuwez', '2025-05-25 22:27:41'),
('3279', 'ST10100320250525082821', '1446-11-27', '1.100.10', '101', 'an.RAUDHOTUL JANNAH', '20000', '0', 'Chuwez', '2025-05-25 22:28:21'),
('3280', 'ST10100320250525082821', '1446-11-27', '2.220.10', '101', 'an.RAUDHOTUL JANNAH', '0', '20000', 'Chuwez', '2025-05-25 22:28:21'),
('3281', 'ST10100320250525082846', '1446-11-27', '1.100.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '10000', '0', 'Chuwez', '2025-05-25 22:28:46'),
('3282', 'ST10100320250525082846', '1446-11-27', '2.220.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '0', '10000', 'Chuwez', '2025-05-25 22:28:46'),
('3283', 'ST10100320250525082901', '1446-11-27', '1.100.10', '101', 'an.M. KAMALUDDIN', '20000', '0', 'Chuwez', '2025-05-25 22:29:01'),
('3284', 'ST10100320250525082901', '1446-11-27', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '20000', 'Chuwez', '2025-05-25 22:29:01'),
('3285', 'ST10100320250525082918', '1446-11-27', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '10000', '0', 'Chuwez', '2025-05-25 22:29:18'),
('3286', 'ST10100320250525082918', '1446-11-27', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '10000', 'Chuwez', '2025-05-25 22:29:18'),
('3287', 'ST10100320250525082932', '1446-11-27', '1.100.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '5000', '0', 'Chuwez', '2025-05-25 22:29:32'),
('3288', 'ST10100320250525082932', '1446-11-27', '2.220.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '0', '5000', 'Chuwez', '2025-05-25 22:29:32'),
('3289', 'ST10100320250525082947', '1446-11-27', '1.100.10', '101', 'an.NABILATUN NISAUL UMMAH', '20000', '0', 'Chuwez', '2025-05-25 22:29:47'),
('3290', 'ST10100320250525082947', '1446-11-27', '2.220.10', '101', 'an.NABILATUN NISAUL UMMAH', '0', '20000', 'Chuwez', '2025-05-25 22:29:47'),
('3291', 'ST10100320250525083002', '1446-11-27', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Chuwez', '2025-05-25 22:30:02'),
('3292', 'ST10100320250525083002', '1446-11-27', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Chuwez', '2025-05-25 22:30:02'),
('3293', 'ST10100320250525083018', '1446-11-27', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '3000', '0', 'Chuwez', '2025-05-25 22:30:18'),
('3294', 'ST10100320250525083018', '1446-11-27', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '3000', 'Chuwez', '2025-05-25 22:30:19'),
('3295', 'ST10100320250525083153', '1446-11-27', '1.100.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '10000', '0', 'Chuwez', '2025-05-25 22:31:53'),
('3296', 'ST10100320250525083153', '1446-11-27', '2.220.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '0', '10000', 'Chuwez', '2025-05-25 22:31:53'),
('3297', 'ST10100320250525083209', '1446-11-27', '1.100.10', '101', 'an.M. ROFIQ HIDAYATULLOH', '10000', '0', 'Chuwez', '2025-05-25 22:32:09'),
('3298', 'ST10100320250525083209', '1446-11-27', '2.220.10', '101', 'an.M. ROFIQ HIDAYATULLOH', '0', '10000', 'Chuwez', '2025-05-25 22:32:09'),
('3299', 'ST10100320250525083223', '1446-11-27', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '25000', '0', 'Chuwez', '2025-05-25 22:32:23'),
('3300', 'ST10100320250525083223', '1446-11-27', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '25000', 'Chuwez', '2025-05-25 22:32:23'),
('3301', 'ST10100320250525083238', '1446-11-27', '1.100.10', '101', 'an.SINDI RAISA PUTRI', '10000', '0', 'Chuwez', '2025-05-25 22:32:38'),
('3302', 'ST10100320250525083238', '1446-11-27', '2.220.10', '101', 'an.SINDI RAISA PUTRI', '0', '10000', 'Chuwez', '2025-05-25 22:32:38'),
('3303', 'ST10100320250525083252', '1446-11-27', '1.100.10', '101', 'an.BILQIS THALIA HASNA', '60000', '0', 'Chuwez', '2025-05-25 22:32:52'),
('3304', 'ST10100320250525083252', '1446-11-27', '2.220.10', '101', 'an.BILQIS THALIA HASNA', '0', '60000', 'Chuwez', '2025-05-25 22:32:52'),
('3305', 'ST10100320250525083307', '1446-11-27', '1.100.10', '101', 'an.AHMAD ABBAS MAULANA', '4000', '0', 'Chuwez', '2025-05-25 22:33:07'),
('3306', 'ST10100320250525083307', '1446-11-27', '2.220.10', '101', 'an.AHMAD ABBAS MAULANA', '0', '4000', 'Chuwez', '2025-05-25 22:33:07'),
('3307', 'ST10100320250525083328', '1446-11-27', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'Chuwez', '2025-05-25 22:33:28'),
('3308', 'ST10100320250525083328', '1446-11-27', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'Chuwez', '2025-05-25 22:33:28'),
('3309', 'ST10100320250525083342', '1446-11-27', '1.100.10', '101', 'an.MACHMUDAH', '10000', '0', 'Chuwez', '2025-05-25 22:33:42'),
('3310', 'ST10100320250525083342', '1446-11-27', '2.220.10', '101', 'an.MACHMUDAH', '0', '10000', 'Chuwez', '2025-05-25 22:33:42'),
('3311', 'ST10100320250525083400', '1446-11-27', '1.100.10', '101', 'an.HILYA', '20000', '0', 'Chuwez', '2025-05-25 22:34:00'),
('3312', 'ST10100320250525083400', '1446-11-27', '2.220.10', '101', 'an.HILYA', '0', '20000', 'Chuwez', '2025-05-25 22:34:00'),
('3313', 'ST10100320250525083421', '1446-11-27', '1.100.10', '101', 'an.UST THORIQUL HUDA', '100000', '0', 'Chuwez', '2025-05-25 22:34:21'),
('3314', 'ST10100320250525083421', '1446-11-27', '2.220.10', '101', 'an.UST THORIQUL HUDA', '0', '100000', 'Chuwez', '2025-05-25 22:34:21'),
('3315', 'ST10100320250525083546', '1446-11-27', '1.100.10', '101', 'an.MUHAMMAD KHOIRON', '10000', '0', 'Chuwez', '2025-05-25 22:35:46'),
('3316', 'ST10100320250525083546', '1446-11-27', '2.220.10', '101', 'an.MUHAMMAD KHOIRON', '0', '10000', 'Chuwez', '2025-05-25 22:35:46'),
('3317', 'ST10100320250525083558', '1446-11-27', '1.100.10', '101', 'an.AFANDI', '2000', '0', 'Chuwez', '2025-05-25 22:35:58'),
('3318', 'ST10100320250525083558', '1446-11-27', '2.220.10', '101', 'an.AFANDI', '0', '2000', 'Chuwez', '2025-05-25 22:35:58'),
('3319', 'ST10100320250525083613', '1446-11-27', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '5000', '0', 'Chuwez', '2025-05-25 22:36:13'),
('3320', 'ST10100320250525083613', '1446-11-27', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '5000', 'Chuwez', '2025-05-25 22:36:13'),
('3321', 'ST10100320250525083632', '1446-11-27', '1.100.10', '101', 'an.ANA SALSABILA', '7000', '0', 'Chuwez', '2025-05-25 22:36:32'),
('3322', 'ST10100320250525083632', '1446-11-27', '2.220.10', '101', 'an.ANA SALSABILA', '0', '7000', 'Chuwez', '2025-05-25 22:36:32'),
('3323', 'ST10100320250525083650', '1446-11-27', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '6000', '0', 'Chuwez', '2025-05-25 22:36:50'),
('3324', 'ST10100320250525083650', '1446-11-27', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '6000', 'Chuwez', '2025-05-25 22:36:50'),
('3325', 'ST10100320250525083702', '1446-11-27', '1.100.10', '101', 'an.ZAKIYATUL UMMAH', '2000', '0', 'Chuwez', '2025-05-25 22:37:02'),
('3326', 'ST10100320250525083702', '1446-11-27', '2.220.10', '101', 'an.ZAKIYATUL UMMAH', '0', '2000', 'Chuwez', '2025-05-25 22:37:02'),
('3327', 'ST10100320250525083715', '1446-11-27', '1.100.10', '101', 'an.M. ALIFIN FIKRI', '5000', '0', 'Chuwez', '2025-05-25 22:37:15'),
('3328', 'ST10100320250525083715', '1446-11-27', '2.220.10', '101', 'an.M. ALIFIN FIKRI', '0', '5000', 'Chuwez', '2025-05-25 22:37:15'),
('3329', 'ST10100320250525083730', '1446-11-27', '1.100.10', '101', 'an.M. ZIDAN RIZQI SALIM', '5000', '0', 'Chuwez', '2025-05-25 22:37:30'),
('3330', 'ST10100320250525083730', '1446-11-27', '2.220.10', '101', 'an.M. ZIDAN RIZQI SALIM', '0', '5000', 'Chuwez', '2025-05-25 22:37:30'),
('3331', 'ST10100320250525083743', '1446-11-27', '1.100.10', '101', 'an.MUHAMMAD KANZUL KAROMI', '10000', '0', 'Chuwez', '2025-05-25 22:37:43'),
('3332', 'ST10100320250525083743', '1446-11-27', '2.220.10', '101', 'an.MUHAMMAD KANZUL KAROMI', '0', '10000', 'Chuwez', '2025-05-25 22:37:43'),
('3333', 'ST10100320250525083803', '1446-11-27', '1.100.10', '101', 'an.ACH. JUNAIDI', '5000', '0', 'Chuwez', '2025-05-25 22:38:03'),
('3334', 'ST10100320250525083803', '1446-11-27', '2.220.10', '101', 'an.ACH. JUNAIDI', '0', '5000', 'Chuwez', '2025-05-25 22:38:03'),
('3335', 'ST10100320250525083818', '1446-11-27', '1.100.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '2000', '0', 'Chuwez', '2025-05-25 22:38:18'),
('3336', 'ST10100320250525083818', '1446-11-27', '2.220.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '0', '2000', 'Chuwez', '2025-05-25 22:38:18'),
('3337', 'ST10100320250525083833', '1446-11-27', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '5000', '0', 'Chuwez', '2025-05-25 22:38:33'),
('3338', 'ST10100320250525083833', '1446-11-27', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '5000', 'Chuwez', '2025-05-25 22:38:33'),
('3339', 'ST10100320250525083849', '1446-11-27', '1.100.10', '101', 'an.SAFIRATUL JANNAH', '10000', '0', 'Chuwez', '2025-05-25 22:38:49'),
('3340', 'ST10100320250525083849', '1446-11-27', '2.220.10', '101', 'an.SAFIRATUL JANNAH', '0', '10000', 'Chuwez', '2025-05-25 22:38:49'),
('3341', 'ST10100320250526061055', '1446-11-28', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '10000', '0', 'Chuwez', '2025-05-26 20:10:55'),
('3342', 'ST10100320250526061055', '1446-11-28', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '10000', 'Chuwez', '2025-05-26 20:10:55'),
('3343', 'ST10100320250526061121', '1446-11-28', '1.100.10', '101', 'an.AHMAD ADITIYA', '2000', '0', 'Chuwez', '2025-05-26 20:11:21'),
('3344', 'ST10100320250526061121', '1446-11-28', '2.220.10', '101', 'an.AHMAD ADITIYA', '0', '2000', 'Chuwez', '2025-05-26 20:11:21'),
('3345', 'ST10100320250526061149', '1446-11-28', '1.100.10', '101', 'an.IFTITAHUL IZZA', '100000', '0', 'Chuwez', '2025-05-26 20:11:49'),
('3346', 'ST10100320250526061149', '1446-11-28', '2.220.10', '101', 'an.IFTITAHUL IZZA', '0', '100000', 'Chuwez', '2025-05-26 20:11:49'),
('3347', 'ST10100320250526061226', '1446-11-28', '1.100.10', '101', 'an.AISYAH', '5000', '0', 'Chuwez', '2025-05-26 20:12:26'),
('3348', 'ST10100320250526061226', '1446-11-28', '2.220.10', '101', 'an.AISYAH', '0', '5000', 'Chuwez', '2025-05-26 20:12:26'),
('3349', 'ST10100320250526061252', '1446-11-28', '1.100.10', '101', 'an.LAILATUL MAGHFIROH', '10000', '0', 'Chuwez', '2025-05-26 20:12:52'),
('3350', 'ST10100320250526061252', '1446-11-28', '2.220.10', '101', 'an.LAILATUL MAGHFIROH', '0', '10000', 'Chuwez', '2025-05-26 20:12:52'),
('3351', 'ST10100320250526061321', '1446-11-28', '1.100.10', '101', 'an.MASRUROTUL MAULUDIYAH', '5000', '0', 'Chuwez', '2025-05-26 20:13:21'),
('3352', 'ST10100320250526061321', '1446-11-28', '2.220.10', '101', 'an.MASRUROTUL MAULUDIYAH', '0', '5000', 'Chuwez', '2025-05-26 20:13:21'),
('3353', 'ST10100320250526061357', '1446-11-28', '1.100.10', '101', 'an.ALFI NURDIANA', '5000', '0', 'Chuwez', '2025-05-26 20:13:57'),
('3354', 'ST10100320250526061357', '1446-11-28', '2.220.10', '101', 'an.ALFI NURDIANA', '0', '5000', 'Chuwez', '2025-05-26 20:13:57'),
('3355', 'ST10100320250526061422', '1446-11-28', '1.100.10', '101', 'an.DIANA RIFQOTUL QOLBI', '5000', '0', 'Chuwez', '2025-05-26 20:14:22'),
('3356', 'ST10100320250526061422', '1446-11-28', '2.220.10', '101', 'an.DIANA RIFQOTUL QOLBI', '0', '5000', 'Chuwez', '2025-05-26 20:14:22'),
('3357', 'ST10100320250526061454', '1446-11-28', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '5000', '0', 'Chuwez', '2025-05-26 20:14:54'),
('3358', 'ST10100320250526061454', '1446-11-28', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '5000', 'Chuwez', '2025-05-26 20:14:54'),
('3359', 'ST10100320250526061523', '1446-11-28', '1.100.10', '101', 'an.ACH. JUNAIDI', '5000', '0', 'Chuwez', '2025-05-26 20:15:23'),
('3360', 'ST10100320250526061523', '1446-11-28', '2.220.10', '101', 'an.ACH. JUNAIDI', '0', '5000', 'Chuwez', '2025-05-26 20:15:23'),
('3361', 'ST10100320250526061603', '1446-11-28', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '5000', '0', 'Chuwez', '2025-05-26 20:16:03'),
('3362', 'ST10100320250526061603', '1446-11-28', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '5000', 'Chuwez', '2025-05-26 20:16:04'),
('3363', 'ST10100320250526061953', '1446-11-28', '1.100.10', '101', 'an.M. FAHMI NURUL ANAM', '10000', '0', 'Chuwez', '2025-05-26 20:19:53'),
('3364', 'ST10100320250526061953', '1446-11-28', '2.220.10', '101', 'an.M. FAHMI NURUL ANAM', '0', '10000', 'Chuwez', '2025-05-26 20:19:53'),
('3365', 'ST10100320250526062108', '1446-11-28', '1.100.10', '101', 'an.MUHAMMAD ARDIANSYAH', '10000', '0', 'Chuwez', '2025-05-26 20:21:08'),
('3366', 'ST10100320250526062108', '1446-11-28', '2.220.10', '101', 'an.MUHAMMAD ARDIANSYAH', '0', '10000', 'Chuwez', '2025-05-26 20:21:08'),
('3367', 'ST10100320250526062140', '1446-11-28', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '5000', '0', 'Chuwez', '2025-05-26 20:21:40'),
('3368', 'ST10100320250526062140', '1446-11-28', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '5000', 'Chuwez', '2025-05-26 20:21:40'),
('3369', 'ST10100320250526062200', '1446-11-28', '1.100.10', '101', 'an.FAIZAH NURUL LITA', '5000', '0', 'Chuwez', '2025-05-26 20:22:00'),
('3370', 'ST10100320250526062200', '1446-11-28', '2.220.10', '101', 'an.FAIZAH NURUL LITA', '0', '5000', 'Chuwez', '2025-05-26 20:22:00'),
('3371', 'ST10100320250526062224', '1446-11-28', '1.100.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '2000', '0', 'Chuwez', '2025-05-26 20:22:24'),
('3372', 'ST10100320250526062224', '1446-11-28', '2.220.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '0', '2000', 'Chuwez', '2025-05-26 20:22:24'),
('3373', 'ST10100320250526062314', '1446-11-28', '1.100.10', '101', 'an.AZKA AUFARIL MINAN', '10000', '0', 'Chuwez', '2025-05-26 20:23:14'),
('3374', 'ST10100320250526062314', '1446-11-28', '2.220.10', '101', 'an.AZKA AUFARIL MINAN', '0', '10000', 'Chuwez', '2025-05-26 20:23:14'),
('3375', 'ST10100320250526062336', '1446-11-28', '1.100.10', '101', 'an.MUHAMMAD ALWI', '10000', '0', 'Chuwez', '2025-05-26 20:23:36'),
('3376', 'ST10100320250526062336', '1446-11-28', '2.220.10', '101', 'an.MUHAMMAD ALWI', '0', '10000', 'Chuwez', '2025-05-26 20:23:36'),
('3377', 'ST10100320250526062400', '1446-11-28', '1.100.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '4000', '0', 'Chuwez', '2025-05-26 20:24:00'),
('3378', 'ST10100320250526062400', '1446-11-28', '2.220.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '0', '4000', 'Chuwez', '2025-05-26 20:24:00'),
('3379', 'ST10100320250526062440', '1446-11-28', '1.100.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '20000', '0', 'Chuwez', '2025-05-26 20:24:40'),
('3380', 'ST10100320250526062440', '1446-11-28', '2.220.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '0', '20000', 'Chuwez', '2025-05-26 20:24:40'),
('3381', 'ST10100320250526062505', '1446-11-28', '1.100.10', '101', 'an.NAILATUN NIAMI', '2000', '0', 'Chuwez', '2025-05-26 20:25:05'),
('3382', 'ST10100320250526062505', '1446-11-28', '2.220.10', '101', 'an.NAILATUN NIAMI', '0', '2000', 'Chuwez', '2025-05-26 20:25:05'),
('3383', 'ST10100320250526062525', '1446-11-28', '1.100.10', '101', 'an.ABDULLOH BAHAR', '10000', '0', 'Chuwez', '2025-05-26 20:25:25'),
('3384', 'ST10100320250526062525', '1446-11-28', '2.220.10', '101', 'an.ABDULLOH BAHAR', '0', '10000', 'Chuwez', '2025-05-26 20:25:25'),
('3385', 'ST10100320250526062548', '1446-11-28', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'Chuwez', '2025-05-26 20:25:48'),
('3386', 'ST10100320250526062548', '1446-11-28', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'Chuwez', '2025-05-26 20:25:48'),
('3387', 'ST10100320250526062710', '1446-11-28', '1.100.10', '101', 'an.UMAR FARUQ', '10000', '0', 'Chuwez', '2025-05-26 20:27:10'),
('3388', 'ST10100320250526062710', '1446-11-28', '2.220.10', '101', 'an.UMAR FARUQ', '0', '10000', 'Chuwez', '2025-05-26 20:27:10'),
('3389', 'ST10100320250526062734', '1446-11-28', '1.100.10', '101', 'an.MARIATUL QIBTIYAH', '2000', '0', 'Chuwez', '2025-05-26 20:27:34'),
('3390', 'ST10100320250526062734', '1446-11-28', '2.220.10', '101', 'an.MARIATUL QIBTIYAH', '0', '2000', 'Chuwez', '2025-05-26 20:27:34'),
('3391', 'ST10100320250526062758', '1446-11-28', '1.100.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '2000', '0', 'Chuwez', '2025-05-26 20:27:58'),
('3392', 'ST10100320250526062758', '1446-11-28', '2.220.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '0', '2000', 'Chuwez', '2025-05-26 20:27:58'),
('3393', 'ST10100320250526062825', '1446-11-28', '1.100.10', '101', 'an.DIYANAH KAMALIYAH', '2000', '0', 'Chuwez', '2025-05-26 20:28:25'),
('3394', 'ST10100320250526062825', '1446-11-28', '2.220.10', '101', 'an.DIYANAH KAMALIYAH', '0', '2000', 'Chuwez', '2025-05-26 20:28:25'),
('3395', 'ST10100320250526062847', '1446-11-28', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '10000', '0', 'Chuwez', '2025-05-26 20:28:47'),
('3396', 'ST10100320250526062847', '1446-11-28', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '10000', 'Chuwez', '2025-05-26 20:28:47'),
('3397', 'ST10100320250526062905', '1446-11-28', '1.100.10', '101', 'an.SITI QURROTUL AINI', '2000', '0', 'Chuwez', '2025-05-26 20:29:05'),
('3398', 'ST10100320250526062905', '1446-11-28', '2.220.10', '101', 'an.SITI QURROTUL AINI', '0', '2000', 'Chuwez', '2025-05-26 20:29:05'),
('3399', 'ST10100320250526062924', '1446-11-28', '1.100.10', '101', 'an.AHMAD SYAHRU ROMADHONI', '10000', '0', 'Chuwez', '2025-05-26 20:29:24'),
('3400', 'ST10100320250526062924', '1446-11-28', '2.220.10', '101', 'an.AHMAD SYAHRU ROMADHONI', '0', '10000', 'Chuwez', '2025-05-26 20:29:24'),
('3401', 'ST10100320250526062947', '1446-11-28', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Chuwez', '2025-05-26 20:29:47'),
('3402', 'ST10100320250526062947', '1446-11-28', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Chuwez', '2025-05-26 20:29:47'),
('3403', 'ST10100320250526063006', '1446-11-28', '1.100.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '5000', '0', 'Chuwez', '2025-05-26 20:30:06'),
('3404', 'ST10100320250526063006', '1446-11-28', '2.220.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '0', '5000', 'Chuwez', '2025-05-26 20:30:06'),
('3405', 'ST10100320250526063034', '1446-11-28', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '10000', '0', 'Chuwez', '2025-05-26 20:30:34'),
('3406', 'ST10100320250526063034', '1446-11-28', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '10000', 'Chuwez', '2025-05-26 20:30:34'),
('3407', 'ST10100320250526063104', '1446-11-28', '1.100.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '10000', '0', 'Chuwez', '2025-05-26 20:31:04'),
('3408', 'ST10100320250526063104', '1446-11-28', '2.220.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '0', '10000', 'Chuwez', '2025-05-26 20:31:04'),
('3409', 'ST10100320250526063127', '1446-11-28', '1.100.10', '101', 'an.RAUDHOTUL JANNAH', '20000', '0', 'Chuwez', '2025-05-26 20:31:27'),
('3410', 'ST10100320250526063127', '1446-11-28', '2.220.10', '101', 'an.RAUDHOTUL JANNAH', '0', '20000', 'Chuwez', '2025-05-26 20:31:27'),
('3411', 'ST10100320250526063154', '1446-11-28', '1.100.10', '101', 'an.MIFTAHUL JANNAH', '50000', '0', 'Chuwez', '2025-05-26 20:31:54'),
('3412', 'ST10100320250526063154', '1446-11-28', '2.220.10', '101', 'an.MIFTAHUL JANNAH', '0', '50000', 'Chuwez', '2025-05-26 20:31:54'),
('3413', 'ST10100320250526063214', '1446-11-28', '1.100.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '5000', '0', 'Chuwez', '2025-05-26 20:32:14'),
('3414', 'ST10100320250526063214', '1446-11-28', '2.220.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '0', '5000', 'Chuwez', '2025-05-26 20:32:14'),
('3415', 'ST10100320250526063238', '1446-11-28', '1.100.10', '101', 'an.NABILATUN NISAUL UMMAH', '20000', '0', 'Chuwez', '2025-05-26 20:32:38'),
('3416', 'ST10100320250526063238', '1446-11-28', '2.220.10', '101', 'an.NABILATUN NISAUL UMMAH', '0', '20000', 'Chuwez', '2025-05-26 20:32:38'),
('3417', 'ST10100320250526063425', '1446-11-28', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '5000', '0', 'Chuwez', '2025-05-26 20:34:25'),
('3418', 'ST10100320250526063425', '1446-11-28', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '5000', 'Chuwez', '2025-05-26 20:34:25'),
('3419', 'ST10100320250526063446', '1446-11-28', '1.100.10', '101', 'an.M. ALIFIN FIKRI', '2000', '0', 'Chuwez', '2025-05-26 20:34:46'),
('3420', 'ST10100320250526063446', '1446-11-28', '2.220.10', '101', 'an.M. ALIFIN FIKRI', '0', '2000', 'Chuwez', '2025-05-26 20:34:46'),
('3421', 'ST10100320250526073254', '1446-11-28', '1.100.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '10000', '0', 'Chuwez', '2025-05-26 21:32:54'),
('3422', 'ST10100320250526073254', '1446-11-28', '2.220.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '0', '10000', 'Chuwez', '2025-05-26 21:32:54'),
('3423', 'ST10100320250526073320', '1446-11-28', '1.100.10', '101', 'an.MUHAMMAD ILHAM', '5000', '0', 'Chuwez', '2025-05-26 21:33:20'),
('3424', 'ST10100320250526073320', '1446-11-28', '2.220.10', '101', 'an.MUHAMMAD ILHAM', '0', '5000', 'Chuwez', '2025-05-26 21:33:20'),
('3425', 'ST10100320250526073354', '1446-11-28', '1.100.10', '101', 'an.M. KAMALUDDIN', '20000', '0', 'Chuwez', '2025-05-26 21:33:54'),
('3426', 'ST10100320250526073354', '1446-11-28', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '20000', 'Chuwez', '2025-05-26 21:33:54'),
('3427', 'ST10100320250526073422', '1446-11-28', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '2000', '0', 'Chuwez', '2025-05-26 21:34:22'),
('3428', 'ST10100320250526073422', '1446-11-28', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '2000', 'Chuwez', '2025-05-26 21:34:22'),
('3429', 'ST10100320250526073453', '1446-11-28', '1.100.10', '101', 'an.SAFIRATUL JANNAH', '10000', '0', 'Chuwez', '2025-05-26 21:34:53'),
('3430', 'ST10100320250526073453', '1446-11-28', '2.220.10', '101', 'an.SAFIRATUL JANNAH', '0', '10000', 'Chuwez', '2025-05-26 21:34:53'),
('3431', 'ST10100320250526073543', '1446-11-28', '1.100.10', '101', 'an.BILQIS THALIA HASNA', '60000', '0', 'Chuwez', '2025-05-26 21:35:43'),
('3432', 'ST10100320250526073543', '1446-11-28', '2.220.10', '101', 'an.BILQIS THALIA HASNA', '0', '60000', 'Chuwez', '2025-05-26 21:35:43'),
('3433', 'ST10100320250526073616', '1446-11-28', '1.100.10', '101', 'an.SAUQY AHMAD', '10000', '0', 'Chuwez', '2025-05-26 21:36:16'),
('3434', 'ST10100320250526073616', '1446-11-28', '2.220.10', '101', 'an.SAUQY AHMAD', '0', '10000', 'Chuwez', '2025-05-26 21:36:16'),
('3435', 'ST10100320250526073645', '1446-11-28', '1.100.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '10000', '0', 'Chuwez', '2025-05-26 21:36:45'),
('3436', 'ST10100320250526073645', '1446-11-28', '2.220.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '0', '10000', 'Chuwez', '2025-05-26 21:36:45'),
('3437', 'ST10100320250526073720', '1446-11-28', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'Chuwez', '2025-05-26 21:37:20'),
('3438', 'ST10100320250526073720', '1446-11-28', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'Chuwez', '2025-05-26 21:37:20'),
('3439', 'ST10100320250526073744', '1446-11-28', '1.100.10', '101', 'an.NAURA BILADINA', '5000', '0', 'Chuwez', '2025-05-26 21:37:44'),
('3440', 'ST10100320250526073744', '1446-11-28', '2.220.10', '101', 'an.NAURA BILADINA', '0', '5000', 'Chuwez', '2025-05-26 21:37:44'),
('3441', 'ST10100320250526073810', '1446-11-28', '1.100.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '5000', '0', 'Chuwez', '2025-05-26 21:38:10'),
('3442', 'ST10100320250526073810', '1446-11-28', '2.220.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '0', '5000', 'Chuwez', '2025-05-26 21:38:11'),
('3443', 'ST10100320250526073834', '1446-11-28', '1.100.10', '101', 'an.UBAIDAH', '10000', '0', 'Chuwez', '2025-05-26 21:38:34'),
('3444', 'ST10100320250526073834', '1446-11-28', '2.220.10', '101', 'an.UBAIDAH', '0', '10000', 'Chuwez', '2025-05-26 21:38:34'),
('3445', 'ST10100320250526073854', '1446-11-28', '1.100.10', '101', 'an.HAIKAL SHOMADANI', '2000', '0', 'Chuwez', '2025-05-26 21:38:54'),
('3446', 'ST10100320250526073854', '1446-11-28', '2.220.10', '101', 'an.HAIKAL SHOMADANI', '0', '2000', 'Chuwez', '2025-05-26 21:38:54'),
('3447', 'ST10100320250526073915', '1446-11-28', '1.100.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '5000', '0', 'Chuwez', '2025-05-26 21:39:15'),
('3448', 'ST10100320250526073915', '1446-11-28', '2.220.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '0', '5000', 'Chuwez', '2025-05-26 21:39:15'),
('3449', 'ST10100320250526073938', '1446-11-28', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '10000', '0', 'Chuwez', '2025-05-26 21:39:38'),
('3450', 'ST10100320250526073938', '1446-11-28', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '10000', 'Chuwez', '2025-05-26 21:39:38'),
('3451', 'ST10100320250526073959', '1446-11-28', '1.100.10', '101', 'an.MARIYATUL QIBTIYAH', '5000', '0', 'Chuwez', '2025-05-26 21:39:59'),
('3452', 'ST10100320250526073959', '1446-11-28', '2.220.10', '101', 'an.MARIYATUL QIBTIYAH', '0', '5000', 'Chuwez', '2025-05-26 21:39:59'),
('3453', 'ST10100320250526074153', '1446-11-28', '1.100.10', '101', 'an.HILYA', '20000', '0', 'Chuwez', '2025-05-26 21:41:53'),
('3454', 'ST10100320250526074153', '1446-11-28', '2.220.10', '101', 'an.HILYA', '0', '20000', 'Chuwez', '2025-05-26 21:41:53'),
('3455', 'ST10100320250526074219', '1446-11-28', '1.100.10', '101', 'an.HAMIDAH', '10000', '0', 'Chuwez', '2025-05-26 21:42:19'),
('3456', 'ST10100320250526074219', '1446-11-28', '2.220.10', '101', 'an.HAMIDAH', '0', '10000', 'Chuwez', '2025-05-26 21:42:19'),
('3457', 'ST10100320250526074302', '1446-11-28', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'Chuwez', '2025-05-26 21:43:02'),
('3458', 'ST10100320250526074302', '1446-11-28', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'Chuwez', '2025-05-26 21:43:02'),
('3459', 'ST10100320250526074609', '1446-11-28', '1.100.10', '101', 'an.WARDATUL JANNAH', '2000', '0', 'Chuwez', '2025-05-26 21:46:09'),
('3460', 'ST10100320250526074609', '1446-11-28', '2.220.10', '101', 'an.WARDATUL JANNAH', '0', '2000', 'Chuwez', '2025-05-26 21:46:09'),
('3461', 'KK10100320250526144715', '1446-11-27', '5.520.42', '101', 'Bakso', '25000', '0', 'Chuwez', '2025-05-26 14:47:49'),
('3462', 'KK10100320250526144715', '1446-11-27', '1.100.10', '101', 'Bakso', '0', '25000', 'Chuwez', '2025-05-26 14:47:49'),
('3463', 'KK10100320250526144715', '1446-11-28', '5.520.42', '101', 'Cilok dan gorengan', '10000', '0', 'Chuwez', '2025-05-26 14:48:19'),
('3464', 'KK10100320250526144715', '1446-11-28', '1.100.10', '101', 'Cilok dan gorengan', '0', '10000', 'Chuwez', '2025-05-26 14:48:19'),
('3465', 'SY10100220250527015541000', '1446-10-29', '1.100.10', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '30000', '0', 'Ipul', '2025-05-27 08:55:41'),
('3466', 'SY10100220250527015541000', '1446-10-29', '4.400.20', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '0', '30000', 'Ipul', '2025-05-27 08:55:41'),
('3467', 'SY10100220250527015541001', '1446-11-29', '1.100.10', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '30000', '0', 'Ipul', '2025-05-27 08:55:41'),
('3468', 'SY10100220250527015541001', '1446-11-29', '4.400.20', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '0', '30000', 'Ipul', '2025-05-27 08:55:41'),
('3469', 'SY10100220250527015542002', '1446-12-29', '1.100.10', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '30000', '0', 'Ipul', '2025-05-27 08:55:42'),
('3470', 'SY10100220250527015542002', '1446-12-29', '4.400.20', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '0', '30000', 'Ipul', '2025-05-27 08:55:42'),
('3471', 'SY10100220250527015542003', '1447-01-29', '1.100.10', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '30000', '0', 'Ipul', '2025-05-27 08:55:42'),
('3472', 'SY10100220250527015542003', '1447-01-29', '4.400.20', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '0', '30000', 'Ipul', '2025-05-27 08:55:42'),
('3473', 'ST10100320250527045441', '1446-11-27', '1.100.10', '101', 'an.AMARA', '20000', '0', 'Chuwez', '2025-05-27 18:54:41'),
('3474', 'ST10100320250527045441', '1446-11-27', '2.220.10', '101', 'an.AMARA', '0', '20000', 'Chuwez', '2025-05-27 18:54:41'),
('3475', 'ST10100320250527045511', '1446-11-28', '1.100.10', '101', 'an.AMARA', '10000', '0', 'Chuwez', '2025-05-27 18:55:11'),
('3476', 'ST10100320250527045511', '1446-11-28', '2.220.10', '101', 'an.AMARA', '0', '10000', 'Chuwez', '2025-05-27 18:55:11'),
('3477', 'ST10100320250527073454', '1446-11-29', '1.100.10', '101', 'an.ELOK WARDATUN NAFISAH', '5000', '0', 'Chuwez', '2025-05-27 21:34:54'),
('3478', 'ST10100320250527073454', '1446-11-29', '2.220.10', '101', 'an.ELOK WARDATUN NAFISAH', '0', '5000', 'Chuwez', '2025-05-27 21:34:54'),
('3479', 'ST10100320250527073510', '1446-11-29', '1.100.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '5000', '0', 'Chuwez', '2025-05-27 21:35:10'),
('3480', 'ST10100320250527073510', '1446-11-29', '2.220.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '0', '5000', 'Chuwez', '2025-05-27 21:35:10'),
('3481', 'ST10100320250527073533', '1446-11-29', '1.100.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '2000', '0', 'Chuwez', '2025-05-27 21:35:33'),
('3482', 'ST10100320250527073533', '1446-11-29', '2.220.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '0', '2000', 'Chuwez', '2025-05-27 21:35:33'),
('3483', 'ST10100320250527073553', '1446-11-29', '1.100.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '5000', '0', 'Chuwez', '2025-05-27 21:35:53'),
('3484', 'ST10100320250527073553', '1446-11-29', '2.220.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '0', '5000', 'Chuwez', '2025-05-27 21:35:53'),
('3485', 'ST10100320250527073611', '1446-11-29', '1.100.10', '101', 'an.M. ABD. HADI', '2000', '0', 'Chuwez', '2025-05-27 21:36:11'),
('3486', 'ST10100320250527073611', '1446-11-29', '2.220.10', '101', 'an.M. ABD. HADI', '0', '2000', 'Chuwez', '2025-05-27 21:36:11'),
('3487', 'ST10100320250527073640', '1446-11-29', '1.100.10', '101', 'an.NAURA BILADINA', '8000', '0', 'Chuwez', '2025-05-27 21:36:40'),
('3488', 'ST10100320250527073640', '1446-11-29', '2.220.10', '101', 'an.NAURA BILADINA', '0', '8000', 'Chuwez', '2025-05-27 21:36:40'),
('3489', 'ST10100320250527073714', '1446-11-29', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'Chuwez', '2025-05-27 21:37:14'),
('3490', 'ST10100320250527073714', '1446-11-29', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'Chuwez', '2025-05-27 21:37:14'),
('3491', 'ST10100320250527073743', '1446-11-29', '1.100.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '10000', '0', 'Chuwez', '2025-05-27 21:37:43'),
('3492', 'ST10100320250527073743', '1446-11-29', '2.220.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '0', '10000', 'Chuwez', '2025-05-27 21:37:43'),
('3493', 'ST10100320250527073811', '1446-11-29', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '5000', '0', 'Chuwez', '2025-05-27 21:38:11'),
('3494', 'ST10100320250527073811', '1446-11-29', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '5000', 'Chuwez', '2025-05-27 21:38:11'),
('3495', 'ST10100320250527073836', '1446-11-29', '1.100.10', '101', 'an.AULIA AZZAHRA', '10000', '0', 'Chuwez', '2025-05-27 21:38:36'),
('3496', 'ST10100320250527073836', '1446-11-29', '2.220.10', '101', 'an.AULIA AZZAHRA', '0', '10000', 'Chuwez', '2025-05-27 21:38:36'),
('3497', 'ST10100320250527073906', '1446-11-29', '1.100.10', '101', 'an.ABDULLOH BAHAR', '4000', '0', 'Chuwez', '2025-05-27 21:39:06'),
('3498', 'ST10100320250527073906', '1446-11-29', '2.220.10', '101', 'an.ABDULLOH BAHAR', '0', '4000', 'Chuwez', '2025-05-27 21:39:06'),
('3499', 'ST10100320250527074004', '1446-11-29', '1.100.10', '101', 'an.RAISA ANNISA', '5000', '0', 'Chuwez', '2025-05-27 21:40:04'),
('3500', 'ST10100320250527074004', '1446-11-29', '2.220.10', '101', 'an.RAISA ANNISA', '0', '5000', 'Chuwez', '2025-05-27 21:40:04'),
('3501', 'ST10100320250527074038', '1446-11-29', '1.100.10', '101', 'an.MARIYATUL QIBTIYAH', '5000', '0', 'Chuwez', '2025-05-27 21:40:38'),
('3502', 'ST10100320250527074038', '1446-11-29', '2.220.10', '101', 'an.MARIYATUL QIBTIYAH', '0', '5000', 'Chuwez', '2025-05-27 21:40:38'),
('3503', 'ST10100320250527074124', '1446-11-29', '1.100.10', '101', 'an.UBAIDAH', '10000', '0', 'Chuwez', '2025-05-27 21:41:24'),
('3504', 'ST10100320250527074124', '1446-11-29', '2.220.10', '101', 'an.UBAIDAH', '0', '10000', 'Chuwez', '2025-05-27 21:41:25'),
('3505', 'ST10100320250527074148', '1446-11-29', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '10000', '0', 'Chuwez', '2025-05-27 21:41:48'),
('3506', 'ST10100320250527074148', '1446-11-29', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '10000', 'Chuwez', '2025-05-27 21:41:48'),
('3507', 'ST10100320250527074212', '1446-11-29', '1.100.10', '101', 'an.NAILATUN NIAMI', '2000', '0', 'Chuwez', '2025-05-27 21:42:12'),
('3508', 'ST10100320250527074212', '1446-11-29', '2.220.10', '101', 'an.NAILATUN NIAMI', '0', '2000', 'Chuwez', '2025-05-27 21:42:13'),
('3509', 'ST10100320250527074237', '1446-11-29', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'Chuwez', '2025-05-27 21:42:37'),
('3510', 'ST10100320250527074237', '1446-11-29', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'Chuwez', '2025-05-27 21:42:37'),
('3511', 'ST10100320250527074303', '1446-11-29', '1.100.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '4000', '0', 'Chuwez', '2025-05-27 21:43:03'),
('3512', 'ST10100320250527074303', '1446-11-29', '2.220.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '0', '4000', 'Chuwez', '2025-05-27 21:43:03'),
('3513', 'ST10100320250527074345', '1446-11-29', '1.100.10', '101', 'an.FAIZAH NURUL LITA', '5000', '0', 'Chuwez', '2025-05-27 21:43:45'),
('3514', 'ST10100320250527074345', '1446-11-29', '2.220.10', '101', 'an.FAIZAH NURUL LITA', '0', '5000', 'Chuwez', '2025-05-27 21:43:45'),
('3515', 'ST10100320250527074409', '1446-11-29', '1.100.10', '101', 'an.MARIATUL QIBTIYAH', '2000', '0', 'Chuwez', '2025-05-27 21:44:09'),
('3516', 'ST10100320250527074409', '1446-11-29', '2.220.10', '101', 'an.MARIATUL QIBTIYAH', '0', '2000', 'Chuwez', '2025-05-27 21:44:09'),
('3517', 'ST10100320250527074435', '1446-11-29', '1.100.10', '101', 'an.UMAR FARUQ', '10000', '0', 'Chuwez', '2025-05-27 21:44:35'),
('3518', 'ST10100320250527074435', '1446-11-29', '2.220.10', '101', 'an.UMAR FARUQ', '0', '10000', 'Chuwez', '2025-05-27 21:44:35'),
('3519', 'ST10100320250527074506', '1446-11-29', '1.100.10', '101', 'an.AHMAD ADITIYA', '25000', '0', 'Chuwez', '2025-05-27 21:45:06'),
('3520', 'ST10100320250527074506', '1446-11-29', '2.220.10', '101', 'an.AHMAD ADITIYA', '0', '25000', 'Chuwez', '2025-05-27 21:45:06'),
('3521', 'ST10100320250527074537', '1446-11-29', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '10000', '0', 'Chuwez', '2025-05-27 21:45:37'),
('3522', 'ST10100320250527074537', '1446-11-29', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '10000', 'Chuwez', '2025-05-27 21:45:37'),
('3523', 'ST10100320250527074600', '1446-11-29', '1.100.10', '101', 'an.LAILATUL MAGHFIROH', '5000', '0', 'Chuwez', '2025-05-27 21:46:00'),
('3524', 'ST10100320250527074600', '1446-11-29', '2.220.10', '101', 'an.LAILATUL MAGHFIROH', '0', '5000', 'Chuwez', '2025-05-27 21:46:00'),
('3525', 'ST10100320250527074637', '1446-11-29', '1.100.10', '101', 'an.ALFI NURDIANA', '5000', '0', 'Chuwez', '2025-05-27 21:46:37'),
('3526', 'ST10100320250527074637', '1446-11-29', '2.220.10', '101', 'an.ALFI NURDIANA', '0', '5000', 'Chuwez', '2025-05-27 21:46:37'),
('3527', 'ST10100320250527074658', '1446-11-29', '1.100.10', '101', 'an.DIANA RIFQOTUL QOLBI', '5000', '0', 'Chuwez', '2025-05-27 21:46:58'),
('3528', 'ST10100320250527074658', '1446-11-29', '2.220.10', '101', 'an.DIANA RIFQOTUL QOLBI', '0', '5000', 'Chuwez', '2025-05-27 21:46:58'),
('3529', 'ST10100320250527074721', '1446-11-29', '1.100.10', '101', 'an.AISYAH', '5000', '0', 'Chuwez', '2025-05-27 21:47:21'),
('3530', 'ST10100320250527074721', '1446-11-29', '2.220.10', '101', 'an.AISYAH', '0', '5000', 'Chuwez', '2025-05-27 21:47:21'),
('3531', 'ST10100320250527081319', '1446-11-29', '1.100.10', '101', 'an.WARDATUL JANNAH', '2000', '0', 'Chuwez', '2025-05-27 22:13:19'),
('3532', 'ST10100320250527081319', '1446-11-29', '2.220.10', '101', 'an.WARDATUL JANNAH', '0', '2000', 'Chuwez', '2025-05-27 22:13:19'),
('3533', 'ST10100320250527081347', '1446-11-29', '1.100.10', '101', 'an.SITI QURROTUL AINI', '2000', '0', 'Chuwez', '2025-05-27 22:13:47'),
('3534', 'ST10100320250527081347', '1446-11-29', '2.220.10', '101', 'an.SITI QURROTUL AINI', '0', '2000', 'Chuwez', '2025-05-27 22:13:47'),
('3535', 'ST10100320250527081430', '1446-11-29', '1.100.10', '101', 'an.M. FAHMI NURUL ANAM', '10000', '0', 'Chuwez', '2025-05-27 22:14:30'),
('3536', 'ST10100320250527081430', '1446-11-29', '2.220.10', '101', 'an.M. FAHMI NURUL ANAM', '0', '10000', 'Chuwez', '2025-05-27 22:14:30'),
('3537', 'ST10100320250527081448', '1446-11-29', '1.100.10', '101', 'an.SITI ATHIUR ROHMAH', '5000', '0', 'Chuwez', '2025-05-27 22:14:48'),
('3538', 'ST10100320250527081448', '1446-11-29', '2.220.10', '101', 'an.SITI ATHIUR ROHMAH', '0', '5000', 'Chuwez', '2025-05-27 22:14:48'),
('3539', 'ST10100320250527081505', '1446-11-29', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '10000', '0', 'Chuwez', '2025-05-27 22:15:05'),
('3540', 'ST10100320250527081505', '1446-11-29', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '10000', 'Chuwez', '2025-05-27 22:15:05'),
('3541', 'ST10100320250527081522', '1446-11-29', '1.100.10', '101', 'an.DIYANAH KAMALIYAH', '2000', '0', 'Chuwez', '2025-05-27 22:15:22'),
('3542', 'ST10100320250527081522', '1446-11-29', '2.220.10', '101', 'an.DIYANAH KAMALIYAH', '0', '2000', 'Chuwez', '2025-05-27 22:15:22'),
('3543', 'ST10100320250527081632', '1446-11-29', '1.100.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '5000', '0', 'Chuwez', '2025-05-27 22:16:32'),
('3544', 'ST10100320250527081632', '1446-11-29', '2.220.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '0', '5000', 'Chuwez', '2025-05-27 22:16:32'),
('3545', 'ST10100320250527081710', '1446-11-29', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '10000', '0', 'Chuwez', '2025-05-27 22:17:10'),
('3546', 'ST10100320250527081710', '1446-11-29', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '10000', 'Chuwez', '2025-05-27 22:17:10'),
('3547', 'ST10100320250527081748', '1446-11-29', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '2000', '0', 'Chuwez', '2025-05-27 22:17:48'),
('3548', 'ST10100320250527081748', '1446-11-29', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '2000', 'Chuwez', '2025-05-27 22:17:48'),
('3549', 'ST10100320250527081803', '1446-11-29', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '5000', '0', 'Chuwez', '2025-05-27 22:18:03'),
('3550', 'ST10100320250527081803', '1446-11-29', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '5000', 'Chuwez', '2025-05-27 22:18:03'),
('3551', 'ST10100320250527081819', '1446-11-29', '1.100.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '20000', '0', 'Chuwez', '2025-05-27 22:18:19'),
('3552', 'ST10100320250527081819', '1446-11-29', '2.220.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '0', '20000', 'Chuwez', '2025-05-27 22:18:19'),
('3553', 'ST10100320250527081837', '1446-11-29', '1.100.10', '101', 'an.M. KAMALUDDIN', '20000', '0', 'Chuwez', '2025-05-27 22:18:37'),
('3554', 'ST10100320250527081837', '1446-11-29', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '20000', 'Chuwez', '2025-05-27 22:18:37'),
('3555', 'ST10100320250527081903', '1446-11-29', '1.100.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '10000', '0', 'Chuwez', '2025-05-27 22:19:03'),
('3556', 'ST10100320250527081903', '1446-11-29', '2.220.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '0', '10000', 'Chuwez', '2025-05-27 22:19:03'),
('3557', 'ST10100320250527081922', '1446-11-29', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Chuwez', '2025-05-27 22:19:22'),
('3558', 'ST10100320250527081922', '1446-11-29', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Chuwez', '2025-05-27 22:19:22'),
('3559', 'ST10100320250527081941', '1446-11-29', '1.100.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '5000', '0', 'Chuwez', '2025-05-27 22:19:41'),
('3560', 'ST10100320250527081941', '1446-11-29', '2.220.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '0', '5000', 'Chuwez', '2025-05-27 22:19:41'),
('3561', 'ST10100320250527082032', '1446-11-29', '1.100.10', '101', 'an.AHMAD ABBAS MAULANA', '5000', '0', 'Chuwez', '2025-05-27 22:20:32'),
('3562', 'ST10100320250527082032', '1446-11-29', '2.220.10', '101', 'an.AHMAD ABBAS MAULANA', '0', '5000', 'Chuwez', '2025-05-27 22:20:32'),
('3563', 'ST10100320250527082047', '1446-11-29', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '25000', '0', 'Chuwez', '2025-05-27 22:20:47'),
('3564', 'ST10100320250527082047', '1446-11-29', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '25000', 'Chuwez', '2025-05-27 22:20:48'),
('3565', 'ST10100320250527082105', '1446-11-29', '1.100.10', '101', 'an.BILQIS THALIA HASNA', '60000', '0', 'Chuwez', '2025-05-27 22:21:05'),
('3566', 'ST10100320250527082105', '1446-11-29', '2.220.10', '101', 'an.BILQIS THALIA HASNA', '0', '60000', 'Chuwez', '2025-05-27 22:21:05'),
('3567', 'ST10100320250527082122', '1446-11-29', '1.100.10', '101', 'an.AHMAD JAMALUL MAIMUN', '5000', '0', 'Chuwez', '2025-05-27 22:21:22'),
('3568', 'ST10100320250527082122', '1446-11-29', '2.220.10', '101', 'an.AHMAD JAMALUL MAIMUN', '0', '5000', 'Chuwez', '2025-05-27 22:21:23'),
('3569', 'ST10100320250527082346', '1446-11-29', '1.100.10', '101', 'an.HILYA', '20000', '0', 'Chuwez', '2025-05-27 22:23:46'),
('3570', 'ST10100320250527082346', '1446-11-29', '2.220.10', '101', 'an.HILYA', '0', '20000', 'Chuwez', '2025-05-27 22:23:46'),
('3571', 'ST10100320250527082751', '1446-11-29', '1.100.10', '101', 'an.ZAKIYATUL UMMAH', '2000', '0', 'Chuwez', '2025-05-27 22:27:51'),
('3572', 'ST10100320250527082751', '1446-11-29', '2.220.10', '101', 'an.ZAKIYATUL UMMAH', '0', '2000', 'Chuwez', '2025-05-27 22:27:52'),
('3573', 'ST10100320250527082806', '1446-11-29', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '5000', '0', 'Chuwez', '2025-05-27 22:28:06'),
('3574', 'ST10100320250527082806', '1446-11-29', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '5000', 'Chuwez', '2025-05-27 22:28:06'),
('3575', 'ST10100320250527082819', '1446-11-29', '1.100.10', '101', 'an.ANA SALSABILA', '2000', '0', 'Chuwez', '2025-05-27 22:28:19'),
('3576', 'ST10100320250527082819', '1446-11-29', '2.220.10', '101', 'an.ANA SALSABILA', '0', '2000', 'Chuwez', '2025-05-27 22:28:19'),
('3577', 'ST10100320250527082831', '1446-11-29', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '5000', '0', 'Chuwez', '2025-05-27 22:28:32'),
('3578', 'ST10100320250527082831', '1446-11-29', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '5000', 'Chuwez', '2025-05-27 22:28:32'),
('3579', 'ST10100320250527082859', '1446-11-29', '1.100.10', '101', 'an.M. ALIFIN FIKRI', '3000', '0', 'Chuwez', '2025-05-27 22:28:59'),
('3580', 'ST10100320250527082859', '1446-11-29', '2.220.10', '101', 'an.M. ALIFIN FIKRI', '0', '3000', 'Chuwez', '2025-05-27 22:28:59'),
('3581', 'ST10100320250527082916', '1446-11-29', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '5000', '0', 'Chuwez', '2025-05-27 22:29:16'),
('3582', 'ST10100320250527082916', '1446-11-29', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '5000', 'Chuwez', '2025-05-27 22:29:16'),
('3583', 'ST10100320250527082932', '1446-11-29', '1.100.10', '101', 'an.ACH. JUNAIDI', '5000', '0', 'Chuwez', '2025-05-27 22:29:32'),
('3584', 'ST10100320250527082932', '1446-11-29', '2.220.10', '101', 'an.ACH. JUNAIDI', '0', '5000', 'Chuwez', '2025-05-27 22:29:32'),
('3585', 'ST10100320250527082947', '1446-11-29', '1.100.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '2000', '0', 'Chuwez', '2025-05-27 22:29:47'),
('3586', 'ST10100320250527082947', '1446-11-29', '2.220.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '0', '2000', 'Chuwez', '2025-05-27 22:29:47'),
('3587', 'ST10100320250527083004', '1446-11-29', '1.100.10', '101', 'an.ALFIN HIDAYAT', '25000', '0', 'Chuwez', '2025-05-27 22:30:04'),
('3588', 'ST10100320250527083004', '1446-11-29', '2.220.10', '101', 'an.ALFIN HIDAYAT', '0', '25000', 'Chuwez', '2025-05-27 22:30:04'),
('3589', 'ST10100320250527083020', '1446-11-29', '1.100.10', '101', 'an.SAFIRATUL JANNAH', '10000', '0', 'Chuwez', '2025-05-27 22:30:20'),
('3590', 'ST10100320250527083020', '1446-11-29', '2.220.10', '101', 'an.SAFIRATUL JANNAH', '0', '10000', 'Chuwez', '2025-05-27 22:30:20'),
('3591', 'ST10100320250527083137', '1446-11-29', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'Chuwez', '2025-05-27 22:31:37'),
('3592', 'ST10100320250527083137', '1446-11-29', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'Chuwez', '2025-05-27 22:31:37'),
('3593', 'ST10100320250527084654', '1446-11-29', '1.100.10', '101', 'an.AMARA', '10000', '0', 'Chuwez', '2025-05-27 22:46:54'),
('3594', 'ST10100320250527084654', '1446-11-29', '2.220.10', '101', 'an.AMARA', '0', '10000', 'Chuwez', '2025-05-27 22:46:54'),
('3595', 'ST10100320250528061920', '1446-11-30', '1.100.10', '101', 'an.LAILATUL MAGHFIROH', '5000', '0', 'Chuwez', '2025-05-28 20:19:20'),
('3596', 'ST10100320250528061920', '1446-11-30', '2.220.10', '101', 'an.LAILATUL MAGHFIROH', '0', '5000', 'Chuwez', '2025-05-28 20:19:20'),
('3597', 'ST10100320250528061949', '1446-11-30', '1.100.10', '101', 'an.AISYAH', '5000', '0', 'Chuwez', '2025-05-28 20:19:49'),
('3598', 'ST10100320250528061949', '1446-11-30', '2.220.10', '101', 'an.AISYAH', '0', '5000', 'Chuwez', '2025-05-28 20:19:49'),
('3599', 'ST10100320250528062007', '1446-11-30', '1.100.10', '101', 'an.DIANA RIFQOTUL QOLBI', '5000', '0', 'Chuwez', '2025-05-28 20:20:07'),
('3600', 'ST10100320250528062007', '1446-11-30', '2.220.10', '101', 'an.DIANA RIFQOTUL QOLBI', '0', '5000', 'Chuwez', '2025-05-28 20:20:07'),
('3601', 'ST10100320250528062027', '1446-11-30', '1.100.10', '101', 'an.AHMAD ADITIYA', '5000', '0', 'Chuwez', '2025-05-28 20:20:27'),
('3602', 'ST10100320250528062027', '1446-11-30', '2.220.10', '101', 'an.AHMAD ADITIYA', '0', '5000', 'Chuwez', '2025-05-28 20:20:31'),
('3603', 'ST10100320250528062058', '1446-11-30', '1.100.10', '101', 'an.AZKA AUFARIL MINAN', '20000', '0', 'Chuwez', '2025-05-28 20:20:58'),
('3604', 'ST10100320250528062058', '1446-11-30', '2.220.10', '101', 'an.AZKA AUFARIL MINAN', '0', '20000', 'Chuwez', '2025-05-28 20:20:58'),
('3605', 'ST10100320250528062120', '1446-11-30', '1.100.10', '101', 'an.M. DESTRA MAULANA', '30000', '0', 'Chuwez', '2025-05-28 20:21:20'),
('3606', 'ST10100320250528062120', '1446-11-30', '2.220.10', '101', 'an.M. DESTRA MAULANA', '0', '30000', 'Chuwez', '2025-05-28 20:21:20'),
('3607', 'ST10100320250528062153', '1446-11-30', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '10000', '0', 'Chuwez', '2025-05-28 20:21:53'),
('3608', 'ST10100320250528062153', '1446-11-30', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '10000', 'Chuwez', '2025-05-28 20:21:53'),
('3609', 'ST10100320250528062222', '1446-11-30', '1.100.10', '101', 'an.RAISA ANNISA', '5000', '0', 'Chuwez', '2025-05-28 20:22:22'),
('3610', 'ST10100320250528062222', '1446-11-30', '2.220.10', '101', 'an.RAISA ANNISA', '0', '5000', 'Chuwez', '2025-05-28 20:22:22'),
('3611', 'ST10100320250528062248', '1446-11-30', '1.100.10', '101', 'an.MARIATUL QIBTIYAH', '2000', '0', 'Chuwez', '2025-05-28 20:22:48'),
('3612', 'ST10100320250528062248', '1446-11-30', '2.220.10', '101', 'an.MARIATUL QIBTIYAH', '0', '2000', 'Chuwez', '2025-05-28 20:22:48'),
('3613', 'ST10100320250528062311', '1446-11-30', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'Chuwez', '2025-05-28 20:23:11'),
('3614', 'ST10100320250528062311', '1446-11-30', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'Chuwez', '2025-05-28 20:23:11'),
('3615', 'ST10100320250528062333', '1446-11-30', '1.100.10', '101', 'an.M. KAMALUDDIN', '20000', '0', 'Chuwez', '2025-05-28 20:23:33'),
('3616', 'ST10100320250528062333', '1446-11-30', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '20000', 'Chuwez', '2025-05-28 20:23:33'),
('3617', 'ST10100320250528062357', '1446-11-30', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '2000', '0', 'Chuwez', '2025-05-28 20:23:57'),
('3618', 'ST10100320250528062357', '1446-11-30', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '2000', 'Chuwez', '2025-05-28 20:23:58'),
('3619', 'ST10100320250528062421', '1446-11-30', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Chuwez', '2025-05-28 20:24:21'),
('3620', 'ST10100320250528062421', '1446-11-30', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Chuwez', '2025-05-28 20:24:21'),
('3621', 'ST10100320250528062447', '1446-11-30', '1.100.10', '101', 'an.NABILATUN NISAUL UMMAH', '20000', '0', 'Chuwez', '2025-05-28 20:24:47'),
('3622', 'ST10100320250528062447', '1446-11-30', '2.220.10', '101', 'an.NABILATUN NISAUL UMMAH', '0', '20000', 'Chuwez', '2025-05-28 20:24:47'),
('3623', 'ST10100320250528062513', '1446-11-30', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '5000', '0', 'Chuwez', '2025-05-28 20:25:13'),
('3624', 'ST10100320250528062513', '1446-11-30', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '5000', 'Chuwez', '2025-05-28 20:25:13'),
('3625', 'ST10100320250528062549', '1446-11-30', '1.100.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '5000', '0', 'Chuwez', '2025-05-28 20:25:49'),
('3626', 'ST10100320250528062549', '1446-11-30', '2.220.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '0', '5000', 'Chuwez', '2025-05-28 20:25:49'),
('3627', 'ST10100320250528062613', '1446-11-30', '1.100.10', '101', 'an.RENI FARIDA', '2000', '0', 'Chuwez', '2025-05-28 20:26:13'),
('3628', 'ST10100320250528062613', '1446-11-30', '2.220.10', '101', 'an.RENI FARIDA', '0', '2000', 'Chuwez', '2025-05-28 20:26:13'),
('3629', 'ST10100320250528062636', '1446-11-30', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '10000', '0', 'Chuwez', '2025-05-28 20:26:36'),
('3630', 'ST10100320250528062636', '1446-11-30', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '10000', 'Chuwez', '2025-05-28 20:26:36'),
('3631', 'ST10100320250528062659', '1446-11-30', '1.100.10', '101', 'an.MIFTAHUL JANNAH', '50000', '0', 'Chuwez', '2025-05-28 20:26:59'),
('3632', 'ST10100320250528062659', '1446-11-30', '2.220.10', '101', 'an.MIFTAHUL JANNAH', '0', '50000', 'Chuwez', '2025-05-28 20:26:59'),
('3633', 'ST10100320250528062719', '1446-11-30', '1.100.10', '101', 'an.RAUDHOTUL JANNAH', '20000', '0', 'Chuwez', '2025-05-28 20:27:19'),
('3634', 'ST10100320250528062719', '1446-11-30', '2.220.10', '101', 'an.RAUDHOTUL JANNAH', '0', '20000', 'Chuwez', '2025-05-28 20:27:19'),
('3635', 'ST10100320250528062739', '1446-11-30', '1.100.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '10000', '0', 'Chuwez', '2025-05-28 20:27:39'),
('3636', 'ST10100320250528062739', '1446-11-30', '2.220.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '0', '10000', 'Chuwez', '2025-05-28 20:27:39'),
('3637', 'ST10100320250528062901', '1446-11-30', '1.100.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '4000', '0', 'Chuwez', '2025-05-28 20:29:01'),
('3638', 'ST10100320250528062901', '1446-11-30', '2.220.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '0', '4000', 'Chuwez', '2025-05-28 20:29:01'),
('3639', 'ST10100320250528070827', '1446-11-30', '1.100.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '10000', '0', 'Chuwez', '2025-05-28 21:08:27'),
('3640', 'ST10100320250528070827', '1446-11-30', '2.220.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '0', '10000', 'Chuwez', '2025-05-28 21:08:27'),
('3641', 'ST10100320250528070919', '1446-11-30', '1.100.10', '101', 'an.SITI QURROTUL AINI', '2000', '0', 'Chuwez', '2025-05-28 21:09:19'),
('3642', 'ST10100320250528070919', '1446-11-30', '2.220.10', '101', 'an.SITI QURROTUL AINI', '0', '2000', 'Chuwez', '2025-05-28 21:09:19'),
('3643', 'ST10100320250528071830', '1446-11-30', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '10000', '0', 'Chuwez', '2025-05-28 21:18:30'),
('3644', 'ST10100320250528071830', '1446-11-30', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '10000', 'Chuwez', '2025-05-28 21:18:30'),
('3645', 'ST10100320250528071853', '1446-11-30', '1.100.10', '101', 'an.SITI ATHIUR ROHMAH', '5000', '0', 'Chuwez', '2025-05-28 21:18:53'),
('3646', 'ST10100320250528071853', '1446-11-30', '2.220.10', '101', 'an.SITI ATHIUR ROHMAH', '0', '5000', 'Chuwez', '2025-05-28 21:18:53'),
('3647', 'ST10100320250528071912', '1446-11-30', '1.100.10', '101', 'an.KHOIRIYAH', '10000', '0', 'Chuwez', '2025-05-28 21:19:12'),
('3648', 'ST10100320250528071912', '1446-11-30', '2.220.10', '101', 'an.KHOIRIYAH', '0', '10000', 'Chuwez', '2025-05-28 21:19:12'),
('3649', 'ST10100320250528071933', '1446-11-30', '1.100.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '5000', '0', 'Chuwez', '2025-05-28 21:19:33'),
('3650', 'ST10100320250528071933', '1446-11-30', '2.220.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '0', '5000', 'Chuwez', '2025-05-28 21:19:33'),
('3651', 'ST10100320250528072013', '1446-11-30', '1.100.10', '101', 'an.SINDI RAISA PUTRI', '10000', '0', 'Chuwez', '2025-05-28 21:20:13'),
('3652', 'ST10100320250528072013', '1446-11-30', '2.220.10', '101', 'an.SINDI RAISA PUTRI', '0', '10000', 'Chuwez', '2025-05-28 21:20:13'),
('3653', 'ST10100320250528072039', '1446-11-30', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '25000', '0', 'Chuwez', '2025-05-28 21:20:39'),
('3654', 'ST10100320250528072039', '1446-11-30', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '25000', 'Chuwez', '2025-05-28 21:20:39'),
('3655', 'ST10100320250528072059', '1446-11-30', '1.100.10', '101', 'an.AHMAD ABBAS MAULANA', '3000', '0', 'Chuwez', '2025-05-28 21:20:59'),
('3656', 'ST10100320250528072059', '1446-11-30', '2.220.10', '101', 'an.AHMAD ABBAS MAULANA', '0', '3000', 'Chuwez', '2025-05-28 21:20:59'),
('3657', 'ST10100320250528072121', '1446-11-30', '1.100.10', '101', 'an.AKHMAD FIKRI HAIKAL', '50000', '0', 'Chuwez', '2025-05-28 21:21:21'),
('3658', 'ST10100320250528072121', '1446-11-30', '2.220.10', '101', 'an.AKHMAD FIKRI HAIKAL', '0', '50000', 'Chuwez', '2025-05-28 21:21:21'),
('3659', 'ST10100320250528072143', '1446-11-30', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '5000', '0', 'Chuwez', '2025-05-28 21:21:43'),
('3660', 'ST10100320250528072143', '1446-11-30', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '5000', 'Chuwez', '2025-05-28 21:21:43'),
('3661', 'ST10100320250528072203', '1446-11-30', '1.100.10', '101', 'an.ANA SALSABILA', '2000', '0', 'Chuwez', '2025-05-28 21:22:03'),
('3662', 'ST10100320250528072203', '1446-11-30', '2.220.10', '101', 'an.ANA SALSABILA', '0', '2000', 'Chuwez', '2025-05-28 21:22:03'),
('3663', 'ST10100320250528072223', '1446-11-30', '1.100.10', '101', 'an.AFANDI', '2000', '0', 'Chuwez', '2025-05-28 21:22:23'),
('3664', 'ST10100320250528072223', '1446-11-30', '2.220.10', '101', 'an.AFANDI', '0', '2000', 'Chuwez', '2025-05-28 21:22:23'),
('3665', 'ST10100320250528072239', '1446-11-30', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '5000', '0', 'Chuwez', '2025-05-28 21:22:39'),
('3666', 'ST10100320250528072239', '1446-11-30', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '5000', 'Chuwez', '2025-05-28 21:22:39'),
('3667', 'ST10100320250528072651', '1446-11-30', '1.100.10', '101', 'an.SAFIRATUL JANNAH', '10000', '0', 'Chuwez', '2025-05-28 21:26:51'),
('3668', 'ST10100320250528072651', '1446-11-30', '2.220.10', '101', 'an.SAFIRATUL JANNAH', '0', '10000', 'Chuwez', '2025-05-28 21:26:51'),
('3669', 'ST10100320250528072706', '1446-11-30', '1.100.10', '101', 'an.ACH. JUNAIDI', '5000', '0', 'Chuwez', '2025-05-28 21:27:06'),
('3670', 'ST10100320250528072706', '1446-11-30', '2.220.10', '101', 'an.ACH. JUNAIDI', '0', '5000', 'Chuwez', '2025-05-28 21:27:07'),
('3671', 'ST10100320250528072803', '1446-11-30', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '10000', '0', 'Chuwez', '2025-05-28 21:28:03'),
('3672', 'ST10100320250528072803', '1446-11-30', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '10000', 'Chuwez', '2025-05-28 21:28:03'),
('3673', 'ST10100320250528072823', '1446-11-30', '1.100.10', '101', 'an.M. ZIDAN RIZQI SALIM', '5000', '0', 'Chuwez', '2025-05-28 21:28:23'),
('3674', 'ST10100320250528072823', '1446-11-30', '2.220.10', '101', 'an.M. ZIDAN RIZQI SALIM', '0', '5000', 'Chuwez', '2025-05-28 21:28:23'),
('3675', 'ST10100320250528072846', '1446-11-30', '1.100.10', '101', 'an.FAIZAH NURUL LITA', '5000', '0', 'Chuwez', '2025-05-28 21:28:46'),
('3676', 'ST10100320250528072846', '1446-11-30', '2.220.10', '101', 'an.FAIZAH NURUL LITA', '0', '5000', 'Chuwez', '2025-05-28 21:28:46'),
('3677', 'ST10100320250528072906', '1446-11-30', '1.100.10', '101', 'an.MARIYATUL QIBTIYAH', '5000', '0', 'Chuwez', '2025-05-28 21:29:06'),
('3678', 'ST10100320250528072906', '1446-11-30', '2.220.10', '101', 'an.MARIYATUL QIBTIYAH', '0', '5000', 'Chuwez', '2025-05-28 21:29:06'),
('3679', 'ST10100320250528072924', '1446-11-30', '1.100.10', '101', 'an.UMAR FARUQ', '5000', '0', 'Chuwez', '2025-05-28 21:29:24'),
('3680', 'ST10100320250528072924', '1446-11-30', '2.220.10', '101', 'an.UMAR FARUQ', '0', '5000', 'Chuwez', '2025-05-28 21:29:24'),
('3681', 'ST10100320250528072940', '1446-11-30', '1.100.10', '101', 'an.UBAIDAH', '10000', '0', 'Chuwez', '2025-05-28 21:29:40'),
('3682', 'ST10100320250528072940', '1446-11-30', '2.220.10', '101', 'an.UBAIDAH', '0', '10000', 'Chuwez', '2025-05-28 21:29:40'),
('3683', 'ST10100320250528072956', '1446-11-30', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '10000', '0', 'Chuwez', '2025-05-28 21:29:56'),
('3684', 'ST10100320250528072956', '1446-11-30', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '10000', 'Chuwez', '2025-05-28 21:29:56'),
('3685', 'ST10100320250528073017', '1446-11-30', '1.100.10', '101', 'an.MUHAMMAD ALWI', '5000', '0', 'Chuwez', '2025-05-28 21:30:17'),
('3686', 'ST10100320250528073017', '1446-11-30', '2.220.10', '101', 'an.MUHAMMAD ALWI', '0', '5000', 'Chuwez', '2025-05-28 21:30:17'),
('3687', 'ST10100320250528073204', '1446-11-30', '1.100.10', '101', 'an.M. FAHMI NURUL ANAM', '20000', '0', 'Chuwez', '2025-05-28 21:32:04'),
('3688', 'ST10100320250528073204', '1446-11-30', '2.220.10', '101', 'an.M. FAHMI NURUL ANAM', '0', '20000', 'Chuwez', '2025-05-28 21:32:04'),
('3689', 'ST10100320250528073252', '1446-11-30', '1.100.10', '101', 'an.BILQIS THALIA HASNA', '60000', '0', 'Chuwez', '2025-05-28 21:32:52'),
('3690', 'ST10100320250528073252', '1446-11-30', '2.220.10', '101', 'an.BILQIS THALIA HASNA', '0', '60000', 'Chuwez', '2025-05-28 21:32:52'),
('3691', 'ST10100320250528073357', '1446-11-30', '1.100.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '5000', '0', 'Chuwez', '2025-05-28 21:33:57'),
('3692', 'ST10100320250528073357', '1446-11-30', '2.220.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '0', '5000', 'Chuwez', '2025-05-28 21:33:57'),
('3693', 'ST10100320250528073414', '1446-11-30', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '5000', '0', 'Chuwez', '2025-05-28 21:34:14'),
('3694', 'ST10100320250528073414', '1446-11-30', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '5000', 'Chuwez', '2025-05-28 21:34:14'),
('3695', 'ST10100320250528073440', '1446-11-30', '1.100.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '5000', '0', 'Chuwez', '2025-05-28 21:34:40'),
('3696', 'ST10100320250528073440', '1446-11-30', '2.220.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '0', '5000', 'Chuwez', '2025-05-28 21:34:40'),
('3697', 'ST10100320250528073513', '1446-11-30', '1.100.10', '101', 'an.NAURA BILADINA', '6000', '0', 'Chuwez', '2025-05-28 21:35:13'),
('3698', 'ST10100320250528073513', '1446-11-30', '2.220.10', '101', 'an.NAURA BILADINA', '0', '6000', 'Chuwez', '2025-05-28 21:35:13'),
('3699', 'ST10100320250528073533', '1446-11-30', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'Chuwez', '2025-05-28 21:35:33'),
('3700', 'ST10100320250528073533', '1446-11-30', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'Chuwez', '2025-05-28 21:35:33'),
('3701', 'ST10100320250528073552', '1446-11-30', '1.100.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '5000', '0', 'Chuwez', '2025-05-28 21:35:52'),
('3702', 'ST10100320250528073552', '1446-11-30', '2.220.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '0', '5000', 'Chuwez', '2025-05-28 21:35:52'),
('3703', 'ST10100320250528073612', '1446-11-30', '1.100.10', '101', 'an.AULIA AZZAHRA', '5000', '0', 'Chuwez', '2025-05-28 21:36:12'),
('3704', 'ST10100320250528073612', '1446-11-30', '2.220.10', '101', 'an.AULIA AZZAHRA', '0', '5000', 'Chuwez', '2025-05-28 21:36:12'),
('3705', 'ST10100320250528073635', '1446-11-30', '1.100.10', '101', 'an.M. ABD. HADI', '2000', '0', 'Chuwez', '2025-05-28 21:36:35'),
('3706', 'ST10100320250528073635', '1446-11-30', '2.220.10', '101', 'an.M. ABD. HADI', '0', '2000', 'Chuwez', '2025-05-28 21:36:35'),
('3707', 'ST10100320250528073647', '1446-11-30', '1.100.10', '101', 'an.HAIKAL SHOMADANI', '2000', '0', 'Chuwez', '2025-05-28 21:36:47'),
('3708', 'ST10100320250528073647', '1446-11-30', '2.220.10', '101', 'an.HAIKAL SHOMADANI', '0', '2000', 'Chuwez', '2025-05-28 21:36:47'),
('3709', 'ST10100320250528080518', '1446-11-30', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'Chuwez', '2025-05-28 22:05:18'),
('3710', 'ST10100320250528080518', '1446-11-30', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'Chuwez', '2025-05-28 22:05:18'),
('3711', 'ST10100320250528080601', '1446-11-30', '1.100.10', '101', 'an.HILYA', '20000', '0', 'Chuwez', '2025-05-28 22:06:01'),
('3712', 'ST10100320250528080601', '1446-11-30', '2.220.10', '101', 'an.HILYA', '0', '20000', 'Chuwez', '2025-05-28 22:06:01'),
('3713', 'ST10100320250528080817', '1446-11-30', '1.100.10', '101', 'an.AMARA', '20000', '0', 'Chuwez', '2025-05-28 22:08:17'),
('3714', 'ST10100320250528080817', '1446-11-30', '2.220.10', '101', 'an.AMARA', '0', '20000', 'Chuwez', '2025-05-28 22:08:17'),
('3715', 'SY10100320250529043524000', '1446-10-01', '1.100.10', '101', 'Bayar[NAURA BILADINA]', '30000', '0', 'Chuwez', '2025-05-29 11:35:24'),
('3716', 'SY10100320250529043524000', '1446-10-01', '4.400.20', '101', 'Bayar[NAURA BILADINA]', '0', '30000', 'Chuwez', '2025-05-29 11:35:24'),
('3717', 'SY10100320250529043656000', '1446-10-01', '1.100.10', '101', 'Bayar[MARIYATUL QIBTIYAH]', '30000', '0', 'Chuwez', '2025-05-29 11:36:56'),
('3718', 'SY10100320250529043656000', '1446-10-01', '4.400.20', '101', 'Bayar[MARIYATUL QIBTIYAH]', '0', '30000', 'Chuwez', '2025-05-29 11:36:56'),
('3719', 'SY10100320250529043813000', '1446-10-01', '1.100.10', '101', 'Bayar[MARIATUL QIBTIYAH]', '30000', '0', 'Chuwez', '2025-05-29 11:38:13'),
('3720', 'SY10100320250529043813000', '1446-10-01', '4.400.20', '101', 'Bayar[MARIATUL QIBTIYAH]', '0', '30000', 'Chuwez', '2025-05-29 11:38:13'),
('3721', 'SY10100320250529043813001', '1446-11-01', '1.100.10', '101', 'Bayar[MARIATUL QIBTIYAH]', '30000', '0', 'Chuwez', '2025-05-29 11:38:13'),
('3722', 'SY10100320250529043813001', '1446-11-01', '4.400.20', '101', 'Bayar[MARIATUL QIBTIYAH]', '0', '30000', 'Chuwez', '2025-05-29 11:38:13'),
('3723', 'SY10100320250529043919000', '1446-10-01', '1.100.10', '101', 'Bayar[ABDUL MUTHOLLIB]', '30000', '0', 'Chuwez', '2025-05-29 11:39:19'),
('3724', 'SY10100320250529043919000', '1446-10-01', '4.400.20', '101', 'Bayar[ABDUL MUTHOLLIB]', '0', '30000', 'Chuwez', '2025-05-29 11:39:19'),
('3725', 'SY10100320250529043919001', '1446-11-01', '1.100.10', '101', 'Bayar[ABDUL MUTHOLLIB]', '30000', '0', 'Chuwez', '2025-05-29 11:39:19'),
('3726', 'SY10100320250529043919001', '1446-11-01', '4.400.20', '101', 'Bayar[ABDUL MUTHOLLIB]', '0', '30000', 'Chuwez', '2025-05-29 11:39:19'),
('3727', 'SY10100320250529044008000', '1446-10-01', '1.100.10', '101', 'Bayar[AHMAD QUTHBI EL AMIN]', '30000', '0', 'Chuwez', '2025-05-29 11:40:08'),
('3728', 'SY10100320250529044008000', '1446-10-01', '4.400.20', '101', 'Bayar[AHMAD QUTHBI EL AMIN]', '0', '30000', 'Chuwez', '2025-05-29 11:40:08'),
('3729', 'SY10100320250529044008001', '1446-11-01', '1.100.10', '101', 'Bayar[AHMAD QUTHBI EL AMIN]', '30000', '0', 'Chuwez', '2025-05-29 11:40:08'),
('3730', 'SY10100320250529044008001', '1446-11-01', '4.400.20', '101', 'Bayar[AHMAD QUTHBI EL AMIN]', '0', '30000', 'Chuwez', '2025-05-29 11:40:08'),
('3731', 'SY10100320250529044058000', '1446-10-01', '1.100.10', '101', 'Bayar[ACHMAD FADLILUL AKMAL]', '30000', '0', 'Chuwez', '2025-05-29 11:40:58'),
('3732', 'SY10100320250529044058000', '1446-10-01', '4.400.20', '101', 'Bayar[ACHMAD FADLILUL AKMAL]', '0', '30000', 'Chuwez', '2025-05-29 11:40:58'),
('3733', 'SY10100320250529044138000', '1446-10-01', '1.100.10', '101', 'Bayar[AHMAD ADITIYA]', '30000', '0', 'Chuwez', '2025-05-29 11:41:38'),
('3734', 'SY10100320250529044138000', '1446-10-01', '4.400.20', '101', 'Bayar[AHMAD ADITIYA]', '0', '30000', 'Chuwez', '2025-05-29 11:41:38'),
('3735', 'SY10100320250529044255000', '1446-10-01', '1.100.10', '101', 'Bayar[M. ZAINURI AZIZ SINATRIA]', '30000', '0', 'Chuwez', '2025-05-29 11:42:55'),
('3736', 'SY10100320250529044255000', '1446-10-01', '4.400.20', '101', 'Bayar[M. ZAINURI AZIZ SINATRIA]', '0', '30000', 'Chuwez', '2025-05-29 11:42:55'),
('3737', 'SY10100320250529044255001', '1446-11-01', '1.100.10', '101', 'Bayar[M. ZAINURI AZIZ SINATRIA]', '30000', '0', 'Chuwez', '2025-05-29 11:42:55'),
('3738', 'SY10100320250529044255001', '1446-11-01', '4.400.20', '101', 'Bayar[M. ZAINURI AZIZ SINATRIA]', '0', '30000', 'Chuwez', '2025-05-29 11:42:55'),
('3739', 'SY10100320250529044255002', '1446-12-01', '1.100.10', '101', 'Bayar[M. ZAINURI AZIZ SINATRIA]', '30000', '0', 'Chuwez', '2025-05-29 11:42:55'),
('3740', 'SY10100320250529044255002', '1446-12-01', '4.400.20', '101', 'Bayar[M. ZAINURI AZIZ SINATRIA]', '0', '30000', 'Chuwez', '2025-05-29 11:42:55'),
('3741', 'SY10100320250529044255003', '1447-01-01', '1.100.10', '101', 'Bayar[M. ZAINURI AZIZ SINATRIA]', '30000', '0', 'Chuwez', '2025-05-29 11:42:55'),
('3742', 'SY10100320250529044255003', '1447-01-01', '4.400.20', '101', 'Bayar[M. ZAINURI AZIZ SINATRIA]', '0', '30000', 'Chuwez', '2025-05-29 11:42:55'),
('3743', 'SY10100320250529044255004', '1447-02-01', '1.100.10', '101', 'Bayar[M. ZAINURI AZIZ SINATRIA]', '30000', '0', 'Chuwez', '2025-05-29 11:42:55'),
('3744', 'SY10100320250529044255004', '1447-02-01', '4.400.20', '101', 'Bayar[M. ZAINURI AZIZ SINATRIA]', '0', '30000', 'Chuwez', '2025-05-29 11:42:55'),
('3745', 'SY10100320250529044255005', '1447-03-01', '1.100.10', '101', 'Bayar[M. ZAINURI AZIZ SINATRIA]', '30000', '0', 'Chuwez', '2025-05-29 11:42:55'),
('3746', 'SY10100320250529044255005', '1447-03-01', '4.400.20', '101', 'Bayar[M. ZAINURI AZIZ SINATRIA]', '0', '30000', 'Chuwez', '2025-05-29 11:42:55'),
('3747', 'SY10100320250529044536000', '1446-10-01', '1.100.10', '101', 'Bayar[NAYLA FITRI AULIA]', '30000', '0', 'Chuwez', '2025-05-29 11:45:36'),
('3748', 'SY10100320250529044536000', '1446-10-01', '4.400.20', '101', 'Bayar[NAYLA FITRI AULIA]', '0', '30000', 'Chuwez', '2025-05-29 11:45:36'),
('3749', 'SY10100320250529044536001', '1446-11-01', '1.100.10', '101', 'Bayar[NAYLA FITRI AULIA]', '30000', '0', 'Chuwez', '2025-05-29 11:45:36'),
('3750', 'SY10100320250529044536001', '1446-11-01', '4.400.20', '101', 'Bayar[NAYLA FITRI AULIA]', '0', '30000', 'Chuwez', '2025-05-29 11:45:36'),
('3751', 'SY10100320250529044630000', '1446-10-01', '1.100.10', '101', 'Bayar[MOCH KHOTIBUL UMAM]', '30000', '0', 'Chuwez', '2025-05-29 11:46:30'),
('3752', 'SY10100320250529044630000', '1446-10-01', '4.400.20', '101', 'Bayar[MOCH KHOTIBUL UMAM]', '0', '30000', 'Chuwez', '2025-05-29 11:46:30'),
('3753', 'SY10100320250529044630001', '1446-11-01', '1.100.10', '101', 'Bayar[MOCH KHOTIBUL UMAM]', '30000', '0', 'Chuwez', '2025-05-29 11:46:30'),
('3754', 'SY10100320250529044630001', '1446-11-01', '4.400.20', '101', 'Bayar[MOCH KHOTIBUL UMAM]', '0', '30000', 'Chuwez', '2025-05-29 11:46:30'),
('3755', 'SY10100320250529044631002', '1446-12-01', '1.100.10', '101', 'Bayar[MOCH KHOTIBUL UMAM]', '30000', '0', 'Chuwez', '2025-05-29 11:46:31'),
('3756', 'SY10100320250529044631002', '1446-12-01', '4.400.20', '101', 'Bayar[MOCH KHOTIBUL UMAM]', '0', '30000', 'Chuwez', '2025-05-29 11:46:31'),
('3757', 'SY10100320250529044631003', '1447-01-01', '1.100.10', '101', 'Bayar[MOCH KHOTIBUL UMAM]', '30000', '0', 'Chuwez', '2025-05-29 11:46:31'),
('3758', 'SY10100320250529044631003', '1447-01-01', '4.400.20', '101', 'Bayar[MOCH KHOTIBUL UMAM]', '0', '30000', 'Chuwez', '2025-05-29 11:46:31'),
('3759', 'SY10100320250529044631004', '1447-02-01', '1.100.10', '101', 'Bayar[MOCH KHOTIBUL UMAM]', '30000', '0', 'Chuwez', '2025-05-29 11:46:31'),
('3760', 'SY10100320250529044631004', '1447-02-01', '4.400.20', '101', 'Bayar[MOCH KHOTIBUL UMAM]', '0', '30000', 'Chuwez', '2025-05-29 11:46:31'),
('3761', 'SY10100320250529044719000', '1446-10-01', '1.100.10', '101', 'Bayar[MUHAMMAD YAQUB HAMDANI]', '30000', '0', 'Chuwez', '2025-05-29 11:47:19'),
('3762', 'SY10100320250529044719000', '1446-10-01', '4.400.20', '101', 'Bayar[MUHAMMAD YAQUB HAMDANI]', '0', '30000', 'Chuwez', '2025-05-29 11:47:19'),
('3763', 'SY10100320250529044719001', '1446-11-01', '1.100.10', '101', 'Bayar[MUHAMMAD YAQUB HAMDANI]', '30000', '0', 'Chuwez', '2025-05-29 11:47:19'),
('3764', 'SY10100320250529044719001', '1446-11-01', '4.400.20', '101', 'Bayar[MUHAMMAD YAQUB HAMDANI]', '0', '30000', 'Chuwez', '2025-05-29 11:47:19'),
('3765', 'SY10100320250529044719002', '1446-12-01', '1.100.10', '101', 'Bayar[MUHAMMAD YAQUB HAMDANI]', '30000', '0', 'Chuwez', '2025-05-29 11:47:19'),
('3766', 'SY10100320250529044719002', '1446-12-01', '4.400.20', '101', 'Bayar[MUHAMMAD YAQUB HAMDANI]', '0', '30000', 'Chuwez', '2025-05-29 11:47:19'),
('3767', 'SY10100320250529044804000', '1446-10-01', '1.100.10', '101', 'Bayar[SALWA LAILI]', '30000', '0', 'Chuwez', '2025-05-29 11:48:04'),
('3768', 'SY10100320250529044804000', '1446-10-01', '4.400.20', '101', 'Bayar[SALWA LAILI]', '0', '30000', 'Chuwez', '2025-05-29 11:48:04'),
('3769', 'SY10100320250529044851000', '1446-10-01', '1.100.10', '101', 'Bayar[MUTHIMATUS SHOLIHAH]', '30000', '0', 'Chuwez', '2025-05-29 11:48:51'),
('3770', 'SY10100320250529044851000', '1446-10-01', '4.400.20', '101', 'Bayar[MUTHIMATUS SHOLIHAH]', '0', '30000', 'Chuwez', '2025-05-29 11:48:51'),
('3771', 'SY10100320250529045025000', '1446-10-01', '1.100.10', '101', 'Bayar[AQILA SHIDQIA]', '30000', '0', 'Chuwez', '2025-05-29 11:50:25'),
('3772', 'SY10100320250529045025000', '1446-10-01', '4.400.20', '101', 'Bayar[AQILA SHIDQIA]', '0', '30000', 'Chuwez', '2025-05-29 11:50:25'),
('3773', 'SY10100320250529045025001', '1446-11-01', '1.100.10', '101', 'Bayar[AQILA SHIDQIA]', '30000', '0', 'Chuwez', '2025-05-29 11:50:25'),
('3774', 'SY10100320250529045025001', '1446-11-01', '4.400.20', '101', 'Bayar[AQILA SHIDQIA]', '0', '30000', 'Chuwez', '2025-05-29 11:50:25'),
('3775', 'SY10100320250529045025002', '1446-12-01', '1.100.10', '101', 'Bayar[AQILA SHIDQIA]', '30000', '0', 'Chuwez', '2025-05-29 11:50:25'),
('3776', 'SY10100320250529045025002', '1446-12-01', '4.400.20', '101', 'Bayar[AQILA SHIDQIA]', '0', '30000', 'Chuwez', '2025-05-29 11:50:25'),
('3777', 'SY10100320250529045025003', '1447-01-01', '1.100.10', '101', 'Bayar[AQILA SHIDQIA]', '30000', '0', 'Chuwez', '2025-05-29 11:50:25'),
('3778', 'SY10100320250529045025003', '1447-01-01', '4.400.20', '101', 'Bayar[AQILA SHIDQIA]', '0', '30000', 'Chuwez', '2025-05-29 11:50:25'),
('3779', 'SY10100320250529045025004', '1447-02-01', '1.100.10', '101', 'Bayar[AQILA SHIDQIA]', '30000', '0', 'Chuwez', '2025-05-29 11:50:25'),
('3780', 'SY10100320250529045025004', '1447-02-01', '4.400.20', '101', 'Bayar[AQILA SHIDQIA]', '0', '30000', 'Chuwez', '2025-05-29 11:50:25'),
('3781', 'SY10100320250529045025005', '1447-03-01', '1.100.10', '101', 'Bayar[AQILA SHIDQIA]', '30000', '0', 'Chuwez', '2025-05-29 11:50:25'),
('3782', 'SY10100320250529045025005', '1447-03-01', '4.400.20', '101', 'Bayar[AQILA SHIDQIA]', '0', '30000', 'Chuwez', '2025-05-29 11:50:25'),
('3783', 'SY10100320250529045025006', '1447-04-01', '1.100.10', '101', 'Bayar[AQILA SHIDQIA]', '30000', '0', 'Chuwez', '2025-05-29 11:50:25'),
('3784', 'SY10100320250529045025006', '1447-04-01', '4.400.20', '101', 'Bayar[AQILA SHIDQIA]', '0', '30000', 'Chuwez', '2025-05-29 11:50:25'),
('3785', 'SY10100320250529045025007', '1447-05-01', '1.100.10', '101', 'Bayar[AQILA SHIDQIA]', '30000', '0', 'Chuwez', '2025-05-29 11:50:25'),
('3786', 'SY10100320250529045025007', '1447-05-01', '4.400.20', '101', 'Bayar[AQILA SHIDQIA]', '0', '30000', 'Chuwez', '2025-05-29 11:50:25'),
('3787', 'SY10100320250529045025008', '1447-06-01', '1.100.10', '101', 'Bayar[AQILA SHIDQIA]', '30000', '0', 'Chuwez', '2025-05-29 11:50:25'),
('3788', 'SY10100320250529045025008', '1447-06-01', '4.400.20', '101', 'Bayar[AQILA SHIDQIA]', '0', '30000', 'Chuwez', '2025-05-29 11:50:25'),
('3789', 'SY10100320250529045025009', '1447-07-01', '1.100.10', '101', 'Bayar[AQILA SHIDQIA]', '30000', '0', 'Chuwez', '2025-05-29 11:50:25'),
('3790', 'SY10100320250529045025009', '1447-07-01', '4.400.20', '101', 'Bayar[AQILA SHIDQIA]', '0', '30000', 'Chuwez', '2025-05-29 11:50:25'),
('3791', 'SY10100320250529045026010', '1447-08-01', '1.100.10', '101', 'Bayar[AQILA SHIDQIA]', '30000', '0', 'Chuwez', '2025-05-29 11:50:26'),
('3792', 'SY10100320250529045026010', '1447-08-01', '4.400.20', '101', 'Bayar[AQILA SHIDQIA]', '0', '30000', 'Chuwez', '2025-05-29 11:50:26'),
('3793', 'SY10100320250529045159000', '1446-10-01', '1.100.10', '101', 'Bayar[MUHAMMAD NAUFAL BADRUTTAMAM]', '30000', '0', 'Chuwez', '2025-05-29 11:51:59'),
('3794', 'SY10100320250529045159000', '1446-10-01', '4.400.20', '101', 'Bayar[MUHAMMAD NAUFAL BADRUTTAMAM]', '0', '30000', 'Chuwez', '2025-05-29 11:51:59'),
('3795', 'SY10100320250529045200001', '1446-11-01', '1.100.10', '101', 'Bayar[MUHAMMAD NAUFAL BADRUTTAMAM]', '30000', '0', 'Chuwez', '2025-05-29 11:52:00'),
('3796', 'SY10100320250529045200001', '1446-11-01', '4.400.20', '101', 'Bayar[MUHAMMAD NAUFAL BADRUTTAMAM]', '0', '30000', 'Chuwez', '2025-05-29 11:52:00'),
('3797', 'SY10100320250529045200002', '1446-12-01', '1.100.10', '101', 'Bayar[MUHAMMAD NAUFAL BADRUTTAMAM]', '30000', '0', 'Chuwez', '2025-05-29 11:52:00'),
('3798', 'SY10100320250529045200002', '1446-12-01', '4.400.20', '101', 'Bayar[MUHAMMAD NAUFAL BADRUTTAMAM]', '0', '30000', 'Chuwez', '2025-05-29 11:52:00'),
('3799', 'SY10100320250529045200003', '1447-01-01', '1.100.10', '101', 'Bayar[MUHAMMAD NAUFAL BADRUTTAMAM]', '30000', '0', 'Chuwez', '2025-05-29 11:52:00'),
('3800', 'SY10100320250529045200003', '1447-01-01', '4.400.20', '101', 'Bayar[MUHAMMAD NAUFAL BADRUTTAMAM]', '0', '30000', 'Chuwez', '2025-05-29 11:52:00'),
('3801', 'SY10100320250529045200004', '1447-02-01', '1.100.10', '101', 'Bayar[MUHAMMAD NAUFAL BADRUTTAMAM]', '30000', '0', 'Chuwez', '2025-05-29 11:52:00'),
('3802', 'SY10100320250529045200004', '1447-02-01', '4.400.20', '101', 'Bayar[MUHAMMAD NAUFAL BADRUTTAMAM]', '0', '30000', 'Chuwez', '2025-05-29 11:52:00'),
('3803', 'SY10100320250529045200005', '1447-03-01', '1.100.10', '101', 'Bayar[MUHAMMAD NAUFAL BADRUTTAMAM]', '30000', '0', 'Chuwez', '2025-05-29 11:52:00'),
('3804', 'SY10100320250529045200005', '1447-03-01', '4.400.20', '101', 'Bayar[MUHAMMAD NAUFAL BADRUTTAMAM]', '0', '30000', 'Chuwez', '2025-05-29 11:52:00'),
('3805', 'SY10100320250529045200006', '1447-04-01', '1.100.10', '101', 'Bayar[MUHAMMAD NAUFAL BADRUTTAMAM]', '30000', '0', 'Chuwez', '2025-05-29 11:52:00'),
('3806', 'SY10100320250529045200006', '1447-04-01', '4.400.20', '101', 'Bayar[MUHAMMAD NAUFAL BADRUTTAMAM]', '0', '30000', 'Chuwez', '2025-05-29 11:52:00'),
('3807', 'SY10100320250529045200007', '1447-05-01', '1.100.10', '101', 'Bayar[MUHAMMAD NAUFAL BADRUTTAMAM]', '30000', '0', 'Chuwez', '2025-05-29 11:52:00'),
('3808', 'SY10100320250529045200007', '1447-05-01', '4.400.20', '101', 'Bayar[MUHAMMAD NAUFAL BADRUTTAMAM]', '0', '30000', 'Chuwez', '2025-05-29 11:52:00'),
('3809', 'SY10100320250529045200008', '1447-06-01', '1.100.10', '101', 'Bayar[MUHAMMAD NAUFAL BADRUTTAMAM]', '30000', '0', 'Chuwez', '2025-05-29 11:52:00'),
('3810', 'SY10100320250529045200008', '1447-06-01', '4.400.20', '101', 'Bayar[MUHAMMAD NAUFAL BADRUTTAMAM]', '0', '30000', 'Chuwez', '2025-05-29 11:52:00'),
('3811', 'SY10100320250529045200009', '1447-07-01', '1.100.10', '101', 'Bayar[MUHAMMAD NAUFAL BADRUTTAMAM]', '30000', '0', 'Chuwez', '2025-05-29 11:52:00'),
('3812', 'SY10100320250529045200009', '1447-07-01', '4.400.20', '101', 'Bayar[MUHAMMAD NAUFAL BADRUTTAMAM]', '0', '30000', 'Chuwez', '2025-05-29 11:52:00'),
('3813', 'SY10100320250529045200010', '1447-08-01', '1.100.10', '101', 'Bayar[MUHAMMAD NAUFAL BADRUTTAMAM]', '30000', '0', 'Chuwez', '2025-05-29 11:52:00'),
('3814', 'SY10100320250529045200010', '1447-08-01', '4.400.20', '101', 'Bayar[MUHAMMAD NAUFAL BADRUTTAMAM]', '0', '30000', 'Chuwez', '2025-05-29 11:52:00'),
('3815', 'SY10100320250529045735000', '1446-10-01', '1.100.10', '101', 'Bayar[AHMAD ALFAN DZIKRI RAMADHAN]', '30000', '0', 'Chuwez', '2025-05-29 11:57:35'),
('3816', 'SY10100320250529045735000', '1446-10-01', '4.400.20', '101', 'Bayar[AHMAD ALFAN DZIKRI RAMADHAN]', '0', '30000', 'Chuwez', '2025-05-29 11:57:35'),
('3817', 'SY10100320250529045735001', '1446-11-01', '1.100.10', '101', 'Bayar[AHMAD ALFAN DZIKRI RAMADHAN]', '30000', '0', 'Chuwez', '2025-05-29 11:57:35'),
('3818', 'SY10100320250529045735001', '1446-11-01', '4.400.20', '101', 'Bayar[AHMAD ALFAN DZIKRI RAMADHAN]', '0', '30000', 'Chuwez', '2025-05-29 11:57:35'),
('3819', 'SY10100320250529045735002', '1446-12-01', '1.100.10', '101', 'Bayar[AHMAD ALFAN DZIKRI RAMADHAN]', '30000', '0', 'Chuwez', '2025-05-29 11:57:35'),
('3820', 'SY10100320250529045735002', '1446-12-01', '4.400.20', '101', 'Bayar[AHMAD ALFAN DZIKRI RAMADHAN]', '0', '30000', 'Chuwez', '2025-05-29 11:57:35'),
('3821', 'SY10100320250529045825000', '1446-10-01', '1.100.10', '101', 'Bayar[SAFIRATUL JANNAH]', '30000', '0', 'Chuwez', '2025-05-29 11:58:25'),
('3822', 'SY10100320250529045825000', '1446-10-01', '4.400.20', '101', 'Bayar[SAFIRATUL JANNAH]', '0', '30000', 'Chuwez', '2025-05-29 11:58:25'),
('3823', 'SY10100320250529045921000', '1446-10-01', '1.100.10', '101', 'Bayar[NUR HIDAYATULLOH]', '30000', '0', 'Chuwez', '2025-05-29 11:59:21'),
('3824', 'SY10100320250529045921000', '1446-10-01', '4.400.20', '101', 'Bayar[NUR HIDAYATULLOH]', '0', '30000', 'Chuwez', '2025-05-29 11:59:21'),
('3825', 'SY10100320250529045921001', '1446-11-01', '1.100.10', '101', 'Bayar[NUR HIDAYATULLOH]', '30000', '0', 'Chuwez', '2025-05-29 11:59:21'),
('3826', 'SY10100320250529045921001', '1446-11-01', '4.400.20', '101', 'Bayar[NUR HIDAYATULLOH]', '0', '30000', 'Chuwez', '2025-05-29 11:59:21'),
('3827', 'SY10100320250529045921002', '1446-12-01', '1.100.10', '101', 'Bayar[NUR HIDAYATULLOH]', '30000', '0', 'Chuwez', '2025-05-29 11:59:21'),
('3828', 'SY10100320250529045921002', '1446-12-01', '4.400.20', '101', 'Bayar[NUR HIDAYATULLOH]', '0', '30000', 'Chuwez', '2025-05-29 11:59:21'),
('3829', 'SY10100320250529045922003', '1447-01-01', '1.100.10', '101', 'Bayar[NUR HIDAYATULLOH]', '30000', '0', 'Chuwez', '2025-05-29 11:59:22'),
('3830', 'SY10100320250529045922003', '1447-01-01', '4.400.20', '101', 'Bayar[NUR HIDAYATULLOH]', '0', '30000', 'Chuwez', '2025-05-29 11:59:22'),
('3831', 'SY10100320250529045922004', '1447-02-01', '1.100.10', '101', 'Bayar[NUR HIDAYATULLOH]', '30000', '0', 'Chuwez', '2025-05-29 11:59:22'),
('3832', 'SY10100320250529045922004', '1447-02-01', '4.400.20', '101', 'Bayar[NUR HIDAYATULLOH]', '0', '30000', 'Chuwez', '2025-05-29 11:59:22'),
('3833', 'SY10100320250529045922005', '1447-03-01', '1.100.10', '101', 'Bayar[NUR HIDAYATULLOH]', '30000', '0', 'Chuwez', '2025-05-29 11:59:22'),
('3834', 'SY10100320250529045922005', '1447-03-01', '4.400.20', '101', 'Bayar[NUR HIDAYATULLOH]', '0', '30000', 'Chuwez', '2025-05-29 11:59:22'),
('3835', 'SY10100320250529045922006', '1447-04-01', '1.100.10', '101', 'Bayar[NUR HIDAYATULLOH]', '30000', '0', 'Chuwez', '2025-05-29 11:59:22'),
('3836', 'SY10100320250529045922006', '1447-04-01', '4.400.20', '101', 'Bayar[NUR HIDAYATULLOH]', '0', '30000', 'Chuwez', '2025-05-29 11:59:22'),
('3837', 'SY10100320250529045922007', '1447-05-01', '1.100.10', '101', 'Bayar[NUR HIDAYATULLOH]', '30000', '0', 'Chuwez', '2025-05-29 11:59:22'),
('3838', 'SY10100320250529045922007', '1447-05-01', '4.400.20', '101', 'Bayar[NUR HIDAYATULLOH]', '0', '30000', 'Chuwez', '2025-05-29 11:59:22'),
('3839', 'SY10100320250529045922008', '1447-06-01', '1.100.10', '101', 'Bayar[NUR HIDAYATULLOH]', '30000', '0', 'Chuwez', '2025-05-29 11:59:22'),
('3840', 'SY10100320250529045922008', '1447-06-01', '4.400.20', '101', 'Bayar[NUR HIDAYATULLOH]', '0', '30000', 'Chuwez', '2025-05-29 11:59:22'),
('3841', 'SY10100320250529045922009', '1447-07-01', '1.100.10', '101', 'Bayar[NUR HIDAYATULLOH]', '30000', '0', 'Chuwez', '2025-05-29 11:59:22'),
('3842', 'SY10100320250529045922009', '1447-07-01', '4.400.20', '101', 'Bayar[NUR HIDAYATULLOH]', '0', '30000', 'Chuwez', '2025-05-29 11:59:22'),
('3843', 'SY10100320250529045922010', '1447-08-01', '1.100.10', '101', 'Bayar[NUR HIDAYATULLOH]', '30000', '0', 'Chuwez', '2025-05-29 11:59:22'),
('3844', 'SY10100320250529045922010', '1447-08-01', '4.400.20', '101', 'Bayar[NUR HIDAYATULLOH]', '0', '30000', 'Chuwez', '2025-05-29 11:59:22'),
('3845', 'SY10100320250529052939000', '1446-10-01', '1.100.10', '101', 'Bayar[CHUSNIYAH RAMADHANI]', '30000', '0', 'Chuwez', '2025-05-29 12:29:39'),
('3846', 'SY10100320250529052939000', '1446-10-01', '4.400.20', '101', 'Bayar[CHUSNIYAH RAMADHANI]', '0', '30000', 'Chuwez', '2025-05-29 12:29:39'),
('3847', 'SY10100320250529052939001', '1446-11-01', '1.100.10', '101', 'Bayar[CHUSNIYAH RAMADHANI]', '30000', '0', 'Chuwez', '2025-05-29 12:29:39'),
('3848', 'SY10100320250529052939001', '1446-11-01', '4.400.20', '101', 'Bayar[CHUSNIYAH RAMADHANI]', '0', '30000', 'Chuwez', '2025-05-29 12:29:39'),
('3849', 'SY10100320250529053245000', '1446-10-01', '1.100.10', '101', 'Bayar[M. KAMALUDDIN]', '30000', '0', 'Chuwez', '2025-05-29 12:32:45'),
('3850', 'SY10100320250529053245000', '1446-10-01', '4.400.20', '101', 'Bayar[M. KAMALUDDIN]', '0', '30000', 'Chuwez', '2025-05-29 12:32:45'),
('3851', 'SY10100320250529053245001', '1446-11-01', '1.100.10', '101', 'Bayar[M. KAMALUDDIN]', '30000', '0', 'Chuwez', '2025-05-29 12:32:45'),
('3852', 'SY10100320250529053245001', '1446-11-01', '4.400.20', '101', 'Bayar[M. KAMALUDDIN]', '0', '30000', 'Chuwez', '2025-05-29 12:32:45'),
('3853', 'SY10100320250529053341000', '1446-10-01', '1.100.10', '101', 'Bayar[A. KHOIRUN NIZAM]', '30000', '0', 'Chuwez', '2025-05-29 12:33:41'),
('3854', 'SY10100320250529053341000', '1446-10-01', '4.400.20', '101', 'Bayar[A. KHOIRUN NIZAM]', '0', '30000', 'Chuwez', '2025-05-29 12:33:41'),
('3855', 'SY10100320250529053437000', '1446-10-01', '1.100.10', '101', 'Bayar[ZAIDATUS SYARIFATUN NAJWA]', '30000', '0', 'Chuwez', '2025-05-29 12:34:37'),
('3856', 'SY10100320250529053437000', '1446-10-01', '4.400.20', '101', 'Bayar[ZAIDATUS SYARIFATUN NAJWA]', '0', '30000', 'Chuwez', '2025-05-29 12:34:37'),
('3857', 'SY10100320250529053437001', '1446-11-01', '1.100.10', '101', 'Bayar[ZAIDATUS SYARIFATUN NAJWA]', '30000', '0', 'Chuwez', '2025-05-29 12:34:37'),
('3858', 'SY10100320250529053437001', '1446-11-01', '4.400.20', '101', 'Bayar[ZAIDATUS SYARIFATUN NAJWA]', '0', '30000', 'Chuwez', '2025-05-29 12:34:37'),
('3859', 'SY10100320250529053519000', '1446-10-01', '1.100.10', '101', 'Bayar[M. ROFIQ HIDAYATULLOH]', '30000', '0', 'Chuwez', '2025-05-29 12:35:19'),
('3860', 'SY10100320250529053519000', '1446-10-01', '4.400.20', '101', 'Bayar[M. ROFIQ HIDAYATULLOH]', '0', '30000', 'Chuwez', '2025-05-29 12:35:19'),
('3861', 'SY10100320250529053642000', '1446-10-01', '1.100.10', '101', 'Bayar[ROBIATUL ADAWIYAH]', '30000', '0', 'Chuwez', '2025-05-29 12:36:42'),
('3862', 'SY10100320250529053642000', '1446-10-01', '4.400.20', '101', 'Bayar[ROBIATUL ADAWIYAH]', '0', '30000', 'Chuwez', '2025-05-29 12:36:42'),
('3863', 'SY10100320250529053741000', '1446-10-01', '1.100.10', '101', 'Bayar[SAUQY AHMAD]', '30000', '0', 'Chuwez', '2025-05-29 12:37:41'),
('3864', 'SY10100320250529053741000', '1446-10-01', '4.400.20', '101', 'Bayar[SAUQY AHMAD]', '0', '30000', 'Chuwez', '2025-05-29 12:37:41'),
('3865', 'SY10100320250529053741001', '1446-11-01', '1.100.10', '101', 'Bayar[SAUQY AHMAD]', '30000', '0', 'Chuwez', '2025-05-29 12:37:41'),
('3866', 'SY10100320250529053741001', '1446-11-01', '4.400.20', '101', 'Bayar[SAUQY AHMAD]', '0', '30000', 'Chuwez', '2025-05-29 12:37:41'),
('3867', 'SY10100320250529053835000', '1446-10-01', '1.100.10', '101', 'Bayar[BILQIS THALIA HASNA]', '30000', '0', 'Chuwez', '2025-05-29 12:38:35'),
('3868', 'SY10100320250529053835000', '1446-10-01', '4.400.20', '101', 'Bayar[BILQIS THALIA HASNA]', '0', '30000', 'Chuwez', '2025-05-29 12:38:35'),
('3869', 'SY10100320250529054103000', '1446-10-01', '1.100.10', '101', 'Bayar[ACHMAD ZAFRAN SHINAGA]', '30000', '0', 'Chuwez', '2025-05-29 12:41:03'),
('3870', 'SY10100320250529054103000', '1446-10-01', '4.400.20', '101', 'Bayar[ACHMAD ZAFRAN SHINAGA]', '0', '30000', 'Chuwez', '2025-05-29 12:41:03'),
('3871', 'SY10100320250529054103001', '1446-11-01', '1.100.10', '101', 'Bayar[ACHMAD ZAFRAN SHINAGA]', '30000', '0', 'Chuwez', '2025-05-29 12:41:03'),
('3872', 'SY10100320250529054103001', '1446-11-01', '4.400.20', '101', 'Bayar[ACHMAD ZAFRAN SHINAGA]', '0', '30000', 'Chuwez', '2025-05-29 12:41:03'),
('3873', 'SY10100320250529054103002', '1446-12-01', '1.100.10', '101', 'Bayar[ACHMAD ZAFRAN SHINAGA]', '30000', '0', 'Chuwez', '2025-05-29 12:41:03'),
('3874', 'SY10100320250529054103002', '1446-12-01', '4.400.20', '101', 'Bayar[ACHMAD ZAFRAN SHINAGA]', '0', '30000', 'Chuwez', '2025-05-29 12:41:03'),
('3875', 'SY10100320250529054103003', '1447-01-01', '1.100.10', '101', 'Bayar[ACHMAD ZAFRAN SHINAGA]', '30000', '0', 'Chuwez', '2025-05-29 12:41:03'),
('3876', 'SY10100320250529054103003', '1447-01-01', '4.400.20', '101', 'Bayar[ACHMAD ZAFRAN SHINAGA]', '0', '30000', 'Chuwez', '2025-05-29 12:41:03'),
('3877', 'SY10100320250529054104004', '1447-02-01', '1.100.10', '101', 'Bayar[ACHMAD ZAFRAN SHINAGA]', '30000', '0', 'Chuwez', '2025-05-29 12:41:04'),
('3878', 'SY10100320250529054104004', '1447-02-01', '4.400.20', '101', 'Bayar[ACHMAD ZAFRAN SHINAGA]', '0', '30000', 'Chuwez', '2025-05-29 12:41:04'),
('3879', 'SY10100320250529054104005', '1447-03-01', '1.100.10', '101', 'Bayar[ACHMAD ZAFRAN SHINAGA]', '30000', '0', 'Chuwez', '2025-05-29 12:41:04'),
('3880', 'SY10100320250529054104005', '1447-03-01', '4.400.20', '101', 'Bayar[ACHMAD ZAFRAN SHINAGA]', '0', '30000', 'Chuwez', '2025-05-29 12:41:04'),
('3881', 'SY10100320250529054104006', '1447-04-01', '1.100.10', '101', 'Bayar[ACHMAD ZAFRAN SHINAGA]', '30000', '0', 'Chuwez', '2025-05-29 12:41:04'),
('3882', 'SY10100320250529054104006', '1447-04-01', '4.400.20', '101', 'Bayar[ACHMAD ZAFRAN SHINAGA]', '0', '30000', 'Chuwez', '2025-05-29 12:41:04'),
('3883', 'SY10100320250529054104007', '1447-05-01', '1.100.10', '101', 'Bayar[ACHMAD ZAFRAN SHINAGA]', '30000', '0', 'Chuwez', '2025-05-29 12:41:04'),
('3884', 'SY10100320250529054104007', '1447-05-01', '4.400.20', '101', 'Bayar[ACHMAD ZAFRAN SHINAGA]', '0', '30000', 'Chuwez', '2025-05-29 12:41:04'),
('3885', 'SY10100320250529054104008', '1447-06-01', '1.100.10', '101', 'Bayar[ACHMAD ZAFRAN SHINAGA]', '30000', '0', 'Chuwez', '2025-05-29 12:41:04'),
('3886', 'SY10100320250529054104008', '1447-06-01', '4.400.20', '101', 'Bayar[ACHMAD ZAFRAN SHINAGA]', '0', '30000', 'Chuwez', '2025-05-29 12:41:04'),
('3887', 'SY10100320250529054104009', '1447-07-01', '1.100.10', '101', 'Bayar[ACHMAD ZAFRAN SHINAGA]', '30000', '0', 'Chuwez', '2025-05-29 12:41:04'),
('3888', 'SY10100320250529054104009', '1447-07-01', '4.400.20', '101', 'Bayar[ACHMAD ZAFRAN SHINAGA]', '0', '30000', 'Chuwez', '2025-05-29 12:41:04'),
('3889', 'SY10100320250529054104010', '1447-08-01', '1.100.10', '101', 'Bayar[ACHMAD ZAFRAN SHINAGA]', '30000', '0', 'Chuwez', '2025-05-29 12:41:04'),
('3890', 'SY10100320250529054104010', '1447-08-01', '4.400.20', '101', 'Bayar[ACHMAD ZAFRAN SHINAGA]', '0', '30000', 'Chuwez', '2025-05-29 12:41:04'),
('3891', 'SY10100320250529054204000', '1446-10-01', '1.100.10', '101', 'Bayar[UBAIDAH]', '30000', '0', 'Chuwez', '2025-05-29 12:42:04'),
('3892', 'SY10100320250529054204000', '1446-10-01', '4.400.20', '101', 'Bayar[UBAIDAH]', '0', '30000', 'Chuwez', '2025-05-29 12:42:04'),
('3893', 'SY10100320250529054204001', '1446-11-01', '1.100.10', '101', 'Bayar[UBAIDAH]', '30000', '0', 'Chuwez', '2025-05-29 12:42:04'),
('3894', 'SY10100320250529054204001', '1446-11-01', '4.400.20', '101', 'Bayar[UBAIDAH]', '0', '30000', 'Chuwez', '2025-05-29 12:42:04'),
('3895', 'SY10100320250529054204002', '1446-12-01', '1.100.10', '101', 'Bayar[UBAIDAH]', '30000', '0', 'Chuwez', '2025-05-29 12:42:04'),
('3896', 'SY10100320250529054204002', '1446-12-01', '4.400.20', '101', 'Bayar[UBAIDAH]', '0', '30000', 'Chuwez', '2025-05-29 12:42:04'),
('3897', 'SY10100320250529054204003', '1447-01-01', '1.100.10', '101', 'Bayar[UBAIDAH]', '30000', '0', 'Chuwez', '2025-05-29 12:42:04'),
('3898', 'SY10100320250529054204003', '1447-01-01', '4.400.20', '101', 'Bayar[UBAIDAH]', '0', '30000', 'Chuwez', '2025-05-29 12:42:04'),
('3899', 'SY10100320250529054204004', '1447-02-01', '1.100.10', '101', 'Bayar[UBAIDAH]', '30000', '0', 'Chuwez', '2025-05-29 12:42:04'),
('3900', 'SY10100320250529054204004', '1447-02-01', '4.400.20', '101', 'Bayar[UBAIDAH]', '0', '30000', 'Chuwez', '2025-05-29 12:42:04'),
('3901', 'SY10100320250529054205005', '1447-03-01', '1.100.10', '101', 'Bayar[UBAIDAH]', '30000', '0', 'Chuwez', '2025-05-29 12:42:05'),
('3902', 'SY10100320250529054205005', '1447-03-01', '4.400.20', '101', 'Bayar[UBAIDAH]', '0', '30000', 'Chuwez', '2025-05-29 12:42:05'),
('3903', 'SY10100320250529054205006', '1447-04-01', '1.100.10', '101', 'Bayar[UBAIDAH]', '30000', '0', 'Chuwez', '2025-05-29 12:42:05'),
('3904', 'SY10100320250529054205006', '1447-04-01', '4.400.20', '101', 'Bayar[UBAIDAH]', '0', '30000', 'Chuwez', '2025-05-29 12:42:05'),
('3905', 'SY10100320250529054205007', '1447-05-01', '1.100.10', '101', 'Bayar[UBAIDAH]', '30000', '0', 'Chuwez', '2025-05-29 12:42:05'),
('3906', 'SY10100320250529054205007', '1447-05-01', '4.400.20', '101', 'Bayar[UBAIDAH]', '0', '30000', 'Chuwez', '2025-05-29 12:42:05'),
('3907', 'SY10100320250529054205008', '1447-06-01', '1.100.10', '101', 'Bayar[UBAIDAH]', '30000', '0', 'Chuwez', '2025-05-29 12:42:05'),
('3908', 'SY10100320250529054205008', '1447-06-01', '4.400.20', '101', 'Bayar[UBAIDAH]', '0', '30000', 'Chuwez', '2025-05-29 12:42:05'),
('3909', 'SY10100320250529054205009', '1447-07-01', '1.100.10', '101', 'Bayar[UBAIDAH]', '30000', '0', 'Chuwez', '2025-05-29 12:42:05'),
('3910', 'SY10100320250529054205009', '1447-07-01', '4.400.20', '101', 'Bayar[UBAIDAH]', '0', '30000', 'Chuwez', '2025-05-29 12:42:05'),
('3911', 'SY10100320250529054205010', '1447-08-01', '1.100.10', '101', 'Bayar[UBAIDAH]', '30000', '0', 'Chuwez', '2025-05-29 12:42:05'),
('3912', 'SY10100320250529054205010', '1447-08-01', '4.400.20', '101', 'Bayar[UBAIDAH]', '0', '30000', 'Chuwez', '2025-05-29 12:42:05'),
('3913', 'SY10100320250529054258000', '1446-10-01', '1.100.10', '101', 'Bayar[AFIKA APRILIA ULKIFAYA]', '30000', '0', 'Chuwez', '2025-05-29 12:42:58'),
('3914', 'SY10100320250529054258000', '1446-10-01', '4.400.20', '101', 'Bayar[AFIKA APRILIA ULKIFAYA]', '0', '30000', 'Chuwez', '2025-05-29 12:42:58'),
('3915', 'SY10100320250529054258001', '1446-11-01', '1.100.10', '101', 'Bayar[AFIKA APRILIA ULKIFAYA]', '30000', '0', 'Chuwez', '2025-05-29 12:42:58'),
('3916', 'SY10100320250529054258001', '1446-11-01', '4.400.20', '101', 'Bayar[AFIKA APRILIA ULKIFAYA]', '0', '30000', 'Chuwez', '2025-05-29 12:42:58'),
('3917', 'SY10100320250529054259002', '1446-12-01', '1.100.10', '101', 'Bayar[AFIKA APRILIA ULKIFAYA]', '30000', '0', 'Chuwez', '2025-05-29 12:42:59'),
('3918', 'SY10100320250529054259002', '1446-12-01', '4.400.20', '101', 'Bayar[AFIKA APRILIA ULKIFAYA]', '0', '30000', 'Chuwez', '2025-05-29 12:42:59'),
('3919', 'SY10100320250529054259003', '1447-01-01', '1.100.10', '101', 'Bayar[AFIKA APRILIA ULKIFAYA]', '30000', '0', 'Chuwez', '2025-05-29 12:42:59'),
('3920', 'SY10100320250529054259003', '1447-01-01', '4.400.20', '101', 'Bayar[AFIKA APRILIA ULKIFAYA]', '0', '30000', 'Chuwez', '2025-05-29 12:42:59'),
('3921', 'SY10100320250529054259004', '1447-02-01', '1.100.10', '101', 'Bayar[AFIKA APRILIA ULKIFAYA]', '30000', '0', 'Chuwez', '2025-05-29 12:42:59'),
('3922', 'SY10100320250529054259004', '1447-02-01', '4.400.20', '101', 'Bayar[AFIKA APRILIA ULKIFAYA]', '0', '30000', 'Chuwez', '2025-05-29 12:42:59'),
('3923', 'SY10100320250529054259005', '1447-03-01', '1.100.10', '101', 'Bayar[AFIKA APRILIA ULKIFAYA]', '30000', '0', 'Chuwez', '2025-05-29 12:42:59'),
('3924', 'SY10100320250529054259005', '1447-03-01', '4.400.20', '101', 'Bayar[AFIKA APRILIA ULKIFAYA]', '0', '30000', 'Chuwez', '2025-05-29 12:42:59'),
('3925', 'SY10100320250529054259006', '1447-04-01', '1.100.10', '101', 'Bayar[AFIKA APRILIA ULKIFAYA]', '30000', '0', 'Chuwez', '2025-05-29 12:42:59'),
('3926', 'SY10100320250529054259006', '1447-04-01', '4.400.20', '101', 'Bayar[AFIKA APRILIA ULKIFAYA]', '0', '30000', 'Chuwez', '2025-05-29 12:42:59'),
('3927', 'SY10100320250529054259007', '1447-05-01', '1.100.10', '101', 'Bayar[AFIKA APRILIA ULKIFAYA]', '30000', '0', 'Chuwez', '2025-05-29 12:42:59'),
('3928', 'SY10100320250529054259007', '1447-05-01', '4.400.20', '101', 'Bayar[AFIKA APRILIA ULKIFAYA]', '0', '30000', 'Chuwez', '2025-05-29 12:42:59'),
('3929', 'SY10100320250529054259008', '1447-06-01', '1.100.10', '101', 'Bayar[AFIKA APRILIA ULKIFAYA]', '30000', '0', 'Chuwez', '2025-05-29 12:42:59'),
('3930', 'SY10100320250529054259008', '1447-06-01', '4.400.20', '101', 'Bayar[AFIKA APRILIA ULKIFAYA]', '0', '30000', 'Chuwez', '2025-05-29 12:42:59'),
('3931', 'SY10100320250529054259009', '1447-07-01', '1.100.10', '101', 'Bayar[AFIKA APRILIA ULKIFAYA]', '30000', '0', 'Chuwez', '2025-05-29 12:42:59'),
('3932', 'SY10100320250529054259009', '1447-07-01', '4.400.20', '101', 'Bayar[AFIKA APRILIA ULKIFAYA]', '0', '30000', 'Chuwez', '2025-05-29 12:42:59'),
('3933', 'SY10100320250529054259010', '1447-08-01', '1.100.10', '101', 'Bayar[AFIKA APRILIA ULKIFAYA]', '30000', '0', 'Chuwez', '2025-05-29 12:42:59'),
('3934', 'SY10100320250529054259010', '1447-08-01', '4.400.20', '101', 'Bayar[AFIKA APRILIA ULKIFAYA]', '0', '30000', 'Chuwez', '2025-05-29 12:42:59'),
('3935', 'SY10100320250529054338000', '1446-10-01', '1.100.10', '101', 'Bayar[UMAR FARUQ]', '30000', '0', 'Chuwez', '2025-05-29 12:43:38'),
('3936', 'SY10100320250529054338000', '1446-10-01', '4.400.20', '101', 'Bayar[UMAR FARUQ]', '0', '30000', 'Chuwez', '2025-05-29 12:43:38'),
('3937', 'SY10100320250529054338001', '1446-11-01', '1.100.10', '101', 'Bayar[UMAR FARUQ]', '30000', '0', 'Chuwez', '2025-05-29 12:43:38'),
('3938', 'SY10100320250529054338001', '1446-11-01', '4.400.20', '101', 'Bayar[UMAR FARUQ]', '0', '30000', 'Chuwez', '2025-05-29 12:43:38'),
('3939', 'SY10100320250529054459000', '1446-10-01', '1.100.10', '101', 'Bayar[AFZAN FAISAL MAULANA]', '30000', '0', 'Chuwez', '2025-05-29 12:44:59'),
('3940', 'SY10100320250529054459000', '1446-10-01', '4.400.20', '101', 'Bayar[AFZAN FAISAL MAULANA]', '0', '30000', 'Chuwez', '2025-05-29 12:44:59'),
('3941', 'SY10100320250529054459001', '1446-11-01', '1.100.10', '101', 'Bayar[AFZAN FAISAL MAULANA]', '30000', '0', 'Chuwez', '2025-05-29 12:44:59'),
('3942', 'SY10100320250529054459001', '1446-11-01', '4.400.20', '101', 'Bayar[AFZAN FAISAL MAULANA]', '0', '30000', 'Chuwez', '2025-05-29 12:44:59'),
('3943', 'SY10100320250529054459002', '1446-12-01', '1.100.10', '101', 'Bayar[AFZAN FAISAL MAULANA]', '30000', '0', 'Chuwez', '2025-05-29 12:44:59'),
('3944', 'SY10100320250529054459002', '1446-12-01', '4.400.20', '101', 'Bayar[AFZAN FAISAL MAULANA]', '0', '30000', 'Chuwez', '2025-05-29 12:44:59'),
('3945', 'SY10100320250529054806000', '1446-10-01', '1.100.10', '101', 'Bayar[M. ALI FIKRI]', '30000', '0', 'Chuwez', '2025-05-29 12:48:06'),
('3946', 'SY10100320250529054806000', '1446-10-01', '4.400.20', '101', 'Bayar[M. ALI FIKRI]', '0', '30000', 'Chuwez', '2025-05-29 12:48:06'),
('3947', 'SY10100320250529054856000', '1446-10-01', '1.100.10', '101', 'Bayar[MUHAMMAD ZAINAL ABIDIN]', '30000', '0', 'Chuwez', '2025-05-29 12:48:56'),
('3948', 'SY10100320250529054856000', '1446-10-01', '4.400.20', '101', 'Bayar[MUHAMMAD ZAINAL ABIDIN]', '0', '30000', 'Chuwez', '2025-05-29 12:48:56'),
('3971', 'SY10100320250529055045000', '1446-10-01', '1.100.10', '101', 'Bayar[KHOIRIYAH]', '30000', '0', 'Chuwez', '2025-05-29 12:50:45'),
('3972', 'SY10100320250529055045000', '1446-10-01', '4.400.20', '101', 'Bayar[KHOIRIYAH]', '0', '30000', 'Chuwez', '2025-05-29 12:50:45'),
('3973', 'SY10100320250529055045001', '1446-11-01', '1.100.10', '101', 'Bayar[KHOIRIYAH]', '30000', '0', 'Chuwez', '2025-05-29 12:50:45'),
('3974', 'SY10100320250529055045001', '1446-11-01', '4.400.20', '101', 'Bayar[KHOIRIYAH]', '0', '30000', 'Chuwez', '2025-05-29 12:50:45'),
('3975', 'SY10100320250529055151000', '1446-10-01', '1.100.10', '101', 'Bayar[ADIBA QONITA]', '30000', '0', 'Chuwez', '2025-05-29 12:51:51'),
('3976', 'SY10100320250529055151000', '1446-10-01', '4.400.20', '101', 'Bayar[ADIBA QONITA]', '0', '30000', 'Chuwez', '2025-05-29 12:51:51'),
('3977', 'SY10100320250529055248000', '1446-10-01', '1.100.10', '101', 'Bayar[MUCHAMAD RAFIE FAWWAZI]', '30000', '0', 'Chuwez', '2025-05-29 12:52:48'),
('3978', 'SY10100320250529055248000', '1446-10-01', '4.400.20', '101', 'Bayar[MUCHAMAD RAFIE FAWWAZI]', '0', '30000', 'Chuwez', '2025-05-29 12:52:48'),
('3979', 'SY10100320250529055338000', '1446-10-01', '1.100.10', '101', 'Bayar[ALFI NURDIANA]', '30000', '0', 'Chuwez', '2025-05-29 12:53:38'),
('3980', 'SY10100320250529055338000', '1446-10-01', '4.400.20', '101', 'Bayar[ALFI NURDIANA]', '0', '30000', 'Chuwez', '2025-05-29 12:53:38'),
('3981', 'SY10100320250529055338001', '1446-11-01', '1.100.10', '101', 'Bayar[ALFI NURDIANA]', '30000', '0', 'Chuwez', '2025-05-29 12:53:38'),
('3982', 'SY10100320250529055338001', '1446-11-01', '4.400.20', '101', 'Bayar[ALFI NURDIANA]', '0', '30000', 'Chuwez', '2025-05-29 12:53:38'),
('3983', 'SY10100320250529055338002', '1446-12-01', '1.100.10', '101', 'Bayar[ALFI NURDIANA]', '30000', '0', 'Chuwez', '2025-05-29 12:53:38'),
('3984', 'SY10100320250529055338002', '1446-12-01', '4.400.20', '101', 'Bayar[ALFI NURDIANA]', '0', '30000', 'Chuwez', '2025-05-29 12:53:38'),
('3985', 'SY10100320250529055338003', '1447-01-01', '1.100.10', '101', 'Bayar[ALFI NURDIANA]', '30000', '0', 'Chuwez', '2025-05-29 12:53:38'),
('3986', 'SY10100320250529055338003', '1447-01-01', '4.400.20', '101', 'Bayar[ALFI NURDIANA]', '0', '30000', 'Chuwez', '2025-05-29 12:53:38'),
('3987', 'SY10100320250529055338004', '1447-02-01', '1.100.10', '101', 'Bayar[ALFI NURDIANA]', '30000', '0', 'Chuwez', '2025-05-29 12:53:38'),
('3988', 'SY10100320250529055338004', '1447-02-01', '4.400.20', '101', 'Bayar[ALFI NURDIANA]', '0', '30000', 'Chuwez', '2025-05-29 12:53:38'),
('3989', 'SY10100320250529055338005', '1447-03-01', '1.100.10', '101', 'Bayar[ALFI NURDIANA]', '30000', '0', 'Chuwez', '2025-05-29 12:53:38'),
('3990', 'SY10100320250529055338005', '1447-03-01', '4.400.20', '101', 'Bayar[ALFI NURDIANA]', '0', '30000', 'Chuwez', '2025-05-29 12:53:38'),
('3991', 'SY10100320250529055339006', '1447-04-01', '1.100.10', '101', 'Bayar[ALFI NURDIANA]', '30000', '0', 'Chuwez', '2025-05-29 12:53:39'),
('3992', 'SY10100320250529055339006', '1447-04-01', '4.400.20', '101', 'Bayar[ALFI NURDIANA]', '0', '30000', 'Chuwez', '2025-05-29 12:53:39'),
('3993', 'SY10100320250529055339007', '1447-05-01', '1.100.10', '101', 'Bayar[ALFI NURDIANA]', '30000', '0', 'Chuwez', '2025-05-29 12:53:39'),
('3994', 'SY10100320250529055339007', '1447-05-01', '4.400.20', '101', 'Bayar[ALFI NURDIANA]', '0', '30000', 'Chuwez', '2025-05-29 12:53:39'),
('3995', 'SY10100320250529055339008', '1447-06-01', '1.100.10', '101', 'Bayar[ALFI NURDIANA]', '30000', '0', 'Chuwez', '2025-05-29 12:53:39'),
('3996', 'SY10100320250529055339008', '1447-06-01', '4.400.20', '101', 'Bayar[ALFI NURDIANA]', '0', '30000', 'Chuwez', '2025-05-29 12:53:39'),
('3997', 'SY10100320250529055339009', '1447-07-01', '1.100.10', '101', 'Bayar[ALFI NURDIANA]', '30000', '0', 'Chuwez', '2025-05-29 12:53:39'),
('3998', 'SY10100320250529055339009', '1447-07-01', '4.400.20', '101', 'Bayar[ALFI NURDIANA]', '0', '30000', 'Chuwez', '2025-05-29 12:53:39'),
('3999', 'SY10100320250529055339010', '1447-08-01', '1.100.10', '101', 'Bayar[ALFI NURDIANA]', '30000', '0', 'Chuwez', '2025-05-29 12:53:39'),
('4000', 'SY10100320250529055339010', '1447-08-01', '4.400.20', '101', 'Bayar[ALFI NURDIANA]', '0', '30000', 'Chuwez', '2025-05-29 12:53:39'),
('4001', 'SY10100320250529055445000', '1446-10-01', '1.100.10', '101', 'Bayar[AKHMAD FIKRI HAIKAL]', '30000', '0', 'Chuwez', '2025-05-29 12:54:45'),
('4002', 'SY10100320250529055445000', '1446-10-01', '4.400.20', '101', 'Bayar[AKHMAD FIKRI HAIKAL]', '0', '30000', 'Chuwez', '2025-05-29 12:54:45'),
('4003', 'SY10100320250529055445001', '1446-11-01', '1.100.10', '101', 'Bayar[AKHMAD FIKRI HAIKAL]', '30000', '0', 'Chuwez', '2025-05-29 12:54:45'),
('4004', 'SY10100320250529055445001', '1446-11-01', '4.400.20', '101', 'Bayar[AKHMAD FIKRI HAIKAL]', '0', '30000', 'Chuwez', '2025-05-29 12:54:45'),
('4005', 'SY10100320250529055445002', '1446-12-01', '1.100.10', '101', 'Bayar[AKHMAD FIKRI HAIKAL]', '30000', '0', 'Chuwez', '2025-05-29 12:54:45'),
('4006', 'SY10100320250529055445002', '1446-12-01', '4.400.20', '101', 'Bayar[AKHMAD FIKRI HAIKAL]', '0', '30000', 'Chuwez', '2025-05-29 12:54:45'),
('4007', 'SY10100320250529055446003', '1447-01-01', '1.100.10', '101', 'Bayar[AKHMAD FIKRI HAIKAL]', '30000', '0', 'Chuwez', '2025-05-29 12:54:46'),
('4008', 'SY10100320250529055446003', '1447-01-01', '4.400.20', '101', 'Bayar[AKHMAD FIKRI HAIKAL]', '0', '30000', 'Chuwez', '2025-05-29 12:54:46'),
('4009', 'SY10100320250529055446004', '1447-02-01', '1.100.10', '101', 'Bayar[AKHMAD FIKRI HAIKAL]', '30000', '0', 'Chuwez', '2025-05-29 12:54:46'),
('4010', 'SY10100320250529055446004', '1447-02-01', '4.400.20', '101', 'Bayar[AKHMAD FIKRI HAIKAL]', '0', '30000', 'Chuwez', '2025-05-29 12:54:46'),
('4011', 'SY10100320250529055446005', '1447-03-01', '1.100.10', '101', 'Bayar[AKHMAD FIKRI HAIKAL]', '30000', '0', 'Chuwez', '2025-05-29 12:54:46'),
('4012', 'SY10100320250529055446005', '1447-03-01', '4.400.20', '101', 'Bayar[AKHMAD FIKRI HAIKAL]', '0', '30000', 'Chuwez', '2025-05-29 12:54:46'),
('4013', 'SY10100320250529055446006', '1447-04-01', '1.100.10', '101', 'Bayar[AKHMAD FIKRI HAIKAL]', '30000', '0', 'Chuwez', '2025-05-29 12:54:46'),
('4014', 'SY10100320250529055446006', '1447-04-01', '4.400.20', '101', 'Bayar[AKHMAD FIKRI HAIKAL]', '0', '30000', 'Chuwez', '2025-05-29 12:54:46'),
('4015', 'SY10100320250529055446007', '1447-05-01', '1.100.10', '101', 'Bayar[AKHMAD FIKRI HAIKAL]', '30000', '0', 'Chuwez', '2025-05-29 12:54:46'),
('4016', 'SY10100320250529055446007', '1447-05-01', '4.400.20', '101', 'Bayar[AKHMAD FIKRI HAIKAL]', '0', '30000', 'Chuwez', '2025-05-29 12:54:46'),
('4017', 'SY10100320250529055446008', '1447-06-01', '1.100.10', '101', 'Bayar[AKHMAD FIKRI HAIKAL]', '30000', '0', 'Chuwez', '2025-05-29 12:54:46'),
('4018', 'SY10100320250529055446008', '1447-06-01', '4.400.20', '101', 'Bayar[AKHMAD FIKRI HAIKAL]', '0', '30000', 'Chuwez', '2025-05-29 12:54:46'),
('4019', 'SY10100320250529055446009', '1447-07-01', '1.100.10', '101', 'Bayar[AKHMAD FIKRI HAIKAL]', '30000', '0', 'Chuwez', '2025-05-29 12:54:46'),
('4020', 'SY10100320250529055446009', '1447-07-01', '4.400.20', '101', 'Bayar[AKHMAD FIKRI HAIKAL]', '0', '30000', 'Chuwez', '2025-05-29 12:54:46'),
('4021', 'SY10100320250529055446010', '1447-08-01', '1.100.10', '101', 'Bayar[AKHMAD FIKRI HAIKAL]', '30000', '0', 'Chuwez', '2025-05-29 12:54:46'),
('4022', 'SY10100320250529055446010', '1447-08-01', '4.400.20', '101', 'Bayar[AKHMAD FIKRI HAIKAL]', '0', '30000', 'Chuwez', '2025-05-29 12:54:46'),
('4023', 'SY10100320250529055534000', '1446-10-01', '1.100.10', '101', 'Bayar[MUHAMMAD NAZHIRUL ASROFI]', '30000', '0', 'Chuwez', '2025-05-29 12:55:34'),
('4024', 'SY10100320250529055534000', '1446-10-01', '4.400.20', '101', 'Bayar[MUHAMMAD NAZHIRUL ASROFI]', '0', '30000', 'Chuwez', '2025-05-29 12:55:34'),
('4025', 'SY10100320250529055646000', '1446-10-01', '1.100.10', '101', 'Bayar[M. WAFA BAHRUN NAJA]', '30000', '0', 'Chuwez', '2025-05-29 12:56:46'),
('4026', 'SY10100320250529055646000', '1446-10-01', '4.400.20', '101', 'Bayar[M. WAFA BAHRUN NAJA]', '0', '30000', 'Chuwez', '2025-05-29 12:56:46'),
('4027', 'SY10100320250529055646001', '1446-11-01', '1.100.10', '101', 'Bayar[M. WAFA BAHRUN NAJA]', '30000', '0', 'Chuwez', '2025-05-29 12:56:46'),
('4028', 'SY10100320250529055646001', '1446-11-01', '4.400.20', '101', 'Bayar[M. WAFA BAHRUN NAJA]', '0', '30000', 'Chuwez', '2025-05-29 12:56:46'),
('4029', 'SY10100320250529055646002', '1446-12-01', '1.100.10', '101', 'Bayar[M. WAFA BAHRUN NAJA]', '30000', '0', 'Chuwez', '2025-05-29 12:56:46'),
('4030', 'SY10100320250529055646002', '1446-12-01', '4.400.20', '101', 'Bayar[M. WAFA BAHRUN NAJA]', '0', '30000', 'Chuwez', '2025-05-29 12:56:46'),
('4031', 'SY10100320250529055646003', '1447-01-01', '1.100.10', '101', 'Bayar[M. WAFA BAHRUN NAJA]', '30000', '0', 'Chuwez', '2025-05-29 12:56:46'),
('4032', 'SY10100320250529055646003', '1447-01-01', '4.400.20', '101', 'Bayar[M. WAFA BAHRUN NAJA]', '0', '30000', 'Chuwez', '2025-05-29 12:56:46'),
('4033', 'SY10100320250529055646004', '1447-02-01', '1.100.10', '101', 'Bayar[M. WAFA BAHRUN NAJA]', '30000', '0', 'Chuwez', '2025-05-29 12:56:46'),
('4034', 'SY10100320250529055646004', '1447-02-01', '4.400.20', '101', 'Bayar[M. WAFA BAHRUN NAJA]', '0', '30000', 'Chuwez', '2025-05-29 12:56:46'),
('4035', 'SY10100320250529055740000', '1446-10-01', '1.100.10', '101', 'Bayar[SITI ATHIUR ROHMAH]', '30000', '0', 'Chuwez', '2025-05-29 12:57:40'),
('4036', 'SY10100320250529055740000', '1446-10-01', '4.400.20', '101', 'Bayar[SITI ATHIUR ROHMAH]', '0', '30000', 'Chuwez', '2025-05-29 12:57:40'),
('4037', 'SY10100320250529055741001', '1446-11-01', '1.100.10', '101', 'Bayar[SITI ATHIUR ROHMAH]', '30000', '0', 'Chuwez', '2025-05-29 12:57:41'),
('4038', 'SY10100320250529055741001', '1446-11-01', '4.400.20', '101', 'Bayar[SITI ATHIUR ROHMAH]', '0', '30000', 'Chuwez', '2025-05-29 12:57:41'),
('4039', 'SY10100320250529055835000', '1446-10-01', '1.100.10', '101', 'Bayar[SITI KARIMATIN NISAK]', '30000', '0', 'Chuwez', '2025-05-29 12:58:35'),
('4040', 'SY10100320250529055835000', '1446-10-01', '4.400.20', '101', 'Bayar[SITI KARIMATIN NISAK]', '0', '30000', 'Chuwez', '2025-05-29 12:58:35'),
('4041', 'SY10100320250529055946000', '1446-10-01', '1.100.10', '101', 'Bayar[MILLAH KAMILAH]', '30000', '0', 'Chuwez', '2025-05-29 12:59:46'),
('4042', 'SY10100320250529055946000', '1446-10-01', '4.400.20', '101', 'Bayar[MILLAH KAMILAH]', '0', '30000', 'Chuwez', '2025-05-29 12:59:46'),
('4043', 'SY10100320250529055947001', '1446-11-01', '1.100.10', '101', 'Bayar[MILLAH KAMILAH]', '30000', '0', 'Chuwez', '2025-05-29 12:59:47'),
('4044', 'SY10100320250529055947001', '1446-11-01', '4.400.20', '101', 'Bayar[MILLAH KAMILAH]', '0', '30000', 'Chuwez', '2025-05-29 12:59:47'),
('4045', 'SY10100320250529055947002', '1446-12-01', '1.100.10', '101', 'Bayar[MILLAH KAMILAH]', '30000', '0', 'Chuwez', '2025-05-29 12:59:47'),
('4046', 'SY10100320250529055947002', '1446-12-01', '4.400.20', '101', 'Bayar[MILLAH KAMILAH]', '0', '30000', 'Chuwez', '2025-05-29 12:59:47'),
('4047', 'SY10100320250529055947003', '1447-01-01', '1.100.10', '101', 'Bayar[MILLAH KAMILAH]', '30000', '0', 'Chuwez', '2025-05-29 12:59:47'),
('4048', 'SY10100320250529055947003', '1447-01-01', '4.400.20', '101', 'Bayar[MILLAH KAMILAH]', '0', '30000', 'Chuwez', '2025-05-29 12:59:47'),
('4049', 'SY10100320250529055947004', '1447-02-01', '1.100.10', '101', 'Bayar[MILLAH KAMILAH]', '30000', '0', 'Chuwez', '2025-05-29 12:59:47'),
('4050', 'SY10100320250529055947004', '1447-02-01', '4.400.20', '101', 'Bayar[MILLAH KAMILAH]', '0', '30000', 'Chuwez', '2025-05-29 12:59:47'),
('4051', 'SY10100320250529055947005', '1447-03-01', '1.100.10', '101', 'Bayar[MILLAH KAMILAH]', '30000', '0', 'Chuwez', '2025-05-29 12:59:47'),
('4052', 'SY10100320250529055947005', '1447-03-01', '4.400.20', '101', 'Bayar[MILLAH KAMILAH]', '0', '30000', 'Chuwez', '2025-05-29 12:59:47'),
('4053', 'SY10100320250529055947006', '1447-04-01', '1.100.10', '101', 'Bayar[MILLAH KAMILAH]', '30000', '0', 'Chuwez', '2025-05-29 12:59:47'),
('4054', 'SY10100320250529055947006', '1447-04-01', '4.400.20', '101', 'Bayar[MILLAH KAMILAH]', '0', '30000', 'Chuwez', '2025-05-29 12:59:47'),
('4055', 'SY10100320250529055947007', '1447-05-01', '1.100.10', '101', 'Bayar[MILLAH KAMILAH]', '30000', '0', 'Chuwez', '2025-05-29 12:59:47'),
('4056', 'SY10100320250529055947007', '1447-05-01', '4.400.20', '101', 'Bayar[MILLAH KAMILAH]', '0', '30000', 'Chuwez', '2025-05-29 12:59:47'),
('4057', 'SY10100320250529055947008', '1447-06-01', '1.100.10', '101', 'Bayar[MILLAH KAMILAH]', '30000', '0', 'Chuwez', '2025-05-29 12:59:47'),
('4058', 'SY10100320250529055947008', '1447-06-01', '4.400.20', '101', 'Bayar[MILLAH KAMILAH]', '0', '30000', 'Chuwez', '2025-05-29 12:59:47'),
('4059', 'SY10100320250529055947009', '1447-07-01', '1.100.10', '101', 'Bayar[MILLAH KAMILAH]', '30000', '0', 'Chuwez', '2025-05-29 12:59:47'),
('4060', 'SY10100320250529055947009', '1447-07-01', '4.400.20', '101', 'Bayar[MILLAH KAMILAH]', '0', '30000', 'Chuwez', '2025-05-29 12:59:47'),
('4061', 'SY10100320250529055947010', '1447-08-01', '1.100.10', '101', 'Bayar[MILLAH KAMILAH]', '30000', '0', 'Chuwez', '2025-05-29 12:59:47'),
('4062', 'SY10100320250529055947010', '1447-08-01', '4.400.20', '101', 'Bayar[MILLAH KAMILAH]', '0', '30000', 'Chuwez', '2025-05-29 12:59:47'),
('4063', 'SY10100320250529060217000', '1446-10-01', '1.100.10', '101', 'Bayar[ROHMATULLOH]', '30000', '0', 'Chuwez', '2025-05-29 13:02:17'),
('4064', 'SY10100320250529060217000', '1446-10-01', '4.400.20', '101', 'Bayar[ROHMATULLOH]', '0', '30000', 'Chuwez', '2025-05-29 13:02:17'),
('4065', 'SY10100320250529060217001', '1446-11-01', '1.100.10', '101', 'Bayar[ROHMATULLOH]', '30000', '0', 'Chuwez', '2025-05-29 13:02:17'),
('4066', 'SY10100320250529060217001', '1446-11-01', '4.400.20', '101', 'Bayar[ROHMATULLOH]', '0', '30000', 'Chuwez', '2025-05-29 13:02:17'),
('4067', 'SY10100320250529060256000', '1446-10-01', '1.100.10', '101', 'Bayar[AZKA AUFARIL MINAN]', '30000', '0', 'Chuwez', '2025-05-29 13:02:56'),
('4068', 'SY10100320250529060256000', '1446-10-01', '4.400.20', '101', 'Bayar[AZKA AUFARIL MINAN]', '0', '30000', 'Chuwez', '2025-05-29 13:02:56'),
('4069', 'SY10100320250529060332000', '1446-10-01', '1.100.10', '101', 'Bayar[MASRUROTUL MAULUDIYAH]', '30000', '0', 'Chuwez', '2025-05-29 13:03:32'),
('4070', 'SY10100320250529060332000', '1446-10-01', '4.400.20', '101', 'Bayar[MASRUROTUL MAULUDIYAH]', '0', '30000', 'Chuwez', '2025-05-29 13:03:32'),
('4071', 'SY10100320250529060332001', '1446-11-01', '1.100.10', '101', 'Bayar[MASRUROTUL MAULUDIYAH]', '30000', '0', 'Chuwez', '2025-05-29 13:03:32'),
('4072', 'SY10100320250529060332001', '1446-11-01', '4.400.20', '101', 'Bayar[MASRUROTUL MAULUDIYAH]', '0', '30000', 'Chuwez', '2025-05-29 13:03:32'),
('4073', 'SY10100320250529060436000', '1446-10-01', '1.100.10', '101', 'Bayar[NAILATUN NIAMI]', '30000', '0', 'Chuwez', '2025-05-29 13:04:36'),
('4074', 'SY10100320250529060436000', '1446-10-01', '4.400.20', '101', 'Bayar[NAILATUN NIAMI]', '0', '30000', 'Chuwez', '2025-05-29 13:04:36'),
('4075', 'SY10100320250529060436001', '1446-11-01', '1.100.10', '101', 'Bayar[NAILATUN NIAMI]', '30000', '0', 'Chuwez', '2025-05-29 13:04:36'),
('4076', 'SY10100320250529060436001', '1446-11-01', '4.400.20', '101', 'Bayar[NAILATUN NIAMI]', '0', '30000', 'Chuwez', '2025-05-29 13:04:36'),
('4077', 'SY10100320250529060436002', '1446-12-01', '1.100.10', '101', 'Bayar[NAILATUN NIAMI]', '30000', '0', 'Chuwez', '2025-05-29 13:04:36'),
('4078', 'SY10100320250529060436002', '1446-12-01', '4.400.20', '101', 'Bayar[NAILATUN NIAMI]', '0', '30000', 'Chuwez', '2025-05-29 13:04:36'),
('4079', 'SY10100320250529060436003', '1447-01-01', '1.100.10', '101', 'Bayar[NAILATUN NIAMI]', '30000', '0', 'Chuwez', '2025-05-29 13:04:36'),
('4080', 'SY10100320250529060436003', '1447-01-01', '4.400.20', '101', 'Bayar[NAILATUN NIAMI]', '0', '30000', 'Chuwez', '2025-05-29 13:04:36'),
('4081', 'SY10100320250529060436004', '1447-02-01', '1.100.10', '101', 'Bayar[NAILATUN NIAMI]', '30000', '0', 'Chuwez', '2025-05-29 13:04:36'),
('4082', 'SY10100320250529060436004', '1447-02-01', '4.400.20', '101', 'Bayar[NAILATUN NIAMI]', '0', '30000', 'Chuwez', '2025-05-29 13:04:36'),
('4083', 'SY10100320250529060436005', '1447-03-01', '1.100.10', '101', 'Bayar[NAILATUN NIAMI]', '30000', '0', 'Chuwez', '2025-05-29 13:04:36'),
('4084', 'SY10100320250529060436005', '1447-03-01', '4.400.20', '101', 'Bayar[NAILATUN NIAMI]', '0', '30000', 'Chuwez', '2025-05-29 13:04:36'),
('4085', 'SY10100320250529060525000', '1446-10-01', '1.100.10', '101', 'Bayar[IFTITAHUL IZZA]', '30000', '0', 'Chuwez', '2025-05-29 13:05:25'),
('4086', 'SY10100320250529060525000', '1446-10-01', '4.400.20', '101', 'Bayar[IFTITAHUL IZZA]', '0', '30000', 'Chuwez', '2025-05-29 13:05:25'),
('4087', 'SY10100320250529060608000', '1446-10-01', '1.100.10', '101', 'Bayar[RAUDHOTUL JANNAH]', '30000', '0', 'Chuwez', '2025-05-29 13:06:08'),
('4088', 'SY10100320250529060608000', '1446-10-01', '4.400.20', '101', 'Bayar[RAUDHOTUL JANNAH]', '0', '30000', 'Chuwez', '2025-05-29 13:06:08'),
('4089', 'SY10100320250529060608001', '1446-11-01', '1.100.10', '101', 'Bayar[RAUDHOTUL JANNAH]', '30000', '0', 'Chuwez', '2025-05-29 13:06:08'),
('4090', 'SY10100320250529060608001', '1446-11-01', '4.400.20', '101', 'Bayar[RAUDHOTUL JANNAH]', '0', '30000', 'Chuwez', '2025-05-29 13:06:08'),
('4091', 'SY10100320250529060608002', '1446-12-01', '1.100.10', '101', 'Bayar[RAUDHOTUL JANNAH]', '30000', '0', 'Chuwez', '2025-05-29 13:06:08'),
('4092', 'SY10100320250529060608002', '1446-12-01', '4.400.20', '101', 'Bayar[RAUDHOTUL JANNAH]', '0', '30000', 'Chuwez', '2025-05-29 13:06:08'),
('4093', 'SY10100320250529060608003', '1447-01-01', '1.100.10', '101', 'Bayar[RAUDHOTUL JANNAH]', '30000', '0', 'Chuwez', '2025-05-29 13:06:08'),
('4094', 'SY10100320250529060608003', '1447-01-01', '4.400.20', '101', 'Bayar[RAUDHOTUL JANNAH]', '0', '30000', 'Chuwez', '2025-05-29 13:06:08'),
('4095', 'ST10100320250529081411', '1446-12-01', '1.100.10', '101', 'an.HAIKAL SHOMADANI', '2000', '0', 'Chuwez', '2025-05-29 22:14:11'),
('4096', 'ST10100320250529081411', '1446-12-01', '2.220.10', '101', 'an.HAIKAL SHOMADANI', '0', '2000', 'Chuwez', '2025-05-29 22:14:11'),
('4097', 'ST10100320250529081424', '1446-12-01', '1.100.10', '101', 'an.AULIA AZZAHRA', '5000', '0', 'Chuwez', '2025-05-29 22:14:24'),
('4098', 'ST10100320250529081424', '1446-12-01', '2.220.10', '101', 'an.AULIA AZZAHRA', '0', '5000', 'Chuwez', '2025-05-29 22:14:24'),
('4099', 'ST10100320250529081438', '1446-12-01', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '5000', '0', 'Chuwez', '2025-05-29 22:14:38'),
('4100', 'ST10100320250529081438', '1446-12-01', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '5000', 'Chuwez', '2025-05-29 22:14:38'),
('4101', 'ST10100320250529081511', '1446-12-01', '1.100.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '10000', '0', 'Chuwez', '2025-05-29 22:15:11'),
('4102', 'ST10100320250529081511', '1446-12-01', '2.220.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '0', '10000', 'Chuwez', '2025-05-29 22:15:11'),
('4103', 'ST10100320250529081532', '1446-12-01', '1.100.10', '101', 'an.NAURA BILADINA', '7000', '0', 'Chuwez', '2025-05-29 22:15:32'),
('4104', 'ST10100320250529081532', '1446-12-01', '2.220.10', '101', 'an.NAURA BILADINA', '0', '7000', 'Chuwez', '2025-05-29 22:15:32'),
('4105', 'ST10100320250529081545', '1446-12-01', '1.100.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '5000', '0', 'Chuwez', '2025-05-29 22:15:45'),
('4106', 'ST10100320250529081545', '1446-12-01', '2.220.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '0', '5000', 'Chuwez', '2025-05-29 22:15:45'),
('4107', 'ST10100320250529081604', '1446-12-01', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'Chuwez', '2025-05-29 22:16:04'),
('4108', 'ST10100320250529081604', '1446-12-01', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'Chuwez', '2025-05-29 22:16:04'),
('4109', 'ST10100320250529081617', '1446-12-01', '1.100.10', '101', 'an.M. ABD. HADI', '2000', '0', 'Chuwez', '2025-05-29 22:16:17'),
('4110', 'ST10100320250529081617', '1446-12-01', '2.220.10', '101', 'an.M. ABD. HADI', '0', '2000', 'Chuwez', '2025-05-29 22:16:17'),
('4111', 'ST10100320250529081639', '1446-12-01', '1.100.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '4000', '0', 'Chuwez', '2025-05-29 22:16:39'),
('4112', 'ST10100320250529081639', '1446-12-01', '2.220.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '0', '4000', 'Chuwez', '2025-05-29 22:16:39'),
('4113', 'ST10100320250529081656', '1446-12-01', '1.100.10', '101', 'an.NAILATUN NIAMI', '5000', '0', 'Chuwez', '2025-05-29 22:16:56'),
('4114', 'ST10100320250529081656', '1446-12-01', '2.220.10', '101', 'an.NAILATUN NIAMI', '0', '5000', 'Chuwez', '2025-05-29 22:16:56'),
('4115', 'ST10100320250529081711', '1446-12-01', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'Chuwez', '2025-05-29 22:17:11'),
('4116', 'ST10100320250529081711', '1446-12-01', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'Chuwez', '2025-05-29 22:17:12'),
('4117', 'ST10100320250529081725', '1446-12-01', '1.100.10', '101', 'an.RAISA ANNISA', '5000', '0', 'Chuwez', '2025-05-29 22:17:25'),
('4118', 'ST10100320250529081725', '1446-12-01', '2.220.10', '101', 'an.RAISA ANNISA', '0', '5000', 'Chuwez', '2025-05-29 22:17:25'),
('4119', 'ST10100320250529081739', '1446-12-01', '1.100.10', '101', 'an.FAIZAH NURUL LITA', '5000', '0', 'Chuwez', '2025-05-29 22:17:39'),
('4120', 'ST10100320250529081739', '1446-12-01', '2.220.10', '101', 'an.FAIZAH NURUL LITA', '0', '5000', 'Chuwez', '2025-05-29 22:17:39'),
('4121', 'ST10100320250529081752', '1446-12-01', '1.100.10', '101', 'an.SAUQY AHMAD', '5000', '0', 'Chuwez', '2025-05-29 22:17:52'),
('4122', 'ST10100320250529081752', '1446-12-01', '2.220.10', '101', 'an.SAUQY AHMAD', '0', '5000', 'Chuwez', '2025-05-29 22:17:53'),
('4123', 'ST10100320250529081807', '1446-12-01', '1.100.10', '101', 'an.UMAR FARUQ', '5000', '0', 'Chuwez', '2025-05-29 22:18:07'),
('4124', 'ST10100320250529081807', '1446-12-01', '2.220.10', '101', 'an.UMAR FARUQ', '0', '5000', 'Chuwez', '2025-05-29 22:18:07'),
('4125', 'ST10100320250529081832', '1446-12-01', '1.100.10', '101', 'an.UBAIDAH', '20000', '0', 'Chuwez', '2025-05-29 22:18:32'),
('4126', 'ST10100320250529081832', '1446-12-01', '2.220.10', '101', 'an.UBAIDAH', '0', '20000', 'Chuwez', '2025-05-29 22:18:32'),
('4127', 'ST10100320250529081848', '1446-12-01', '1.100.10', '101', 'an.M. ABDIL ARIKIN', '4000', '0', 'Chuwez', '2025-05-29 22:18:48'),
('4128', 'ST10100320250529081848', '1446-12-01', '2.220.10', '101', 'an.M. ABDIL ARIKIN', '0', '4000', 'Chuwez', '2025-05-29 22:18:48'),
('4129', 'ST10100320250529081904', '1446-12-01', '1.100.10', '101', 'an.MUHAMMAD ALWI', '5000', '0', 'Chuwez', '2025-05-29 22:19:04'),
('4130', 'ST10100320250529081904', '1446-12-01', '2.220.10', '101', 'an.MUHAMMAD ALWI', '0', '5000', 'Chuwez', '2025-05-29 22:19:04'),
('4131', 'ST10100320250529081917', '1446-12-01', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '5000', '0', 'Chuwez', '2025-05-29 22:19:17'),
('4132', 'ST10100320250529081917', '1446-12-01', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '5000', 'Chuwez', '2025-05-29 22:19:17'),
('4133', 'ST10100320250529081929', '1446-12-01', '1.100.10', '101', 'an.MARIATUL QIBTIYAH', '2000', '0', 'Chuwez', '2025-05-29 22:19:29'),
('4134', 'ST10100320250529081929', '1446-12-01', '2.220.10', '101', 'an.MARIATUL QIBTIYAH', '0', '2000', 'Chuwez', '2025-05-29 22:19:29'),
('4135', 'ST10100320250529081943', '1446-12-01', '1.100.10', '101', 'an.MARIYATUL QIBTIYAH', '5000', '0', 'Chuwez', '2025-05-29 22:19:43'),
('4136', 'ST10100320250529081943', '1446-12-01', '2.220.10', '101', 'an.MARIYATUL QIBTIYAH', '0', '5000', 'Chuwez', '2025-05-29 22:19:43'),
('4137', 'ST10100320250529081956', '1446-12-01', '1.100.10', '101', 'an.MUHAMMAD ARDIANSYAH', '10000', '0', 'Chuwez', '2025-05-29 22:19:56'),
('4138', 'ST10100320250529081956', '1446-12-01', '2.220.10', '101', 'an.MUHAMMAD ARDIANSYAH', '0', '10000', 'Chuwez', '2025-05-29 22:19:56'),
('4139', 'ST10100320250529082014', '1446-12-01', '1.100.10', '101', 'an.HILYA', '20000', '0', 'Chuwez', '2025-05-29 22:20:14'),
('4140', 'ST10100320250529082014', '1446-12-01', '2.220.10', '101', 'an.HILYA', '0', '20000', 'Chuwez', '2025-05-29 22:20:14'),
('4141', 'ST10100320250529082135', '1446-12-01', '1.100.10', '101', 'an.AISYAH', '5000', '0', 'Chuwez', '2025-05-29 22:21:35'),
('4142', 'ST10100320250529082135', '1446-12-01', '2.220.10', '101', 'an.AISYAH', '0', '5000', 'Chuwez', '2025-05-29 22:21:35'),
('4143', 'ST10100320250529082148', '1446-12-01', '1.100.10', '101', 'an.DIANA RIFQOTUL QOLBI', '5000', '0', 'Chuwez', '2025-05-29 22:21:48'),
('4144', 'ST10100320250529082148', '1446-12-01', '2.220.10', '101', 'an.DIANA RIFQOTUL QOLBI', '0', '5000', 'Chuwez', '2025-05-29 22:21:48'),
('4145', 'ST10100320250529082159', '1446-12-01', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '10000', '0', 'Chuwez', '2025-05-29 22:21:59'),
('4146', 'ST10100320250529082159', '1446-12-01', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '10000', 'Chuwez', '2025-05-29 22:21:59'),
('4147', 'ST10100320250529082216', '1446-12-01', '1.100.10', '101', 'an.LAILATUL MAGHFIROH', '5000', '0', 'Chuwez', '2025-05-29 22:22:16'),
('4148', 'ST10100320250529082216', '1446-12-01', '2.220.10', '101', 'an.LAILATUL MAGHFIROH', '0', '5000', 'Chuwez', '2025-05-29 22:22:16'),
('4149', 'ST10100320250529082228', '1446-12-01', '1.100.10', '101', 'an.AZKA AUFARIL MINAN', '10000', '0', 'Chuwez', '2025-05-29 22:22:28'),
('4150', 'ST10100320250529082228', '1446-12-01', '2.220.10', '101', 'an.AZKA AUFARIL MINAN', '0', '10000', 'Chuwez', '2025-05-29 22:22:28'),
('4151', 'ST10100320250529082246', '1446-12-01', '1.100.10', '101', 'an.ALFI NURDIANA', '5000', '0', 'Chuwez', '2025-05-29 22:22:46'),
('4152', 'ST10100320250529082246', '1446-12-01', '2.220.10', '101', 'an.ALFI NURDIANA', '0', '5000', 'Chuwez', '2025-05-29 22:22:46'),
('4153', 'ST10100320250529082258', '1446-12-01', '1.100.10', '101', 'an.AHMAD ADITIYA', '2000', '0', 'Chuwez', '2025-05-29 22:22:58'),
('4154', 'ST10100320250529082258', '1446-12-01', '2.220.10', '101', 'an.AHMAD ADITIYA', '0', '2000', 'Chuwez', '2025-05-29 22:22:59'),
('4155', 'ST10100320250529082438', '1446-12-01', '1.100.10', '101', 'an.WARDATUL JANNAH', '2000', '0', 'Chuwez', '2025-05-29 22:24:38'),
('4156', 'ST10100320250529082438', '1446-12-01', '2.220.10', '101', 'an.WARDATUL JANNAH', '0', '2000', 'Chuwez', '2025-05-29 22:24:38'),
('4157', 'ST10100320250529082456', '1446-12-01', '1.100.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '10000', '0', 'Chuwez', '2025-05-29 22:24:56'),
('4158', 'ST10100320250529082456', '1446-12-01', '2.220.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '0', '10000', 'Chuwez', '2025-05-29 22:24:57'),
('4159', 'ST10100320250529082515', '1446-12-01', '1.100.10', '101', 'an.M. FAHMI NURUL ANAM', '10000', '0', 'Chuwez', '2025-05-29 22:25:15'),
('4160', 'ST10100320250529082515', '1446-12-01', '2.220.10', '101', 'an.M. FAHMI NURUL ANAM', '0', '10000', 'Chuwez', '2025-05-29 22:25:15'),
('4161', 'ST10100320250529082532', '1446-12-01', '1.100.10', '101', 'an.ABDUL HAMID', '4000', '0', 'Chuwez', '2025-05-29 22:25:32'),
('4162', 'ST10100320250529082532', '1446-12-01', '2.220.10', '101', 'an.ABDUL HAMID', '0', '4000', 'Chuwez', '2025-05-29 22:25:32'),
('4163', 'ST10100320250529082546', '1446-12-01', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '10000', '0', 'Chuwez', '2025-05-29 22:25:46'),
('4164', 'ST10100320250529082546', '1446-12-01', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '10000', 'Chuwez', '2025-05-29 22:25:46'),
('4165', 'ST10100320250529082605', '1446-12-01', '1.100.10', '101', 'an.DIYANAH KAMALIYAH', '5000', '0', 'Chuwez', '2025-05-29 22:26:05'),
('4166', 'ST10100320250529082605', '1446-12-01', '2.220.10', '101', 'an.DIYANAH KAMALIYAH', '0', '5000', 'Chuwez', '2025-05-29 22:26:05'),
('4167', 'ST10100320250529082618', '1446-12-01', '1.100.10', '101', 'an.SITI QURROTUL AINI', '2000', '0', 'Chuwez', '2025-05-29 22:26:18'),
('4168', 'ST10100320250529082618', '1446-12-01', '2.220.10', '101', 'an.SITI QURROTUL AINI', '0', '2000', 'Chuwez', '2025-05-29 22:26:18'),
('4169', 'ST10100320250529082644', '1446-12-01', '1.100.10', '101', 'an.MUHAMMAD ILHAM', '5000', '0', 'Chuwez', '2025-05-29 22:26:44'),
('4170', 'ST10100320250529082644', '1446-12-01', '2.220.10', '101', 'an.MUHAMMAD ILHAM', '0', '5000', 'Chuwez', '2025-05-29 22:26:44'),
('4171', 'ST10100320250529082657', '1446-12-01', '1.100.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '15000', '0', 'Chuwez', '2025-05-29 22:26:57'),
('4172', 'ST10100320250529082657', '1446-12-01', '2.220.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '0', '15000', 'Chuwez', '2025-05-29 22:26:57'),
('4173', 'ST10100320250529082716', '1446-12-01', '1.100.10', '101', 'an.MIFTAHUL JANNAH', '50000', '0', 'Chuwez', '2025-05-29 22:27:16'),
('4174', 'ST10100320250529082716', '1446-12-01', '2.220.10', '101', 'an.MIFTAHUL JANNAH', '0', '50000', 'Chuwez', '2025-05-29 22:27:16'),
('4175', 'ST10100320250529082730', '1446-12-01', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '10000', '0', 'Chuwez', '2025-05-29 22:27:30'),
('4176', 'ST10100320250529082730', '1446-12-01', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '10000', 'Chuwez', '2025-05-29 22:27:30'),
('4177', 'ST10100320250529082748', '1446-12-01', '1.100.10', '101', 'an.M. KAMALUDDIN', '20000', '0', 'Chuwez', '2025-05-29 22:27:48'),
('4178', 'ST10100320250529082748', '1446-12-01', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '20000', 'Chuwez', '2025-05-29 22:27:48'),
('4179', 'ST10100320250529082804', '1446-12-01', '1.100.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '20000', '0', 'Chuwez', '2025-05-29 22:28:04'),
('4180', 'ST10100320250529082804', '1446-12-01', '2.220.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '0', '20000', 'Chuwez', '2025-05-29 22:28:04'),
('4181', 'ST10100320250529082822', '1446-12-01', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '5000', '0', 'Chuwez', '2025-05-29 22:28:22'),
('4182', 'ST10100320250529082822', '1446-12-01', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '5000', 'Chuwez', '2025-05-29 22:28:22'),
('4183', 'ST10100320250529082837', '1446-12-01', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Chuwez', '2025-05-29 22:28:37'),
('4184', 'ST10100320250529082837', '1446-12-01', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Chuwez', '2025-05-29 22:28:37'),
('4185', 'ST10100320250529082854', '1446-12-01', '1.100.10', '101', 'an.NABILATUN NISAUL UMMAH', '20000', '0', 'Chuwez', '2025-05-29 22:28:54'),
('4186', 'ST10100320250529082854', '1446-12-01', '2.220.10', '101', 'an.NABILATUN NISAUL UMMAH', '0', '20000', 'Chuwez', '2025-05-29 22:28:54'),
('4187', 'ST10100320250529082905', '1446-12-01', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '3000', '0', 'Chuwez', '2025-05-29 22:29:05'),
('4188', 'ST10100320250529082905', '1446-12-01', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '3000', 'Chuwez', '2025-05-29 22:29:05'),
('4189', 'ST10100320250529082918', '1446-12-01', '1.100.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '10000', '0', 'Chuwez', '2025-05-29 22:29:18'),
('4190', 'ST10100320250529082918', '1446-12-01', '2.220.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '0', '10000', 'Chuwez', '2025-05-29 22:29:18'),
('4191', 'ST10100320250529082931', '1446-12-01', '1.100.10', '101', 'an.MOCH KHOTIBUL UMAM', '50000', '0', 'Chuwez', '2025-05-29 22:29:31'),
('4192', 'ST10100320250529082931', '1446-12-01', '2.220.10', '101', 'an.MOCH KHOTIBUL UMAM', '0', '50000', 'Chuwez', '2025-05-29 22:29:31'),
('4193', 'ST10100320250529083148', '1446-12-01', '1.100.10', '101', 'an.BILQIS THALIA HASNA', '60000', '0', 'Chuwez', '2025-05-29 22:31:48'),
('4194', 'ST10100320250529083148', '1446-12-01', '2.220.10', '101', 'an.BILQIS THALIA HASNA', '0', '60000', 'Chuwez', '2025-05-29 22:31:48'),
('4195', 'ST10100320250529083218', '1446-12-01', '1.100.10', '101', 'an.AKHMAD FIKRI HAIKAL', '50000', '0', 'Chuwez', '2025-05-29 22:32:18'),
('4196', 'ST10100320250529083218', '1446-12-01', '2.220.10', '101', 'an.AKHMAD FIKRI HAIKAL', '0', '50000', 'Chuwez', '2025-05-29 22:32:18'),
('4197', 'ST10100320250529083229', '1446-12-01', '1.100.10', '101', 'an.M. HAIKAL NASRULLOH', '5000', '0', 'Chuwez', '2025-05-29 22:32:29'),
('4198', 'ST10100320250529083229', '1446-12-01', '2.220.10', '101', 'an.M. HAIKAL NASRULLOH', '0', '5000', 'Chuwez', '2025-05-29 22:32:29'),
('4199', 'ST10100320250529083244', '1446-12-01', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '25000', '0', 'Chuwez', '2025-05-29 22:32:44'),
('4200', 'ST10100320250529083244', '1446-12-01', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '25000', 'Chuwez', '2025-05-29 22:32:44'),
('4201', 'ST10100320250529083302', '1446-12-01', '1.100.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '20000', '0', 'Chuwez', '2025-05-29 22:33:02'),
('4202', 'ST10100320250529083302', '1446-12-01', '2.220.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '0', '20000', 'Chuwez', '2025-05-29 22:33:02'),
('4203', 'ST10100320250529083323', '1446-12-01', '1.100.10', '101', 'an.SINDI RAISA PUTRI', '10000', '0', 'Chuwez', '2025-05-29 22:33:23'),
('4204', 'ST10100320250529083323', '1446-12-01', '2.220.10', '101', 'an.SINDI RAISA PUTRI', '0', '10000', 'Chuwez', '2025-05-29 22:33:23'),
('4205', 'ST10100320250529083341', '1446-12-01', '1.100.10', '101', 'an.MUHAMMAD HAMDANI', '10000', '0', 'Chuwez', '2025-05-29 22:33:41'),
('4206', 'ST10100320250529083341', '1446-12-01', '2.220.10', '101', 'an.MUHAMMAD HAMDANI', '0', '10000', 'Chuwez', '2025-05-29 22:33:41'),
('4207', 'ST10100320250529083356', '1446-12-01', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '5000', '0', 'Chuwez', '2025-05-29 22:33:56'),
('4208', 'ST10100320250529083356', '1446-12-01', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '5000', 'Chuwez', '2025-05-29 22:33:56'),
('4209', 'ST10100320250529083412', '1446-12-01', '1.100.10', '101', 'an.ZAKIYATUL UMMAH', '2000', '0', 'Chuwez', '2025-05-29 22:34:12'),
('4210', 'ST10100320250529083412', '1446-12-01', '2.220.10', '101', 'an.ZAKIYATUL UMMAH', '0', '2000', 'Chuwez', '2025-05-29 22:34:12'),
('4211', 'ST10100320250529083426', '1446-12-01', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '5000', '0', 'Chuwez', '2025-05-29 22:34:26'),
('4212', 'ST10100320250529083426', '1446-12-01', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '5000', 'Chuwez', '2025-05-29 22:34:26'),
('4213', 'ST10100320250529083439', '1446-12-01', '1.100.10', '101', 'an.AFANDI', '2000', '0', 'Chuwez', '2025-05-29 22:34:39'),
('4214', 'ST10100320250529083439', '1446-12-01', '2.220.10', '101', 'an.AFANDI', '0', '2000', 'Chuwez', '2025-05-29 22:34:39'),
('4215', 'ST10100320250529083456', '1446-12-01', '1.100.10', '101', 'an.M. ALIFIN FIKRI', '3000', '0', 'Chuwez', '2025-05-29 22:34:56'),
('4216', 'ST10100320250529083456', '1446-12-01', '2.220.10', '101', 'an.M. ALIFIN FIKRI', '0', '3000', 'Chuwez', '2025-05-29 22:34:56'),
('4217', 'ST10100320250529083508', '1446-12-01', '1.100.10', '101', 'an.MUHAMMAD KHOIRON', '2000', '0', 'Chuwez', '2025-05-29 22:35:08'),
('4218', 'ST10100320250529083508', '1446-12-01', '2.220.10', '101', 'an.MUHAMMAD KHOIRON', '0', '2000', 'Chuwez', '2025-05-29 22:35:08'),
('4219', 'ST10100320250529083527', '1446-12-01', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '5000', '0', 'Chuwez', '2025-05-29 22:35:27'),
('4220', 'ST10100320250529083527', '1446-12-01', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '5000', 'Chuwez', '2025-05-29 22:35:27'),
('4221', 'ST10100320250529083549', '1446-12-01', '1.100.10', '101', 'an.ACH. JUNAIDI', '5000', '0', 'Chuwez', '2025-05-29 22:35:49'),
('4222', 'ST10100320250529083549', '1446-12-01', '2.220.10', '101', 'an.ACH. JUNAIDI', '0', '5000', 'Chuwez', '2025-05-29 22:35:49'),
('4223', 'ST10100320250529083614', '1446-12-01', '1.100.10', '101', 'an.MACHMUDAH', '10000', '0', 'Chuwez', '2025-05-29 22:36:14'),
('4224', 'ST10100320250529083614', '1446-12-01', '2.220.10', '101', 'an.MACHMUDAH', '0', '10000', 'Chuwez', '2025-05-29 22:36:14'),
('4225', 'ST10100320250529083631', '1446-12-01', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'Chuwez', '2025-05-29 22:36:31'),
('4226', 'ST10100320250529083631', '1446-12-01', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'Chuwez', '2025-05-29 22:36:31'),
('4227', 'ST10100320250529084720', '1446-12-01', '1.100.10', '101', 'an.AMARA', '20000', '0', 'Chuwez', '2025-05-29 22:47:20'),
('4228', 'ST10100320250529084720', '1446-12-01', '2.220.10', '101', 'an.AMARA', '0', '20000', 'Chuwez', '2025-05-29 22:47:21'),
('4229', 'SY10100320250529085220000', '1446-10-01', '1.100.10', '101', 'Bayar[HIKMATUL KHOLIDAH]', '30000', '0', 'Chuwez', '2025-05-29 15:52:20'),
('4230', 'SY10100320250529085220000', '1446-10-01', '4.400.20', '101', 'Bayar[HIKMATUL KHOLIDAH]', '0', '30000', 'Chuwez', '2025-05-29 15:52:20'),
('4231', 'SY10100320250529085315000', '1446-10-01', '1.100.10', '101', 'Bayar[PUTRI MAULIDATUL IMANIA]', '30000', '0', 'Chuwez', '2025-05-29 15:53:15'),
('4232', 'SY10100320250529085315000', '1446-10-01', '4.400.20', '101', 'Bayar[PUTRI MAULIDATUL IMANIA]', '0', '30000', 'Chuwez', '2025-05-29 15:53:15'),
('4233', 'SY10100320250529085402000', '1446-10-01', '1.100.10', '101', 'Bayar[M.AKMALUL HIMAM]', '30000', '0', 'Chuwez', '2025-05-29 15:54:02'),
('4234', 'SY10100320250529085402000', '1446-10-01', '4.400.20', '101', 'Bayar[M.AKMALUL HIMAM]', '0', '30000', 'Chuwez', '2025-05-29 15:54:02'),
('4235', 'SY10100320250529085402001', '1446-11-01', '1.100.10', '101', 'Bayar[M.AKMALUL HIMAM]', '30000', '0', 'Chuwez', '2025-05-29 15:54:02'),
('4236', 'SY10100320250529085402001', '1446-11-01', '4.400.20', '101', 'Bayar[M.AKMALUL HIMAM]', '0', '30000', 'Chuwez', '2025-05-29 15:54:02'),
('4237', 'SY10100320250529085402002', '1446-12-01', '1.100.10', '101', 'Bayar[M.AKMALUL HIMAM]', '30000', '0', 'Chuwez', '2025-05-29 15:54:02'),
('4238', 'SY10100320250529085402002', '1446-12-01', '4.400.20', '101', 'Bayar[M.AKMALUL HIMAM]', '0', '30000', 'Chuwez', '2025-05-29 15:54:02'),
('4239', 'SY10100320250529085456000', '1446-10-01', '1.100.10', '101', 'Bayar[MUHAMMAD ALWI]', '30000', '0', 'Chuwez', '2025-05-29 15:54:56'),
('4240', 'SY10100320250529085456000', '1446-10-01', '4.400.20', '101', 'Bayar[MUHAMMAD ALWI]', '0', '30000', 'Chuwez', '2025-05-29 15:54:56'),
('4241', 'SY10100320250529085456001', '1446-11-01', '1.100.10', '101', 'Bayar[MUHAMMAD ALWI]', '30000', '0', 'Chuwez', '2025-05-29 15:54:56'),
('4242', 'SY10100320250529085456001', '1446-11-01', '4.400.20', '101', 'Bayar[MUHAMMAD ALWI]', '0', '30000', 'Chuwez', '2025-05-29 15:54:56'),
('4243', 'SY10100320250529085456002', '1446-12-01', '1.100.10', '101', 'Bayar[MUHAMMAD ALWI]', '30000', '0', 'Chuwez', '2025-05-29 15:54:56'),
('4244', 'SY10100320250529085456002', '1446-12-01', '4.400.20', '101', 'Bayar[MUHAMMAD ALWI]', '0', '30000', 'Chuwez', '2025-05-29 15:54:56'),
('4245', 'SY10100320250529085531000', '1446-10-01', '1.100.10', '101', 'Bayar[AHMAD AZAIM IBRAHIMI]', '30000', '0', 'Chuwez', '2025-05-29 15:55:31'),
('4246', 'SY10100320250529085531000', '1446-10-01', '4.400.20', '101', 'Bayar[AHMAD AZAIM IBRAHIMI]', '0', '30000', 'Chuwez', '2025-05-29 15:55:31'),
('4247', 'SY10100320250529085531001', '1446-11-01', '1.100.10', '101', 'Bayar[AHMAD AZAIM IBRAHIMI]', '30000', '0', 'Chuwez', '2025-05-29 15:55:31'),
('4248', 'SY10100320250529085531001', '1446-11-01', '4.400.20', '101', 'Bayar[AHMAD AZAIM IBRAHIMI]', '0', '30000', 'Chuwez', '2025-05-29 15:55:31'),
('4249', 'SY10100320250529085605000', '1446-10-01', '1.100.10', '101', 'Bayar[HIKMIAH PUTRI NIKMATUNNAFILAH]', '30000', '0', 'Chuwez', '2025-05-29 15:56:05'),
('4250', 'SY10100320250529085605000', '1446-10-01', '4.400.20', '101', 'Bayar[HIKMIAH PUTRI NIKMATUNNAFILAH]', '0', '30000', 'Chuwez', '2025-05-29 15:56:05'),
('4251', 'SY10100320250529085605001', '1446-11-01', '1.100.10', '101', 'Bayar[HIKMIAH PUTRI NIKMATUNNAFILAH]', '30000', '0', 'Chuwez', '2025-05-29 15:56:05'),
('4252', 'SY10100320250529085605001', '1446-11-01', '4.400.20', '101', 'Bayar[HIKMIAH PUTRI NIKMATUNNAFILAH]', '0', '30000', 'Chuwez', '2025-05-29 15:56:05'),
('4253', 'SY10100320250529085652000', '1446-10-01', '1.100.10', '101', 'Bayar[SITI ISTIFAIYAH]', '30000', '0', 'Chuwez', '2025-05-29 15:56:52'),
('4254', 'SY10100320250529085652000', '1446-10-01', '4.400.20', '101', 'Bayar[SITI ISTIFAIYAH]', '0', '30000', 'Chuwez', '2025-05-29 15:56:52'),
('4255', 'SY10100320250529085731000', '1446-10-01', '1.100.10', '101', 'Bayar[WARDATUL JANNAH]', '30000', '0', 'Chuwez', '2025-05-29 15:57:31'),
('4256', 'SY10100320250529085731000', '1446-10-01', '4.400.20', '101', 'Bayar[WARDATUL JANNAH]', '0', '30000', 'Chuwez', '2025-05-29 15:57:31'),
('4257', 'SY10100320250529085731001', '1446-11-01', '1.100.10', '101', 'Bayar[WARDATUL JANNAH]', '30000', '0', 'Chuwez', '2025-05-29 15:57:31'),
('4258', 'SY10100320250529085731001', '1446-11-01', '4.400.20', '101', 'Bayar[WARDATUL JANNAH]', '0', '30000', 'Chuwez', '2025-05-29 15:57:31'),
('4259', 'SY10100320250529085818000', '1446-10-01', '1.100.10', '101', 'Bayar[MUHAMMAD ISMAIL]', '30000', '0', 'Chuwez', '2025-05-29 15:58:18'),
('4260', 'SY10100320250529085818000', '1446-10-01', '4.400.20', '101', 'Bayar[MUHAMMAD ISMAIL]', '0', '30000', 'Chuwez', '2025-05-29 15:58:18'),
('4261', 'SY10100320250529085850000', '1446-10-01', '1.100.10', '101', 'Bayar[RENI FARIDA]', '30000', '0', 'Chuwez', '2025-05-29 15:58:50'),
('4262', 'SY10100320250529085850000', '1446-10-01', '4.400.20', '101', 'Bayar[RENI FARIDA]', '0', '30000', 'Chuwez', '2025-05-29 15:58:50'),
('4263', 'SY10100320250529085928000', '1446-10-01', '1.100.10', '101', 'Bayar[M. ABD. HADI]', '30000', '0', 'Chuwez', '2025-05-29 15:59:28'),
('4264', 'SY10100320250529085928000', '1446-10-01', '4.400.20', '101', 'Bayar[M. ABD. HADI]', '0', '30000', 'Chuwez', '2025-05-29 15:59:28'),
('4265', 'SY10100320250529090001000', '1446-10-01', '1.100.10', '101', 'Bayar[MUHAMMAD YAHYA SYAKARUDDIN]', '30000', '0', 'Chuwez', '2025-05-29 16:00:01'),
('4266', 'SY10100320250529090001000', '1446-10-01', '4.400.20', '101', 'Bayar[MUHAMMAD YAHYA SYAKARUDDIN]', '0', '30000', 'Chuwez', '2025-05-29 16:00:01'),
('4267', 'SY10100320250529090032000', '1446-10-01', '1.100.10', '101', 'Bayar[MOCHAMMAD TAUFIK ALI KURNIAWAN]', '30000', '0', 'Chuwez', '2025-05-29 16:00:32'),
('4268', 'SY10100320250529090032000', '1446-10-01', '4.400.20', '101', 'Bayar[MOCHAMMAD TAUFIK ALI KURNIAWAN]', '0', '30000', 'Chuwez', '2025-05-29 16:00:32'),
('4269', 'SY10100320250529090057000', '1446-10-01', '1.100.10', '101', 'Bayar[DIYANAH KAMALIYAH]', '30000', '0', 'Chuwez', '2025-05-29 16:00:57'),
('4270', 'SY10100320250529090057000', '1446-10-01', '4.400.20', '101', 'Bayar[DIYANAH KAMALIYAH]', '0', '30000', 'Chuwez', '2025-05-29 16:00:57'),
('4271', 'SY10100320250529090057001', '1446-11-01', '1.100.10', '101', 'Bayar[DIYANAH KAMALIYAH]', '30000', '0', 'Chuwez', '2025-05-29 16:00:57'),
('4272', 'SY10100320250529090057001', '1446-11-01', '4.400.20', '101', 'Bayar[DIYANAH KAMALIYAH]', '0', '30000', 'Chuwez', '2025-05-29 16:00:57'),
('4273', 'SY10100320250529090128000', '1446-10-01', '1.100.10', '101', 'Bayar[AHMAD RAFI SALIM]', '30000', '0', 'Chuwez', '2025-05-29 16:01:28'),
('4274', 'SY10100320250529090128000', '1446-10-01', '4.400.20', '101', 'Bayar[AHMAD RAFI SALIM]', '0', '30000', 'Chuwez', '2025-05-29 16:01:28'),
('4275', 'SY10100320250529090203000', '1446-10-01', '1.100.10', '101', 'Bayar[MOCHAMMAD UMAR SAID HIDAYATULLOH]', '30000', '0', 'Chuwez', '2025-05-29 16:02:03'),
('4276', 'SY10100320250529090203000', '1446-10-01', '4.400.20', '101', 'Bayar[MOCHAMMAD UMAR SAID HIDAYATULLOH]', '0', '30000', 'Chuwez', '2025-05-29 16:02:03'),
('4277', 'SY10100320250529090204001', '1446-11-01', '1.100.10', '101', 'Bayar[MOCHAMMAD UMAR SAID HIDAYATULLOH]', '30000', '0', 'Chuwez', '2025-05-29 16:02:04'),
('4278', 'SY10100320250529090204001', '1446-11-01', '4.400.20', '101', 'Bayar[MOCHAMMAD UMAR SAID HIDAYATULLOH]', '0', '30000', 'Chuwez', '2025-05-29 16:02:04'),
('4279', 'SY10100320250529090241000', '1446-10-01', '1.100.10', '101', 'Bayar[M. FAHMI NURUL ANAM]', '30000', '0', 'Chuwez', '2025-05-29 16:02:41'),
('4280', 'SY10100320250529090241000', '1446-10-01', '4.400.20', '101', 'Bayar[M. FAHMI NURUL ANAM]', '0', '30000', 'Chuwez', '2025-05-29 16:02:41'),
('4281', 'SY10100320250529090241001', '1446-11-01', '1.100.10', '101', 'Bayar[M. FAHMI NURUL ANAM]', '30000', '0', 'Chuwez', '2025-05-29 16:02:41'),
('4282', 'SY10100320250529090241001', '1446-11-01', '4.400.20', '101', 'Bayar[M. FAHMI NURUL ANAM]', '0', '30000', 'Chuwez', '2025-05-29 16:02:41'),
('4285', 'SY10100320250529090352000', '1446-10-01', '1.100.10', '101', 'Bayar[MUHAMMAD KANZUL KAROMI]', '30000', '0', 'Chuwez', '2025-05-29 16:03:52'),
('4286', 'SY10100320250529090352000', '1446-10-01', '4.400.20', '101', 'Bayar[MUHAMMAD KANZUL KAROMI]', '0', '30000', 'Chuwez', '2025-05-29 16:03:52'),
('4287', 'SY10100320250529090352001', '1446-11-01', '1.100.10', '101', 'Bayar[MUHAMMAD KANZUL KAROMI]', '30000', '0', 'Chuwez', '2025-05-29 16:03:52'),
('4288', 'SY10100320250529090352001', '1446-11-01', '4.400.20', '101', 'Bayar[MUHAMMAD KANZUL KAROMI]', '0', '30000', 'Chuwez', '2025-05-29 16:03:52'),
('4289', 'SY10100320250529090433000', '1446-10-01', '1.100.10', '101', 'Bayar[MUHAMMAD HAMDANI]', '30000', '0', 'Chuwez', '2025-05-29 16:04:33'),
('4290', 'SY10100320250529090433000', '1446-10-01', '4.400.20', '101', 'Bayar[MUHAMMAD HAMDANI]', '0', '30000', 'Chuwez', '2025-05-29 16:04:33'),
('4291', 'SY10100320250529090504000', '1446-10-01', '1.100.10', '101', 'Bayar[MUHAMMAD ARDIANSYAH]', '30000', '0', 'Chuwez', '2025-05-29 16:05:04'),
('4292', 'SY10100320250529090504000', '1446-10-01', '4.400.20', '101', 'Bayar[MUHAMMAD ARDIANSYAH]', '0', '30000', 'Chuwez', '2025-05-29 16:05:04'),
('4293', 'SY10100320250529090538000', '1446-10-01', '1.100.10', '101', 'Bayar[RAISA ANNISA]', '30000', '0', 'Chuwez', '2025-05-29 16:05:38'),
('4294', 'SY10100320250529090538000', '1446-10-01', '4.400.20', '101', 'Bayar[RAISA ANNISA]', '0', '30000', 'Chuwez', '2025-05-29 16:05:38'),
('4295', 'SY10100320250529090614000', '1446-10-01', '1.100.10', '101', 'Bayar[M. DESTRA MAULANA]', '30000', '0', 'Chuwez', '2025-05-29 16:06:14'),
('4296', 'SY10100320250529090614000', '1446-10-01', '4.400.20', '101', 'Bayar[M. DESTRA MAULANA]', '0', '30000', 'Chuwez', '2025-05-29 16:06:14'),
('4297', 'SY10100320250529090614001', '1446-11-01', '1.100.10', '101', 'Bayar[M. DESTRA MAULANA]', '30000', '0', 'Chuwez', '2025-05-29 16:06:14'),
('4298', 'SY10100320250529090614001', '1446-11-01', '4.400.20', '101', 'Bayar[M. DESTRA MAULANA]', '0', '30000', 'Chuwez', '2025-05-29 16:06:14'),
('4299', 'SY10100320250529090653000', '1446-10-01', '1.100.10', '101', 'Bayar[NABILATUN NISAUL UMMAH]', '30000', '0', 'Chuwez', '2025-05-29 16:06:53'),
('4300', 'SY10100320250529090653000', '1446-10-01', '4.400.20', '101', 'Bayar[NABILATUN NISAUL UMMAH]', '0', '30000', 'Chuwez', '2025-05-29 16:06:53'),
('4301', 'SY10100320250529090653001', '1446-11-01', '1.100.10', '101', 'Bayar[NABILATUN NISAUL UMMAH]', '30000', '0', 'Chuwez', '2025-05-29 16:06:53'),
('4302', 'SY10100320250529090653001', '1446-11-01', '4.400.20', '101', 'Bayar[NABILATUN NISAUL UMMAH]', '0', '30000', 'Chuwez', '2025-05-29 16:06:53'),
('4303', 'SY10100320250529090653002', '1446-12-01', '1.100.10', '101', 'Bayar[NABILATUN NISAUL UMMAH]', '30000', '0', 'Chuwez', '2025-05-29 16:06:53'),
('4304', 'SY10100320250529090653002', '1446-12-01', '4.400.20', '101', 'Bayar[NABILATUN NISAUL UMMAH]', '0', '30000', 'Chuwez', '2025-05-29 16:06:53'),
('4305', 'SY10100320250529090727000', '1446-10-01', '1.100.10', '101', 'Bayar[LAILATUL MAGHFIROH]', '30000', '0', 'Chuwez', '2025-05-29 16:07:27'),
('4306', 'SY10100320250529090727000', '1446-10-01', '4.400.20', '101', 'Bayar[LAILATUL MAGHFIROH]', '0', '30000', 'Chuwez', '2025-05-29 16:07:27'),
('4307', 'SY10100320250529090727001', '1446-11-01', '1.100.10', '101', 'Bayar[LAILATUL MAGHFIROH]', '30000', '0', 'Chuwez', '2025-05-29 16:07:27'),
('4308', 'SY10100320250529090727001', '1446-11-01', '4.400.20', '101', 'Bayar[LAILATUL MAGHFIROH]', '0', '30000', 'Chuwez', '2025-05-29 16:07:27'),
('4309', 'SY10100320250529090803000', '1446-10-01', '1.100.10', '101', 'Bayar[AHMAD ABBAS MAULANA]', '30000', '0', 'Chuwez', '2025-05-29 16:08:03'),
('4310', 'SY10100320250529090803000', '1446-10-01', '4.400.20', '101', 'Bayar[AHMAD ABBAS MAULANA]', '0', '30000', 'Chuwez', '2025-05-29 16:08:03'),
('4311', 'SY10100320250529090838000', '1446-10-01', '1.100.10', '101', 'Bayar[MUHAMMAD RAIHAN SABILA]', '30000', '0', 'Chuwez', '2025-05-29 16:08:38'),
('4312', 'SY10100320250529090838000', '1446-10-01', '4.400.20', '101', 'Bayar[MUHAMMAD RAIHAN SABILA]', '0', '30000', 'Chuwez', '2025-05-29 16:08:38'),
('4313', 'SY10100320250529090838001', '1446-11-01', '1.100.10', '101', 'Bayar[MUHAMMAD RAIHAN SABILA]', '30000', '0', 'Chuwez', '2025-05-29 16:08:38'),
('4314', 'SY10100320250529090838001', '1446-11-01', '4.400.20', '101', 'Bayar[MUHAMMAD RAIHAN SABILA]', '0', '30000', 'Chuwez', '2025-05-29 16:08:38'),
('4315', 'SY10100320250529090913000', '1446-10-01', '1.100.10', '101', 'Bayar[SITI QURROTUL AINI]', '30000', '0', 'Chuwez', '2025-05-29 16:09:13'),
('4316', 'SY10100320250529090913000', '1446-10-01', '4.400.20', '101', 'Bayar[SITI QURROTUL AINI]', '0', '30000', 'Chuwez', '2025-05-29 16:09:13'),
('4317', 'SY10100320250529090913001', '1446-11-01', '1.100.10', '101', 'Bayar[SITI QURROTUL AINI]', '30000', '0', 'Chuwez', '2025-05-29 16:09:13'),
('4318', 'SY10100320250529090913001', '1446-11-01', '4.400.20', '101', 'Bayar[SITI QURROTUL AINI]', '0', '30000', 'Chuwez', '2025-05-29 16:09:13'),
('4319', 'SY10100320250529090959000', '1446-10-01', '1.100.10', '101', 'Bayar[ABDUL HAMID]', '30000', '0', 'Chuwez', '2025-05-29 16:09:59'),
('4320', 'SY10100320250529090959000', '1446-10-01', '4.400.20', '101', 'Bayar[ABDUL HAMID]', '0', '30000', 'Chuwez', '2025-05-29 16:09:59'),
('4321', 'SY10100320250529091028000', '1446-10-01', '1.100.10', '101', 'Bayar[ROFIQOTUS SARIROH]', '30000', '0', 'Chuwez', '2025-05-29 16:10:28'),
('4322', 'SY10100320250529091028000', '1446-10-01', '4.400.20', '101', 'Bayar[ROFIQOTUS SARIROH]', '0', '30000', 'Chuwez', '2025-05-29 16:10:28'),
('4323', 'SY10100320250529091029001', '1446-11-01', '1.100.10', '101', 'Bayar[ROFIQOTUS SARIROH]', '30000', '0', 'Chuwez', '2025-05-29 16:10:29'),
('4324', 'SY10100320250529091029001', '1446-11-01', '4.400.20', '101', 'Bayar[ROFIQOTUS SARIROH]', '0', '30000', 'Chuwez', '2025-05-29 16:10:29'),
('4325', 'KK10100320250529161255', '1446-12-01', '5.520.42', '101', 'Beli gorengan', '10000', '0', 'Chuwez', '2025-05-29 16:13:13'),
('4326', 'KK10100320250529161255', '1446-12-01', '1.100.10', '101', 'Beli gorengan', '0', '10000', 'Chuwez', '2025-05-29 16:13:13'),
('4329', 'ST10100320250531073707', '1446-12-03', '1.100.10', '101', 'an.M. ABD. HADI', '2000', '0', 'Chuwez', '2025-05-31 21:37:07'),
('4330', 'ST10100320250531073707', '1446-12-03', '2.220.10', '101', 'an.M. ABD. HADI', '0', '2000', 'Chuwez', '2025-05-31 21:37:07'),
('4331', 'ST10100320250531073734', '1446-12-03', '1.100.10', '101', 'an.ELOK WARDATUN NAFISAH', '10000', '0', 'Chuwez', '2025-05-31 21:37:34'),
('4332', 'ST10100320250531073734', '1446-12-03', '2.220.10', '101', 'an.ELOK WARDATUN NAFISAH', '0', '10000', 'Chuwez', '2025-05-31 21:37:34'),
('4333', 'ST10100320250531073848', '1446-12-03', '1.100.10', '101', 'an.RAISA ANNISA', '5000', '0', 'Chuwez', '2025-05-31 21:38:48'),
('4334', 'ST10100320250531073848', '1446-12-03', '2.220.10', '101', 'an.RAISA ANNISA', '0', '5000', 'Chuwez', '2025-05-31 21:38:48'),
('4335', 'ST10100320250531073909', '1446-12-03', '1.100.10', '101', 'an.HAIKAL SHOMADANI', '2000', '0', 'Chuwez', '2025-05-31 21:39:09'),
('4336', 'ST10100320250531073909', '1446-12-03', '2.220.10', '101', 'an.HAIKAL SHOMADANI', '0', '2000', 'Chuwez', '2025-05-31 21:39:09'),
('4337', 'ST10100320250531073943', '1446-12-03', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '5000', '0', 'Chuwez', '2025-05-31 21:39:43'),
('4338', 'ST10100320250531073943', '1446-12-03', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '5000', 'Chuwez', '2025-05-31 21:39:43'),
('4339', 'ST10100320250531074010', '1446-12-03', '1.100.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '10000', '0', 'Chuwez', '2025-05-31 21:40:10'),
('4340', 'ST10100320250531074010', '1446-12-03', '2.220.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '0', '10000', 'Chuwez', '2025-05-31 21:40:10'),
('4341', 'ST10100320250531074038', '1446-12-03', '1.100.10', '101', 'an.MUHAMMAD ALWI', '10000', '0', 'Chuwez', '2025-05-31 21:40:38'),
('4342', 'ST10100320250531074038', '1446-12-03', '2.220.10', '101', 'an.MUHAMMAD ALWI', '0', '10000', 'Chuwez', '2025-05-31 21:40:38'),
('4343', 'ST10100320250531074142', '1446-12-03', '1.100.10', '101', 'an.UMAR FARUQ', '10000', '0', 'Chuwez', '2025-05-31 21:41:42'),
('4344', 'ST10100320250531074142', '1446-12-03', '2.220.10', '101', 'an.UMAR FARUQ', '0', '10000', 'Chuwez', '2025-05-31 21:41:42'),
('4345', 'ST10100320250531074227', '1446-12-03', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'Chuwez', '2025-05-31 21:42:27'),
('4346', 'ST10100320250531074227', '1446-12-03', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'Chuwez', '2025-05-31 21:42:27'),
('4347', 'ST10100320250531074254', '1446-12-03', '1.100.10', '101', 'an.NAURA BILADINA', '6000', '0', 'Chuwez', '2025-05-31 21:42:54'),
('4348', 'ST10100320250531074254', '1446-12-03', '2.220.10', '101', 'an.NAURA BILADINA', '0', '6000', 'Chuwez', '2025-05-31 21:42:54'),
('4349', 'ST10100320250531074329', '1446-12-03', '1.100.10', '101', 'an.AULIA AZZAHRA', '10000', '0', 'Chuwez', '2025-05-31 21:43:29'),
('4350', 'ST10100320250531074329', '1446-12-03', '2.220.10', '101', 'an.AULIA AZZAHRA', '0', '10000', 'Chuwez', '2025-05-31 21:43:29'),
('4351', 'ST10100320250531074607', '1446-12-03', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '2000', '0', 'Chuwez', '2025-05-31 21:46:07'),
('4352', 'ST10100320250531074607', '1446-12-03', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '2000', 'Chuwez', '2025-05-31 21:46:07'),
('4353', 'ST10100320250531074628', '1446-12-03', '1.100.10', '101', 'an.M. KAMALUDDIN', '20000', '0', 'Chuwez', '2025-05-31 21:46:28'),
('4354', 'ST10100320250531074628', '1446-12-03', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '20000', 'Chuwez', '2025-05-31 21:46:29'),
('4355', 'ST10100320250531074658', '1446-12-03', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Chuwez', '2025-05-31 21:46:58'),
('4356', 'ST10100320250531074658', '1446-12-03', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Chuwez', '2025-05-31 21:46:58'),
('4357', 'ST10100320250531074720', '1446-12-03', '1.100.10', '101', 'an.NABILATUN NISAUL UMMAH', '20000', '0', 'Chuwez', '2025-05-31 21:47:20'),
('4358', 'ST10100320250531074720', '1446-12-03', '2.220.10', '101', 'an.NABILATUN NISAUL UMMAH', '0', '20000', 'Chuwez', '2025-05-31 21:47:20'),
('4359', 'ST10100320250531074748', '1446-12-03', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '5000', '0', 'Chuwez', '2025-05-31 21:47:48'),
('4360', 'ST10100320250531074748', '1446-12-03', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '5000', 'Chuwez', '2025-05-31 21:47:48'),
('4361', 'ST10100320250531074804', '1446-12-03', '1.100.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '20000', '0', 'Chuwez', '2025-05-31 21:48:04'),
('4362', 'ST10100320250531074804', '1446-12-03', '2.220.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '0', '20000', 'Chuwez', '2025-05-31 21:48:04'),
('4363', 'ST10100320250531074819', '1446-12-03', '1.100.10', '101', 'an.MIFTAHUL JANNAH', '50000', '0', 'Chuwez', '2025-05-31 21:48:19'),
('4364', 'ST10100320250531074819', '1446-12-03', '2.220.10', '101', 'an.MIFTAHUL JANNAH', '0', '50000', 'Chuwez', '2025-05-31 21:48:19'),
('4365', 'ST10100320250531074835', '1446-12-03', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '10000', '0', 'Chuwez', '2025-05-31 21:48:35'),
('4366', 'ST10100320250531074835', '1446-12-03', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '10000', 'Chuwez', '2025-05-31 21:48:35'),
('4367', 'ST10100320250531074913', '1446-12-03', '1.100.10', '101', 'an.FAIZAH NURUL LITA', '5000', '0', 'Chuwez', '2025-05-31 21:49:13'),
('4368', 'ST10100320250531074913', '1446-12-03', '2.220.10', '101', 'an.FAIZAH NURUL LITA', '0', '5000', 'Chuwez', '2025-05-31 21:49:13'),
('4369', 'ST10100320250531074934', '1446-12-03', '1.100.10', '101', 'an.UBAIDAH', '20000', '0', 'Chuwez', '2025-05-31 21:49:34'),
('4370', 'ST10100320250531074934', '1446-12-03', '2.220.10', '101', 'an.UBAIDAH', '0', '20000', 'Chuwez', '2025-05-31 21:49:35'),
('4371', 'ST10100320250531074955', '1446-12-03', '1.100.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '4000', '0', 'Chuwez', '2025-05-31 21:49:55'),
('4372', 'ST10100320250531074955', '1446-12-03', '2.220.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '0', '4000', 'Chuwez', '2025-05-31 21:49:55'),
('4373', 'ST10100320250531075045', '1446-12-03', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'Chuwez', '2025-05-31 21:50:45'),
('4374', 'ST10100320250531075045', '1446-12-03', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'Chuwez', '2025-05-31 21:50:45'),
('4375', 'ST10100320250531075108', '1446-12-03', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '5000', '0', 'Chuwez', '2025-05-31 21:51:08'),
('4376', 'ST10100320250531075108', '1446-12-03', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '5000', 'Chuwez', '2025-05-31 21:51:08'),
('4377', 'ST10100320250531075131', '1446-12-03', '1.100.10', '101', 'an.ADIBA QONITA', '30000', '0', 'Chuwez', '2025-05-31 21:51:31'),
('4378', 'ST10100320250531075131', '1446-12-03', '2.220.10', '101', 'an.ADIBA QONITA', '0', '30000', 'Chuwez', '2025-05-31 21:51:31'),
('4379', 'ST10100320250531075208', '1446-12-03', '1.100.10', '101', 'an.MARIYATUL QIBTIYAH', '5000', '0', 'Chuwez', '2025-05-31 21:52:08'),
('4380', 'ST10100320250531075208', '1446-12-03', '2.220.10', '101', 'an.MARIYATUL QIBTIYAH', '0', '5000', 'Chuwez', '2025-05-31 21:52:08'),
('4381', 'ST10100320250531075232', '1446-12-03', '1.100.10', '101', 'an.NAILATUN NIAMI', '2000', '0', 'Chuwez', '2025-05-31 21:52:32'),
('4382', 'ST10100320250531075232', '1446-12-03', '2.220.10', '101', 'an.NAILATUN NIAMI', '0', '2000', 'Chuwez', '2025-05-31 21:52:32'),
('4383', 'ST10100320250531075252', '1446-12-03', '1.100.10', '101', 'an.MARIATUL QIBTIYAH', '2000', '0', 'Chuwez', '2025-05-31 21:52:52'),
('4384', 'ST10100320250531075252', '1446-12-03', '2.220.10', '101', 'an.MARIATUL QIBTIYAH', '0', '2000', 'Chuwez', '2025-05-31 21:52:52'),
('4385', 'ST10100320250531075317', '1446-12-03', '1.100.10', '101', 'an.SAUQY AHMAD', '5000', '0', 'Chuwez', '2025-05-31 21:53:17'),
('4386', 'ST10100320250531075317', '1446-12-03', '2.220.10', '101', 'an.SAUQY AHMAD', '0', '5000', 'Chuwez', '2025-05-31 21:53:17'),
('4387', 'ST10100320250531075348', '1446-12-03', '1.100.10', '101', 'an.ALFI NURDIANA', '5000', '0', 'Chuwez', '2025-05-31 21:53:48'),
('4388', 'ST10100320250531075348', '1446-12-03', '2.220.10', '101', 'an.ALFI NURDIANA', '0', '5000', 'Chuwez', '2025-05-31 21:53:48'),
('4389', 'ST10100320250531075416', '1446-12-03', '1.100.10', '101', 'an.DIANA RIFQOTUL QOLBI', '10000', '0', 'Chuwez', '2025-05-31 21:54:16'),
('4390', 'ST10100320250531075416', '1446-12-03', '2.220.10', '101', 'an.DIANA RIFQOTUL QOLBI', '0', '10000', 'Chuwez', '2025-05-31 21:54:16'),
('4391', 'ST10100320250531075440', '1446-12-03', '1.100.10', '101', 'an.AHMAD ADITIYA', '2000', '0', 'Chuwez', '2025-05-31 21:54:40'),
('4392', 'ST10100320250531075440', '1446-12-03', '2.220.10', '101', 'an.AHMAD ADITIYA', '0', '2000', 'Chuwez', '2025-05-31 21:54:40'),
('4393', 'ST10100320250531075503', '1446-12-03', '1.100.10', '101', 'an.AZKA AUFARIL MINAN', '10000', '0', 'Chuwez', '2025-05-31 21:55:03'),
('4394', 'ST10100320250531075503', '1446-12-03', '2.220.10', '101', 'an.AZKA AUFARIL MINAN', '0', '10000', 'Chuwez', '2025-05-31 21:55:03'),
('4395', 'ST10100320250531075541', '1446-12-03', '1.100.10', '101', 'an.LAILATUL MAGHFIROH', '5000', '0', 'Chuwez', '2025-05-31 21:55:41'),
('4396', 'ST10100320250531075541', '1446-12-03', '2.220.10', '101', 'an.LAILATUL MAGHFIROH', '0', '5000', 'Chuwez', '2025-05-31 21:55:41'),
('4397', 'ST10100320250531073636', '1446-12-03', '1.100.10', '101', 'an.SITI SHOFIYAH LABIBAH', '30000', '0', 'Ipul', '2025-05-31 21:55:47'),
('4398', 'ST10100320250531073636', '1446-12-03', '2.220.10', '101', 'an.SITI SHOFIYAH LABIBAH', '0', '30000', 'Ipul', '2025-05-31 21:55:47'),
('4399', 'ST10100320250531075608', '1446-12-03', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '10000', '0', 'Chuwez', '2025-05-31 21:56:08'),
('4400', 'ST10100320250531075608', '1446-12-03', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '10000', 'Chuwez', '2025-05-31 21:56:08'),
('4401', 'ST10100320250531075632', '1446-12-03', '1.100.10', '101', 'an.AISYAH', '5000', '0', 'Chuwez', '2025-05-31 21:56:32'),
('4402', 'ST10100320250531075632', '1446-12-03', '2.220.10', '101', 'an.AISYAH', '0', '5000', 'Chuwez', '2025-05-31 21:56:32'),
('4403', 'ST10100320250531075715', '1446-12-03', '1.100.10', '101', 'an.ABDUL HAMID', '5000', '0', 'Chuwez', '2025-05-31 21:57:15'),
('4404', 'ST10100320250531075715', '1446-12-03', '2.220.10', '101', 'an.ABDUL HAMID', '0', '5000', 'Chuwez', '2025-05-31 21:57:15'),
('4405', 'ST10100320250531075734', '1446-12-03', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '10000', '0', 'Chuwez', '2025-05-31 21:57:34'),
('4406', 'ST10100320250531075734', '1446-12-03', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '10000', 'Chuwez', '2025-05-31 21:57:34'),
('4407', 'ST10100320250531075756', '1446-12-03', '1.100.10', '101', 'an.WARDATUL JANNAH', '5000', '0', 'Chuwez', '2025-05-31 21:57:56'),
('4408', 'ST10100320250531075756', '1446-12-03', '2.220.10', '101', 'an.WARDATUL JANNAH', '0', '5000', 'Chuwez', '2025-05-31 21:57:56'),
('4409', 'ST10100320250531075829', '1446-12-03', '1.100.10', '101', 'an.DIYANAH KAMALIYAH', '2000', '0', 'Chuwez', '2025-05-31 21:58:29'),
('4410', 'ST10100320250531075829', '1446-12-03', '2.220.10', '101', 'an.DIYANAH KAMALIYAH', '0', '2000', 'Chuwez', '2025-05-31 21:58:29'),
('4411', 'ST10100320250531075857', '1446-12-03', '1.100.10', '101', 'an.SITI QURROTUL AINI', '2000', '0', 'Chuwez', '2025-05-31 21:58:57'),
('4412', 'ST10100320250531075857', '1446-12-03', '2.220.10', '101', 'an.SITI QURROTUL AINI', '0', '2000', 'Chuwez', '2025-05-31 21:58:57'),
('4413', 'ST10100320250531075943', '1446-12-03', '1.100.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '10000', '0', 'Chuwez', '2025-05-31 21:59:43'),
('4414', 'ST10100320250531075943', '1446-12-03', '2.220.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '0', '10000', 'Chuwez', '2025-05-31 21:59:43'),
('4415', 'ST10100320250531080007', '1446-12-03', '1.100.10', '101', 'an.SITI ATHIUR ROHMAH', '5000', '0', 'Chuwez', '2025-05-31 22:00:07'),
('4416', 'ST10100320250531080007', '1446-12-03', '2.220.10', '101', 'an.SITI ATHIUR ROHMAH', '0', '5000', 'Chuwez', '2025-05-31 22:00:07'),
('4417', 'BS10100220250531080033000', '1446-11-03', '1.100.10', '101', 'Bayar[BILQIS THALIA HASNA]', '30000', '0', 'Ipul', '2025-05-31 15:00:33'),
('4418', 'BS10100220250531080033000', '1446-11-03', '4.400.20', '101', 'Bayar[BILQIS THALIA HASNA]', '0', '30000', 'Ipul', '2025-05-31 15:00:33'),
('4419', 'BS10100220250531080034001', '1446-12-03', '1.100.10', '101', 'Bayar[BILQIS THALIA HASNA]', '30000', '0', 'Ipul', '2025-05-31 15:00:34'),
('4420', 'BS10100220250531080034001', '1446-12-03', '4.400.20', '101', 'Bayar[BILQIS THALIA HASNA]', '0', '30000', 'Ipul', '2025-05-31 15:00:34'),
('4421', 'ST10100320250531080112', '1446-12-03', '1.100.10', '101', 'an.BILQIS THALIA HASNA', '110000', '0', 'Chuwez', '2025-05-31 22:01:12'),
('4422', 'ST10100320250531080112', '1446-12-03', '2.220.10', '101', 'an.BILQIS THALIA HASNA', '0', '110000', 'Chuwez', '2025-05-31 22:01:12'),
('4423', 'ST10100320250531080140', '1446-12-03', '1.100.10', '101', 'an.AKHMAD FIKRI HAIKAL', '100000', '0', 'Chuwez', '2025-05-31 22:01:40'),
('4424', 'ST10100320250531080140', '1446-12-03', '2.220.10', '101', 'an.AKHMAD FIKRI HAIKAL', '0', '100000', 'Chuwez', '2025-05-31 22:01:40'),
('4425', 'ST10100320250531080204', '1446-12-03', '1.100.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '5000', '0', 'Chuwez', '2025-05-31 22:02:04'),
('4426', 'ST10100320250531080204', '1446-12-03', '2.220.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '0', '5000', 'Chuwez', '2025-05-31 22:02:04'),
('4427', 'ST10100320250531080226', '1446-12-03', '1.100.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '10000', '0', 'Chuwez', '2025-05-31 22:02:26'),
('4428', 'ST10100320250531080226', '1446-12-03', '2.220.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '0', '10000', 'Chuwez', '2025-05-31 22:02:26'),
('4429', 'ST10100320250531080303', '1446-12-03', '1.100.10', '101', 'an.SINDI RAISA PUTRI', '10000', '0', 'Chuwez', '2025-05-31 22:03:03'),
('4430', 'ST10100320250531080303', '1446-12-03', '2.220.10', '101', 'an.SINDI RAISA PUTRI', '0', '10000', 'Chuwez', '2025-05-31 22:03:03'),
('4431', 'ST10100320250531080329', '1446-12-03', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '25000', '0', 'Chuwez', '2025-05-31 22:03:29'),
('4432', 'ST10100320250531080329', '1446-12-03', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '25000', 'Chuwez', '2025-05-31 22:03:29'),
('4433', 'ST10100320250531080409', '1446-12-03', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '6000', '0', 'Chuwez', '2025-05-31 22:04:09'),
('4434', 'ST10100320250531080409', '1446-12-03', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '6000', 'Chuwez', '2025-05-31 22:04:10'),
('4435', 'ST10100320250531080429', '1446-12-03', '1.100.10', '101', 'an.ZAKIYATUL UMMAH', '2000', '0', 'Chuwez', '2025-05-31 22:04:29'),
('4436', 'ST10100320250531080429', '1446-12-03', '2.220.10', '101', 'an.ZAKIYATUL UMMAH', '0', '2000', 'Chuwez', '2025-05-31 22:04:29'),
('4437', 'ST10100320250531080455', '1446-12-03', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '10000', '0', 'Chuwez', '2025-05-31 22:04:55'),
('4438', 'ST10100320250531080455', '1446-12-03', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '10000', 'Chuwez', '2025-05-31 22:04:55'),
('4439', 'ST10100320250531080513', '1446-12-03', '1.100.10', '101', 'an.AFANDI', '2000', '0', 'Chuwez', '2025-05-31 22:05:13'),
('4440', 'ST10100320250531080513', '1446-12-03', '2.220.10', '101', 'an.AFANDI', '0', '2000', 'Chuwez', '2025-05-31 22:05:13'),
('4441', 'ST10100320250531080535', '1446-12-03', '1.100.10', '101', 'an.ANA SALSABILA', '2000', '0', 'Chuwez', '2025-05-31 22:05:35'),
('4442', 'ST10100320250531080535', '1446-12-03', '2.220.10', '101', 'an.ANA SALSABILA', '0', '2000', 'Chuwez', '2025-05-31 22:05:35'),
('4443', 'ST10100320250531080603', '1446-12-03', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '5000', '0', 'Chuwez', '2025-05-31 22:06:03'),
('4444', 'ST10100320250531080603', '1446-12-03', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '5000', 'Chuwez', '2025-05-31 22:06:03'),
('4445', 'ST10100320250531080625', '1446-12-03', '1.100.10', '101', 'an.SAFIRATUL JANNAH', '20000', '0', 'Chuwez', '2025-05-31 22:06:25'),
('4446', 'ST10100320250531080625', '1446-12-03', '2.220.10', '101', 'an.SAFIRATUL JANNAH', '0', '20000', 'Chuwez', '2025-05-31 22:06:25'),
('4447', 'ST10100320250531080647', '1446-12-03', '1.100.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '2000', '0', 'Chuwez', '2025-05-31 22:06:47'),
('4448', 'ST10100320250531080647', '1446-12-03', '2.220.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '0', '2000', 'Chuwez', '2025-05-31 22:06:47'),
('4449', 'ST10100320250531080708', '1446-12-03', '1.100.10', '101', 'an.MACHMUDAH', '10000', '0', 'Chuwez', '2025-05-31 22:07:08'),
('4450', 'ST10100320250531080708', '1446-12-03', '2.220.10', '101', 'an.MACHMUDAH', '0', '10000', 'Chuwez', '2025-05-31 22:07:08'),
('4451', 'ST10100320250531080734', '1446-12-03', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'Chuwez', '2025-05-31 22:07:34'),
('4452', 'ST10100320250531080734', '1446-12-03', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'Chuwez', '2025-05-31 22:07:34'),
('4453', 'ST10100320250531080808', '1446-12-03', '1.100.10', '101', 'an.HILYA', '20000', '0', 'Chuwez', '2025-05-31 22:08:08'),
('4454', 'ST10100320250531080808', '1446-12-03', '2.220.10', '101', 'an.HILYA', '0', '20000', 'Chuwez', '2025-05-31 22:08:08'),
('4455', 'ST10100320250531080838', '1446-12-03', '1.100.10', '101', 'an.HAMIDAH', '100000', '0', 'Chuwez', '2025-05-31 22:08:38'),
('4456', 'ST10100320250531080838', '1446-12-03', '2.220.10', '101', 'an.HAMIDAH', '0', '100000', 'Chuwez', '2025-05-31 22:08:38'),
('4457', 'ST10100320250531081001', '1446-12-03', '1.100.10', '101', 'an.AMARA', '20000', '0', 'Chuwez', '2025-05-31 22:10:01'),
('4458', 'ST10100320250531081001', '1446-12-03', '2.220.10', '101', 'an.AMARA', '0', '20000', 'Chuwez', '2025-05-31 22:10:01'),
('4459', 'KK10100320250531151243', '1446-12-03', '5.520.42', '101', 'Air galon dan gorengan dan cilok', '30000', '0', 'Chuwez', '2025-05-31 15:14:18'),
('4460', 'KK10100320250531151243', '1446-12-03', '1.100.10', '101', 'Air galon dan gorengan dan cilok', '0', '30000', 'Chuwez', '2025-05-31 15:14:18'),
('4461', 'D110100220250601053905', '1446-12-04', '1.100.10', '101', 'Bayar lunas[AHMADA KEVIN AINUN NAIM]', '35000', '0', 'Ipul', '2025-06-01 12:39:05'),
('4462', 'D110100220250601053905', '1446-12-04', '4.400.22', '101', 'Bayar lunas[AHMADA KEVIN AINUN NAIM]', '0', '35000', 'Ipul', '2025-06-01 12:39:05'),
('4463', 'ST10100320250601074304', '1446-12-04', '1.100.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '10000', '0', 'Chuwez', '2025-06-01 21:43:04'),
('4464', 'ST10100320250601074304', '1446-12-04', '2.220.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '0', '10000', 'Chuwez', '2025-06-01 21:43:04'),
('4465', 'ST10100320250601074322', '1446-12-04', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '5000', '0', 'Chuwez', '2025-06-01 21:43:22'),
('4466', 'ST10100320250601074322', '1446-12-04', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '5000', 'Chuwez', '2025-06-01 21:43:22'),
('4467', 'ST10100320250601074338', '1446-12-04', '1.100.10', '101', 'an.AULIA AZZAHRA', '5000', '0', 'Chuwez', '2025-06-01 21:43:38'),
('4468', 'ST10100320250601074338', '1446-12-04', '2.220.10', '101', 'an.AULIA AZZAHRA', '0', '5000', 'Chuwez', '2025-06-01 21:43:38'),
('4469', 'ST10100320250601074357', '1446-12-04', '1.100.10', '101', 'an.SITI SHOFIYAH LABIBAH', '10000', '0', 'Chuwez', '2025-06-01 21:43:57'),
('4470', 'ST10100320250601074357', '1446-12-04', '2.220.10', '101', 'an.SITI SHOFIYAH LABIBAH', '0', '10000', 'Chuwez', '2025-06-01 21:43:57'),
('4471', 'ST10100320250601074418', '1446-12-04', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'Chuwez', '2025-06-01 21:44:18'),
('4472', 'ST10100320250601074418', '1446-12-04', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'Chuwez', '2025-06-01 21:44:18'),
('4473', 'ST10100320250601074438', '1446-12-04', '1.100.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '10000', '0', 'Chuwez', '2025-06-01 21:44:38'),
('4474', 'ST10100320250601074438', '1446-12-04', '2.220.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '0', '10000', 'Chuwez', '2025-06-01 21:44:38'),
('4475', 'ST10100320250601074455', '1446-12-04', '1.100.10', '101', 'an.HAIKAL SHOMADANI', '2000', '0', 'Chuwez', '2025-06-01 21:44:55'),
('4476', 'ST10100320250601074455', '1446-12-04', '2.220.10', '101', 'an.HAIKAL SHOMADANI', '0', '2000', 'Chuwez', '2025-06-01 21:44:55'),
('4477', 'ST10100320250601074511', '1446-12-04', '1.100.10', '101', 'an.M. ABD. HADI', '2000', '0', 'Chuwez', '2025-06-01 21:45:11'),
('4478', 'ST10100320250601074511', '1446-12-04', '2.220.10', '101', 'an.M. ABD. HADI', '0', '2000', 'Chuwez', '2025-06-01 21:45:11'),
('4479', 'ST10100320250601074528', '1446-12-04', '1.100.10', '101', 'an.NAURA BILADINA', '6000', '0', 'Chuwez', '2025-06-01 21:45:28'),
('4480', 'ST10100320250601074528', '1446-12-04', '2.220.10', '101', 'an.NAURA BILADINA', '0', '6000', 'Chuwez', '2025-06-01 21:45:28'),
('4481', 'ST10100220250601081622', '1446-12-04', '1.100.10', '101', 'an.MASRUROTUL MAULUDIYAH', '10000', '0', 'Ipul', '2025-06-01 22:16:22'),
('4482', 'ST10100220250601081622', '1446-12-04', '2.220.10', '101', 'an.MASRUROTUL MAULUDIYAH', '0', '10000', 'Ipul', '2025-06-01 22:16:22'),
('4483', 'ST10100220250601081642', '1446-12-04', '1.100.10', '101', 'an.AHMAD ADITIYA', '4000', '0', 'Ipul', '2025-06-01 22:16:42'),
('4484', 'ST10100220250601081642', '1446-12-04', '2.220.10', '101', 'an.AHMAD ADITIYA', '0', '4000', 'Ipul', '2025-06-01 22:16:42'),
('4485', 'ST10100220250601081706', '1446-12-04', '1.100.10', '101', 'an.AISYAH', '5000', '0', 'Ipul', '2025-06-01 22:17:06'),
('4486', 'ST10100220250601081706', '1446-12-04', '2.220.10', '101', 'an.AISYAH', '0', '5000', 'Ipul', '2025-06-01 22:17:06'),
('4487', 'ST10100220250601081729', '1446-12-04', '1.100.10', '101', 'an.M. DESTRA MAULANA', '20000', '0', 'Ipul', '2025-06-01 22:17:29'),
('4488', 'ST10100220250601081729', '1446-12-04', '2.220.10', '101', 'an.M. DESTRA MAULANA', '0', '20000', 'Ipul', '2025-06-01 22:17:29'),
('4489', 'ST10100220250601081748', '1446-12-04', '1.100.10', '101', 'an.AZKA AUFARIL MINAN', '10000', '0', 'Ipul', '2025-06-01 22:17:48'),
('4490', 'ST10100220250601081748', '1446-12-04', '2.220.10', '101', 'an.AZKA AUFARIL MINAN', '0', '10000', 'Ipul', '2025-06-01 22:17:48'),
('4491', 'ST10100220250601081818', '1446-12-04', '1.100.10', '101', 'an.SITI ATHIUR ROHMAH', '5000', '0', 'Ipul', '2025-06-01 22:18:18'),
('4492', 'ST10100220250601081818', '1446-12-04', '2.220.10', '101', 'an.SITI ATHIUR ROHMAH', '0', '5000', 'Ipul', '2025-06-01 22:18:18'),
('4493', 'ST10100220250601081850', '1446-12-04', '1.100.10', '101', 'an.SITI QURROTUL AINI', '2000', '0', 'Ipul', '2025-06-01 22:18:50'),
('4494', 'ST10100220250601081850', '1446-12-04', '2.220.10', '101', 'an.SITI QURROTUL AINI', '0', '2000', 'Ipul', '2025-06-01 22:18:51'),
('4495', 'ST10100220250601081911', '1446-12-04', '1.100.10', '101', 'an.AHMAD SYAHRU ROMADHONI', '10000', '0', 'Ipul', '2025-06-01 22:19:11'),
('4496', 'ST10100220250601081911', '1446-12-04', '2.220.10', '101', 'an.AHMAD SYAHRU ROMADHONI', '0', '10000', 'Ipul', '2025-06-01 22:19:11'),
('4497', 'ST10100220250601081932', '1446-12-04', '1.100.10', '101', 'an.M. FAHMI NURUL ANAM', '20000', '0', 'Ipul', '2025-06-01 22:19:32'),
('4498', 'ST10100220250601081932', '1446-12-04', '2.220.10', '101', 'an.M. FAHMI NURUL ANAM', '0', '20000', 'Ipul', '2025-06-01 22:19:32'),
('4499', 'ST10100220250601082002', '1446-12-04', '1.100.10', '101', 'an.WARDATUL JANNAH', '2000', '0', 'Ipul', '2025-06-01 22:20:02'),
('4500', 'ST10100220250601082002', '1446-12-04', '2.220.10', '101', 'an.WARDATUL JANNAH', '0', '2000', 'Ipul', '2025-06-01 22:20:02'),
('4501', 'ST10100320250601082013', '1446-12-04', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '2000', '0', 'Chuwez', '2025-06-01 22:20:13'),
('4502', 'ST10100320250601082013', '1446-12-04', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '2000', 'Chuwez', '2025-06-01 22:20:13'),
('4503', 'ST10100220250601082021', '1446-12-04', '1.100.10', '101', 'an.DIYANAH KAMALIYAH', '2000', '0', 'Ipul', '2025-06-01 22:20:21'),
('4504', 'ST10100220250601082021', '1446-12-04', '2.220.10', '101', 'an.DIYANAH KAMALIYAH', '0', '2000', 'Ipul', '2025-06-01 22:20:21'),
('4505', 'ST10100320250601082032', '1446-12-04', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '5000', '0', 'Chuwez', '2025-06-01 22:20:32'),
('4506', 'ST10100320250601082032', '1446-12-04', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '5000', 'Chuwez', '2025-06-01 22:20:32'),
('4507', 'ST10100320250601082046', '1446-12-04', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Chuwez', '2025-06-01 22:20:46'),
('4508', 'ST10100320250601082046', '1446-12-04', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Chuwez', '2025-06-01 22:20:46'),
('4509', 'ST10100220250601082048', '1446-12-04', '1.100.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '10000', '0', 'Ipul', '2025-06-01 22:20:48'),
('4510', 'ST10100220250601082048', '1446-12-04', '2.220.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '0', '10000', 'Ipul', '2025-06-01 22:20:48'),
('4511', 'ST10100220250601082107', '1446-12-04', '1.100.10', '101', 'an.AHMAD RAFI SALIM', '10000', '0', 'Ipul', '2025-06-01 22:21:07'),
('4512', 'ST10100220250601082107', '1446-12-04', '2.220.10', '101', 'an.AHMAD RAFI SALIM', '0', '10000', 'Ipul', '2025-06-01 22:21:07'),
('4513', 'ST10100320250601082109', '1446-12-04', '1.100.10', '101', 'an.NABILATUN NISAUL UMMAH', '20000', '0', 'Chuwez', '2025-06-01 22:21:09'),
('4514', 'ST10100320250601082109', '1446-12-04', '2.220.10', '101', 'an.NABILATUN NISAUL UMMAH', '0', '20000', 'Chuwez', '2025-06-01 22:21:10'),
('4515', 'ST10100220250601082131', '1446-12-04', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '10000', '0', 'Ipul', '2025-06-01 22:21:31'),
('4516', 'ST10100220250601082131', '1446-12-04', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '10000', 'Ipul', '2025-06-01 22:21:31'),
('4517', 'ST10100320250601082133', '1446-12-04', '1.100.10', '101', 'an.M. KAMALUDDIN', '10000', '0', 'Chuwez', '2025-06-01 22:21:33'),
('4518', 'ST10100320250601082133', '1446-12-04', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '10000', 'Chuwez', '2025-06-01 22:21:33'),
('4519', 'ST10100320250601082148', '1446-12-04', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '10000', '0', 'Chuwez', '2025-06-01 22:21:48'),
('4520', 'ST10100320250601082148', '1446-12-04', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '10000', 'Chuwez', '2025-06-01 22:21:48'),
('4521', 'ST10100220250601082150', '1446-12-04', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '5000', '0', 'Ipul', '2025-06-01 22:21:50'),
('4522', 'ST10100220250601082150', '1446-12-04', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '5000', 'Ipul', '2025-06-01 22:21:50'),
('4523', 'ST10100320250601082206', '1446-12-04', '1.100.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '10000', '0', 'Chuwez', '2025-06-01 22:22:06'),
('4524', 'ST10100320250601082206', '1446-12-04', '2.220.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '0', '10000', 'Chuwez', '2025-06-01 22:22:06'),
('4525', 'ST10100220250601082210', '1446-12-04', '1.100.10', '101', 'an.M. ZIDAN RIZQI SALIM', '5000', '0', 'Ipul', '2025-06-01 22:22:10'),
('4526', 'ST10100220250601082210', '1446-12-04', '2.220.10', '101', 'an.M. ZIDAN RIZQI SALIM', '0', '5000', 'Ipul', '2025-06-01 22:22:10'),
('4527', 'ST10100220250601082228', '1446-12-04', '1.100.10', '101', 'an.SAFIRATUL JANNAH', '10000', '0', 'Ipul', '2025-06-01 22:22:28'),
('4528', 'ST10100220250601082228', '1446-12-04', '2.220.10', '101', 'an.SAFIRATUL JANNAH', '0', '10000', 'Ipul', '2025-06-01 22:22:28'),
('4529', 'ST10100320250601082242', '1446-12-04', '1.100.10', '101', 'an.M. HAIKAL NASRULLOH', '5000', '0', 'Chuwez', '2025-06-01 22:22:42'),
('4530', 'ST10100320250601082242', '1446-12-04', '2.220.10', '101', 'an.M. HAIKAL NASRULLOH', '0', '5000', 'Chuwez', '2025-06-01 22:22:42'),
('4531', 'ST10100320250601082259', '1446-12-04', '1.100.10', '101', 'an.AHMAD ABBAS MAULANA', '3000', '0', 'Chuwez', '2025-06-01 22:22:59'),
('4532', 'ST10100320250601082259', '1446-12-04', '2.220.10', '101', 'an.AHMAD ABBAS MAULANA', '0', '3000', 'Chuwez', '2025-06-01 22:22:59'),
('4533', 'ST10100320250601082322', '1446-12-04', '1.100.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '10000', '0', 'Chuwez', '2025-06-01 22:23:22'),
('4534', 'ST10100320250601082322', '1446-12-04', '2.220.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '0', '10000', 'Chuwez', '2025-06-01 22:23:22'),
('4535', 'ST10100220250601082325', '1446-12-04', '1.100.10', '101', 'an.AFANDI', '2000', '0', 'Ipul', '2025-06-01 22:23:25'),
('4536', 'ST10100220250601082325', '1446-12-04', '2.220.10', '101', 'an.AFANDI', '0', '2000', 'Ipul', '2025-06-01 22:23:25'),
('4537', 'ST10100320250601082337', '1446-12-04', '1.100.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '5000', '0', 'Chuwez', '2025-06-01 22:23:37'),
('4538', 'ST10100320250601082337', '1446-12-04', '2.220.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '0', '5000', 'Chuwez', '2025-06-01 22:23:37'),
('4539', 'ST10100320250601082354', '1446-12-04', '1.100.10', '101', 'an.M. ROFIQ HIDAYATULLOH', '10000', '0', 'Chuwez', '2025-06-01 22:23:54'),
('4540', 'ST10100320250601082354', '1446-12-04', '2.220.10', '101', 'an.M. ROFIQ HIDAYATULLOH', '0', '10000', 'Chuwez', '2025-06-01 22:23:54'),
('4541', 'ST10100220250601082404', '1446-12-04', '1.100.10', '101', 'an.ROBIATUL ADAWIYAH', '5000', '0', 'Ipul', '2025-06-01 22:24:04'),
('4542', 'ST10100220250601082404', '1446-12-04', '2.220.10', '101', 'an.ROBIATUL ADAWIYAH', '0', '5000', 'Ipul', '2025-06-01 22:24:04'),
('4543', 'ST10100320250601082415', '1446-12-04', '1.100.10', '101', 'an.AKHMAD FIKRI HAIKAL', '100000', '0', 'Chuwez', '2025-06-01 22:24:15'),
('4544', 'ST10100320250601082415', '1446-12-04', '2.220.10', '101', 'an.AKHMAD FIKRI HAIKAL', '0', '100000', 'Chuwez', '2025-06-01 22:24:15'),
('4545', 'ST10100220250601082427', '1446-12-04', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '10000', '0', 'Ipul', '2025-06-01 22:24:27'),
('4546', 'ST10100220250601082427', '1446-12-04', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '10000', 'Ipul', '2025-06-01 22:24:27'),
('4547', 'ST10100320250601082434', '1446-12-04', '1.100.10', '101', 'an.SINDI RAISA PUTRI', '10000', '0', 'Chuwez', '2025-06-01 22:24:34'),
('4548', 'ST10100320250601082434', '1446-12-04', '2.220.10', '101', 'an.SINDI RAISA PUTRI', '0', '10000', 'Chuwez', '2025-06-01 22:24:35'),
('4549', 'ST10100220250601082448', '1446-12-04', '1.100.10', '101', 'an.ZAKIYATUL UMMAH', '2000', '0', 'Ipul', '2025-06-01 22:24:48'),
('4550', 'ST10100220250601082448', '1446-12-04', '2.220.10', '101', 'an.ZAKIYATUL UMMAH', '0', '2000', 'Ipul', '2025-06-01 22:24:48'),
('4551', 'ST10100320250601082459', '1446-12-04', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '25000', '0', 'Chuwez', '2025-06-01 22:24:59'),
('4552', 'ST10100320250601082459', '1446-12-04', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '25000', 'Chuwez', '2025-06-01 22:24:59'),
('4553', 'ST10100220250601082507', '1446-12-04', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '5000', '0', 'Ipul', '2025-06-01 22:25:07'),
('4554', 'ST10100220250601082507', '1446-12-04', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '5000', 'Ipul', '2025-06-01 22:25:07'),
('4555', 'ST10100220250601082525', '1446-12-04', '1.100.10', '101', 'an.ANA SALSABILA', '7000', '0', 'Ipul', '2025-06-01 22:25:25'),
('4556', 'ST10100220250601082525', '1446-12-04', '2.220.10', '101', 'an.ANA SALSABILA', '0', '7000', 'Ipul', '2025-06-01 22:25:25'),
('4557', 'ST10100320250601082526', '1446-12-04', '1.100.10', '101', 'an.M. ABDIL ARIKIN', '5000', '0', 'Chuwez', '2025-06-01 22:25:26'),
('4558', 'ST10100320250601082526', '1446-12-04', '2.220.10', '101', 'an.M. ABDIL ARIKIN', '0', '5000', 'Chuwez', '2025-06-01 22:25:26'),
('4559', 'ST10100220250601082541', '1446-12-04', '1.100.10', '101', 'an.M. ALIFIN FIKRI', '2000', '0', 'Ipul', '2025-06-01 22:25:41'),
('4560', 'ST10100220250601082541', '1446-12-04', '2.220.10', '101', 'an.M. ALIFIN FIKRI', '0', '2000', 'Ipul', '2025-06-01 22:25:41'),
('4561', 'ST10100320250601082547', '1446-12-04', '1.100.10', '101', 'an.NAILATUN NIAMI', '2000', '0', 'Chuwez', '2025-06-01 22:25:47'),
('4562', 'ST10100320250601082547', '1446-12-04', '2.220.10', '101', 'an.NAILATUN NIAMI', '0', '2000', 'Chuwez', '2025-06-01 22:25:47'),
('4563', 'ST10100320250601082611', '1446-12-04', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'Chuwez', '2025-06-01 22:26:11'),
('4564', 'ST10100320250601082611', '1446-12-04', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'Chuwez', '2025-06-01 22:26:11'),
('4565', 'ST10100320250601082629', '1446-12-04', '1.100.10', '101', 'an.UBAIDAH', '20000', '0', 'Chuwez', '2025-06-01 22:26:29'),
('4566', 'ST10100320250601082629', '1446-12-04', '2.220.10', '101', 'an.UBAIDAH', '0', '20000', 'Chuwez', '2025-06-01 22:26:29'),
('4567', 'ST10100320250601082645', '1446-12-04', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '5000', '0', 'Chuwez', '2025-06-01 22:26:45'),
('4568', 'ST10100320250601082645', '1446-12-04', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '5000', 'Chuwez', '2025-06-01 22:26:45'),
('4569', 'ST10100320250601082706', '1446-12-04', '1.100.10', '101', 'an.MARIATUL QIBTIYAH', '2000', '0', 'Chuwez', '2025-06-01 22:27:06'),
('4570', 'ST10100320250601082706', '1446-12-04', '2.220.10', '101', 'an.MARIATUL QIBTIYAH', '0', '2000', 'Chuwez', '2025-06-01 22:27:06'),
('4571', 'ST10100320250601082725', '1446-12-04', '1.100.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '4000', '0', 'Chuwez', '2025-06-01 22:27:25'),
('4572', 'ST10100320250601082725', '1446-12-04', '2.220.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '0', '4000', 'Chuwez', '2025-06-01 22:27:25'),
('4573', 'ST10100320250601082742', '1446-12-04', '1.100.10', '101', 'an.RAISA ANNISA', '5000', '0', 'Chuwez', '2025-06-01 22:27:42'),
('4574', 'ST10100320250601082742', '1446-12-04', '2.220.10', '101', 'an.RAISA ANNISA', '0', '5000', 'Chuwez', '2025-06-01 22:27:42'),
('4575', 'ST10100320250601082755', '1446-12-04', '1.100.10', '101', 'an.MARIYATUL QIBTIYAH', '5000', '0', 'Chuwez', '2025-06-01 22:27:55'),
('4576', 'ST10100320250601082755', '1446-12-04', '2.220.10', '101', 'an.MARIYATUL QIBTIYAH', '0', '5000', 'Chuwez', '2025-06-01 22:27:55'),
('4577', 'ST10100320250601082812', '1446-12-04', '1.100.10', '101', 'an.MUHAMMAD ALWI', '10000', '0', 'Chuwez', '2025-06-01 22:28:12'),
('4578', 'ST10100320250601082812', '1446-12-04', '2.220.10', '101', 'an.MUHAMMAD ALWI', '0', '10000', 'Chuwez', '2025-06-01 22:28:12'),
('4579', 'ST10100320250601082826', '1446-12-04', '1.100.10', '101', 'an.UMAR FARUQ', '10000', '0', 'Chuwez', '2025-06-01 22:28:26'),
('4580', 'ST10100320250601082826', '1446-12-04', '2.220.10', '101', 'an.UMAR FARUQ', '0', '10000', 'Chuwez', '2025-06-01 22:28:26'),
('4581', 'ST10100320250601082843', '1446-12-04', '1.100.10', '101', 'an.FAIZAH NURUL LITA', '5000', '0', 'Chuwez', '2025-06-01 22:28:43'),
('4582', 'ST10100320250601082843', '1446-12-04', '2.220.10', '101', 'an.FAIZAH NURUL LITA', '0', '5000', 'Chuwez', '2025-06-01 22:28:43'),
('4583', 'ST10100320250601082901', '1446-12-04', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'Chuwez', '2025-06-01 22:29:01'),
('4584', 'ST10100320250601082901', '1446-12-04', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'Chuwez', '2025-06-01 22:29:02'),
('4585', 'ST10100320250601082922', '1446-12-04', '1.100.10', '101', 'an.HALIMAH', '5000', '0', 'Chuwez', '2025-06-01 22:29:22'),
('4586', 'ST10100320250601082922', '1446-12-04', '2.220.10', '101', 'an.HALIMAH', '0', '5000', 'Chuwez', '2025-06-01 22:29:22'),
('4587', 'ST10100320250601082942', '1446-12-04', '1.100.10', '101', 'an.HILYA', '20000', '0', 'Chuwez', '2025-06-01 22:29:42'),
('4588', 'ST10100320250601082942', '1446-12-04', '2.220.10', '101', 'an.HILYA', '0', '20000', 'Chuwez', '2025-06-01 22:29:42'),
('4589', 'ST10100320250601083003', '1446-12-04', '1.100.10', '101', 'an.UST THORIQUL HUDA', '50000', '0', 'Chuwez', '2025-06-01 22:30:03'),
('4590', 'ST10100320250601083003', '1446-12-04', '2.220.10', '101', 'an.UST THORIQUL HUDA', '0', '50000', 'Chuwez', '2025-06-01 22:30:03'),
('4591', 'ST10100320250601083117', '1446-12-04', '1.100.10', '101', 'an.AMARA', '10000', '0', 'Chuwez', '2025-06-01 22:31:17'),
('4592', 'ST10100320250601083117', '1446-12-04', '2.220.10', '101', 'an.AMARA', '0', '10000', 'Chuwez', '2025-06-01 22:31:17'),
('4593', 'BS10100220250601083254000', '1446-11-04', '1.100.10', '101', 'Bayar[SITI KARIMATIN NISAK]', '30000', '0', 'Ipul', '2025-06-01 15:32:54'),
('4594', 'BS10100220250601083254000', '1446-11-04', '4.400.20', '101', 'Bayar[SITI KARIMATIN NISAK]', '0', '30000', 'Ipul', '2025-06-01 15:32:54'),
('4595', 'BS10100220250601083254001', '1446-12-04', '1.100.10', '101', 'Bayar[SITI KARIMATIN NISAK]', '30000', '0', 'Ipul', '2025-06-01 15:32:54'),
('4596', 'BS10100220250601083254001', '1446-12-04', '4.400.20', '101', 'Bayar[SITI KARIMATIN NISAK]', '0', '30000', 'Ipul', '2025-06-01 15:32:54'),
('4597', 'BS10100220250601083347000', '1446-11-04', '1.100.10', '101', 'Bayar[FAIZAH NURUL LITA]', '30000', '0', 'Ipul', '2025-06-01 15:33:47'),
('4598', 'BS10100220250601083347000', '1446-11-04', '4.400.20', '101', 'Bayar[FAIZAH NURUL LITA]', '0', '30000', 'Ipul', '2025-06-01 15:33:47'),
('4599', 'BS10100220250601083347001', '1446-12-04', '1.100.10', '101', 'Bayar[FAIZAH NURUL LITA]', '30000', '0', 'Ipul', '2025-06-01 15:33:47'),
('4600', 'BS10100220250601083347001', '1446-12-04', '4.400.20', '101', 'Bayar[FAIZAH NURUL LITA]', '0', '30000', 'Ipul', '2025-06-01 15:33:47'),
('4601', 'D110100320250601083837', '1446-12-04', '1.100.10', '101', 'Bayar[SITI ATHIUR ROHMAH]', '35000', '0', 'Chuwez', '2025-06-01 15:38:37'),
('4602', 'D110100320250601083837', '1446-12-04', '4.400.22', '101', 'Bayar[SITI ATHIUR ROHMAH]', '0', '35000', 'Chuwez', '2025-06-01 15:38:37'),
('4603', 'D110100320250601083914', '1446-12-04', '1.100.10', '101', 'Bayar[AZKA AUFARIL MINAN]', '35000', '0', 'Chuwez', '2025-06-01 15:39:14'),
('4604', 'D110100320250601083914', '1446-12-04', '4.400.22', '101', 'Bayar[AZKA AUFARIL MINAN]', '0', '35000', 'Chuwez', '2025-06-01 15:39:14'),
('4605', 'D110100320250601083947', '1446-12-04', '1.100.10', '101', 'Bayar[MUCHAMAD RAFIE FAWWAZI]', '20000', '0', 'Chuwez', '2025-06-01 15:39:47'),
('4606', 'D110100320250601083947', '1446-12-04', '4.400.22', '101', 'Bayar[MUCHAMAD RAFIE FAWWAZI]', '0', '20000', 'Chuwez', '2025-06-01 15:39:47'),
('4607', 'BS10100220250601085209000', '1446-11-04', '1.100.10', '101', 'Bayar[MUCHAMAD RAFIE FAWWAZI]', '30000', '0', 'Ipul', '2025-06-01 15:52:09'),
('4608', 'BS10100220250601085209000', '1446-11-04', '4.400.20', '101', 'Bayar[MUCHAMAD RAFIE FAWWAZI]', '0', '30000', 'Ipul', '2025-06-01 15:52:09'),
('4609', 'BS10100220250601085209001', '1446-12-04', '1.100.10', '101', 'Bayar[MUCHAMAD RAFIE FAWWAZI]', '30000', '0', 'Ipul', '2025-06-01 15:52:09'),
('4610', 'BS10100220250601085209001', '1446-12-04', '4.400.20', '101', 'Bayar[MUCHAMAD RAFIE FAWWAZI]', '0', '30000', 'Ipul', '2025-06-01 15:52:09'),
('4611', 'BS10100220250601085238000', '1446-11-04', '1.100.10', '101', 'Bayar[ROBIATUL ADAWIYAH]', '30000', '0', 'Ipul', '2025-06-01 15:52:38'),
('4612', 'BS10100220250601085238000', '1446-11-04', '4.400.20', '101', 'Bayar[ROBIATUL ADAWIYAH]', '0', '30000', 'Ipul', '2025-06-01 15:52:38'),
('4613', 'BS10100220250601085558000', '1446-12-04', '1.100.10', '101', 'Bayar[SITI ATHIUR ROHMAH]', '30000', '0', 'Ipul', '2025-06-01 15:55:58'),
('4614', 'BS10100220250601085558000', '1446-12-04', '4.400.20', '101', 'Bayar[SITI ATHIUR ROHMAH]', '0', '30000', 'Ipul', '2025-06-01 15:55:58'),
('4615', 'BS10100220250601085638000', '1446-11-04', '1.100.10', '101', 'Bayar[RAISA ANNISA]', '30000', '0', 'Ipul', '2025-06-01 15:56:38'),
('4616', 'BS10100220250601085638000', '1446-11-04', '4.400.20', '101', 'Bayar[RAISA ANNISA]', '0', '30000', 'Ipul', '2025-06-01 15:56:38'),
('4617', 'KI10100220250601090013', '1446-12-04', '1.100.10', '101', 'Bayar[M.AKMALUL HIMAM]', '95000', '0', 'Ipul', '2025-06-01 16:00:13'),
('4618', 'KI10100220250601090013', '1446-12-04', '4.400.21', '101', 'Bayar[M.AKMALUL HIMAM]', '0', '95000', 'Ipul', '2025-06-01 16:00:13'),
('4619', 'ST10100320250602062125', '1446-12-05', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '30000', '0', 'Chuwez', '2025-06-02 20:21:25'),
('4620', 'ST10100320250602062125', '1446-12-05', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '30000', 'Chuwez', '2025-06-02 20:21:26'),
('4621', 'ST10100320250602062154', '1446-12-05', '1.100.10', '101', 'an.SINDI RAISA PUTRI', '10000', '0', 'Chuwez', '2025-06-02 20:21:54'),
('4622', 'ST10100320250602062154', '1446-12-05', '2.220.10', '101', 'an.SINDI RAISA PUTRI', '0', '10000', 'Chuwez', '2025-06-02 20:21:54'),
('4623', 'ST10100320250602062216', '1446-12-05', '1.100.10', '101', 'an.AKHMAD FIKRI HAIKAL', '100000', '0', 'Chuwez', '2025-06-02 20:22:16'),
('4624', 'ST10100320250602062216', '1446-12-05', '2.220.10', '101', 'an.AKHMAD FIKRI HAIKAL', '0', '100000', 'Chuwez', '2025-06-02 20:22:16'),
('4625', 'ST10100320250602062245', '1446-12-05', '1.100.10', '101', 'an.M. ROFIQ', '15000', '0', 'Chuwez', '2025-06-02 20:22:45'),
('4626', 'ST10100320250602062245', '1446-12-05', '2.220.10', '101', 'an.M. ROFIQ', '0', '15000', 'Chuwez', '2025-06-02 20:22:45'),
('4627', 'ST10100320250602062305', '1446-12-05', '1.100.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '5000', '0', 'Chuwez', '2025-06-02 20:23:05'),
('4628', 'ST10100320250602062305', '1446-12-05', '2.220.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '0', '5000', 'Chuwez', '2025-06-02 20:23:05'),
('4629', 'ST10100320250602062347', '1446-12-05', '1.100.10', '101', 'an.NABILATUN NISAUL UMMAH', '20000', '0', 'Chuwez', '2025-06-02 20:23:47'),
('4630', 'ST10100320250602062347', '1446-12-05', '2.220.10', '101', 'an.NABILATUN NISAUL UMMAH', '0', '20000', 'Chuwez', '2025-06-02 20:23:47'),
('4631', 'ST10100320250602062408', '1446-12-05', '1.100.10', '101', 'an.MIFTAHUL JANNAH', '100000', '0', 'Chuwez', '2025-06-02 20:24:08'),
('4632', 'ST10100320250602062408', '1446-12-05', '2.220.10', '101', 'an.MIFTAHUL JANNAH', '0', '100000', 'Chuwez', '2025-06-02 20:24:08'),
('4633', 'ST10100320250602062433', '1446-12-05', '1.100.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '10000', '0', 'Chuwez', '2025-06-02 20:24:33'),
('4634', 'ST10100320250602062433', '1446-12-05', '2.220.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '0', '10000', 'Chuwez', '2025-06-02 20:24:33'),
('4635', 'ST10100320250602062457', '1446-12-05', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '5000', '0', 'Chuwez', '2025-06-02 20:24:57'),
('4636', 'ST10100320250602062457', '1446-12-05', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '5000', 'Chuwez', '2025-06-02 20:24:57'),
('4637', 'ST10100320250602062534', '1446-12-05', '1.100.10', '101', 'an.M. KAMALUDDIN', '10000', '0', 'Chuwez', '2025-06-02 20:25:34'),
('4638', 'ST10100320250602062534', '1446-12-05', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '10000', 'Chuwez', '2025-06-02 20:25:34'),
('4639', 'ST10100320250602062555', '1446-12-05', '1.100.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '10000', '0', 'Chuwez', '2025-06-02 20:25:55'),
('4640', 'ST10100320250602062555', '1446-12-05', '2.220.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '0', '10000', 'Chuwez', '2025-06-02 20:25:55'),
('4641', 'ST10100320250602062617', '1446-12-05', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '10000', '0', 'Chuwez', '2025-06-02 20:26:17'),
('4642', 'ST10100320250602062617', '1446-12-05', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '10000', 'Chuwez', '2025-06-02 20:26:17'),
('4643', 'ST10100320250602062651', '1446-12-05', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '2000', '0', 'Chuwez', '2025-06-02 20:26:51'),
('4644', 'ST10100320250602062651', '1446-12-05', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '2000', 'Chuwez', '2025-06-02 20:26:51'),
('4645', 'ST10100320250602062805', '1446-12-05', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Chuwez', '2025-06-02 20:28:05'),
('4646', 'ST10100320250602062805', '1446-12-05', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Chuwez', '2025-06-02 20:28:06'),
('4647', 'ST10100320250602072849', '1446-12-05', '1.100.10', '101', 'an.BILQIS THALIA HASNA', '175000', '0', 'Chuwez', '2025-06-02 21:28:49'),
('4648', 'ST10100320250602072849', '1446-12-05', '2.220.10', '101', 'an.BILQIS THALIA HASNA', '0', '175000', 'Chuwez', '2025-06-02 21:28:49'),
('4649', 'ST10100320250602073009', '1446-12-05', '1.100.10', '101', 'an.SITI SHOFIYAH LABIBAH', '20000', '0', 'Chuwez', '2025-06-02 21:30:09'),
('4650', 'ST10100320250602073009', '1446-12-05', '2.220.10', '101', 'an.SITI SHOFIYAH LABIBAH', '0', '20000', 'Chuwez', '2025-06-02 21:30:09'),
('4651', 'ST10100320250602073027', '1446-12-05', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '10000', '0', 'Chuwez', '2025-06-02 21:30:27'),
('4652', 'ST10100320250602073027', '1446-12-05', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '10000', 'Chuwez', '2025-06-02 21:30:27'),
('4653', 'ST10100320250602073048', '1446-12-05', '1.100.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '10000', '0', 'Chuwez', '2025-06-02 21:30:48'),
('4654', 'ST10100320250602073048', '1446-12-05', '2.220.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '0', '10000', 'Chuwez', '2025-06-02 21:30:48'),
('4655', 'ST10100320250602073106', '1446-12-05', '1.100.10', '101', 'an.NAURA BILADINA', '5000', '0', 'Chuwez', '2025-06-02 21:31:06'),
('4656', 'ST10100320250602073106', '1446-12-05', '2.220.10', '101', 'an.NAURA BILADINA', '0', '5000', 'Chuwez', '2025-06-02 21:31:06'),
('4657', 'ST10100320250602073125', '1446-12-05', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'Chuwez', '2025-06-02 21:31:25'),
('4658', 'ST10100320250602073125', '1446-12-05', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'Chuwez', '2025-06-02 21:31:26'),
('4659', 'ST10100320250602073215', '1446-12-05', '1.100.10', '101', 'an.HAIKAL SHOMADANI', '2000', '0', 'Chuwez', '2025-06-02 21:32:15'),
('4660', 'ST10100320250602073215', '1446-12-05', '2.220.10', '101', 'an.HAIKAL SHOMADANI', '0', '2000', 'Chuwez', '2025-06-02 21:32:15'),
('4661', 'ST10100320250602073245', '1446-12-05', '1.100.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '10000', '0', 'Chuwez', '2025-06-02 21:32:45'),
('4662', 'ST10100320250602073245', '1446-12-05', '2.220.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '0', '10000', 'Chuwez', '2025-06-02 21:32:45'),
('4663', 'ST10100320250602073307', '1446-12-05', '1.100.10', '101', 'an.M. ABD. HADI', '2000', '0', 'Chuwez', '2025-06-02 21:33:07'),
('4664', 'ST10100320250602073307', '1446-12-05', '2.220.10', '101', 'an.M. ABD. HADI', '0', '2000', 'Chuwez', '2025-06-02 21:33:07'),
('4665', 'ST10100320250602073349', '1446-12-05', '1.100.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '2000', '0', 'Chuwez', '2025-06-02 21:33:49'),
('4666', 'ST10100320250602073349', '1446-12-05', '2.220.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '0', '2000', 'Chuwez', '2025-06-02 21:33:49'),
('4667', 'ST10100320250602073621', '1446-12-05', '1.100.10', '101', 'an.MARIYATUL QIBTIYAH', '5000', '0', 'Chuwez', '2025-06-02 21:36:21'),
('4668', 'ST10100320250602073621', '1446-12-05', '2.220.10', '101', 'an.MARIYATUL QIBTIYAH', '0', '5000', 'Chuwez', '2025-06-02 21:36:21'),
('4669', 'ST10100320250602073720', '1446-12-05', '1.100.10', '101', 'an.UMAR FARUQ', '10000', '0', 'Chuwez', '2025-06-02 21:37:20'),
('4670', 'ST10100320250602073720', '1446-12-05', '2.220.10', '101', 'an.UMAR FARUQ', '0', '10000', 'Chuwez', '2025-06-02 21:37:20'),
('4671', 'ST10100320250602073743', '1446-12-05', '1.100.10', '101', 'an.NAILATUN NIAMI', '5000', '0', 'Chuwez', '2025-06-02 21:37:43'),
('4672', 'ST10100320250602073743', '1446-12-05', '2.220.10', '101', 'an.NAILATUN NIAMI', '0', '5000', 'Chuwez', '2025-06-02 21:37:43'),
('4673', 'ST10100320250602073801', '1446-12-05', '1.100.10', '101', 'an.MARIATUL QIBTIYAH', '2000', '0', 'Chuwez', '2025-06-02 21:38:01'),
('4674', 'ST10100320250602073801', '1446-12-05', '2.220.10', '101', 'an.MARIATUL QIBTIYAH', '0', '2000', 'Chuwez', '2025-06-02 21:38:01'),
('4675', 'ST10100320250602073817', '1446-12-05', '1.100.10', '101', 'an.MUHAMMAD ALWI', '10000', '0', 'Chuwez', '2025-06-02 21:38:17'),
('4676', 'ST10100320250602073817', '1446-12-05', '2.220.10', '101', 'an.MUHAMMAD ALWI', '0', '10000', 'Chuwez', '2025-06-02 21:38:17'),
('4677', 'ST10100320250602073848', '1446-12-05', '1.100.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '4000', '0', 'Chuwez', '2025-06-02 21:38:48'),
('4678', 'ST10100320250602073848', '1446-12-05', '2.220.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '0', '4000', 'Chuwez', '2025-06-02 21:38:48'),
('4679', 'ST10100320250602073926', '1446-12-05', '1.100.10', '101', 'an.FAIZAH NURUL LITA', '5000', '0', 'Chuwez', '2025-06-02 21:39:26'),
('4680', 'ST10100320250602073926', '1446-12-05', '2.220.10', '101', 'an.FAIZAH NURUL LITA', '0', '5000', 'Chuwez', '2025-06-02 21:39:26'),
('4681', 'ST10100320250602073952', '1446-12-05', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'Chuwez', '2025-06-02 21:39:52'),
('4682', 'ST10100320250602073952', '1446-12-05', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'Chuwez', '2025-06-02 21:39:52'),
('4683', 'ST10100320250602074017', '1446-12-05', '1.100.10', '101', 'an.ROHMATULLOH', '5000', '0', 'Chuwez', '2025-06-02 21:40:17'),
('4684', 'ST10100320250602074017', '1446-12-05', '2.220.10', '101', 'an.ROHMATULLOH', '0', '5000', 'Chuwez', '2025-06-02 21:40:17'),
('4685', 'ST10100320250602074049', '1446-12-05', '1.100.10', '101', 'an.MILLAH KAMILAH', '50000', '0', 'Chuwez', '2025-06-02 21:40:49'),
('4686', 'ST10100320250602074049', '1446-12-05', '2.220.10', '101', 'an.MILLAH KAMILAH', '0', '50000', 'Chuwez', '2025-06-02 21:40:49'),
('4687', 'ST10100320250602074121', '1446-12-05', '1.100.10', '101', 'an.UBAIDAH', '10000', '0', 'Chuwez', '2025-06-02 21:41:21'),
('4688', 'ST10100320250602074121', '1446-12-05', '2.220.10', '101', 'an.UBAIDAH', '0', '10000', 'Chuwez', '2025-06-02 21:41:21'),
('4689', 'ST10100320250602074149', '1446-12-05', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '5000', '0', 'Chuwez', '2025-06-02 21:41:49'),
('4690', 'ST10100320250602074149', '1446-12-05', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '5000', 'Chuwez', '2025-06-02 21:41:49'),
('4691', 'ST10100320250602074408', '1446-12-05', '1.100.10', '101', 'an.SAFIRATUL JANNAH', '10000', '0', 'Chuwez', '2025-06-02 21:44:08'),
('4692', 'ST10100320250602074408', '1446-12-05', '2.220.10', '101', 'an.SAFIRATUL JANNAH', '0', '10000', 'Chuwez', '2025-06-02 21:44:08'),
('4693', 'ST10100320250602074428', '1446-12-05', '1.100.10', '101', 'an.AHMAD ADITIYA', '2000', '0', 'Chuwez', '2025-06-02 21:44:28'),
('4694', 'ST10100320250602074428', '1446-12-05', '2.220.10', '101', 'an.AHMAD ADITIYA', '0', '2000', 'Chuwez', '2025-06-02 21:44:28'),
('4695', 'ST10100320250602074520', '1446-12-05', '1.100.10', '101', 'an.LAILATUL MAGHFIROH', '5000', '0', 'Chuwez', '2025-06-02 21:45:20'),
('4696', 'ST10100320250602074520', '1446-12-05', '2.220.10', '101', 'an.LAILATUL MAGHFIROH', '0', '5000', 'Chuwez', '2025-06-02 21:45:20'),
('4697', 'ST10100320250602074549', '1446-12-05', '1.100.10', '101', 'an.IFTITAHUL IZZA', '100000', '0', 'Chuwez', '2025-06-02 21:45:49'),
('4698', 'ST10100320250602074549', '1446-12-05', '2.220.10', '101', 'an.IFTITAHUL IZZA', '0', '100000', 'Chuwez', '2025-06-02 21:45:49'),
('4699', 'ST10100320250602074614', '1446-12-05', '1.100.10', '101', 'an.AISYAH', '4000', '0', 'Chuwez', '2025-06-02 21:46:14'),
('4700', 'ST10100320250602074614', '1446-12-05', '2.220.10', '101', 'an.AISYAH', '0', '4000', 'Chuwez', '2025-06-02 21:46:14'),
('4701', 'ST10100320250602074632', '1446-12-05', '1.100.10', '101', 'an.ALFI NURDIANA', '5000', '0', 'Chuwez', '2025-06-02 21:46:32'),
('4702', 'ST10100320250602074632', '1446-12-05', '2.220.10', '101', 'an.ALFI NURDIANA', '0', '5000', 'Chuwez', '2025-06-02 21:46:32'),
('4703', 'ST10100320250602074702', '1446-12-05', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '10000', '0', 'Chuwez', '2025-06-02 21:47:02'),
('4704', 'ST10100320250602074702', '1446-12-05', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '10000', 'Chuwez', '2025-06-02 21:47:02'),
('4705', 'ST10100320250602074726', '1446-12-05', '1.100.10', '101', 'an.AZKA AUFARIL MINAN', '10000', '0', 'Chuwez', '2025-06-02 21:47:26'),
('4706', 'ST10100320250602074726', '1446-12-05', '2.220.10', '101', 'an.AZKA AUFARIL MINAN', '0', '10000', 'Chuwez', '2025-06-02 21:47:26'),
('4707', 'ST10100320250602074813', '1446-12-05', '1.100.10', '101', 'an.M. FAHMI NURUL ANAM', '10000', '0', 'Chuwez', '2025-06-02 21:48:13'),
('4708', 'ST10100320250602074813', '1446-12-05', '2.220.10', '101', 'an.M. FAHMI NURUL ANAM', '0', '10000', 'Chuwez', '2025-06-02 21:48:13'),
('4709', 'ST10100320250602074841', '1446-12-05', '1.100.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '10000', '0', 'Chuwez', '2025-06-02 21:48:41'),
('4710', 'ST10100320250602074841', '1446-12-05', '2.220.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '0', '10000', 'Chuwez', '2025-06-02 21:48:41'),
('4711', 'ST10100320250602074902', '1446-12-05', '1.100.10', '101', 'an.WARDATUL JANNAH', '5000', '0', 'Chuwez', '2025-06-02 21:49:02'),
('4712', 'ST10100320250602074902', '1446-12-05', '2.220.10', '101', 'an.WARDATUL JANNAH', '0', '5000', 'Chuwez', '2025-06-02 21:49:02'),
('4713', 'ST10100320250602074925', '1446-12-05', '1.100.10', '101', 'an.DIYANAH KAMALIYAH', '2000', '0', 'Chuwez', '2025-06-02 21:49:25'),
('4714', 'ST10100320250602074925', '1446-12-05', '2.220.10', '101', 'an.DIYANAH KAMALIYAH', '0', '2000', 'Chuwez', '2025-06-02 21:49:25'),
('4715', 'ST10100320250602074939', '1446-12-05', '1.100.10', '101', 'an.SITI QURROTUL AINI', '2000', '0', 'Chuwez', '2025-06-02 21:49:39'),
('4716', 'ST10100320250602074939', '1446-12-05', '2.220.10', '101', 'an.SITI QURROTUL AINI', '0', '2000', 'Chuwez', '2025-06-02 21:49:39'),
('4717', 'ST10100320250602074958', '1446-12-05', '1.100.10', '101', 'an.ABDUL HAMID', '5000', '0', 'Chuwez', '2025-06-02 21:49:58'),
('4718', 'ST10100320250602074958', '1446-12-05', '2.220.10', '101', 'an.ABDUL HAMID', '0', '5000', 'Chuwez', '2025-06-02 21:49:58'),
('4719', 'ST10100320250602075020', '1446-12-05', '1.100.10', '101', 'an.SITI ATHIUR ROHMAH', '5000', '0', 'Chuwez', '2025-06-02 21:50:20'),
('4720', 'ST10100320250602075020', '1446-12-05', '2.220.10', '101', 'an.SITI ATHIUR ROHMAH', '0', '5000', 'Chuwez', '2025-06-02 21:50:20'),
('4721', 'ST10100320250602075131', '1446-12-05', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '10000', '0', 'Chuwez', '2025-06-02 21:51:31'),
('4722', 'ST10100320250602075131', '1446-12-05', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '10000', 'Chuwez', '2025-06-02 21:51:31'),
('4723', 'ST10100320250602075153', '1446-12-05', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '5000', '0', 'Chuwez', '2025-06-02 21:51:53'),
('4724', 'ST10100320250602075153', '1446-12-05', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '5000', 'Chuwez', '2025-06-02 21:51:53'),
('4725', 'ST10100320250602075219', '1446-12-05', '1.100.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '2000', '0', 'Chuwez', '2025-06-02 21:52:19'),
('4726', 'ST10100320250602075219', '1446-12-05', '2.220.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '0', '2000', 'Chuwez', '2025-06-02 21:52:19'),
('4727', 'ST10100320250602075322', '1446-12-05', '1.100.10', '101', 'an.MUHAMMAD YAHYA SYAKARUDDIN', '5000', '0', 'Chuwez', '2025-06-02 21:53:22'),
('4728', 'ST10100320250602075322', '1446-12-05', '2.220.10', '101', 'an.MUHAMMAD YAHYA SYAKARUDDIN', '0', '5000', 'Chuwez', '2025-06-02 21:53:22'),
('4729', 'ST10100320250602075350', '1446-12-05', '1.100.10', '101', 'an.ZAKIYATUL UMMAH', '2000', '0', 'Chuwez', '2025-06-02 21:53:50'),
('4730', 'ST10100320250602075350', '1446-12-05', '2.220.10', '101', 'an.ZAKIYATUL UMMAH', '0', '2000', 'Chuwez', '2025-06-02 21:53:50'),
('4731', 'ST10100320250602075422', '1446-12-05', '1.100.10', '101', 'an.ANA SALSABILA', '22000', '0', 'Chuwez', '2025-06-02 21:54:22'),
('4732', 'ST10100320250602075422', '1446-12-05', '2.220.10', '101', 'an.ANA SALSABILA', '0', '22000', 'Chuwez', '2025-06-02 21:54:22'),
('4733', 'ST10100320250602075441', '1446-12-05', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '5000', '0', 'Chuwez', '2025-06-02 21:54:41'),
('4734', 'ST10100320250602075441', '1446-12-05', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '5000', 'Chuwez', '2025-06-02 21:54:41'),
('4735', 'ST10100320250602075502', '1446-12-05', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '10000', '0', 'Chuwez', '2025-06-02 21:55:02'),
('4736', 'ST10100320250602075502', '1446-12-05', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '10000', 'Chuwez', '2025-06-02 21:55:02'),
('4737', 'ST10100320250602080136', '1446-12-05', '1.100.10', '101', 'an.HILYA', '20000', '0', 'Chuwez', '2025-06-02 22:01:36'),
('4738', 'ST10100320250602080136', '1446-12-05', '2.220.10', '101', 'an.HILYA', '0', '20000', 'Chuwez', '2025-06-02 22:01:36'),
('4739', 'ST10100320250602080234', '1446-12-05', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'Chuwez', '2025-06-02 22:02:34'),
('4740', 'ST10100320250602080234', '1446-12-05', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'Chuwez', '2025-06-02 22:02:36'),
('4741', 'ST10100320250602080257', '1446-12-05', '1.100.10', '101', 'an.MACHMUDAH', '10000', '0', 'Chuwez', '2025-06-02 22:02:57'),
('4742', 'ST10100320250602080257', '1446-12-05', '2.220.10', '101', 'an.MACHMUDAH', '0', '10000', 'Chuwez', '2025-06-02 22:02:57'),
('4743', 'ST10100320250602080340', '1446-12-05', '1.100.10', '101', 'an.HALIMAH', '5000', '0', 'Chuwez', '2025-06-02 22:03:40'),
('4744', 'ST10100320250602080340', '1446-12-05', '2.220.10', '101', 'an.HALIMAH', '0', '5000', 'Chuwez', '2025-06-02 22:03:40'),
('4745', 'D110100320250602080525', '1446-12-05', '1.100.10', '101', 'Bayar[MUHAMMAD RIFQIL MAMUN]', '20000', '0', 'Chuwez', '2025-06-02 15:05:25'),
('4746', 'D110100320250602080525', '1446-12-05', '4.400.22', '101', 'Bayar[MUHAMMAD RIFQIL MAMUN]', '0', '20000', 'Chuwez', '2025-06-02 15:05:25'),
('4747', 'D110100320250602080721', '1446-12-05', '1.100.10', '101', 'Bayar[ZAIDATUS SYARIFATUN NAJWA]', '40000', '0', 'Chuwez', '2025-06-02 15:07:21'),
('4748', 'D110100320250602080721', '1446-12-05', '4.400.22', '101', 'Bayar[ZAIDATUS SYARIFATUN NAJWA]', '0', '40000', 'Chuwez', '2025-06-02 15:07:21'),
('4749', 'D110100320250602080811', '1446-12-05', '1.100.10', '101', 'Bayar[RAUDHOTUL JANNAH]', '35000', '0', 'Chuwez', '2025-06-02 15:08:11'),
('4750', 'D110100320250602080811', '1446-12-05', '4.400.22', '101', 'Bayar[RAUDHOTUL JANNAH]', '0', '35000', 'Chuwez', '2025-06-02 15:08:11'),
('4751', 'D110100320250602080852', '1446-12-05', '1.100.10', '101', 'Bayar[CHUSNIYAH RAMADHANI]', '35000', '0', 'Chuwez', '2025-06-02 15:08:52'),
('4752', 'D110100320250602080852', '1446-12-05', '4.400.22', '101', 'Bayar[CHUSNIYAH RAMADHANI]', '0', '35000', 'Chuwez', '2025-06-02 15:08:52'),
('4753', 'D110100320250602080931', '1446-12-05', '1.100.10', '101', 'Bayar[MUHAMMAD YAQUB HAMDANI]', '35000', '0', 'Chuwez', '2025-06-02 15:09:31'),
('4754', 'D110100320250602080931', '1446-12-05', '4.400.22', '101', 'Bayar[MUHAMMAD YAQUB HAMDANI]', '0', '35000', 'Chuwez', '2025-06-02 15:09:31'),
('4755', 'BS10100320250602081112000', '1446-10-05', '1.100.10', '101', 'Bayar[MUHAMMAD RIFQIL MAMUN]', '30000', '0', 'Chuwez', '2025-06-02 15:11:12'),
('4756', 'BS10100320250602081112000', '1446-10-05', '4.400.20', '101', 'Bayar[MUHAMMAD RIFQIL MAMUN]', '0', '30000', 'Chuwez', '2025-06-02 15:11:12'),
('4757', 'BS10100320250602081112001', '1446-11-05', '1.100.10', '101', 'Bayar[MUHAMMAD RIFQIL MAMUN]', '30000', '0', 'Chuwez', '2025-06-02 15:11:12'),
('4758', 'BS10100320250602081112001', '1446-11-05', '4.400.20', '101', 'Bayar[MUHAMMAD RIFQIL MAMUN]', '0', '30000', 'Chuwez', '2025-06-02 15:11:12'),
('4759', 'BS10100320250602081112002', '1446-12-05', '1.100.10', '101', 'Bayar[MUHAMMAD RIFQIL MAMUN]', '30000', '0', 'Chuwez', '2025-06-02 15:11:12'),
('4760', 'BS10100320250602081112002', '1446-12-05', '4.400.20', '101', 'Bayar[MUHAMMAD RIFQIL MAMUN]', '0', '30000', 'Chuwez', '2025-06-02 15:11:12'),
('4761', 'BS10100320250602081231000', '1446-12-05', '1.100.10', '101', 'Bayar[KHOIRIYAH]', '30000', '0', 'Chuwez', '2025-06-02 15:12:31'),
('4762', 'BS10100320250602081231000', '1446-12-05', '4.400.20', '101', 'Bayar[KHOIRIYAH]', '0', '30000', 'Chuwez', '2025-06-02 15:12:31'),
('4763', 'BS10100320250602081346000', '1446-11-05', '1.100.10', '101', 'Bayar[MUHAMMAD NAZHIRUL ASROFI]', '30000', '0', 'Chuwez', '2025-06-02 15:13:46'),
('4764', 'BS10100320250602081346000', '1446-11-05', '4.400.20', '101', 'Bayar[MUHAMMAD NAZHIRUL ASROFI]', '0', '30000', 'Chuwez', '2025-06-02 15:13:46'),
('4765', 'BS10100320250602081519000', '1446-11-05', '1.100.10', '101', 'Bayar[IFTITAHUL IZZA]', '30000', '0', 'Chuwez', '2025-06-02 15:15:19'),
('4766', 'BS10100320250602081519000', '1446-11-05', '4.400.20', '101', 'Bayar[IFTITAHUL IZZA]', '0', '30000', 'Chuwez', '2025-06-02 15:15:19'),
('4767', 'BS10100320250602081519001', '1446-12-05', '1.100.10', '101', 'Bayar[IFTITAHUL IZZA]', '30000', '0', 'Chuwez', '2025-06-02 15:15:19'),
('4768', 'BS10100320250602081519001', '1446-12-05', '4.400.20', '101', 'Bayar[IFTITAHUL IZZA]', '0', '30000', 'Chuwez', '2025-06-02 15:15:19'),
('4769', 'BS10100320250602081657000', '1446-11-05', '1.100.10', '101', 'Bayar[MARIYATUL QIBTIYAH]', '30000', '0', 'Chuwez', '2025-06-02 15:16:57'),
('4770', 'BS10100320250602081657000', '1446-11-05', '4.400.20', '101', 'Bayar[MARIYATUL QIBTIYAH]', '0', '30000', 'Chuwez', '2025-06-02 15:16:57'),
('4771', 'BS10100320250602081658001', '1446-12-05', '1.100.10', '101', 'Bayar[MARIYATUL QIBTIYAH]', '30000', '0', 'Chuwez', '2025-06-02 15:16:58'),
('4772', 'BS10100320250602081658001', '1446-12-05', '4.400.20', '101', 'Bayar[MARIYATUL QIBTIYAH]', '0', '30000', 'Chuwez', '2025-06-02 15:16:58'),
('4773', 'BS10100320250602081658002', '1447-01-05', '1.100.10', '101', 'Bayar[MARIYATUL QIBTIYAH]', '30000', '0', 'Chuwez', '2025-06-02 15:16:58'),
('4774', 'BS10100320250602081658002', '1447-01-05', '4.400.20', '101', 'Bayar[MARIYATUL QIBTIYAH]', '0', '30000', 'Chuwez', '2025-06-02 15:16:58'),
('4775', 'BS10100320250602081658003', '1447-02-05', '1.100.10', '101', 'Bayar[MARIYATUL QIBTIYAH]', '30000', '0', 'Chuwez', '2025-06-02 15:16:58'),
('4776', 'BS10100320250602081658003', '1447-02-05', '4.400.20', '101', 'Bayar[MARIYATUL QIBTIYAH]', '0', '30000', 'Chuwez', '2025-06-02 15:16:58'),
('4777', 'BS10100320250602081658004', '1447-03-05', '1.100.10', '101', 'Bayar[MARIYATUL QIBTIYAH]', '30000', '0', 'Chuwez', '2025-06-02 15:16:58'),
('4778', 'BS10100320250602081658004', '1447-03-05', '4.400.20', '101', 'Bayar[MARIYATUL QIBTIYAH]', '0', '30000', 'Chuwez', '2025-06-02 15:16:58'),
('4779', 'BS10100320250602081658005', '1447-04-05', '1.100.10', '101', 'Bayar[MARIYATUL QIBTIYAH]', '30000', '0', 'Chuwez', '2025-06-02 15:16:58'),
('4780', 'BS10100320250602081658005', '1447-04-05', '4.400.20', '101', 'Bayar[MARIYATUL QIBTIYAH]', '0', '30000', 'Chuwez', '2025-06-02 15:16:58'),
('4781', 'BS10100320250602081658006', '1447-05-05', '1.100.10', '101', 'Bayar[MARIYATUL QIBTIYAH]', '30000', '0', 'Chuwez', '2025-06-02 15:16:58'),
('4782', 'BS10100320250602081658006', '1447-05-05', '4.400.20', '101', 'Bayar[MARIYATUL QIBTIYAH]', '0', '30000', 'Chuwez', '2025-06-02 15:16:58'),
('4783', 'BS10100320250602081658007', '1447-06-05', '1.100.10', '101', 'Bayar[MARIYATUL QIBTIYAH]', '30000', '0', 'Chuwez', '2025-06-02 15:16:58'),
('4784', 'BS10100320250602081658007', '1447-06-05', '4.400.20', '101', 'Bayar[MARIYATUL QIBTIYAH]', '0', '30000', 'Chuwez', '2025-06-02 15:16:58'),
('4785', 'BS10100320250602081658008', '1447-07-05', '1.100.10', '101', 'Bayar[MARIYATUL QIBTIYAH]', '30000', '0', 'Chuwez', '2025-06-02 15:16:58'),
('4786', 'BS10100320250602081658008', '1447-07-05', '4.400.20', '101', 'Bayar[MARIYATUL QIBTIYAH]', '0', '30000', 'Chuwez', '2025-06-02 15:16:58'),
('4787', 'BS10100320250602081658009', '1447-08-05', '1.100.10', '101', 'Bayar[MARIYATUL QIBTIYAH]', '30000', '0', 'Chuwez', '2025-06-02 15:16:58'),
('4788', 'BS10100320250602081658009', '1447-08-05', '4.400.20', '101', 'Bayar[MARIYATUL QIBTIYAH]', '0', '30000', 'Chuwez', '2025-06-02 15:16:58'),
('4789', 'BS10100320250602081746000', '1446-10-05', '1.100.10', '101', 'Bayar[ANA SALSABILA]', '30000', '0', 'Chuwez', '2025-06-02 15:17:46'),
('4790', 'BS10100320250602081746000', '1446-10-05', '4.400.20', '101', 'Bayar[ANA SALSABILA]', '0', '30000', 'Chuwez', '2025-06-02 15:17:46'),
('4791', 'BS10100320250602081958000', '1446-12-05', '1.100.10', '101', 'Bayar[ZAIDATUS SYARIFATUN NAJWA]', '30000', '0', 'Chuwez', '2025-06-02 15:19:58'),
('4792', 'BS10100320250602081958000', '1446-12-05', '4.400.20', '101', 'Bayar[ZAIDATUS SYARIFATUN NAJWA]', '0', '30000', 'Chuwez', '2025-06-02 15:19:58'),
('4793', 'BS10100320250602082026000', '1446-12-05', '1.100.10', '101', 'Bayar[CHUSNIYAH RAMADHANI]', '30000', '0', 'Chuwez', '2025-06-02 15:20:26'),
('4794', 'BS10100320250602082026000', '1446-12-05', '4.400.20', '101', 'Bayar[CHUSNIYAH RAMADHANI]', '0', '30000', 'Chuwez', '2025-06-02 15:20:26'),
('4795', 'KK10100320250602152222', '1446-12-05', '5.520.42', '101', 'Kopi+bakso+cilok', '60000', '0', 'Chuwez', '2025-06-02 15:22:51'),
('4796', 'KK10100320250602152222', '1446-12-05', '1.100.10', '101', 'Kopi+bakso+cilok', '0', '60000', 'Chuwez', '2025-06-02 15:22:51'),
('4799', 'BS10100220250603013017001', '1446-11-06', '1.100.10', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '30000', '0', 'Ipul', '2025-06-03 08:30:17'),
('4800', 'BS10100220250603013017001', '1446-11-06', '4.400.20', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '0', '30000', 'Ipul', '2025-06-03 08:30:17'),
('4801', 'BS10100220250603013017002', '1446-12-06', '1.100.10', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '30000', '0', 'Ipul', '2025-06-03 08:30:17'),
('4802', 'BS10100220250603013017002', '1446-12-06', '4.400.20', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '0', '30000', 'Ipul', '2025-06-03 08:30:17'),
('4803', 'BS10100220250603013017003', '1447-01-06', '1.100.10', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '30000', '0', 'Ipul', '2025-06-03 08:30:17'),
('4804', 'BS10100220250603013017003', '1447-01-06', '4.400.20', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '0', '30000', 'Ipul', '2025-06-03 08:30:17'),
('4805', 'BS10100220250603013017004', '1447-02-06', '1.100.10', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '30000', '0', 'Ipul', '2025-06-03 08:30:17'),
('4806', 'BS10100220250603013017004', '1447-02-06', '4.400.20', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '0', '30000', 'Ipul', '2025-06-03 08:30:17'),
('4807', 'BS10100220250603013017005', '1447-03-06', '1.100.10', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '30000', '0', 'Ipul', '2025-06-03 08:30:17'),
('4808', 'BS10100220250603013017005', '1447-03-06', '4.400.20', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '0', '30000', 'Ipul', '2025-06-03 08:30:17'),
('4809', 'BS10100220250603013017006', '1447-04-06', '1.100.10', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '30000', '0', 'Ipul', '2025-06-03 08:30:17'),
('4810', 'BS10100220250603013017006', '1447-04-06', '4.400.20', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '0', '30000', 'Ipul', '2025-06-03 08:30:17'),
('4811', 'BS10100220250603013017007', '1447-05-06', '1.100.10', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '30000', '0', 'Ipul', '2025-06-03 08:30:17'),
('4812', 'BS10100220250603013017007', '1447-05-06', '4.400.20', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '0', '30000', 'Ipul', '2025-06-03 08:30:17'),
('4813', 'BS10100220250603013017008', '1447-06-06', '1.100.10', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '30000', '0', 'Ipul', '2025-06-03 08:30:17'),
('4814', 'BS10100220250603013017008', '1447-06-06', '4.400.20', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '0', '30000', 'Ipul', '2025-06-03 08:30:17'),
('4815', 'BS10100220250603013017009', '1447-07-06', '1.100.10', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '30000', '0', 'Ipul', '2025-06-03 08:30:17'),
('4816', 'BS10100220250603013017009', '1447-07-06', '4.400.20', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '0', '30000', 'Ipul', '2025-06-03 08:30:17'),
('4819', 'KI10100220250603013349', '1446-11-19', '1.100.10', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '84000', '0', 'Ipul', '2025-06-03 08:33:49'),
('4820', 'KI10100220250603013349', '1446-11-19', '4.400.21', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '0', '84000', 'Ipul', '2025-06-03 08:33:49'),
('4821', 'ST10100320250603073713', '1446-12-06', '1.100.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '10000', '0', 'Chuwez', '2025-06-03 21:37:13'),
('4822', 'ST10100320250603073713', '1446-12-06', '2.220.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '0', '10000', 'Chuwez', '2025-06-03 21:37:13'),
('4823', 'ST10100320250603073734', '1446-12-06', '1.100.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '2000', '0', 'Chuwez', '2025-06-03 21:37:34'),
('4824', 'ST10100320250603073734', '1446-12-06', '2.220.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '0', '2000', 'Chuwez', '2025-06-03 21:37:34'),
('4825', 'ST10100320250603073800', '1446-12-06', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'Chuwez', '2025-06-03 21:38:00'),
('4826', 'ST10100320250603073800', '1446-12-06', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'Chuwez', '2025-06-03 21:38:00'),
('4827', 'ST10100320250603073825', '1446-12-06', '1.100.10', '101', 'an.NAURA BILADINA', '5000', '0', 'Chuwez', '2025-06-03 21:38:25'),
('4828', 'ST10100320250603073825', '1446-12-06', '2.220.10', '101', 'an.NAURA BILADINA', '0', '5000', 'Chuwez', '2025-06-03 21:38:25'),
('4829', 'ST10100320250603073849', '1446-12-06', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '10000', '0', 'Chuwez', '2025-06-03 21:38:49'),
('4830', 'ST10100320250603073849', '1446-12-06', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '10000', 'Chuwez', '2025-06-03 21:38:49'),
('4831', 'ST10100320250603073909', '1446-12-06', '1.100.10', '101', 'an.SITI SHOFIYAH LABIBAH', '10000', '0', 'Chuwez', '2025-06-03 21:39:09'),
('4832', 'ST10100320250603073909', '1446-12-06', '2.220.10', '101', 'an.SITI SHOFIYAH LABIBAH', '0', '10000', 'Chuwez', '2025-06-03 21:39:09'),
('4833', 'ST10100320250603073927', '1446-12-06', '1.100.10', '101', 'an.M. ABD. HADI', '2000', '0', 'Chuwez', '2025-06-03 21:39:27'),
('4834', 'ST10100320250603073927', '1446-12-06', '2.220.10', '101', 'an.M. ABD. HADI', '0', '2000', 'Chuwez', '2025-06-03 21:39:27'),
('4835', 'ST10100320250603073948', '1446-12-06', '1.100.10', '101', 'an.HAIKAL SHOMADANI', '2000', '0', 'Chuwez', '2025-06-03 21:39:48'),
('4836', 'ST10100320250603073948', '1446-12-06', '2.220.10', '101', 'an.HAIKAL SHOMADANI', '0', '2000', 'Chuwez', '2025-06-03 21:39:48'),
('4837', 'ST10100320250603074012', '1446-12-06', '1.100.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '5000', '0', 'Chuwez', '2025-06-03 21:40:12'),
('4838', 'ST10100320250603074012', '1446-12-06', '2.220.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '0', '5000', 'Chuwez', '2025-06-03 21:40:12'),
('4839', 'ST10100320250603074039', '1446-12-06', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'Chuwez', '2025-06-03 21:40:39'),
('4840', 'ST10100320250603074039', '1446-12-06', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'Chuwez', '2025-06-03 21:40:39'),
('4841', 'ST10100320250603074100', '1446-12-06', '1.100.10', '101', 'an.ABDULLOH BAHAR', '2000', '0', 'Chuwez', '2025-06-03 21:41:00'),
('4842', 'ST10100320250603074100', '1446-12-06', '2.220.10', '101', 'an.ABDULLOH BAHAR', '0', '2000', 'Chuwez', '2025-06-03 21:41:00'),
('4843', 'ST10100320250603074121', '1446-12-06', '1.100.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '4000', '0', 'Chuwez', '2025-06-03 21:41:21'),
('4844', 'ST10100320250603074121', '1446-12-06', '2.220.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '0', '4000', 'Chuwez', '2025-06-03 21:41:21'),
('4845', 'ST10100320250603074137', '1446-12-06', '1.100.10', '101', 'an.RAISA ANNISA', '10000', '0', 'Chuwez', '2025-06-03 21:41:37'),
('4846', 'ST10100320250603074137', '1446-12-06', '2.220.10', '101', 'an.RAISA ANNISA', '0', '10000', 'Chuwez', '2025-06-03 21:41:37'),
('4847', 'ST10100320250603074153', '1446-12-06', '1.100.10', '101', 'an.MARIATUL QIBTIYAH', '2000', '0', 'Chuwez', '2025-06-03 21:41:53'),
('4848', 'ST10100320250603074153', '1446-12-06', '2.220.10', '101', 'an.MARIATUL QIBTIYAH', '0', '2000', 'Chuwez', '2025-06-03 21:41:53'),
('4849', 'ST10100320250603074212', '1446-12-06', '1.100.10', '101', 'an.MARIYATUL QIBTIYAH', '5000', '0', 'Chuwez', '2025-06-03 21:42:12'),
('4850', 'ST10100320250603074212', '1446-12-06', '2.220.10', '101', 'an.MARIYATUL QIBTIYAH', '0', '5000', 'Chuwez', '2025-06-03 21:42:12'),
('4851', 'ST10100320250603074232', '1446-12-06', '1.100.10', '101', 'an.MUHAMMAD ALWI', '10000', '0', 'Chuwez', '2025-06-03 21:42:32'),
('4852', 'ST10100320250603074232', '1446-12-06', '2.220.10', '101', 'an.MUHAMMAD ALWI', '0', '10000', 'Chuwez', '2025-06-03 21:42:32'),
('4853', 'ST10100320250603074250', '1446-12-06', '1.100.10', '101', 'an.UBAIDAH', '20000', '0', 'Chuwez', '2025-06-03 21:42:50'),
('4854', 'ST10100320250603074250', '1446-12-06', '2.220.10', '101', 'an.UBAIDAH', '0', '20000', 'Chuwez', '2025-06-03 21:42:50'),
('4855', 'ST10100320250603074307', '1446-12-06', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '5000', '0', 'Chuwez', '2025-06-03 21:43:07'),
('4856', 'ST10100320250603074307', '1446-12-06', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '5000', 'Chuwez', '2025-06-03 21:43:07'),
('4857', 'ST10100320250603074328', '1446-12-06', '1.100.10', '101', 'an.FAIZAH NURUL LITA', '10000', '0', 'Chuwez', '2025-06-03 21:43:28'),
('4858', 'ST10100320250603074328', '1446-12-06', '2.220.10', '101', 'an.FAIZAH NURUL LITA', '0', '10000', 'Chuwez', '2025-06-03 21:43:28'),
('4859', 'ST10100320250603074347', '1446-12-06', '1.100.10', '101', 'an.NAILATUN NIAMI', '2000', '0', 'Chuwez', '2025-06-03 21:43:47'),
('4860', 'ST10100320250603074347', '1446-12-06', '2.220.10', '101', 'an.NAILATUN NIAMI', '0', '2000', 'Chuwez', '2025-06-03 21:43:47'),
('4861', 'ST10100320250603074520', '1446-12-06', '1.100.10', '101', 'an.AZKA AUFARIL MINAN', '10000', '0', 'Chuwez', '2025-06-03 21:45:20'),
('4862', 'ST10100320250603074520', '1446-12-06', '2.220.10', '101', 'an.AZKA AUFARIL MINAN', '0', '10000', 'Chuwez', '2025-06-03 21:45:20'),
('4863', 'ST10100320250603074541', '1446-12-06', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '5000', '0', 'Chuwez', '2025-06-03 21:45:41'),
('4864', 'ST10100320250603074541', '1446-12-06', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '5000', 'Chuwez', '2025-06-03 21:45:41'),
('4865', 'ST10100320250603074602', '1446-12-06', '1.100.10', '101', 'an.AHMAD ADITIYA', '15000', '0', 'Chuwez', '2025-06-03 21:46:02'),
('4866', 'ST10100320250603074602', '1446-12-06', '2.220.10', '101', 'an.AHMAD ADITIYA', '0', '15000', 'Chuwez', '2025-06-03 21:46:02'),
('4867', 'ST10100320250603074619', '1446-12-06', '1.100.10', '101', 'an.ALFI NURDIANA', '5000', '0', 'Chuwez', '2025-06-03 21:46:19'),
('4868', 'ST10100320250603074619', '1446-12-06', '2.220.10', '101', 'an.ALFI NURDIANA', '0', '5000', 'Chuwez', '2025-06-03 21:46:19'),
('4869', 'ST10100320250603074635', '1446-12-06', '1.100.10', '101', 'an.AISYAH', '5000', '0', 'Chuwez', '2025-06-03 21:46:35'),
('4870', 'ST10100320250603074635', '1446-12-06', '2.220.10', '101', 'an.AISYAH', '0', '5000', 'Chuwez', '2025-06-03 21:46:35'),
('4871', 'ST10100320250603074658', '1446-12-06', '1.100.10', '101', 'an.WARDATUL JANNAH', '2000', '0', 'Chuwez', '2025-06-03 21:46:58'),
('4872', 'ST10100320250603074658', '1446-12-06', '2.220.10', '101', 'an.WARDATUL JANNAH', '0', '2000', 'Chuwez', '2025-06-03 21:46:58'),
('4873', 'ST10100320250603074722', '1446-12-06', '1.100.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '10000', '0', 'Chuwez', '2025-06-03 21:47:22'),
('4874', 'ST10100320250603074722', '1446-12-06', '2.220.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '0', '10000', 'Chuwez', '2025-06-03 21:47:22'),
('4877', 'ST10100320250603074802', '1446-12-06', '1.100.10', '101', 'an.M. FAHMI NURUL ANAM', '10000', '0', 'Chuwez', '2025-06-03 21:48:02'),
('4878', 'ST10100320250603074802', '1446-12-06', '2.220.10', '101', 'an.M. FAHMI NURUL ANAM', '0', '10000', 'Chuwez', '2025-06-03 21:48:02'),
('4879', 'ST10100320250603074829', '1446-12-06', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '10000', '0', 'Chuwez', '2025-06-03 21:48:29'),
('4880', 'ST10100320250603074829', '1446-12-06', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '10000', 'Chuwez', '2025-06-03 21:48:29'),
('4881', 'ST10100320250603074918', '1446-12-06', '1.100.10', '101', 'an.SITI ATHIUR ROHMAH', '2000', '0', 'Chuwez', '2025-06-03 21:49:18'),
('4882', 'ST10100320250603074918', '1446-12-06', '2.220.10', '101', 'an.SITI ATHIUR ROHMAH', '0', '2000', 'Chuwez', '2025-06-03 21:49:18'),
('4883', 'ST10100320250603074940', '1446-12-06', '1.100.10', '101', 'an.DIYANAH KAMALIYAH', '2000', '0', 'Chuwez', '2025-06-03 21:49:40'),
('4884', 'ST10100320250603074940', '1446-12-06', '2.220.10', '101', 'an.DIYANAH KAMALIYAH', '0', '2000', 'Chuwez', '2025-06-03 21:49:41'),
('4885', 'ST10100320250603075013', '1446-12-06', '1.100.10', '101', 'an.MIFTAHUL JANNAH', '50000', '0', 'Chuwez', '2025-06-03 21:50:13'),
('4886', 'ST10100320250603075013', '1446-12-06', '2.220.10', '101', 'an.MIFTAHUL JANNAH', '0', '50000', 'Chuwez', '2025-06-03 21:50:13'),
('4887', 'ST10100320250603075039', '1446-12-06', '1.100.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '20000', '0', 'Chuwez', '2025-06-03 21:50:39'),
('4888', 'ST10100320250603075039', '1446-12-06', '2.220.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '0', '20000', 'Chuwez', '2025-06-03 21:50:39'),
('4889', 'ST10100320250603075123', '1446-12-06', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '5000', '0', 'Chuwez', '2025-06-03 21:51:23'),
('4890', 'ST10100320250603075123', '1446-12-06', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '5000', 'Chuwez', '2025-06-03 21:51:23'),
('4891', 'ST10100320250603075147', '1446-12-06', '1.100.10', '101', 'an.M. KAMALUDDIN', '20000', '0', 'Chuwez', '2025-06-03 21:51:47'),
('4892', 'ST10100320250603075147', '1446-12-06', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '20000', 'Chuwez', '2025-06-03 21:51:47'),
('4893', 'ST10100320250603075258', '1446-12-06', '1.100.10', '101', 'an.NABILATUN NISAUL UMMAH', '20000', '0', 'Chuwez', '2025-06-03 21:52:58'),
('4894', 'ST10100320250603075258', '1446-12-06', '2.220.10', '101', 'an.NABILATUN NISAUL UMMAH', '0', '20000', 'Chuwez', '2025-06-03 21:52:59'),
('4895', 'ST10100320250603075319', '1446-12-06', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '10000', '0', 'Chuwez', '2025-06-03 21:53:19'),
('4896', 'ST10100320250603075319', '1446-12-06', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '10000', 'Chuwez', '2025-06-03 21:53:19'),
('4897', 'ST10100320250603075342', '1446-12-06', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Chuwez', '2025-06-03 21:53:42'),
('4898', 'ST10100320250603075342', '1446-12-06', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Chuwez', '2025-06-03 21:53:42'),
('4899', 'ST10100320250603075403', '1446-12-06', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '2000', '0', 'Chuwez', '2025-06-03 21:54:03'),
('4900', 'ST10100320250603075403', '1446-12-06', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '2000', 'Chuwez', '2025-06-03 21:54:03'),
('4901', 'ST10100320250603075440', '1446-12-06', '1.100.10', '101', 'an.SINDI RAISA PUTRI', '10000', '0', 'Chuwez', '2025-06-03 21:54:40'),
('4902', 'ST10100320250603075440', '1446-12-06', '2.220.10', '101', 'an.SINDI RAISA PUTRI', '0', '10000', 'Chuwez', '2025-06-03 21:54:40'),
('4903', 'ST10100320250603080054', '1446-12-06', '1.100.10', '101', 'an.ELOK WARDATUN NAFISAH', '15000', '0', 'Chuwez', '2025-06-03 22:00:54'),
('4904', 'ST10100320250603080054', '1446-12-06', '2.220.10', '101', 'an.ELOK WARDATUN NAFISAH', '0', '15000', 'Chuwez', '2025-06-03 22:00:54'),
('4905', 'ST10100320250603080131', '1446-12-06', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '15000', '0', 'Chuwez', '2025-06-03 22:01:31'),
('4906', 'ST10100320250603080131', '1446-12-06', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '15000', 'Chuwez', '2025-06-03 22:01:32'),
('4907', 'ST10100320250603080200', '1446-12-06', '1.100.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '5000', '0', 'Chuwez', '2025-06-03 22:02:00'),
('4908', 'ST10100320250603080200', '1446-12-06', '2.220.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '0', '5000', 'Chuwez', '2025-06-03 22:02:00'),
('4909', 'ST10100320250603080221', '1446-12-06', '1.100.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '20000', '0', 'Chuwez', '2025-06-03 22:02:21'),
('4910', 'ST10100320250603080221', '1446-12-06', '2.220.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '0', '20000', 'Chuwez', '2025-06-03 22:02:21'),
('4911', 'ST10100320250603080241', '1446-12-06', '1.100.10', '101', 'an.AKHMAD FIKRI HAIKAL', '100000', '0', 'Chuwez', '2025-06-03 22:02:41'),
('4912', 'ST10100320250603080241', '1446-12-06', '2.220.10', '101', 'an.AKHMAD FIKRI HAIKAL', '0', '100000', 'Chuwez', '2025-06-03 22:02:41'),
('4913', 'ST10100320250603080314', '1446-12-06', '1.100.10', '101', 'an.BILQIS THALIA HASNA', '125000', '0', 'Chuwez', '2025-06-03 22:03:14'),
('4914', 'ST10100320250603080314', '1446-12-06', '2.220.10', '101', 'an.BILQIS THALIA HASNA', '0', '125000', 'Chuwez', '2025-06-03 22:03:14'),
('4915', 'ST10100320250603080424', '1446-12-06', '1.100.10', '101', 'an.MUHAMMAD KHOIRON', '5000', '0', 'Chuwez', '2025-06-03 22:04:24'),
('4916', 'ST10100320250603080424', '1446-12-06', '2.220.10', '101', 'an.MUHAMMAD KHOIRON', '0', '5000', 'Chuwez', '2025-06-03 22:04:24'),
('4917', 'ST10100320250603080453', '1446-12-06', '1.100.10', '101', 'an.MUHAMMAD YAHYA SYAKARUDDIN', '10000', '0', 'Chuwez', '2025-06-03 22:04:53'),
('4918', 'ST10100320250603080453', '1446-12-06', '2.220.10', '101', 'an.MUHAMMAD YAHYA SYAKARUDDIN', '0', '10000', 'Chuwez', '2025-06-03 22:04:53'),
('4919', 'ST10100320250603080514', '1446-12-06', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '5000', '0', 'Chuwez', '2025-06-03 22:05:14'),
('4920', 'ST10100320250603080514', '1446-12-06', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '5000', 'Chuwez', '2025-06-03 22:05:14'),
('4921', 'ST10100320250603080542', '1446-12-06', '1.100.10', '101', 'an.AFANDI', '2000', '0', 'Chuwez', '2025-06-03 22:05:42'),
('4922', 'ST10100320250603080542', '1446-12-06', '2.220.10', '101', 'an.AFANDI', '0', '2000', 'Chuwez', '2025-06-03 22:05:42'),
('4923', 'ST10100320250603080603', '1446-12-06', '1.100.10', '101', 'an.ZAKIYATUL UMMAH', '2000', '0', 'Chuwez', '2025-06-03 22:06:03'),
('4924', 'ST10100320250603080603', '1446-12-06', '2.220.10', '101', 'an.ZAKIYATUL UMMAH', '0', '2000', 'Chuwez', '2025-06-03 22:06:03'),
('4925', 'ST10100320250603080627', '1446-12-06', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '5000', '0', 'Chuwez', '2025-06-03 22:06:27'),
('4926', 'ST10100320250603080627', '1446-12-06', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '5000', 'Chuwez', '2025-06-03 22:06:27'),
('4927', 'ST10100320250603080647', '1446-12-06', '1.100.10', '101', 'an.ANA SALSABILA', '4000', '0', 'Chuwez', '2025-06-03 22:06:47'),
('4928', 'ST10100320250603080647', '1446-12-06', '2.220.10', '101', 'an.ANA SALSABILA', '0', '4000', 'Chuwez', '2025-06-03 22:06:47'),
('4929', 'ST10100320250603080714', '1446-12-06', '1.100.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '2000', '0', 'Chuwez', '2025-06-03 22:07:14'),
('4930', 'ST10100320250603080714', '1446-12-06', '2.220.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '0', '2000', 'Chuwez', '2025-06-03 22:07:15'),
('4931', 'ST10100320250603080736', '1446-12-06', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '5000', '0', 'Chuwez', '2025-06-03 22:07:36'),
('4932', 'ST10100320250603080736', '1446-12-06', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '5000', 'Chuwez', '2025-06-03 22:07:36'),
('4933', 'ST10100320250603080755', '1446-12-06', '1.100.10', '101', 'an.SAFIRATUL JANNAH', '10000', '0', 'Chuwez', '2025-06-03 22:07:55'),
('4934', 'ST10100320250603080755', '1446-12-06', '2.220.10', '101', 'an.SAFIRATUL JANNAH', '0', '10000', 'Chuwez', '2025-06-03 22:07:55'),
('4935', 'ST10100320250603080830', '1446-12-06', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'Chuwez', '2025-06-03 22:08:30'),
('4936', 'ST10100320250603080830', '1446-12-06', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'Chuwez', '2025-06-03 22:08:30'),
('4937', 'ST10100320250603080854', '1446-12-06', '1.100.10', '101', 'an.HILYA', '20000', '0', 'Chuwez', '2025-06-03 22:08:54'),
('4938', 'ST10100320250603080854', '1446-12-06', '2.220.10', '101', 'an.HILYA', '0', '20000', 'Chuwez', '2025-06-03 22:08:55'),
('4939', 'ST10100320250603074743', '1446-12-06', '1.100.10', '101', 'an.SITI QURROTUL AINI', '4000', '0', 'Chuwez', '2025-06-03 22:10:14'),
('4940', 'ST10100320250603074743', '1446-12-06', '2.220.10', '101', 'an.SITI QURROTUL AINI', '0', '4000', 'Chuwez', '2025-06-03 22:10:14'),
('4941', 'BS10100320250603081059000', '1446-10-06', '1.100.10', '101', 'Bayar[ELOK WARDATUN NAFISAH]', '30000', '0', 'Chuwez', '2025-06-03 15:10:59'),
('4942', 'BS10100320250603081059000', '1446-10-06', '4.400.20', '101', 'Bayar[ELOK WARDATUN NAFISAH]', '0', '30000', 'Chuwez', '2025-06-03 15:10:59'),
('4943', 'BS10100320250603081059001', '1446-11-06', '1.100.10', '101', 'Bayar[ELOK WARDATUN NAFISAH]', '30000', '0', 'Chuwez', '2025-06-03 15:10:59'),
('4944', 'BS10100320250603081059001', '1446-11-06', '4.400.20', '101', 'Bayar[ELOK WARDATUN NAFISAH]', '0', '30000', 'Chuwez', '2025-06-03 15:10:59'),
('4945', 'BS10100320250603081059002', '1446-12-06', '1.100.10', '101', 'Bayar[ELOK WARDATUN NAFISAH]', '30000', '0', 'Chuwez', '2025-06-03 15:10:59'),
('4946', 'BS10100320250603081059002', '1446-12-06', '4.400.20', '101', 'Bayar[ELOK WARDATUN NAFISAH]', '0', '30000', 'Chuwez', '2025-06-03 15:10:59'),
('4947', 'D110100320250603081420', '1446-12-06', '1.100.10', '101', 'Bayar[ELOK WARDATUN NAFISAH]', '20000', '0', 'Chuwez', '2025-06-03 15:14:20'),
('4948', 'D110100320250603081420', '1446-12-06', '4.400.22', '101', 'Bayar[ELOK WARDATUN NAFISAH]', '0', '20000', 'Chuwez', '2025-06-03 15:14:20'),
('4949', 'D110100320250603081442', '1446-12-06', '1.100.10', '101', 'Bayar[ALFI NURDIANA]', '35000', '0', 'Chuwez', '2025-06-03 15:14:42'),
('4950', 'D110100320250603081442', '1446-12-06', '4.400.22', '101', 'Bayar[ALFI NURDIANA]', '0', '35000', 'Chuwez', '2025-06-03 15:14:42'),
('4951', 'BS10100320250603081554000', '1446-11-06', '1.100.10', '101', 'Bayar[MUHAMMAD YAHYA SYAKARUDDIN]', '30000', '0', 'Chuwez', '2025-06-03 15:15:54'),
('4952', 'BS10100320250603081554000', '1446-11-06', '4.400.20', '101', 'Bayar[MUHAMMAD YAHYA SYAKARUDDIN]', '0', '30000', 'Chuwez', '2025-06-03 15:15:54'),
('4953', 'BS10100320250603081627000', '1446-12-06', '1.100.10', '101', 'Bayar[M. FAHMI NURUL ANAM]', '30000', '0', 'Chuwez', '2025-06-03 15:16:27'),
('4954', 'BS10100320250603081627000', '1446-12-06', '4.400.20', '101', 'Bayar[M. FAHMI NURUL ANAM]', '0', '30000', 'Chuwez', '2025-06-03 15:16:27'),
('4955', 'BS10100320250603081706000', '1446-11-06', '1.100.10', '101', 'Bayar[HIKMATUL KHOLIDAH]', '30000', '0', 'Chuwez', '2025-06-03 15:17:06'),
('4956', 'BS10100320250603081706000', '1446-11-06', '4.400.20', '101', 'Bayar[HIKMATUL KHOLIDAH]', '0', '30000', 'Chuwez', '2025-06-03 15:17:06'),
('4957', 'BS10100320250603081707001', '1446-12-06', '1.100.10', '101', 'Bayar[HIKMATUL KHOLIDAH]', '30000', '0', 'Chuwez', '2025-06-03 15:17:07'),
('4958', 'BS10100320250603081707001', '1446-12-06', '4.400.20', '101', 'Bayar[HIKMATUL KHOLIDAH]', '0', '30000', 'Chuwez', '2025-06-03 15:17:07'),
('4959', 'BS10100320250603081757000', '1446-12-06', '1.100.10', '101', 'Bayar[SAUQY AHMAD]', '30000', '0', 'Chuwez', '2025-06-03 15:17:57'),
('4960', 'BS10100320250603081757000', '1446-12-06', '4.400.20', '101', 'Bayar[SAUQY AHMAD]', '0', '30000', 'Chuwez', '2025-06-03 15:17:57'),
('4961', 'ST10100320250603081840', '1446-12-06', '1.100.10', '101', 'an.SAUQY AHMAD', '5000', '0', 'Chuwez', '2025-06-03 22:18:40'),
('4962', 'ST10100320250603081840', '1446-12-06', '2.220.10', '101', 'an.SAUQY AHMAD', '0', '5000', 'Chuwez', '2025-06-03 22:18:40'),
('4963', 'KK10100320250603152857', '1446-12-06', '5.520.42', '101', 'Peyek', '10000', '0', 'Chuwez', '2025-06-03 15:29:16'),
('4964', 'KK10100320250603152857', '1446-12-06', '1.100.10', '101', 'Peyek', '0', '10000', 'Chuwez', '2025-06-03 15:29:16'),
('4965', 'ST10100320250604064829', '1446-12-07', '1.100.10', '101', 'an.ABDULLOH BAHAR', '3000', '0', 'Chuwez', '2025-06-04 20:48:29'),
('4966', 'ST10100320250604064829', '1446-12-07', '2.220.10', '101', 'an.ABDULLOH BAHAR', '0', '3000', 'Chuwez', '2025-06-04 20:48:29'),
('4967', 'ST10100320250604064903', '1446-12-07', '1.100.10', '101', 'an.MARIATUL QIBTIYAH', '2000', '0', 'Chuwez', '2025-06-04 20:49:03'),
('4968', 'ST10100320250604064903', '1446-12-07', '2.220.10', '101', 'an.MARIATUL QIBTIYAH', '0', '2000', 'Chuwez', '2025-06-04 20:49:03'),
('4969', 'ST10100320250604064935', '1446-12-07', '1.100.10', '101', 'an.RAISA ANNISA', '5000', '0', 'Chuwez', '2025-06-04 20:49:35'),
('4970', 'ST10100320250604064935', '1446-12-07', '2.220.10', '101', 'an.RAISA ANNISA', '0', '5000', 'Chuwez', '2025-06-04 20:49:36'),
('4971', 'ST10100320250604065015', '1446-12-07', '1.100.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '2000', '0', 'Chuwez', '2025-06-04 20:50:15'),
('4972', 'ST10100320250604065015', '1446-12-07', '2.220.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '0', '2000', 'Chuwez', '2025-06-04 20:50:15'),
('4973', 'ST10100320250604065117', '1446-12-07', '1.100.10', '101', 'an.MUHAMMAD YAHYA SYAKARUDDIN', '4000', '0', 'Chuwez', '2025-06-04 20:51:17'),
('4974', 'ST10100320250604065117', '1446-12-07', '2.220.10', '101', 'an.MUHAMMAD YAHYA SYAKARUDDIN', '0', '4000', 'Chuwez', '2025-06-04 20:51:17'),
('4975', 'ST10100320250604065141', '1446-12-07', '1.100.10', '101', 'an.ANA SALSABILA', '5000', '0', 'Chuwez', '2025-06-04 20:51:41'),
('4976', 'ST10100320250604065141', '1446-12-07', '2.220.10', '101', 'an.ANA SALSABILA', '0', '5000', 'Chuwez', '2025-06-04 20:51:41'),
('4977', 'ST10100320250604065207', '1446-12-07', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '5000', '0', 'Chuwez', '2025-06-04 20:52:07'),
('4978', 'ST10100320250604065207', '1446-12-07', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '5000', 'Chuwez', '2025-06-04 20:52:07'),
('4979', 'ST10100320250604065238', '1446-12-07', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '5000', '0', 'Chuwez', '2025-06-04 20:52:38'),
('4980', 'ST10100320250604065238', '1446-12-07', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '5000', 'Chuwez', '2025-06-04 20:52:38'),
('4981', 'ST10100320250604065332', '1446-12-07', '1.100.10', '101', 'an.ZAKIYATUL UMMAH', '2000', '0', 'Chuwez', '2025-06-04 20:53:32'),
('4982', 'ST10100320250604065332', '1446-12-07', '2.220.10', '101', 'an.ZAKIYATUL UMMAH', '0', '2000', 'Chuwez', '2025-06-04 20:53:32'),
('4983', 'ST10100320250604065419', '1446-12-07', '1.100.10', '101', 'an.AFANDI', '6000', '0', 'Chuwez', '2025-06-04 20:54:19'),
('4984', 'ST10100320250604065419', '1446-12-07', '2.220.10', '101', 'an.AFANDI', '0', '6000', 'Chuwez', '2025-06-04 20:54:20'),
('4985', 'ST10100320250604070310', '1446-12-07', '1.100.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '10000', '0', 'Chuwez', '2025-06-04 21:03:10'),
('4986', 'ST10100320250604070310', '1446-12-07', '2.220.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '0', '10000', 'Chuwez', '2025-06-04 21:03:10'),
('4987', 'ST10100320250604070335', '1446-12-07', '1.100.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '10000', '0', 'Chuwez', '2025-06-04 21:03:35'),
('4988', 'ST10100320250604070335', '1446-12-07', '2.220.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '0', '10000', 'Chuwez', '2025-06-04 21:03:35'),
('4989', 'ST10100320250604070357', '1446-12-07', '1.100.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '10000', '0', 'Chuwez', '2025-06-04 21:03:57'),
('4990', 'ST10100320250604070357', '1446-12-07', '2.220.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '0', '10000', 'Chuwez', '2025-06-04 21:03:57'),
('4991', 'ST10100320250604070424', '1446-12-07', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '2000', '0', 'Chuwez', '2025-06-04 21:04:24'),
('4992', 'ST10100320250604070424', '1446-12-07', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '2000', 'Chuwez', '2025-06-04 21:04:24'),
('4993', 'ST10100320250604070446', '1446-12-07', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '10000', '0', 'Chuwez', '2025-06-04 21:04:46'),
('4994', 'ST10100320250604070446', '1446-12-07', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '10000', 'Chuwez', '2025-06-04 21:04:46'),
('4995', 'ST10100320250604070509', '1446-12-07', '1.100.10', '101', 'an.MIFTAHUL JANNAH', '50000', '0', 'Chuwez', '2025-06-04 21:05:09'),
('4996', 'ST10100320250604070509', '1446-12-07', '2.220.10', '101', 'an.MIFTAHUL JANNAH', '0', '50000', 'Chuwez', '2025-06-04 21:05:09'),
('4997', 'ST10100320250604070530', '1446-12-07', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '5000', '0', 'Chuwez', '2025-06-04 21:05:30'),
('4998', 'ST10100320250604070530', '1446-12-07', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '5000', 'Chuwez', '2025-06-04 21:05:30'),
('4999', 'ST10100320250604070604', '1446-12-07', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Chuwez', '2025-06-04 21:06:04'),
('5000', 'ST10100320250604070604', '1446-12-07', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Chuwez', '2025-06-04 21:06:05'),
('5001', 'ST10100320250604070636', '1446-12-07', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'Chuwez', '2025-06-04 21:06:36'),
('5002', 'ST10100320250604070636', '1446-12-07', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'Chuwez', '2025-06-04 21:06:36'),
('5003', 'ST10100320250604070704', '1446-12-07', '1.100.10', '101', 'an.M. KAMALUDDIN', '10000', '0', 'Chuwez', '2025-06-04 21:07:04'),
('5004', 'ST10100320250604070704', '1446-12-07', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '10000', 'Chuwez', '2025-06-04 21:07:04'),
('5005', 'ST10100320250604070733', '1446-12-07', '1.100.10', '101', 'an.NABILATUN NISAUL UMMAH', '20000', '0', 'Chuwez', '2025-06-04 21:07:33'),
('5006', 'ST10100320250604070733', '1446-12-07', '2.220.10', '101', 'an.NABILATUN NISAUL UMMAH', '0', '20000', 'Chuwez', '2025-06-04 21:07:33'),
('5007', 'ST10100320250604070803', '1446-12-07', '1.100.10', '101', 'an.ROHMATULLOH', '10000', '0', 'Chuwez', '2025-06-04 21:08:03'),
('5008', 'ST10100320250604070803', '1446-12-07', '2.220.10', '101', 'an.ROHMATULLOH', '0', '10000', 'Chuwez', '2025-06-04 21:08:03'),
('5009', 'ST10100320250604070828', '1446-12-07', '1.100.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '4000', '0', 'Chuwez', '2025-06-04 21:08:28'),
('5010', 'ST10100320250604070828', '1446-12-07', '2.220.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '0', '4000', 'Chuwez', '2025-06-04 21:08:28'),
('5011', 'ST10100320250604070901', '1446-12-07', '1.100.10', '101', 'an.DIANA RIFQOTUL QOLBI', '5000', '0', 'Chuwez', '2025-06-04 21:09:01'),
('5012', 'ST10100320250604070901', '1446-12-07', '2.220.10', '101', 'an.DIANA RIFQOTUL QOLBI', '0', '5000', 'Chuwez', '2025-06-04 21:09:01'),
('5013', 'ST10100320250604070923', '1446-12-07', '1.100.10', '101', 'an.AISYAH', '5000', '0', 'Chuwez', '2025-06-04 21:09:23'),
('5014', 'ST10100320250604070923', '1446-12-07', '2.220.10', '101', 'an.AISYAH', '0', '5000', 'Chuwez', '2025-06-04 21:09:23'),
('5015', 'ST10100320250604070947', '1446-12-07', '1.100.10', '101', 'an.ALFI NURDIANA', '5000', '0', 'Chuwez', '2025-06-04 21:09:47'),
('5016', 'ST10100320250604070947', '1446-12-07', '2.220.10', '101', 'an.ALFI NURDIANA', '0', '5000', 'Chuwez', '2025-06-04 21:09:47'),
('5017', 'ST10100320250604071010', '1446-12-07', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '10000', '0', 'Chuwez', '2025-06-04 21:10:10'),
('5018', 'ST10100320250604071010', '1446-12-07', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '10000', 'Chuwez', '2025-06-04 21:10:10'),
('5019', 'ST10100320250604071307', '1446-12-07', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '10000', '0', 'Chuwez', '2025-06-04 21:13:07'),
('5020', 'ST10100320250604071307', '1446-12-07', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '10000', 'Chuwez', '2025-06-04 21:13:07'),
('5021', 'ST10100320250604071331', '1446-12-07', '1.100.10', '101', 'an.DIYANAH KAMALIYAH', '2000', '0', 'Chuwez', '2025-06-04 21:13:31'),
('5022', 'ST10100320250604071331', '1446-12-07', '2.220.10', '101', 'an.DIYANAH KAMALIYAH', '0', '2000', 'Chuwez', '2025-06-04 21:13:31'),
('5023', 'ST10100320250604071357', '1446-12-07', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '10000', '0', 'Chuwez', '2025-06-04 21:13:57'),
('5024', 'ST10100320250604071357', '1446-12-07', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '10000', 'Chuwez', '2025-06-04 21:13:57'),
('5025', 'ST10100320250604071415', '1446-12-07', '1.100.10', '101', 'an.SITI QURROTUL AINI', '2000', '0', 'Chuwez', '2025-06-04 21:14:15'),
('5026', 'ST10100320250604071415', '1446-12-07', '2.220.10', '101', 'an.SITI QURROTUL AINI', '0', '2000', 'Chuwez', '2025-06-04 21:14:15'),
('5027', 'ST10100320250604071440', '1446-12-07', '1.100.10', '101', 'an.SITI ATHIUR ROHMAH', '3000', '0', 'Chuwez', '2025-06-04 21:14:40'),
('5028', 'ST10100320250604071440', '1446-12-07', '2.220.10', '101', 'an.SITI ATHIUR ROHMAH', '0', '3000', 'Chuwez', '2025-06-04 21:14:40'),
('5029', 'ST10100320250604071458', '1446-12-07', '1.100.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '5000', '0', 'Chuwez', '2025-06-04 21:14:58'),
('5030', 'ST10100320250604071458', '1446-12-07', '2.220.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '0', '5000', 'Chuwez', '2025-06-04 21:14:58'),
('5031', 'ST10100320250604071519', '1446-12-07', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '25000', '0', 'Chuwez', '2025-06-04 21:15:19'),
('5032', 'ST10100320250604071519', '1446-12-07', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '25000', 'Chuwez', '2025-06-04 21:15:19'),
('5033', 'ST10100320250604071538', '1446-12-07', '1.100.10', '101', 'an.SINDI RAISA PUTRI', '10000', '0', 'Chuwez', '2025-06-04 21:15:38'),
('5034', 'ST10100320250604071538', '1446-12-07', '2.220.10', '101', 'an.SINDI RAISA PUTRI', '0', '10000', 'Chuwez', '2025-06-04 21:15:38'),
('5035', 'ST10100320250604071601', '1446-12-07', '1.100.10', '101', 'an.HALIMAH', '10000', '0', 'Chuwez', '2025-06-04 21:16:01'),
('5036', 'ST10100320250604071601', '1446-12-07', '2.220.10', '101', 'an.HALIMAH', '0', '10000', 'Chuwez', '2025-06-04 21:16:01'),
('5037', 'ST10100320250604071624', '1446-12-07', '1.100.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '10000', '0', 'Chuwez', '2025-06-04 21:16:24'),
('5038', 'ST10100320250604071624', '1446-12-07', '2.220.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '0', '10000', 'Chuwez', '2025-06-04 21:16:24'),
('5039', 'ST10100320250604073206', '1446-12-07', '1.100.10', '101', 'an.SAFIRATUL JANNAH', '10000', '0', 'Chuwez', '2025-06-04 21:32:06'),
('5040', 'ST10100320250604073206', '1446-12-07', '2.220.10', '101', 'an.SAFIRATUL JANNAH', '0', '10000', 'Chuwez', '2025-06-04 21:32:06'),
('5041', 'ST10100320250604073355', '1446-12-07', '1.100.10', '101', 'an.FAIZAH NURUL LITA', '5000', '0', 'Chuwez', '2025-06-04 21:33:55'),
('5042', 'ST10100320250604073355', '1446-12-07', '2.220.10', '101', 'an.FAIZAH NURUL LITA', '0', '5000', 'Chuwez', '2025-06-04 21:33:56'),
('5043', 'ST10100320250604073449', '1446-12-07', '1.100.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '5000', '0', 'Chuwez', '2025-06-04 21:34:49'),
('5044', 'ST10100320250604073449', '1446-12-07', '2.220.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '0', '5000', 'Chuwez', '2025-06-04 21:34:49'),
('5045', 'ST10100320250604073518', '1446-12-07', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'Chuwez', '2025-06-04 21:35:18'),
('5046', 'ST10100320250604073518', '1446-12-07', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'Chuwez', '2025-06-04 21:35:18'),
('5047', 'ST10100320250604073547', '1446-12-07', '1.100.10', '101', 'an.WARDATUL JANNAH', '2000', '0', 'Chuwez', '2025-06-04 21:35:47'),
('5048', 'ST10100320250604073547', '1446-12-07', '2.220.10', '101', 'an.WARDATUL JANNAH', '0', '2000', 'Chuwez', '2025-06-04 21:35:48'),
('5049', 'ST10100320250604073611', '1446-12-07', '1.100.10', '101', 'an.M. FAHMI NURUL ANAM', '10000', '0', 'Chuwez', '2025-06-04 21:36:11'),
('5050', 'ST10100320250604073611', '1446-12-07', '2.220.10', '101', 'an.M. FAHMI NURUL ANAM', '0', '10000', 'Chuwez', '2025-06-04 21:36:11'),
('5051', 'ST10100320250604073639', '1446-12-07', '1.100.10', '101', 'an.HAIKAL SHOMADANI', '2000', '0', 'Chuwez', '2025-06-04 21:36:39'),
('5052', 'ST10100320250604073639', '1446-12-07', '2.220.10', '101', 'an.HAIKAL SHOMADANI', '0', '2000', 'Chuwez', '2025-06-04 21:36:39'),
('5053', 'ST10100320250604073702', '1446-12-07', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'Chuwez', '2025-06-04 21:37:02'),
('5054', 'ST10100320250604073702', '1446-12-07', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'Chuwez', '2025-06-04 21:37:02'),
('5055', 'ST10100320250604073729', '1446-12-07', '1.100.10', '101', 'an.NAURA BILADINA', '10000', '0', 'Chuwez', '2025-06-04 21:37:29'),
('5056', 'ST10100320250604073729', '1446-12-07', '2.220.10', '101', 'an.NAURA BILADINA', '0', '10000', 'Chuwez', '2025-06-04 21:37:29'),
('5057', 'ST10100320250604073807', '1446-12-07', '1.100.10', '101', 'an.NAILATUN NIAMI', '10000', '0', 'Chuwez', '2025-06-04 21:38:07'),
('5058', 'ST10100320250604073807', '1446-12-07', '2.220.10', '101', 'an.NAILATUN NIAMI', '0', '10000', 'Chuwez', '2025-06-04 21:38:07'),
('5059', 'ST10100320250604073829', '1446-12-07', '1.100.10', '101', 'an.UBAIDAH', '10000', '0', 'Chuwez', '2025-06-04 21:38:29'),
('5060', 'ST10100320250604073829', '1446-12-07', '2.220.10', '101', 'an.UBAIDAH', '0', '10000', 'Chuwez', '2025-06-04 21:38:29'),
('5061', 'ST10100320250604073903', '1446-12-07', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '5000', '0', 'Chuwez', '2025-06-04 21:39:03'),
('5062', 'ST10100320250604073903', '1446-12-07', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '5000', 'Chuwez', '2025-06-04 21:39:03'),
('5063', 'ST10100320250604073941', '1446-12-07', '1.100.10', '101', 'an.MARIYATUL QIBTIYAH', '5000', '0', 'Chuwez', '2025-06-04 21:39:41'),
('5064', 'ST10100320250604073941', '1446-12-07', '2.220.10', '101', 'an.MARIYATUL QIBTIYAH', '0', '5000', 'Chuwez', '2025-06-04 21:39:42'),
('5065', 'ST10100320250604074037', '1446-12-07', '1.100.10', '101', 'an.BILQIS THALIA HASNA', '75000', '0', 'Chuwez', '2025-06-04 21:40:37'),
('5066', 'ST10100320250604074037', '1446-12-07', '2.220.10', '101', 'an.BILQIS THALIA HASNA', '0', '75000', 'Chuwez', '2025-06-04 21:40:37'),
('5067', 'ST10100320250604074108', '1446-12-07', '1.100.10', '101', 'an.SITI SHOFIYAH LABIBAH', '50000', '0', 'Chuwez', '2025-06-04 21:41:08'),
('5068', 'ST10100320250604074108', '1446-12-07', '2.220.10', '101', 'an.SITI SHOFIYAH LABIBAH', '0', '50000', 'Chuwez', '2025-06-04 21:41:08'),
('5069', 'ST10100320250604074212', '1446-12-07', '1.100.10', '101', 'an.HILYA', '20000', '0', 'Chuwez', '2025-06-04 21:42:12'),
('5070', 'ST10100320250604074212', '1446-12-07', '2.220.10', '101', 'an.HILYA', '0', '20000', 'Chuwez', '2025-06-04 21:42:12'),
('5071', 'ST10100320250604074238', '1446-12-07', '1.100.10', '101', 'an.M. ABD. HADI', '2000', '0', 'Chuwez', '2025-06-04 21:42:38'),
('5072', 'ST10100320250604074238', '1446-12-07', '2.220.10', '101', 'an.M. ABD. HADI', '0', '2000', 'Chuwez', '2025-06-04 21:42:38'),
('5073', 'ST10100320250604074329', '1446-12-07', '1.100.10', '101', 'an.M. ABDIL ARIKIN', '5000', '0', 'Chuwez', '2025-06-04 21:43:29'),
('5074', 'ST10100320250604074329', '1446-12-07', '2.220.10', '101', 'an.M. ABDIL ARIKIN', '0', '5000', 'Chuwez', '2025-06-04 21:43:29'),
('5075', 'ST10100320250604074352', '1446-12-07', '1.100.10', '101', 'an.AULIA AZZAHRA', '10000', '0', 'Chuwez', '2025-06-04 21:43:52'),
('5076', 'ST10100320250604074352', '1446-12-07', '2.220.10', '101', 'an.AULIA AZZAHRA', '0', '10000', 'Chuwez', '2025-06-04 21:43:52'),
('5077', 'BS10100320250604074848000', '1446-10-07', '1.100.10', '101', 'Bayar[MOCH.AMMAR HAFIDZ FADLULLOH]', '30000', '0', 'Chuwez', '2025-06-04 14:48:48'),
('5078', 'BS10100320250604074848000', '1446-10-07', '4.400.20', '101', 'Bayar[MOCH.AMMAR HAFIDZ FADLULLOH]', '0', '30000', 'Chuwez', '2025-06-04 14:48:48'),
('5079', 'BS10100320250604074848001', '1446-11-07', '1.100.10', '101', 'Bayar[MOCH.AMMAR HAFIDZ FADLULLOH]', '30000', '0', 'Chuwez', '2025-06-04 14:48:48'),
('5080', 'BS10100320250604074848001', '1446-11-07', '4.400.20', '101', 'Bayar[MOCH.AMMAR HAFIDZ FADLULLOH]', '0', '30000', 'Chuwez', '2025-06-04 14:48:48'),
('5081', 'BS10100320250604074848002', '1446-12-07', '1.100.10', '101', 'Bayar[MOCH.AMMAR HAFIDZ FADLULLOH]', '30000', '0', 'Chuwez', '2025-06-04 14:48:48'),
('5082', 'BS10100320250604074848002', '1446-12-07', '4.400.20', '101', 'Bayar[MOCH.AMMAR HAFIDZ FADLULLOH]', '0', '30000', 'Chuwez', '2025-06-04 14:48:48'),
('5083', 'BS10100320250604074915000', '1446-12-07', '1.100.10', '101', 'Bayar[M. KAMALUDDIN]', '30000', '0', 'Chuwez', '2025-06-04 14:49:15'),
('5084', 'BS10100320250604074915000', '1446-12-07', '4.400.20', '101', 'Bayar[M. KAMALUDDIN]', '0', '30000', 'Chuwez', '2025-06-04 14:49:15'),
('5085', 'BS10100320250604074945000', '1446-11-07', '1.100.10', '101', 'Bayar[NAURA BILADINA]', '30000', '0', 'Chuwez', '2025-06-04 14:49:45'),
('5086', 'BS10100320250604074945000', '1446-11-07', '4.400.20', '101', 'Bayar[NAURA BILADINA]', '0', '30000', 'Chuwez', '2025-06-04 14:49:45'),
('5087', 'BS10100320250604074945001', '1446-12-07', '1.100.10', '101', 'Bayar[NAURA BILADINA]', '30000', '0', 'Chuwez', '2025-06-04 14:49:45'),
('5088', 'BS10100320250604074945001', '1446-12-07', '4.400.20', '101', 'Bayar[NAURA BILADINA]', '0', '30000', 'Chuwez', '2025-06-04 14:49:45'),
('5089', 'BS10100320250604075016000', '1446-11-07', '1.100.10', '101', 'Bayar[SALWA LAILI]', '30000', '0', 'Chuwez', '2025-06-04 14:50:16'),
('5090', 'BS10100320250604075016000', '1446-11-07', '4.400.20', '101', 'Bayar[SALWA LAILI]', '0', '30000', 'Chuwez', '2025-06-04 14:50:16'),
('5091', 'BS10100320250604075016001', '1446-12-07', '1.100.10', '101', 'Bayar[SALWA LAILI]', '30000', '0', 'Chuwez', '2025-06-04 14:50:16'),
('5092', 'BS10100320250604075016001', '1446-12-07', '4.400.20', '101', 'Bayar[SALWA LAILI]', '0', '30000', 'Chuwez', '2025-06-04 14:50:16'),
('5093', 'BS10100320250604075258000', '1446-10-07', '1.100.10', '101', 'Bayar[FITRI RAMAN DHANI]', '30000', '0', 'Chuwez', '2025-06-04 14:52:58'),
('5094', 'BS10100320250604075258000', '1446-10-07', '4.400.20', '101', 'Bayar[FITRI RAMAN DHANI]', '0', '30000', 'Chuwez', '2025-06-04 14:52:58'),
('5095', 'BS10100320250604075258001', '1446-11-07', '1.100.10', '101', 'Bayar[FITRI RAMAN DHANI]', '30000', '0', 'Chuwez', '2025-06-04 14:52:58'),
('5096', 'BS10100320250604075258001', '1446-11-07', '4.400.20', '101', 'Bayar[FITRI RAMAN DHANI]', '0', '30000', 'Chuwez', '2025-06-04 14:52:58'),
('5097', 'BS10100320250604075258002', '1446-12-07', '1.100.10', '101', 'Bayar[FITRI RAMAN DHANI]', '30000', '0', 'Chuwez', '2025-06-04 14:52:58'),
('5098', 'BS10100320250604075258002', '1446-12-07', '4.400.20', '101', 'Bayar[FITRI RAMAN DHANI]', '0', '30000', 'Chuwez', '2025-06-04 14:52:58'),
('5099', 'BS10100320250604075328000', '1446-10-07', '1.100.10', '101', 'Bayar[AISYAH]', '30000', '0', 'Chuwez', '2025-06-04 14:53:28'),
('5100', 'BS10100320250604075328000', '1446-10-07', '4.400.20', '101', 'Bayar[AISYAH]', '0', '30000', 'Chuwez', '2025-06-04 14:53:28'),
('5101', 'BS10100320250604075328001', '1446-11-07', '1.100.10', '101', 'Bayar[AISYAH]', '30000', '0', 'Chuwez', '2025-06-04 14:53:28'),
('5102', 'BS10100320250604075328001', '1446-11-07', '4.400.20', '101', 'Bayar[AISYAH]', '0', '30000', 'Chuwez', '2025-06-04 14:53:28'),
('5103', 'D110100320250604082411', '1446-12-07', '1.100.10', '101', 'Bayar[MOCH.AMMAR HAFIDZ FADLULLOH]', '20000', '0', 'Chuwez', '2025-06-04 15:24:11'),
('5104', 'D110100320250604082411', '1446-12-07', '4.400.22', '101', 'Bayar[MOCH.AMMAR HAFIDZ FADLULLOH]', '0', '20000', 'Chuwez', '2025-06-04 15:24:11'),
('5105', 'D110100320250604082447', '1446-12-07', '1.100.10', '101', 'Bayar[M. KAMALUDDIN]', '35000', '0', 'Chuwez', '2025-06-04 15:24:47'),
('5106', 'D110100320250604082447', '1446-12-07', '4.400.22', '101', 'Bayar[M. KAMALUDDIN]', '0', '35000', 'Chuwez', '2025-06-04 15:24:47'),
('5107', 'ST10100320250604082812', '1446-12-07', '1.100.10', '101', 'an.AHMAD ADITIYA', '2000', '0', 'Chuwez', '2025-06-04 22:28:12'),
('5108', 'ST10100320250604082812', '1446-12-07', '2.220.10', '101', 'an.AHMAD ADITIYA', '0', '2000', 'Chuwez', '2025-06-04 22:28:13'),
('5109', 'ST10100320250605081847', '1446-12-08', '1.100.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '5000', '0', 'Chuwez', '2025-06-05 15:18:47'),
('5110', 'ST10100320250605081847', '1446-12-08', '2.220.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '0', '5000', 'Chuwez', '2025-06-05 15:18:47'),
('5111', 'ST10100320250605082026', '1446-12-08', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '10000', '0', 'Chuwez', '2025-06-05 15:20:26'),
('5112', 'ST10100320250605082026', '1446-12-08', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '10000', 'Chuwez', '2025-06-05 15:20:26'),
('5113', 'ST10100320250605082104', '1446-12-08', '1.100.10', '101', 'an.AULIA AZZAHRA', '5000', '0', 'Chuwez', '2025-06-05 15:21:04'),
('5114', 'ST10100320250605082104', '1446-12-08', '2.220.10', '101', 'an.AULIA AZZAHRA', '0', '5000', 'Chuwez', '2025-06-05 15:21:04'),
('5115', 'ST10100320250605082120', '1446-12-08', '1.100.10', '101', 'an.NAURA BILADINA', '10000', '0', 'Chuwez', '2025-06-05 15:21:20'),
('5116', 'ST10100320250605082120', '1446-12-08', '2.220.10', '101', 'an.NAURA BILADINA', '0', '10000', 'Chuwez', '2025-06-05 15:21:20'),
('5117', 'ST10100320250605082151', '1446-12-08', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'Chuwez', '2025-06-05 15:21:51'),
('5118', 'ST10100320250605082151', '1446-12-08', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'Chuwez', '2025-06-05 15:21:51'),
('5119', 'ST10100320250605082210', '1446-12-08', '1.100.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '10000', '0', 'Chuwez', '2025-06-05 15:22:10'),
('5120', 'ST10100320250605082210', '1446-12-08', '2.220.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '0', '10000', 'Chuwez', '2025-06-05 15:22:10'),
('5121', 'ST10100320250605082229', '1446-12-08', '1.100.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '10000', '0', 'Chuwez', '2025-06-05 15:22:29'),
('5122', 'ST10100320250605082229', '1446-12-08', '2.220.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '0', '10000', 'Chuwez', '2025-06-05 15:22:29'),
('5123', 'ST10100320250605082245', '1446-12-08', '1.100.10', '101', 'an.M. ABD. HADI', '2000', '0', 'Chuwez', '2025-06-05 15:22:45'),
('5124', 'ST10100320250605082245', '1446-12-08', '2.220.10', '101', 'an.M. ABD. HADI', '0', '2000', 'Chuwez', '2025-06-05 15:22:45'),
('5125', 'ST10100320250605082312', '1446-12-08', '1.100.10', '101', 'an.SAUQY AHMAD', '5000', '0', 'Chuwez', '2025-06-05 15:23:12'),
('5126', 'ST10100320250605082312', '1446-12-08', '2.220.10', '101', 'an.SAUQY AHMAD', '0', '5000', 'Chuwez', '2025-06-05 15:23:12'),
('5127', 'ST10100320250605082324', '1446-12-08', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '10000', '0', 'Chuwez', '2025-06-05 15:23:24'),
('5128', 'ST10100320250605082324', '1446-12-08', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '10000', 'Chuwez', '2025-06-05 15:23:24'),
('5129', 'ST10100320250605082337', '1446-12-08', '1.100.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '4000', '0', 'Chuwez', '2025-06-05 15:23:37'),
('5130', 'ST10100320250605082337', '1446-12-08', '2.220.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '0', '4000', 'Chuwez', '2025-06-05 15:23:37'),
('5131', 'ST10100320250605082352', '1446-12-08', '1.100.10', '101', 'an.ROFIQOTUS SARIROH', '10000', '0', 'Chuwez', '2025-06-05 15:23:52'),
('5132', 'ST10100320250605082352', '1446-12-08', '2.220.10', '101', 'an.ROFIQOTUS SARIROH', '0', '10000', 'Chuwez', '2025-06-05 15:23:52'),
('5133', 'ST10100320250605082406', '1446-12-08', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'Chuwez', '2025-06-05 15:24:06'),
('5134', 'ST10100320250605082406', '1446-12-08', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'Chuwez', '2025-06-05 15:24:06'),
('5135', 'ST10100320250605082424', '1446-12-08', '1.100.10', '101', 'an.MARIATUL QIBTIYAH', '2000', '0', 'Chuwez', '2025-06-05 15:24:24'),
('5136', 'ST10100320250605082424', '1446-12-08', '2.220.10', '101', 'an.MARIATUL QIBTIYAH', '0', '2000', 'Chuwez', '2025-06-05 15:24:24'),
('5137', 'ST10100320250605082443', '1446-12-08', '1.100.10', '101', 'an.NAILATUN NIAMI', '3000', '0', 'Chuwez', '2025-06-05 15:24:43'),
('5138', 'ST10100320250605082443', '1446-12-08', '2.220.10', '101', 'an.NAILATUN NIAMI', '0', '3000', 'Chuwez', '2025-06-05 15:24:43'),
('5139', 'ST10100320250605082500', '1446-12-08', '1.100.10', '101', 'an.RAISA ANNISA', '5000', '0', 'Chuwez', '2025-06-05 15:25:00'),
('5140', 'ST10100320250605082500', '1446-12-08', '2.220.10', '101', 'an.RAISA ANNISA', '0', '5000', 'Chuwez', '2025-06-05 15:25:00'),
('5141', 'ST10100320250605082515', '1446-12-08', '1.100.10', '101', 'an.MARIYATUL QIBTIYAH', '5000', '0', 'Chuwez', '2025-06-05 15:25:15'),
('5142', 'ST10100320250605082515', '1446-12-08', '2.220.10', '101', 'an.MARIYATUL QIBTIYAH', '0', '5000', 'Chuwez', '2025-06-05 15:25:15'),
('5143', 'ST10100320250605082726', '1446-12-08', '1.100.10', '101', 'an.HILYA', '50000', '0', 'Chuwez', '2025-06-05 15:27:26'),
('5144', 'ST10100320250605082726', '1446-12-08', '2.220.10', '101', 'an.HILYA', '0', '50000', 'Chuwez', '2025-06-05 15:27:26'),
('5145', 'ST10100320250605082907', '1446-12-08', '1.100.10', '101', 'an.AISYAH', '5000', '0', 'Chuwez', '2025-06-05 15:29:07'),
('5146', 'ST10100320250605082907', '1446-12-08', '2.220.10', '101', 'an.AISYAH', '0', '5000', 'Chuwez', '2025-06-05 15:29:07'),
('5147', 'ST10100320250605082925', '1446-12-08', '1.100.10', '101', 'an.DIANA RIFQOTUL QOLBI', '5000', '0', 'Chuwez', '2025-06-05 15:29:25'),
('5148', 'ST10100320250605082925', '1446-12-08', '2.220.10', '101', 'an.DIANA RIFQOTUL QOLBI', '0', '5000', 'Chuwez', '2025-06-05 15:29:25'),
('5149', 'ST10100320250605083026', '1446-12-08', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '10000', '0', 'Chuwez', '2025-06-05 15:30:26'),
('5150', 'ST10100320250605083026', '1446-12-08', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '10000', 'Chuwez', '2025-06-05 15:30:26'),
('5151', 'ST10100320250605083048', '1446-12-08', '1.100.10', '101', 'an.AZKA AUFARIL MINAN', '20000', '0', 'Chuwez', '2025-06-05 15:30:48'),
('5152', 'ST10100320250605083048', '1446-12-08', '2.220.10', '101', 'an.AZKA AUFARIL MINAN', '0', '20000', 'Chuwez', '2025-06-05 15:30:48'),
('5153', 'ST10100320250605083105', '1446-12-08', '1.100.10', '101', 'an.AHMAD ADITIYA', '5000', '0', 'Chuwez', '2025-06-05 15:31:05'),
('5154', 'ST10100320250605083105', '1446-12-08', '2.220.10', '101', 'an.AHMAD ADITIYA', '0', '5000', 'Chuwez', '2025-06-05 15:31:05'),
('5155', 'ST10100320250605083121', '1446-12-08', '1.100.10', '101', 'an.ALFI NURDIANA', '5000', '0', 'Chuwez', '2025-06-05 15:31:21'),
('5156', 'ST10100320250605083121', '1446-12-08', '2.220.10', '101', 'an.ALFI NURDIANA', '0', '5000', 'Chuwez', '2025-06-05 15:31:21'),
('5157', 'ST10100320250605083140', '1446-12-08', '1.100.10', '101', 'an.AHMAD SYAHRU ROMADHONI', '10000', '0', 'Chuwez', '2025-06-05 15:31:40'),
('5158', 'ST10100320250605083140', '1446-12-08', '2.220.10', '101', 'an.AHMAD SYAHRU ROMADHONI', '0', '10000', 'Chuwez', '2025-06-05 15:31:40'),
('5159', 'ST10100320250605083154', '1446-12-08', '1.100.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '10000', '0', 'Chuwez', '2025-06-05 15:31:54'),
('5160', 'ST10100320250605083154', '1446-12-08', '2.220.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '0', '10000', 'Chuwez', '2025-06-05 15:31:54'),
('5161', 'ST10100320250605083215', '1446-12-08', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '10000', '0', 'Chuwez', '2025-06-05 15:32:15'),
('5162', 'ST10100320250605083215', '1446-12-08', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '10000', 'Chuwez', '2025-06-05 15:32:15'),
('5163', 'ST10100320250605083237', '1446-12-08', '1.100.10', '101', 'an.WARDATUL JANNAH', '2000', '0', 'Chuwez', '2025-06-05 15:32:37'),
('5164', 'ST10100320250605083237', '1446-12-08', '2.220.10', '101', 'an.WARDATUL JANNAH', '0', '2000', 'Chuwez', '2025-06-05 15:32:37'),
('5165', 'ST10100320250605083250', '1446-12-08', '1.100.10', '101', 'an.SITI QURROTUL AINI', '5000', '0', 'Chuwez', '2025-06-05 15:32:50'),
('5166', 'ST10100320250605083250', '1446-12-08', '2.220.10', '101', 'an.SITI QURROTUL AINI', '0', '5000', 'Chuwez', '2025-06-05 15:32:50'),
('5167', 'ST10100320250605083310', '1446-12-08', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '2000', '0', 'Chuwez', '2025-06-05 15:33:10'),
('5168', 'ST10100320250605083310', '1446-12-08', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '2000', 'Chuwez', '2025-06-05 15:33:10'),
('5169', 'ST10100320250605083323', '1446-12-08', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '10000', '0', 'Chuwez', '2025-06-05 15:33:23'),
('5170', 'ST10100320250605083323', '1446-12-08', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '10000', 'Chuwez', '2025-06-05 15:33:23'),
('5171', 'ST10100320250605083340', '1446-12-08', '1.100.10', '101', 'an.M. KAMALUDDIN', '10000', '0', 'Chuwez', '2025-06-05 15:33:40'),
('5172', 'ST10100320250605083340', '1446-12-08', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '10000', 'Chuwez', '2025-06-05 15:33:40'),
('5173', 'ST10100320250605083358', '1446-12-08', '1.100.10', '101', 'an.MUHAMMAD ILHAM', '5000', '0', 'Chuwez', '2025-06-05 15:33:58'),
('5174', 'ST10100320250605083358', '1446-12-08', '2.220.10', '101', 'an.MUHAMMAD ILHAM', '0', '5000', 'Chuwez', '2025-06-05 15:33:58'),
('5175', 'ST10100320250605083418', '1446-12-08', '1.100.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '20000', '0', 'Chuwez', '2025-06-05 15:34:18'),
('5176', 'ST10100320250605083418', '1446-12-08', '2.220.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '0', '20000', 'Chuwez', '2025-06-05 15:34:18'),
('5177', 'ST10100320250605083508', '1446-12-08', '1.100.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '10000', '0', 'Chuwez', '2025-06-05 15:35:08'),
('5178', 'ST10100320250605083508', '1446-12-08', '2.220.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '0', '10000', 'Chuwez', '2025-06-05 15:35:08'),
('5179', 'ST10100320250605083524', '1446-12-08', '1.100.10', '101', 'an.NABILATUN NISAUL UMMAH', '20000', '0', 'Chuwez', '2025-06-05 15:35:24'),
('5180', 'ST10100320250605083524', '1446-12-08', '2.220.10', '101', 'an.NABILATUN NISAUL UMMAH', '0', '20000', 'Chuwez', '2025-06-05 15:35:24'),
('5181', 'ST10100320250605083537', '1446-12-08', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Chuwez', '2025-06-05 15:35:37'),
('5182', 'ST10100320250605083537', '1446-12-08', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Chuwez', '2025-06-05 15:35:37'),
('5183', 'ST10100320250605083554', '1446-12-08', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '4000', '0', 'Chuwez', '2025-06-05 15:35:54'),
('5184', 'ST10100320250605083554', '1446-12-08', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '4000', 'Chuwez', '2025-06-05 15:35:54'),
('5185', 'ST10100320250605083609', '1446-12-08', '1.100.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '10000', '0', 'Chuwez', '2025-06-05 15:36:09'),
('5186', 'ST10100320250605083609', '1446-12-08', '2.220.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '0', '10000', 'Chuwez', '2025-06-05 15:36:09'),
('5187', 'ST10100320250605083626', '1446-12-08', '1.100.10', '101', 'an.MIFTAHUL JANNAH', '100000', '0', 'Chuwez', '2025-06-05 15:36:26'),
('5188', 'ST10100320250605083626', '1446-12-08', '2.220.10', '101', 'an.MIFTAHUL JANNAH', '0', '100000', 'Chuwez', '2025-06-05 15:36:26'),
('5189', 'ST10100320250605083652', '1446-12-08', '1.100.10', '101', 'an.AHMAD ABBAS MAULANA', '5000', '0', 'Chuwez', '2025-06-05 15:36:52'),
('5190', 'ST10100320250605083652', '1446-12-08', '2.220.10', '101', 'an.AHMAD ABBAS MAULANA', '0', '5000', 'Chuwez', '2025-06-05 15:36:52'),
('5191', 'ST10100320250605083706', '1446-12-08', '1.100.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '10000', '0', 'Chuwez', '2025-06-05 15:37:06'),
('5192', 'ST10100320250605083706', '1446-12-08', '2.220.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '0', '10000', 'Chuwez', '2025-06-05 15:37:06'),
('5193', 'ST10100320250605083721', '1446-12-08', '1.100.10', '101', 'an.SINDI RAISA PUTRI', '10000', '0', 'Chuwez', '2025-06-05 15:37:21'),
('5194', 'ST10100320250605083721', '1446-12-08', '2.220.10', '101', 'an.SINDI RAISA PUTRI', '0', '10000', 'Chuwez', '2025-06-05 15:37:21'),
('5195', 'ST10100320250605083738', '1446-12-08', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '25000', '0', 'Chuwez', '2025-06-05 15:37:38'),
('5196', 'ST10100320250605083738', '1446-12-08', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '25000', 'Chuwez', '2025-06-05 15:37:38'),
('5197', 'ST10100320250605083757', '1446-12-08', '1.100.10', '101', 'an.BILQIS THALIA HASNA', '25000', '0', 'Chuwez', '2025-06-05 15:37:57'),
('5198', 'ST10100320250605083757', '1446-12-08', '2.220.10', '101', 'an.BILQIS THALIA HASNA', '0', '25000', 'Chuwez', '2025-06-05 15:37:57'),
('5199', 'ST10100320250605083824', '1446-12-08', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '5000', '0', 'Chuwez', '2025-06-05 15:38:24'),
('5200', 'ST10100320250605083824', '1446-12-08', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '5000', 'Chuwez', '2025-06-05 15:38:24'),
('5201', 'ST10100320250605083837', '1446-12-08', '1.100.10', '101', 'an.ZAKIYATUL UMMAH', '2000', '0', 'Chuwez', '2025-06-05 15:38:37'),
('5202', 'ST10100320250605083837', '1446-12-08', '2.220.10', '101', 'an.ZAKIYATUL UMMAH', '0', '2000', 'Chuwez', '2025-06-05 15:38:37'),
('5203', 'ST10100320250605083853', '1446-12-08', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '5000', '0', 'Chuwez', '2025-06-05 15:38:53'),
('5204', 'ST10100320250605083853', '1446-12-08', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '5000', 'Chuwez', '2025-06-05 15:38:53'),
('5205', 'ST10100320250605083914', '1446-12-08', '1.100.10', '101', 'an.ANA SALSABILA', '5000', '0', 'Chuwez', '2025-06-05 15:39:14'),
('5206', 'ST10100320250605083914', '1446-12-08', '2.220.10', '101', 'an.ANA SALSABILA', '0', '5000', 'Chuwez', '2025-06-05 15:39:14'),
('5207', 'ST10100320250605083934', '1446-12-08', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '5000', '0', 'Chuwez', '2025-06-05 15:39:34'),
('5208', 'ST10100320250605083934', '1446-12-08', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '5000', 'Chuwez', '2025-06-05 15:39:34'),
('5209', 'ST10100320250605083955', '1446-12-08', '1.100.10', '101', 'an.SAFIRATUL JANNAH', '10000', '0', 'Chuwez', '2025-06-05 15:39:55'),
('5210', 'ST10100320250605083955', '1446-12-08', '2.220.10', '101', 'an.SAFIRATUL JANNAH', '0', '10000', 'Chuwez', '2025-06-05 15:39:55'),
('5211', 'ST10100320250605084014', '1446-12-08', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'Chuwez', '2025-06-05 15:40:14'),
('5212', 'ST10100320250605084014', '1446-12-08', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'Chuwez', '2025-06-05 15:40:14'),
('5213', 'ST10100320250605084034', '1446-12-08', '1.100.10', '101', 'an.HALIMAH', '5000', '0', 'Chuwez', '2025-06-05 15:40:34'),
('5214', 'ST10100320250605084034', '1446-12-08', '2.220.10', '101', 'an.HALIMAH', '0', '5000', 'Chuwez', '2025-06-05 15:40:34'),
('5215', 'D110100320250605085324', '1446-12-08', '1.100.10', '101', 'Bayar[SALWA LAILI]', '20000', '0', 'Chuwez', '2025-06-05 15:53:24'),
('5216', 'D110100320250605085324', '1446-12-08', '4.400.22', '101', 'Bayar[SALWA LAILI]', '0', '20000', 'Chuwez', '2025-06-05 15:53:24'),
('5217', 'D110100320250605085354', '1446-12-08', '1.100.10', '101', 'Bayar[AFZAN FAISAL MAULANA]', '20000', '0', 'Chuwez', '2025-06-05 15:53:54'),
('5218', 'D110100320250605085354', '1446-12-08', '4.400.22', '101', 'Bayar[AFZAN FAISAL MAULANA]', '0', '20000', 'Chuwez', '2025-06-05 15:53:54'),
('5219', 'D110100320250605085422', '1446-12-08', '1.100.10', '101', 'Bayar[M. DESTRA MAULANA]', '35000', '0', 'Chuwez', '2025-06-05 15:54:22'),
('5220', 'D110100320250605085422', '1446-12-08', '4.400.22', '101', 'Bayar[M. DESTRA MAULANA]', '0', '35000', 'Chuwez', '2025-06-05 15:54:22'),
('5221', 'BS10100320250605085507000', '1446-12-08', '1.100.10', '101', 'Bayar[M. DESTRA MAULANA]', '30000', '0', 'Chuwez', '2025-06-05 15:55:07'),
('5222', 'BS10100320250605085507000', '1446-12-08', '4.400.20', '101', 'Bayar[M. DESTRA MAULANA]', '0', '30000', 'Chuwez', '2025-06-05 15:55:07'),
('5223', 'BS10100320250605085543000', '1446-12-08', '1.100.10', '101', 'Bayar[MASRUROTUL MAULUDIYAH]', '30000', '0', 'Chuwez', '2025-06-05 15:55:43'),
('5224', 'BS10100320250605085543000', '1446-12-08', '4.400.20', '101', 'Bayar[MASRUROTUL MAULUDIYAH]', '0', '30000', 'Chuwez', '2025-06-05 15:55:43'),
('5225', 'KI10100220250605125231', '1446-12-08', '1.100.10', '101', 'Bayar[AHMAD ABBAS MAULANA]', '50000', '0', 'Ipul', '2025-06-05 19:52:31'),
('5226', 'KI10100220250605125231', '1446-12-08', '4.400.21', '101', 'Bayar[AHMAD ABBAS MAULANA]', '0', '50000', 'Ipul', '2025-06-05 19:52:31'),
('5227', 'ST10100320250608073551', '1446-12-11', '1.100.10', '101', 'an.KHOIRIYAH', '50000', '0', 'Chuwez', '2025-06-08 14:35:51'),
('5228', 'ST10100320250608073551', '1446-12-11', '2.220.10', '101', 'an.KHOIRIYAH', '0', '50000', 'Chuwez', '2025-06-08 14:35:51'),
('5229', 'ST10100320250608073617', '1446-12-11', '1.100.10', '101', 'an.SITI QURROTUL AINI', '2000', '0', 'Chuwez', '2025-06-08 14:36:17'),
('5230', 'ST10100320250608073617', '1446-12-11', '2.220.10', '101', 'an.SITI QURROTUL AINI', '0', '2000', 'Chuwez', '2025-06-08 14:36:17'),
('5231', 'ST10100320250608073641', '1446-12-11', '1.100.10', '101', 'an.M. KAMALUDDIN', '10000', '0', 'Chuwez', '2025-06-08 14:36:41'),
('5232', 'ST10100320250608073641', '1446-12-11', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '10000', 'Chuwez', '2025-06-08 14:36:41'),
('5233', 'ST10100320250608073708', '1446-12-11', '1.100.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '20000', '0', 'Chuwez', '2025-06-08 14:37:08'),
('5234', 'ST10100320250608073708', '1446-12-11', '2.220.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '0', '20000', 'Chuwez', '2025-06-08 14:37:08'),
('5235', 'ST10100320250608073747', '1446-12-11', '1.100.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '10000', '0', 'Chuwez', '2025-06-08 14:37:47'),
('5236', 'ST10100320250608073747', '1446-12-11', '2.220.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '0', '10000', 'Chuwez', '2025-06-08 14:37:47'),
('5237', 'ST10100320250608073811', '1446-12-11', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'Chuwez', '2025-06-08 14:38:11'),
('5238', 'ST10100320250608073811', '1446-12-11', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'Chuwez', '2025-06-08 14:38:11'),
('5239', 'ST10100320250608073836', '1446-12-11', '1.100.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '2000', '0', 'Chuwez', '2025-06-08 14:38:36'),
('5240', 'ST10100320250608073836', '1446-12-11', '2.220.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '0', '2000', 'Chuwez', '2025-06-08 14:38:36'),
('5241', 'ST10100320250608073902', '1446-12-11', '1.100.10', '101', 'an.AHMAD ADITIYA', '10000', '0', 'Chuwez', '2025-06-08 14:39:02'),
('5242', 'ST10100320250608073902', '1446-12-11', '2.220.10', '101', 'an.AHMAD ADITIYA', '0', '10000', 'Chuwez', '2025-06-08 14:39:02'),
('5243', 'ST10100320250608074025', '1446-12-11', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '10000', '0', 'Chuwez', '2025-06-08 14:40:25'),
('5244', 'ST10100320250608074025', '1446-12-11', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '10000', 'Chuwez', '2025-06-08 14:40:25'),
('5245', 'ST10100320250608074048', '1446-12-11', '1.100.10', '101', 'an.SITI SHOFIYAH LABIBAH', '50000', '0', 'Chuwez', '2025-06-08 14:40:48'),
('5246', 'ST10100320250608074048', '1446-12-11', '2.220.10', '101', 'an.SITI SHOFIYAH LABIBAH', '0', '50000', 'Chuwez', '2025-06-08 14:40:48'),
('5247', 'ST10100320250608074116', '1446-12-11', '1.100.10', '101', 'an.NAURA BILADINA', '20000', '0', 'Chuwez', '2025-06-08 14:41:16'),
('5248', 'ST10100320250608074116', '1446-12-11', '2.220.10', '101', 'an.NAURA BILADINA', '0', '20000', 'Chuwez', '2025-06-08 14:41:16'),
('5249', 'ST10100320250608074138', '1446-12-11', '1.100.10', '101', 'an.M. ABD. HADI', '2000', '0', 'Chuwez', '2025-06-08 14:41:38'),
('5250', 'ST10100320250608074138', '1446-12-11', '2.220.10', '101', 'an.M. ABD. HADI', '0', '2000', 'Chuwez', '2025-06-08 14:41:38'),
('5251', 'ST10100320250608074159', '1446-12-11', '1.100.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '5000', '0', 'Chuwez', '2025-06-08 14:41:59'),
('5252', 'ST10100320250608074159', '1446-12-11', '2.220.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '0', '5000', 'Chuwez', '2025-06-08 14:41:59'),
('5253', 'ST10100320250608074231', '1446-12-11', '1.100.10', '101', 'an.UMAR FARUQ', '20000', '0', 'Chuwez', '2025-06-08 14:42:31'),
('5254', 'ST10100320250608074231', '1446-12-11', '2.220.10', '101', 'an.UMAR FARUQ', '0', '20000', 'Chuwez', '2025-06-08 14:42:31'),
('5255', 'ST10100320250608074249', '1446-12-11', '1.100.10', '101', 'an.RAISA ANNISA', '5000', '0', 'Chuwez', '2025-06-08 14:42:49'),
('5256', 'ST10100320250608074249', '1446-12-11', '2.220.10', '101', 'an.RAISA ANNISA', '0', '5000', 'Chuwez', '2025-06-08 14:42:49'),
('5257', 'ST10100320250608074312', '1446-12-11', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'Chuwez', '2025-06-08 14:43:12'),
('5258', 'ST10100320250608074312', '1446-12-11', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'Chuwez', '2025-06-08 14:43:12'),
('5259', 'ST10100320250608074332', '1446-12-11', '1.100.10', '101', 'an.MARIYATUL QIBTIYAH', '4000', '0', 'Chuwez', '2025-06-08 14:43:32'),
('5260', 'ST10100320250608074332', '1446-12-11', '2.220.10', '101', 'an.MARIYATUL QIBTIYAH', '0', '4000', 'Chuwez', '2025-06-08 14:43:32'),
('5261', 'ST10100320250608074446', '1446-12-11', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '10000', '0', 'Chuwez', '2025-06-08 14:44:46'),
('5262', 'ST10100320250608074446', '1446-12-11', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '10000', 'Chuwez', '2025-06-08 14:44:46'),
('5263', 'ST10100320250608074509', '1446-12-11', '1.100.10', '101', 'an.FAIZAH NURUL LITA', '10000', '0', 'Chuwez', '2025-06-08 14:45:09'),
('5264', 'ST10100320250608074509', '1446-12-11', '2.220.10', '101', 'an.FAIZAH NURUL LITA', '0', '10000', 'Chuwez', '2025-06-08 14:45:09'),
('5265', 'ST10100320250608074530', '1446-12-11', '1.100.10', '101', 'an.NAILATUN NIAMI', '5000', '0', 'Chuwez', '2025-06-08 14:45:30'),
('5266', 'ST10100320250608074530', '1446-12-11', '2.220.10', '101', 'an.NAILATUN NIAMI', '0', '5000', 'Chuwez', '2025-06-08 14:45:30'),
('5267', 'ST10100320250608074549', '1446-12-11', '1.100.10', '101', 'an.UBAIDAH', '10000', '0', 'Chuwez', '2025-06-08 14:45:49'),
('5268', 'ST10100320250608074549', '1446-12-11', '2.220.10', '101', 'an.UBAIDAH', '0', '10000', 'Chuwez', '2025-06-08 14:45:49'),
('5269', 'ST10100320250608074612', '1446-12-11', '1.100.10', '101', 'an.MUHAMMAD ALWI', '30000', '0', 'Chuwez', '2025-06-08 14:46:12'),
('5270', 'ST10100320250608074612', '1446-12-11', '2.220.10', '101', 'an.MUHAMMAD ALWI', '0', '30000', 'Chuwez', '2025-06-08 14:46:12'),
('5271', 'ST10100320250608074747', '1446-12-11', '1.100.10', '101', 'an.M. DESTRA MAULANA', '10000', '0', 'Chuwez', '2025-06-08 14:47:47'),
('5272', 'ST10100320250608074747', '1446-12-11', '2.220.10', '101', 'an.M. DESTRA MAULANA', '0', '10000', 'Chuwez', '2025-06-08 14:47:47'),
('5273', 'ST10100320250608074805', '1446-12-11', '1.100.10', '101', 'an.AISYAH', '5000', '0', 'Chuwez', '2025-06-08 14:48:05'),
('5274', 'ST10100320250608074805', '1446-12-11', '2.220.10', '101', 'an.AISYAH', '0', '5000', 'Chuwez', '2025-06-08 14:48:05'),
('5275', 'ST10100320250608074827', '1446-12-11', '1.100.10', '101', 'an.MASRUROTUL MAULUDIYAH', '10000', '0', 'Chuwez', '2025-06-08 14:48:27'),
('5276', 'ST10100320250608074827', '1446-12-11', '2.220.10', '101', 'an.MASRUROTUL MAULUDIYAH', '0', '10000', 'Chuwez', '2025-06-08 14:48:27'),
('5277', 'ST10100320250608074850', '1446-12-11', '1.100.10', '101', 'an.ALFI NURDIANA', '5000', '0', 'Chuwez', '2025-06-08 14:48:50'),
('5278', 'ST10100320250608074850', '1446-12-11', '2.220.10', '101', 'an.ALFI NURDIANA', '0', '5000', 'Chuwez', '2025-06-08 14:48:50'),
('5279', 'ST10100320250608074916', '1446-12-11', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '5000', '0', 'Chuwez', '2025-06-08 14:49:16'),
('5280', 'ST10100320250608074916', '1446-12-11', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '5000', 'Chuwez', '2025-06-08 14:49:16'),
('5281', 'ST10100320250608074945', '1446-12-11', '1.100.10', '101', 'an.AZKA AUFARIL MINAN', '10000', '0', 'Chuwez', '2025-06-08 14:49:45'),
('5282', 'ST10100320250608074945', '1446-12-11', '2.220.10', '101', 'an.AZKA AUFARIL MINAN', '0', '10000', 'Chuwez', '2025-06-08 14:49:45'),
('5283', 'ST10100320250608075004', '1446-12-11', '1.100.10', '101', 'an.LAILATUL MAGHFIROH', '10000', '0', 'Chuwez', '2025-06-08 14:50:04'),
('5284', 'ST10100320250608075004', '1446-12-11', '2.220.10', '101', 'an.LAILATUL MAGHFIROH', '0', '10000', 'Chuwez', '2025-06-08 14:50:04'),
('5285', 'ST10100320250608075033', '1446-12-11', '1.100.10', '101', 'an.DIYANAH KAMALIYAH', '2000', '0', 'Chuwez', '2025-06-08 14:50:33'),
('5286', 'ST10100320250608075033', '1446-12-11', '2.220.10', '101', 'an.DIYANAH KAMALIYAH', '0', '2000', 'Chuwez', '2025-06-08 14:50:33'),
('5287', 'ST10100320250608075059', '1446-12-11', '1.100.10', '101', 'an.SITI ATHIUR ROHMAH', '5000', '0', 'Chuwez', '2025-06-08 14:50:59'),
('5288', 'ST10100320250608075059', '1446-12-11', '2.220.10', '101', 'an.SITI ATHIUR ROHMAH', '0', '5000', 'Chuwez', '2025-06-08 14:50:59'),
('5289', 'ST10100320250608075121', '1446-12-11', '1.100.10', '101', 'an.M. FAHMI NURUL ANAM', '10000', '0', 'Chuwez', '2025-06-08 14:51:21'),
('5290', 'ST10100320250608075121', '1446-12-11', '2.220.10', '101', 'an.M. FAHMI NURUL ANAM', '0', '10000', 'Chuwez', '2025-06-08 14:51:21'),
('5291', 'ST10100320250608075144', '1446-12-11', '1.100.10', '101', 'an.MUHAMMAD ILHAM', '5000', '0', 'Chuwez', '2025-06-08 14:51:45'),
('5292', 'ST10100320250608075144', '1446-12-11', '2.220.10', '101', 'an.MUHAMMAD ILHAM', '0', '5000', 'Chuwez', '2025-06-08 14:51:45'),
('5293', 'ST10100320250608075208', '1446-12-11', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '10000', '0', 'Chuwez', '2025-06-08 14:52:08'),
('5294', 'ST10100320250608075208', '1446-12-11', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '10000', 'Chuwez', '2025-06-08 14:52:09'),
('5295', 'ST10100320250608075236', '1446-12-11', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '10000', '0', 'Chuwez', '2025-06-08 14:52:36'),
('5296', 'ST10100320250608075236', '1446-12-11', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '10000', 'Chuwez', '2025-06-08 14:52:36'),
('5297', 'ST10100320250608075257', '1446-12-11', '1.100.10', '101', 'an.RAUDHOTUL JANNAH', '20000', '0', 'Chuwez', '2025-06-08 14:52:57'),
('5298', 'ST10100320250608075257', '1446-12-11', '2.220.10', '101', 'an.RAUDHOTUL JANNAH', '0', '20000', 'Chuwez', '2025-06-08 14:52:57'),
('5299', 'ST10100320250608075323', '1446-12-11', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '2000', '0', 'Chuwez', '2025-06-08 14:53:23'),
('5300', 'ST10100320250608075323', '1446-12-11', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '2000', 'Chuwez', '2025-06-08 14:53:23'),
('5301', 'ST10100320250608075338', '1446-12-11', '1.100.10', '101', 'an.MIFTAHUL JANNAH', '50000', '0', 'Chuwez', '2025-06-08 14:53:38'),
('5302', 'ST10100320250608075338', '1446-12-11', '2.220.10', '101', 'an.MIFTAHUL JANNAH', '0', '50000', 'Chuwez', '2025-06-08 14:53:38'),
('5303', 'ST10100320250608075408', '1446-12-11', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Chuwez', '2025-06-08 14:54:08'),
('5304', 'ST10100320250608075408', '1446-12-11', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Chuwez', '2025-06-08 14:54:08'),
('5305', 'ST10100320250608075444', '1446-12-11', '1.100.10', '101', 'an.SINDI RAISA PUTRI', '10000', '0', 'Chuwez', '2025-06-08 14:54:44'),
('5306', 'ST10100320250608075444', '1446-12-11', '2.220.10', '101', 'an.SINDI RAISA PUTRI', '0', '10000', 'Chuwez', '2025-06-08 14:54:44'),
('5307', 'ST10100320250608075509', '1446-12-11', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '25000', '0', 'Chuwez', '2025-06-08 14:55:09'),
('5308', 'ST10100320250608075509', '1446-12-11', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '25000', 'Chuwez', '2025-06-08 14:55:09'),
('5309', 'ST10100320250608075534', '1446-12-11', '1.100.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '5000', '0', 'Chuwez', '2025-06-08 14:55:34'),
('5310', 'ST10100320250608075534', '1446-12-11', '2.220.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '0', '5000', 'Chuwez', '2025-06-08 14:55:34'),
('5311', 'ST10100320250608075603', '1446-12-11', '1.100.10', '101', 'an.AKHMAD FIKRI HAIKAL', '50000', '0', 'Chuwez', '2025-06-08 14:56:03'),
('5312', 'ST10100320250608075603', '1446-12-11', '2.220.10', '101', 'an.AKHMAD FIKRI HAIKAL', '0', '50000', 'Chuwez', '2025-06-08 14:56:03'),
('5313', 'ST10100320250608075623', '1446-12-11', '1.100.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '20000', '0', 'Chuwez', '2025-06-08 14:56:23'),
('5314', 'ST10100320250608075623', '1446-12-11', '2.220.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '0', '20000', 'Chuwez', '2025-06-08 14:56:23'),
('5315', 'ST10100320250608075650', '1446-12-11', '1.100.10', '101', 'an.SAFIRATUL JANNAH', '10000', '0', 'Chuwez', '2025-06-08 14:56:50'),
('5316', 'ST10100320250608075650', '1446-12-11', '2.220.10', '101', 'an.SAFIRATUL JANNAH', '0', '10000', 'Chuwez', '2025-06-08 14:56:50'),
('5317', 'ST10100320250608075711', '1446-12-11', '1.100.10', '101', 'an.ANA SALSABILA', '20000', '0', 'Chuwez', '2025-06-08 14:57:11'),
('5318', 'ST10100320250608075711', '1446-12-11', '2.220.10', '101', 'an.ANA SALSABILA', '0', '20000', 'Chuwez', '2025-06-08 14:57:11'),
('5319', 'ST10100320250608075734', '1446-12-11', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '10000', '0', 'Chuwez', '2025-06-08 14:57:34'),
('5320', 'ST10100320250608075734', '1446-12-11', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '10000', 'Chuwez', '2025-06-08 14:57:34'),
('5321', 'ST10100320250608075755', '1446-12-11', '1.100.10', '101', 'an.ZAKIYATUL UMMAH', '2000', '0', 'Chuwez', '2025-06-08 14:57:55'),
('5322', 'ST10100320250608075755', '1446-12-11', '2.220.10', '101', 'an.ZAKIYATUL UMMAH', '0', '2000', 'Chuwez', '2025-06-08 14:57:55'),
('5323', 'ST10100320250608075821', '1446-12-11', '1.100.10', '101', 'an.HALIMAH', '5000', '0', 'Chuwez', '2025-06-08 14:58:21'),
('5324', 'ST10100320250608075821', '1446-12-11', '2.220.10', '101', 'an.HALIMAH', '0', '5000', 'Chuwez', '2025-06-08 14:58:21'),
('5325', 'ST10100320250608075842', '1446-12-11', '1.100.10', '101', 'an.AHMAD ABBAS MAULANA', '4000', '0', 'Chuwez', '2025-06-08 14:58:42'),
('5326', 'ST10100320250608075842', '1446-12-11', '2.220.10', '101', 'an.AHMAD ABBAS MAULANA', '0', '4000', 'Chuwez', '2025-06-08 14:58:42'),
('5327', 'ST10100320250608075913', '1446-12-11', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '5000', '0', 'Chuwez', '2025-06-08 14:59:13'),
('5328', 'ST10100320250608075913', '1446-12-11', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '5000', 'Chuwez', '2025-06-08 14:59:13'),
('5329', 'ST10100320250608075948', '1446-12-11', '1.100.10', '101', 'an.HILYA', '30000', '0', 'Chuwez', '2025-06-08 14:59:48'),
('5330', 'ST10100320250608075948', '1446-12-11', '2.220.10', '101', 'an.HILYA', '0', '30000', 'Chuwez', '2025-06-08 14:59:48'),
('5331', 'ST10100320250608080015', '1446-12-11', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'Chuwez', '2025-06-08 15:00:15'),
('5332', 'ST10100320250608080015', '1446-12-11', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'Chuwez', '2025-06-08 15:00:15'),
('5333', 'BS10100320250608080111000', '1446-12-11', '1.100.10', '101', 'Bayar[MOCHAMMAD UMAR SAID HIDAYATULLOH]', '30000', '0', 'Chuwez', '2025-06-08 15:01:11'),
('5334', 'BS10100320250608080111000', '1446-12-11', '4.400.20', '101', 'Bayar[MOCHAMMAD UMAR SAID HIDAYATULLOH]', '0', '30000', 'Chuwez', '2025-06-08 15:01:11'),
('5335', 'BS10100320250608080143000', '1446-12-11', '1.100.10', '101', 'Bayar[ROHMATULLOH]', '30000', '0', 'Chuwez', '2025-06-08 15:01:43'),
('5336', 'BS10100320250608080143000', '1446-12-11', '4.400.20', '101', 'Bayar[ROHMATULLOH]', '0', '30000', 'Chuwez', '2025-06-08 15:01:43'),
('5337', 'BS10100320250608080226000', '1446-12-11', '1.100.10', '101', 'Bayar[SITI QURROTUL AINI]', '30000', '0', 'Chuwez', '2025-06-08 15:02:26'),
('5338', 'BS10100320250608080226000', '1446-12-11', '4.400.20', '101', 'Bayar[SITI QURROTUL AINI]', '0', '30000', 'Chuwez', '2025-06-08 15:02:26'),
('5339', 'BS10100320250608080311000', '1446-10-11', '1.100.10', '101', 'Bayar[M. HAIKAL NASRULLOH]', '30000', '0', 'Chuwez', '2025-06-08 15:03:11'),
('5340', 'BS10100320250608080311000', '1446-10-11', '4.400.20', '101', 'Bayar[M. HAIKAL NASRULLOH]', '0', '30000', 'Chuwez', '2025-06-08 15:03:11'),
('5341', 'BS10100320250608080311001', '1446-11-11', '1.100.10', '101', 'Bayar[M. HAIKAL NASRULLOH]', '30000', '0', 'Chuwez', '2025-06-08 15:03:11'),
('5342', 'BS10100320250608080311001', '1446-11-11', '4.400.20', '101', 'Bayar[M. HAIKAL NASRULLOH]', '0', '30000', 'Chuwez', '2025-06-08 15:03:11'),
('5343', 'BS10100320250608080352000', '1446-12-11', '1.100.10', '101', 'Bayar[UMAR FARUQ]', '30000', '0', 'Chuwez', '2025-06-08 15:03:52'),
('5344', 'BS10100320250608080352000', '1446-12-11', '4.400.20', '101', 'Bayar[UMAR FARUQ]', '0', '30000', 'Chuwez', '2025-06-08 15:03:52'),
('5345', 'ST10100320250608080425', '1446-12-11', '1.100.10', '101', 'an.UST THORIQUL HUDA', '50000', '0', 'Chuwez', '2025-06-08 15:04:25'),
('5346', 'ST10100320250608080425', '1446-12-11', '2.220.10', '101', 'an.UST THORIQUL HUDA', '0', '50000', 'Chuwez', '2025-06-08 15:04:25'),
('5347', 'D110100320250608080528', '1446-12-11', '1.100.10', '101', 'Bayar[ROHMATULLOH]', '20000', '0', 'Chuwez', '2025-06-08 15:05:28'),
('5348', 'D110100320250608080528', '1446-12-11', '4.400.22', '101', 'Bayar[ROHMATULLOH]', '0', '20000', 'Chuwez', '2025-06-08 15:05:28'),
('5349', 'D110100320250608080548', '1446-12-11', '1.100.10', '101', 'Bayar[UMAR FARUQ]', '20000', '0', 'Chuwez', '2025-06-08 15:05:48'),
('5350', 'D110100320250608080548', '1446-12-11', '4.400.22', '101', 'Bayar[UMAR FARUQ]', '0', '20000', 'Chuwez', '2025-06-08 15:05:48'),
('5351', 'D110100320250608080621', '1446-12-11', '1.100.10', '101', 'Bayar[SITI QURROTUL AINI]', '35000', '0', 'Chuwez', '2025-06-08 15:06:21'),
('5352', 'D110100320250608080621', '1446-12-11', '4.400.22', '101', 'Bayar[SITI QURROTUL AINI]', '0', '35000', 'Chuwez', '2025-06-08 15:06:21'),
('5353', 'BS10100320250608081141000', '1446-12-11', '1.100.10', '101', 'Bayar[MUHAMMAD NAZHIRUL ASROFI]', '30000', '0', 'Chuwez', '2025-06-08 15:11:41'),
('5354', 'BS10100320250608081141000', '1446-12-11', '4.400.20', '101', 'Bayar[MUHAMMAD NAZHIRUL ASROFI]', '0', '30000', 'Chuwez', '2025-06-08 15:11:41'),
('5355', 'D110100320250608081205', '1446-12-11', '1.100.10', '101', 'Bayar[MUHAMMAD NAZHIRUL ASROFI]', '20000', '0', 'Chuwez', '2025-06-08 15:12:05'),
('5356', 'D110100320250608081205', '1446-12-11', '4.400.22', '101', 'Bayar[MUHAMMAD NAZHIRUL ASROFI]', '0', '20000', 'Chuwez', '2025-06-08 15:12:05'),
('5357', 'D110100320250608081256', '1446-12-11', '1.100.10', '101', 'Bayar[MUHAMMAD ZAINAL ABIDIN]', '40000', '0', 'Chuwez', '2025-06-08 15:12:56'),
('5358', 'D110100320250608081256', '1446-12-11', '4.400.22', '101', 'Bayar[MUHAMMAD ZAINAL ABIDIN]', '0', '40000', 'Chuwez', '2025-06-08 15:12:56'),
('5359', 'BS10100320250608081411000', '1446-11-11', '1.100.10', '101', 'Bayar[MUHAMMAD ZAINAL ABIDIN]', '30000', '0', 'Chuwez', '2025-06-08 15:14:11'),
('5360', 'BS10100320250608081411000', '1446-11-11', '4.400.20', '101', 'Bayar[MUHAMMAD ZAINAL ABIDIN]', '0', '30000', 'Chuwez', '2025-06-08 15:14:11'),
('5361', 'BS10100320250608081411001', '1446-12-11', '1.100.10', '101', 'Bayar[MUHAMMAD ZAINAL ABIDIN]', '30000', '0', 'Chuwez', '2025-06-08 15:14:11'),
('5362', 'BS10100320250608081411001', '1446-12-11', '4.400.20', '101', 'Bayar[MUHAMMAD ZAINAL ABIDIN]', '0', '30000', 'Chuwez', '2025-06-08 15:14:11'),
('5363', 'KK10100320250608152557', '1446-12-11', '5.520.42', '101', 'Cilok', '10000', '0', 'Chuwez', '2025-06-08 15:26:13'),
('5364', 'KK10100320250608152557', '1446-12-11', '1.100.10', '101', 'Cilok', '0', '10000', 'Chuwez', '2025-06-08 15:26:13'),
('5365', 'D110100320250608082639', '1446-12-11', '1.100.10', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '20000', '0', 'Chuwez', '2025-06-08 15:26:39'),
('5366', 'D110100320250608082639', '1446-12-11', '4.400.22', '101', 'Bayar[SITI SHOFIYAH LABIBAH]', '0', '20000', 'Chuwez', '2025-06-08 15:26:39'),
('5367', 'ST10100320250609080423', '1446-12-12', '1.100.10', '101', 'an.SITI SHOFIYAH LABIBAH', '30000', '0', 'Chuwez', '2025-06-09 15:04:23'),
('5368', 'ST10100320250609080423', '1446-12-12', '2.220.10', '101', 'an.SITI SHOFIYAH LABIBAH', '0', '30000', 'Chuwez', '2025-06-09 15:04:23'),
('5369', 'ST10100320250609080440', '1446-12-12', '1.100.10', '101', 'an.HAIKAL SHOMADANI', '2000', '0', 'Chuwez', '2025-06-09 15:04:40'),
('5370', 'ST10100320250609080440', '1446-12-12', '2.220.10', '101', 'an.HAIKAL SHOMADANI', '0', '2000', 'Chuwez', '2025-06-09 15:04:40'),
('5371', 'ST10100320250609080454', '1446-12-12', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '10000', '0', 'Chuwez', '2025-06-09 15:04:54'),
('5372', 'ST10100320250609080454', '1446-12-12', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '10000', 'Chuwez', '2025-06-09 15:04:54'),
('5373', 'ST10100320250609080514', '1446-12-12', '1.100.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '10000', '0', 'Chuwez', '2025-06-09 15:05:14'),
('5374', 'ST10100320250609080514', '1446-12-12', '2.220.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '0', '10000', 'Chuwez', '2025-06-09 15:05:14'),
('5375', 'ST10100320250609080528', '1446-12-12', '1.100.10', '101', 'an.M. ABD. HADI', '2000', '0', 'Chuwez', '2025-06-09 15:05:28'),
('5376', 'ST10100320250609080528', '1446-12-12', '2.220.10', '101', 'an.M. ABD. HADI', '0', '2000', 'Chuwez', '2025-06-09 15:05:28'),
('5377', 'ST10100320250609080553', '1446-12-12', '1.100.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '5000', '0', 'Chuwez', '2025-06-09 15:05:53'),
('5378', 'ST10100320250609080553', '1446-12-12', '2.220.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '0', '5000', 'Chuwez', '2025-06-09 15:05:53'),
('5379', 'ST10100320250609080624', '1446-12-12', '1.100.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '5000', '0', 'Chuwez', '2025-06-09 15:06:24'),
('5380', 'ST10100320250609080624', '1446-12-12', '2.220.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '0', '5000', 'Chuwez', '2025-06-09 15:06:24'),
('5381', 'ST10100320250609080654', '1446-12-12', '1.100.10', '101', 'an.NAURA BILADINA', '10000', '0', 'Chuwez', '2025-06-09 15:06:54'),
('5382', 'ST10100320250609080654', '1446-12-12', '2.220.10', '101', 'an.NAURA BILADINA', '0', '10000', 'Chuwez', '2025-06-09 15:06:54'),
('5383', 'ST10100320250609080707', '1446-12-12', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'Chuwez', '2025-06-09 15:07:07'),
('5384', 'ST10100320250609080707', '1446-12-12', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'Chuwez', '2025-06-09 15:07:07'),
('5385', 'ST10100320250609080815', '1446-12-12', '1.100.10', '101', 'an.MUHAMMAD ALWI', '20000', '0', 'Chuwez', '2025-06-09 15:08:15'),
('5386', 'ST10100320250609080815', '1446-12-12', '2.220.10', '101', 'an.MUHAMMAD ALWI', '0', '20000', 'Chuwez', '2025-06-09 15:08:15'),
('5387', 'ST10100320250609080830', '1446-12-12', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '10000', '0', 'Chuwez', '2025-06-09 15:08:30'),
('5388', 'ST10100320250609080830', '1446-12-12', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '10000', 'Chuwez', '2025-06-09 15:08:30'),
('5389', 'ST10100320250609080847', '1446-12-12', '1.100.10', '101', 'an.MARIYATUL QIBTIYAH', '5000', '0', 'Chuwez', '2025-06-09 15:08:47'),
('5390', 'ST10100320250609080847', '1446-12-12', '2.220.10', '101', 'an.MARIYATUL QIBTIYAH', '0', '5000', 'Chuwez', '2025-06-09 15:08:47'),
('5391', 'ST10100320250609080900', '1446-12-12', '1.100.10', '101', 'an.FAIZAH NURUL LITA', '5000', '0', 'Chuwez', '2025-06-09 15:09:01'),
('5392', 'ST10100320250609080900', '1446-12-12', '2.220.10', '101', 'an.FAIZAH NURUL LITA', '0', '5000', 'Chuwez', '2025-06-09 15:09:01'),
('5393', 'ST10100320250609080921', '1446-12-12', '1.100.10', '101', 'an.UBAIDAH', '10000', '0', 'Chuwez', '2025-06-09 15:09:21'),
('5394', 'ST10100320250609080921', '1446-12-12', '2.220.10', '101', 'an.UBAIDAH', '0', '10000', 'Chuwez', '2025-06-09 15:09:21'),
('5395', 'ST10100320250609080939', '1446-12-12', '1.100.10', '101', 'an.MARIATUL QIBTIYAH', '4000', '0', 'Chuwez', '2025-06-09 15:09:39'),
('5396', 'ST10100320250609080939', '1446-12-12', '2.220.10', '101', 'an.MARIATUL QIBTIYAH', '0', '4000', 'Chuwez', '2025-06-09 15:09:39'),
('5397', 'ST10100320250609080957', '1446-12-12', '1.100.10', '101', 'an.NAILATUN NIAMI', '2000', '0', 'Chuwez', '2025-06-09 15:09:57'),
('5398', 'ST10100320250609080957', '1446-12-12', '2.220.10', '101', 'an.NAILATUN NIAMI', '0', '2000', 'Chuwez', '2025-06-09 15:09:57'),
('5399', 'ST10100320250609081019', '1446-12-12', '1.100.10', '101', 'an.UMAR FARUQ', '10000', '0', 'Chuwez', '2025-06-09 15:10:19'),
('5400', 'ST10100320250609081019', '1446-12-12', '2.220.10', '101', 'an.UMAR FARUQ', '0', '10000', 'Chuwez', '2025-06-09 15:10:19'),
('5401', 'ST10100320250609081036', '1446-12-12', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'Chuwez', '2025-06-09 15:10:36'),
('5402', 'ST10100320250609081036', '1446-12-12', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'Chuwez', '2025-06-09 15:10:36'),
('5403', 'ST10100320250609081050', '1446-12-12', '1.100.10', '101', 'an.RAISA ANNISA', '5000', '0', 'Chuwez', '2025-06-09 15:10:50'),
('5404', 'ST10100320250609081050', '1446-12-12', '2.220.10', '101', 'an.RAISA ANNISA', '0', '5000', 'Chuwez', '2025-06-09 15:10:50'),
('5405', 'ST10100320250609081109', '1446-12-12', '1.100.10', '101', 'an.AZKA AUFARIL MINAN', '10000', '0', 'Chuwez', '2025-06-09 15:11:09'),
('5406', 'ST10100320250609081109', '1446-12-12', '2.220.10', '101', 'an.AZKA AUFARIL MINAN', '0', '10000', 'Chuwez', '2025-06-09 15:11:09'),
('5407', 'ST10100320250609081123', '1446-12-12', '1.100.10', '101', 'an.AHMAD ADITIYA', '5000', '0', 'Chuwez', '2025-06-09 15:11:23'),
('5408', 'ST10100320250609081123', '1446-12-12', '2.220.10', '101', 'an.AHMAD ADITIYA', '0', '5000', 'Chuwez', '2025-06-09 15:11:23'),
('5409', 'ST10100320250609081136', '1446-12-12', '1.100.10', '101', 'an.ALFI NURDIANA', '5000', '0', 'Chuwez', '2025-06-09 15:11:36'),
('5410', 'ST10100320250609081136', '1446-12-12', '2.220.10', '101', 'an.ALFI NURDIANA', '0', '5000', 'Chuwez', '2025-06-09 15:11:36'),
('5411', 'ST10100320250609081148', '1446-12-12', '1.100.10', '101', 'an.AISYAH', '5000', '0', 'Chuwez', '2025-06-09 15:11:48'),
('5412', 'ST10100320250609081148', '1446-12-12', '2.220.10', '101', 'an.AISYAH', '0', '5000', 'Chuwez', '2025-06-09 15:11:48'),
('5413', 'ST10100320250609081201', '1446-12-12', '1.100.10', '101', 'an.LAILATUL MAGHFIROH', '5000', '0', 'Chuwez', '2025-06-09 15:12:01'),
('5414', 'ST10100320250609081201', '1446-12-12', '2.220.10', '101', 'an.LAILATUL MAGHFIROH', '0', '5000', 'Chuwez', '2025-06-09 15:12:01'),
('5415', 'ST10100320250609081216', '1446-12-12', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '5000', '0', 'Chuwez', '2025-06-09 15:12:16'),
('5416', 'ST10100320250609081216', '1446-12-12', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '5000', 'Chuwez', '2025-06-09 15:12:16'),
('5417', 'ST10100320250609081353', '1446-12-12', '1.100.10', '101', 'an.M. FAHMI NURUL ANAM', '10000', '0', 'Chuwez', '2025-06-09 15:13:53'),
('5418', 'ST10100320250609081353', '1446-12-12', '2.220.10', '101', 'an.M. FAHMI NURUL ANAM', '0', '10000', 'Chuwez', '2025-06-09 15:13:53'),
('5419', 'ST10100320250609081410', '1446-12-12', '1.100.10', '101', 'an.WARDATUL JANNAH', '5000', '0', 'Chuwez', '2025-06-09 15:14:10'),
('5420', 'ST10100320250609081410', '1446-12-12', '2.220.10', '101', 'an.WARDATUL JANNAH', '0', '5000', 'Chuwez', '2025-06-09 15:14:10'),
('5421', 'ST10100320250609081424', '1446-12-12', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '10000', '0', 'Chuwez', '2025-06-09 15:14:24'),
('5422', 'ST10100320250609081424', '1446-12-12', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '10000', 'Chuwez', '2025-06-09 15:14:24'),
('5423', 'ST10100320250609081439', '1446-12-12', '1.100.10', '101', 'an.SITI ATHIUR ROHMAH', '5000', '0', 'Chuwez', '2025-06-09 15:14:39'),
('5424', 'ST10100320250609081439', '1446-12-12', '2.220.10', '101', 'an.SITI ATHIUR ROHMAH', '0', '5000', 'Chuwez', '2025-06-09 15:14:39'),
('5425', 'ST10100320250609081456', '1446-12-12', '1.100.10', '101', 'an.DIYANAH KAMALIYAH', '2000', '0', 'Chuwez', '2025-06-09 15:14:56'),
('5426', 'ST10100320250609081456', '1446-12-12', '2.220.10', '101', 'an.DIYANAH KAMALIYAH', '0', '2000', 'Chuwez', '2025-06-09 15:14:56'),
('5427', 'ST10100320250609081515', '1446-12-12', '1.100.10', '101', 'an.SITI QURROTUL AINI', '2000', '0', 'Chuwez', '2025-06-09 15:15:15'),
('5428', 'ST10100320250609081515', '1446-12-12', '2.220.10', '101', 'an.SITI QURROTUL AINI', '0', '2000', 'Chuwez', '2025-06-09 15:15:15'),
('5429', 'ST10100320250609081535', '1446-12-12', '1.100.10', '101', 'an.M. KAMALUDDIN', '10000', '0', 'Chuwez', '2025-06-09 15:15:35'),
('5430', 'ST10100320250609081535', '1446-12-12', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '10000', 'Chuwez', '2025-06-09 15:15:35'),
('5431', 'ST10100320250609081720', '1446-12-12', '1.100.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '10000', '0', 'Chuwez', '2025-06-09 15:17:20'),
('5432', 'ST10100320250609081720', '1446-12-12', '2.220.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '0', '10000', 'Chuwez', '2025-06-09 15:17:20'),
('5433', 'ST10100320250609081734', '1446-12-12', '1.100.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '10000', '0', 'Chuwez', '2025-06-09 15:17:34'),
('5434', 'ST10100320250609081734', '1446-12-12', '2.220.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '0', '10000', 'Chuwez', '2025-06-09 15:17:34'),
('5435', 'ST10100320250609081749', '1446-12-12', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Chuwez', '2025-06-09 15:17:49'),
('5436', 'ST10100320250609081749', '1446-12-12', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Chuwez', '2025-06-09 15:17:49'),
('5437', 'ST10100320250609081804', '1446-12-12', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '10000', '0', 'Chuwez', '2025-06-09 15:18:04'),
('5438', 'ST10100320250609081804', '1446-12-12', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '10000', 'Chuwez', '2025-06-09 15:18:04'),
('5439', 'ST10100320250609081822', '1446-12-12', '1.100.10', '101', 'an.RAUDHOTUL JANNAH', '20000', '0', 'Chuwez', '2025-06-09 15:18:22'),
('5440', 'ST10100320250609081822', '1446-12-12', '2.220.10', '101', 'an.RAUDHOTUL JANNAH', '0', '20000', 'Chuwez', '2025-06-09 15:18:22'),
('5441', 'ST10100320250609081836', '1446-12-12', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '5000', '0', 'Chuwez', '2025-06-09 15:18:36'),
('5442', 'ST10100320250609081836', '1446-12-12', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '5000', 'Chuwez', '2025-06-09 15:18:36'),
('5443', 'ST10100320250609081851', '1446-12-12', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '2000', '0', 'Chuwez', '2025-06-09 15:18:51'),
('5444', 'ST10100320250609081851', '1446-12-12', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '2000', 'Chuwez', '2025-06-09 15:18:51'),
('5445', 'ST10100320250609081913', '1446-12-12', '1.100.10', '101', 'an.BILQIS THALIA HASNA', '150000', '0', 'Chuwez', '2025-06-09 15:19:13'),
('5446', 'ST10100320250609081913', '1446-12-12', '2.220.10', '101', 'an.BILQIS THALIA HASNA', '0', '150000', 'Chuwez', '2025-06-09 15:19:13'),
('5447', 'ST10100320250609081928', '1446-12-12', '1.100.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '10000', '0', 'Chuwez', '2025-06-09 15:19:28'),
('5448', 'ST10100320250609081928', '1446-12-12', '2.220.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '0', '10000', 'Chuwez', '2025-06-09 15:19:28'),
('5449', 'ST10100320250609081943', '1446-12-12', '1.100.10', '101', 'an.M. ROFIQ HIDAYATULLOH', '10000', '0', 'Chuwez', '2025-06-09 15:19:43'),
('5450', 'ST10100320250609081943', '1446-12-12', '2.220.10', '101', 'an.M. ROFIQ HIDAYATULLOH', '0', '10000', 'Chuwez', '2025-06-09 15:19:43'),
('5451', 'ST10100320250609082002', '1446-12-12', '1.100.10', '101', 'an.AKHMAD FIKRI HAIKAL', '100000', '0', 'Chuwez', '2025-06-09 15:20:02'),
('5452', 'ST10100320250609082002', '1446-12-12', '2.220.10', '101', 'an.AKHMAD FIKRI HAIKAL', '0', '100000', 'Chuwez', '2025-06-09 15:20:02'),
('5453', 'ST10100320250609082016', '1446-12-12', '1.100.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '5000', '0', 'Chuwez', '2025-06-09 15:20:16'),
('5454', 'ST10100320250609082016', '1446-12-12', '2.220.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '0', '5000', 'Chuwez', '2025-06-09 15:20:16'),
('5455', 'ST10100320250609082031', '1446-12-12', '1.100.10', '101', 'an.AHMAD ABBAS MAULANA', '5000', '0', 'Chuwez', '2025-06-09 15:20:31'),
('5456', 'ST10100320250609082031', '1446-12-12', '2.220.10', '101', 'an.AHMAD ABBAS MAULANA', '0', '5000', 'Chuwez', '2025-06-09 15:20:31'),
('5457', 'ST10100320250609082047', '1446-12-12', '1.100.10', '101', 'an.SINDI RAISA PUTRI', '10000', '0', 'Chuwez', '2025-06-09 15:20:47'),
('5458', 'ST10100320250609082047', '1446-12-12', '2.220.10', '101', 'an.SINDI RAISA PUTRI', '0', '10000', 'Chuwez', '2025-06-09 15:20:47'),
('5459', 'ST10100320250609082104', '1446-12-12', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '25000', '0', 'Chuwez', '2025-06-09 15:21:04'),
('5460', 'ST10100320250609082104', '1446-12-12', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '25000', 'Chuwez', '2025-06-09 15:21:04'),
('5461', 'ST10100320250609082121', '1446-12-12', '1.100.10', '101', 'an.AFANDI', '2000', '0', 'Chuwez', '2025-06-09 15:21:21'),
('5462', 'ST10100320250609082121', '1446-12-12', '2.220.10', '101', 'an.AFANDI', '0', '2000', 'Chuwez', '2025-06-09 15:21:21'),
('5463', 'ST10100320250609082150', '1446-12-12', '1.100.10', '101', 'an.MUHAMMAD YAHYA SYAKARUDDIN', '5000', '0', 'Chuwez', '2025-06-09 15:21:50'),
('5464', 'ST10100320250609082150', '1446-12-12', '2.220.10', '101', 'an.MUHAMMAD YAHYA SYAKARUDDIN', '0', '5000', 'Chuwez', '2025-06-09 15:21:50'),
('5465', 'ST10100320250609082204', '1446-12-12', '1.100.10', '101', 'an.ZAKIYATUL UMMAH', '2000', '0', 'Chuwez', '2025-06-09 15:22:04'),
('5466', 'ST10100320250609082204', '1446-12-12', '2.220.10', '101', 'an.ZAKIYATUL UMMAH', '0', '2000', 'Chuwez', '2025-06-09 15:22:04'),
('5467', 'ST10100320250609082220', '1446-12-12', '1.100.10', '101', 'an.MUHAMMAD KHOIRON', '5000', '0', 'Chuwez', '2025-06-09 15:22:20'),
('5468', 'ST10100320250609082220', '1446-12-12', '2.220.10', '101', 'an.MUHAMMAD KHOIRON', '0', '5000', 'Chuwez', '2025-06-09 15:22:20'),
('5469', 'ST10100320250609082233', '1446-12-12', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '5000', '0', 'Chuwez', '2025-06-09 15:22:34'),
('5470', 'ST10100320250609082233', '1446-12-12', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '5000', 'Chuwez', '2025-06-09 15:22:34'),
('5471', 'ST10100320250609082314', '1446-12-12', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '5000', '0', 'Chuwez', '2025-06-09 15:23:14'),
('5472', 'ST10100320250609082314', '1446-12-12', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '5000', 'Chuwez', '2025-06-09 15:23:14'),
('5473', 'ST10100320250609082328', '1446-12-12', '1.100.10', '101', 'an.ANA SALSABILA', '2000', '0', 'Chuwez', '2025-06-09 15:23:28'),
('5474', 'ST10100320250609082328', '1446-12-12', '2.220.10', '101', 'an.ANA SALSABILA', '0', '2000', 'Chuwez', '2025-06-09 15:23:28'),
('5475', 'ST10100320250609082347', '1446-12-12', '1.100.10', '101', 'an.M. ALIFIN FIKRI', '2000', '0', 'Chuwez', '2025-06-09 15:23:47'),
('5476', 'ST10100320250609082347', '1446-12-12', '2.220.10', '101', 'an.M. ALIFIN FIKRI', '0', '2000', 'Chuwez', '2025-06-09 15:23:47'),
('5477', 'ST10100320250609082403', '1446-12-12', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '10000', '0', 'Chuwez', '2025-06-09 15:24:03'),
('5478', 'ST10100320250609082403', '1446-12-12', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '10000', 'Chuwez', '2025-06-09 15:24:03'),
('5479', 'ST10100320250609082424', '1446-12-12', '1.100.10', '101', 'an.ALFIN HIDAYAT', '7000', '0', 'Chuwez', '2025-06-09 15:24:24'),
('5480', 'ST10100320250609082424', '1446-12-12', '2.220.10', '101', 'an.ALFIN HIDAYAT', '0', '7000', 'Chuwez', '2025-06-09 15:24:24'),
('5481', 'ST10100320250609082441', '1446-12-12', '1.100.10', '101', 'an.MUHAMMAD KANZUL KAROMI', '10000', '0', 'Chuwez', '2025-06-09 15:24:41'),
('5482', 'ST10100320250609082441', '1446-12-12', '2.220.10', '101', 'an.MUHAMMAD KANZUL KAROMI', '0', '10000', 'Chuwez', '2025-06-09 15:24:41'),
('5483', 'ST10100320250609082501', '1446-12-12', '1.100.10', '101', 'an.SAFIRATUL JANNAH', '10000', '0', 'Chuwez', '2025-06-09 15:25:01'),
('5484', 'ST10100320250609082501', '1446-12-12', '2.220.10', '101', 'an.SAFIRATUL JANNAH', '0', '10000', 'Chuwez', '2025-06-09 15:25:01'),
('5485', 'ST10100320250609082520', '1446-12-12', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'Chuwez', '2025-06-09 15:25:20'),
('5486', 'ST10100320250609082520', '1446-12-12', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'Chuwez', '2025-06-09 15:25:20'),
('5487', 'ST10100320250609082540', '1446-12-12', '1.100.10', '101', 'an.HALIMAH', '5000', '0', 'Chuwez', '2025-06-09 15:25:40'),
('5488', 'ST10100320250609082540', '1446-12-12', '2.220.10', '101', 'an.HALIMAH', '0', '5000', 'Chuwez', '2025-06-09 15:25:40'),
('5489', 'ST10100320250609082600', '1446-12-12', '1.100.10', '101', 'an.MACHMUDAH', '5000', '0', 'Chuwez', '2025-06-09 15:26:00'),
('5490', 'ST10100320250609082600', '1446-12-12', '2.220.10', '101', 'an.MACHMUDAH', '0', '5000', 'Chuwez', '2025-06-09 15:26:00'),
('5493', 'BS10100320250609082658000', '1446-10-12', '1.100.10', '101', 'Bayar[SINDI RAISA PUTRI]', '30000', '0', 'Chuwez', '2025-06-09 15:26:58'),
('5494', 'BS10100320250609082658000', '1446-10-12', '4.400.20', '101', 'Bayar[SINDI RAISA PUTRI]', '0', '30000', 'Chuwez', '2025-06-09 15:26:58'),
('5495', 'BS10100320250609082658001', '1446-11-12', '1.100.10', '101', 'Bayar[SINDI RAISA PUTRI]', '30000', '0', 'Chuwez', '2025-06-09 15:26:58'),
('5496', 'BS10100320250609082658001', '1446-11-12', '4.400.20', '101', 'Bayar[SINDI RAISA PUTRI]', '0', '30000', 'Chuwez', '2025-06-09 15:26:58'),
('5497', 'BS10100320250609082725000', '1446-10-12', '1.100.10', '101', 'Bayar[ALFIN HIDAYAT]', '30000', '0', 'Chuwez', '2025-06-09 15:27:25'),
('5498', 'BS10100320250609082725000', '1446-10-12', '4.400.20', '101', 'Bayar[ALFIN HIDAYAT]', '0', '30000', 'Chuwez', '2025-06-09 15:27:25'),
('5499', 'BS10100320250609082725001', '1446-11-12', '1.100.10', '101', 'Bayar[ALFIN HIDAYAT]', '30000', '0', 'Chuwez', '2025-06-09 15:27:25'),
('5500', 'BS10100320250609082725001', '1446-11-12', '4.400.20', '101', 'Bayar[ALFIN HIDAYAT]', '0', '30000', 'Chuwez', '2025-06-09 15:27:25'),
('5501', 'BS10100320250609082758000', '1446-11-12', '1.100.10', '101', 'Bayar[AHMAD ABBAS MAULANA]', '30000', '0', 'Chuwez', '2025-06-09 15:27:58'),
('5502', 'BS10100320250609082758000', '1446-11-12', '4.400.20', '101', 'Bayar[AHMAD ABBAS MAULANA]', '0', '30000', 'Chuwez', '2025-06-09 15:27:58'),
('5503', 'KK10100320250609152830', '1446-12-12', '5.520.42', '101', 'Cilok', '10000', '0', 'Chuwez', '2025-06-09 15:28:42'),
('5504', 'KK10100320250609152830', '1446-12-12', '1.100.10', '101', 'Cilok', '0', '10000', 'Chuwez', '2025-06-09 15:28:42'),
('5507', 'ST10100320250609083847', '1446-12-12', '1.100.10', '101', 'an.HILYA', '20000', '0', 'Chuwez', '2025-06-09 15:38:47'),
('5508', 'ST10100320250609083847', '1446-12-12', '2.220.10', '101', 'an.HILYA', '0', '20000', 'Chuwez', '2025-06-09 15:38:47'),
('5509', 'D110100320250609084152', '1446-12-12', '1.100.10', '101', 'Bayar[MUHAMMAD ALWI]', '20000', '0', 'Chuwez', '2025-06-09 15:41:52'),
('5510', 'D110100320250609084152', '1446-12-12', '4.400.22', '101', 'Bayar[MUHAMMAD ALWI]', '0', '20000', 'Chuwez', '2025-06-09 15:41:52'),
('5511', 'D110100320250609084212', '1446-12-12', '1.100.10', '101', 'Bayar[M. WAFA BAHRUN NAJA]', '40000', '0', 'Chuwez', '2025-06-09 15:42:12'),
('5512', 'D110100320250609084212', '1446-12-12', '4.400.22', '101', 'Bayar[M. WAFA BAHRUN NAJA]', '0', '40000', 'Chuwez', '2025-06-09 15:42:12'),
('5513', 'D110100320250610073016', '1446-12-13', '1.100.10', '101', 'Bayar[M. FAHMI NURUL ANAM]', '35000', '0', 'Chuwez', '2025-06-10 14:30:16'),
('5514', 'D110100320250610073016', '1446-12-13', '4.400.22', '101', 'Bayar[M. FAHMI NURUL ANAM]', '0', '35000', 'Chuwez', '2025-06-10 14:30:16'),
('5515', 'D110100320250610073048', '1446-12-13', '1.100.10', '101', 'Bayar[ACH. JUNAIDI]', '40000', '0', 'Chuwez', '2025-06-10 14:30:48'),
('5516', 'D110100320250610073048', '1446-12-13', '4.400.22', '101', 'Bayar[ACH. JUNAIDI]', '0', '40000', 'Chuwez', '2025-06-10 14:30:48'),
('5517', 'ST10100320250610073432', '1446-12-13', '1.100.10', '101', 'an.SAFIRATUL JANNAH', '10000', '0', 'Chuwez', '2025-06-10 14:34:32'),
('5518', 'ST10100320250610073432', '1446-12-13', '2.220.10', '101', 'an.SAFIRATUL JANNAH', '0', '10000', 'Chuwez', '2025-06-10 14:34:32'),
('5519', 'ST10100320250610073458', '1446-12-13', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '10000', '0', 'Chuwez', '2025-06-10 14:34:58'),
('5520', 'ST10100320250610073458', '1446-12-13', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '10000', 'Chuwez', '2025-06-10 14:34:58'),
('5521', 'ST10100320250610073524', '1446-12-13', '1.100.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '2000', '0', 'Chuwez', '2025-06-10 14:35:24'),
('5522', 'ST10100320250610073524', '1446-12-13', '2.220.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '0', '2000', 'Chuwez', '2025-06-10 14:35:24'),
('5523', 'ST10100320250610073610', '1446-12-13', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '5000', '0', 'Chuwez', '2025-06-10 14:36:10'),
('5524', 'ST10100320250610073610', '1446-12-13', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '5000', 'Chuwez', '2025-06-10 14:36:10'),
('5525', 'ST10100320250610073629', '1446-12-13', '1.100.10', '101', 'an.ZAKIYATUL UMMAH', '2000', '0', 'Chuwez', '2025-06-10 14:36:29'),
('5526', 'ST10100320250610073629', '1446-12-13', '2.220.10', '101', 'an.ZAKIYATUL UMMAH', '0', '2000', 'Chuwez', '2025-06-10 14:36:29'),
('5527', 'ST10100320250610073701', '1446-12-13', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '5000', '0', 'Chuwez', '2025-06-10 14:37:01'),
('5528', 'ST10100320250610073701', '1446-12-13', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '5000', 'Chuwez', '2025-06-10 14:37:01'),
('5529', 'ST10100320250610073724', '1446-12-13', '1.100.10', '101', 'an.MUHAMMAD KHOIRON', '5000', '0', 'Chuwez', '2025-06-10 14:37:24'),
('5530', 'ST10100320250610073724', '1446-12-13', '2.220.10', '101', 'an.MUHAMMAD KHOIRON', '0', '5000', 'Chuwez', '2025-06-10 14:37:24'),
('5531', 'ST10100320250610073750', '1446-12-13', '1.100.10', '101', 'an.ANA SALSABILA', '5000', '0', 'Chuwez', '2025-06-10 14:37:50'),
('5532', 'ST10100320250610073750', '1446-12-13', '2.220.10', '101', 'an.ANA SALSABILA', '0', '5000', 'Chuwez', '2025-06-10 14:37:50'),
('5533', 'ST10100320250610073830', '1446-12-13', '1.100.10', '101', 'an.BILQIS THALIA HASNA', '65000', '0', 'Chuwez', '2025-06-10 14:38:30'),
('5534', 'ST10100320250610073830', '1446-12-13', '2.220.10', '101', 'an.BILQIS THALIA HASNA', '0', '65000', 'Chuwez', '2025-06-10 14:38:30'),
('5535', 'ST10100320250610073854', '1446-12-13', '1.100.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '10000', '0', 'Chuwez', '2025-06-10 14:38:54'),
('5536', 'ST10100320250610073854', '1446-12-13', '2.220.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '0', '10000', 'Chuwez', '2025-06-10 14:38:54'),
('5537', 'ST10100320250610073919', '1446-12-13', '1.100.10', '101', 'an.AKHMAD FIKRI HAIKAL', '50000', '0', 'Chuwez', '2025-06-10 14:39:19'),
('5538', 'ST10100320250610073919', '1446-12-13', '2.220.10', '101', 'an.AKHMAD FIKRI HAIKAL', '0', '50000', 'Chuwez', '2025-06-10 14:39:19'),
('5539', 'ST10100320250610073955', '1446-12-13', '1.100.10', '101', 'an.SINDI RAISA PUTRI', '10000', '0', 'Chuwez', '2025-06-10 14:39:55'),
('5540', 'ST10100320250610073955', '1446-12-13', '2.220.10', '101', 'an.SINDI RAISA PUTRI', '0', '10000', 'Chuwez', '2025-06-10 14:39:55'),
('5541', 'ST10100320250610074026', '1446-12-13', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '25000', '0', 'Chuwez', '2025-06-10 14:40:26'),
('5542', 'ST10100320250610074026', '1446-12-13', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '25000', 'Chuwez', '2025-06-10 14:40:26'),
('5543', 'ST10100320250610074053', '1446-12-13', '1.100.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '5000', '0', 'Chuwez', '2025-06-10 14:40:53'),
('5544', 'ST10100320250610074053', '1446-12-13', '2.220.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '0', '5000', 'Chuwez', '2025-06-10 14:40:53'),
('5545', 'ST10100320250610074127', '1446-12-13', '1.100.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '5000', '0', 'Chuwez', '2025-06-10 14:41:27'),
('5546', 'ST10100320250610074127', '1446-12-13', '2.220.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '0', '5000', 'Chuwez', '2025-06-10 14:41:27'),
('5547', 'ST10100320250610074207', '1446-12-13', '1.100.10', '101', 'an.RAUDHOTUL JANNAH', '20000', '0', 'Chuwez', '2025-06-10 14:42:07'),
('5548', 'ST10100320250610074207', '1446-12-13', '2.220.10', '101', 'an.RAUDHOTUL JANNAH', '0', '20000', 'Chuwez', '2025-06-10 14:42:07'),
('5549', 'ST10100320250610074240', '1446-12-13', '1.100.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '5000', '0', 'Chuwez', '2025-06-10 14:42:40'),
('5550', 'ST10100320250610074240', '1446-12-13', '2.220.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '0', '5000', 'Chuwez', '2025-06-10 14:42:40'),
('5551', 'ST10100320250610074310', '1446-12-13', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '10000', '0', 'Chuwez', '2025-06-10 14:43:10'),
('5552', 'ST10100320250610074310', '1446-12-13', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '10000', 'Chuwez', '2025-06-10 14:43:10'),
('5553', 'ST10100320250610074330', '1446-12-13', '1.100.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '10000', '0', 'Chuwez', '2025-06-10 14:43:30'),
('5554', 'ST10100320250610074330', '1446-12-13', '2.220.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '0', '10000', 'Chuwez', '2025-06-10 14:43:30'),
('5555', 'ST10100320250610074355', '1446-12-13', '1.100.10', '101', 'an.M. KAMALUDDIN', '10000', '0', 'Chuwez', '2025-06-10 14:43:55'),
('5556', 'ST10100320250610074355', '1446-12-13', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '10000', 'Chuwez', '2025-06-10 14:43:55'),
('5557', 'ST10100320250610074646', '1446-12-13', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '5000', '0', 'Chuwez', '2025-06-10 14:46:46'),
('5558', 'ST10100320250610074646', '1446-12-13', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '5000', 'Chuwez', '2025-06-10 14:46:46'),
('5559', 'ST10100320250610074717', '1446-12-13', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '2000', '0', 'Chuwez', '2025-06-10 14:47:17'),
('5560', 'ST10100320250610074717', '1446-12-13', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '2000', 'Chuwez', '2025-06-10 14:47:17'),
('5561', 'ST10100320250610074739', '1446-12-13', '1.100.10', '101', 'an.MIFTAHUL JANNAH', '50000', '0', 'Chuwez', '2025-06-10 14:47:39'),
('5562', 'ST10100320250610074739', '1446-12-13', '2.220.10', '101', 'an.MIFTAHUL JANNAH', '0', '50000', 'Chuwez', '2025-06-10 14:47:39'),
('5563', 'ST10100320250610074810', '1446-12-13', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Chuwez', '2025-06-10 14:48:10'),
('5564', 'ST10100320250610074810', '1446-12-13', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Chuwez', '2025-06-10 14:48:10'),
('5565', 'ST10100320250610074836', '1446-12-13', '1.100.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '30000', '0', 'Chuwez', '2025-06-10 14:48:36'),
('5566', 'ST10100320250610074836', '1446-12-13', '2.220.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '0', '30000', 'Chuwez', '2025-06-10 14:48:36'),
('5567', 'ST10100320250610074905', '1446-12-13', '1.100.10', '101', 'an.DIYANAH KAMALIYAH', '2000', '0', 'Chuwez', '2025-06-10 14:49:05'),
('5568', 'ST10100320250610074905', '1446-12-13', '2.220.10', '101', 'an.DIYANAH KAMALIYAH', '0', '2000', 'Chuwez', '2025-06-10 14:49:05'),
('5569', 'ST10100320250610074932', '1446-12-13', '1.100.10', '101', 'an.ABDUL HAMID', '10000', '0', 'Chuwez', '2025-06-10 14:49:32'),
('5570', 'ST10100320250610074932', '1446-12-13', '2.220.10', '101', 'an.ABDUL HAMID', '0', '10000', 'Chuwez', '2025-06-10 14:49:32'),
('5571', 'ST10100320250610075004', '1446-12-13', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '10000', '0', 'Chuwez', '2025-06-10 14:50:04'),
('5572', 'ST10100320250610075004', '1446-12-13', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '10000', 'Chuwez', '2025-06-10 14:50:04'),
('5573', 'ST10100320250610075029', '1446-12-13', '1.100.10', '101', 'an.SITI QURROTUL AINI', '2000', '0', 'Chuwez', '2025-06-10 14:50:29'),
('5574', 'ST10100320250610075029', '1446-12-13', '2.220.10', '101', 'an.SITI QURROTUL AINI', '0', '2000', 'Chuwez', '2025-06-10 14:50:29'),
('5575', 'ST10100320250610075130', '1446-12-13', '1.100.10', '101', 'an.SITI ATHIUR ROHMAH', '5000', '0', 'Chuwez', '2025-06-10 14:51:30'),
('5576', 'ST10100320250610075130', '1446-12-13', '2.220.10', '101', 'an.SITI ATHIUR ROHMAH', '0', '5000', 'Chuwez', '2025-06-10 14:51:30'),
('5577', 'ST10100320250610075145', '1446-12-13', '1.100.10', '101', 'an.WARDATUL JANNAH', '2000', '0', 'Chuwez', '2025-06-10 14:51:45'),
('5578', 'ST10100320250610075145', '1446-12-13', '2.220.10', '101', 'an.WARDATUL JANNAH', '0', '2000', 'Chuwez', '2025-06-10 14:51:45'),
('5579', 'ST10100320250610075207', '1446-12-13', '1.100.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '20000', '0', 'Chuwez', '2025-06-10 14:52:07'),
('5580', 'ST10100320250610075207', '1446-12-13', '2.220.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '0', '20000', 'Chuwez', '2025-06-10 14:52:07'),
('5581', 'ST10100320250610075244', '1446-12-13', '1.100.10', '101', 'an.M. FAHMI NURUL ANAM', '10000', '0', 'Chuwez', '2025-06-10 14:52:44'),
('5582', 'ST10100320250610075244', '1446-12-13', '2.220.10', '101', 'an.M. FAHMI NURUL ANAM', '0', '10000', 'Chuwez', '2025-06-10 14:52:44'),
('5583', 'ST10100320250610075310', '1446-12-13', '1.100.10', '101', 'an.IFTITAHUL IZZA', '100000', '0', 'Chuwez', '2025-06-10 14:53:10'),
('5584', 'ST10100320250610075310', '1446-12-13', '2.220.10', '101', 'an.IFTITAHUL IZZA', '0', '100000', 'Chuwez', '2025-06-10 14:53:10'),
('5585', 'ST10100320250610075433', '1446-12-13', '1.100.10', '101', 'an.ALFI NURDIANA', '5000', '0', 'Chuwez', '2025-06-10 14:54:33'),
('5586', 'ST10100320250610075433', '1446-12-13', '2.220.10', '101', 'an.ALFI NURDIANA', '0', '5000', 'Chuwez', '2025-06-10 14:54:33'),
('5587', 'ST10100320250610075457', '1446-12-13', '1.100.10', '101', 'an.AISYAH', '5000', '0', 'Chuwez', '2025-06-10 14:54:57'),
('5588', 'ST10100320250610075457', '1446-12-13', '2.220.10', '101', 'an.AISYAH', '0', '5000', 'Chuwez', '2025-06-10 14:54:57'),
('5589', 'ST10100320250610075518', '1446-12-13', '1.100.10', '101', 'an.DIANA RIFQOTUL QOLBI', '5000', '0', 'Chuwez', '2025-06-10 14:55:18'),
('5590', 'ST10100320250610075518', '1446-12-13', '2.220.10', '101', 'an.DIANA RIFQOTUL QOLBI', '0', '5000', 'Chuwez', '2025-06-10 14:55:18'),
('5591', 'ST10100320250610075540', '1446-12-13', '1.100.10', '101', 'an.AHMAD ADITIYA', '2000', '0', 'Chuwez', '2025-06-10 14:55:41'),
('5592', 'ST10100320250610075540', '1446-12-13', '2.220.10', '101', 'an.AHMAD ADITIYA', '0', '2000', 'Chuwez', '2025-06-10 14:55:41'),
('5593', 'ST10100320250610075608', '1446-12-13', '1.100.10', '101', 'an.AZKA AUFARIL MINAN', '10000', '0', 'Chuwez', '2025-06-10 14:56:08'),
('5594', 'ST10100320250610075608', '1446-12-13', '2.220.10', '101', 'an.AZKA AUFARIL MINAN', '0', '10000', 'Chuwez', '2025-06-10 14:56:08'),
('5595', 'ST10100320250610075627', '1446-12-13', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '5000', '0', 'Chuwez', '2025-06-10 14:56:27'),
('5596', 'ST10100320250610075627', '1446-12-13', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '5000', 'Chuwez', '2025-06-10 14:56:27'),
('5597', 'D110100320250610075721', '1446-12-13', '1.100.10', '101', 'Bayar[M. ZAINURI AZIZ SINATRIA]', '40000', '0', 'Chuwez', '2025-06-10 14:57:21'),
('5598', 'D110100320250610075721', '1446-12-13', '4.400.22', '101', 'Bayar[M. ZAINURI AZIZ SINATRIA]', '0', '40000', 'Chuwez', '2025-06-10 14:57:21'),
('5599', 'ST10100320250610075753', '1446-12-13', '1.100.10', '101', 'an.MARIYATUL QIBTIYAH', '6000', '0', 'Chuwez', '2025-06-10 14:57:53'),
('5600', 'ST10100320250610075753', '1446-12-13', '2.220.10', '101', 'an.MARIYATUL QIBTIYAH', '0', '6000', 'Chuwez', '2025-06-10 14:57:53'),
('5601', 'ST10100320250610075813', '1446-12-13', '1.100.10', '101', 'an.MARIATUL QIBTIYAH', '2000', '0', 'Chuwez', '2025-06-10 14:58:13'),
('5602', 'ST10100320250610075813', '1446-12-13', '2.220.10', '101', 'an.MARIATUL QIBTIYAH', '0', '2000', 'Chuwez', '2025-06-10 14:58:13'),
('5603', 'ST10100320250610075832', '1446-12-13', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'Chuwez', '2025-06-10 14:58:32'),
('5604', 'ST10100320250610075832', '1446-12-13', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'Chuwez', '2025-06-10 14:58:32'),
('5605', 'ST10100320250610075851', '1446-12-13', '1.100.10', '101', 'an.NAILATUN NIAMI', '2000', '0', 'Chuwez', '2025-06-10 14:58:51'),
('5606', 'ST10100320250610075851', '1446-12-13', '2.220.10', '101', 'an.NAILATUN NIAMI', '0', '2000', 'Chuwez', '2025-06-10 14:58:51'),
('5607', 'ST10100320250610075909', '1446-12-13', '1.100.10', '101', 'an.SITI ISTIFAIYAH', '15000', '0', 'Chuwez', '2025-06-10 14:59:09'),
('5608', 'ST10100320250610075909', '1446-12-13', '2.220.10', '101', 'an.SITI ISTIFAIYAH', '0', '15000', 'Chuwez', '2025-06-10 14:59:09'),
('5609', 'ST10100320250610075931', '1446-12-13', '1.100.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '9000', '0', 'Chuwez', '2025-06-10 14:59:31'),
('5610', 'ST10100320250610075931', '1446-12-13', '2.220.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '0', '9000', 'Chuwez', '2025-06-10 14:59:31'),
('5611', 'ST10100320250610075949', '1446-12-13', '1.100.10', '101', 'an.RAISA ANNISA', '5000', '0', 'Chuwez', '2025-06-10 14:59:49'),
('5612', 'ST10100320250610075949', '1446-12-13', '2.220.10', '101', 'an.RAISA ANNISA', '0', '5000', 'Chuwez', '2025-06-10 14:59:49'),
('5613', 'ST10100320250610080003', '1446-12-13', '1.100.10', '101', 'an.UMAR FARUQ', '5000', '0', 'Chuwez', '2025-06-10 15:00:03'),
('5614', 'ST10100320250610080003', '1446-12-13', '2.220.10', '101', 'an.UMAR FARUQ', '0', '5000', 'Chuwez', '2025-06-10 15:00:03'),
('5615', 'ST10100320250610080017', '1446-12-13', '1.100.10', '101', 'an.FAIZAH NURUL LITA', '5000', '0', 'Chuwez', '2025-06-10 15:00:17'),
('5616', 'ST10100320250610080017', '1446-12-13', '2.220.10', '101', 'an.FAIZAH NURUL LITA', '0', '5000', 'Chuwez', '2025-06-10 15:00:17'),
('5617', 'ST10100320250610080030', '1446-12-13', '1.100.10', '101', 'an.ROHMATULLOH', '5000', '0', 'Chuwez', '2025-06-10 15:00:30'),
('5618', 'ST10100320250610080030', '1446-12-13', '2.220.10', '101', 'an.ROHMATULLOH', '0', '5000', 'Chuwez', '2025-06-10 15:00:30'),
('5619', 'ST10100320250610080043', '1446-12-13', '1.100.10', '101', 'an.MUHAMMAD ALWI', '10000', '0', 'Chuwez', '2025-06-10 15:00:43'),
('5620', 'ST10100320250610080043', '1446-12-13', '2.220.10', '101', 'an.MUHAMMAD ALWI', '0', '10000', 'Chuwez', '2025-06-10 15:00:43'),
('5621', 'ST10100320250610080100', '1446-12-13', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '10000', '0', 'Chuwez', '2025-06-10 15:01:00'),
('5622', 'ST10100320250610080100', '1446-12-13', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '10000', 'Chuwez', '2025-06-10 15:01:00'),
('5623', 'ST10100320250610080212', '1446-12-13', '1.100.10', '101', 'an.HAIKAL SHOMADANI', '2000', '0', 'Chuwez', '2025-06-10 15:02:12'),
('5624', 'ST10100320250610080212', '1446-12-13', '2.220.10', '101', 'an.HAIKAL SHOMADANI', '0', '2000', 'Chuwez', '2025-06-10 15:02:12'),
('5625', 'ST10100320250610080239', '1446-12-13', '1.100.10', '101', 'an.M. ABD. HADI', '2000', '0', 'Chuwez', '2025-06-10 15:02:39'),
('5626', 'ST10100320250610080239', '1446-12-13', '2.220.10', '101', 'an.M. ABD. HADI', '0', '2000', 'Chuwez', '2025-06-10 15:02:39'),
('5627', 'ST10100320250610080255', '1446-12-13', '1.100.10', '101', 'an.NAURA BILADINA', '5000', '0', 'Chuwez', '2025-06-10 15:02:55'),
('5628', 'ST10100320250610080255', '1446-12-13', '2.220.10', '101', 'an.NAURA BILADINA', '0', '5000', 'Chuwez', '2025-06-10 15:02:55'),
('5629', 'ST10100320250610080312', '1446-12-13', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '10000', '0', 'Chuwez', '2025-06-10 15:03:12'),
('5630', 'ST10100320250610080312', '1446-12-13', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '10000', 'Chuwez', '2025-06-10 15:03:12'),
('5631', 'ST10100320250610080328', '1446-12-13', '1.100.10', '101', 'an.SALWA LAILI', '10000', '0', 'Chuwez', '2025-06-10 15:03:28'),
('5632', 'ST10100320250610080328', '1446-12-13', '2.220.10', '101', 'an.SALWA LAILI', '0', '10000', 'Chuwez', '2025-06-10 15:03:28'),
('5633', 'ST10100320250610080343', '1446-12-13', '1.100.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '5000', '0', 'Chuwez', '2025-06-10 15:03:43'),
('5634', 'ST10100320250610080343', '1446-12-13', '2.220.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '0', '5000', 'Chuwez', '2025-06-10 15:03:43'),
('5635', 'ST10100320250610080408', '1446-12-13', '1.100.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '10000', '0', 'Chuwez', '2025-06-10 15:04:08'),
('5636', 'ST10100320250610080408', '1446-12-13', '2.220.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '0', '10000', 'Chuwez', '2025-06-10 15:04:08'),
('5637', 'ST10100320250610080423', '1446-12-13', '1.100.10', '101', 'an.AULIA AZZAHRA', '10000', '0', 'Chuwez', '2025-06-10 15:04:24'),
('5638', 'ST10100320250610080423', '1446-12-13', '2.220.10', '101', 'an.AULIA AZZAHRA', '0', '10000', 'Chuwez', '2025-06-10 15:04:24'),
('5639', 'ST10100320250610080440', '1446-12-13', '1.100.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '2000', '0', 'Chuwez', '2025-06-10 15:04:40'),
('5640', 'ST10100320250610080440', '1446-12-13', '2.220.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '0', '2000', 'Chuwez', '2025-06-10 15:04:40'),
('5641', 'ST10100320250610080506', '1446-12-13', '1.100.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '5000', '0', 'Chuwez', '2025-06-10 15:05:06'),
('5642', 'ST10100320250610080506', '1446-12-13', '2.220.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '0', '5000', 'Chuwez', '2025-06-10 15:05:06'),
('5643', 'ST10100320250610080541', '1446-12-13', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'Chuwez', '2025-06-10 15:05:41'),
('5644', 'ST10100320250610080541', '1446-12-13', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'Chuwez', '2025-06-10 15:05:41'),
('5645', 'ST10100320250610080602', '1446-12-13', '1.100.10', '101', 'an.HALIMAH', '5000', '0', 'Chuwez', '2025-06-10 15:06:02'),
('5646', 'ST10100320250610080602', '1446-12-13', '2.220.10', '101', 'an.HALIMAH', '0', '5000', 'Chuwez', '2025-06-10 15:06:02'),
('5647', 'ST10100320250610080632', '1446-12-13', '1.100.10', '101', 'an.HILYA', '20000', '0', 'Chuwez', '2025-06-10 15:06:32'),
('5648', 'ST10100320250610080632', '1446-12-13', '2.220.10', '101', 'an.HILYA', '0', '20000', 'Chuwez', '2025-06-10 15:06:32'),
('5649', 'D110100320250610080821', '1446-12-13', '1.100.10', '101', 'Bayar[AHMAD JAMALUL MAIMUN]', '40000', '0', 'Chuwez', '2025-06-10 15:08:21'),
('5650', 'D110100320250610080821', '1446-12-13', '4.400.22', '101', 'Bayar[AHMAD JAMALUL MAIMUN]', '0', '40000', 'Chuwez', '2025-06-10 15:08:21'),
('5651', 'BS10100320250610080852000', '1446-10-13', '1.100.10', '101', 'Bayar[AHMAD JAMALUL MAIMUN]', '30000', '0', 'Chuwez', '2025-06-10 15:08:52'),
('5652', 'BS10100320250610080852000', '1446-10-13', '4.400.20', '101', 'Bayar[AHMAD JAMALUL MAIMUN]', '0', '30000', 'Chuwez', '2025-06-10 15:08:52'),
('5653', 'BS10100320250610080852001', '1446-11-13', '1.100.10', '101', 'Bayar[AHMAD JAMALUL MAIMUN]', '30000', '0', 'Chuwez', '2025-06-10 15:08:52'),
('5654', 'BS10100320250610080852001', '1446-11-13', '4.400.20', '101', 'Bayar[AHMAD JAMALUL MAIMUN]', '0', '30000', 'Chuwez', '2025-06-10 15:08:52'),
('5655', 'BS10100320250610080852002', '1446-12-13', '1.100.10', '101', 'Bayar[AHMAD JAMALUL MAIMUN]', '30000', '0', 'Chuwez', '2025-06-10 15:08:52'),
('5656', 'BS10100320250610080852002', '1446-12-13', '4.400.20', '101', 'Bayar[AHMAD JAMALUL MAIMUN]', '0', '30000', 'Chuwez', '2025-06-10 15:08:52'),
('5657', 'BS10100320250610080952000', '1446-11-13', '1.100.10', '101', 'Bayar[SITI ISTIFAIYAH]', '30000', '0', 'Chuwez', '2025-06-10 15:09:52'),
('5658', 'BS10100320250610080952000', '1446-11-13', '4.400.20', '101', 'Bayar[SITI ISTIFAIYAH]', '0', '30000', 'Chuwez', '2025-06-10 15:09:52'),
('5659', 'KK10100320250610151007', '1446-12-13', '5.520.42', '101', 'Cilok', '10000', '0', 'Chuwez', '2025-06-10 15:10:24'),
('5660', 'KK10100320250610151007', '1446-12-13', '1.100.10', '101', 'Cilok', '0', '10000', 'Chuwez', '2025-06-10 15:10:24'),
('5661', 'KK10100320250610151007', '1446-12-13', '5.520.37', '101', 'Foto copy', '4000', '0', 'Chuwez', '2025-06-10 15:11:59'),
('5662', 'KK10100320250610151007', '1446-12-13', '1.100.10', '101', 'Foto copy', '0', '4000', 'Chuwez', '2025-06-10 15:11:59'),
('5663', 'BS10100320250610081407000', '1446-10-13', '1.100.10', '101', 'Bayar[ACH. JUNAIDI]', '30000', '0', 'Chuwez', '2025-06-10 15:14:07'),
('5664', 'BS10100320250610081407000', '1446-10-13', '4.400.20', '101', 'Bayar[ACH. JUNAIDI]', '0', '30000', 'Chuwez', '2025-06-10 15:14:07'),
('5665', 'BS10100320250610081407001', '1446-11-13', '1.100.10', '101', 'Bayar[ACH. JUNAIDI]', '30000', '0', 'Chuwez', '2025-06-10 15:14:07'),
('5666', 'BS10100320250610081407001', '1446-11-13', '4.400.20', '101', 'Bayar[ACH. JUNAIDI]', '0', '30000', 'Chuwez', '2025-06-10 15:14:07'),
('5667', 'BS10100320250610081407002', '1446-12-13', '1.100.10', '101', 'Bayar[ACH. JUNAIDI]', '30000', '0', 'Chuwez', '2025-06-10 15:14:07'),
('5668', 'BS10100320250610081407002', '1446-12-13', '4.400.20', '101', 'Bayar[ACH. JUNAIDI]', '0', '30000', 'Chuwez', '2025-06-10 15:14:07'),
('5669', 'BS10100320250610081547000', '1446-12-13', '1.100.10', '101', 'Bayar[RAISA ANNISA]', '30000', '0', 'Chuwez', '2025-06-10 15:15:47'),
('5670', 'BS10100320250610081547000', '1446-12-13', '4.400.20', '101', 'Bayar[RAISA ANNISA]', '0', '30000', 'Chuwez', '2025-06-10 15:15:47'),
('5671', 'BS10100320250610091701000', '1446-10-13', '1.100.10', '101', 'Bayar[AHMADA KEVIN AINUN NAIM]', '30000', '0', 'Chuwez', '2025-06-10 16:17:01'),
('5672', 'BS10100320250610091701000', '1446-10-13', '4.400.20', '101', 'Bayar[AHMADA KEVIN AINUN NAIM]', '0', '30000', 'Chuwez', '2025-06-10 16:17:01'),
('5673', 'BS10100320250610091701001', '1446-11-13', '1.100.10', '101', 'Bayar[AHMADA KEVIN AINUN NAIM]', '30000', '0', 'Chuwez', '2025-06-10 16:17:01'),
('5674', 'BS10100320250610091701001', '1446-11-13', '4.400.20', '101', 'Bayar[AHMADA KEVIN AINUN NAIM]', '0', '30000', 'Chuwez', '2025-06-10 16:17:01'),
('5675', 'BS10100320250610091701002', '1446-12-13', '1.100.10', '101', 'Bayar[AHMADA KEVIN AINUN NAIM]', '30000', '0', 'Chuwez', '2025-06-10 16:17:01'),
('5676', 'BS10100320250610091701002', '1446-12-13', '4.400.20', '101', 'Bayar[AHMADA KEVIN AINUN NAIM]', '0', '30000', 'Chuwez', '2025-06-10 16:17:01'),
('5677', 'BS10100320250610091701003', '1447-01-13', '1.100.10', '101', 'Bayar[AHMADA KEVIN AINUN NAIM]', '30000', '0', 'Chuwez', '2025-06-10 16:17:01'),
('5678', 'BS10100320250610091701003', '1447-01-13', '4.400.20', '101', 'Bayar[AHMADA KEVIN AINUN NAIM]', '0', '30000', 'Chuwez', '2025-06-10 16:17:01'),
('5679', 'D110100320250611062649', '1446-12-14', '1.100.10', '101', 'Bayar[AHMAD RAFI SALIM]', '35000', '0', 'Chuwez', '2025-06-11 13:26:49'),
('5680', 'D110100320250611062649', '1446-12-14', '4.400.22', '101', 'Bayar[AHMAD RAFI SALIM]', '0', '35000', 'Chuwez', '2025-06-11 13:26:49'),
('5681', 'D110100320250611062714', '1446-12-14', '1.100.10', '101', 'Bayar[DIYANAH KAMALIYAH]', '35000', '0', 'Chuwez', '2025-06-11 13:27:14'),
('5682', 'D110100320250611062714', '1446-12-14', '4.400.22', '101', 'Bayar[DIYANAH KAMALIYAH]', '0', '35000', 'Chuwez', '2025-06-11 13:27:14'),
('5683', 'D110100320250611062737', '1446-12-14', '1.100.10', '101', 'Bayar[SITI KARIMATIN NISAK]', '35000', '0', 'Chuwez', '2025-06-11 13:27:37'),
('5684', 'D110100320250611062737', '1446-12-14', '4.400.22', '101', 'Bayar[SITI KARIMATIN NISAK]', '0', '35000', 'Chuwez', '2025-06-11 13:27:37'),
('5685', 'ST10100320250611064702', '1446-12-14', '1.100.10', '101', 'an.MUHAMMAD HAMDANI', '10000', '0', 'Chuwez', '2025-06-11 13:47:02'),
('5686', 'ST10100320250611064702', '1446-12-14', '2.220.10', '101', 'an.MUHAMMAD HAMDANI', '0', '10000', 'Chuwez', '2025-06-11 13:47:02'),
('5687', 'ST10100320250611064748', '1446-12-14', '1.100.10', '101', 'an.M. ALIFIN FIKRI', '2000', '0', 'Chuwez', '2025-06-11 13:47:48'),
('5688', 'ST10100320250611064748', '1446-12-14', '2.220.10', '101', 'an.M. ALIFIN FIKRI', '0', '2000', 'Chuwez', '2025-06-11 13:47:48'),
('5689', 'ST10100320250611064845', '1446-12-14', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '5000', '0', 'Chuwez', '2025-06-11 13:48:45'),
('5690', 'ST10100320250611064845', '1446-12-14', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '5000', 'Chuwez', '2025-06-11 13:48:45'),
('5691', 'ST10100320250611064913', '1446-12-14', '1.100.10', '101', 'an.MUHAMMAD KHOIRON', '5000', '0', 'Chuwez', '2025-06-11 13:49:14'),
('5692', 'ST10100320250611064913', '1446-12-14', '2.220.10', '101', 'an.MUHAMMAD KHOIRON', '0', '5000', 'Chuwez', '2025-06-11 13:49:14'),
('5693', 'ST10100320250611065005', '1446-12-14', '1.100.10', '101', 'an.AFANDI', '2000', '0', 'Chuwez', '2025-06-11 13:50:05'),
('5694', 'ST10100320250611065005', '1446-12-14', '2.220.10', '101', 'an.AFANDI', '0', '2000', 'Chuwez', '2025-06-11 13:50:05'),
('5695', 'ST10100320250611065122', '1446-12-14', '1.100.10', '101', 'an.ANA SALSABILA', '5000', '0', 'Chuwez', '2025-06-11 13:51:22'),
('5696', 'ST10100320250611065122', '1446-12-14', '2.220.10', '101', 'an.ANA SALSABILA', '0', '5000', 'Chuwez', '2025-06-11 13:51:22'),
('5697', 'ST10100320250611065205', '1446-12-14', '1.100.10', '101', 'an.ZAKIYATUL UMMAH', '2000', '0', 'Chuwez', '2025-06-11 13:52:05'),
('5698', 'ST10100320250611065205', '1446-12-14', '2.220.10', '101', 'an.ZAKIYATUL UMMAH', '0', '2000', 'Chuwez', '2025-06-11 13:52:05'),
('5699', 'ST10100320250611065303', '1446-12-14', '1.100.10', '101', 'an.SINDI RAISA PUTRI', '10000', '0', 'Chuwez', '2025-06-11 13:53:03'),
('5700', 'ST10100320250611065303', '1446-12-14', '2.220.10', '101', 'an.SINDI RAISA PUTRI', '0', '10000', 'Chuwez', '2025-06-11 13:53:03'),
('5701', 'ST10100320250611065345', '1446-12-14', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '25000', '0', 'Chuwez', '2025-06-11 13:53:45'),
('5702', 'ST10100320250611065345', '1446-12-14', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '25000', 'Chuwez', '2025-06-11 13:53:45'),
('5703', 'ST10100320250611065503', '1446-12-14', '1.100.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '5000', '0', 'Chuwez', '2025-06-11 13:55:03'),
('5704', 'ST10100320250611065503', '1446-12-14', '2.220.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '0', '5000', 'Chuwez', '2025-06-11 13:55:03'),
('5705', 'ST10100320250611065535', '1446-12-14', '1.100.10', '101', 'an.AHMAD JAMALUL MAIMUN', '5000', '0', 'Chuwez', '2025-06-11 13:55:35'),
('5706', 'ST10100320250611065535', '1446-12-14', '2.220.10', '101', 'an.AHMAD JAMALUL MAIMUN', '0', '5000', 'Chuwez', '2025-06-11 13:55:35'),
('5707', 'ST10100320250611065636', '1446-12-14', '1.100.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '10000', '0', 'Chuwez', '2025-06-11 13:56:36'),
('5708', 'ST10100320250611065636', '1446-12-14', '2.220.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '0', '10000', 'Chuwez', '2025-06-11 13:56:36'),
('5709', 'ST10100320250611065711', '1446-12-14', '1.100.10', '101', 'an.AKHMAD FIKRI HAIKAL', '50000', '0', 'Chuwez', '2025-06-11 13:57:11'),
('5710', 'ST10100320250611065711', '1446-12-14', '2.220.10', '101', 'an.AKHMAD FIKRI HAIKAL', '0', '50000', 'Chuwez', '2025-06-11 13:57:11'),
('5711', 'ST10100320250611065757', '1446-12-14', '1.100.10', '101', 'an.AHMAD ABBAS MAULANA', '3000', '0', 'Chuwez', '2025-06-11 13:57:57'),
('5712', 'ST10100320250611065757', '1446-12-14', '2.220.10', '101', 'an.AHMAD ABBAS MAULANA', '0', '3000', 'Chuwez', '2025-06-11 13:57:57'),
('5713', 'ST10100320250611065958', '1446-12-14', '1.100.10', '101', 'an.M. HAIKAL NASRULLOH', '5000', '0', 'Chuwez', '2025-06-11 13:59:58'),
('5714', 'ST10100320250611065958', '1446-12-14', '2.220.10', '101', 'an.M. HAIKAL NASRULLOH', '0', '5000', 'Chuwez', '2025-06-11 13:59:58'),
('5715', 'ST10100320250611070032', '1446-12-14', '1.100.10', '101', 'an.MIFTAHUL JANNAH', '50000', '0', 'Chuwez', '2025-06-11 14:00:32'),
('5716', 'ST10100320250611070032', '1446-12-14', '2.220.10', '101', 'an.MIFTAHUL JANNAH', '0', '50000', 'Chuwez', '2025-06-11 14:00:32'),
('5717', 'ST10100320250611070124', '1446-12-14', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Chuwez', '2025-06-11 14:01:24'),
('5718', 'ST10100320250611070124', '1446-12-14', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Chuwez', '2025-06-11 14:01:24'),
('5719', 'ST10100320250611070151', '1446-12-14', '1.100.10', '101', 'an.M. KAMALUDDIN', '10000', '0', 'Chuwez', '2025-06-11 14:01:51'),
('5720', 'ST10100320250611070151', '1446-12-14', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '10000', 'Chuwez', '2025-06-11 14:01:51'),
('5721', 'ST10100320250611070212', '1446-12-14', '1.100.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '5000', '0', 'Chuwez', '2025-06-11 14:02:12'),
('5722', 'ST10100320250611070212', '1446-12-14', '2.220.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '0', '5000', 'Chuwez', '2025-06-11 14:02:12'),
('5723', 'ST10100320250611070251', '1446-12-14', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '4000', '0', 'Chuwez', '2025-06-11 14:02:51'),
('5724', 'ST10100320250611070251', '1446-12-14', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '4000', 'Chuwez', '2025-06-11 14:02:51'),
('5725', 'ST10100320250611070314', '1446-12-14', '1.100.10', '101', 'an.NABILATUN NISAUL UMMAH', '50000', '0', 'Chuwez', '2025-06-11 14:03:14'),
('5726', 'ST10100320250611070314', '1446-12-14', '2.220.10', '101', 'an.NABILATUN NISAUL UMMAH', '0', '50000', 'Chuwez', '2025-06-11 14:03:14'),
('5727', 'ST10100320250611070403', '1446-12-14', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '2000', '0', 'Chuwez', '2025-06-11 14:04:03'),
('5728', 'ST10100320250611070403', '1446-12-14', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '2000', 'Chuwez', '2025-06-11 14:04:03'),
('5729', 'ST10100320250611070446', '1446-12-14', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '10000', '0', 'Chuwez', '2025-06-11 14:04:46'),
('5730', 'ST10100320250611070446', '1446-12-14', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '10000', 'Chuwez', '2025-06-11 14:04:46'),
('5731', 'ST10100320250611071159', '1446-12-14', '1.100.10', '101', 'an.MUHAMMAD ARDIANSYAH', '10000', '0', 'Chuwez', '2025-06-11 14:11:59'),
('5732', 'ST10100320250611071159', '1446-12-14', '2.220.10', '101', 'an.MUHAMMAD ARDIANSYAH', '0', '10000', 'Chuwez', '2025-06-11 14:11:59'),
('5733', 'ST10100320250611071220', '1446-12-14', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'Chuwez', '2025-06-11 14:12:20'),
('5734', 'ST10100320250611071220', '1446-12-14', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'Chuwez', '2025-06-11 14:12:20'),
('5735', 'ST10100320250611071240', '1446-12-14', '1.100.10', '101', 'an.MARIATUL QIBTIYAH', '2000', '0', 'Chuwez', '2025-06-11 14:12:40'),
('5736', 'ST10100320250611071240', '1446-12-14', '2.220.10', '101', 'an.MARIATUL QIBTIYAH', '0', '2000', 'Chuwez', '2025-06-11 14:12:40'),
('5737', 'ST10100320250611071315', '1446-12-14', '1.100.10', '101', 'an.NAILATUN NIAMI', '2000', '0', 'Chuwez', '2025-06-11 14:13:15'),
('5738', 'ST10100320250611071315', '1446-12-14', '2.220.10', '101', 'an.NAILATUN NIAMI', '0', '2000', 'Chuwez', '2025-06-11 14:13:15'),
('5739', 'ST10100320250611071408', '1446-12-14', '1.100.10', '101', 'an.ROFIQOTUS SARIROH', '5000', '0', 'Chuwez', '2025-06-11 14:14:08'),
('5740', 'ST10100320250611071408', '1446-12-14', '2.220.10', '101', 'an.ROFIQOTUS SARIROH', '0', '5000', 'Chuwez', '2025-06-11 14:14:08'),
('5741', 'ST10100320250611071428', '1446-12-14', '1.100.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '4000', '0', 'Chuwez', '2025-06-11 14:14:28'),
('5742', 'ST10100320250611071428', '1446-12-14', '2.220.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '0', '4000', 'Chuwez', '2025-06-11 14:14:28'),
('5743', 'ST10100320250611071452', '1446-12-14', '1.100.10', '101', 'an.ALFI NURDIANA', '5000', '0', 'Chuwez', '2025-06-11 14:14:52'),
('5744', 'ST10100320250611071452', '1446-12-14', '2.220.10', '101', 'an.ALFI NURDIANA', '0', '5000', 'Chuwez', '2025-06-11 14:14:52'),
('5745', 'ST10100320250611071511', '1446-12-14', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '5000', '0', 'Chuwez', '2025-06-11 14:15:11'),
('5746', 'ST10100320250611071511', '1446-12-14', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '5000', 'Chuwez', '2025-06-11 14:15:11'),
('5747', 'ST10100320250611071532', '1446-12-14', '1.100.10', '101', 'an.AZKA AUFARIL MINAN', '10000', '0', 'Chuwez', '2025-06-11 14:15:32'),
('5748', 'ST10100320250611071532', '1446-12-14', '2.220.10', '101', 'an.AZKA AUFARIL MINAN', '0', '10000', 'Chuwez', '2025-06-11 14:15:32'),
('5749', 'ST10100320250611071557', '1446-12-14', '1.100.10', '101', 'an.AISYAH', '4000', '0', 'Chuwez', '2025-06-11 14:15:57'),
('5750', 'ST10100320250611071557', '1446-12-14', '2.220.10', '101', 'an.AISYAH', '0', '4000', 'Chuwez', '2025-06-11 14:15:57'),
('5751', 'ST10100320250611071619', '1446-12-14', '1.100.10', '101', 'an.SITI QURROTUL AINI', '2000', '0', 'Chuwez', '2025-06-11 14:16:19'),
('5752', 'ST10100320250611071619', '1446-12-14', '2.220.10', '101', 'an.SITI QURROTUL AINI', '0', '2000', 'Chuwez', '2025-06-11 14:16:19'),
('5753', 'ST10100320250611071637', '1446-12-14', '1.100.10', '101', 'an.SITI ATHIUR ROHMAH', '5000', '0', 'Chuwez', '2025-06-11 14:16:37'),
('5754', 'ST10100320250611071637', '1446-12-14', '2.220.10', '101', 'an.SITI ATHIUR ROHMAH', '0', '5000', 'Chuwez', '2025-06-11 14:16:37'),
('5755', 'ST10100320250611071701', '1446-12-14', '1.100.10', '101', 'an.DIYANAH KAMALIYAH', '2000', '0', 'Chuwez', '2025-06-11 14:17:01'),
('5756', 'ST10100320250611071701', '1446-12-14', '2.220.10', '101', 'an.DIYANAH KAMALIYAH', '0', '2000', 'Chuwez', '2025-06-11 14:17:01'),
('5757', 'ST10100320250611071727', '1446-12-14', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '10000', '0', 'Chuwez', '2025-06-11 14:17:27'),
('5758', 'ST10100320250611071727', '1446-12-14', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '10000', 'Chuwez', '2025-06-11 14:17:27'),
('5759', 'ST10100320250611071751', '1446-12-14', '1.100.10', '101', 'an.ABDUL HAMID', '5000', '0', 'Chuwez', '2025-06-11 14:17:51'),
('5760', 'ST10100320250611071751', '1446-12-14', '2.220.10', '101', 'an.ABDUL HAMID', '0', '5000', 'Chuwez', '2025-06-11 14:17:51'),
('5761', 'ST10100320250611072825', '1446-12-14', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '5000', '0', 'Chuwez', '2025-06-11 14:28:25'),
('5762', 'ST10100320250611072825', '1446-12-14', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '5000', 'Chuwez', '2025-06-11 14:28:25'),
('5763', 'ST10100320250611072850', '1446-12-14', '1.100.10', '101', 'an.HAIKAL SHOMADANI', '2000', '0', 'Chuwez', '2025-06-11 14:28:50'),
('5764', 'ST10100320250611072850', '1446-12-14', '2.220.10', '101', 'an.HAIKAL SHOMADANI', '0', '2000', 'Chuwez', '2025-06-11 14:28:50'),
('5765', 'ST10100320250611073001', '1446-12-14', '1.100.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '2000', '0', 'Chuwez', '2025-06-11 14:30:01'),
('5766', 'ST10100320250611073001', '1446-12-14', '2.220.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '0', '2000', 'Chuwez', '2025-06-11 14:30:01'),
('5767', 'ST10100320250611073024', '1446-12-14', '1.100.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '2000', '0', 'Chuwez', '2025-06-11 14:30:24'),
('5768', 'ST10100320250611073024', '1446-12-14', '2.220.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '0', '2000', 'Chuwez', '2025-06-11 14:30:24'),
('5769', 'ST10100320250611073052', '1446-12-14', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '5000', '0', 'Chuwez', '2025-06-11 14:30:52'),
('5770', 'ST10100320250611073052', '1446-12-14', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '5000', 'Chuwez', '2025-06-11 14:30:52'),
('5771', 'ST10100320250611073119', '1446-12-14', '1.100.10', '101', 'an.RAISA ANNISA', '5000', '0', 'Chuwez', '2025-06-11 14:31:19'),
('5772', 'ST10100320250611073119', '1446-12-14', '2.220.10', '101', 'an.RAISA ANNISA', '0', '5000', 'Chuwez', '2025-06-11 14:31:19'),
('5773', 'ST10100320250611073139', '1446-12-14', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '10000', '0', 'Chuwez', '2025-06-11 14:31:39'),
('5774', 'ST10100320250611073139', '1446-12-14', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '10000', 'Chuwez', '2025-06-11 14:31:39'),
('5775', 'ST10100320250611073159', '1446-12-14', '1.100.10', '101', 'an.NAURA BILADINA', '5000', '0', 'Chuwez', '2025-06-11 14:31:59'),
('5776', 'ST10100320250611073159', '1446-12-14', '2.220.10', '101', 'an.NAURA BILADINA', '0', '5000', 'Chuwez', '2025-06-11 14:31:59'),
('5777', 'ST10100320250611073240', '1446-12-14', '1.100.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '5000', '0', 'Chuwez', '2025-06-11 14:32:40'),
('5778', 'ST10100320250611073240', '1446-12-14', '2.220.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '0', '5000', 'Chuwez', '2025-06-11 14:32:40'),
('5779', 'ST10100320250611073305', '1446-12-14', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'Chuwez', '2025-06-11 14:33:05'),
('5780', 'ST10100320250611073305', '1446-12-14', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'Chuwez', '2025-06-11 14:33:05'),
('5781', 'ST10100320250611073336', '1446-12-14', '1.100.10', '101', 'an.M. ABD. HADI', '2000', '0', 'Chuwez', '2025-06-11 14:33:36'),
('5782', 'ST10100320250611073336', '1446-12-14', '2.220.10', '101', 'an.M. ABD. HADI', '0', '2000', 'Chuwez', '2025-06-11 14:33:36'),
('5783', 'ST10100320250611073401', '1446-12-14', '1.100.10', '101', 'an.MUHAMMAD ALWI', '10000', '0', 'Chuwez', '2025-06-11 14:34:01'),
('5784', 'ST10100320250611073401', '1446-12-14', '2.220.10', '101', 'an.MUHAMMAD ALWI', '0', '10000', 'Chuwez', '2025-06-11 14:34:01'),
('5785', 'ST10100320250611073426', '1446-12-14', '1.100.10', '101', 'an.UMAR FARUQ', '5000', '0', 'Chuwez', '2025-06-11 14:34:26'),
('5786', 'ST10100320250611073426', '1446-12-14', '2.220.10', '101', 'an.UMAR FARUQ', '0', '5000', 'Chuwez', '2025-06-11 14:34:26'),
('5787', 'ST10100320250611073449', '1446-12-14', '1.100.10', '101', 'an.FAIZAH NURUL LITA', '10000', '0', 'Chuwez', '2025-06-11 14:34:49'),
('5788', 'ST10100320250611073449', '1446-12-14', '2.220.10', '101', 'an.FAIZAH NURUL LITA', '0', '10000', 'Chuwez', '2025-06-11 14:34:49'),
('5789', 'ST10100320250611073616', '1446-12-14', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'Chuwez', '2025-06-11 14:36:16'),
('5790', 'ST10100320250611073616', '1446-12-14', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'Chuwez', '2025-06-11 14:36:16'),
('5791', 'D110100320250611073715', '1446-12-14', '1.100.10', '101', 'Bayar[NAILATUN NIAMI]', '20000', '0', 'Chuwez', '2025-06-11 14:37:15'),
('5792', 'D110100320250611073715', '1446-12-14', '4.400.22', '101', 'Bayar[NAILATUN NIAMI]', '0', '20000', 'Chuwez', '2025-06-11 14:37:15'),
('5795', 'BS10100320250611073902000', '1446-12-14', '1.100.10', '101', 'Bayar[ROFIQOTUS SARIROH]', '30000', '0', 'Chuwez', '2025-06-11 14:39:02'),
('5796', 'BS10100320250611073902000', '1446-12-14', '4.400.20', '101', 'Bayar[ROFIQOTUS SARIROH]', '0', '30000', 'Chuwez', '2025-06-11 14:39:02'),
('5797', 'BS10100320250611074025000', '1446-11-14', '1.100.10', '101', 'Bayar[SAFIRATUL JANNAH]', '30000', '0', 'Chuwez', '2025-06-11 14:40:25'),
('5798', 'BS10100320250611074025000', '1446-11-14', '4.400.20', '101', 'Bayar[SAFIRATUL JANNAH]', '0', '30000', 'Chuwez', '2025-06-11 14:40:25'),
('5799', 'BS10100320250611074025001', '1446-12-14', '1.100.10', '101', 'Bayar[SAFIRATUL JANNAH]', '30000', '0', 'Chuwez', '2025-06-11 14:40:25'),
('5800', 'BS10100320250611074025001', '1446-12-14', '4.400.20', '101', 'Bayar[SAFIRATUL JANNAH]', '0', '30000', 'Chuwez', '2025-06-11 14:40:25'),
('5801', 'BS10100320250611074109000', '1446-11-14', '1.100.10', '101', 'Bayar[AHMAD RAFI SALIM]', '30000', '0', 'Chuwez', '2025-06-11 14:41:09'),
('5802', 'BS10100320250611074109000', '1446-11-14', '4.400.20', '101', 'Bayar[AHMAD RAFI SALIM]', '0', '30000', 'Chuwez', '2025-06-11 14:41:09'),
('5803', 'BS10100320250611074148000', '1446-12-14', '1.100.10', '101', 'Bayar[AHMAD QUTHBI EL AMIN]', '30000', '0', 'Chuwez', '2025-06-11 14:41:48'),
('5804', 'BS10100320250611074148000', '1446-12-14', '4.400.20', '101', 'Bayar[AHMAD QUTHBI EL AMIN]', '0', '30000', 'Chuwez', '2025-06-11 14:41:48'),
('5805', 'BS10100320250611074222000', '1446-11-14', '1.100.10', '101', 'Bayar[M. ROFIQ HIDAYATULLOH]', '30000', '0', 'Chuwez', '2025-06-11 14:42:22'),
('5806', 'BS10100320250611074222000', '1446-11-14', '4.400.20', '101', 'Bayar[M. ROFIQ HIDAYATULLOH]', '0', '30000', 'Chuwez', '2025-06-11 14:42:22'),
('5807', 'BS10100320250611074222001', '1446-12-14', '1.100.10', '101', 'Bayar[M. ROFIQ HIDAYATULLOH]', '30000', '0', 'Chuwez', '2025-06-11 14:42:22'),
('5808', 'BS10100320250611074222001', '1446-12-14', '4.400.20', '101', 'Bayar[M. ROFIQ HIDAYATULLOH]', '0', '30000', 'Chuwez', '2025-06-11 14:42:22'),
('5809', 'ST10100320250611074306', '1446-12-14', '1.100.10', '101', 'an.BILQIS THALIA HASNA', '75000', '0', 'Chuwez', '2025-06-11 14:43:06'),
('5810', 'ST10100320250611074306', '1446-12-14', '2.220.10', '101', 'an.BILQIS THALIA HASNA', '0', '75000', 'Chuwez', '2025-06-11 14:43:06'),
('5811', 'ST10100320250611074330', '1446-12-14', '1.100.10', '101', 'an.HILYA', '50000', '0', 'Chuwez', '2025-06-11 14:43:30'),
('5812', 'ST10100320250611074330', '1446-12-14', '2.220.10', '101', 'an.HILYA', '0', '50000', 'Chuwez', '2025-06-11 14:43:30'),
('5813', 'D110100320250611074703', '1446-12-14', '1.100.10', '101', 'Bayar[ROFIQOTUS SARIROH]', '20000', '0', 'Chuwez', '2025-06-11 14:47:03'),
('5814', 'D110100320250611074703', '1446-12-14', '4.400.22', '101', 'Bayar[ROFIQOTUS SARIROH]', '0', '20000', 'Chuwez', '2025-06-11 14:47:03'),
('5817', 'ST10100320250612100347', '1446-12-15', '1.100.10', '101', 'an.HAIKAL SHOMADANI', '2000', '0', 'Chuwez', '2025-06-12 17:03:47'),
('5818', 'ST10100320250612100347', '1446-12-15', '2.220.10', '101', 'an.HAIKAL SHOMADANI', '0', '2000', 'Chuwez', '2025-06-12 17:03:47'),
('5819', 'ST10100320250612100427', '1446-12-15', '1.100.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '5000', '0', 'Chuwez', '2025-06-12 17:04:27'),
('5820', 'ST10100320250612100427', '1446-12-15', '2.220.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '0', '5000', 'Chuwez', '2025-06-12 17:04:27'),
('5821', 'ST10100320250612100449', '1446-12-15', '1.100.10', '101', 'an.M. ABD. HADI', '2000', '0', 'Chuwez', '2025-06-12 17:04:49'),
('5822', 'ST10100320250612100449', '1446-12-15', '2.220.10', '101', 'an.M. ABD. HADI', '0', '2000', 'Chuwez', '2025-06-12 17:04:49'),
('5823', 'ST10100320250612100506', '1446-12-15', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'Chuwez', '2025-06-12 17:05:06'),
('5824', 'ST10100320250612100506', '1446-12-15', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'Chuwez', '2025-06-12 17:05:06'),
('5825', 'ST10100320250612100527', '1446-12-15', '1.100.10', '101', 'an.NAURA BILADINA', '10000', '0', 'Chuwez', '2025-06-12 17:05:27'),
('5826', 'ST10100320250612100527', '1446-12-15', '2.220.10', '101', 'an.NAURA BILADINA', '0', '10000', 'Chuwez', '2025-06-12 17:05:27'),
('5827', 'ST10100320250612100547', '1446-12-15', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '10000', '0', 'Chuwez', '2025-06-12 17:05:47'),
('5828', 'ST10100320250612100547', '1446-12-15', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '10000', 'Chuwez', '2025-06-12 17:05:47'),
('5829', 'ST10100320250612100629', '1446-12-15', '1.100.10', '101', 'an.AULIA AZZAHRA', '10000', '0', 'Chuwez', '2025-06-12 17:06:29'),
('5830', 'ST10100320250612100629', '1446-12-15', '2.220.10', '101', 'an.AULIA AZZAHRA', '0', '10000', 'Chuwez', '2025-06-12 17:06:29'),
('5831', 'ST10100320250612100737', '1446-12-15', '1.100.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '2000', '0', 'Chuwez', '2025-06-12 17:07:37'),
('5832', 'ST10100320250612100737', '1446-12-15', '2.220.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '0', '2000', 'Chuwez', '2025-06-12 17:07:37'),
('5833', 'ST10100320250612100757', '1446-12-15', '1.100.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '5000', '0', 'Chuwez', '2025-06-12 17:07:57'),
('5834', 'ST10100320250612100757', '1446-12-15', '2.220.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '0', '5000', 'Chuwez', '2025-06-12 17:07:57'),
('5835', 'ST10100320250612105011', '1446-12-15', '1.100.10', '101', 'an.UBAIDAH', '20000', '0', 'Chuwez', '2025-06-12 17:50:11'),
('5836', 'ST10100320250612105011', '1446-12-15', '2.220.10', '101', 'an.UBAIDAH', '0', '20000', 'Chuwez', '2025-06-12 17:50:11'),
('5837', 'ST10100320250612105037', '1446-12-15', '1.100.10', '101', 'an.UMAR FARUQ', '10000', '0', 'Chuwez', '2025-06-12 17:50:37'),
('5838', 'ST10100320250612105037', '1446-12-15', '2.220.10', '101', 'an.UMAR FARUQ', '0', '10000', 'Chuwez', '2025-06-12 17:50:37'),
('5839', 'ST10100320250612105059', '1446-12-15', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '5000', '0', 'Chuwez', '2025-06-12 17:50:59'),
('5840', 'ST10100320250612105059', '1446-12-15', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '5000', 'Chuwez', '2025-06-12 17:50:59'),
('5841', 'ST10100320250612105204', '1446-12-15', '1.100.10', '101', 'an.AHMAD NUR HASAN ROMADHONI', '2000', '0', 'Chuwez', '2025-06-12 17:52:04'),
('5842', 'ST10100320250612105204', '1446-12-15', '2.220.10', '101', 'an.AHMAD NUR HASAN ROMADHONI', '0', '2000', 'Chuwez', '2025-06-12 17:52:04'),
('5843', 'ST10100320250612105230', '1446-12-15', '1.100.10', '101', 'an.AISYAH', '2000', '0', 'Chuwez', '2025-06-12 17:52:30'),
('5844', 'ST10100320250612105230', '1446-12-15', '2.220.10', '101', 'an.AISYAH', '0', '2000', 'Chuwez', '2025-06-12 17:52:30'),
('5845', 'ST10100320250612105250', '1446-12-15', '1.100.10', '101', 'an.AZKA AUFARIL MINAN', '10000', '0', 'Chuwez', '2025-06-12 17:52:50'),
('5846', 'ST10100320250612105250', '1446-12-15', '2.220.10', '101', 'an.AZKA AUFARIL MINAN', '0', '10000', 'Chuwez', '2025-06-12 17:52:50'),
('5847', 'ST10100320250612105308', '1446-12-15', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '5000', '0', 'Chuwez', '2025-06-12 17:53:08'),
('5848', 'ST10100320250612105308', '1446-12-15', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '5000', 'Chuwez', '2025-06-12 17:53:08'),
('5849', 'ST10100320250612105319', '1446-12-15', '1.100.10', '101', 'an.AHMAD ADITIYA', '2000', '0', 'Chuwez', '2025-06-12 17:53:19'),
('5850', 'ST10100320250612105319', '1446-12-15', '2.220.10', '101', 'an.AHMAD ADITIYA', '0', '2000', 'Chuwez', '2025-06-12 17:53:19'),
('5851', 'ST10100320250612105331', '1446-12-15', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '10000', '0', 'Chuwez', '2025-06-12 17:53:31'),
('5852', 'ST10100320250612105331', '1446-12-15', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '10000', 'Chuwez', '2025-06-12 17:53:31'),
('5853', 'ST10100320250612105351', '1446-12-15', '1.100.10', '101', 'an.M. FAHMI NURUL ANAM', '10000', '0', 'Chuwez', '2025-06-12 17:53:51'),
('5854', 'ST10100320250612105351', '1446-12-15', '2.220.10', '101', 'an.M. FAHMI NURUL ANAM', '0', '10000', 'Chuwez', '2025-06-12 17:53:51'),
('5855', 'ST10100320250612105406', '1446-12-15', '1.100.10', '101', 'an.DIYANAH KAMALIYAH', '2000', '0', 'Chuwez', '2025-06-12 17:54:06'),
('5856', 'ST10100320250612105406', '1446-12-15', '2.220.10', '101', 'an.DIYANAH KAMALIYAH', '0', '2000', 'Chuwez', '2025-06-12 17:54:06'),
('5857', 'ST10100320250612105422', '1446-12-15', '1.100.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '20000', '0', 'Chuwez', '2025-06-12 17:54:22'),
('5858', 'ST10100320250612105422', '1446-12-15', '2.220.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '0', '20000', 'Chuwez', '2025-06-12 17:54:22'),
('5859', 'ST10100320250612105436', '1446-12-15', '1.100.10', '101', 'an.SITI ATHIUR ROHMAH', '5000', '0', 'Chuwez', '2025-06-12 17:54:36'),
('5860', 'ST10100320250612105436', '1446-12-15', '2.220.10', '101', 'an.SITI ATHIUR ROHMAH', '0', '5000', 'Chuwez', '2025-06-12 17:54:36'),
('5861', 'ST10100320250612105449', '1446-12-15', '1.100.10', '101', 'an.ABDUL HAMID', '5000', '0', 'Chuwez', '2025-06-12 17:54:49'),
('5862', 'ST10100320250612105449', '1446-12-15', '2.220.10', '101', 'an.ABDUL HAMID', '0', '5000', 'Chuwez', '2025-06-12 17:54:49'),
('5863', 'ST10100320250612105504', '1446-12-15', '1.100.10', '101', 'an.WARDATUL JANNAH', '2000', '0', 'Chuwez', '2025-06-12 17:55:04'),
('5864', 'ST10100320250612105504', '1446-12-15', '2.220.10', '101', 'an.WARDATUL JANNAH', '0', '2000', 'Chuwez', '2025-06-12 17:55:04'),
('5865', 'ST10100320250612105519', '1446-12-15', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '7000', '0', 'Chuwez', '2025-06-12 17:55:19'),
('5866', 'ST10100320250612105519', '1446-12-15', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '7000', 'Chuwez', '2025-06-12 17:55:19'),
('5867', 'ST10100320250612105531', '1446-12-15', '1.100.10', '101', 'an.NABILATUN NISAUL UMMAH', '20000', '0', 'Chuwez', '2025-06-12 17:55:31'),
('5868', 'ST10100320250612105531', '1446-12-15', '2.220.10', '101', 'an.NABILATUN NISAUL UMMAH', '0', '20000', 'Chuwez', '2025-06-12 17:55:31'),
('5869', 'ST10100320250612105541', '1446-12-15', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '10000', '0', 'Chuwez', '2025-06-12 17:55:41'),
('5870', 'ST10100320250612105541', '1446-12-15', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '10000', 'Chuwez', '2025-06-12 17:55:41'),
('5871', 'ST10100320250612105600', '1446-12-15', '1.100.10', '101', 'an.M. KAMALUDDIN', '10000', '0', 'Chuwez', '2025-06-12 17:56:00'),
('5872', 'ST10100320250612105600', '1446-12-15', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '10000', 'Chuwez', '2025-06-12 17:56:00'),
('5873', 'ST10100320250612105614', '1446-12-15', '1.100.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '10000', '0', 'Chuwez', '2025-06-12 17:56:14'),
('5874', 'ST10100320250612105614', '1446-12-15', '2.220.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '0', '10000', 'Chuwez', '2025-06-12 17:56:14'),
('5875', 'ST10100320250612105629', '1446-12-15', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '2000', '0', 'Chuwez', '2025-06-12 17:56:29'),
('5876', 'ST10100320250612105629', '1446-12-15', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '2000', 'Chuwez', '2025-06-12 17:56:29'),
('5877', 'ST10100320250612105651', '1446-12-15', '1.100.10', '101', 'an.MIFTAHUL JANNAH', '50000', '0', 'Chuwez', '2025-06-12 17:56:51'),
('5878', 'ST10100320250612105651', '1446-12-15', '2.220.10', '101', 'an.MIFTAHUL JANNAH', '0', '50000', 'Chuwez', '2025-06-12 17:56:51'),
('5879', 'ST10100320250612105701', '1446-12-15', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Chuwez', '2025-06-12 17:57:01'),
('5880', 'ST10100320250612105701', '1446-12-15', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Chuwez', '2025-06-12 17:57:01'),
('5881', 'ST10100320250612105712', '1446-12-15', '1.100.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '20000', '0', 'Chuwez', '2025-06-12 17:57:12'),
('5882', 'ST10100320250612105712', '1446-12-15', '2.220.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '0', '20000', 'Chuwez', '2025-06-12 17:57:12'),
('5883', 'ST10100320250612105724', '1446-12-15', '1.100.10', '101', 'an.M. HAIKAL NASRULLOH', '5000', '0', 'Chuwez', '2025-06-12 17:57:24'),
('5884', 'ST10100320250612105724', '1446-12-15', '2.220.10', '101', 'an.M. HAIKAL NASRULLOH', '0', '5000', 'Chuwez', '2025-06-12 17:57:24'),
('5885', 'ST10100320250612105741', '1446-12-15', '1.100.10', '101', 'an.AHMAD ABBAS MAULANA', '3000', '0', 'Chuwez', '2025-06-12 17:57:41'),
('5886', 'ST10100320250612105741', '1446-12-15', '2.220.10', '101', 'an.AHMAD ABBAS MAULANA', '0', '3000', 'Chuwez', '2025-06-12 17:57:41'),
('5887', 'ST10100320250612105805', '1446-12-15', '1.100.10', '101', 'an.AKHMAD FIKRI HAIKAL', '100000', '0', 'Chuwez', '2025-06-12 17:58:05'),
('5888', 'ST10100320250612105805', '1446-12-15', '2.220.10', '101', 'an.AKHMAD FIKRI HAIKAL', '0', '100000', 'Chuwez', '2025-06-12 17:58:05'),
('5889', 'ST10100320250612105823', '1446-12-15', '1.100.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '10000', '0', 'Chuwez', '2025-06-12 17:58:23'),
('5890', 'ST10100320250612105823', '1446-12-15', '2.220.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '0', '10000', 'Chuwez', '2025-06-12 17:58:23'),
('5891', 'ST10100320250612105837', '1446-12-15', '1.100.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '5000', '0', 'Chuwez', '2025-06-12 17:58:37'),
('5892', 'ST10100320250612105837', '1446-12-15', '2.220.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '0', '5000', 'Chuwez', '2025-06-12 17:58:37'),
('5893', 'ST10100320250612105849', '1446-12-15', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '25000', '0', 'Chuwez', '2025-06-12 17:58:49'),
('5894', 'ST10100320250612105849', '1446-12-15', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '25000', 'Chuwez', '2025-06-12 17:58:49'),
('5895', 'ST10100320250612105901', '1446-12-15', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '5000', '0', 'Chuwez', '2025-06-12 17:59:01'),
('5896', 'ST10100320250612105901', '1446-12-15', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '5000', 'Chuwez', '2025-06-12 17:59:01'),
('5897', 'ST10100320250612105917', '1446-12-15', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '2000', '0', 'Chuwez', '2025-06-12 17:59:17'),
('5898', 'ST10100320250612105917', '1446-12-15', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '2000', 'Chuwez', '2025-06-12 17:59:17'),
('5899', 'ST10100320250612105930', '1446-12-15', '1.100.10', '101', 'an.ZAKIYATUL UMMAH', '2000', '0', 'Chuwez', '2025-06-12 17:59:30'),
('5900', 'ST10100320250612105930', '1446-12-15', '2.220.10', '101', 'an.ZAKIYATUL UMMAH', '0', '2000', 'Chuwez', '2025-06-12 17:59:30'),
('5901', 'ST10100320250612105948', '1446-12-15', '1.100.10', '101', 'an.ANA SALSABILA', '5000', '0', 'Chuwez', '2025-06-12 17:59:48'),
('5902', 'ST10100320250612105948', '1446-12-15', '2.220.10', '101', 'an.ANA SALSABILA', '0', '5000', 'Chuwez', '2025-06-12 17:59:48'),
('5903', 'ST10100320250612110002', '1446-12-15', '1.100.10', '101', 'an.M. ALIFIN FIKRI', '5000', '0', 'Chuwez', '2025-06-12 18:00:02'),
('5904', 'ST10100320250612110002', '1446-12-15', '2.220.10', '101', 'an.M. ALIFIN FIKRI', '0', '5000', 'Chuwez', '2025-06-12 18:00:12'),
('5905', 'ST10100320250612110030', '1446-12-15', '1.100.10', '101', 'an.SAFIRATUL JANNAH', '20000', '0', 'Chuwez', '2025-06-12 18:00:30'),
('5906', 'ST10100320250612110030', '1446-12-15', '2.220.10', '101', 'an.SAFIRATUL JANNAH', '0', '20000', 'Chuwez', '2025-06-12 18:00:30'),
('5907', 'ST10100320250612110047', '1446-12-15', '1.100.10', '101', 'an.M. ZIDAN RIZQI SALIM', '10000', '0', 'Chuwez', '2025-06-12 18:00:47'),
('5908', 'ST10100320250612110047', '1446-12-15', '2.220.10', '101', 'an.M. ZIDAN RIZQI SALIM', '0', '10000', 'Chuwez', '2025-06-12 18:00:47'),
('5909', 'ST10100320250612110103', '1446-12-15', '1.100.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '2000', '0', 'Chuwez', '2025-06-12 18:01:03'),
('5910', 'ST10100320250612110103', '1446-12-15', '2.220.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '0', '2000', 'Chuwez', '2025-06-12 18:01:03'),
('5911', 'ST10100320250612110117', '1446-12-15', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '10000', '0', 'Chuwez', '2025-06-12 18:01:17'),
('5912', 'ST10100320250612110117', '1446-12-15', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '10000', 'Chuwez', '2025-06-12 18:01:17'),
('5913', 'ST10100320250612110147', '1446-12-15', '1.100.10', '101', 'an.HILYA', '30000', '0', 'Chuwez', '2025-06-12 18:01:47'),
('5914', 'ST10100320250612110147', '1446-12-15', '2.220.10', '101', 'an.HILYA', '0', '30000', 'Chuwez', '2025-06-12 18:01:47'),
('5915', 'ST10100320250612110206', '1446-12-15', '1.100.10', '101', 'an.MACHMUDAH', '10000', '0', 'Chuwez', '2025-06-12 18:02:06'),
('5916', 'ST10100320250612110206', '1446-12-15', '2.220.10', '101', 'an.MACHMUDAH', '0', '10000', 'Chuwez', '2025-06-12 18:02:06'),
('5917', 'ST10100320250612110226', '1446-12-15', '1.100.10', '101', 'an.HALIMAH', '5000', '0', 'Chuwez', '2025-06-12 18:02:26'),
('5918', 'ST10100320250612110226', '1446-12-15', '2.220.10', '101', 'an.HALIMAH', '0', '5000', 'Chuwez', '2025-06-12 18:02:26'),
('5919', 'ST10100320250612110243', '1446-12-15', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'Chuwez', '2025-06-12 18:02:43'),
('5920', 'ST10100320250612110243', '1446-12-15', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'Chuwez', '2025-06-12 18:02:44'),
('5921', 'BS10100320250612110311000', '1446-12-15', '1.100.10', '101', 'Bayar[DIYANAH KAMALIYAH]', '30000', '0', 'Chuwez', '2025-06-12 11:03:11'),
('5922', 'BS10100320250612110311000', '1446-12-15', '4.400.20', '101', 'Bayar[DIYANAH KAMALIYAH]', '0', '30000', 'Chuwez', '2025-06-12 11:03:11'),
('5923', 'KK10100320250615143928', '1446-12-18', '5.520.42', '101', 'Nasi kumpulan, peyek, kacang', '90000', '0', 'Chuwez', '2025-06-15 07:40:27'),
('5924', 'KK10100320250615143928', '1446-12-18', '1.100.10', '101', 'Nasi kumpulan, peyek, kacang', '0', '90000', 'Chuwez', '2025-06-15 07:40:27'),
('5925', 'BS10100320250615074130000', '1446-11-18', '1.100.10', '101', 'Bayar[PUTRI MAULIDATUL IMANIA]', '30000', '0', 'Chuwez', '2025-06-15 07:41:30'),
('5926', 'BS10100320250615074130000', '1446-11-18', '4.400.20', '101', 'Bayar[PUTRI MAULIDATUL IMANIA]', '0', '30000', 'Chuwez', '2025-06-15 07:41:30'),
('5927', 'BS10100320250615074130001', '1446-12-18', '1.100.10', '101', 'Bayar[PUTRI MAULIDATUL IMANIA]', '30000', '0', 'Chuwez', '2025-06-15 07:41:30'),
('5928', 'BS10100320250615074130001', '1446-12-18', '4.400.20', '101', 'Bayar[PUTRI MAULIDATUL IMANIA]', '0', '30000', 'Chuwez', '2025-06-15 07:41:30'),
('5929', 'BS10100320250615074233000', '1446-10-18', '1.100.10', '101', 'Bayar[MUHAMMAD ABD. MANNAN ROSYID]', '30000', '0', 'Chuwez', '2025-06-15 07:42:33'),
('5930', 'BS10100320250615074233000', '1446-10-18', '4.400.20', '101', 'Bayar[MUHAMMAD ABD. MANNAN ROSYID]', '0', '30000', 'Chuwez', '2025-06-15 07:42:33'),
('5931', 'BS10100320250615074233001', '1446-11-18', '1.100.10', '101', 'Bayar[MUHAMMAD ABD. MANNAN ROSYID]', '30000', '0', 'Chuwez', '2025-06-15 07:42:33'),
('5932', 'BS10100320250615074233001', '1446-11-18', '4.400.20', '101', 'Bayar[MUHAMMAD ABD. MANNAN ROSYID]', '0', '30000', 'Chuwez', '2025-06-15 07:42:33'),
('5933', 'BS10100320250615074313000', '1446-11-18', '1.100.10', '101', 'Bayar[MUHAMMAD ISMAIL]', '30000', '0', 'Chuwez', '2025-06-15 07:43:13'),
('5934', 'BS10100320250615074313000', '1446-11-18', '4.400.20', '101', 'Bayar[MUHAMMAD ISMAIL]', '0', '30000', 'Chuwez', '2025-06-15 07:43:13'),
('5935', 'BS10100320250615074313001', '1446-12-18', '1.100.10', '101', 'Bayar[MUHAMMAD ISMAIL]', '30000', '0', 'Chuwez', '2025-06-15 07:43:13'),
('5936', 'BS10100320250615074313001', '1446-12-18', '4.400.20', '101', 'Bayar[MUHAMMAD ISMAIL]', '0', '30000', 'Chuwez', '2025-06-15 07:43:13'),
('5937', 'BS10100320250615074434000', '1446-11-18', '1.100.10', '101', 'Bayar[RENI FARIDA]', '30000', '0', 'Chuwez', '2025-06-15 07:44:34'),
('5938', 'BS10100320250615074434000', '1446-11-18', '4.400.20', '101', 'Bayar[RENI FARIDA]', '0', '30000', 'Chuwez', '2025-06-15 07:44:34'),
('5939', 'ST10100320250615074818', '1446-12-18', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '15000', '0', 'Chuwez', '2025-06-15 14:48:18'),
('5940', 'ST10100320250615074818', '1446-12-18', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '15000', 'Chuwez', '2025-06-15 14:48:18'),
('5941', 'ST10100320250615074833', '1446-12-18', '1.100.10', '101', 'an.HAIKAL SHOMADANI', '2000', '0', 'Chuwez', '2025-06-15 14:48:33'),
('5942', 'ST10100320250615074833', '1446-12-18', '2.220.10', '101', 'an.HAIKAL SHOMADANI', '0', '2000', 'Chuwez', '2025-06-15 14:48:33'),
('5945', 'ST10100320250615074906', '1446-12-18', '1.100.10', '101', 'an.AULIA AZZAHRA', '20000', '0', 'Chuwez', '2025-06-15 14:49:06'),
('5946', 'ST10100320250615074906', '1446-12-18', '2.220.10', '101', 'an.AULIA AZZAHRA', '0', '20000', 'Chuwez', '2025-06-15 14:49:06'),
('5947', 'ST10100320250615074932', '1446-12-18', '1.100.10', '101', 'an.M. ABD. HADI', '4000', '0', 'Chuwez', '2025-06-15 14:49:32'),
('5948', 'ST10100320250615074932', '1446-12-18', '2.220.10', '101', 'an.M. ABD. HADI', '0', '4000', 'Chuwez', '2025-06-15 14:49:32'),
('5949', 'ST10100320250615074949', '1446-12-18', '1.100.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '5000', '0', 'Chuwez', '2025-06-15 14:49:49'),
('5950', 'ST10100320250615074949', '1446-12-18', '2.220.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '0', '5000', 'Chuwez', '2025-06-15 14:49:49'),
('5951', 'ST10100320250615075006', '1446-12-18', '1.100.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '20000', '0', 'Chuwez', '2025-06-15 14:50:06'),
('5952', 'ST10100320250615075006', '1446-12-18', '2.220.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '0', '20000', 'Chuwez', '2025-06-15 14:50:06'),
('5953', 'ST10100320250615075028', '1446-12-18', '1.100.10', '101', 'an.SALWA LAILI', '10000', '0', 'Chuwez', '2025-06-15 14:50:28'),
('5954', 'ST10100320250615075028', '1446-12-18', '2.220.10', '101', 'an.SALWA LAILI', '0', '10000', 'Chuwez', '2025-06-15 14:50:28'),
('5955', 'ST10100320250615075048', '1446-12-18', '1.100.10', '101', 'an.SITI SHOFIYAH LABIBAH', '20000', '0', 'Chuwez', '2025-06-15 14:50:48'),
('5956', 'ST10100320250615075048', '1446-12-18', '2.220.10', '101', 'an.SITI SHOFIYAH LABIBAH', '0', '20000', 'Chuwez', '2025-06-15 14:50:48'),
('5957', 'ST10100320250615075102', '1446-12-18', '1.100.10', '101', 'an.NAURA BILADINA', '20000', '0', 'Chuwez', '2025-06-15 14:51:02'),
('5958', 'ST10100320250615075102', '1446-12-18', '2.220.10', '101', 'an.NAURA BILADINA', '0', '20000', 'Chuwez', '2025-06-15 14:51:02'),
('5959', 'ST10100320250615080444', '1446-12-18', '1.100.10', '101', 'an.MUHAMMAD ALWI', '30000', '0', 'Chuwez', '2025-06-15 15:04:44'),
('5960', 'ST10100320250615080444', '1446-12-18', '2.220.10', '101', 'an.MUHAMMAD ALWI', '0', '30000', 'Chuwez', '2025-06-15 15:04:44'),
('5961', 'ST10100320250615080501', '1446-12-18', '1.100.10', '101', 'an.NAILATUN NIAMI', '10000', '0', 'Chuwez', '2025-06-15 15:05:01'),
('5962', 'ST10100320250615080501', '1446-12-18', '2.220.10', '101', 'an.NAILATUN NIAMI', '0', '10000', 'Chuwez', '2025-06-15 15:05:01'),
('5963', 'ST10100320250615080523', '1446-12-18', '1.100.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '10000', '0', 'Chuwez', '2025-06-15 15:05:23'),
('5964', 'ST10100320250615080523', '1446-12-18', '2.220.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '0', '10000', 'Chuwez', '2025-06-15 15:05:23'),
('5965', 'ST10100320250615080538', '1446-12-18', '1.100.10', '101', 'an.M. ABDIL ARIKIN', '10000', '0', 'Chuwez', '2025-06-15 15:05:38'),
('5966', 'ST10100320250615080538', '1446-12-18', '2.220.10', '101', 'an.M. ABDIL ARIKIN', '0', '10000', 'Chuwez', '2025-06-15 15:05:38'),
('5967', 'ST10100320250615080604', '1446-12-18', '1.100.10', '101', 'an.RAISA ANNISA', '10000', '0', 'Chuwez', '2025-06-15 15:06:04'),
('5968', 'ST10100320250615080604', '1446-12-18', '2.220.10', '101', 'an.RAISA ANNISA', '0', '10000', 'Chuwez', '2025-06-15 15:06:04'),
('5969', 'ST10100320250615080624', '1446-12-18', '1.100.10', '101', 'an.MARIATUL QIBTIYAH', '4000', '0', 'Chuwez', '2025-06-15 15:06:24'),
('5970', 'ST10100320250615080624', '1446-12-18', '2.220.10', '101', 'an.MARIATUL QIBTIYAH', '0', '4000', 'Chuwez', '2025-06-15 15:06:24'),
('5971', 'ST10100320250615080641', '1446-12-18', '1.100.10', '101', 'an.FAIZAH NURUL LITA', '5000', '0', 'Chuwez', '2025-06-15 15:06:41'),
('5972', 'ST10100320250615080641', '1446-12-18', '2.220.10', '101', 'an.FAIZAH NURUL LITA', '0', '5000', 'Chuwez', '2025-06-15 15:06:41'),
('5973', 'ST10100320250615080702', '1446-12-18', '1.100.10', '101', 'an.UBAIDAH', '30000', '0', 'Chuwez', '2025-06-15 15:07:02'),
('5974', 'ST10100320250615080702', '1446-12-18', '2.220.10', '101', 'an.UBAIDAH', '0', '30000', 'Chuwez', '2025-06-15 15:07:02'),
('5975', 'ST10100320250615080740', '1446-12-18', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '20000', '0', 'Chuwez', '2025-06-15 15:07:40'),
('5976', 'ST10100320250615080740', '1446-12-18', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '20000', 'Chuwez', '2025-06-15 15:07:40'),
('5977', 'ST10100320250615080801', '1446-12-18', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '10000', '0', 'Chuwez', '2025-06-15 15:08:01'),
('5978', 'ST10100320250615080801', '1446-12-18', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '10000', 'Chuwez', '2025-06-15 15:08:01'),
('5979', 'ST10100320250615080819', '1446-12-18', '1.100.10', '101', 'an.ABDULLOH BAHAR', '2000', '0', 'Chuwez', '2025-06-15 15:08:19'),
('5980', 'ST10100320250615080819', '1446-12-18', '2.220.10', '101', 'an.ABDULLOH BAHAR', '0', '2000', 'Chuwez', '2025-06-15 15:08:19'),
('5981', 'ST10100320250615080907', '1446-12-18', '1.100.10', '101', 'an.LAILATUL MAGHFIROH', '5000', '0', 'Chuwez', '2025-06-15 15:09:07'),
('5982', 'ST10100320250615080907', '1446-12-18', '2.220.10', '101', 'an.LAILATUL MAGHFIROH', '0', '5000', 'Chuwez', '2025-06-15 15:09:07'),
('5983', 'ST10100320250615080923', '1446-12-18', '1.100.10', '101', 'an.AZKA AUFARIL MINAN', '20000', '0', 'Chuwez', '2025-06-15 15:09:23'),
('5984', 'ST10100320250615080923', '1446-12-18', '2.220.10', '101', 'an.AZKA AUFARIL MINAN', '0', '20000', 'Chuwez', '2025-06-15 15:09:23'),
('5985', 'ST10100320250615080948', '1446-12-18', '1.100.10', '101', 'an.MASRUROTUL MAULUDIYAH', '10000', '0', 'Chuwez', '2025-06-15 15:09:48'),
('5986', 'ST10100320250615080948', '1446-12-18', '2.220.10', '101', 'an.MASRUROTUL MAULUDIYAH', '0', '10000', 'Chuwez', '2025-06-15 15:09:48'),
('5987', 'ST10100320250615081010', '1446-12-18', '1.100.10', '101', 'an.IFTITAHUL IZZA', '100000', '0', 'Chuwez', '2025-06-15 15:10:10'),
('5988', 'ST10100320250615081010', '1446-12-18', '2.220.10', '101', 'an.IFTITAHUL IZZA', '0', '100000', 'Chuwez', '2025-06-15 15:10:10'),
('5989', 'ST10100320250615081028', '1446-12-18', '1.100.10', '101', 'an.AHMAD ADITIYA', '2000', '0', 'Chuwez', '2025-06-15 15:10:28'),
('5990', 'ST10100320250615081028', '1446-12-18', '2.220.10', '101', 'an.AHMAD ADITIYA', '0', '2000', 'Chuwez', '2025-06-15 15:10:28'),
('5991', 'ST10100320250615081044', '1446-12-18', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '15000', '0', 'Chuwez', '2025-06-15 15:10:44'),
('5992', 'ST10100320250615081044', '1446-12-18', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '15000', 'Chuwez', '2025-06-15 15:10:44'),
('5993', 'ST10100320250615081101', '1446-12-18', '1.100.10', '101', 'an.AISYAH', '10000', '0', 'Chuwez', '2025-06-15 15:11:01'),
('5994', 'ST10100320250615081101', '1446-12-18', '2.220.10', '101', 'an.AISYAH', '0', '10000', 'Chuwez', '2025-06-15 15:11:01'),
('5995', 'ST10100320250615081119', '1446-12-18', '1.100.10', '101', 'an.ALFI NURDIANA', '7000', '0', 'Chuwez', '2025-06-15 15:11:19'),
('5996', 'ST10100320250615081119', '1446-12-18', '2.220.10', '101', 'an.ALFI NURDIANA', '0', '7000', 'Chuwez', '2025-06-15 15:11:19'),
('5997', 'ST10100320250615081148', '1446-12-18', '1.100.10', '101', 'an.AHMAD NUR HASAN ROMADHONI', '12000', '0', 'Chuwez', '2025-06-15 15:11:48'),
('5998', 'ST10100320250615081148', '1446-12-18', '2.220.10', '101', 'an.AHMAD NUR HASAN ROMADHONI', '0', '12000', 'Chuwez', '2025-06-15 15:11:48'),
('5999', 'ST10100320250615081226', '1446-12-18', '1.100.10', '101', 'an.SITI ATHIUR ROHMAH', '5000', '0', 'Chuwez', '2025-06-15 15:12:26'),
('6000', 'ST10100320250615081226', '1446-12-18', '2.220.10', '101', 'an.SITI ATHIUR ROHMAH', '0', '5000', 'Chuwez', '2025-06-15 15:12:26'),
('6001', 'ST10100320250615081244', '1446-12-18', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '20000', '0', 'Chuwez', '2025-06-15 15:12:44'),
('6002', 'ST10100320250615081244', '1446-12-18', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '20000', 'Chuwez', '2025-06-15 15:12:44'),
('6003', 'ST10100320250615081302', '1446-12-18', '1.100.10', '101', 'an.M. FAHMI NURUL ANAM', '10000', '0', 'Chuwez', '2025-06-15 15:13:02'),
('6004', 'ST10100320250615081302', '1446-12-18', '2.220.10', '101', 'an.M. FAHMI NURUL ANAM', '0', '10000', 'Chuwez', '2025-06-15 15:13:02'),
('6005', 'ST10100320250615081321', '1446-12-18', '1.100.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '20000', '0', 'Chuwez', '2025-06-15 15:13:21'),
('6006', 'ST10100320250615081321', '1446-12-18', '2.220.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '0', '20000', 'Chuwez', '2025-06-15 15:13:21'),
('6007', 'ST10100320250615081336', '1446-12-18', '1.100.10', '101', 'an.WARDATUL JANNAH', '4000', '0', 'Chuwez', '2025-06-15 15:13:36'),
('6008', 'ST10100320250615081336', '1446-12-18', '2.220.10', '101', 'an.WARDATUL JANNAH', '0', '4000', 'Chuwez', '2025-06-15 15:13:36'),
('6009', 'ST10100320250615081351', '1446-12-18', '1.100.10', '101', 'an.KHOIRIYAH', '5000', '0', 'Chuwez', '2025-06-15 15:13:51'),
('6010', 'ST10100320250615081351', '1446-12-18', '2.220.10', '101', 'an.KHOIRIYAH', '0', '5000', 'Chuwez', '2025-06-15 15:13:51'),
('6011', 'ST10100320250615081406', '1446-12-18', '1.100.10', '101', 'an.SITI QURROTUL AINI', '4000', '0', 'Chuwez', '2025-06-15 15:14:06'),
('6012', 'ST10100320250615081406', '1446-12-18', '2.220.10', '101', 'an.SITI QURROTUL AINI', '0', '4000', 'Chuwez', '2025-06-15 15:14:06'),
('6013', 'ST10100320250615081438', '1446-12-18', '1.100.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '30000', '0', 'Chuwez', '2025-06-15 15:14:38'),
('6014', 'ST10100320250615081438', '1446-12-18', '2.220.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '0', '30000', 'Chuwez', '2025-06-15 15:14:38'),
('6015', 'ST10100320250615081453', '1446-12-18', '1.100.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '10000', '0', 'Chuwez', '2025-06-15 15:14:53'),
('6016', 'ST10100320250615081453', '1446-12-18', '2.220.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '0', '10000', 'Chuwez', '2025-06-15 15:14:53'),
('6017', 'ST10100320250615081510', '1446-12-18', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '20000', '0', 'Chuwez', '2025-06-15 15:15:10'),
('6018', 'ST10100320250615081510', '1446-12-18', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '20000', 'Chuwez', '2025-06-15 15:15:10'),
('6019', 'ST10100320250615081526', '1446-12-18', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '10000', '0', 'Chuwez', '2025-06-15 15:15:26'),
('6020', 'ST10100320250615081526', '1446-12-18', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '10000', 'Chuwez', '2025-06-15 15:15:26'),
('6021', 'ST10100320250615081545', '1446-12-18', '1.100.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '5000', '0', 'Chuwez', '2025-06-15 15:15:45'),
('6022', 'ST10100320250615081545', '1446-12-18', '2.220.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '0', '5000', 'Chuwez', '2025-06-15 15:15:45'),
('6023', 'ST10100320250615081600', '1446-12-18', '1.100.10', '101', 'an.MIFTAHUL JANNAH', '50000', '0', 'Chuwez', '2025-06-15 15:16:00'),
('6024', 'ST10100320250615081600', '1446-12-18', '2.220.10', '101', 'an.MIFTAHUL JANNAH', '0', '50000', 'Chuwez', '2025-06-15 15:16:00'),
('6025', 'ST10100320250615081615', '1446-12-18', '1.100.10', '101', 'an.NABILATUN NISAUL UMMAH', '20000', '0', 'Chuwez', '2025-06-15 15:16:15'),
('6026', 'ST10100320250615081615', '1446-12-18', '2.220.10', '101', 'an.NABILATUN NISAUL UMMAH', '0', '20000', 'Chuwez', '2025-06-15 15:16:15'),
('6027', 'ST10100320250615081633', '1446-12-18', '1.100.10', '101', 'an.NIKMATUL MAULIDAH', '5000', '0', 'Chuwez', '2025-06-15 15:16:33'),
('6028', 'ST10100320250615081633', '1446-12-18', '2.220.10', '101', 'an.NIKMATUL MAULIDAH', '0', '5000', 'Chuwez', '2025-06-15 15:16:33'),
('6029', 'ST10100320250615081652', '1446-12-18', '1.100.10', '101', 'an.M. KAMALUDDIN', '20000', '0', 'Chuwez', '2025-06-15 15:16:52'),
('6030', 'ST10100320250615081652', '1446-12-18', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '20000', 'Chuwez', '2025-06-15 15:16:52'),
('6031', 'ST10100320250615081720', '1446-12-18', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '20000', '0', 'Chuwez', '2025-06-15 15:17:20'),
('6032', 'ST10100320250615081720', '1446-12-18', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '20000', 'Chuwez', '2025-06-15 15:17:20'),
('6033', 'D110100320250615081847', '1446-12-18', '1.100.10', '101', 'Bayar[NUR HIDAYATULLOH]', '35000', '0', 'Chuwez', '2025-06-15 08:18:47'),
('6034', 'D110100320250615081847', '1446-12-18', '4.400.22', '101', 'Bayar[NUR HIDAYATULLOH]', '0', '35000', 'Chuwez', '2025-06-15 08:18:47'),
('6035', 'ST10100320250615082114', '1446-12-18', '1.100.10', '101', 'an.AHMAD ABBAS MAULANA', '3000', '0', 'Chuwez', '2025-06-15 15:21:14'),
('6036', 'ST10100320250615082114', '1446-12-18', '2.220.10', '101', 'an.AHMAD ABBAS MAULANA', '0', '3000', 'Chuwez', '2025-06-15 15:21:14'),
('6037', 'ST10100320250615082137', '1446-12-18', '1.100.10', '101', 'an.AKHMAD FIKRI HAIKAL', '100000', '0', 'Chuwez', '2025-06-15 15:21:37'),
('6038', 'ST10100320250615082137', '1446-12-18', '2.220.10', '101', 'an.AKHMAD FIKRI HAIKAL', '0', '100000', 'Chuwez', '2025-06-15 15:21:37'),
('6039', 'ST10100320250615082158', '1446-12-18', '1.100.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '20000', '0', 'Chuwez', '2025-06-15 15:21:58'),
('6040', 'ST10100320250615082158', '1446-12-18', '2.220.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '0', '20000', 'Chuwez', '2025-06-15 15:21:58'),
('6041', 'ST10100320250615082226', '1446-12-18', '1.100.10', '101', 'an.BILQIS THALIA HASNA', '250000', '0', 'Chuwez', '2025-06-15 15:22:26'),
('6042', 'ST10100320250615082226', '1446-12-18', '2.220.10', '101', 'an.BILQIS THALIA HASNA', '0', '250000', 'Chuwez', '2025-06-15 15:22:26'),
('6043', 'ST10100320250615082244', '1446-12-18', '1.100.10', '101', 'an.M. HAIKAL NASRULLOH', '5000', '0', 'Chuwez', '2025-06-15 15:22:44'),
('6044', 'ST10100320250615082244', '1446-12-18', '2.220.10', '101', 'an.M. HAIKAL NASRULLOH', '0', '5000', 'Chuwez', '2025-06-15 15:22:44'),
('6045', 'ST10100320250615082313', '1446-12-18', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '50000', '0', 'Chuwez', '2025-06-15 15:23:13'),
('6046', 'ST10100320250615082313', '1446-12-18', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '50000', 'Chuwez', '2025-06-15 15:23:13'),
('6047', 'ST10100320250615082339', '1446-12-18', '1.100.10', '101', 'an.AHMAD JAMALUL MAIMUN', '5000', '0', 'Chuwez', '2025-06-15 15:23:39'),
('6048', 'ST10100320250615082339', '1446-12-18', '2.220.10', '101', 'an.AHMAD JAMALUL MAIMUN', '0', '5000', 'Chuwez', '2025-06-15 15:23:39'),
('6049', 'ST10100320250615082428', '1446-12-18', '1.100.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '10000', '0', 'Chuwez', '2025-06-15 15:24:28'),
('6050', 'ST10100320250615082428', '1446-12-18', '2.220.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '0', '10000', 'Chuwez', '2025-06-15 15:24:28'),
('6051', 'ST10100320250615082543', '1446-12-18', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '15000', '0', 'Chuwez', '2025-06-15 15:25:43'),
('6052', 'ST10100320250615082543', '1446-12-18', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '15000', 'Chuwez', '2025-06-15 15:25:43'),
('6053', 'ST10100320250615082556', '1446-12-18', '1.100.10', '101', 'an.M. ALIFIN FIKRI', '4000', '0', 'Chuwez', '2025-06-15 15:25:56'),
('6054', 'ST10100320250615082556', '1446-12-18', '2.220.10', '101', 'an.M. ALIFIN FIKRI', '0', '4000', 'Chuwez', '2025-06-15 15:25:56'),
('6055', 'ST10100320250615082612', '1446-12-18', '1.100.10', '101', 'an.ANA SALSABILA', '10000', '0', 'Chuwez', '2025-06-15 15:26:12'),
('6056', 'ST10100320250615082612', '1446-12-18', '2.220.10', '101', 'an.ANA SALSABILA', '0', '10000', 'Chuwez', '2025-06-15 15:26:12'),
('6057', 'ST10100320250615082634', '1446-12-18', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '10000', '0', 'Chuwez', '2025-06-15 15:26:34'),
('6058', 'ST10100320250615082634', '1446-12-18', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '10000', 'Chuwez', '2025-06-15 15:26:34'),
('6059', 'ST10100320250615082649', '1446-12-18', '1.100.10', '101', 'an.ZAKIYATUL UMMAH', '2000', '0', 'Chuwez', '2025-06-15 15:26:49'),
('6060', 'ST10100320250615082649', '1446-12-18', '2.220.10', '101', 'an.ZAKIYATUL UMMAH', '0', '2000', 'Chuwez', '2025-06-15 15:26:49'),
('6061', 'ST10100320250615082709', '1446-12-18', '1.100.10', '101', 'an.AFANDI', '4000', '0', 'Chuwez', '2025-06-15 15:27:09'),
('6062', 'ST10100320250615082709', '1446-12-18', '2.220.10', '101', 'an.AFANDI', '0', '4000', 'Chuwez', '2025-06-15 15:27:09'),
('6063', 'ST10100320250615082723', '1446-12-18', '1.100.10', '101', 'an.MUHAMMAD KHOIRON', '7000', '0', 'Chuwez', '2025-06-15 15:27:23'),
('6064', 'ST10100320250615082723', '1446-12-18', '2.220.10', '101', 'an.MUHAMMAD KHOIRON', '0', '7000', 'Chuwez', '2025-06-15 15:27:23'),
('6065', 'ST10100320250615082744', '1446-12-18', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '10000', '0', 'Chuwez', '2025-06-15 15:27:44'),
('6066', 'ST10100320250615082744', '1446-12-18', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '10000', 'Chuwez', '2025-06-15 15:27:44'),
('6067', 'ST10100320250615082804', '1446-12-18', '1.100.10', '101', 'an.SAFIRATUL JANNAH', '20000', '0', 'Chuwez', '2025-06-15 15:28:04'),
('6068', 'ST10100320250615082804', '1446-12-18', '2.220.10', '101', 'an.SAFIRATUL JANNAH', '0', '20000', 'Chuwez', '2025-06-15 15:28:04'),
('6069', 'ST10100320250615082824', '1446-12-18', '1.100.10', '101', 'an.ALFIN HIDAYAT', '12000', '0', 'Chuwez', '2025-06-15 15:28:24'),
('6070', 'ST10100320250615082824', '1446-12-18', '2.220.10', '101', 'an.ALFIN HIDAYAT', '0', '12000', 'Chuwez', '2025-06-15 15:28:24'),
('6071', 'ST10100320250615082854', '1446-12-18', '1.100.10', '101', 'an.UST THORIQUL HUDA', '100000', '0', 'Chuwez', '2025-06-15 15:28:54'),
('6072', 'ST10100320250615082854', '1446-12-18', '2.220.10', '101', 'an.UST THORIQUL HUDA', '0', '100000', 'Chuwez', '2025-06-15 15:28:54'),
('6073', 'ST10100320250615082924', '1446-12-18', '1.100.10', '101', 'an.HILYA', '70000', '0', 'Chuwez', '2025-06-15 15:29:24'),
('6074', 'ST10100320250615082924', '1446-12-18', '2.220.10', '101', 'an.HILYA', '0', '70000', 'Chuwez', '2025-06-15 15:29:24'),
('6075', 'ST10100320250615083013', '1446-12-18', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '40000', '0', 'Chuwez', '2025-06-15 15:30:13'),
('6076', 'ST10100320250615083013', '1446-12-18', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '40000', 'Chuwez', '2025-06-15 15:30:13'),
('6077', 'ST10100320250615074845', '1446-12-18', '1.100.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '10000', '0', 'Chuwez', '2025-06-15 15:31:16'),
('6078', 'ST10100320250615074845', '1446-12-18', '2.220.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '0', '10000', 'Chuwez', '2025-06-15 15:31:16'),
('6079', 'D110100320250615083150', '1446-12-18', '1.100.10', '101', 'Bayar[MOCHAMMAD TAUFIK ALI KURNIAWAN]', '20000', '0', 'Chuwez', '2025-06-15 08:31:50'),
('6080', 'D110100320250615083150', '1446-12-18', '4.400.22', '101', 'Bayar[MOCHAMMAD TAUFIK ALI KURNIAWAN]', '0', '20000', 'Chuwez', '2025-06-15 08:31:50'),
('6081', 'BS10100320250615083220000', '1446-11-18', '1.100.10', '101', 'Bayar[MOCHAMMAD TAUFIK ALI KURNIAWAN]', '30000', '0', 'Chuwez', '2025-06-15 08:32:20'),
('6082', 'BS10100320250615083220000', '1446-11-18', '4.400.20', '101', 'Bayar[MOCHAMMAD TAUFIK ALI KURNIAWAN]', '0', '30000', 'Chuwez', '2025-06-15 08:32:20'),
('6083', 'D110100320250615084045', '1446-12-18', '1.100.10', '101', 'Bayar[FAIZAH NURUL LITA]', '20000', '0', 'Chuwez', '2025-06-15 08:40:45'),
('6084', 'D110100320250615084045', '1446-12-18', '4.400.22', '101', 'Bayar[FAIZAH NURUL LITA]', '0', '20000', 'Chuwez', '2025-06-15 08:40:45'),
('6085', 'D110100320250615084102', '1446-12-18', '1.100.10', '101', 'Bayar[MARIATUL QIBTIYAH]', '20000', '0', 'Chuwez', '2025-06-15 08:41:02'),
('6086', 'D110100320250615084102', '1446-12-18', '4.400.22', '101', 'Bayar[MARIATUL QIBTIYAH]', '0', '20000', 'Chuwez', '2025-06-15 08:41:02'),
('6087', 'D110100320250615084130', '1446-12-18', '1.100.10', '101', 'Bayar[RAISA ANNISA]', '20000', '0', 'Chuwez', '2025-06-15 08:41:30'),
('6088', 'D110100320250615084130', '1446-12-18', '4.400.22', '101', 'Bayar[RAISA ANNISA]', '0', '20000', 'Chuwez', '2025-06-15 08:41:30'),
('6089', 'D110100320250615084154', '1446-12-18', '1.100.10', '101', 'Bayar[SITI ISTIFAIYAH]', '20000', '0', 'Chuwez', '2025-06-15 08:41:54'),
('6090', 'D110100320250615084154', '1446-12-18', '4.400.22', '101', 'Bayar[SITI ISTIFAIYAH]', '0', '20000', 'Chuwez', '2025-06-15 08:41:54'),
('6091', 'D110100320250615084214', '1446-12-18', '1.100.10', '101', 'Bayar[UBAIDAH]', '20000', '0', 'Chuwez', '2025-06-15 08:42:14'),
('6092', 'D110100320250615084214', '1446-12-18', '4.400.22', '101', 'Bayar[UBAIDAH]', '0', '20000', 'Chuwez', '2025-06-15 08:42:14'),
('6093', 'D110100320250615084232', '1446-12-18', '1.100.10', '101', 'Bayar[HIKMATUL KHOLIDAH]', '20000', '0', 'Chuwez', '2025-06-15 08:42:32'),
('6094', 'D110100320250615084232', '1446-12-18', '4.400.22', '101', 'Bayar[HIKMATUL KHOLIDAH]', '0', '20000', 'Chuwez', '2025-06-15 08:42:32'),
('6095', 'D110100320250615084257', '1446-12-18', '1.100.10', '101', 'Bayar[AHMAD ADITIYA]', '35000', '0', 'Chuwez', '2025-06-15 08:42:57'),
('6096', 'D110100320250615084257', '1446-12-18', '4.400.22', '101', 'Bayar[AHMAD ADITIYA]', '0', '35000', 'Chuwez', '2025-06-15 08:42:57'),
('6097', 'D110100320250615084319', '1446-12-18', '1.100.10', '101', 'Bayar[AHMAD ABBAS MAULANA]', '40000', '0', 'Chuwez', '2025-06-15 08:43:19'),
('6098', 'D110100320250615084319', '1446-12-18', '4.400.22', '101', 'Bayar[AHMAD ABBAS MAULANA]', '0', '40000', 'Chuwez', '2025-06-15 08:43:19'),
('6099', 'D110100320250615084335', '1446-12-18', '1.100.10', '101', 'Bayar[MUHAMMAD ABD. MANNAN ROSYID]', '40000', '0', 'Chuwez', '2025-06-15 08:43:35'),
('6100', 'D110100320250615084335', '1446-12-18', '4.400.22', '101', 'Bayar[MUHAMMAD ABD. MANNAN ROSYID]', '0', '40000', 'Chuwez', '2025-06-15 08:43:35'),
('6101', 'ST10100320250616061916', '1446-12-19', '1.100.10', '101', 'an.ROHMATULLOH', '5000', '0', 'Chuwez', '2025-06-16 13:19:16'),
('6102', 'ST10100320250616061916', '1446-12-19', '2.220.10', '101', 'an.ROHMATULLOH', '0', '5000', 'Chuwez', '2025-06-16 13:19:16'),
('6103', 'ST10100320250616061937', '1446-12-19', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '2000', '0', 'Chuwez', '2025-06-16 13:19:37'),
('6104', 'ST10100320250616061937', '1446-12-19', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '2000', 'Chuwez', '2025-06-16 13:19:37'),
('6105', 'ST10100320250616062003', '1446-12-19', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Chuwez', '2025-06-16 13:20:03'),
('6106', 'ST10100320250616062003', '1446-12-19', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Chuwez', '2025-06-16 13:20:03'),
('6107', 'ST10100320250616062029', '1446-12-19', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '10000', '0', 'Chuwez', '2025-06-16 13:20:29'),
('6108', 'ST10100320250616062029', '1446-12-19', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '10000', 'Chuwez', '2025-06-16 13:20:29'),
('6109', 'ST10100320250616062106', '1446-12-19', '1.100.10', '101', 'an.M. KAMALUDDIN', '10000', '0', 'Chuwez', '2025-06-16 13:21:06'),
('6110', 'ST10100320250616062106', '1446-12-19', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '10000', 'Chuwez', '2025-06-16 13:21:06'),
('6111', 'ST10100320250616062137', '1446-12-19', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '5000', '0', 'Chuwez', '2025-06-16 13:21:37'),
('6112', 'ST10100320250616062137', '1446-12-19', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '5000', 'Chuwez', '2025-06-16 13:21:37'),
('6113', 'ST10100320250616062207', '1446-12-19', '1.100.10', '101', 'an.NABILATUN NISAUL UMMAH', '20000', '0', 'Chuwez', '2025-06-16 13:22:07'),
('6114', 'ST10100320250616062207', '1446-12-19', '2.220.10', '101', 'an.NABILATUN NISAUL UMMAH', '0', '20000', 'Chuwez', '2025-06-16 13:22:07'),
('6115', 'ST10100320250616062236', '1446-12-19', '1.100.10', '101', 'an.RENI FARIDA', '4000', '0', 'Chuwez', '2025-06-16 13:22:36'),
('6116', 'ST10100320250616062236', '1446-12-19', '2.220.10', '101', 'an.RENI FARIDA', '0', '4000', 'Chuwez', '2025-06-16 13:22:36'),
('6117', 'ST10100320250616062314', '1446-12-19', '1.100.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '5000', '0', 'Chuwez', '2025-06-16 13:23:15'),
('6118', 'ST10100320250616062314', '1446-12-19', '2.220.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '0', '5000', 'Chuwez', '2025-06-16 13:23:15'),
('6119', 'ST10100320250616062348', '1446-12-19', '1.100.10', '101', 'an.ABDUL HAMID', '2000', '0', 'Chuwez', '2025-06-16 13:23:48'),
('6120', 'ST10100320250616062348', '1446-12-19', '2.220.10', '101', 'an.ABDUL HAMID', '0', '2000', 'Chuwez', '2025-06-16 13:23:48'),
('6121', 'ST10100320250616062427', '1446-12-19', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '10000', '0', 'Chuwez', '2025-06-16 13:24:27'),
('6122', 'ST10100320250616062427', '1446-12-19', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '10000', 'Chuwez', '2025-06-16 13:24:27'),
('6123', 'ST10100320250616062456', '1446-12-19', '1.100.10', '101', 'an.AHMAD SYAHRU ROMADHONI', '10000', '0', 'Chuwez', '2025-06-16 13:24:56'),
('6124', 'ST10100320250616062456', '1446-12-19', '2.220.10', '101', 'an.AHMAD SYAHRU ROMADHONI', '0', '10000', 'Chuwez', '2025-06-16 13:24:56'),
('6125', 'ST10100320250616062516', '1446-12-19', '1.100.10', '101', 'an.M. FAHMI NURUL ANAM', '10000', '0', 'Chuwez', '2025-06-16 13:25:16'),
('6126', 'ST10100320250616062516', '1446-12-19', '2.220.10', '101', 'an.M. FAHMI NURUL ANAM', '0', '10000', 'Chuwez', '2025-06-16 13:25:16'),
('6127', 'ST10100320250616062540', '1446-12-19', '1.100.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '10000', '0', 'Chuwez', '2025-06-16 13:25:40'),
('6128', 'ST10100320250616062540', '1446-12-19', '2.220.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '0', '10000', 'Chuwez', '2025-06-16 13:25:40'),
('6129', 'ST10100320250616062558', '1446-12-19', '1.100.10', '101', 'an.DIYANAH KAMALIYAH', '5000', '0', 'Chuwez', '2025-06-16 13:25:58'),
('6130', 'ST10100320250616062558', '1446-12-19', '2.220.10', '101', 'an.DIYANAH KAMALIYAH', '0', '5000', 'Chuwez', '2025-06-16 13:25:58'),
('6131', 'ST10100320250616062622', '1446-12-19', '1.100.10', '101', 'an.SITI QURROTUL AINI', '2000', '0', 'Chuwez', '2025-06-16 13:26:22'),
('6132', 'ST10100320250616062622', '1446-12-19', '2.220.10', '101', 'an.SITI QURROTUL AINI', '0', '2000', 'Chuwez', '2025-06-16 13:26:22'),
('6133', 'ST10100320250616062659', '1446-12-19', '1.100.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '2000', '0', 'Chuwez', '2025-06-16 13:26:59'),
('6134', 'ST10100320250616062659', '1446-12-19', '2.220.10', '101', 'an.MUHAMMAD ZAINAL ABIDIN', '0', '2000', 'Chuwez', '2025-06-16 13:26:59'),
('6135', 'ST10100320250616062721', '1446-12-19', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '5000', '0', 'Chuwez', '2025-06-16 13:27:21'),
('6136', 'ST10100320250616062721', '1446-12-19', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '5000', 'Chuwez', '2025-06-16 13:27:21'),
('6137', 'ST10100320250616062750', '1446-12-19', '1.100.10', '101', 'an.AZKA AUFARIL MINAN', '10000', '0', 'Chuwez', '2025-06-16 13:27:50'),
('6138', 'ST10100320250616062750', '1446-12-19', '2.220.10', '101', 'an.AZKA AUFARIL MINAN', '0', '10000', 'Chuwez', '2025-06-16 13:27:50'),
('6139', 'ST10100320250616062811', '1446-12-19', '1.100.10', '101', 'an.M. DESTRA MAULANA', '5000', '0', 'Chuwez', '2025-06-16 13:28:11'),
('6140', 'ST10100320250616062811', '1446-12-19', '2.220.10', '101', 'an.M. DESTRA MAULANA', '0', '5000', 'Chuwez', '2025-06-16 13:28:11'),
('6141', 'ST10100320250616062833', '1446-12-19', '1.100.10', '101', 'an.AHMAD ADITIYA', '2000', '0', 'Chuwez', '2025-06-16 13:28:33'),
('6142', 'ST10100320250616062833', '1446-12-19', '2.220.10', '101', 'an.AHMAD ADITIYA', '0', '2000', 'Chuwez', '2025-06-16 13:28:33'),
('6143', 'ST10100320250616062855', '1446-12-19', '1.100.10', '101', 'an.AISYAH', '5000', '0', 'Chuwez', '2025-06-16 13:28:55'),
('6144', 'ST10100320250616062855', '1446-12-19', '2.220.10', '101', 'an.AISYAH', '0', '5000', 'Chuwez', '2025-06-16 13:28:55'),
('6145', 'ST10100320250616062915', '1446-12-19', '1.100.10', '101', 'an.ALFI NURDIANA', '5000', '0', 'Chuwez', '2025-06-16 13:29:15'),
('6146', 'ST10100320250616062915', '1446-12-19', '2.220.10', '101', 'an.ALFI NURDIANA', '0', '5000', 'Chuwez', '2025-06-16 13:29:15'),
('6147', 'ST10100320250616062950', '1446-12-19', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '5000', '0', 'Chuwez', '2025-06-16 13:29:50'),
('6148', 'ST10100320250616062950', '1446-12-19', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '5000', 'Chuwez', '2025-06-16 13:29:50'),
('6149', 'ST10100320250616063009', '1446-12-19', '1.100.10', '101', 'an.MUHAMMAD KHOIRON', '5000', '0', 'Chuwez', '2025-06-16 13:30:09'),
('6150', 'ST10100320250616063009', '1446-12-19', '2.220.10', '101', 'an.MUHAMMAD KHOIRON', '0', '5000', 'Chuwez', '2025-06-16 13:30:09'),
('6151', 'ST10100320250616063136', '1446-12-19', '1.100.10', '101', 'an.ANA SALSABILA', '2000', '0', 'Chuwez', '2025-06-16 13:31:36'),
('6152', 'ST10100320250616063136', '1446-12-19', '2.220.10', '101', 'an.ANA SALSABILA', '0', '2000', 'Chuwez', '2025-06-16 13:31:36'),
('6153', 'ST10100320250616063157', '1446-12-19', '1.100.10', '101', 'an.ZAKIYATUL UMMAH', '2000', '0', 'Chuwez', '2025-06-16 13:31:57'),
('6154', 'ST10100320250616063157', '1446-12-19', '2.220.10', '101', 'an.ZAKIYATUL UMMAH', '0', '2000', 'Chuwez', '2025-06-16 13:31:57'),
('6155', 'ST10100320250616063215', '1446-12-19', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '5000', '0', 'Chuwez', '2025-06-16 13:32:15'),
('6156', 'ST10100320250616063215', '1446-12-19', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '5000', 'Chuwez', '2025-06-16 13:32:15'),
('6157', 'ST10100320250616063309', '1446-12-19', '1.100.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '10000', '0', 'Chuwez', '2025-06-16 13:33:09'),
('6158', 'ST10100320250616063309', '1446-12-19', '2.220.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '0', '10000', 'Chuwez', '2025-06-16 13:33:09'),
('6159', 'ST10100320250616063328', '1446-12-19', '1.100.10', '101', 'an.AKHMAD FIKRI HAIKAL', '50000', '0', 'Chuwez', '2025-06-16 13:33:28'),
('6160', 'ST10100320250616063328', '1446-12-19', '2.220.10', '101', 'an.AKHMAD FIKRI HAIKAL', '0', '50000', 'Chuwez', '2025-06-16 13:33:28'),
('6161', 'ST10100320250616063349', '1446-12-19', '1.100.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '5000', '0', 'Chuwez', '2025-06-16 13:33:49'),
('6162', 'ST10100320250616063349', '1446-12-19', '2.220.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '0', '5000', 'Chuwez', '2025-06-16 13:33:49'),
('6163', 'ST10100320250616063409', '1446-12-19', '1.100.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '10000', '0', 'Chuwez', '2025-06-16 13:34:09'),
('6164', 'ST10100320250616063409', '1446-12-19', '2.220.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '0', '10000', 'Chuwez', '2025-06-16 13:34:09'),
('6165', 'ST10100320250616063431', '1446-12-19', '1.100.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '5000', '0', 'Chuwez', '2025-06-16 13:34:31'),
('6166', 'ST10100320250616063431', '1446-12-19', '2.220.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '0', '5000', 'Chuwez', '2025-06-16 13:34:31'),
('6167', 'ST10100320250616063450', '1446-12-19', '1.100.10', '101', 'an.AHMAD ABBAS MAULANA', '3000', '0', 'Chuwez', '2025-06-16 13:34:50'),
('6168', 'ST10100320250616063450', '1446-12-19', '2.220.10', '101', 'an.AHMAD ABBAS MAULANA', '0', '3000', 'Chuwez', '2025-06-16 13:34:50'),
('6169', 'ST10100320250616063512', '1446-12-19', '1.100.10', '101', 'an.M. ROFIQ HIDAYATULLOH', '10000', '0', 'Chuwez', '2025-06-16 13:35:12'),
('6170', 'ST10100320250616063512', '1446-12-19', '2.220.10', '101', 'an.M. ROFIQ HIDAYATULLOH', '0', '10000', 'Chuwez', '2025-06-16 13:35:12'),
('6171', 'ST10100320250616063530', '1446-12-19', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '25000', '0', 'Chuwez', '2025-06-16 13:35:30'),
('6172', 'ST10100320250616063530', '1446-12-19', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '25000', 'Chuwez', '2025-06-16 13:35:30'),
('6173', 'ST10100320250616063551', '1446-12-19', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'Chuwez', '2025-06-16 13:35:51'),
('6174', 'ST10100320250616063551', '1446-12-19', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'Chuwez', '2025-06-16 13:35:51'),
('6175', 'KK10100320250616133604', '1446-12-18', '5.520.42', '101', 'Bakso', '40000', '0', 'Chuwez', '2025-06-16 06:36:26'),
('6176', 'KK10100320250616133604', '1446-12-18', '1.100.10', '101', 'Bakso', '0', '40000', 'Chuwez', '2025-06-16 06:36:26'),
('6177', 'KK10100320250616133604', '1446-12-19', '5.520.42', '101', 'Cemilan', '20000', '0', 'Chuwez', '2025-06-16 06:36:43'),
('6178', 'KK10100320250616133604', '1446-12-19', '1.100.10', '101', 'Cemilan', '0', '20000', 'Chuwez', '2025-06-16 06:36:43'),
('6179', 'ST10100320250616073609', '1446-12-19', '1.100.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '5000', '0', 'Chuwez', '2025-06-16 14:36:09'),
('6180', 'ST10100320250616073609', '1446-12-19', '2.220.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '0', '5000', 'Chuwez', '2025-06-16 14:36:09'),
('6181', 'ST10100320250616073629', '1446-12-19', '1.100.10', '101', 'an.SAFIRATUL JANNAH', '10000', '0', 'Chuwez', '2025-06-16 14:36:29'),
('6182', 'ST10100320250616073629', '1446-12-19', '2.220.10', '101', 'an.SAFIRATUL JANNAH', '0', '10000', 'Chuwez', '2025-06-16 14:36:29'),
('6183', 'ST10100320250616073702', '1446-12-19', '1.100.10', '101', 'an.RAISA ANNISA', '5000', '0', 'Chuwez', '2025-06-16 14:37:02'),
('6184', 'ST10100320250616073702', '1446-12-19', '2.220.10', '101', 'an.RAISA ANNISA', '0', '5000', 'Chuwez', '2025-06-16 14:37:02'),
('6185', 'ST10100320250616073741', '1446-12-19', '1.100.10', '101', 'an.NAILATUN NIAMI', '2000', '0', 'Chuwez', '2025-06-16 14:37:41'),
('6186', 'ST10100320250616073741', '1446-12-19', '2.220.10', '101', 'an.NAILATUN NIAMI', '0', '2000', 'Chuwez', '2025-06-16 14:37:41'),
('6187', 'ST10100320250616073805', '1446-12-19', '1.100.10', '101', 'an.MARIATUL QIBTIYAH', '2000', '0', 'Chuwez', '2025-06-16 14:38:05'),
('6188', 'ST10100320250616073805', '1446-12-19', '2.220.10', '101', 'an.MARIATUL QIBTIYAH', '0', '2000', 'Chuwez', '2025-06-16 14:38:05'),
('6189', 'ST10100320250616073830', '1446-12-19', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '5000', '0', 'Chuwez', '2025-06-16 14:38:30'),
('6190', 'ST10100320250616073830', '1446-12-19', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '5000', 'Chuwez', '2025-06-16 14:38:30'),
('6191', 'ST10100320250616073905', '1446-12-19', '1.100.10', '101', 'an.ROFIQOTUS SARIROH', '5000', '0', 'Chuwez', '2025-06-16 14:39:05'),
('6192', 'ST10100320250616073905', '1446-12-19', '2.220.10', '101', 'an.ROFIQOTUS SARIROH', '0', '5000', 'Chuwez', '2025-06-16 14:39:05'),
('6193', 'ST10100320250616073930', '1446-12-19', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'Chuwez', '2025-06-16 14:39:30'),
('6194', 'ST10100320250616073930', '1446-12-19', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'Chuwez', '2025-06-16 14:39:30'),
('6195', 'ST10100320250616073947', '1446-12-19', '1.100.10', '101', 'an.FAIZAH NURUL LITA', '5000', '0', 'Chuwez', '2025-06-16 14:39:47'),
('6196', 'ST10100320250616073947', '1446-12-19', '2.220.10', '101', 'an.FAIZAH NURUL LITA', '0', '5000', 'Chuwez', '2025-06-16 14:39:47'),
('6197', 'ST10100320250616074009', '1446-12-19', '1.100.10', '101', 'an.MARIYATUL QIBTIYAH', '5000', '0', 'Chuwez', '2025-06-16 14:40:09'),
('6198', 'ST10100320250616074009', '1446-12-19', '2.220.10', '101', 'an.MARIYATUL QIBTIYAH', '0', '5000', 'Chuwez', '2025-06-16 14:40:09'),
('6199', 'ST10100320250616074027', '1446-12-19', '1.100.10', '101', 'an.UBAIDAH', '10000', '0', 'Chuwez', '2025-06-16 14:40:27'),
('6200', 'ST10100320250616074027', '1446-12-19', '2.220.10', '101', 'an.UBAIDAH', '0', '10000', 'Chuwez', '2025-06-16 14:40:27'),
('6201', 'ST10100320250616074100', '1446-12-19', '1.100.10', '101', 'an.MUHAMMAD ALWI', '10000', '0', 'Chuwez', '2025-06-16 14:41:00'),
('6202', 'ST10100320250616074100', '1446-12-19', '2.220.10', '101', 'an.MUHAMMAD ALWI', '0', '10000', 'Chuwez', '2025-06-16 14:41:00'),
('6203', 'ST10100320250616074135', '1446-12-19', '1.100.10', '101', 'an.UMAR FARUQ', '20000', '0', 'Chuwez', '2025-06-16 14:41:35'),
('6204', 'ST10100320250616074135', '1446-12-19', '2.220.10', '101', 'an.UMAR FARUQ', '0', '20000', 'Chuwez', '2025-06-16 14:41:35'),
('6205', 'ST10100320250616074205', '1446-12-19', '1.100.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '4000', '0', 'Chuwez', '2025-06-16 14:42:05'),
('6206', 'ST10100320250616074205', '1446-12-19', '2.220.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '0', '4000', 'Chuwez', '2025-06-16 14:42:05'),
('6207', 'ST10100320250616074232', '1446-12-19', '1.100.10', '101', 'an.HILYA', '20000', '0', 'Chuwez', '2025-06-16 14:42:32'),
('6208', 'ST10100320250616074232', '1446-12-19', '2.220.10', '101', 'an.HILYA', '0', '20000', 'Chuwez', '2025-06-16 14:42:32'),
('6209', 'ST10100320250616074301', '1446-12-19', '1.100.10', '101', 'an.BILQIS THALIA HASNA', '75000', '0', 'Chuwez', '2025-06-16 14:43:01'),
('6210', 'ST10100320250616074301', '1446-12-19', '2.220.10', '101', 'an.BILQIS THALIA HASNA', '0', '75000', 'Chuwez', '2025-06-16 14:43:01'),
('6211', 'ST10100320250616074403', '1446-12-19', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '15000', '0', 'Chuwez', '2025-06-16 14:44:03'),
('6212', 'ST10100320250616074403', '1446-12-19', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '15000', 'Chuwez', '2025-06-16 14:44:03'),
('6213', 'ST10100320250616074422', '1446-12-19', '1.100.10', '101', 'an.HAIKAL SHOMADANI', '2000', '0', 'Chuwez', '2025-06-16 14:44:22'),
('6214', 'ST10100320250616074422', '1446-12-19', '2.220.10', '101', 'an.HAIKAL SHOMADANI', '0', '2000', 'Chuwez', '2025-06-16 14:44:22'),
('6215', 'ST10100320250616074445', '1446-12-19', '1.100.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '2000', '0', 'Chuwez', '2025-06-16 14:44:45'),
('6216', 'ST10100320250616074445', '1446-12-19', '2.220.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '0', '2000', 'Chuwez', '2025-06-16 14:44:45'),
('6217', 'ST10100320250616074512', '1446-12-19', '1.100.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '5000', '0', 'Chuwez', '2025-06-16 14:45:12'),
('6218', 'ST10100320250616074512', '1446-12-19', '2.220.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '0', '5000', 'Chuwez', '2025-06-16 14:45:12'),
('6219', 'ST10100320250616074535', '1446-12-19', '1.100.10', '101', 'an.NAURA BILADINA', '10000', '0', 'Chuwez', '2025-06-16 14:45:35'),
('6220', 'ST10100320250616074535', '1446-12-19', '2.220.10', '101', 'an.NAURA BILADINA', '0', '10000', 'Chuwez', '2025-06-16 14:45:35'),
('6221', 'ST10100320250616074602', '1446-12-19', '1.100.10', '101', 'an.M. ABD. HADI', '2000', '0', 'Chuwez', '2025-06-16 14:46:02'),
('6222', 'ST10100320250616074602', '1446-12-19', '2.220.10', '101', 'an.M. ABD. HADI', '0', '2000', 'Chuwez', '2025-06-16 14:46:02'),
('6223', 'ST10100320250616074631', '1446-12-19', '1.100.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '5000', '0', 'Chuwez', '2025-06-16 14:46:31'),
('6224', 'ST10100320250616074631', '1446-12-19', '2.220.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '0', '5000', 'Chuwez', '2025-06-16 14:46:31'),
('6225', 'ST10100320250616074651', '1446-12-19', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'Chuwez', '2025-06-16 14:46:51'),
('6226', 'ST10100320250616074651', '1446-12-19', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'Chuwez', '2025-06-16 14:46:51'),
('6227', 'ST10100320250616074714', '1446-12-19', '1.100.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '5000', '0', 'Chuwez', '2025-06-16 14:47:14'),
('6228', 'ST10100320250616074714', '1446-12-19', '2.220.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '0', '5000', 'Chuwez', '2025-06-16 14:47:14'),
('6229', 'BS10100320250616074804000', '1446-12-19', '1.100.10', '101', 'Bayar[MUHAMMAD RAIHAN SABILA]', '30000', '0', 'Chuwez', '2025-06-16 07:48:04'),
('6230', 'BS10100320250616074804000', '1446-12-19', '4.400.20', '101', 'Bayar[MUHAMMAD RAIHAN SABILA]', '0', '30000', 'Chuwez', '2025-06-16 07:48:04'),
('6231', 'D110100320250616082940', '1446-12-19', '1.100.10', '101', 'Bayar[HAIKAL SHOMADANI]', '20000', '0', 'Chuwez', '2025-06-16 08:29:40'),
('6232', 'D110100320250616082940', '1446-12-19', '4.400.22', '101', 'Bayar[HAIKAL SHOMADANI]', '0', '20000', 'Chuwez', '2025-06-16 08:29:40'),
('6235', 'D110100320250616092744', '1446-12-19', '1.100.10', '101', 'Bayar[MOCH.ANDIE FIRMANSYAH]', '20000', '0', 'Chuwez', '2025-06-16 09:27:44'),
('6236', 'D110100320250616092744', '1446-12-19', '4.400.22', '101', 'Bayar[MOCH.ANDIE FIRMANSYAH]', '0', '20000', 'Chuwez', '2025-06-16 09:27:44'),
('6237', 'D110100320250617074207', '1446-12-20', '1.100.10', '101', 'Bayar[AHMAD NUR HASAN ROMADHONI]', '35000', '0', 'Chuwez', '2025-06-17 07:42:07'),
('6238', 'D110100320250617074207', '1446-12-20', '4.400.22', '101', 'Bayar[AHMAD NUR HASAN ROMADHONI]', '0', '35000', 'Chuwez', '2025-06-17 07:42:07'),
('6239', 'D110100320250617074232', '1446-12-20', '1.100.10', '101', 'Bayar[ADIBA QONITA]', '20000', '0', 'Chuwez', '2025-06-17 07:42:32'),
('6240', 'D110100320250617074232', '1446-12-20', '4.400.22', '101', 'Bayar[ADIBA QONITA]', '0', '20000', 'Chuwez', '2025-06-17 07:42:32'),
('6241', 'BS10100320250617074300000', '1446-10-20', '1.100.10', '101', 'Bayar[AHMAD NUR HASAN ROMADHONI]', '30000', '0', 'Chuwez', '2025-06-17 07:43:00'),
('6242', 'BS10100320250617074300000', '1446-10-20', '4.400.20', '101', 'Bayar[AHMAD NUR HASAN ROMADHONI]', '0', '30000', 'Chuwez', '2025-06-17 07:43:00'),
('6243', 'BS10100320250617074300001', '1446-11-20', '1.100.10', '101', 'Bayar[AHMAD NUR HASAN ROMADHONI]', '30000', '0', 'Chuwez', '2025-06-17 07:43:00'),
('6244', 'BS10100320250617074300001', '1446-11-20', '4.400.20', '101', 'Bayar[AHMAD NUR HASAN ROMADHONI]', '0', '30000', 'Chuwez', '2025-06-17 07:43:00'),
('6245', 'BS10100320250617074300002', '1446-12-20', '1.100.10', '101', 'Bayar[AHMAD NUR HASAN ROMADHONI]', '30000', '0', 'Chuwez', '2025-06-17 07:43:00'),
('6246', 'BS10100320250617074300002', '1446-12-20', '4.400.20', '101', 'Bayar[AHMAD NUR HASAN ROMADHONI]', '0', '30000', 'Chuwez', '2025-06-17 07:43:00'),
('6247', 'D110100320250617074442', '1446-12-20', '1.100.10', '101', 'Bayar[IZZA BILLAH]', '35000', '0', 'Chuwez', '2025-06-17 07:44:42'),
('6248', 'D110100320250617074442', '1446-12-20', '4.400.22', '101', 'Bayar[IZZA BILLAH]', '0', '35000', 'Chuwez', '2025-06-17 07:44:42'),
('6249', 'D110100320250617074800', '1446-12-20', '1.100.10', '101', 'Bayar[MUHAMMAD HAMDANI]', '40000', '0', 'Chuwez', '2025-06-17 07:48:00'),
('6250', 'D110100320250617074800', '1446-12-20', '4.400.22', '101', 'Bayar[MUHAMMAD HAMDANI]', '0', '40000', 'Chuwez', '2025-06-17 07:48:00'),
('6251', 'BS10100320250617074917000', '1446-11-20', '1.100.10', '101', 'Bayar[MUHAMMAD HAMDANI]', '30000', '0', 'Chuwez', '2025-06-17 07:49:17'),
('6252', 'BS10100320250617074917000', '1446-11-20', '4.400.20', '101', 'Bayar[MUHAMMAD HAMDANI]', '0', '30000', 'Chuwez', '2025-06-17 07:49:17'),
('6253', 'ST10100320250617082027', '1446-12-20', '1.100.10', '101', 'an.NAURA BILADINA', '10000', '0', 'Chuwez', '2025-06-17 15:20:27'),
('6254', 'ST10100320250617082027', '1446-12-20', '2.220.10', '101', 'an.NAURA BILADINA', '0', '10000', 'Chuwez', '2025-06-17 15:20:27'),
('6255', 'ST10100320250617082046', '1446-12-20', '1.100.10', '101', 'an.M. ABD. HADI', '2000', '0', 'Chuwez', '2025-06-17 15:20:46'),
('6256', 'ST10100320250617082046', '1446-12-20', '2.220.10', '101', 'an.M. ABD. HADI', '0', '2000', 'Chuwez', '2025-06-17 15:20:46'),
('6257', 'ST10100320250617082122', '1446-12-20', '1.100.10', '101', 'an.HAIKAL SHOMADANI', '2000', '0', 'Chuwez', '2025-06-17 15:21:22'),
('6258', 'ST10100320250617082122', '1446-12-20', '2.220.10', '101', 'an.HAIKAL SHOMADANI', '0', '2000', 'Chuwez', '2025-06-17 15:21:22'),
('6259', 'ST10100320250617082145', '1446-12-20', '1.100.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '5000', '0', 'Chuwez', '2025-06-17 15:21:45'),
('6260', 'ST10100320250617082145', '1446-12-20', '2.220.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '0', '5000', 'Chuwez', '2025-06-17 15:21:45'),
('6261', 'ST10100320250617082208', '1446-12-20', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '10000', '0', 'Chuwez', '2025-06-17 15:22:08'),
('6262', 'ST10100320250617082208', '1446-12-20', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '10000', 'Chuwez', '2025-06-17 15:22:08'),
('6263', 'ST10100320250617082228', '1446-12-20', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'Chuwez', '2025-06-17 15:22:28'),
('6264', 'ST10100320250617082228', '1446-12-20', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'Chuwez', '2025-06-17 15:22:28'),
('6265', 'ST10100320250617082243', '1446-12-20', '1.100.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '5000', '0', 'Chuwez', '2025-06-17 15:22:43'),
('6266', 'ST10100320250617082243', '1446-12-20', '2.220.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '0', '5000', 'Chuwez', '2025-06-17 15:22:43'),
('6267', 'ST10100320250617082300', '1446-12-20', '1.100.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '2000', '0', 'Chuwez', '2025-06-17 15:23:00'),
('6268', 'ST10100320250617082300', '1446-12-20', '2.220.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '0', '2000', 'Chuwez', '2025-06-17 15:23:00'),
('6269', 'ST10100320250617082337', '1446-12-20', '1.100.10', '101', 'an.FAIZAH NURUL LITA', '5000', '0', 'Chuwez', '2025-06-17 15:23:37'),
('6270', 'ST10100320250617082337', '1446-12-20', '2.220.10', '101', 'an.FAIZAH NURUL LITA', '0', '5000', 'Chuwez', '2025-06-17 15:23:37'),
('6271', 'ST10100320250617082352', '1446-12-20', '1.100.10', '101', 'an.MARIYATUL QIBTIYAH', '5000', '0', 'Chuwez', '2025-06-17 15:23:52'),
('6272', 'ST10100320250617082352', '1446-12-20', '2.220.10', '101', 'an.MARIYATUL QIBTIYAH', '0', '5000', 'Chuwez', '2025-06-17 15:23:52'),
('6273', 'ST10100320250617082409', '1446-12-20', '1.100.10', '101', 'an.MUHAMMAD ALWI', '10000', '0', 'Chuwez', '2025-06-17 15:24:09'),
('6274', 'ST10100320250617082409', '1446-12-20', '2.220.10', '101', 'an.MUHAMMAD ALWI', '0', '10000', 'Chuwez', '2025-06-17 15:24:09'),
('6275', 'ST10100320250617082428', '1446-12-20', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '5000', '0', 'Chuwez', '2025-06-17 15:24:28'),
('6276', 'ST10100320250617082428', '1446-12-20', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '5000', 'Chuwez', '2025-06-17 15:24:28'),
('6277', 'ST10100320250617082449', '1446-12-20', '1.100.10', '101', 'an.RAISA ANNISA', '5000', '0', 'Chuwez', '2025-06-17 15:24:49'),
('6278', 'ST10100320250617082449', '1446-12-20', '2.220.10', '101', 'an.RAISA ANNISA', '0', '5000', 'Chuwez', '2025-06-17 15:24:49'),
('6279', 'ST10100320250617082508', '1446-12-20', '1.100.10', '101', 'an.UBAIDAH', '10000', '0', 'Chuwez', '2025-06-17 15:25:08'),
('6280', 'ST10100320250617082508', '1446-12-20', '2.220.10', '101', 'an.UBAIDAH', '0', '10000', 'Chuwez', '2025-06-17 15:25:08'),
('6281', 'ST10100320250617082531', '1446-12-20', '1.100.10', '101', 'an.SAUQY AHMAD', '10000', '0', 'Chuwez', '2025-06-17 15:25:31'),
('6282', 'ST10100320250617082531', '1446-12-20', '2.220.10', '101', 'an.SAUQY AHMAD', '0', '10000', 'Chuwez', '2025-06-17 15:25:31'),
('6283', 'ST10100320250617082546', '1446-12-20', '1.100.10', '101', 'an.UMAR FARUQ', '10000', '0', 'Chuwez', '2025-06-17 15:25:46'),
('6284', 'ST10100320250617082546', '1446-12-20', '2.220.10', '101', 'an.UMAR FARUQ', '0', '10000', 'Chuwez', '2025-06-17 15:25:46'),
('6285', 'ST10100320250617082603', '1446-12-20', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'Chuwez', '2025-06-17 15:26:03'),
('6286', 'ST10100320250617082603', '1446-12-20', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'Chuwez', '2025-06-17 15:26:03'),
('6287', 'ST10100320250617082620', '1446-12-20', '1.100.10', '101', 'an.NAILATUN NIAMI', '2000', '0', 'Chuwez', '2025-06-17 15:26:20'),
('6288', 'ST10100320250617082620', '1446-12-20', '2.220.10', '101', 'an.NAILATUN NIAMI', '0', '2000', 'Chuwez', '2025-06-17 15:26:20'),
('6289', 'ST10100320250617082639', '1446-12-20', '1.100.10', '101', 'an.MARIATUL QIBTIYAH', '2000', '0', 'Chuwez', '2025-06-17 15:26:39'),
('6290', 'ST10100320250617082639', '1446-12-20', '2.220.10', '101', 'an.MARIATUL QIBTIYAH', '0', '2000', 'Chuwez', '2025-06-17 15:26:39'),
('6291', 'ST10100320250617082705', '1446-12-20', '1.100.10', '101', 'an.ALFI NURDIANA', '5000', '0', 'Chuwez', '2025-06-17 15:27:05'),
('6292', 'ST10100320250617082705', '1446-12-20', '2.220.10', '101', 'an.ALFI NURDIANA', '0', '5000', 'Chuwez', '2025-06-17 15:27:05'),
('6293', 'ST10100320250617082724', '1446-12-20', '1.100.10', '101', 'an.AISYAH', '5000', '0', 'Chuwez', '2025-06-17 15:27:24'),
('6294', 'ST10100320250617082724', '1446-12-20', '2.220.10', '101', 'an.AISYAH', '0', '5000', 'Chuwez', '2025-06-17 15:27:24'),
('6295', 'ST10100320250617082738', '1446-12-20', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '10000', '0', 'Chuwez', '2025-06-17 15:27:38'),
('6296', 'ST10100320250617082738', '1446-12-20', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '10000', 'Chuwez', '2025-06-17 15:27:38'),
('6297', 'ST10100320250617082754', '1446-12-20', '1.100.10', '101', 'an.AHMAD NUR HASAN ROMADHONI', '5000', '0', 'Chuwez', '2025-06-17 15:27:54'),
('6298', 'ST10100320250617082754', '1446-12-20', '2.220.10', '101', 'an.AHMAD NUR HASAN ROMADHONI', '0', '5000', 'Chuwez', '2025-06-17 15:27:54'),
('6299', 'ST10100320250617082811', '1446-12-20', '1.100.10', '101', 'an.AZKA AUFARIL MINAN', '10000', '0', 'Chuwez', '2025-06-17 15:28:11'),
('6300', 'ST10100320250617082811', '1446-12-20', '2.220.10', '101', 'an.AZKA AUFARIL MINAN', '0', '10000', 'Chuwez', '2025-06-17 15:28:11'),
('6301', 'ST10100320250617082832', '1446-12-20', '1.100.10', '101', 'an.AHMAD ADITIYA', '1000', '0', 'Chuwez', '2025-06-17 15:28:32'),
('6302', 'ST10100320250617082832', '1446-12-20', '2.220.10', '101', 'an.AHMAD ADITIYA', '0', '1000', 'Chuwez', '2025-06-17 15:28:32'),
('6303', 'ST10100320250617082900', '1446-12-20', '1.100.10', '101', 'an.DIYANAH KAMALIYAH', '2000', '0', 'Chuwez', '2025-06-17 15:29:00'),
('6304', 'ST10100320250617082900', '1446-12-20', '2.220.10', '101', 'an.DIYANAH KAMALIYAH', '0', '2000', 'Chuwez', '2025-06-17 15:29:00'),
('6305', 'ST10100320250617082915', '1446-12-20', '1.100.10', '101', 'an.M. FAHMI NURUL ANAM', '10000', '0', 'Chuwez', '2025-06-17 15:29:15'),
('6306', 'ST10100320250617082915', '1446-12-20', '2.220.10', '101', 'an.M. FAHMI NURUL ANAM', '0', '10000', 'Chuwez', '2025-06-17 15:29:15'),
('6307', 'ST10100320250617082930', '1446-12-20', '1.100.10', '101', 'an.ABDUL HAMID', '5000', '0', 'Chuwez', '2025-06-17 15:29:30'),
('6308', 'ST10100320250617082930', '1446-12-20', '2.220.10', '101', 'an.ABDUL HAMID', '0', '5000', 'Chuwez', '2025-06-17 15:29:30'),
('6309', 'ST10100320250617082945', '1446-12-20', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '10000', '0', 'Chuwez', '2025-06-17 15:29:45'),
('6310', 'ST10100320250617082945', '1446-12-20', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '10000', 'Chuwez', '2025-06-17 15:29:45'),
('6311', 'ST10100320250617083001', '1446-12-20', '1.100.10', '101', 'an.WARDATUL JANNAH', '2000', '0', 'Chuwez', '2025-06-17 15:30:01'),
('6312', 'ST10100320250617083001', '1446-12-20', '2.220.10', '101', 'an.WARDATUL JANNAH', '0', '2000', 'Chuwez', '2025-06-17 15:30:01'),
('6313', 'ST10100320250617083047', '1446-12-20', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '5000', '0', 'Chuwez', '2025-06-17 15:30:47'),
('6314', 'ST10100320250617083047', '1446-12-20', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '5000', 'Chuwez', '2025-06-17 15:30:47'),
('6315', 'ST10100320250617083059', '1446-12-20', '1.100.10', '101', 'an.M. KAMALUDDIN', '10000', '0', 'Chuwez', '2025-06-17 15:30:59'),
('6316', 'ST10100320250617083059', '1446-12-20', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '10000', 'Chuwez', '2025-06-17 15:30:59'),
('6317', 'ST10100320250617083115', '1446-12-20', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Chuwez', '2025-06-17 15:31:15'),
('6318', 'ST10100320250617083115', '1446-12-20', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Chuwez', '2025-06-17 15:31:15'),
('6319', 'ST10100320250617083134', '1446-12-20', '1.100.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '10000', '0', 'Chuwez', '2025-06-17 15:31:34'),
('6320', 'ST10100320250617083134', '1446-12-20', '2.220.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '0', '10000', 'Chuwez', '2025-06-17 15:31:34'),
('6321', 'ST10100320250617083152', '1446-12-20', '1.100.10', '101', 'an.MIFTAHUL JANNAH', '50000', '0', 'Chuwez', '2025-06-17 15:31:52'),
('6322', 'ST10100320250617083152', '1446-12-20', '2.220.10', '101', 'an.MIFTAHUL JANNAH', '0', '50000', 'Chuwez', '2025-06-17 15:31:52'),
('6323', 'ST10100320250617083206', '1446-12-20', '1.100.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '5000', '0', 'Chuwez', '2025-06-17 15:32:06'),
('6324', 'ST10100320250617083206', '1446-12-20', '2.220.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '0', '5000', 'Chuwez', '2025-06-17 15:32:06'),
('6325', 'ST10100320250617083226', '1446-12-20', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '10000', '0', 'Chuwez', '2025-06-17 15:32:26'),
('6326', 'ST10100320250617083226', '1446-12-20', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '10000', 'Chuwez', '2025-06-17 15:32:26'),
('6327', 'ST10100320250617083240', '1446-12-20', '1.100.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '5000', '0', 'Chuwez', '2025-06-17 15:32:40'),
('6328', 'ST10100320250617083240', '1446-12-20', '2.220.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '0', '5000', 'Chuwez', '2025-06-17 15:32:40'),
('6329', 'ST10100320250617083301', '1446-12-20', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '2000', '0', 'Chuwez', '2025-06-17 15:33:01'),
('6330', 'ST10100320250617083301', '1446-12-20', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '2000', 'Chuwez', '2025-06-17 15:33:01'),
('6331', 'ST10100320250617083319', '1446-12-20', '1.100.10', '101', 'an.AKHMAD FIKRI HAIKAL', '50000', '0', 'Chuwez', '2025-06-17 15:33:19'),
('6332', 'ST10100320250617083319', '1446-12-20', '2.220.10', '101', 'an.AKHMAD FIKRI HAIKAL', '0', '50000', 'Chuwez', '2025-06-17 15:33:19'),
('6333', 'ST10100320250617083331', '1446-12-20', '1.100.10', '101', 'an.AHMAD ABBAS MAULANA', '4000', '0', 'Chuwez', '2025-06-17 15:33:31'),
('6334', 'ST10100320250617083331', '1446-12-20', '2.220.10', '101', 'an.AHMAD ABBAS MAULANA', '0', '4000', 'Chuwez', '2025-06-17 15:33:31'),
('6335', 'ST10100320250617083344', '1446-12-20', '1.100.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '10000', '0', 'Chuwez', '2025-06-17 15:33:44'),
('6336', 'ST10100320250617083344', '1446-12-20', '2.220.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '0', '10000', 'Chuwez', '2025-06-17 15:33:44'),
('6337', 'ST10100320250617083400', '1446-12-20', '1.100.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '5000', '0', 'Chuwez', '2025-06-17 15:34:00'),
('6338', 'ST10100320250617083400', '1446-12-20', '2.220.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '0', '5000', 'Chuwez', '2025-06-17 15:34:00'),
('6339', 'ST10100320250617083414', '1446-12-20', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '25000', '0', 'Chuwez', '2025-06-17 15:34:14'),
('6340', 'ST10100320250617083414', '1446-12-20', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '25000', 'Chuwez', '2025-06-17 15:34:14'),
('6341', 'ST10100320250617083429', '1446-12-20', '1.100.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '5000', '0', 'Chuwez', '2025-06-17 15:34:29'),
('6342', 'ST10100320250617083429', '1446-12-20', '2.220.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '0', '5000', 'Chuwez', '2025-06-17 15:34:29'),
('6343', 'ST10100320250617083444', '1446-12-20', '1.100.10', '101', 'an.BILQIS THALIA HASNA', '75000', '0', 'Chuwez', '2025-06-17 15:34:44'),
('6344', 'ST10100320250617083444', '1446-12-20', '2.220.10', '101', 'an.BILQIS THALIA HASNA', '0', '75000', 'Chuwez', '2025-06-17 15:34:44'),
('6345', 'ST10100320250617083457', '1446-12-20', '1.100.10', '101', 'an.SINDI RAISA PUTRI', '10000', '0', 'Chuwez', '2025-06-17 15:34:57'),
('6346', 'ST10100320250617083457', '1446-12-20', '2.220.10', '101', 'an.SINDI RAISA PUTRI', '0', '10000', 'Chuwez', '2025-06-17 15:34:57'),
('6347', 'ST10100320250617083525', '1446-12-20', '1.100.10', '101', 'an.ANA SALSABILA', '5000', '0', 'Chuwez', '2025-06-17 15:35:25'),
('6348', 'ST10100320250617083525', '1446-12-20', '2.220.10', '101', 'an.ANA SALSABILA', '0', '5000', 'Chuwez', '2025-06-17 15:35:25'),
('6349', 'ST10100320250617083538', '1446-12-20', '1.100.10', '101', 'an.AFANDI', '5000', '0', 'Chuwez', '2025-06-17 15:35:38'),
('6350', 'ST10100320250617083538', '1446-12-20', '2.220.10', '101', 'an.AFANDI', '0', '5000', 'Chuwez', '2025-06-17 15:35:38'),
('6351', 'ST10100320250617083549', '1446-12-20', '1.100.10', '101', 'an.MUHAMMAD KHOIRON', '5000', '0', 'Chuwez', '2025-06-17 15:35:49'),
('6352', 'ST10100320250617083549', '1446-12-20', '2.220.10', '101', 'an.MUHAMMAD KHOIRON', '0', '5000', 'Chuwez', '2025-06-17 15:35:49'),
('6353', 'ST10100320250617083602', '1446-12-20', '1.100.10', '101', 'an.M. ALIFIN FIKRI', '3000', '0', 'Chuwez', '2025-06-17 15:36:02'),
('6354', 'ST10100320250617083602', '1446-12-20', '2.220.10', '101', 'an.M. ALIFIN FIKRI', '0', '3000', 'Chuwez', '2025-06-17 15:36:02'),
('6355', 'ST10100320250617083616', '1446-12-20', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '5000', '0', 'Chuwez', '2025-06-17 15:36:16'),
('6356', 'ST10100320250617083616', '1446-12-20', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '5000', 'Chuwez', '2025-06-17 15:36:16'),
('6357', 'ST10100320250617083637', '1446-12-20', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '5000', '0', 'Chuwez', '2025-06-17 15:36:37'),
('6358', 'ST10100320250617083637', '1446-12-20', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '5000', 'Chuwez', '2025-06-17 15:36:37'),
('6359', 'ST10100320250617083650', '1446-12-20', '1.100.10', '101', 'an.ZAKIYATUL UMMAH', '2000', '0', 'Chuwez', '2025-06-17 15:36:50'),
('6360', 'ST10100320250617083650', '1446-12-20', '2.220.10', '101', 'an.ZAKIYATUL UMMAH', '0', '2000', 'Chuwez', '2025-06-17 15:36:50'),
('6361', 'ST10100320250617083721', '1446-12-20', '1.100.10', '101', 'an.SAFIRATUL JANNAH', '10000', '0', 'Chuwez', '2025-06-17 15:37:21'),
('6362', 'ST10100320250617083721', '1446-12-20', '2.220.10', '101', 'an.SAFIRATUL JANNAH', '0', '10000', 'Chuwez', '2025-06-17 15:37:21'),
('6363', 'ST10100320250617083739', '1446-12-20', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '5000', '0', 'Chuwez', '2025-06-17 15:37:39'),
('6364', 'ST10100320250617083739', '1446-12-20', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '5000', 'Chuwez', '2025-06-17 15:37:39'),
('6365', 'ST10100320250617083757', '1446-12-20', '1.100.10', '101', 'an.HILYA', '20000', '0', 'Chuwez', '2025-06-17 15:37:57'),
('6366', 'ST10100320250617083757', '1446-12-20', '2.220.10', '101', 'an.HILYA', '0', '20000', 'Chuwez', '2025-06-17 15:37:57'),
('6367', 'ST10100320250617083814', '1446-12-20', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'Chuwez', '2025-06-17 15:38:14'),
('6368', 'ST10100320250617083814', '1446-12-20', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'Chuwez', '2025-06-17 15:38:14'),
('6369', 'BS10100320250617085445000', '1446-10-20', '1.100.10', '101', 'Bayar[M. ALIFIN FIKRI]', '30000', '0', 'Chuwez', '2025-06-17 08:54:45'),
('6370', 'BS10100320250617085445000', '1446-10-20', '4.400.20', '101', 'Bayar[M. ALIFIN FIKRI]', '0', '30000', 'Chuwez', '2025-06-17 08:54:45'),
('6371', 'BS10100320250617085445001', '1446-11-20', '1.100.10', '101', 'Bayar[M. ALIFIN FIKRI]', '30000', '0', 'Chuwez', '2025-06-17 08:54:45'),
('6372', 'BS10100320250617085445001', '1446-11-20', '4.400.20', '101', 'Bayar[M. ALIFIN FIKRI]', '0', '30000', 'Chuwez', '2025-06-17 08:54:45'),
('6373', 'KK10100320250617161342', '1446-12-20', '5.520.42', '101', 'Mayoran', '80000', '0', 'Chuwez', '2025-06-17 09:13:59'),
('6374', 'KK10100320250617161342', '1446-12-20', '1.100.10', '101', 'Mayoran', '0', '80000', 'Chuwez', '2025-06-17 09:13:59'),
('6375', 'ST10100220250617100857', '1446-12-20', '1.100.10', '101', 'an.KHOIRIYAH tarik ke kas madrasah dan sudah diganti oleh uang tabungan info ust umar', '0', '85000', 'Ipul', '2025-06-17 17:08:57'),
('6376', 'ST10100220250617100857', '1446-12-20', '2.220.10', '101', 'an.KHOIRIYAH tarik ke kas madrasah dan sudah diganti oleh uang tabungan info ust umar', '85000', '0', 'Ipul', '2025-06-17 17:08:57'),
('6377', 'D110100320250618073232', '1446-12-21', '1.100.10', '101', 'Bayar[A. KHOIRUN NIZAM]', '35000', '0', 'Chuwez', '2025-06-18 07:32:32'),
('6378', 'D110100320250618073232', '1446-12-21', '4.400.22', '101', 'Bayar[A. KHOIRUN NIZAM]', '0', '35000', 'Chuwez', '2025-06-18 07:32:32'),
('6379', 'ST10100320250618073427', '1446-12-21', '1.100.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '2000', '0', 'Chuwez', '2025-06-18 14:34:27'),
('6380', 'ST10100320250618073427', '1446-12-21', '2.220.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '0', '2000', 'Chuwez', '2025-06-18 14:34:27'),
('6381', 'ST10100320250618073442', '1446-12-21', '1.100.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '5000', '0', 'Chuwez', '2025-06-18 14:34:42'),
('6382', 'ST10100320250618073442', '1446-12-21', '2.220.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '0', '5000', 'Chuwez', '2025-06-18 14:34:42'),
('6383', 'ST10100320250618073457', '1446-12-21', '1.100.10', '101', 'an.AULIA AZZAHRA', '10000', '0', 'Chuwez', '2025-06-18 14:34:57'),
('6384', 'ST10100320250618073457', '1446-12-21', '2.220.10', '101', 'an.AULIA AZZAHRA', '0', '10000', 'Chuwez', '2025-06-18 14:34:57'),
('6385', 'ST10100320250618073515', '1446-12-21', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '10000', '0', 'Chuwez', '2025-06-18 14:35:15'),
('6386', 'ST10100320250618073515', '1446-12-21', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '10000', 'Chuwez', '2025-06-18 14:35:15'),
('6387', 'ST10100320250618073531', '1446-12-21', '1.100.10', '101', 'an.HAIKAL SHOMADANI', '2000', '0', 'Chuwez', '2025-06-18 14:35:31'),
('6388', 'ST10100320250618073531', '1446-12-21', '2.220.10', '101', 'an.HAIKAL SHOMADANI', '0', '2000', 'Chuwez', '2025-06-18 14:35:31'),
('6389', 'ST10100320250618073548', '1446-12-21', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'Chuwez', '2025-06-18 14:35:48'),
('6390', 'ST10100320250618073548', '1446-12-21', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'Chuwez', '2025-06-18 14:35:48'),
('6391', 'ST10100320250618073602', '1446-12-21', '1.100.10', '101', 'an.NAURA BILADINA', '10000', '0', 'Chuwez', '2025-06-18 14:36:02'),
('6392', 'ST10100320250618073602', '1446-12-21', '2.220.10', '101', 'an.NAURA BILADINA', '0', '10000', 'Chuwez', '2025-06-18 14:36:02'),
('6393', 'ST10100320250618073618', '1446-12-21', '1.100.10', '101', 'an.M. ABD. HADI', '2000', '0', 'Chuwez', '2025-06-18 14:36:18'),
('6394', 'ST10100320250618073618', '1446-12-21', '2.220.10', '101', 'an.M. ABD. HADI', '0', '2000', 'Chuwez', '2025-06-18 14:36:18'),
('6395', 'D110100320250618075713', '1446-12-21', '1.100.10', '101', 'Bayar[IFTITAHUL IZZA]', '35000', '0', 'chuwez', '2025-06-18 07:57:13'),
('6396', 'D110100320250618075713', '1446-12-21', '4.400.22', '101', 'Bayar[IFTITAHUL IZZA]', '0', '35000', 'chuwez', '2025-06-18 07:57:13'),
('6397', 'ST10100320250618075750', '1446-12-21', '1.100.10', '101', 'an.RAISA ANNISA', '5000', '0', 'chuwez', '2025-06-18 14:57:50'),
('6398', 'ST10100320250618075750', '1446-12-21', '2.220.10', '101', 'an.RAISA ANNISA', '0', '5000', 'chuwez', '2025-06-18 14:57:50'),
('6399', 'ST10100320250618075805', '1446-12-21', '1.100.10', '101', 'an.UBAIDAH', '20000', '0', 'chuwez', '2025-06-18 14:58:05'),
('6400', 'ST10100320250618075805', '1446-12-21', '2.220.10', '101', 'an.UBAIDAH', '0', '20000', 'chuwez', '2025-06-18 14:58:06'),
('6401', 'ST10100320250618075823', '1446-12-21', '1.100.10', '101', 'an.NAILATUN NIAMI', '2000', '0', 'chuwez', '2025-06-18 14:58:23'),
('6402', 'ST10100320250618075823', '1446-12-21', '2.220.10', '101', 'an.NAILATUN NIAMI', '0', '2000', 'chuwez', '2025-06-18 14:58:23'),
('6403', 'ST10100320250618075840', '1446-12-21', '1.100.10', '101', 'an.MARIATUL QIBTIYAH', '2000', '0', 'chuwez', '2025-06-18 14:58:40'),
('6404', 'ST10100320250618075840', '1446-12-21', '2.220.10', '101', 'an.MARIATUL QIBTIYAH', '0', '2000', 'chuwez', '2025-06-18 14:58:40'),
('6405', 'ST10100320250618075857', '1446-12-21', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'chuwez', '2025-06-18 14:58:57'),
('6406', 'ST10100320250618075857', '1446-12-21', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'chuwez', '2025-06-18 14:58:57'),
('6407', 'ST10100320250618075913', '1446-12-21', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '5000', '0', 'chuwez', '2025-06-18 14:59:13'),
('6408', 'ST10100320250618075913', '1446-12-21', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '5000', 'chuwez', '2025-06-18 14:59:13'),
('6409', 'ST10100320250618075928', '1446-12-21', '1.100.10', '101', 'an.MUHAMMAD ALWI', '10000', '0', 'chuwez', '2025-06-18 14:59:28'),
('6410', 'ST10100320250618075928', '1446-12-21', '2.220.10', '101', 'an.MUHAMMAD ALWI', '0', '10000', 'chuwez', '2025-06-18 14:59:28'),
('6411', 'ST10100320250618075942', '1446-12-21', '1.100.10', '101', 'an.UMAR FARUQ', '5000', '0', 'chuwez', '2025-06-18 14:59:42'),
('6412', 'ST10100320250618075942', '1446-12-21', '2.220.10', '101', 'an.UMAR FARUQ', '0', '5000', 'chuwez', '2025-06-18 14:59:42'),
('6413', 'ST10100320250618075956', '1446-12-21', '1.100.10', '101', 'an.MARIYATUL QIBTIYAH', '5000', '0', 'chuwez', '2025-06-18 14:59:56'),
('6414', 'ST10100320250618075956', '1446-12-21', '2.220.10', '101', 'an.MARIYATUL QIBTIYAH', '0', '5000', 'chuwez', '2025-06-18 14:59:56'),
('6415', 'ST10100320250618080035', '1446-12-21', '1.100.10', '101', 'an.M. DESTRA MAULANA', '10000', '0', 'chuwez', '2025-06-18 15:00:35'),
('6416', 'ST10100320250618080035', '1446-12-21', '2.220.10', '101', 'an.M. DESTRA MAULANA', '0', '10000', 'chuwez', '2025-06-18 15:00:35'),
('6417', 'ST10100320250618080051', '1446-12-21', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '10000', '0', 'chuwez', '2025-06-18 15:00:51'),
('6418', 'ST10100320250618080051', '1446-12-21', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '10000', 'chuwez', '2025-06-18 15:00:51'),
('6419', 'ST10100320250618080103', '1446-12-21', '1.100.10', '101', 'an.AISYAH', '2000', '0', 'chuwez', '2025-06-18 15:01:03'),
('6420', 'ST10100320250618080103', '1446-12-21', '2.220.10', '101', 'an.AISYAH', '0', '2000', 'chuwez', '2025-06-18 15:01:03'),
('6421', 'ST10100320250618080119', '1446-12-21', '1.100.10', '101', 'an.ALFI NURDIANA', '5000', '0', 'chuwez', '2025-06-18 15:01:19'),
('6422', 'ST10100320250618080119', '1446-12-21', '2.220.10', '101', 'an.ALFI NURDIANA', '0', '5000', 'chuwez', '2025-06-18 15:01:19'),
('6423', 'ST10100320250618080133', '1446-12-21', '1.100.10', '101', 'an.AHMAD ADITIYA', '3000', '0', 'chuwez', '2025-06-18 15:01:33'),
('6424', 'ST10100320250618080133', '1446-12-21', '2.220.10', '101', 'an.AHMAD ADITIYA', '0', '3000', 'chuwez', '2025-06-18 15:01:33'),
('6425', 'ST10100320250618080145', '1446-12-21', '1.100.10', '101', 'an.AZKA AUFARIL MINAN', '10000', '0', 'chuwez', '2025-06-18 15:01:45'),
('6426', 'ST10100320250618080145', '1446-12-21', '2.220.10', '101', 'an.AZKA AUFARIL MINAN', '0', '10000', 'chuwez', '2025-06-18 15:01:45'),
('6427', 'ST10100320250618080223', '1446-12-21', '1.100.10', '101', 'an.ABDUL HAMID', '2000', '0', 'chuwez', '2025-06-18 15:02:23'),
('6428', 'ST10100320250618080223', '1446-12-21', '2.220.10', '101', 'an.ABDUL HAMID', '0', '2000', 'chuwez', '2025-06-18 15:02:23'),
('6429', 'ST10100320250618080238', '1446-12-21', '1.100.10', '101', 'an.WARDATUL JANNAH', '2000', '0', 'chuwez', '2025-06-18 15:02:38'),
('6430', 'ST10100320250618080238', '1446-12-21', '2.220.10', '101', 'an.WARDATUL JANNAH', '0', '2000', 'chuwez', '2025-06-18 15:02:38'),
('6431', 'ST10100320250618080251', '1446-12-21', '1.100.10', '101', 'an.DIYANAH KAMALIYAH', '5000', '0', 'chuwez', '2025-06-18 15:02:51'),
('6432', 'ST10100320250618080251', '1446-12-21', '2.220.10', '101', 'an.DIYANAH KAMALIYAH', '0', '5000', 'chuwez', '2025-06-18 15:02:51'),
('6433', 'ST10100320250618080308', '1446-12-21', '1.100.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '20000', '0', 'chuwez', '2025-06-18 15:03:08'),
('6434', 'ST10100320250618080308', '1446-12-21', '2.220.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '0', '20000', 'chuwez', '2025-06-18 15:03:08'),
('6435', 'ST10100320250618080324', '1446-12-21', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '10000', '0', 'chuwez', '2025-06-18 15:03:24'),
('6436', 'ST10100320250618080324', '1446-12-21', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '10000', 'chuwez', '2025-06-18 15:03:24'),
('6437', 'ST10100320250618080336', '1446-12-21', '1.100.10', '101', 'an.SITI ATHIUR ROHMAH', '5000', '0', 'chuwez', '2025-06-18 15:03:36'),
('6438', 'ST10100320250618080336', '1446-12-21', '2.220.10', '101', 'an.SITI ATHIUR ROHMAH', '0', '5000', 'chuwez', '2025-06-18 15:03:36'),
('6439', 'ST10100320250618080404', '1446-12-21', '1.100.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '5000', '0', 'chuwez', '2025-06-18 15:04:04'),
('6440', 'ST10100320250618080404', '1446-12-21', '2.220.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '0', '5000', 'chuwez', '2025-06-18 15:04:04'),
('6441', 'ST10100320250618080423', '1446-12-21', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '2000', '0', 'chuwez', '2025-06-18 15:04:23'),
('6442', 'ST10100320250618080423', '1446-12-21', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '2000', 'chuwez', '2025-06-18 15:04:23'),
('6443', 'ST10100320250618080439', '1446-12-21', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'chuwez', '2025-06-18 15:04:39'),
('6444', 'ST10100320250618080439', '1446-12-21', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'chuwez', '2025-06-18 15:04:39'),
('6445', 'ST10100320250618080454', '1446-12-21', '1.100.10', '101', 'an.MIFTAHUL JANNAH', '50000', '0', 'chuwez', '2025-06-18 15:04:54'),
('6446', 'ST10100320250618080454', '1446-12-21', '2.220.10', '101', 'an.MIFTAHUL JANNAH', '0', '50000', 'chuwez', '2025-06-18 15:04:54'),
('6447', 'ST10100320250618080511', '1446-12-21', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '5000', '0', 'chuwez', '2025-06-18 15:05:11'),
('6448', 'ST10100320250618080511', '1446-12-21', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '5000', 'chuwez', '2025-06-18 15:05:11'),
('6449', 'ST10100320250618080529', '1446-12-21', '1.100.10', '101', 'an.M. KAMALUDDIN', '10000', '0', 'chuwez', '2025-06-18 15:05:29'),
('6450', 'ST10100320250618080529', '1446-12-21', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '10000', 'chuwez', '2025-06-18 15:05:29'),
('6451', 'ST10100320250618080543', '1446-12-21', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '10000', '0', 'chuwez', '2025-06-18 15:05:43'),
('6452', 'ST10100320250618080543', '1446-12-21', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '10000', 'chuwez', '2025-06-18 15:05:43'),
('6453', 'ST10100320250618080628', '1446-12-21', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '30000', '0', 'chuwez', '2025-06-18 15:06:28'),
('6454', 'ST10100320250618080628', '1446-12-21', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '30000', 'chuwez', '2025-06-18 15:06:28'),
('6455', 'ST10100320250618080652', '1446-12-21', '1.100.10', '101', 'an.SINDI RAISA PUTRI', '10000', '0', 'chuwez', '2025-06-18 15:06:52'),
('6456', 'ST10100320250618080652', '1446-12-21', '2.220.10', '101', 'an.SINDI RAISA PUTRI', '0', '10000', 'chuwez', '2025-06-18 15:06:52'),
('6457', 'ST10100320250618080730', '1446-12-21', '1.100.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '10000', '0', 'chuwez', '2025-06-18 15:07:30'),
('6458', 'ST10100320250618080730', '1446-12-21', '2.220.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '0', '10000', 'chuwez', '2025-06-18 15:07:30'),
('6459', 'ST10100320250618080746', '1446-12-21', '1.100.10', '101', 'an.AHMAD ABBAS MAULANA', '4000', '0', 'chuwez', '2025-06-18 15:07:46'),
('6460', 'ST10100320250618080746', '1446-12-21', '2.220.10', '101', 'an.AHMAD ABBAS MAULANA', '0', '4000', 'chuwez', '2025-06-18 15:07:46'),
('6461', 'ST10100320250618080801', '1446-12-21', '1.100.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '5000', '0', 'chuwez', '2025-06-18 15:08:01'),
('6462', 'ST10100320250618080801', '1446-12-21', '2.220.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '0', '5000', 'chuwez', '2025-06-18 15:08:01'),
('6463', 'ST10100320250618080814', '1446-12-21', '1.100.10', '101', 'an.AKHMAD FIKRI HAIKAL', '50000', '0', 'chuwez', '2025-06-18 15:08:14'),
('6464', 'ST10100320250618080814', '1446-12-21', '2.220.10', '101', 'an.AKHMAD FIKRI HAIKAL', '0', '50000', 'chuwez', '2025-06-18 15:08:14'),
('6465', 'ST10100320250618080827', '1446-12-21', '1.100.10', '101', 'an.BILQIS THALIA HASNA', '75000', '0', 'chuwez', '2025-06-18 15:08:27'),
('6466', 'ST10100320250618080827', '1446-12-21', '2.220.10', '101', 'an.BILQIS THALIA HASNA', '0', '75000', 'chuwez', '2025-06-18 15:08:27'),
('6467', 'ST10100320250618080856', '1446-12-21', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '10000', '0', 'chuwez', '2025-06-18 15:08:56'),
('6468', 'ST10100320250618080856', '1446-12-21', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '10000', 'chuwez', '2025-06-18 15:08:56'),
('6469', 'ST10100320250618080909', '1446-12-21', '1.100.10', '101', 'an.MUHAMMAD KHOIRON', '5000', '0', 'chuwez', '2025-06-18 15:09:09'),
('6470', 'ST10100320250618080909', '1446-12-21', '2.220.10', '101', 'an.MUHAMMAD KHOIRON', '0', '5000', 'chuwez', '2025-06-18 15:09:09'),
('6471', 'ST10100320250618080923', '1446-12-21', '1.100.10', '101', 'an.ZAKIYATUL UMMAH', '2000', '0', 'chuwez', '2025-06-18 15:09:23'),
('6472', 'ST10100320250618080923', '1446-12-21', '2.220.10', '101', 'an.ZAKIYATUL UMMAH', '0', '2000', 'chuwez', '2025-06-18 15:09:23'),
('6473', 'ST10100320250618080935', '1446-12-21', '1.100.10', '101', 'an.AFANDI', '2000', '0', 'chuwez', '2025-06-18 15:09:35'),
('6474', 'ST10100320250618080935', '1446-12-21', '2.220.10', '101', 'an.AFANDI', '0', '2000', 'chuwez', '2025-06-18 15:09:36'),
('6475', 'ST10100320250618080947', '1446-12-21', '1.100.10', '101', 'an.ANA SALSABILA', '2000', '0', 'chuwez', '2025-06-18 15:09:47'),
('6476', 'ST10100320250618080947', '1446-12-21', '2.220.10', '101', 'an.ANA SALSABILA', '0', '2000', 'chuwez', '2025-06-18 15:09:47'),
('6477', 'ST10100320250618081013', '1446-12-21', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '2000', '0', 'chuwez', '2025-06-18 15:10:13'),
('6478', 'ST10100320250618081013', '1446-12-21', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '2000', 'chuwez', '2025-06-18 15:10:13'),
('6479', 'ST10100320250618081026', '1446-12-21', '1.100.10', '101', 'an.ROBIATUL ADAWIYAH', '5000', '0', 'chuwez', '2025-06-18 15:10:26'),
('6480', 'ST10100320250618081026', '1446-12-21', '2.220.10', '101', 'an.ROBIATUL ADAWIYAH', '0', '5000', 'chuwez', '2025-06-18 15:10:26'),
('6481', 'ST10100320250618081103', '1446-12-21', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '10000', '0', 'chuwez', '2025-06-18 15:11:03'),
('6482', 'ST10100320250618081103', '1446-12-21', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '10000', 'chuwez', '2025-06-18 15:11:03'),
('6483', 'ST10100320250618081120', '1446-12-21', '1.100.10', '101', 'an.SAFIRATUL JANNAH', '10000', '0', 'chuwez', '2025-06-18 15:11:20'),
('6484', 'ST10100320250618081120', '1446-12-21', '2.220.10', '101', 'an.SAFIRATUL JANNAH', '0', '10000', 'chuwez', '2025-06-18 15:11:20'),
('6485', 'ST10100320250618081233', '1446-12-21', '1.100.10', '101', 'an.MACHMUDAH', '5000', '0', 'chuwez', '2025-06-18 15:12:33'),
('6486', 'ST10100320250618081233', '1446-12-21', '2.220.10', '101', 'an.MACHMUDAH', '0', '5000', 'chuwez', '2025-06-18 15:12:33'),
('6487', 'ST10100320250618081247', '1446-12-21', '1.100.10', '101', 'an.HILYA', '20000', '0', 'chuwez', '2025-06-18 15:12:47'),
('6488', 'ST10100320250618081247', '1446-12-21', '2.220.10', '101', 'an.HILYA', '0', '20000', 'chuwez', '2025-06-18 15:12:47'),
('6489', 'ST10100320250618081302', '1446-12-21', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'chuwez', '2025-06-18 15:13:02'),
('6490', 'ST10100320250618081302', '1446-12-21', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'chuwez', '2025-06-18 15:13:02'),
('6491', 'BS10100320250618082514000', '1446-10-21', '1.100.10', '101', 'Bayar[MUHAMMAD KHOIRON]', '30000', '0', 'chuwez', '2025-06-18 08:25:14'),
('6492', 'BS10100320250618082514000', '1446-10-21', '4.400.20', '101', 'Bayar[MUHAMMAD KHOIRON]', '0', '30000', 'chuwez', '2025-06-18 08:25:14'),
('6493', 'BS10100320250618082514001', '1446-11-21', '1.100.10', '101', 'Bayar[MUHAMMAD KHOIRON]', '30000', '0', 'chuwez', '2025-06-18 08:25:14'),
('6494', 'BS10100320250618082514001', '1446-11-21', '4.400.20', '101', 'Bayar[MUHAMMAD KHOIRON]', '0', '30000', 'chuwez', '2025-06-18 08:25:14'),
('6495', 'BS10100320250618082514002', '1446-12-21', '1.100.10', '101', 'Bayar[MUHAMMAD KHOIRON]', '30000', '0', 'chuwez', '2025-06-18 08:25:14'),
('6496', 'BS10100320250618082514002', '1446-12-21', '4.400.20', '101', 'Bayar[MUHAMMAD KHOIRON]', '0', '30000', 'chuwez', '2025-06-18 08:25:14'),
('6497', 'BS10100320250618082548000', '1446-11-21', '1.100.10', '101', 'Bayar[MUTHIMATUS SHOLIHAH]', '30000', '0', 'chuwez', '2025-06-18 08:25:48'),
('6498', 'BS10100320250618082548000', '1446-11-21', '4.400.20', '101', 'Bayar[MUTHIMATUS SHOLIHAH]', '0', '30000', 'chuwez', '2025-06-18 08:25:48'),
('6499', 'BS10100320250618082548001', '1446-12-21', '1.100.10', '101', 'Bayar[MUTHIMATUS SHOLIHAH]', '30000', '0', 'chuwez', '2025-06-18 08:25:48'),
('6500', 'BS10100320250618082548001', '1446-12-21', '4.400.20', '101', 'Bayar[MUTHIMATUS SHOLIHAH]', '0', '30000', 'chuwez', '2025-06-18 08:25:48'),
('6501', 'BS10100320250618082613000', '1446-11-21', '1.100.10', '101', 'Bayar[A. KHOIRUN NIZAM]', '30000', '0', 'chuwez', '2025-06-18 08:26:13'),
('6502', 'BS10100320250618082613000', '1446-11-21', '4.400.20', '101', 'Bayar[A. KHOIRUN NIZAM]', '0', '30000', 'chuwez', '2025-06-18 08:26:13'),
('6503', 'BS10100320250618082644000', '1446-11-21', '1.100.10', '101', 'Bayar[MUHAMMAD ARDIANSYAH]', '30000', '0', 'chuwez', '2025-06-18 08:26:44'),
('6504', 'BS10100320250618082644000', '1446-11-21', '4.400.20', '101', 'Bayar[MUHAMMAD ARDIANSYAH]', '0', '30000', 'chuwez', '2025-06-18 08:26:44'),
('6505', 'BS10100320250618082715000', '1446-12-21', '1.100.10', '101', 'Bayar[WARDATUL JANNAH]', '30000', '0', 'chuwez', '2025-06-18 08:27:15'),
('6506', 'BS10100320250618082715000', '1446-12-21', '4.400.20', '101', 'Bayar[WARDATUL JANNAH]', '0', '30000', 'chuwez', '2025-06-18 08:27:15'),
('6507', 'ST10100320250619083000', '1446-12-22', '1.100.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '5000', '0', 'Chuwez', '2025-06-19 15:30:00'),
('6508', 'ST10100320250619083000', '1446-12-22', '2.220.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '0', '5000', 'Chuwez', '2025-06-19 15:30:00'),
('6509', 'ST10100320250619083014', '1446-12-22', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'Chuwez', '2025-06-19 15:30:14'),
('6510', 'ST10100320250619083014', '1446-12-22', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'Chuwez', '2025-06-19 15:30:14'),
('6511', 'ST10100320250619083028', '1446-12-22', '1.100.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '2000', '0', 'Chuwez', '2025-06-19 15:30:28'),
('6512', 'ST10100320250619083028', '1446-12-22', '2.220.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '0', '2000', 'Chuwez', '2025-06-19 15:30:28'),
('6513', 'ST10100320250619083045', '1446-12-22', '1.100.10', '101', 'an.AULIA AZZAHRA', '10000', '0', 'Chuwez', '2025-06-19 15:30:45'),
('6514', 'ST10100320250619083045', '1446-12-22', '2.220.10', '101', 'an.AULIA AZZAHRA', '0', '10000', 'Chuwez', '2025-06-19 15:30:45'),
('6515', 'ST10100320250619083059', '1446-12-22', '1.100.10', '101', 'an.NAURA BILADINA', '5000', '0', 'Chuwez', '2025-06-19 15:30:59'),
('6516', 'ST10100320250619083059', '1446-12-22', '2.220.10', '101', 'an.NAURA BILADINA', '0', '5000', 'Chuwez', '2025-06-19 15:30:59'),
('6517', 'ST10100320250619083116', '1446-12-22', '1.100.10', '101', 'an.M. ABD. HADI', '2000', '0', 'Chuwez', '2025-06-19 15:31:16'),
('6518', 'ST10100320250619083116', '1446-12-22', '2.220.10', '101', 'an.M. ABD. HADI', '0', '2000', 'Chuwez', '2025-06-19 15:31:16'),
('6519', 'ST10100320250619083133', '1446-12-22', '1.100.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '10000', '0', 'Chuwez', '2025-06-19 15:31:33'),
('6520', 'ST10100320250619083133', '1446-12-22', '2.220.10', '101', 'an.ACHMAD ZAFRAN SHINAGA', '0', '10000', 'Chuwez', '2025-06-19 15:31:33'),
('6521', 'ST10100320250619083146', '1446-12-22', '1.100.10', '101', 'an.HAIKAL SHOMADANI', '2000', '0', 'Chuwez', '2025-06-19 15:31:47'),
('6522', 'ST10100320250619083146', '1446-12-22', '2.220.10', '101', 'an.HAIKAL SHOMADANI', '0', '2000', 'Chuwez', '2025-06-19 15:31:47'),
('6523', 'ST10100320250619083207', '1446-12-22', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '10000', '0', 'Chuwez', '2025-06-19 15:32:07'),
('6524', 'ST10100320250619083207', '1446-12-22', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '10000', 'Chuwez', '2025-06-19 15:32:07'),
('6525', 'ST10100320250619083231', '1446-12-22', '1.100.10', '101', 'an.SAUQY AHMAD', '10000', '0', 'Chuwez', '2025-06-19 15:32:31'),
('6526', 'ST10100320250619083231', '1446-12-22', '2.220.10', '101', 'an.SAUQY AHMAD', '0', '10000', 'Chuwez', '2025-06-19 15:32:31'),
('6527', 'ST10100320250619083250', '1446-12-22', '1.100.10', '101', 'an.MARIATUL QIBTIYAH', '2000', '0', 'Chuwez', '2025-06-19 15:32:50'),
('6528', 'ST10100320250619083250', '1446-12-22', '2.220.10', '101', 'an.MARIATUL QIBTIYAH', '0', '2000', 'Chuwez', '2025-06-19 15:32:50'),
('6529', 'ST10100320250619083307', '1446-12-22', '1.100.10', '101', 'an.RAISA ANNISA', '5000', '0', 'Chuwez', '2025-06-19 15:33:07'),
('6530', 'ST10100320250619083307', '1446-12-22', '2.220.10', '101', 'an.RAISA ANNISA', '0', '5000', 'Chuwez', '2025-06-19 15:33:07'),
('6531', 'ST10100320250619083329', '1446-12-22', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'Chuwez', '2025-06-19 15:33:29'),
('6532', 'ST10100320250619083329', '1446-12-22', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'Chuwez', '2025-06-19 15:33:29'),
('6533', 'ST10100320250619083348', '1446-12-22', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '5000', '0', 'Chuwez', '2025-06-19 15:33:48'),
('6534', 'ST10100320250619083348', '1446-12-22', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '5000', 'Chuwez', '2025-06-19 15:33:48'),
('6535', 'ST10100320250619083415', '1446-12-22', '1.100.10', '101', 'an.MUHAMMAD ALWI', '10000', '0', 'Chuwez', '2025-06-19 15:34:15'),
('6536', 'ST10100320250619083415', '1446-12-22', '2.220.10', '101', 'an.MUHAMMAD ALWI', '0', '10000', 'Chuwez', '2025-06-19 15:34:15'),
('6537', 'ST10100320250619083428', '1446-12-22', '1.100.10', '101', 'an.UMAR FARUQ', '5000', '0', 'Chuwez', '2025-06-19 15:34:28'),
('6538', 'ST10100320250619083428', '1446-12-22', '2.220.10', '101', 'an.UMAR FARUQ', '0', '5000', 'Chuwez', '2025-06-19 15:34:28'),
('6539', 'ST10100320250619083443', '1446-12-22', '1.100.10', '101', 'an.MARIYATUL QIBTIYAH', '5000', '0', 'Chuwez', '2025-06-19 15:34:43'),
('6540', 'ST10100320250619083443', '1446-12-22', '2.220.10', '101', 'an.MARIYATUL QIBTIYAH', '0', '5000', 'Chuwez', '2025-06-19 15:34:43'),
('6541', 'ST10100320250619083503', '1446-12-22', '1.100.10', '101', 'an.HILYA', '20000', '0', 'Chuwez', '2025-06-19 15:35:03'),
('6542', 'ST10100320250619083503', '1446-12-22', '2.220.10', '101', 'an.HILYA', '0', '20000', 'Chuwez', '2025-06-19 15:35:03'),
('6543', 'ST10100320250619083707', '1446-12-22', '1.100.10', '101', 'an.AZKA AUFARIL MINAN', '10000', '0', 'Chuwez', '2025-06-19 15:37:07'),
('6544', 'ST10100320250619083707', '1446-12-22', '2.220.10', '101', 'an.AZKA AUFARIL MINAN', '0', '10000', 'Chuwez', '2025-06-19 15:37:07'),
('6545', 'ST10100320250619083739', '1446-12-22', '1.100.10', '101', 'an.ALFI NURDIANA', '5000', '0', 'Chuwez', '2025-06-19 15:37:39'),
('6546', 'ST10100320250619083739', '1446-12-22', '2.220.10', '101', 'an.ALFI NURDIANA', '0', '5000', 'Chuwez', '2025-06-19 15:37:39'),
('6547', 'ST10100320250619083758', '1446-12-22', '1.100.10', '101', 'an.AISYAH', '5000', '0', 'Chuwez', '2025-06-19 15:37:58'),
('6548', 'ST10100320250619083758', '1446-12-22', '2.220.10', '101', 'an.AISYAH', '0', '5000', 'Chuwez', '2025-06-19 15:37:58'),
('6549', 'ST10100320250619083842', '1446-12-22', '1.100.10', '101', 'an.M. DESTRA MAULANA', '5000', '0', 'Chuwez', '2025-06-19 15:38:42'),
('6550', 'ST10100320250619083842', '1446-12-22', '2.220.10', '101', 'an.M. DESTRA MAULANA', '0', '5000', 'Chuwez', '2025-06-19 15:38:42'),
('6551', 'ST10100320250619083903', '1446-12-22', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '10000', '0', 'Chuwez', '2025-06-19 15:39:03'),
('6552', 'ST10100320250619083903', '1446-12-22', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '10000', 'Chuwez', '2025-06-19 15:39:03'),
('6553', 'ST10100320250619084024', '1446-12-22', '1.100.10', '101', 'an.M. FAHMI NURUL ANAM', '10000', '0', 'Chuwez', '2025-06-19 15:40:24'),
('6554', 'ST10100320250619084024', '1446-12-22', '2.220.10', '101', 'an.M. FAHMI NURUL ANAM', '0', '10000', 'Chuwez', '2025-06-19 15:40:24'),
('6555', 'ST10100320250619084037', '1446-12-22', '1.100.10', '101', 'an.DIYANAH KAMALIYAH', '5000', '0', 'Chuwez', '2025-06-19 15:40:37'),
('6556', 'ST10100320250619084037', '1446-12-22', '2.220.10', '101', 'an.DIYANAH KAMALIYAH', '0', '5000', 'Chuwez', '2025-06-19 15:40:37'),
('6557', 'ST10100320250619084055', '1446-12-22', '1.100.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '10000', '0', 'Chuwez', '2025-06-19 15:40:55'),
('6558', 'ST10100320250619084055', '1446-12-22', '2.220.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '0', '10000', 'Chuwez', '2025-06-19 15:40:55'),
('6559', 'ST10100320250619084110', '1446-12-22', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '10000', '0', 'Chuwez', '2025-06-19 15:41:10'),
('6560', 'ST10100320250619084110', '1446-12-22', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '10000', 'Chuwez', '2025-06-19 15:41:10'),
('6561', 'ST10100320250619084127', '1446-12-22', '1.100.10', '101', 'an.SITI QURROTUL AINI', '2000', '0', 'Chuwez', '2025-06-19 15:41:27'),
('6562', 'ST10100320250619084127', '1446-12-22', '2.220.10', '101', 'an.SITI QURROTUL AINI', '0', '2000', 'Chuwez', '2025-06-19 15:41:27'),
('6563', 'ST10100320250619084144', '1446-12-22', '1.100.10', '101', 'an.ABDUL HAMID', '2000', '0', 'Chuwez', '2025-06-19 15:41:44'),
('6564', 'ST10100320250619084144', '1446-12-22', '2.220.10', '101', 'an.ABDUL HAMID', '0', '2000', 'Chuwez', '2025-06-19 15:41:44'),
('6565', 'ST10100320250619084212', '1446-12-22', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '2000', '0', 'Chuwez', '2025-06-19 15:42:12'),
('6566', 'ST10100320250619084212', '1446-12-22', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '2000', 'Chuwez', '2025-06-19 15:42:12'),
('6569', 'ST10100320250619084239', '1446-12-22', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Chuwez', '2025-06-19 15:42:39'),
('6570', 'ST10100320250619084239', '1446-12-22', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Chuwez', '2025-06-19 15:42:39'),
('6571', 'ST10100320250619084257', '1446-12-22', '1.100.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '10000', '0', 'Chuwez', '2025-06-19 15:42:57'),
('6572', 'ST10100320250619084257', '1446-12-22', '2.220.10', '101', 'an.AFIKA APRILIA ULKIFAYA', '0', '10000', 'Chuwez', '2025-06-19 15:42:57'),
('6573', 'ST10100320250619084311', '1446-12-22', '1.100.10', '101', 'an.M. KAMALUDDIN', '10000', '0', 'Chuwez', '2025-06-19 15:43:11'),
('6574', 'ST10100320250619084311', '1446-12-22', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '10000', 'Chuwez', '2025-06-19 15:43:11'),
('6575', 'ST10100320250619084330', '1446-12-22', '1.100.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '5000', '0', 'Chuwez', '2025-06-19 15:43:30'),
('6576', 'ST10100320250619084330', '1446-12-22', '2.220.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '0', '5000', 'Chuwez', '2025-06-19 15:43:30'),
('6577', 'ST10100320250619084347', '1446-12-22', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '5000', '0', 'Chuwez', '2025-06-19 15:43:47'),
('6578', 'ST10100320250619084347', '1446-12-22', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '5000', 'Chuwez', '2025-06-19 15:43:47'),
('6579', 'ST10100320250619084418', '1446-12-22', '1.100.10', '101', 'an.AKHMAD FIKRI HAIKAL', '50000', '0', 'Chuwez', '2025-06-19 15:44:18'),
('6580', 'ST10100320250619084418', '1446-12-22', '2.220.10', '101', 'an.AKHMAD FIKRI HAIKAL', '0', '50000', 'Chuwez', '2025-06-19 15:44:18'),
('6581', 'ST10100320250619084441', '1446-12-22', '1.100.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '5000', '0', 'Chuwez', '2025-06-19 15:44:41'),
('6582', 'ST10100320250619084441', '1446-12-22', '2.220.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '0', '5000', 'Chuwez', '2025-06-19 15:44:41'),
('6583', 'ST10100320250619084455', '1446-12-22', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '25000', '0', 'Chuwez', '2025-06-19 15:44:55'),
('6584', 'ST10100320250619084455', '1446-12-22', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '25000', 'Chuwez', '2025-06-19 15:44:55'),
('6585', 'ST10100320250619084508', '1446-12-22', '1.100.10', '101', 'an.AHMAD ABBAS MAULANA', '5000', '0', 'Chuwez', '2025-06-19 15:45:08'),
('6586', 'ST10100320250619084508', '1446-12-22', '2.220.10', '101', 'an.AHMAD ABBAS MAULANA', '0', '5000', 'Chuwez', '2025-06-19 15:45:08'),
('6587', 'ST10100320250619084530', '1446-12-22', '1.100.10', '101', 'an.SINDI RAISA PUTRI', '10000', '0', 'Chuwez', '2025-06-19 15:45:30'),
('6588', 'ST10100320250619084530', '1446-12-22', '2.220.10', '101', 'an.SINDI RAISA PUTRI', '0', '10000', 'Chuwez', '2025-06-19 15:45:30'),
('6589', 'ST10100320250619084546', '1446-12-22', '1.100.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '10000', '0', 'Chuwez', '2025-06-19 15:45:46'),
('6590', 'ST10100320250619084546', '1446-12-22', '2.220.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '0', '10000', 'Chuwez', '2025-06-19 15:45:46'),
('6591', 'ST10100320250619084603', '1446-12-22', '1.100.10', '101', 'an.M. HAIKAL NASRULLOH', '5000', '0', 'Chuwez', '2025-06-19 15:46:03'),
('6592', 'ST10100320250619084603', '1446-12-22', '2.220.10', '101', 'an.M. HAIKAL NASRULLOH', '0', '5000', 'Chuwez', '2025-06-19 15:46:03'),
('6593', 'ST10100320250619084618', '1446-12-22', '1.100.10', '101', 'an.BILQIS THALIA HASNA', '75000', '0', 'Chuwez', '2025-06-19 15:46:18'),
('6594', 'ST10100320250619084618', '1446-12-22', '2.220.10', '101', 'an.BILQIS THALIA HASNA', '0', '75000', 'Chuwez', '2025-06-19 15:46:18'),
('6595', 'ST10100320250619084639', '1446-12-22', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '5000', '0', 'Chuwez', '2025-06-19 15:46:39'),
('6596', 'ST10100320250619084639', '1446-12-22', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '5000', 'Chuwez', '2025-06-19 15:46:39'),
('6597', 'ST10100320250619084658', '1446-12-22', '1.100.10', '101', 'an.ZAKIYATUL UMMAH', '2000', '0', 'Chuwez', '2025-06-19 15:46:58'),
('6598', 'ST10100320250619084658', '1446-12-22', '2.220.10', '101', 'an.ZAKIYATUL UMMAH', '0', '2000', 'Chuwez', '2025-06-19 15:46:58'),
('6599', 'ST10100320250619084716', '1446-12-22', '1.100.10', '101', 'an.MUHAMMAD KHOIRON', '5000', '0', 'Chuwez', '2025-06-19 15:47:16'),
('6600', 'ST10100320250619084716', '1446-12-22', '2.220.10', '101', 'an.MUHAMMAD KHOIRON', '0', '5000', 'Chuwez', '2025-06-19 15:47:16'),
('6601', 'ST10100320250619084731', '1446-12-22', '1.100.10', '101', 'an.ANA SALSABILA', '2000', '0', 'Chuwez', '2025-06-19 15:47:31'),
('6602', 'ST10100320250619084731', '1446-12-22', '2.220.10', '101', 'an.ANA SALSABILA', '0', '2000', 'Chuwez', '2025-06-19 15:47:31'),
('6603', 'ST10100320250619084746', '1446-12-22', '1.100.10', '101', 'an.AFANDI', '2000', '0', 'Chuwez', '2025-06-19 15:47:46'),
('6604', 'ST10100320250619084746', '1446-12-22', '2.220.10', '101', 'an.AFANDI', '0', '2000', 'Chuwez', '2025-06-19 15:47:46'),
('6605', 'ST10100320250619084801', '1446-12-22', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '10000', '0', 'Chuwez', '2025-06-19 15:48:01'),
('6606', 'ST10100320250619084801', '1446-12-22', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '10000', 'Chuwez', '2025-06-19 15:48:01'),
('6607', 'ST10100320250619084821', '1446-12-22', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '10000', '0', 'Chuwez', '2025-06-19 15:48:21'),
('6608', 'ST10100320250619084821', '1446-12-22', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '10000', 'Chuwez', '2025-06-19 15:48:21'),
('6609', 'ST10100320250619084834', '1446-12-22', '1.100.10', '101', 'an.SAFIRATUL JANNAH', '10000', '0', 'Chuwez', '2025-06-19 15:48:35'),
('6610', 'ST10100320250619084834', '1446-12-22', '2.220.10', '101', 'an.SAFIRATUL JANNAH', '0', '10000', 'Chuwez', '2025-06-19 15:48:35'),
('6611', 'ST10100320250619084855', '1446-12-22', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'Chuwez', '2025-06-19 15:48:55'),
('6612', 'ST10100320250619084855', '1446-12-22', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'Chuwez', '2025-06-19 15:48:55'),
('6613', 'ST10100320250619085431', '1446-12-22', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '10000', '0', 'Chuwez', '2025-06-19 15:54:31'),
('6614', 'ST10100320250619085431', '1446-12-22', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '10000', 'Chuwez', '2025-06-19 15:54:31'),
('6615', 'BS10100320250619085831000', '1446-12-22', '1.100.10', '101', 'Bayar[MARIATUL QIBTIYAH]', '30000', '0', 'Chuwez', '2025-06-19 08:58:31'),
('6616', 'BS10100320250619085831000', '1446-12-22', '4.400.20', '101', 'Bayar[MARIATUL QIBTIYAH]', '0', '30000', 'Chuwez', '2025-06-19 08:58:31'),
('6617', 'BS10100320250619085831001', '1447-01-22', '1.100.10', '101', 'Bayar[MARIATUL QIBTIYAH]', '30000', '0', 'Chuwez', '2025-06-19 08:58:31'),
('6618', 'BS10100320250619085831001', '1447-01-22', '4.400.20', '101', 'Bayar[MARIATUL QIBTIYAH]', '0', '30000', 'Chuwez', '2025-06-19 08:58:31'),
('6619', 'BS10100320250619085902000', '1446-12-22', '1.100.10', '101', 'Bayar[MUHAMMAD KANZUL KAROMI]', '30000', '0', 'Chuwez', '2025-06-19 08:59:02'),
('6620', 'BS10100320250619085902000', '1446-12-22', '4.400.20', '101', 'Bayar[MUHAMMAD KANZUL KAROMI]', '0', '30000', 'Chuwez', '2025-06-19 08:59:02'),
('6621', 'D110100320250619090121', '1446-12-22', '1.100.10', '101', 'Bayar[AHMAD AZAIM IBRAHIMI]', '35000', '0', 'Chuwez', '2025-06-19 09:01:21'),
('6622', 'D110100320250619090121', '1446-12-22', '4.400.22', '101', 'Bayar[AHMAD AZAIM IBRAHIMI]', '0', '35000', 'Chuwez', '2025-06-19 09:01:21'),
('6623', 'D110100320250619090212', '1446-12-22', '1.100.10', '101', 'Bayar[SAUQY AHMAD]', '20000', '0', 'Chuwez', '2025-06-19 09:02:12'),
('6624', 'D110100320250619090212', '1446-12-22', '4.400.22', '101', 'Bayar[SAUQY AHMAD]', '0', '20000', 'Chuwez', '2025-06-19 09:02:12'),
('6625', 'KI10100220250619154004', '1446-12-22', '1.100.10', '101', 'Lunas[MOCHAMMAD TAUFIK ALI KURNIAWAN]', '139000', '0', 'Ipul', '2025-06-19 15:40:04'),
('6626', 'KI10100220250619154004', '1446-12-22', '4.400.21', '101', 'Lunas[MOCHAMMAD TAUFIK ALI KURNIAWAN]', '0', '139000', 'Ipul', '2025-06-19 15:40:04'),
('6627', 'KI10100220250619154105', '1446-12-22', '1.100.10', '101', 'Lunas[MUCHAMAD RAFIE FAWWAZI]', '139000', '0', 'Ipul', '2025-06-19 15:41:05'),
('6628', 'KI10100220250619154105', '1446-12-22', '4.400.21', '101', 'Lunas[MUCHAMAD RAFIE FAWWAZI]', '0', '139000', 'Ipul', '2025-06-19 15:41:05'),
('6629', 'KI10100220250619154206', '1446-12-22', '1.100.10', '101', 'Lunas[PUTRI MAULIDATUL IMANIA]', '139000', '0', 'Ipul', '2025-06-19 15:42:06'),
('6630', 'KI10100220250619154206', '1446-12-22', '4.400.21', '101', 'Lunas[PUTRI MAULIDATUL IMANIA]', '0', '139000', 'Ipul', '2025-06-19 15:42:06'),
('6631', 'KI10100220250619154318', '1446-12-22', '1.100.10', '101', 'Lunas[ELOK WARDATUN NAFISAH]', '139000', '0', 'Ipul', '2025-06-19 15:43:18'),
('6632', 'KI10100220250619154318', '1446-12-22', '4.400.21', '101', 'Lunas[ELOK WARDATUN NAFISAH]', '0', '139000', 'Ipul', '2025-06-19 15:43:18'),
('6633', 'KI10100220250427163119009', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab jilid 1', '129000', '0', 'Ipul', '2025-06-19 22:44:28'),
('6634', 'KI10100220250427163119009', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab jilid 1', '0', '129000', 'Ipul', '2025-06-19 22:44:28'),
('6635', 'KI10100220250619154455', '1446-12-22', '1.100.10', '101', 'Lunas[NAURA BILADINA]', '129000', '0', 'Ipul', '2025-06-19 15:44:55'),
('6636', 'KI10100220250619154455', '1446-12-22', '4.400.21', '101', 'Lunas[NAURA BILADINA]', '0', '129000', 'Ipul', '2025-06-19 15:44:55'),
('6637', 'KI10100220250427163119006', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Pra TK, Jilid 1 dan Materi Tambahan', '99000', '0', 'Ipul', '2025-06-19 22:46:27'),
('6638', 'KI10100220250427163119006', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Pra TK, Jilid 1 dan Materi Tambahan', '0', '99000', 'Ipul', '2025-06-19 22:46:27'),
('6639', 'KI10100220250619154653', '1446-12-22', '1.100.10', '101', 'Lunas[MUHAMMAD NAZHIRUL ASROFI]', '99000', '0', 'Ipul', '2025-06-19 15:46:53'),
('6640', 'KI10100220250619154653', '1446-12-22', '4.400.21', '101', 'Lunas[MUHAMMAD NAZHIRUL ASROFI]', '0', '99000', 'Ipul', '2025-06-19 15:46:53'),
('6641', 'KI10100220250427163119011', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab jilid 1', '129000', '0', 'Ipul', '2025-06-19 22:47:56'),
('6642', 'KI10100220250427163119011', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab jilid 1', '0', '129000', 'Ipul', '2025-06-19 22:47:56'),
('6643', 'KI10100220250619154823', '1446-12-22', '1.100.10', '101', 'Lunas[SALWA LAILI]', '129000', '0', 'Ipul', '2025-06-19 15:48:23'),
('6644', 'KI10100220250619154823', '1446-12-22', '4.400.21', '101', 'Lunas[SALWA LAILI]', '0', '129000', 'Ipul', '2025-06-19 15:48:23'),
('6645', 'KI10100220250427163119007', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab jilid 1', '129000', '0', 'Ipul', '2025-06-19 22:49:28'),
('6646', 'KI10100220250427163119007', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab jilid 1', '0', '129000', 'Ipul', '2025-06-19 22:49:28'),
('6647', 'KI10100220250619154952', '1446-12-22', '1.100.10', '101', 'Lunas[AULIA AZZAHRA]', '129000', '0', 'Ipul', '2025-06-19 15:49:52'),
('6648', 'KI10100220250619154952', '1446-12-22', '4.400.21', '101', 'Lunas[AULIA AZZAHRA]', '0', '129000', 'Ipul', '2025-06-19 15:49:52'),
('6649', 'MB10100220250619160016', '1446-12-22', '1.100.10', '101', 'Daftar murid baru.101.000117', '20000', '0', 'Ipul', '2025-06-19 16:00:16'),
('6650', 'MB10100220250619160016', '1446-12-22', '4.400.10', '101', 'Daftar murid baru.101.000117', '0', '20000', 'Ipul', '2025-06-19 16:00:16'),
('6651', 'KI10100220250619161516', '1446-12-22', '1.100.10', '101', 'Bayar[ABDUL ALIM]', '50000', '0', 'Ipul', '2025-06-19 16:15:16'),
('6652', 'KI10100220250619161516', '1446-12-22', '4.400.21', '101', 'Bayar[ABDUL ALIM]', '0', '50000', 'Ipul', '2025-06-19 16:15:16'),
('6653', 'KI10100220250427163119000', '1446-10-28', '1.200.10', '101', 'Tidak beli Pra  TK, Jilid 1, Materi Tambahan, Pego dan Map Raport', '64000', '0', 'Ipul', '2025-06-19 23:21:55'),
('6654', 'KI10100220250427163119000', '1446-10-28', '4.100.30', '101', 'Tidak beli Pra  TK, Jilid 1, Materi Tambahan, Pego dan Map Raport', '0', '64000', 'Ipul', '2025-06-19 23:21:55'),
('6655', 'KI10100220250619162214', '1446-12-22', '1.100.10', '101', 'Lunas[HAIKAL SHOMADANI]', '64000', '0', 'Ipul', '2025-06-19 16:22:14'),
('6656', 'KI10100220250619162214', '1446-12-22', '4.400.21', '101', 'Lunas[HAIKAL SHOMADANI]', '0', '64000', 'Ipul', '2025-06-19 16:22:14'),
('6657', 'KI10100220250427163119001', '1446-10-28', '1.200.10', '101', 'Tidak beli Pra TK, Jilid 1, Materi Tambahan, BHS Arab, Pego dan Map Raport', '54000', '0', 'Ipul', '2025-06-19 23:23:42'),
('6658', 'KI10100220250427163119001', '1446-10-28', '4.100.30', '101', 'Tidak beli Pra TK, Jilid 1, Materi Tambahan, BHS Arab, Pego dan Map Raport', '0', '54000', 'Ipul', '2025-06-19 23:23:42'),
('6659', 'KI10100220250619162403', '1446-12-22', '1.100.10', '101', 'Lunas[MOCH.ANDIE FIRMANSYAH]', '54000', '0', 'Ipul', '2025-06-19 16:24:03'),
('6660', 'KI10100220250619162403', '1446-12-22', '4.400.21', '101', 'Lunas[MOCH.ANDIE FIRMANSYAH]', '0', '54000', 'Ipul', '2025-06-19 16:24:03'),
('6661', 'KI10100220250427163143017', '1446-10-28', '1.200.10', '101', 'Tidak beli jilid 2, 3 , Pego dan BHS Arab', '20000', '0', 'Ipul', '2025-06-19 23:34:25'),
('6662', 'KI10100220250427163143017', '1446-10-28', '4.100.30', '101', 'Tidak beli jilid 2, 3 , Pego dan BHS Arab', '0', '20000', 'Ipul', '2025-06-19 23:34:25'),
('6663', 'KI10100220250619163448', '1446-12-22', '1.100.10', '101', 'Lunas[ROFIQOTUS SARIROH]', '20000', '0', 'Ipul', '2025-06-19 16:34:48'),
('6664', 'KI10100220250619163448', '1446-12-22', '4.400.21', '101', 'Lunas[ROFIQOTUS SARIROH]', '0', '20000', 'Ipul', '2025-06-19 16:34:48'),
('6665', 'KI10100220250427163143006', '1446-10-28', '1.200.10', '101', 'Tidak beli jilid 2, 3 , Materi Tambahan dan BHS Arab', '20000', '0', 'Ipul', '2025-06-19 23:36:42'),
('6666', 'KI10100220250427163143006', '1446-10-28', '4.100.30', '101', 'Tidak beli jilid 2, 3 , Materi Tambahan dan BHS Arab', '0', '20000', 'Ipul', '2025-06-19 23:36:42'),
('6667', 'KI10100220250619163704', '1446-12-22', '1.100.10', '101', 'Lunas[MUHAMMAD RIFQIL MAMUN]', '20000', '0', 'Ipul', '2025-06-19 16:37:04'),
('6668', 'KI10100220250619163704', '1446-12-22', '4.400.21', '101', 'Lunas[MUHAMMAD RIFQIL MAMUN]', '0', '20000', 'Ipul', '2025-06-19 16:37:04'),
('6669', 'KI10100220250427163143012', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab BHS Arab', '49000', '0', 'Ipul', '2025-06-19 23:38:15'),
('6670', 'KI10100220250427163143012', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab BHS Arab', '0', '49000', 'Ipul', '2025-06-19 23:38:15'),
('6671', 'KI10100220250619163853', '1446-12-22', '1.100.10', '101', 'Lunas[MARIATUL QIBTIYAH]', '49000', '0', 'Ipul', '2025-06-19 16:38:53'),
('6672', 'KI10100220250619163853', '1446-12-22', '4.400.21', '101', 'Lunas[MARIATUL QIBTIYAH]', '0', '49000', 'Ipul', '2025-06-19 16:38:53'),
('6673', 'KI10100220250427163143009', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab BHS Arab', '49000', '0', 'Ipul', '2025-06-19 23:39:53'),
('6674', 'KI10100220250427163143009', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab BHS Arab', '0', '49000', 'Ipul', '2025-06-19 23:39:53'),
('6675', 'KI10100220250619164018', '1446-12-22', '1.100.10', '101', 'Lunas[UMAR FARUQ]', '49000', '0', 'Ipul', '2025-06-19 16:40:18'),
('6676', 'KI10100220250619164018', '1446-12-22', '4.400.21', '101', 'Lunas[UMAR FARUQ]', '0', '49000', 'Ipul', '2025-06-19 16:40:18'),
('6677', 'KI10100220250427163143004', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab BHS Arab', '49000', '0', 'Ipul', '2025-06-19 23:41:08'),
('6678', 'KI10100220250427163143004', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab BHS Arab', '0', '49000', 'Ipul', '2025-06-19 23:41:08'),
('6679', 'KI10100220250619164131', '1446-12-22', '1.100.10', '101', 'Lunas[MUHAMMAD ALWI]', '49000', '0', 'Ipul', '2025-06-19 16:41:31'),
('6680', 'KI10100220250619164131', '1446-12-22', '4.400.21', '101', 'Lunas[MUHAMMAD ALWI]', '0', '49000', 'Ipul', '2025-06-19 16:41:31'),
('6681', 'KI10100220250427163143008', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab BHS Arab', '49000', '0', 'Ipul', '2025-06-19 23:42:33'),
('6682', 'KI10100220250427163143008', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab BHS Arab', '0', '49000', 'Ipul', '2025-06-19 23:42:33'),
('6685', 'KI10100220250427163143007', '1446-10-28', '1.200.10', '101', 'Tidak beli jilid 2, 3 dan BHS Arab', '29000', '0', 'Ipul', '2025-06-19 23:48:03'),
('6686', 'KI10100220250427163143007', '1446-10-28', '4.100.30', '101', 'Tidak beli jilid 2, 3 dan BHS Arab', '0', '29000', 'Ipul', '2025-06-19 23:48:03'),
('6687', 'KI10100220250619164824', '1446-12-22', '1.100.10', '101', 'Lunas[ROHMATULLOH]', '29000', '0', 'Ipul', '2025-06-19 16:48:24'),
('6688', 'KI10100220250619164824', '1446-12-22', '4.400.21', '101', 'Lunas[ROHMATULLOH]', '0', '29000', 'Ipul', '2025-06-19 16:48:24'),
('6689', 'KI10100220250427163143015', '1446-10-28', '1.200.10', '101', 'Tidak beli jilid 2, 3 dan BHS Arab', '29000', '0', 'Ipul', '2025-06-19 23:49:20'),
('6690', 'KI10100220250427163143015', '1446-10-28', '4.100.30', '101', 'Tidak beli jilid 2, 3 dan BHS Arab', '0', '29000', 'Ipul', '2025-06-19 23:49:20'),
('6691', 'KI10100220250619164940', '1446-12-22', '1.100.10', '101', 'Lunas[NAILATUN NIAMI]', '29000', '0', 'Ipul', '2025-06-19 16:49:40'),
('6692', 'KI10100220250619164940', '1446-12-22', '4.400.21', '101', 'Lunas[NAILATUN NIAMI]', '0', '29000', 'Ipul', '2025-06-19 16:49:40'),
('6693', 'KI10100220250427163143011', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab BHS Arab', '49000', '0', 'Ipul', '2025-06-19 23:52:09'),
('6694', 'KI10100220250427163143011', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab BHS Arab', '0', '49000', 'Ipul', '2025-06-19 23:52:09'),
('6695', 'KI10100220250619165234', '1446-12-22', '1.100.10', '101', 'Lunas[FAIZAH NURUL LITA]', '49000', '0', 'Ipul', '2025-06-19 16:52:34'),
('6696', 'KI10100220250619165234', '1446-12-22', '4.400.21', '101', 'Lunas[FAIZAH NURUL LITA]', '0', '49000', 'Ipul', '2025-06-19 16:52:34'),
('6697', 'KI10100220250427163143002', '1446-10-28', '1.200.10', '101', 'Tidak beli jilid 3, Materi Tambahan dan BHS Arab', '29000', '0', 'Ipul', '2025-06-19 23:54:26'),
('6698', 'KI10100220250427163143002', '1446-10-28', '4.100.30', '101', 'Tidak beli jilid 3, Materi Tambahan dan BHS Arab', '0', '29000', 'Ipul', '2025-06-19 23:54:26'),
('6699', 'KI10100220250619165455', '1446-12-22', '1.100.10', '101', 'Lunas[AFZAN FAISAL MAULANA]', '29000', '0', 'Ipul', '2025-06-19 16:54:55'),
('6700', 'KI10100220250619165455', '1446-12-22', '4.400.21', '101', 'Lunas[AFZAN FAISAL MAULANA]', '0', '29000', 'Ipul', '2025-06-19 16:54:55'),
('6701', 'KI10100220250427163143018', '1446-10-28', '1.200.10', '101', 'Tidak beli jilid 2, 3 , Materi Tambahan dan BHS Arab', '19000', '0', 'Ipul', '2025-06-19 23:56:22'),
('6702', 'KI10100220250427163143018', '1446-10-28', '4.100.30', '101', 'Tidak beli jilid 2, 3 , Materi Tambahan dan BHS Arab', '0', '19000', 'Ipul', '2025-06-19 23:56:22'),
('6703', 'KI10100220250619165643', '1446-12-22', '1.100.10', '101', 'Lunas[SITI ISTIFAIYAH]', '19000', '0', 'Ipul', '2025-06-19 16:56:43'),
('6704', 'KI10100220250619165643', '1446-12-22', '4.400.21', '101', 'Lunas[SITI ISTIFAIYAH]', '0', '19000', 'Ipul', '2025-06-19 16:56:43'),
('6705', 'KI10100220250427163143000', '1446-10-28', '1.200.10', '101', 'Tidak beli jilid 2, 3 , Materi Tambahan dan BHS Arab', '19000', '0', 'Ipul', '2025-06-20 00:00:22'),
('6706', 'KI10100220250427163143000', '1446-10-28', '4.100.30', '101', 'Tidak beli jilid 2, 3 , Materi Tambahan dan BHS Arab', '0', '19000', 'Ipul', '2025-06-20 00:00:22'),
('6707', 'KI10100220250619170044', '1446-12-23', '1.100.10', '101', 'Lunas[ABDULLOH BAHAR]', '19000', '0', 'Ipul', '2025-06-19 17:00:44'),
('6708', 'KI10100220250619170044', '1446-12-23', '4.400.21', '101', 'Lunas[ABDULLOH BAHAR]', '0', '19000', 'Ipul', '2025-06-19 17:00:44'),
('6709', 'KI10100220250427163143010', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab BHS Arab', '49000', '0', 'Ipul', '2025-06-20 00:01:32'),
('6710', 'KI10100220250427163143010', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab BHS Arab', '0', '49000', 'Ipul', '2025-06-20 00:01:32'),
('6711', 'KI10100220250619170153', '1446-12-23', '1.100.10', '101', 'Lunas[ADIBA QONITA]', '49000', '0', 'Ipul', '2025-06-19 17:01:53'),
('6712', 'KI10100220250619170153', '1446-12-23', '4.400.21', '101', 'Lunas[ADIBA QONITA]', '0', '49000', 'Ipul', '2025-06-19 17:01:53'),
('6713', 'KI10100220250427163143016', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab BHS Arab', '49000', '0', 'Ipul', '2025-06-20 00:03:00'),
('6714', 'KI10100220250427163143016', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab BHS Arab', '0', '49000', 'Ipul', '2025-06-20 00:03:00'),
('6715', 'KI10100220250619170321', '1446-12-23', '1.100.10', '101', 'Lunas[RAISA ANNISA]', '49000', '0', 'Ipul', '2025-06-19 17:03:21'),
('6716', 'KI10100220250619170321', '1446-12-23', '4.400.21', '101', 'Lunas[RAISA ANNISA]', '0', '49000', 'Ipul', '2025-06-19 17:03:21'),
('6717', 'KI10100220250427163143019', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab BHS Arab', '49000', '0', 'Ipul', '2025-06-20 00:04:00'),
('6718', 'KI10100220250427163143019', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab BHS Arab', '0', '49000', 'Ipul', '2025-06-20 00:04:00'),
('6719', 'KI10100220250619170420', '1446-12-23', '1.100.10', '101', 'Lunas[UBAIDAH]', '49000', '0', 'Ipul', '2025-06-19 17:04:20'),
('6720', 'KI10100220250619170420', '1446-12-23', '4.400.21', '101', 'Lunas[UBAIDAH]', '0', '49000', 'Ipul', '2025-06-19 17:04:20'),
('6721', 'KI10100220250427163143003', '1446-10-28', '1.200.10', '101', 'Tagihan kitab tambah buku prestasi', '64000', '0', 'Ipul', '2025-06-20 00:05:34'),
('6722', 'KI10100220250427163143003', '1446-10-28', '4.100.30', '101', 'Tagihan kitab tambah buku prestasi', '0', '64000', 'Ipul', '2025-06-20 00:05:34'),
('6723', 'KI10100220250427163143021', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab BHS Arab dan tambah buku prestasi', '54000', '0', 'Ipul', '2025-06-20 00:07:37'),
('6724', 'KI10100220250427163143021', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab BHS Arab dan tambah buku prestasi', '0', '54000', 'Ipul', '2025-06-20 00:07:37'),
('6725', 'KI10100220250619170758', '1446-12-23', '1.100.10', '101', 'Lunas[M. ABDIL ARIKIN]', '54000', '0', 'Ipul', '2025-06-19 17:07:58'),
('6726', 'KI10100220250619170758', '1446-12-23', '4.400.21', '101', 'Lunas[M. ABDIL ARIKIN]', '0', '54000', 'Ipul', '2025-06-19 17:07:58'),
('6727', 'KI10100220250427163143001', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Arab Pego dan BHS Arab', '39000', '0', 'Ipul', '2025-06-20 00:09:38'),
('6728', 'KI10100220250427163143001', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Arab Pego dan BHS Arab', '0', '39000', 'Ipul', '2025-06-20 00:09:38'),
('6729', 'KI10100220250427163143013', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab BHS Arab dan tambah buku prestasi', '54000', '0', 'Ipul', '2025-06-20 00:10:40'),
('6730', 'KI10100220250427163143013', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab BHS Arab dan tambah buku prestasi', '0', '54000', 'Ipul', '2025-06-20 00:10:40'),
('6731', 'KI10100220250619171113', '1446-12-23', '1.100.10', '101', 'Lunas[MARIYATUL QIBTIYAH]', '54000', '0', 'Ipul', '2025-06-19 17:11:13'),
('6732', 'KI10100220250619171113', '1446-12-23', '4.400.21', '101', 'Lunas[MARIYATUL QIBTIYAH]', '0', '54000', 'Ipul', '2025-06-19 17:11:13'),
('6733', 'KI10100220250620030356', '1446-12-23', '1.100.10', '101', 'Lunas[ALFI NURDIANA]', '75000', '0', 'Ipul', '2025-06-20 03:03:56'),
('6734', 'KI10100220250620030356', '1446-12-23', '4.400.21', '101', 'Lunas[ALFI NURDIANA]', '0', '75000', 'Ipul', '2025-06-20 03:03:56'),
('6735', 'KI10100220250620030533', '1446-12-23', '1.100.10', '101', 'Lunas[AQILA SHIDQIA]', '42000', '0', 'Ipul', '2025-06-20 03:05:33'),
('6736', 'KI10100220250620030533', '1446-12-23', '4.400.21', '101', 'Lunas[AQILA SHIDQIA]', '0', '42000', 'Ipul', '2025-06-20 03:05:33'),
('6737', 'KI10100220250620030623', '1446-12-23', '1.100.10', '101', 'Lunas[AHMAD ADITIYA]', '75000', '0', 'Ipul', '2025-06-20 03:06:23'),
('6738', 'KI10100220250620030623', '1446-12-23', '4.400.21', '101', 'Lunas[AHMAD ADITIYA]', '0', '75000', 'Ipul', '2025-06-20 03:06:23'),
('6739', 'KI10100220250620030659', '1446-12-23', '1.100.10', '101', 'Lunas[MASRUROTUL MAULUDIYAH]', '42000', '0', 'Ipul', '2025-06-20 03:06:59'),
('6740', 'KI10100220250620030659', '1446-12-23', '4.400.21', '101', 'Lunas[MASRUROTUL MAULUDIYAH]', '0', '42000', 'Ipul', '2025-06-20 03:06:59'),
('6741', 'KI10100220250427163219003', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Tauhid dan Fasholatan', '57000', '0', 'Ipul', '2025-06-20 10:08:15'),
('6742', 'KI10100220250427163219003', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Tauhid dan Fasholatan', '0', '57000', 'Ipul', '2025-06-20 10:08:15'),
('6743', 'KI10100220250620030838', '1446-12-23', '1.100.10', '101', 'Lunas[AZKA AUFARIL MINAN]', '57000', '0', 'Ipul', '2025-06-20 03:08:38'),
('6744', 'KI10100220250620030838', '1446-12-23', '4.400.21', '101', 'Lunas[AZKA AUFARIL MINAN]', '0', '57000', 'Ipul', '2025-06-20 03:08:38'),
('6745', 'KI10100220250427163219002', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Jilid 4, 5 dan Dasar-dasar ilmu tajwid', '55000', '0', 'Ipul', '2025-06-20 10:09:48'),
('6746', 'KI10100220250427163219002', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Jilid 4, 5 dan Dasar-dasar ilmu tajwid', '0', '55000', 'Ipul', '2025-06-20 10:09:48'),
('6747', 'KI10100220250620031009', '1446-12-23', '1.100.10', '101', 'Lunas[AHMAD NUR HASAN ROMADHONI]', '55000', '0', 'Ipul', '2025-06-20 03:10:09'),
('6748', 'KI10100220250620031009', '1446-12-23', '4.400.21', '101', 'Lunas[AHMAD NUR HASAN ROMADHONI]', '0', '55000', 'Ipul', '2025-06-20 03:10:09'),
('6749', 'KI10100220250620031042', '1446-12-23', '1.100.10', '101', 'Lunas[M. DESTRA MAULANA]', '75000', '0', 'Ipul', '2025-06-20 03:10:42'),
('6750', 'KI10100220250620031042', '1446-12-23', '4.400.21', '101', 'Lunas[M. DESTRA MAULANA]', '0', '75000', 'Ipul', '2025-06-20 03:10:42'),
('6751', 'KI10100220250620031103', '1446-12-23', '1.100.10', '101', 'Lunas[LAILATUL MAGHFIROH]', '75000', '0', 'Ipul', '2025-06-20 03:11:03'),
('6752', 'KI10100220250620031103', '1446-12-23', '4.400.21', '101', 'Lunas[LAILATUL MAGHFIROH]', '0', '75000', 'Ipul', '2025-06-20 03:11:03'),
('6753', 'KI10100220250427163219000', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Tauhid, Fasholatan, BHS Arab dan Jilid 5', '32000', '0', 'Ipul', '2025-06-20 10:11:56'),
('6754', 'KI10100220250427163219000', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Tauhid, Fasholatan, BHS Arab dan Jilid 5', '0', '32000', 'Ipul', '2025-06-20 10:11:56'),
('6755', 'KI10100220250620031219', '1446-12-23', '1.100.10', '101', 'Lunas[ACHMAD FADLILUL AKMAL]', '32000', '0', 'Ipul', '2025-06-20 03:12:19'),
('6756', 'KI10100220250620031219', '1446-12-23', '4.400.21', '101', 'Lunas[ACHMAD FADLILUL AKMAL]', '0', '32000', 'Ipul', '2025-06-20 03:12:19'),
('6757', 'KI10100220250427163219005', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Jilid 4 dan 5', '55000', '0', 'Ipul', '2025-06-20 10:15:59'),
('6758', 'KI10100220250427163219005', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Jilid 4 dan 5', '0', '55000', 'Ipul', '2025-06-20 10:15:59'),
('6759', 'KI10100220250620031619', '1446-12-23', '1.100.10', '101', 'Lunas[AISYAH]', '55000', '0', 'Ipul', '2025-06-20 03:16:19'),
('6760', 'KI10100220250620031619', '1446-12-23', '4.400.21', '101', 'Lunas[AISYAH]', '0', '55000', 'Ipul', '2025-06-20 03:16:19'),
('6761', 'KI10100220250620031952', '1446-12-23', '1.100.10', '101', 'Lunas[DIANA RIFQOTUL QOLBI]', '75000', '0', 'Ipul', '2025-06-20 03:19:52'),
('6762', 'KI10100220250620031952', '1446-12-23', '4.400.21', '101', 'Lunas[DIANA RIFQOTUL QOLBI]', '0', '75000', 'Ipul', '2025-06-20 03:19:52'),
('6763', 'KI10100220250620032123', '1446-12-23', '1.100.10', '101', 'Lunas[SITI ATHIUR ROHMAH]', '70000', '0', 'Ipul', '2025-06-20 03:21:23'),
('6764', 'KI10100220250620032123', '1446-12-23', '4.400.21', '101', 'Lunas[SITI ATHIUR ROHMAH]', '0', '70000', 'Ipul', '2025-06-20 03:21:23'),
('6765', 'KI10100220250620032154', '1446-12-23', '1.100.10', '101', 'Lunas[DIYANAH KAMALIYAH]', '49000', '0', 'Ipul', '2025-06-20 03:21:54'),
('6766', 'KI10100220250620032154', '1446-12-23', '4.400.21', '101', 'Lunas[DIYANAH KAMALIYAH]', '0', '49000', 'Ipul', '2025-06-20 03:21:54'),
('6767', 'KI10100220250427163237013', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Tauhid, Tajwid dan Ghorib', '60000', '0', 'Ipul', '2025-06-20 10:23:46'),
('6768', 'KI10100220250427163237013', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Tauhid, Tajwid dan Ghorib', '0', '60000', 'Ipul', '2025-06-20 10:23:46'),
('6769', 'KI10100220250620032410', '1446-12-23', '1.100.10', '101', 'Lunas[SITI QURROTUL AINI]', '60000', '0', 'Ipul', '2025-06-20 03:24:10'),
('6770', 'KI10100220250620032410', '1446-12-23', '4.400.21', '101', 'Lunas[SITI QURROTUL AINI]', '0', '60000', 'Ipul', '2025-06-20 03:24:10'),
('6771', 'KI10100220250427163237000', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Fiqih, Tauhid, Tajwid dan Ghorib', '50000', '0', 'Ipul', '2025-06-20 10:25:09'),
('6772', 'KI10100220250427163237000', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Fiqih, Tauhid, Tajwid dan Ghorib', '0', '50000', 'Ipul', '2025-06-20 10:25:09'),
('6773', 'KI10100220250620032526', '1446-12-23', '1.100.10', '101', 'Lunas[ABDUL HAMID]', '50000', '0', 'Ipul', '2025-06-20 03:25:26'),
('6774', 'KI10100220250620032526', '1446-12-23', '4.400.21', '101', 'Lunas[ABDUL HAMID]', '0', '50000', 'Ipul', '2025-06-20 03:25:26'),
('6775', 'KI10100220250620032626', '1446-12-23', '1.100.10', '101', 'Lunas[AHMAD QUTHBI EL AMIN]', '90000', '0', 'Ipul', '2025-06-20 03:26:26'),
('6776', 'KI10100220250620032626', '1446-12-23', '4.400.21', '101', 'Lunas[AHMAD QUTHBI EL AMIN]', '0', '90000', 'Ipul', '2025-06-20 03:26:26'),
('6777', 'KI10100220250620032658', '1446-12-23', '1.100.10', '101', 'Lunas[KHOIRIYAH]', '90000', '0', 'Ipul', '2025-06-20 03:26:58'),
('6778', 'KI10100220250620032658', '1446-12-23', '4.400.21', '101', 'Lunas[KHOIRIYAH]', '0', '90000', 'Ipul', '2025-06-20 03:26:58'),
('6779', 'KI10100220250620032746', '1446-12-23', '1.100.10', '101', 'Lunas[AHMAD SYAHRU ROMADHONI]', '90000', '0', 'Ipul', '2025-06-20 03:27:46'),
('6780', 'KI10100220250620032746', '1446-12-23', '4.400.21', '101', 'Lunas[AHMAD SYAHRU ROMADHONI]', '0', '90000', 'Ipul', '2025-06-20 03:27:46'),
('6781', 'KI10100220250620032816', '1446-12-23', '1.100.10', '101', 'Lunas[M. FAHMI NURUL ANAM]', '90000', '0', 'Ipul', '2025-06-20 03:28:16'),
('6782', 'KI10100220250620032816', '1446-12-23', '4.400.21', '101', 'Lunas[M. FAHMI NURUL ANAM]', '0', '90000', 'Ipul', '2025-06-20 03:28:16'),
('6783', 'KI10100220250427163237012', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Terjemah Nurul Yaqin Juz 1', '79000', '0', 'Ipul', '2025-06-20 10:29:18'),
('6784', 'KI10100220250427163237012', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Terjemah Nurul Yaqin Juz 1', '0', '79000', 'Ipul', '2025-06-20 10:29:18'),
('6785', 'KI10100220250620032937', '1446-12-23', '1.100.10', '101', 'Lunas[SITI KARIMATIN NISAK]', '79000', '0', 'Ipul', '2025-06-20 03:29:37'),
('6786', 'KI10100220250620032937', '1446-12-23', '4.400.21', '101', 'Lunas[SITI KARIMATIN NISAK]', '0', '79000', 'Ipul', '2025-06-20 03:29:37'),
('6787', 'KI10100220250620033023', '1446-12-23', '1.100.10', '101', 'Lunas[AHMADA KEVIN AINUN NAIM]', '90000', '0', 'Ipul', '2025-06-20 03:30:23'),
('6788', 'KI10100220250620033023', '1446-12-23', '4.400.21', '101', 'Lunas[AHMADA KEVIN AINUN NAIM]', '0', '90000', 'Ipul', '2025-06-20 03:30:23'),
('6789', 'KI10100220250620033051', '1446-12-23', '1.100.10', '101', 'Lunas[HIKMIAH PUTRI NIKMATUNNAFILAH]', '90000', '0', 'Ipul', '2025-06-20 03:30:51'),
('6790', 'KI10100220250620033051', '1446-12-23', '4.400.21', '101', 'Lunas[HIKMIAH PUTRI NIKMATUNNAFILAH]', '0', '90000', 'Ipul', '2025-06-20 03:30:51'),
('6791', 'KI10100220250620033124', '1446-12-23', '1.100.10', '101', 'Lunas[MUHAMMAD YAQUB HAMDANI]', '90000', '0', 'Ipul', '2025-06-20 03:31:24'),
('6792', 'KI10100220250620033124', '1446-12-23', '4.400.21', '101', 'Lunas[MUHAMMAD YAQUB HAMDANI]', '0', '90000', 'Ipul', '2025-06-20 03:31:24'),
('6793', 'KI10100220250620033149', '1446-12-23', '1.100.10', '101', 'Lunas[AHMAD RAFI SALIM]', '90000', '0', 'Ipul', '2025-06-20 03:31:49'),
('6794', 'KI10100220250620033149', '1446-12-23', '4.400.21', '101', 'Lunas[AHMAD RAFI SALIM]', '0', '90000', 'Ipul', '2025-06-20 03:31:49'),
('6795', 'KI10100220250620033218', '1446-12-23', '1.100.10', '101', 'Lunas[WARDATUL JANNAH]', '90000', '0', 'Ipul', '2025-06-20 03:32:18'),
('6796', 'KI10100220250620033218', '1446-12-23', '4.400.21', '101', 'Lunas[WARDATUL JANNAH]', '0', '90000', 'Ipul', '2025-06-20 03:32:18'),
('6797', 'KI10100220250620033316', '1446-12-23', '1.100.10', '101', 'Bayar[M ADAM MALIK]', '50000', '0', 'Ipul', '2025-06-20 03:33:16'),
('6798', 'KI10100220250620033316', '1446-12-23', '4.400.21', '101', 'Bayar[M ADAM MALIK]', '0', '50000', 'Ipul', '2025-06-20 03:33:16'),
('6799', 'KI10100220250620033536', '1446-12-23', '1.100.10', '101', 'Lunas[MUHAMMAD NAUFAL BADRUTTAMAM]', '151000', '0', 'Ipul', '2025-06-20 03:35:36'),
('6800', 'KI10100220250620033536', '1446-12-23', '4.400.21', '101', 'Lunas[MUHAMMAD NAUFAL BADRUTTAMAM]', '0', '151000', 'Ipul', '2025-06-20 03:35:36'),
('6801', 'KI10100220250620033625', '1446-12-23', '1.100.10', '101', 'Lunas[M. ROFIQ]', '200000', '0', 'Ipul', '2025-06-20 03:36:25'),
('6802', 'KI10100220250620033625', '1446-12-23', '4.400.21', '101', 'Lunas[M. ROFIQ]', '0', '200000', 'Ipul', '2025-06-20 03:36:25'),
('6803', 'KI10100220250620033656', '1446-12-23', '1.100.10', '101', 'Lunas[AHMAD JAMALUL MAIMUN]', '200000', '0', 'Ipul', '2025-06-20 03:36:56'),
('6804', 'KI10100220250620033656', '1446-12-23', '4.400.21', '101', 'Lunas[AHMAD JAMALUL MAIMUN]', '0', '200000', 'Ipul', '2025-06-20 03:36:56'),
('6805', 'KI10100220250620033723', '1446-12-23', '1.100.10', '101', 'Lunas[M. ROFIQ HIDAYATULLOH]', '200000', '0', 'Ipul', '2025-06-20 03:37:23'),
('6806', 'KI10100220250620033723', '1446-12-23', '4.400.21', '101', 'Lunas[M. ROFIQ HIDAYATULLOH]', '0', '200000', 'Ipul', '2025-06-20 03:37:23'),
('6807', 'KI10100220250620033746', '1446-12-23', '1.100.10', '101', 'Lunas[M. ZAINURI AZIZ SINATRIA]', '200000', '0', 'Ipul', '2025-06-20 03:37:46'),
('6808', 'KI10100220250620033746', '1446-12-23', '4.400.21', '101', 'Lunas[M. ZAINURI AZIZ SINATRIA]', '0', '200000', 'Ipul', '2025-06-20 03:37:46'),
('6811', 'KI10100220250620034050', '1446-12-23', '1.100.10', '101', 'Lunas[AHMAD ALFAN DZIKRI RAMADHAN]', '200000', '0', 'Ipul', '2025-06-20 03:40:50'),
('6812', 'KI10100220250620034050', '1446-12-23', '4.400.21', '101', 'Lunas[AHMAD ALFAN DZIKRI RAMADHAN]', '0', '200000', 'Ipul', '2025-06-20 03:40:50'),
('6813', 'KI10100220250620034239', '1446-12-23', '1.100.10', '101', 'Lunas[ZAIDATUS SYARIFATUN NAJWA]', '200000', '0', 'Ipul', '2025-06-20 03:42:39'),
('6814', 'KI10100220250620034239', '1446-12-23', '4.400.21', '101', 'Lunas[ZAIDATUS SYARIFATUN NAJWA]', '0', '200000', 'Ipul', '2025-06-20 03:42:39'),
('6815', 'KI10100220250620034328', '1446-12-23', '1.100.10', '101', 'Lunas[SINDI RAISA PUTRI]', '200000', '0', 'Ipul', '2025-06-20 03:43:28'),
('6816', 'KI10100220250620034328', '1446-12-23', '4.400.21', '101', 'Lunas[SINDI RAISA PUTRI]', '0', '200000', 'Ipul', '2025-06-20 03:43:28'),
('6817', 'KI10100220250620034352', '1446-12-23', '1.100.10', '101', 'Lunas[BILQIS THALIA HASNA]', '136000', '0', 'Ipul', '2025-06-20 03:43:52'),
('6818', 'KI10100220250620034352', '1446-12-23', '4.400.21', '101', 'Lunas[BILQIS THALIA HASNA]', '0', '136000', 'Ipul', '2025-06-20 03:43:52'),
('6819', 'KI10100220250620034425', '1446-12-23', '1.100.10', '101', 'Bayar[AHMAD ABBAS MAULANA]', '100000', '0', 'Ipul', '2025-06-20 03:44:25'),
('6820', 'KI10100220250620034425', '1446-12-23', '4.400.21', '101', 'Bayar[AHMAD ABBAS MAULANA]', '0', '100000', 'Ipul', '2025-06-20 03:44:25'),
('6821', 'KI10100220250620034510', '1446-12-23', '1.100.10', '101', 'Lunas[AKHMAD FIKRI HAIKAL]', '189000', '0', 'Ipul', '2025-06-20 03:45:10'),
('6822', 'KI10100220250620034510', '1446-12-23', '4.400.21', '101', 'Lunas[AKHMAD FIKRI HAIKAL]', '0', '189000', 'Ipul', '2025-06-20 03:45:10'),
('6823', 'KI10100220250620034539', '1446-12-23', '1.100.10', '101', 'Lunas[M. HAIKAL NASRULLOH]', '200000', '0', 'Ipul', '2025-06-20 03:45:39'),
('6824', 'KI10100220250620034539', '1446-12-23', '4.400.21', '101', 'Lunas[M. HAIKAL NASRULLOH]', '0', '200000', 'Ipul', '2025-06-20 03:45:39'),
('6825', 'KI10100220250620034602', '1446-12-23', '1.100.10', '101', 'Lunas[MOCHAMMAD UMAR SAID HIDAYATULLOH]', '200000', '0', 'Ipul', '2025-06-20 03:46:02'),
('6826', 'KI10100220250620034602', '1446-12-23', '4.400.21', '101', 'Lunas[MOCHAMMAD UMAR SAID HIDAYATULLOH]', '0', '200000', 'Ipul', '2025-06-20 03:46:02'),
('6827', 'KI10100220250620034641', '1446-12-23', '1.100.10', '101', 'Bayar[MUHAMMAD ABD. MANNAN ROSYID]', '50000', '0', 'Ipul', '2025-06-20 03:46:41'),
('6828', 'KI10100220250620034641', '1446-12-23', '4.400.21', '101', 'Bayar[MUHAMMAD ABD. MANNAN ROSYID]', '0', '50000', 'Ipul', '2025-06-20 03:46:41'),
('6829', 'KI10100220250620034807', '1446-12-23', '1.100.10', '101', 'Lunas[RENI FARIDA]', '75000', '0', 'Ipul', '2025-06-20 03:48:07'),
('6830', 'KI10100220250620034807', '1446-12-23', '4.400.21', '101', 'Lunas[RENI FARIDA]', '0', '75000', 'Ipul', '2025-06-20 03:48:07'),
('6831', 'KI10100220250620034851', '1446-12-23', '1.100.10', '101', 'Lunas[MUHAMMAD ILHAM]', '75000', '0', 'Ipul', '2025-06-20 03:48:51'),
('6832', 'KI10100220250620034851', '1446-12-23', '4.400.21', '101', 'Lunas[MUHAMMAD ILHAM]', '0', '75000', 'Ipul', '2025-06-20 03:48:51'),
('6833', 'KI10100220250620034921', '1446-12-23', '1.100.10', '101', 'Lunas[MOCH KHOTIBUL UMAM]', '90000', '0', 'Ipul', '2025-06-20 03:49:21'),
('6834', 'KI10100220250620034921', '1446-12-23', '4.400.21', '101', 'Lunas[MOCH KHOTIBUL UMAM]', '0', '90000', 'Ipul', '2025-06-20 03:49:21'),
('6835', 'KI10100220250620034947', '1446-12-23', '1.100.10', '101', 'Lunas[A. KHOIRUN NIZAM]', '75000', '0', 'Ipul', '2025-06-20 03:49:47'),
('6836', 'KI10100220250620034947', '1446-12-23', '4.400.21', '101', 'Lunas[A. KHOIRUN NIZAM]', '0', '75000', 'Ipul', '2025-06-20 03:49:47'),
('6837', 'KI10100220250620035011', '1446-12-23', '1.100.10', '101', 'Lunas[RAUDHOTUL JANNAH]', '54000', '0', 'Ipul', '2025-06-20 03:50:11'),
('6838', 'KI10100220250620035011', '1446-12-23', '4.400.21', '101', 'Lunas[RAUDHOTUL JANNAH]', '0', '54000', 'Ipul', '2025-06-20 03:50:11'),
('6839', 'KI10100220250620035036', '1446-12-23', '1.100.10', '101', 'Lunas[IZZA BILLAH]', '75000', '0', 'Ipul', '2025-06-20 03:50:36'),
('6840', 'KI10100220250620035036', '1446-12-23', '4.400.21', '101', 'Lunas[IZZA BILLAH]', '0', '75000', 'Ipul', '2025-06-20 03:50:36'),
('6841', 'KI10100220250620035109', '1446-12-23', '1.100.10', '101', 'Lunas[MUHAMMAD RAIHAN SABILA]', '75000', '0', 'Ipul', '2025-06-20 03:51:09'),
('6842', 'KI10100220250620035109', '1446-12-23', '4.400.21', '101', 'Lunas[MUHAMMAD RAIHAN SABILA]', '0', '75000', 'Ipul', '2025-06-20 03:51:09'),
('6843', 'KI10100220250620035134', '1446-12-23', '1.100.10', '101', 'Lunas[NUR HIDAYATULLOH]', '46000', '0', 'Ipul', '2025-06-20 03:51:34'),
('6844', 'KI10100220250620035134', '1446-12-23', '4.400.21', '101', 'Lunas[NUR HIDAYATULLOH]', '0', '46000', 'Ipul', '2025-06-20 03:51:34'),
('6845', 'KI10100220250620035201', '1446-12-23', '1.100.10', '101', 'Lunas[MUTHIMATUS SHOLIHAH]', '75000', '0', 'Ipul', '2025-06-20 03:52:01'),
('6846', 'KI10100220250620035201', '1446-12-23', '4.400.21', '101', 'Lunas[MUTHIMATUS SHOLIHAH]', '0', '75000', 'Ipul', '2025-06-20 03:52:01'),
('6847', 'KI10100220250620035227', '1446-12-23', '1.100.10', '101', 'Lunas[AFIKA APRILIA ULKIFAYA]', '75000', '0', 'Ipul', '2025-06-20 03:52:27'),
('6848', 'KI10100220250620035227', '1446-12-23', '4.400.21', '101', 'Lunas[AFIKA APRILIA ULKIFAYA]', '0', '75000', 'Ipul', '2025-06-20 03:52:27'),
('6849', 'KI10100220250427163321014', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Tarekh', '73000', '0', 'Ipul', '2025-06-20 10:54:09'),
('6850', 'KI10100220250427163321014', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Tarekh', '0', '73000', 'Ipul', '2025-06-20 10:54:09'),
('6851', 'KI10100220250620035429', '1446-12-23', '1.100.10', '101', 'Lunas[NIKMATUL MAULIDAH]', '73000', '0', 'Ipul', '2025-06-20 03:54:29'),
('6852', 'KI10100220250620035429', '1446-12-23', '4.400.21', '101', 'Lunas[NIKMATUL MAULIDAH]', '0', '73000', 'Ipul', '2025-06-20 03:54:29'),
('6853', 'KI10100220250620035457', '1446-12-23', '1.100.10', '101', 'Lunas[CHUSNIYAH RAMADHANI]', '75000', '0', 'Ipul', '2025-06-20 03:54:57'),
('6854', 'KI10100220250620035457', '1446-12-23', '4.400.21', '101', 'Lunas[CHUSNIYAH RAMADHANI]', '0', '75000', 'Ipul', '2025-06-20 03:54:57'),
('6855', 'KI10100220250620035529', '1446-12-23', '1.100.10', '101', 'Lunas[NABILATUN NISAUL UMMAH]', '75000', '0', 'Ipul', '2025-06-20 03:55:29'),
('6856', 'KI10100220250620035529', '1446-12-23', '4.400.21', '101', 'Lunas[NABILATUN NISAUL UMMAH]', '0', '75000', 'Ipul', '2025-06-20 03:55:29'),
('6857', 'KI10100220250620035553', '1446-12-23', '1.100.10', '101', 'Lunas[MIFTAHUL JANNAH]', '75000', '0', 'Ipul', '2025-06-20 03:55:53'),
('6858', 'KI10100220250620035553', '1446-12-23', '4.400.21', '101', 'Lunas[MIFTAHUL JANNAH]', '0', '75000', 'Ipul', '2025-06-20 03:55:53'),
('6859', 'KI10100220250620035647', '1446-12-23', '1.100.10', '101', 'Lunas[ABDUL MUTHOLLIB]', '75000', '0', 'Ipul', '2025-06-20 03:56:47'),
('6860', 'KI10100220250620035647', '1446-12-23', '4.400.21', '101', 'Lunas[ABDUL MUTHOLLIB]', '0', '75000', 'Ipul', '2025-06-20 03:56:47'),
('6863', 'KI10100220250620041022', '1446-12-23', '1.100.10', '101', 'Lunas[MUHAMMAD HAMDANI]', '100000', '0', 'Ipul', '2025-06-20 04:10:22'),
('6864', 'KI10100220250620041022', '1446-12-23', '4.400.21', '101', 'Lunas[MUHAMMAD HAMDANI]', '0', '100000', 'Ipul', '2025-06-20 04:10:22'),
('6865', 'KI10100220250427163424004', '1446-10-28', '1.200.10', '101', 'Tidak beli kitab Fathul Qorib Sidogiri', '100000', '0', 'Ipul', '2025-06-20 11:11:27'),
('6866', 'KI10100220250427163424004', '1446-10-28', '4.100.30', '101', 'Tidak beli kitab Fathul Qorib Sidogiri', '0', '100000', 'Ipul', '2025-06-20 11:11:27'),
('6867', 'KI10100220250620041142', '1446-12-23', '1.100.10', '101', 'Lunas[MUHAMMAD KHOIRON]', '100000', '0', 'Ipul', '2025-06-20 04:11:42'),
('6868', 'KI10100220250620041142', '1446-12-23', '4.400.21', '101', 'Lunas[MUHAMMAD KHOIRON]', '0', '100000', 'Ipul', '2025-06-20 04:11:42'),
('6869', 'KI10100220250620041221', '1446-12-23', '1.100.10', '101', 'Lunas[M. ALIFIN FIKRI]', '100000', '0', 'Ipul', '2025-06-20 04:12:21'),
('6870', 'KI10100220250620041221', '1446-12-23', '4.400.21', '101', 'Lunas[M. ALIFIN FIKRI]', '0', '100000', 'Ipul', '2025-06-20 04:12:21'),
('6871', 'KI10100220250620041257', '1446-12-23', '1.100.10', '101', 'Lunas[MUHAMMAD ISMAIL]', '100000', '0', 'Ipul', '2025-06-20 04:12:57'),
('6872', 'KI10100220250620041257', '1446-12-23', '4.400.21', '101', 'Lunas[MUHAMMAD ISMAIL]', '0', '100000', 'Ipul', '2025-06-20 04:12:57'),
('6873', 'KI10100220250620041319', '1446-12-23', '1.100.10', '101', 'Lunas[ZAKIYATUL UMMAH]', '100000', '0', 'Ipul', '2025-06-20 04:13:19'),
('6874', 'KI10100220250620041319', '1446-12-23', '4.400.21', '101', 'Lunas[ZAKIYATUL UMMAH]', '0', '100000', 'Ipul', '2025-06-20 04:13:19'),
('6875', 'KI10100220250620041400', '1446-12-23', '1.100.10', '101', 'Lunas[ROBIATUL ADAWIYAH]', '69000', '0', 'Ipul', '2025-06-20 04:14:00'),
('6876', 'KI10100220250620041400', '1446-12-23', '4.400.21', '101', 'Lunas[ROBIATUL ADAWIYAH]', '0', '69000', 'Ipul', '2025-06-20 04:14:00'),
('6877', 'KI10100220250620041507', '1446-12-23', '1.100.10', '101', 'Lunas[AFANDI]', '100000', '0', 'Ipul', '2025-06-20 04:15:07'),
('6878', 'KI10100220250620041507', '1446-12-23', '4.400.21', '101', 'Lunas[AFANDI]', '0', '100000', 'Ipul', '2025-06-20 04:15:07'),
('6879', 'KI10100220250620041527', '1446-12-23', '1.100.10', '101', 'Lunas[MUHAMMAD YAHYA SYAKARUDDIN]', '100000', '0', 'Ipul', '2025-06-20 04:15:27'),
('6880', 'KI10100220250620041527', '1446-12-23', '4.400.21', '101', 'Lunas[MUHAMMAD YAHYA SYAKARUDDIN]', '0', '100000', 'Ipul', '2025-06-20 04:15:27'),
('6881', 'KI10100220250620041606', '1446-12-23', '1.100.10', '101', 'Lunas[FITRI RAMAN DHANI]', '79000', '0', 'Ipul', '2025-06-20 04:16:06'),
('6882', 'KI10100220250620041606', '1446-12-23', '4.400.21', '101', 'Lunas[FITRI RAMAN DHANI]', '0', '79000', 'Ipul', '2025-06-20 04:16:06'),
('6883', 'D110100320250621063424', '1446-12-24', '1.100.10', '101', 'Bayar[MUHAMMAD ISMAIL]', '40000', '0', 'Chuwez', '2025-06-21 06:34:24'),
('6884', 'D110100320250621063424', '1446-12-24', '4.400.22', '101', 'Bayar[MUHAMMAD ISMAIL]', '0', '40000', 'Chuwez', '2025-06-21 06:34:24'),
('6885', 'D110100220250621072407', '1446-12-24', '1.100.10', '101', 'Bayar[BILQIS THALIA HASNA]', '40000', '0', 'Ipul', '2025-06-21 07:24:07'),
('6886', 'D110100220250621072407', '1446-12-24', '4.400.22', '101', 'Bayar[BILQIS THALIA HASNA]', '0', '40000', 'Ipul', '2025-06-21 07:24:07'),
('6887', 'D110100220250621073048', '1446-12-24', '1.100.10', '101', 'Bayar[MILLAH KAMILAH]', '20000', '0', 'Ipul', '2025-06-21 07:30:48'),
('6888', 'D110100220250621073048', '1446-12-24', '4.400.22', '101', 'Bayar[MILLAH KAMILAH]', '0', '20000', 'Ipul', '2025-06-21 07:30:48'),
('6889', 'D110100220250621073206', '1446-12-24', '1.100.10', '101', 'Bayar[MUHAMMAD ILHAM]', '35000', '0', 'Ipul', '2025-06-21 07:32:06'),
('6890', 'D110100220250621073206', '1446-12-24', '4.400.22', '101', 'Bayar[MUHAMMAD ILHAM]', '0', '35000', 'Ipul', '2025-06-21 07:32:06'),
('6891', 'D110100220250621073229', '1446-12-24', '1.100.10', '101', 'Bayar[HIKMIAH PUTRI NIKMATUNNAFILAH]', '35000', '0', 'Ipul', '2025-06-21 07:32:29'),
('6892', 'D110100220250621073229', '1446-12-24', '4.400.22', '101', 'Bayar[HIKMIAH PUTRI NIKMATUNNAFILAH]', '0', '35000', 'Ipul', '2025-06-21 07:32:29'),
('6893', 'D110100220250621073257', '1446-12-24', '1.100.10', '101', 'Bayar[NAURA BILADINA]', '20000', '0', 'Ipul', '2025-06-21 07:32:57'),
('6894', 'D110100220250621073257', '1446-12-24', '4.400.22', '101', 'Bayar[NAURA BILADINA]', '0', '20000', 'Ipul', '2025-06-21 07:32:57'),
('6895', 'ST10100320250621074003', '1446-12-24', '1.100.10', '101', 'an.HAIKAL SHOMADANI', '2000', '0', 'Chuwez', '2025-06-21 14:40:03'),
('6896', 'ST10100320250621074003', '1446-12-24', '2.220.10', '101', 'an.HAIKAL SHOMADANI', '0', '2000', 'Chuwez', '2025-06-21 14:40:03'),
('6897', 'ST10100320250621074019', '1446-12-24', '1.100.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '10000', '0', 'Chuwez', '2025-06-21 14:40:19'),
('6898', 'ST10100320250621074019', '1446-12-24', '2.220.10', '101', 'an.MUCHAMAD RAFIE FAWWAZI', '0', '10000', 'Chuwez', '2025-06-21 14:40:19'),
('6899', 'ST10100320250621074043', '1446-12-24', '1.100.10', '101', 'an.NAURA BILADINA', '10000', '0', 'Chuwez', '2025-06-21 14:40:43'),
('6900', 'ST10100320250621074043', '1446-12-24', '2.220.10', '101', 'an.NAURA BILADINA', '0', '10000', 'Chuwez', '2025-06-21 14:40:43'),
('6901', 'ST10100320250621074102', '1446-12-24', '1.100.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '5000', '0', 'Chuwez', '2025-06-21 14:41:02'),
('6902', 'ST10100320250621074102', '1446-12-24', '2.220.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '0', '5000', 'Chuwez', '2025-06-21 14:41:02'),
('6903', 'ST10100320250621074119', '1446-12-24', '1.100.10', '101', 'an.AULIA AZZAHRA', '20000', '0', 'Chuwez', '2025-06-21 14:41:19'),
('6904', 'ST10100320250621074119', '1446-12-24', '2.220.10', '101', 'an.AULIA AZZAHRA', '0', '20000', 'Chuwez', '2025-06-21 14:41:19'),
('6905', 'ST10100320250621074140', '1446-12-24', '1.100.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '25000', '0', 'Chuwez', '2025-06-21 14:41:40'),
('6906', 'ST10100320250621074140', '1446-12-24', '2.220.10', '101', 'an.PUTRI MAULIDATUL IMANIA', '0', '25000', 'Chuwez', '2025-06-21 14:41:40'),
('6907', 'ST10100320250621074158', '1446-12-24', '1.100.10', '101', 'an.SALWA LAILI', '5000', '0', 'Chuwez', '2025-06-21 14:41:58'),
('6908', 'ST10100320250621074158', '1446-12-24', '2.220.10', '101', 'an.SALWA LAILI', '0', '5000', 'Chuwez', '2025-06-21 14:41:58'),
('6909', 'ST10100320250621074241', '1446-12-24', '1.100.10', '101', 'an.MARIATUL QIBTIYAH', '2000', '0', 'Chuwez', '2025-06-21 14:42:41'),
('6910', 'ST10100320250621074241', '1446-12-24', '2.220.10', '101', 'an.MARIATUL QIBTIYAH', '0', '2000', 'Chuwez', '2025-06-21 14:42:41'),
('6911', 'ST10100320250621074256', '1446-12-24', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'Chuwez', '2025-06-21 14:42:56'),
('6912', 'ST10100320250621074256', '1446-12-24', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'Chuwez', '2025-06-21 14:42:56'),
('6913', 'ST10100320250621074310', '1446-12-24', '1.100.10', '101', 'an.MARIYATUL QIBTIYAH', '10000', '0', 'Chuwez', '2025-06-21 14:43:10'),
('6914', 'ST10100320250621074310', '1446-12-24', '2.220.10', '101', 'an.MARIYATUL QIBTIYAH', '0', '10000', 'Chuwez', '2025-06-21 14:43:10'),
('6915', 'ST10100320250621074327', '1446-12-24', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '5000', '0', 'Chuwez', '2025-06-21 14:43:27'),
('6916', 'ST10100320250621074327', '1446-12-24', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '5000', 'Chuwez', '2025-06-21 14:43:27'),
('6917', 'ST10100320250621074355', '1446-12-24', '1.100.10', '101', 'an.RAISA ANNISA', '5000', '0', 'Chuwez', '2025-06-21 14:43:55'),
('6918', 'ST10100320250621074355', '1446-12-24', '2.220.10', '101', 'an.RAISA ANNISA', '0', '5000', 'Chuwez', '2025-06-21 14:43:55'),
('6919', 'ST10100320250621074428', '1446-12-24', '1.100.10', '101', 'an.MUHAMMAD ALWI', '10000', '0', 'Chuwez', '2025-06-21 14:44:28'),
('6920', 'ST10100320250621074428', '1446-12-24', '2.220.10', '101', 'an.MUHAMMAD ALWI', '0', '10000', 'Chuwez', '2025-06-21 14:44:28'),
('6921', 'ST10100320250621074506', '1446-12-24', '1.100.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '11000', '0', 'Chuwez', '2025-06-21 14:45:06'),
('6922', 'ST10100320250621074506', '1446-12-24', '2.220.10', '101', 'an.MUHAMMAD RIFQIL MAMUN', '0', '11000', 'Chuwez', '2025-06-21 14:45:06'),
('6923', 'ST10100320250621074527', '1446-12-24', '1.100.10', '101', 'an.UBAIDAH', '20000', '0', 'Chuwez', '2025-06-21 14:45:27'),
('6924', 'ST10100320250621074527', '1446-12-24', '2.220.10', '101', 'an.UBAIDAH', '0', '20000', 'Chuwez', '2025-06-21 14:45:27'),
('6925', 'ST10100320250621074543', '1446-12-24', '1.100.10', '101', 'an.UMAR FARUQ', '10000', '0', 'Chuwez', '2025-06-21 14:45:43'),
('6926', 'ST10100320250621074543', '1446-12-24', '2.220.10', '101', 'an.UMAR FARUQ', '0', '10000', 'Chuwez', '2025-06-21 14:45:43'),
('6927', 'ST10100320250621074620', '1446-12-24', '1.100.10', '101', 'an.AHMAD NUR HASAN ROMADHONI', '5000', '0', 'Chuwez', '2025-06-21 14:46:20'),
('6928', 'ST10100320250621074620', '1446-12-24', '2.220.10', '101', 'an.AHMAD NUR HASAN ROMADHONI', '0', '5000', 'Chuwez', '2025-06-21 14:46:20'),
('6929', 'ST10100320250621074638', '1446-12-24', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '10000', '0', 'Chuwez', '2025-06-21 14:46:38'),
('6930', 'ST10100320250621074638', '1446-12-24', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '10000', 'Chuwez', '2025-06-21 14:46:38'),
('6931', 'ST10100320250621074653', '1446-12-24', '1.100.10', '101', 'an.AHMAD ADITIYA', '2000', '0', 'Chuwez', '2025-06-21 14:46:53'),
('6932', 'ST10100320250621074653', '1446-12-24', '2.220.10', '101', 'an.AHMAD ADITIYA', '0', '2000', 'Chuwez', '2025-06-21 14:46:53'),
('6933', 'ST10100320250621074749', '1446-12-24', '1.100.10', '101', 'an.AHMAD RAFI SALIM', '2000', '0', 'Chuwez', '2025-06-21 14:47:49'),
('6934', 'ST10100320250621074749', '1446-12-24', '2.220.10', '101', 'an.AHMAD RAFI SALIM', '0', '2000', 'Chuwez', '2025-06-21 14:47:49'),
('6935', 'ST10100320250621074804', '1446-12-24', '1.100.10', '101', 'an.SITI KARIMATIN NISAK', '10000', '0', 'Chuwez', '2025-06-21 14:48:04'),
('6936', 'ST10100320250621074804', '1446-12-24', '2.220.10', '101', 'an.SITI KARIMATIN NISAK', '0', '10000', 'Chuwez', '2025-06-21 14:48:04'),
('6937', 'ST10100320250621074833', '1446-12-24', '1.100.10', '101', 'an.WARDATUL JANNAH', '5000', '0', 'Chuwez', '2025-06-21 14:48:33'),
('6938', 'ST10100320250621074833', '1446-12-24', '2.220.10', '101', 'an.WARDATUL JANNAH', '0', '5000', 'Chuwez', '2025-06-21 14:48:33'),
('6939', 'ST10100320250621074855', '1446-12-24', '1.100.10', '101', 'an.KHOIRIYAH', '5000', '0', 'Chuwez', '2025-06-21 14:48:55'),
('6940', 'ST10100320250621074855', '1446-12-24', '2.220.10', '101', 'an.KHOIRIYAH', '0', '5000', 'Chuwez', '2025-06-21 14:48:55'),
('6941', 'ST10100320250621074924', '1446-12-24', '1.100.10', '101', 'an.M. FAHMI NURUL ANAM', '10000', '0', 'Chuwez', '2025-06-21 14:49:24'),
('6942', 'ST10100320250621074924', '1446-12-24', '2.220.10', '101', 'an.M. FAHMI NURUL ANAM', '0', '10000', 'Chuwez', '2025-06-21 14:49:24'),
('6943', 'ST10100320250621074939', '1446-12-24', '1.100.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '10000', '0', 'Chuwez', '2025-06-21 14:49:39'),
('6944', 'ST10100320250621074939', '1446-12-24', '2.220.10', '101', 'an.MUHAMMAD YAQUB HAMDANI', '0', '10000', 'Chuwez', '2025-06-21 14:49:39'),
('6945', 'ST10100320250621075006', '1446-12-24', '1.100.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '5000', '0', 'Chuwez', '2025-06-21 14:50:06'),
('6946', 'ST10100320250621075006', '1446-12-24', '2.220.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '0', '5000', 'Chuwez', '2025-06-21 14:50:06'),
('6947', 'ST10100320250621075022', '1446-12-24', '1.100.10', '101', 'an.M. KAMALUDDIN', '10000', '0', 'Chuwez', '2025-06-21 14:50:22'),
('6948', 'ST10100320250621075022', '1446-12-24', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '10000', 'Chuwez', '2025-06-21 14:50:22'),
('6949', 'ST10100320250621075211', '1446-12-24', '1.100.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '30000', '0', 'Chuwez', '2025-06-21 14:52:11'),
('6950', 'ST10100320250621075211', '1446-12-24', '2.220.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '0', '30000', 'Chuwez', '2025-06-21 14:52:11'),
('6951', 'ST10100320250621075225', '1446-12-24', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '10000', '0', 'Chuwez', '2025-06-21 14:52:25'),
('6952', 'ST10100320250621075225', '1446-12-24', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '10000', 'Chuwez', '2025-06-21 14:52:25'),
('6953', 'ST10100320250621075252', '1446-12-24', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '5000', '0', 'Chuwez', '2025-06-21 14:52:52'),
('6954', 'ST10100320250621075252', '1446-12-24', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '5000', 'Chuwez', '2025-06-21 14:52:52'),
('6955', 'ST10100320250621075327', '1446-12-24', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '2000', '0', 'Chuwez', '2025-06-21 14:53:27'),
('6956', 'ST10100320250621075327', '1446-12-24', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '2000', 'Chuwez', '2025-06-21 14:53:27'),
('6957', 'ST10100320250621075352', '1446-12-24', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'Chuwez', '2025-06-21 14:53:52'),
('6958', 'ST10100320250621075352', '1446-12-24', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'Chuwez', '2025-06-21 14:53:52'),
('6959', 'ST10100320250621080203', '1446-12-24', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '5000', '0', 'Chuwez', '2025-06-21 15:02:03'),
('6960', 'ST10100320250621080203', '1446-12-24', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '5000', 'Chuwez', '2025-06-21 15:02:03'),
('6961', 'ST10100320250621080220', '1446-12-24', '1.100.10', '101', 'an.SAFIRATUL JANNAH', '10000', '0', 'Chuwez', '2025-06-21 15:02:20'),
('6962', 'ST10100320250621080220', '1446-12-24', '2.220.10', '101', 'an.SAFIRATUL JANNAH', '0', '10000', 'Chuwez', '2025-06-21 15:02:20'),
('6963', 'ST10100320250621080334', '1446-12-24', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '10000', '0', 'Chuwez', '2025-06-21 15:03:34'),
('6964', 'ST10100320250621080334', '1446-12-24', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '10000', 'Chuwez', '2025-06-21 15:03:34'),
('6965', 'ST10100320250621080425', '1446-12-24', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '5000', '0', 'Chuwez', '2025-06-21 15:04:25'),
('6966', 'ST10100320250621080425', '1446-12-24', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '5000', 'Chuwez', '2025-06-21 15:04:25'),
('6967', 'ST10100320250621080501', '1446-12-24', '1.100.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '5000', '0', 'Chuwez', '2025-06-21 15:05:01'),
('6968', 'ST10100320250621080501', '1446-12-24', '2.220.10', '101', 'an.AHMAD ALFAN DZIKRI RAMADHAN', '0', '5000', 'Chuwez', '2025-06-21 15:05:01'),
('6969', 'ST10100320250621080517', '1446-12-24', '1.100.10', '101', 'an.BILQIS THALIA HASNA', '125000', '0', 'Chuwez', '2025-06-21 15:05:17'),
('6970', 'ST10100320250621080517', '1446-12-24', '2.220.10', '101', 'an.BILQIS THALIA HASNA', '0', '125000', 'Chuwez', '2025-06-21 15:05:17'),
('6971', 'ST10100320250621080546', '1446-12-24', '1.100.10', '101', 'an.AKHMAD FIKRI HAIKAL', '50000', '0', 'Chuwez', '2025-06-21 15:05:46'),
('6972', 'ST10100320250621080546', '1446-12-24', '2.220.10', '101', 'an.AKHMAD FIKRI HAIKAL', '0', '50000', 'Chuwez', '2025-06-21 15:05:46'),
('6973', 'ST10100320250621080617', '1446-12-24', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '25000', '0', 'Chuwez', '2025-06-21 15:06:17'),
('6974', 'ST10100320250621080617', '1446-12-24', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '25000', 'Chuwez', '2025-06-21 15:06:17'),
('6975', 'ST10100320250621080719', '1446-12-24', '1.100.10', '101', 'an.HILYA', '20000', '0', 'Chuwez', '2025-06-21 15:07:19'),
('6976', 'ST10100320250621080719', '1446-12-24', '2.220.10', '101', 'an.HILYA', '0', '20000', 'Chuwez', '2025-06-21 15:07:19'),
('6977', 'ST10100320250621080737', '1446-12-24', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'Chuwez', '2025-06-21 15:07:37'),
('6978', 'ST10100320250621080737', '1446-12-24', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'Chuwez', '2025-06-21 15:07:37'),
('6979', 'BS10100320250621080803000', '1446-10-24', '1.100.10', '101', 'Bayar[MIFTAHUL JANNAH]', '30000', '0', 'Chuwez', '2025-06-21 08:08:03'),
('6980', 'BS10100320250621080803000', '1446-10-24', '4.400.20', '101', 'Bayar[MIFTAHUL JANNAH]', '0', '30000', 'Chuwez', '2025-06-21 08:08:03'),
('6981', 'BS10100320250621080803001', '1446-11-24', '1.100.10', '101', 'Bayar[MIFTAHUL JANNAH]', '30000', '0', 'Chuwez', '2025-06-21 08:08:03'),
('6982', 'BS10100320250621080803001', '1446-11-24', '4.400.20', '101', 'Bayar[MIFTAHUL JANNAH]', '0', '30000', 'Chuwez', '2025-06-21 08:08:03'),
('6983', 'BS10100320250621080803002', '1446-12-24', '1.100.10', '101', 'Bayar[MIFTAHUL JANNAH]', '30000', '0', 'Chuwez', '2025-06-21 08:08:03'),
('6984', 'BS10100320250621080803002', '1446-12-24', '4.400.20', '101', 'Bayar[MIFTAHUL JANNAH]', '0', '30000', 'Chuwez', '2025-06-21 08:08:03'),
('6985', 'KK10100320250621150812', '1446-12-24', '5.520.42', '101', 'Air galon', '20000', '0', 'Chuwez', '2025-06-21 08:08:53'),
('6986', 'KK10100320250621150812', '1446-12-24', '1.100.10', '101', 'Air galon', '0', '20000', 'Chuwez', '2025-06-21 08:08:53'),
('6987', 'KK10100320250621150812', '1446-12-24', '5.520.42', '101', 'Bakso', '30000', '0', 'Chuwez', '2025-06-21 08:09:13'),
('6988', 'KK10100320250621150812', '1446-12-24', '1.100.10', '101', 'Bakso', '0', '30000', 'Chuwez', '2025-06-21 08:09:13'),
('6989', 'KI10100220250621123711', '1446-12-24', '1.100.10', '101', 'Bayar[IMROATUS SOLIHAH]', '45000', '0', 'Ipul', '2025-06-21 12:37:11'),
('6990', 'KI10100220250621123711', '1446-12-24', '4.400.21', '101', 'Bayar[IMROATUS SOLIHAH]', '0', '45000', 'Ipul', '2025-06-21 12:37:11'),
('6991', 'D110100320250622063056', '1446-12-25', '1.100.10', '101', 'Bayar[AQILA SHIDQIA]', '35000', '0', 'chuwez', '2025-06-22 06:30:56'),
('6992', 'D110100320250622063056', '1446-12-25', '4.400.22', '101', 'Bayar[AQILA SHIDQIA]', '0', '35000', 'chuwez', '2025-06-22 06:30:56'),
('6993', 'D110100320250622063127', '1446-12-25', '1.100.10', '101', 'Bayar[MUHAMMAD NAUFAL BADRUTTAMAM]', '40000', '0', 'chuwez', '2025-06-22 06:31:27'),
('6994', 'D110100320250622063127', '1446-12-25', '4.400.22', '101', 'Bayar[MUHAMMAD NAUFAL BADRUTTAMAM]', '0', '40000', 'chuwez', '2025-06-22 06:31:27'),
('6995', 'D110100320250622070412', '1446-12-25', '1.100.10', '101', 'Bayar[M. ROFIQ]', '40000', '0', 'chuwez', '2025-06-22 07:04:12'),
('6996', 'D110100320250622070412', '1446-12-25', '4.400.22', '101', 'Bayar[M. ROFIQ]', '0', '40000', 'chuwez', '2025-06-22 07:04:12'),
('6997', 'BS10100320250622070448000', '1446-10-25', '1.100.10', '101', 'Bayar[M. ROFIQ]', '30000', '0', 'chuwez', '2025-06-22 07:04:48'),
('6998', 'BS10100320250622070448000', '1446-10-25', '4.400.20', '101', 'Bayar[M. ROFIQ]', '0', '30000', 'chuwez', '2025-06-22 07:04:48'),
('6999', 'BS10100320250622070448001', '1446-11-25', '1.100.10', '101', 'Bayar[M. ROFIQ]', '30000', '0', 'chuwez', '2025-06-22 07:04:48'),
('7000', 'BS10100320250622070448001', '1446-11-25', '4.400.20', '101', 'Bayar[M. ROFIQ]', '0', '30000', 'chuwez', '2025-06-22 07:04:48'),
('7001', 'BS10100320250622070448002', '1446-12-25', '1.100.10', '101', 'Bayar[M. ROFIQ]', '30000', '0', 'chuwez', '2025-06-22 07:04:48'),
('7002', 'BS10100320250622070448002', '1446-12-25', '4.400.20', '101', 'Bayar[M. ROFIQ]', '0', '30000', 'chuwez', '2025-06-22 07:04:48'),
('7003', 'BS10100320250622070448003', '1447-01-25', '1.100.10', '101', 'Bayar[M. ROFIQ]', '30000', '0', 'chuwez', '2025-06-22 07:04:48'),
('7004', 'BS10100320250622070448003', '1447-01-25', '4.400.20', '101', 'Bayar[M. ROFIQ]', '0', '30000', 'chuwez', '2025-06-22 07:04:48'),
('7005', 'BS10100320250622070448004', '1447-02-25', '1.100.10', '101', 'Bayar[M. ROFIQ]', '30000', '0', 'chuwez', '2025-06-22 07:04:48'),
('7006', 'BS10100320250622070448004', '1447-02-25', '4.400.20', '101', 'Bayar[M. ROFIQ]', '0', '30000', 'chuwez', '2025-06-22 07:04:48'),
('7007', 'BS10100320250622070448005', '1447-03-25', '1.100.10', '101', 'Bayar[M. ROFIQ]', '30000', '0', 'chuwez', '2025-06-22 07:04:48'),
('7008', 'BS10100320250622070448005', '1447-03-25', '4.400.20', '101', 'Bayar[M. ROFIQ]', '0', '30000', 'chuwez', '2025-06-22 07:04:48'),
('7009', 'BS10100320250622070448006', '1447-04-25', '1.100.10', '101', 'Bayar[M. ROFIQ]', '30000', '0', 'chuwez', '2025-06-22 07:04:48'),
('7010', 'BS10100320250622070448006', '1447-04-25', '4.400.20', '101', 'Bayar[M. ROFIQ]', '0', '30000', 'chuwez', '2025-06-22 07:04:48'),
('7011', 'BS10100320250622070448007', '1447-05-25', '1.100.10', '101', 'Bayar[M. ROFIQ]', '30000', '0', 'chuwez', '2025-06-22 07:04:48'),
('7012', 'BS10100320250622070448007', '1447-05-25', '4.400.20', '101', 'Bayar[M. ROFIQ]', '0', '30000', 'chuwez', '2025-06-22 07:04:48'),
('7013', 'BS10100320250622070448008', '1447-06-25', '1.100.10', '101', 'Bayar[M. ROFIQ]', '30000', '0', 'chuwez', '2025-06-22 07:04:48'),
('7014', 'BS10100320250622070448008', '1447-06-25', '4.400.20', '101', 'Bayar[M. ROFIQ]', '0', '30000', 'chuwez', '2025-06-22 07:04:48'),
('7015', 'BS10100320250622070448009', '1447-07-25', '1.100.10', '101', 'Bayar[M. ROFIQ]', '30000', '0', 'chuwez', '2025-06-22 07:04:48'),
('7016', 'BS10100320250622070448009', '1447-07-25', '4.400.20', '101', 'Bayar[M. ROFIQ]', '0', '30000', 'chuwez', '2025-06-22 07:04:48'),
('7017', 'BS10100320250622070448010', '1447-08-25', '1.100.10', '101', 'Bayar[M. ROFIQ]', '30000', '0', 'chuwez', '2025-06-22 07:04:48'),
('7018', 'BS10100320250622070448010', '1447-08-25', '4.400.20', '101', 'Bayar[M. ROFIQ]', '0', '30000', 'chuwez', '2025-06-22 07:04:48'),
('7019', 'D110100320250622072940', '1446-12-25', '1.100.10', '101', 'Bayar[MUHAMMAD RAIHAN SABILA]', '35000', '0', 'chuwez', '2025-06-22 07:29:40'),
('7020', 'D110100320250622072940', '1446-12-25', '4.400.22', '101', 'Bayar[MUHAMMAD RAIHAN SABILA]', '0', '35000', 'chuwez', '2025-06-22 07:29:40'),
('7021', 'D110100320250622073011', '1446-12-25', '1.100.10', '101', 'Bayar[M. ABD. HADI]', '20000', '0', 'chuwez', '2025-06-22 07:30:11'),
('7022', 'D110100320250622073011', '1446-12-25', '4.400.22', '101', 'Bayar[M. ABD. HADI]', '0', '20000', 'chuwez', '2025-06-22 07:30:11'),
('7023', 'ST10100320250622073209', '1446-12-25', '1.100.10', '101', 'an.AULIA AZZAHRA', '11000', '0', 'chuwez', '2025-06-22 14:32:09'),
('7024', 'ST10100320250622073209', '1446-12-25', '2.220.10', '101', 'an.AULIA AZZAHRA', '0', '11000', 'chuwez', '2025-06-22 14:32:09'),
('7025', 'ST10100320250622073230', '1446-12-25', '1.100.10', '101', 'an.HAIKAL SHOMADANI', '2000', '0', 'chuwez', '2025-06-22 14:32:30'),
('7026', 'ST10100320250622073230', '1446-12-25', '2.220.10', '101', 'an.HAIKAL SHOMADANI', '0', '2000', 'chuwez', '2025-06-22 14:32:30'),
('7027', 'ST10100320250622073305', '1446-12-25', '1.100.10', '101', 'an.M. ABD. HADI', '2000', '0', 'chuwez', '2025-06-22 14:33:05'),
('7028', 'ST10100320250622073305', '1446-12-25', '2.220.10', '101', 'an.M. ABD. HADI', '0', '2000', 'chuwez', '2025-06-22 14:33:05'),
('7029', 'ST10100320250622073339', '1446-12-25', '1.100.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '2000', '0', 'chuwez', '2025-06-22 14:33:39'),
('7030', 'ST10100320250622073339', '1446-12-25', '2.220.10', '101', 'an.MOCH.AMMAR HAFIDZ FADLULLOH', '0', '2000', 'chuwez', '2025-06-22 14:33:39'),
('7031', 'ST10100320250622073411', '1446-12-25', '1.100.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '5000', '0', 'chuwez', '2025-06-22 14:34:11'),
('7032', 'ST10100320250622073411', '1446-12-25', '2.220.10', '101', 'an.MOCHAMMAD TAUFIK ALI KURNIAWAN', '0', '5000', 'chuwez', '2025-06-22 14:34:11'),
('7033', 'ST10100320250622073753', '1446-12-25', '1.100.10', '101', 'an.UBAIDAH', '20000', '0', 'chuwez', '2025-06-22 14:37:53'),
('7034', 'ST10100320250622073753', '1446-12-25', '2.220.10', '101', 'an.UBAIDAH', '0', '20000', 'chuwez', '2025-06-22 14:37:53'),
('7035', 'ST10100320250622073821', '1446-12-25', '1.100.10', '101', 'an.RAISA ANNISA', '5000', '0', 'chuwez', '2025-06-22 14:38:21'),
('7036', 'ST10100320250622073821', '1446-12-25', '2.220.10', '101', 'an.RAISA ANNISA', '0', '5000', 'chuwez', '2025-06-22 14:38:21'),
('7037', 'ST10100320250622073847', '1446-12-25', '1.100.10', '101', 'an.MARIATUL QIBTIYAH', '2000', '0', 'chuwez', '2025-06-22 14:38:47'),
('7038', 'ST10100320250622073847', '1446-12-25', '2.220.10', '101', 'an.MARIATUL QIBTIYAH', '0', '2000', 'chuwez', '2025-06-22 14:38:47'),
('7039', 'ST10100320250622073914', '1446-12-25', '1.100.10', '101', 'an.SAUQY AHMAD', '10000', '0', 'chuwez', '2025-06-22 14:39:14'),
('7040', 'ST10100320250622073914', '1446-12-25', '2.220.10', '101', 'an.SAUQY AHMAD', '0', '10000', 'chuwez', '2025-06-22 14:39:14'),
('7041', 'ST10100320250622073944', '1446-12-25', '1.100.10', '101', 'an.AFZAN FAISAL MAULANA', '5000', '0', 'chuwez', '2025-06-22 14:39:44'),
('7042', 'ST10100320250622073944', '1446-12-25', '2.220.10', '101', 'an.AFZAN FAISAL MAULANA', '0', '5000', 'chuwez', '2025-06-22 14:39:44'),
('7043', 'ST10100320250622074015', '1446-12-25', '1.100.10', '101', 'an.MUHAMMAD ALWI', '10000', '0', 'chuwez', '2025-06-22 14:40:15'),
('7044', 'ST10100320250622074015', '1446-12-25', '2.220.10', '101', 'an.MUHAMMAD ALWI', '0', '10000', 'chuwez', '2025-06-22 14:40:15'),
('7045', 'ST10100320250622074050', '1446-12-25', '1.100.10', '101', 'an.UMAR FARUQ', '10000', '0', 'chuwez', '2025-06-22 14:40:50'),
('7046', 'ST10100320250622074050', '1446-12-25', '2.220.10', '101', 'an.UMAR FARUQ', '0', '10000', 'chuwez', '2025-06-22 14:40:50'),
('7047', 'ST10100320250622074129', '1446-12-25', '1.100.10', '101', 'an.HIKMATUL KHOLIDAH', '10000', '0', 'chuwez', '2025-06-22 14:41:29'),
('7048', 'ST10100320250622074129', '1446-12-25', '2.220.10', '101', 'an.HIKMATUL KHOLIDAH', '0', '10000', 'chuwez', '2025-06-22 14:41:29'),
('7049', 'ST10100320250622075021', '1446-12-25', '1.100.10', '101', 'an.AISYAH', '5000', '0', 'chuwez', '2025-06-22 14:50:21'),
('7050', 'ST10100320250622075021', '1446-12-25', '2.220.10', '101', 'an.AISYAH', '0', '5000', 'chuwez', '2025-06-22 14:50:21'),
('7051', 'ST10100320250622075040', '1446-12-25', '1.100.10', '101', 'an.MASRUROTUL MAULUDIYAH', '10000', '0', 'chuwez', '2025-06-22 14:50:40'),
('7052', 'ST10100320250622075040', '1446-12-25', '2.220.10', '101', 'an.MASRUROTUL MAULUDIYAH', '0', '10000', 'chuwez', '2025-06-22 14:50:40'),
('7053', 'ST10100320250622075100', '1446-12-25', '1.100.10', '101', 'an.ACHMAD FADLILUL AKMAL', '5000', '0', 'chuwez', '2025-06-22 14:51:00'),
('7054', 'ST10100320250622075100', '1446-12-25', '2.220.10', '101', 'an.ACHMAD FADLILUL AKMAL', '0', '5000', 'chuwez', '2025-06-22 14:51:00'),
('7055', 'ST10100320250622075142', '1446-12-25', '1.100.10', '101', 'an.AHMAD ADITIYA', '2000', '0', 'chuwez', '2025-06-22 14:51:42'),
('7056', 'ST10100320250622075142', '1446-12-25', '2.220.10', '101', 'an.AHMAD ADITIYA', '0', '2000', 'chuwez', '2025-06-22 14:51:42'),
('7057', 'ST10100320250622075202', '1446-12-25', '1.100.10', '101', 'an.AHMAD NUR HASAN ROMADHONI', '5000', '0', 'chuwez', '2025-06-22 14:52:02'),
('7058', 'ST10100320250622075202', '1446-12-25', '2.220.10', '101', 'an.AHMAD NUR HASAN ROMADHONI', '0', '5000', 'chuwez', '2025-06-22 14:52:02'),
('7059', 'ST10100320250622075222', '1446-12-25', '1.100.10', '101', 'an.AZKA AUFARIL MINAN', '5000', '0', 'chuwez', '2025-06-22 14:52:22'),
('7060', 'ST10100320250622075222', '1446-12-25', '2.220.10', '101', 'an.AZKA AUFARIL MINAN', '0', '5000', 'chuwez', '2025-06-22 14:52:22'),
('7061', 'ST10100320250622075249', '1446-12-25', '1.100.10', '101', 'an.M. FAHMI NURUL ANAM', '10000', '0', 'chuwez', '2025-06-22 14:52:49'),
('7062', 'ST10100320250622075249', '1446-12-25', '2.220.10', '101', 'an.M. FAHMI NURUL ANAM', '0', '10000', 'chuwez', '2025-06-22 14:52:49'),
('7063', 'ST10100320250622075309', '1446-12-25', '1.100.10', '101', 'an.AHMAD SYAHRU ROMADHONI', '10000', '0', 'chuwez', '2025-06-22 14:53:09'),
('7064', 'ST10100320250622075309', '1446-12-25', '2.220.10', '101', 'an.AHMAD SYAHRU ROMADHONI', '0', '10000', 'chuwez', '2025-06-22 14:53:09'),
('7065', 'ST10100320250622075329', '1446-12-25', '1.100.10', '101', 'an.SITI QURROTUL AINI', '2000', '0', 'chuwez', '2025-06-22 14:53:29'),
('7066', 'ST10100320250622075329', '1446-12-25', '2.220.10', '101', 'an.SITI QURROTUL AINI', '0', '2000', 'chuwez', '2025-06-22 14:53:29'),
('7067', 'ST10100320250622075408', '1446-12-25', '1.100.10', '101', 'an.A. KHOIRUN NIZAM', '10000', '0', 'chuwez', '2025-06-22 14:54:08'),
('7068', 'ST10100320250622075408', '1446-12-25', '2.220.10', '101', 'an.A. KHOIRUN NIZAM', '0', '10000', 'chuwez', '2025-06-22 14:54:08'),
('7069', 'ST10100320250622075426', '1446-12-25', '1.100.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '10000', '0', 'chuwez', '2025-06-22 14:54:26'),
('7070', 'ST10100320250622075426', '1446-12-25', '2.220.10', '101', 'an.MUHAMMAD RAIHAN SABILA', '0', '10000', 'chuwez', '2025-06-22 14:54:26'),
('7071', 'ST10100320250622075445', '1446-12-25', '1.100.10', '101', 'an.M. KAMALUDDIN', '10000', '0', 'chuwez', '2025-06-22 14:54:45'),
('7072', 'ST10100320250622075445', '1446-12-25', '2.220.10', '101', 'an.M. KAMALUDDIN', '0', '10000', 'chuwez', '2025-06-22 14:54:45'),
('7073', 'ST10100320250622075506', '1446-12-25', '1.100.10', '101', 'an.CHUSNIYAH RAMADHANI', '10000', '0', 'chuwez', '2025-06-22 14:55:06'),
('7074', 'ST10100320250622075506', '1446-12-25', '2.220.10', '101', 'an.CHUSNIYAH RAMADHANI', '0', '10000', 'chuwez', '2025-06-22 14:55:06'),
('7075', 'ST10100320250622075530', '1446-12-25', '1.100.10', '101', 'an.NUR HIDAYATULLOH', '5000', '0', 'chuwez', '2025-06-22 14:55:30'),
('7076', 'ST10100320250622075530', '1446-12-25', '2.220.10', '101', 'an.NUR HIDAYATULLOH', '0', '5000', 'chuwez', '2025-06-22 14:55:30'),
('7077', 'ST10100320250622075550', '1446-12-25', '1.100.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '5000', '0', 'chuwez', '2025-06-22 14:55:50'),
('7078', 'ST10100320250622075550', '1446-12-25', '2.220.10', '101', 'an.AHMAD AZAIM IBRAHIMI', '0', '5000', 'chuwez', '2025-06-22 14:55:50'),
('7079', 'ST10100320250622075619', '1446-12-25', '1.100.10', '101', 'an.M. ROFIQ HIDAYATULLOH', '10000', '0', 'chuwez', '2025-06-22 14:56:19'),
('7080', 'ST10100320250622075619', '1446-12-25', '2.220.10', '101', 'an.M. ROFIQ HIDAYATULLOH', '0', '10000', 'chuwez', '2025-06-22 14:56:19'),
('7081', 'ST10100320250622075638', '1446-12-25', '1.100.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '25000', '0', 'chuwez', '2025-06-22 14:56:38'),
('7082', 'ST10100320250622075638', '1446-12-25', '2.220.10', '101', 'an.ZAIDATUS SYARIFATUN NAJWA', '0', '25000', 'chuwez', '2025-06-22 14:56:38'),
('7083', 'ST10100320250622075658', '1446-12-25', '1.100.10', '101', 'an.SINDI RAISA PUTRI', '10000', '0', 'chuwez', '2025-06-22 14:56:58'),
('7084', 'ST10100320250622075658', '1446-12-25', '2.220.10', '101', 'an.SINDI RAISA PUTRI', '0', '10000', 'chuwez', '2025-06-22 14:56:58'),
('7085', 'ST10100320250622075717', '1446-12-25', '1.100.10', '101', 'an.AKHMAD FIKRI HAIKAL', '50000', '0', 'chuwez', '2025-06-22 14:57:17'),
('7086', 'ST10100320250622075717', '1446-12-25', '2.220.10', '101', 'an.AKHMAD FIKRI HAIKAL', '0', '50000', 'chuwez', '2025-06-22 14:57:17'),
('7087', 'ST10100320250622075737', '1446-12-25', '1.100.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '6000', '0', 'chuwez', '2025-06-22 14:57:37'),
('7088', 'ST10100320250622075737', '1446-12-25', '2.220.10', '101', 'an.MUHAMMAD ABD. MANNAN ROSYID', '0', '6000', 'chuwez', '2025-06-22 14:57:37'),
('7089', 'ST10100320250622075803', '1446-12-25', '1.100.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '20000', '0', 'chuwez', '2025-06-22 14:58:03'),
('7090', 'ST10100320250622075803', '1446-12-25', '2.220.10', '101', 'an.MOCHAMMAD UMAR SAID HIDAYATULLOH', '0', '20000', 'chuwez', '2025-06-22 14:58:03'),
('7091', 'ST10100320250622075830', '1446-12-25', '1.100.10', '101', 'an.BILQIS THALIA HASNA', '75000', '0', 'chuwez', '2025-06-22 14:58:30'),
('7092', 'ST10100320250622075830', '1446-12-25', '2.220.10', '101', 'an.BILQIS THALIA HASNA', '0', '75000', 'chuwez', '2025-06-22 14:58:30'),
('7093', 'ST10100320250622075855', '1446-12-25', '1.100.10', '101', 'an.MUHAMMAD ISMAIL', '10000', '0', 'chuwez', '2025-06-22 14:58:55'),
('7094', 'ST10100320250622075855', '1446-12-25', '2.220.10', '101', 'an.MUHAMMAD ISMAIL', '0', '10000', 'chuwez', '2025-06-22 14:58:55'),
('7095', 'ST10100320250622075913', '1446-12-25', '1.100.10', '101', 'an.MUHAMMAD KHOIRON', '5000', '0', 'chuwez', '2025-06-22 14:59:13'),
('7096', 'ST10100320250622075913', '1446-12-25', '2.220.10', '101', 'an.MUHAMMAD KHOIRON', '0', '5000', 'chuwez', '2025-06-22 14:59:13'),
('7097', 'ST10100320250622075931', '1446-12-25', '1.100.10', '101', 'an.AFANDI', '5000', '0', 'chuwez', '2025-06-22 14:59:31'),
('7098', 'ST10100320250622075931', '1446-12-25', '2.220.10', '101', 'an.AFANDI', '0', '5000', 'chuwez', '2025-06-22 14:59:31'),
('7099', 'ST10100320250622075946', '1446-12-25', '1.100.10', '101', 'an.MUHAMMAD YAHYA SYAKARUDDIN', '15000', '0', 'chuwez', '2025-06-22 14:59:46'),
('7100', 'ST10100320250622075946', '1446-12-25', '2.220.10', '101', 'an.MUHAMMAD YAHYA SYAKARUDDIN', '0', '15000', 'chuwez', '2025-06-22 14:59:46'),
('7101', 'ST10100320250622080007', '1446-12-25', '1.100.10', '101', 'an.FITRI RAMAN DHANI', '5000', '0', 'chuwez', '2025-06-22 15:00:07'),
('7102', 'ST10100320250622080007', '1446-12-25', '2.220.10', '101', 'an.FITRI RAMAN DHANI', '0', '5000', 'chuwez', '2025-06-22 15:00:07'),
('7103', 'ST10100320250622080100', '1446-12-25', '1.100.10', '101', 'an.MUHAMMAD KANZUL KAROMI', '5000', '0', 'chuwez', '2025-06-22 15:01:00'),
('7104', 'ST10100320250622080100', '1446-12-25', '2.220.10', '101', 'an.MUHAMMAD KANZUL KAROMI', '0', '5000', 'chuwez', '2025-06-22 15:01:00'),
('7105', 'ST10100320250622080116', '1446-12-25', '1.100.10', '101', 'an.M. WAFA BAHRUN NAJA', '5000', '0', 'chuwez', '2025-06-22 15:01:16'),
('7106', 'ST10100320250622080116', '1446-12-25', '2.220.10', '101', 'an.M. WAFA BAHRUN NAJA', '0', '5000', 'chuwez', '2025-06-22 15:01:16'),
('7107', 'ST10100320250622080133', '1446-12-25', '1.100.10', '101', 'an.SAFIRATUL JANNAH', '10000', '0', 'chuwez', '2025-06-22 15:01:33'),
('7108', 'ST10100320250622080133', '1446-12-25', '2.220.10', '101', 'an.SAFIRATUL JANNAH', '0', '10000', 'chuwez', '2025-06-22 15:01:33'),
('7109', 'ST10100320250622080209', '1446-12-25', '1.100.10', '101', 'an.HILYA', '30000', '0', 'chuwez', '2025-06-22 15:02:09'),
('7110', 'ST10100320250622080209', '1446-12-25', '2.220.10', '101', 'an.HILYA', '0', '30000', 'chuwez', '2025-06-22 15:02:09'),
('7111', 'ST10100320250622080232', '1446-12-25', '1.100.10', '101', 'an.CHUSNIA RAMADHANI', '20000', '0', 'chuwez', '2025-06-22 15:02:32'),
('7112', 'ST10100320250622080232', '1446-12-25', '2.220.10', '101', 'an.CHUSNIA RAMADHANI', '0', '20000', 'chuwez', '2025-06-22 15:02:32'),
('7113', 'ST10100320250622082332', '1446-12-25', '1.100.10', '101', 'an.UST THORIQUL HUDA', '30000', '0', 'chuwez', '2025-06-22 15:23:32'),
('7114', 'ST10100320250622082332', '1446-12-25', '2.220.10', '101', 'an.UST THORIQUL HUDA', '0', '30000', 'chuwez', '2025-06-22 15:23:32'),
('7115', 'ST10100320250622082354', '1446-12-25', '1.100.10', '101', 'an.ABDUL MUTHOLLIB', '2000', '0', 'chuwez', '2025-06-22 15:23:54'),
('7116', 'ST10100320250622082354', '1446-12-25', '2.220.10', '101', 'an.ABDUL MUTHOLLIB', '0', '2000', 'chuwez', '2025-06-22 15:23:54'),
('7117', 'BS10100320250622082422000', '1446-12-25', '1.100.10', '101', 'Bayar[ABDUL MUTHOLLIB]', '30000', '0', 'chuwez', '2025-06-22 08:24:22'),
('7118', 'BS10100320250622082422000', '1446-12-25', '4.400.20', '101', 'Bayar[ABDUL MUTHOLLIB]', '0', '30000', 'chuwez', '2025-06-22 08:24:22'),
('7119', 'BS10100320250622082422001', '1447-01-25', '1.100.10', '101', 'Bayar[ABDUL MUTHOLLIB]', '30000', '0', 'chuwez', '2025-06-22 08:24:22'),
('7120', 'BS10100320250622082422001', '1447-01-25', '4.400.20', '101', 'Bayar[ABDUL MUTHOLLIB]', '0', '30000', 'chuwez', '2025-06-22 08:24:22'),
('7121', 'D110100320250622082459', '1446-12-25', '1.100.10', '101', 'Bayar[ABDUL MUTHOLLIB]', '35000', '0', 'chuwez', '2025-06-22 08:24:59'),
('7122', 'D110100320250622082459', '1446-1