<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Madrasah</title>
    <!-- <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet"> -->
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: linear-gradient(135deg,rgb(205, 210, 234) 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
            overflow-x: hidden;
        }

        .dashboard-container {
            max-width: 1200px;
            margin: 0 auto;
            animation: fadeInUp 0.6s ease-out;
        }

        .header {
            text-align: center;
            margin-bottom: 30px;
            color: white;
        }

        .header h1 {
            font-size: 2.2rem;
            font-weight: 700;
            margin-bottom: 8px;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.3);
            letter-spacing: -0.02em;
        }

        .header p {
            font-size: 1rem;
            opacity: 0.9;
            font-weight: 400;
        }

        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }

        .stat-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(15px);
            border-radius: 16px;
            padding: 20px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.3);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            overflow: hidden;
            height: fit-content;
        }

        .stat-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, var(--primary), var(--secondary));
        }

        .stat-card:hover {
            transform: translateY(-4px);
            box-shadow: 0 8px 30px rgba(0, 0, 0, 0.15);
            border-color: rgba(255, 255, 255, 0.4);
        }

        /* Card Color Schemes */
        .kas { --primary: #e74c3c; --secondary: #f39c12; }
        .tabungan { --primary: #27ae60; --secondary: #2ecc71; }
        .syahriah { --primary: #3498db; --secondary: #5dade2; }
        .ikhtibar { --primary: #9b59b6; --secondary: #bb8fce; }
        .kitab { --primary: #f39c12; --secondary: #f7dc6f; }
        .seragam { --primary: #17a2b8; --secondary: #7fb3d3; }
        .maulid { --primary: #fd7e14; --secondary: #ffb347; }
        .imda { --primary: #6f42c1; --secondary: #a569bd; }

        .card-header {
            display: flex;
            align-items: center;
            margin-bottom: 16px;
        }

        .card-icon {
            width: 48px;
            height: 48px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 12px;
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            color: white;
            font-size: 20px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        }

        .card-title {
            font-size: 1.2rem;
            font-weight: 600;
            color: #2c3e50;
            letter-spacing: -0.01em;
        }

        .card-stats {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 12px;
        }

        .special-stats {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(70px, 1fr));
            gap: 8px;
        }

        .stat-item {
            text-align: center;
            padding: 12px 8px;
            background: rgba(248, 249, 250, 0.8);
            border-radius: 10px;
            border: 1px solid rgba(0, 0, 0, 0.04);
            transition: all 0.2s ease;
        }

        .stat-item:hover {
            background: rgba(255, 255, 255, 0.9);
            transform: translateY(-1px);
        }

        .stat-label {
            font-size: 0.75rem;
            color: #6c757d;
            font-weight: 500;
            margin-bottom: 4px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .stat-value {
            font-size: 0.95rem;
            font-weight: 700;
            color: var(--primary);
            line-height: 1.2;
        }

        .highlight {
            background: linear-gradient(135deg, rgba(255, 255, 255, 0.9), rgba(248, 249, 250, 0.9));
            border: 1px solid var(--primary);
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }

        .highlight .stat-value {
            color: var(--primary);
            font-size: 1rem;
        }

        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes slideIn {
            from {
                opacity: 0;
                transform: translateX(-20px);
            }
            to {
                opacity: 1;
                transform: translateX(0);
            }
        }

        .stat-card:nth-child(1) { animation: slideIn 0.6s ease-out 0.1s both; }
        .stat-card:nth-child(2) { animation: slideIn 0.6s ease-out 0.2s both; }
        .stat-card:nth-child(3) { animation: slideIn 0.6s ease-out 0.3s both; }
        .stat-card:nth-child(4) { animation: slideIn 0.6s ease-out 0.4s both; }
        .stat-card:nth-child(5) { animation: slideIn 0.6s ease-out 0.5s both; }
        .stat-card:nth-child(6) { animation: slideIn 0.6s ease-out 0.6s both; }
        .stat-card:nth-child(7) { animation: slideIn 0.6s ease-out 0.7s both; }
        .stat-card:nth-child(8) { animation: slideIn 0.6s ease-out 0.8s both; }
        .stat-card:nth-child(9) { animation: slideIn 0.6s ease-out 0.9s both; }

        @media (max-width: 768px) {
            .stats-grid {
                grid-template-columns: repeat(auto-fit, minmax(260px, 1fr));
                gap: 16px;
            }
            
            .header h1 {
                font-size: 1.8rem;
            }
            
            .card-stats {
                grid-template-columns: 1fr;
                gap: 10px;
            }
            
            .special-stats {
                grid-template-columns: repeat(2, 1fr);
                gap: 6px;
            }

            .stat-item {
                padding: 10px 6px;
            }
        }

        @media (max-width: 480px) {
            .stats-grid {
                grid-template-columns: 1fr;
            }
            
            .special-stats {
                grid-template-columns: repeat(3, 1fr);
            }
        }

        .loading-effect {
            position: relative;
            overflow: hidden;
        }

        .loading-effect::after {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.4), transparent);
            animation: shimmer 2s infinite;
        }

        @keyframes shimmer {
            0% { left: -100%; }
            100% { left: 100%; }
        }
    </style>
</head>
<body>
    <div class="dashboard-container">
        <!-- <div class="header">
            <h1><i class="fas fa-mosque"></i> Dashboard Madrasah</h1>
            <p>Sistem Informasi Keuangan Madrasah - <span id="currentDate"></span></p>
        </div> -->

        <?php
        // Koneksi dan konfigurasi
        include 'koneksi.php'; 
        require './kalenderhijriah.php';

        $kode = $_SESSION['kode'];
        $tgl = date('Y-m-d');
         
        $tglH = $hijri[2].'-'.$calendar->monthName($hijri[0]).'-'.sprintf('%02d', $hijri[1]);
        $bulaN = date('m',strtotime($tglH));
        $tahuN = date('Y',strtotime($tglH));
        // query Akumulasi
        function getFinancialData($koneksi, $table, $kode, $tgl = null, $dateField = 'tgl') {
            $dateCondition = $tgl ? "AND $dateField='$tgl'" : "";
            
            $daily = mysqli_fetch_array(mysqli_query($koneksi, 
                "SELECT SUM(bayar) AS daily FROM $table WHERE $dateField='".date('Y-m-d')."' AND kode='$kode'"));
            
            $total = mysqli_fetch_array(mysqli_query($koneksi, 
                "SELECT SUM(kewajiban) AS kewajiban, SUM(bayar) AS bayar, SUM(bayar-kewajiban) AS sisa 
                 FROM $table WHERE kode='$kode'"));
           
            
            return [
                'daily' => $daily['daily'] ?? 0,
                'kewajiban' => $total['kewajiban'] ?? 0,
                'bayar' => $total['bayar'] ?? 0,
                'sisa' => $total['sisa'] ?? 0,
               
            ];
        }

        // Data Kas
        $kas = mysqli_fetch_array(mysqli_query($koneksi, 
            "SELECT SUM(debet-kredit) AS total, 
                    SUM(CASE WHEN tanggal='$tgl' THEN debet-kredit ELSE 0 END) AS daily 
             FROM bukubesar WHERE kode_akun LIKE '%1.100.%' AND kode='$kode'"));

        // Data Tabungan
        $tabungan = mysqli_fetch_array(mysqli_query($koneksi, 
            "SELECT SUM(kredit-debet) AS total,
                    SUM(CASE WHEN tgl2='$tgl' THEN kredit-debet ELSE 0 END) AS daily 
             FROM mutasitabungan"));
             
        $m_syahriah= mysqli_fetch_array(mysqli_query($koneksi,"SELECT SUM(kewajiban)AS mAkewajiban,sum(bayar-kewajiban)AS mAsisa, SUM(bayar) AS mAbayar FROM bulanan WHERE tglmasehi<='$tglH' AND kode='".$_SESSION['kode']."' ")); 
       $ak_syahriah= mysqli_fetch_array(mysqli_query($koneksi,"SELECT SUM(kewajiban) AS kewajiban, SUM(bayar) AS bayar, SUM(bayar-kewajiban) AS sisa FROM bulanan WHERE DATE_FORMAT(tglmasehi, '%Y-%m') <= CONCAT('$tahuN', '-', '$bulaN') AND kode='".$_SESSION['kode']."' ")); 
        // Data untuk setiap kategori
        $syahriah = getFinancialData($koneksi, 'bulanan', $kode);
        $ikhtibar = getFinancialData($koneksi, 'ikhtibar', $kode);
        $kitab = getFinancialData($koneksi, 'kitab', $kode);
        $seragam = getFinancialData($koneksi, 'seragam', $kode);
        $maulid = getFinancialData($koneksi, 'iuran', $kode);
        $imda1 = getFinancialData($koneksi, 'imda1', $kode);
        $imda2 = getFinancialData($koneksi, 'imda2', $kode);
        $imda3 = getFinancialData($koneksi, 'imda3', $kode);
        ?>

        <div class="stats-grid">
            <!-- Kas Card -->
            <div class="stat-card kas">
                <div class="card-header">
                    <div class="card-icon">
                        <i class="fas fa-money-check-alt"></i>
                    </div>
                    <div class="card-title">Kas</div>
                </div>
                <div class="card-stats">
                    <div class="stat-item highlight">
                        <div class="stat-label">Hari Ini</div>
                        <div class="stat-value"><?= number_format($kas['daily'] ?? 0, 0) ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Total</div>
                        <div class="stat-value"><?= number_format($kas['total'] ?? 0, 0) ?></div>
                    </div>
                </div>
            </div>

            <!-- Tabungan Card -->
            <div class="stat-card tabungan">
                <div class="card-header">
                    <div class="card-icon">
                        <i class="fas fa-piggy-bank"></i>
                    </div>
                    <div class="card-title">Tabungan</div>
                </div>
                <div class="card-stats">
                    <div class="stat-item highlight">
                        <div class="stat-label">Hari Ini</div>
                        <div class="stat-value"><?= number_format($tabungan['daily'] ?? 0, 0) ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Total</div>
                        <div class="stat-value"><?= number_format($tabungan['total'] ?? 0, 0) ?></div>
                    </div>
                </div>
            </div>

            <!-- Syahriah Card -->
            <div class="stat-card syahriah">
                <div class="card-header">
                    <div class="card-icon">
                        <i class="fas fa-calendar-check"></i>
                    </div>
                    <div class="card-title">Syahriah</div>
                </div>
                <div class="special-stats">
                    <div class="stat-item highlight">
                        <div class="stat-label">Hari Ini</div>
                        <div class="stat-value"><?= number_format($syahriah['daily'], 0) ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Tagihan</div>
                        <div class="stat-value"><?= number_format($m_syahriah['mAkewajiban'], 0) ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Terbayar</div>
                        <div class="stat-value"><?= number_format($syahriah['bayar'], 0) ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Bayar</div>
                        <div class="stat-value"><?= number_format($ak_syahriah['bayar'], 0) ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Sisa</div>
                        <div class="stat-value"><?= number_format($ak_syahriah['sisa'], 0) ?></div>
                    </div>
                </div>
            </div>

            <!-- Ikhtibar Card -->
            <div class="stat-card ikhtibar">
                <div class="card-header">
                    <div class="card-icon">
                        <i class="fas fa-star-and-crescent"></i>
                    </div>
                    <div class="card-title">Ikhtibar</div>
                </div>
                <div class="special-stats">
                    <div class="stat-item highlight">
                        <div class="stat-label">Hari Ini</div>
                        <div class="stat-value"><?= number_format($ikhtibar['daily'], 0) ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Tagihan</div>
                        <div class="stat-value"><?= number_format($ikhtibar['kewajiban'], 0) ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Terbayar</div>
                        <div class="stat-value"><?= number_format($ikhtibar['bayar'], 0) ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Sisa</div>
                        <div class="stat-value"><?= number_format($ikhtibar['sisa'], 0) ?></div>
                    </div>
                </div>
            </div>

            <!-- Kitab Card -->
            <div class="stat-card kitab">
                <div class="card-header">
                    <div class="card-icon">
                        <i class="fas fa-book"></i>
                    </div>
                    <div class="card-title">Kitab</div>
                </div>
                <div class="special-stats">
                    <div class="stat-item highlight">
                        <div class="stat-label">Hari Ini</div>
                        <div class="stat-value"><?= number_format($kitab['daily'], 0) ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Tagihan</div>
                        <div class="stat-value"><?= number_format($kitab['kewajiban'], 0) ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Terbayar</div>
                        <div class="stat-value"><?= number_format($kitab['bayar'], 0) ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Sisa</div>
                        <div class="stat-value"><?= number_format($kitab['sisa'], 0) ?></div>
                    </div>
                </div>
            </div>

            <!-- Seragam Card -->
            <div class="stat-card seragam">
                <div class="card-header">
                    <div class="card-icon">
                        <i class="fas fa-tshirt"></i>
                    </div>
                    <div class="card-title">Seragam</div>
                </div>
                <div class="special-stats">
                    <div class="stat-item highlight">
                        <div class="stat-label">Hari Ini</div>
                        <div class="stat-value"><?= number_format($seragam['daily'], 0) ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Tagihan</div>
                        <div class="stat-value"><?= number_format($seragam['kewajiban'], 0) ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Terbayar</div>
                        <div class="stat-value"><?= number_format($seragam['bayar'], 0) ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Sisa</div>
                        <div class="stat-value"><?= number_format($seragam['sisa'], 0) ?></div>
                    </div>
                </div>
            </div>

            <!-- Maulid Card -->
            <div class="stat-card maulid">
                <div class="card-header">
                    <div class="card-icon">
                        <i class="fas fa-mosque"></i>
                    </div>
                    <div class="card-title">Maulid</div>
                </div>
                <div class="special-stats">
                    <div class="stat-item highlight">
                        <div class="stat-label">Hari Ini</div>
                        <div class="stat-value"><?= number_format($maulid['daily'], 0) ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Tagihan</div>
                        <div class="stat-value"><?= number_format($maulid['kewajiban'], 0) ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Terbayar</div>
                        <div class="stat-value"><?= number_format($maulid['bayar'], 0) ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Sisa</div>
                        <div class="stat-value"><?= number_format($maulid['sisa'], 0) ?></div>
                    </div>
                </div>
            </div>

            <!-- Imda Card -->
            <div class="stat-card imda">
                <div class="card-header">
                    <div class="card-icon">
                        <i class="fas fa-graduation-cap"></i>
                    </div>
                    <div class="card-title">Imda-I</div>
                </div>
                <div class="special-stats">
                    <div class="stat-item highlight">
                        <div class="stat-label">Hari Ini</div>
                        <div class="stat-value"><?= number_format($imda1['daily'], 0) ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Tagihan</div>
                        <div class="stat-value"><?= number_format($imda1['kewajiban'], 0) ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Terbayar</div>
                        <div class="stat-value"><?= number_format($imda1['bayar'], 0) ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Sisa</div>
                        <div class="stat-value"><?= number_format($imda1['sisa'], 0) ?></div>
                    </div>
                </div>
            </div>

            <!-- Imda-2 Card -->
            <div class="stat-card imda">
                <div class="card-header">
                    <div class="card-icon">
                        <i class="fas fa-graduation-cap"></i>
                    </div>
                    <div class="card-title">Imda-II</div>
                </div>
                <div class="special-stats">
                    <div class="stat-item highlight">
                        <div class="stat-label">Hari Ini</div>
                        <div class="stat-value"><?= number_format($imda2['daily'], 0) ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Tagihan</div>
                        <div class="stat-value"><?= number_format($imda2['kewajiban'], 0) ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Terbayar</div>
                        <div class="stat-value"><?= number_format($imda2['bayar'], 0) ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Sisa</div>
                        <div class="stat-value"><?= number_format($imda2['sisa'], 0) ?></div>
                    </div>
                </div>
            </div>

            <!-- Imda Card -->
            <div class="stat-card imda">
                <div class="card-header">
                    <div class="card-icon">
                        <i class="fas fa-graduation-cap"></i>
                    </div>
                    <div class="card-title">Imda-III</div>
                </div>
                <div class="special-stats">
                    <div class="stat-item highlight">
                        <div class="stat-label">Hari Ini</div>
                        <div class="stat-value"><?= number_format($imda3['daily'], 0) ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Tagihan</div>
                        <div class="stat-value"><?= number_format($imda3['kewajiban'], 0) ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Terbayar</div>
                        <div class="stat-value"><?= number_format($imda3['bayar'], 0) ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Sisa</div>
                        <div class="stat-value"><?= number_format($imda3['sisa'], 0) ?></div>
                    </div>
                </div>
            </div>

            

        </div>
    </div>

    <script>
        // Set current date
        function setCurrentDate() {
            const days = ['Minggu', 'Senin', 'Selasa', 'Rabu', 'Kamis', 'Jumat', 'Sabtu'];
            const months = ['Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni', 
                           'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'];
            
            const now = new Date();
            const dayName = days[now.getDay()];
            const day = now.getDate();
            const month = months[now.getMonth()];
            const year = now.getFullYear();
            
            document.getElementById('currentDate').textContent = 
                `${dayName}, ${day} ${month} ${year}`;
        }

        // Enhanced hover effects
        document.querySelectorAll('.stat-card').forEach(card => {
            card.addEventListener('mouseenter', function() {
                this.style.transform = 'translateY(-6px) scale(1.01)';
                this.style.boxShadow = '0 12px 35px rgba(0, 0, 0, 0.18)';
            });
            
            card.addEventListener('mouseleave', function() {
                this.style.transform = 'translateY(0) scale(1)';
                this.style.boxShadow = '0 4px 20px rgba(0, 0, 0, 0.1)';
            });
        });

        // Initialize
        setCurrentDate();
        
        // Staggered animation for stat values
        document.querySelectorAll('.stat-value').forEach((element, index) => {
            element.style.opacity = '0';
            element.style.transform = 'translateY(10px)';
            
            setTimeout(() => {
                element.style.transition = 'all 0.4s cubic-bezier(0.4, 0, 0.2, 1)';
                element.style.opacity = '1';
                element.style.transform = 'translateY(0)';
            }, index * 50 + 800);
        });

        // Refresh data every 30 seconds
        setInterval(() => {
            location.reload();
        }, 30000);
    </script>
</body>
</html>