<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Madrasah</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg,rgb(194, 209, 235) 0%, #2a5298 100%);
            min-height: 100vh;
            padding: 20px;
        }

        .dashboard-container {
            max-width: 1200px;
            margin: 0 auto;
            animation: fadeInUp 0.8s ease-out;
        }

        .header {
            text-align: center;
            margin-bottom: 30px;
            color: white;
        }

        .header h1 {
            font-size: 2.2rem;
            font-weight: 700;
            margin-bottom: 8px;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.3);
        }

        .header p {
            font-size: 1rem;
            opacity: 0.9;
            font-weight: 300;
        }

        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }

        .stat-card {
            background: rgba(255, 255, 255, 0.98);
            backdrop-filter: blur(20px);
            border-radius: 16px;
            padding: 20px;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.12);
            border: 1px solid rgba(255, 255, 255, 0.18);
            transition: all 0.4s cubic-bezier(0.25, 0.8, 0.25, 1);
            position: relative;
            overflow: hidden;
            min-height: 180px;
        }

        .stat-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, var(--card-color), var(--card-color-light));
            border-radius: 16px 16px 0 0;
        }

        .stat-card::after {
            content: '';
            position: absolute;
            top: -50%;
            right: -50%;
            width: 100px;
            height: 100px;
            background: linear-gradient(135deg, var(--card-color), transparent);
            border-radius: 50%;
            opacity: 0.1;
            transition: all 0.4s ease;
        }

        .stat-card:hover {
            transform: translateY(-6px) scale(1.02);
            box-shadow: 0 16px 48px rgba(0, 0, 0, 0.2);
        }

        .stat-card:hover::after {
            transform: scale(1.2);
            opacity: 0.15;
        }

        .stat-card.kas { --card-color: #ff6b6b; --card-color-light: #ff8e8e; }
        .stat-card.tabungan { --card-color: #51cf66; --card-color-light: #69db7c; }
        .stat-card.syahriah { --card-color: #339af0; --card-color-light: #74c0fc; }
        .stat-card.ikhtibar { --card-color: #9775fa; --card-color-light: #b197fc; }
        .stat-card.kitab { --card-color: #ffd43b; --card-color-light: #ffec99; }
        .stat-card.imda { --card-color: #845ef7; --card-color-light: #b197fc; }
         .stat-card.seragam { --card-color: #20c997; --card-color-light: #63e6be; }
        .stat-card.maulid { --card-color: #fd7e14; --card-color-light: #ffa94d; }
        .stat-card.imni { --card-color: #9775fa; --card-color-light: #b197fc; }

        .card-header {
            display: flex;
            align-items: center;
            margin-bottom: 16px;
        }

        .card-icon {
            width: 48px;
            height: 48px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 12px;
            background: linear-gradient(135deg, var(--card-color), var(--card-color-light));
            color: white;
            font-size: 20px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }

        .card-title {
            font-size: 1.1rem;
            font-weight: 600;
            color: #2d3748;
        }

        .card-stats {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 12px;
        }

        .stat-item {
            text-align: center;
            padding: 12px;
            background: linear-gradient(135deg, #f8fafc, #f1f5f9);
            border-radius: 10px;
            border: 1px solid rgba(226, 232, 240, 0.8);
            transition: all 0.3s ease;
        }

        .stat-item:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }

        .stat-label {
            font-size: 0.75rem;
            color: #64748b;
            font-weight: 500;
            margin-bottom: 4px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .stat-value {
            font-size: 0.95rem;
            font-weight: 700;
            color: var(--card-color);
        }

        .special-stats {
            grid-column: 1 / -1;
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(80px, 1fr));
            gap: 8px;
        }

        .special-stats .stat-item {
            padding: 10px 8px;
        }

        .special-stats .stat-label {
            font-size: 0.7rem;
        }

        .special-stats .stat-value {
            font-size: 0.85rem;
        }

        .highlight {
            background: linear-gradient(135deg, var(--card-color), var(--card-color-light));
            color: white;
            border: none;
        }

        .highlight .stat-label {
            color: rgba(255, 255, 255, 0.9);
        }

        .highlight .stat-value {
            color: white;
        }

        .pulse {
            animation: pulse 3s infinite;
        }

        @keyframes pulse {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.02); }
        }

        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(40px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @media (max-width: 768px) {
            .stats-grid {
                grid-template-columns: 1fr;
                gap: 16px;
            }
            
            .header h1 {
                font-size: 1.8rem;
            }
            
            .card-stats {
                grid-template-columns: 1fr;
            }
            
            .special-stats {
                grid-template-columns: repeat(2, 1fr);
            }

            .stat-card {
                min-height: 160px;
                padding: 16px;
            }
        }

        .loading-shimmer {
            background: linear-gradient(90deg, #f0f0f0 25%, #e0e0e0 50%, #f0f0f0 75%);
            background-size: 200% 100%;
            animation: loading 1.5s infinite;
        }

        @keyframes loading {
            0% { background-position: 200% 0; }
            100% { background-position: -200% 0; }
        }

        /* Smooth scrolling */
        html {
            scroll-behavior: smooth;
        }

        /* Modern glassmorphism effect */
        .stat-card {
            backdrop-filter: blur(20px) saturate(180%);
            -webkit-backdrop-filter: blur(20px) saturate(180%);
            background-color: rgba(255, 255, 255, 0.95);
        }
    </style>
</head>
<body>
    <div class="dashboard-container">
        <!-- <div class="header">
            <h1><i class="fas fa-mosque"></i> Dashboard Madrasah</h1>
            <p>Sistem Informasi Keuangan Madrasah - Hari ini, <span id="currentDate"></span></p>
        </div> -->

        <?php
                include 'koneksi.php'; 
                require './kalenderhijriah.php';
                $kode= $_SESSION['kode'];
                $tgl=date('Y-m-d');
                $tglH= $hijri[2].'-'.$calendar->monthName($hijri[0]).'-'.sprintf('%02d', $hijri[1]);
                

                $kas1= mysqli_fetch_array(mysqli_query($koneksi,"SELECT SUM(debet-kredit)AS tkas FROM bukubesar WHERE kode_akun LIKE '%1.100.%' and kode='".$_SESSION['kode']."' ")); 
                extract($kas1);
                $kas2= mysqli_fetch_array(mysqli_query($koneksi,"SELECT SUM(debet-kredit)AS mkas FROM bukubesar WHERE kode_akun LIKE '%1.100.%' and kode='".$_SESSION['kode']."' ")); 
                extract($kas2);
                $bank1= mysqli_fetch_array(mysqli_query($koneksi,"SELECT SUM(debet-kredit)AS tbank FROM bukubesar WHERE kode_akun LIKE '%1.105.%' and kode='".$_SESSION['kode']."' ")); 
                extract($bank1);
                $bank2= mysqli_fetch_array(mysqli_query($koneksi,"SELECT SUM(debet-kredit)AS mbank FROM bukubesar WHERE tanggal= '$tgl' AND kode_akun LIKE '%1.105.%' and kode='".$_SESSION['kode']."' ")); 
                extract($bank2);

                $mTabungan= mysqli_fetch_array(mysqli_query($koneksi,"SELECT SUM(kredit-debet)AS mTabungan FROM mutasitabungan WHERE tgl2='$tgl'  ")); 
                extract($mTabungan);

                $akTabungan= mysqli_fetch_array(mysqli_query($koneksi,"SELECT SUM(kredit-debet)AS akTabungan FROM mutasitabungan  ")); 
                extract($akTabungan);
                $m_syahriah= mysqli_fetch_array(mysqli_query($koneksi,"SELECT SUM(bayar) AS mSyahriah FROM bulanan WHERE tgl='$tgl' AND kode='".$_SESSION['kode']."' ")); 
                extract($m_syahriah);
                $m_syahriah2= mysqli_fetch_array(mysqli_query($koneksi,"SELECT SUM(kewajiban)AS aKewajibanSyahriah,sum(bayar-kewajiban)AS aSisaSyahriah, SUM(bayar) AS mBayar2 FROM bulanan WHERE tglmasehi<='$tglH' AND kode='".$_SESSION['kode']."' ")); 
                extract($m_syahriah2);
                 $ak_syahriah= mysqli_fetch_array(mysqli_query($koneksi,"SELECT sum(bayar) AS aBayarSyahriah FROM bulanan WHERE tgl<='$tgl' AND kode='".$_SESSION['kode']."' ")); 
                extract($ak_syahriah);
                $m_kitab= mysqli_fetch_array(mysqli_query($koneksi,"SELECT SUM(bayar) AS mKitab FROM kitab WHERE tgl='$tgl' AND kode='".$_SESSION['kode']."' ")); 
                extract($m_kitab);
                 $ak_kitab= mysqli_fetch_array(mysqli_query($koneksi,"SELECT SUM(kewajiban)AS aKewajibanKitab,sum(bayar) AS aBayarKitab, sum(bayar-kewajiban)AS aSisaKitab FROM kitab WHERE kode='".$_SESSION['kode']."' ")); 
                extract($ak_kitab);
                $m_imda1= mysqli_fetch_array(mysqli_query($koneksi,"SELECT SUM(bayar) AS mImda1 FROM imda1 WHERE tgl='$tgl' AND kode='".$_SESSION['kode']."' ")); 
                extract($m_imda1);
                 $ak_imda1= mysqli_fetch_array(mysqli_query($koneksi,"SELECT SUM(kewajiban)AS aKewajibanimda1,sum(bayar) AS aBayarImda1, sum(bayar-kewajiban)AS aSisaImda1 FROM imda1 WHERE kode='".$_SESSION['kode']."' ")); 
                extract($ak_imda1);
                $m_ikhtibar= mysqli_fetch_array(mysqli_query($koneksi,"SELECT SUM(bayar) AS mIkhtibar FROM ikhtibar WHERE tgl='$tgl' AND kode='".$_SESSION['kode']."' ")); 
                extract($m_ikhtibar);
                 $ak_ikhtibar= mysqli_fetch_array(mysqli_query($koneksi,"SELECT SUM(kewajiban)AS aKewajibanIkhtibar,sum(bayar) AS aBayarIkhtibar, sum(bayar-kewajiban)AS aSisaIkhtibar FROM ikhtibar WHERE kode='".$_SESSION['kode']."' ")); 
                extract($ak_ikhtibar);
        ?>

        <div class="stats-grid">
            <!-- Kas Card -->
            <div class="stat-card kas pulse">
                <div class="card-header">
                    <div class="card-icon">
                        <i class="fas fa-money-check-alt"></i>
                    </div>
                    <div class="card-title">Kas</div>
                </div>
                <div class="card-stats">
                    <div class="stat-item highlight">
                        <div class="stat-label">Mutasi Hari Ini</div>
                        <div class="stat-value"><?php echo number_format($mkas, 0); ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Total Kas</div>
                        <div class="stat-value"><?php echo number_format($tkas, 0); ?></div>
                    </div>
                </div>
            </div>

            <!-- Tabungan Card -->
            <div class="stat-card tabungan">
                <div class="card-header">
                    <div class="card-icon">
                        <i class="fas fa-piggy-bank"></i>
                    </div>
                    <div class="card-title">Tabungan</div>
                </div>
                <div class="card-stats">
                    <div class="stat-item highlight">
                        <div class="stat-label">Mutasi Hari Ini</div>
                        <div class="stat-value"><?php echo number_format($mTabungan, 0); ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Total Tabungan</div>
                        <div class="stat-value"><?php echo number_format($akTabungan, 0); ?></div>
                    </div>
                </div>
            </div>

            <!-- Syahriah Card -->
            <div class="stat-card syahriah">
                <div class="card-header">
                    <div class="card-icon">
                        <i class="fas fa-calendar-check"></i>
                    </div>
                    <div class="card-title">Syahriah</div>
                </div>
                <div class="special-stats">
                    <div class="stat-item">
                        <div class="stat-label">Hari Ini</div>
                        <div class="stat-value"><?php echo number_format($mSyahriah, 0); ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Tagihan</div>
                        <div class="stat-value"><?php echo number_format($aKewajibanSyahriah, 0); ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Bayar</div>
                        <div class="stat-value"><?php echo number_format($mBayar2, 0); ?></div>
                    </div>
                    <div class="stat-item highlight">
                        <div class="stat-label">Terbayar</div>
                        <div class="stat-value"><?php echo number_format($aBayarSyahriah, 0); ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Sisa</div>
                        <div class="stat-value"><?php echo number_format($aSisaSyahriah, 0); ?></div>
                    </div>
                </div>
            </div>

            <!-- Ikhtibar Card -->
            <div class="stat-card ikhtibar">
                <div class="card-header">
                    <div class="card-icon">
                        <i class="fas fa-star-and-crescent"></i>
                    </div>
                    <div class="card-title">Ikhtibar</div>
                </div>
                <div class="special-stats">
                    <div class="stat-item">
                        <div class="stat-label">Hari Ini</div>
                        <div class="stat-value"><?php echo number_format($mIkhtibar, 0); ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Tagihan</div>
                        <div class="stat-value"><?php echo number_format($aKewajibanIkhtibar, 0); ?></div>
                    </div>
                    <div class="stat-item highlight">
                        <div class="stat-label">Terbayar</div>
                        <div class="stat-value"><?php echo number_format($aBayarIkhtibar, 0); ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Sisa</div>
                        <div class="stat-value"><?php echo number_format($aSisaIkhtibar, 0); ?></div>
                    </div>
                </div>
            </div>

            <!-- Kitab Card -->
            <div class="stat-card kitab">
                <div class="card-header">
                    <div class="card-icon">
                        <i class="fas fa-book-quran"></i>
                    </div>
                    <div class="card-title">Kitab</div>
                </div>
                <div class="special-stats">
                    <div class="stat-item">
                        <div class="stat-label">Hari Ini</div>
                        <div class="stat-value"><?php echo number_format($mKitab, 0); ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Tagihan</div>
                        <div class="stat-value"><?php echo number_format($aKewajibanKitab, 0); ?></div>
                    </div>
                    <div class="stat-item highlight">
                        <div class="stat-label">Terbayar</div>
                        <div class="stat-value"><?php echo number_format($aBayarKitab, 0); ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Sisa</div>
                        <div class="stat-value"><?php echo number_format($aSisaKitab, 0); ?></div>
                    </div>
                </div>
            </div>

            <!-- Seragam Card -->
            <div class="stat-card seragam">
                <div class="card-header">
                    <div class="card-icon">
                        <i class="fas fa-tshirt"></i>
                    </div>
                    <div class="card-title">Seragam</div>
                </div>
                <div class="special-stats">
                    <div class="stat-item">
                        <div class="stat-label">Hari Ini</div>
                        <div class="stat-value"><?php echo number_format($mSeragam, 0); ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Tagihan</div>
                        <div class="stat-value"><?php echo number_format($aKewajibanSeragam, 0); ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Terbayar</div>
                        <div class="stat-value"><?php echo number_format($aBayarSeragam, 0); ?></div>
                    </div>
                    <div class="stat-item highlight">
                        <div class="stat-label">Sisa</div>
                        <div class="stat-value"><?php echo number_format($aSisaSeragam, 0); ?></div>
                    </div>
                </div>
            </div>

            <!-- Maulid Card -->
            <div class="stat-card maulid">
                <div class="card-header">
                    <div class="card-icon">
                        <i class="fas fa-mosque"></i>
                    </div>
                    <div class="card-title">Maulid</div>
                </div>
                <div class="special-stats">
                    <div class="stat-item">
                        <div class="stat-label">Hari Ini</div>
                        <div class="stat-value"><?php echo number_format($mIuran, 0); ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Tagihan</div>
                        <div class="stat-value"><?php echo number_format($aKewajibanIuran, 0); ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Terbayar</div>
                        <div class="stat-value"><?php echo number_format($aBayarIuran, 0); ?></div>
                    </div>
                    <div class="stat-item highlight">
                        <div class="stat-label">Sisa</div>
                        <div class="stat-value"><?php echo number_format($aSisaIuran, 0); ?></div>
                    </div>
                </div>
            </div>

            <!-- Imni Card -->
            <div class="stat-card imni">
                <div class="card-header">
                    <div class="card-icon">
                        <i class="fas fa-star-and-crescent"></i>
                    </div>
                    <div class="card-title">Imni</div>
                </div>
                <div class="special-stats">
                    <div class="stat-item">
                        <div class="stat-label">Hari Ini</div>
                        <div class="stat-value"><?php echo number_format($mImni, 0); ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Tagihan</div>
                        <div class="stat-value"><?php echo number_format($aKewajibanImni, 0); ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Terbayar</div>
                        <div class="stat-value"><?php echo number_format($aBayarImni, 0); ?></div>
                    </div>
                    <div class="stat-item highlight">
                        <div class="stat-label">Sisa</div>
                        <div class="stat-value"><?php echo number_format($aSisaImni, 0); ?></div>
                    </div>
                </div>
            </div>

            <!-- Imda Card -->
            <div class="stat-card imda">
                <div class="card-header">
                    <div class="card-icon">
                        <i class="fas fa-graduation-cap"></i>
                    </div>
                    <div class="card-title">Imda</div>
                </div>
                <div class="special-stats">
                    <div class="stat-item">
                        <div class="stat-label">Hari Ini</div>
                        <div class="stat-value"><?php echo number_format($mImda1, 0); ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Tagihan</div>
                        <div class="stat-value"><?php echo number_format($aKewajibanimda1, 0); ?></div>
                    </div>
                    <div class="stat-item highlight">
                        <div class="stat-label">Terbayar</div>
                        <div class="stat-value"><?php echo number_format($aBayarImda1, 0); ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Sisa</div>
                        <div class="stat-value"><?php echo number_format($aSisaImda1, 0); ?></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Set current date
        function setCurrentDate() {
            const days = ['Minggu', 'Senin', 'Selasa', 'Rabu', 'Kamis', 'Jumat', 'Sabtu'];
            const months = ['Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni', 
                           'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'];
            
            const now = new Date();
            const dayName = days[now.getDay()];
            const day = now.getDate();
            const month = months[now.getMonth()];
            const year = now.getFullYear();
            
            document.getElementById('currentDate').textContent = 
                `${dayName}, ${day} ${month} ${year}`;
        }

        // Enhanced hover effects with smooth transitions
        document.querySelectorAll('.stat-card').forEach(card => {
            card.addEventListener('mouseenter', function() {
                this.style.transform = 'translateY(-8px) scale(1.02)';
                this.style.boxShadow = '0 20px 60px rgba(0, 0, 0, 0.25)';
            });
            
            card.addEventListener('mouseleave', function() {
                this.style.transform = 'translateY(0) scale(1)';
                this.style.boxShadow = '0 8px 32px rgba(0, 0, 0, 0.12)';
            });
        });

        // Add micro-interactions to stat items
        document.querySelectorAll('.stat-item').forEach(item => {
            item.addEventListener('mouseenter', function() {
                this.style.transform = 'translateY(-3px) scale(1.02)';
            });
            
            item.addEventListener('mouseleave', function() {
                this.style.transform = 'translateY(0) scale(1)';
            });
        });

        // Initialize
        setCurrentDate();
        
        // Enhanced loading animation with staggered effect
        document.querySelectorAll('.stat-value').forEach((element, index) => {
            element.style.opacity = '0';
            element.style.transform = 'translateY(10px)';
            setTimeout(() => {
                element.style.transition = 'all 0.6s cubic-bezier(0.25, 0.8, 0.25, 1)';
                element.style.opacity = '1';
                element.style.transform = 'translateY(0)';
            }, index * 100 + 300);
        });

        // Add subtle parallax effect on scroll
        window.addEventListener('scroll', () => {
            const scrolled = window.pageYOffset;
            const parallax = document.querySelectorAll('.stat-card');
            const speed = 0.1;

            parallax.forEach((element, index) => {
                const yPos = -(scrolled * speed * (index % 3 + 1));
                element.style.transform = `translateY(${yPos}px)`;
            });
        });
    </script>
</body>
</html>