<?php
include "koneksi.php";
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Data Jaminan Detail</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body { background: #eef3f9; }
        h2 { font-weight: 700; }
        .table-container {
            background: #fff;
            padding: 20px;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        .badge-jenis { font-size: 11px; }
        .img-thumb {
            width: 75px;
            height: 75px;
            border-radius: 10px;
            object-fit: cover;
            border: 2px solid #ddd;
        }
        .text-label { font-size: 12px; color: #555; display: block; }
        .value-detail { font-size: 13px; font-weight: 600; }
    </style>
</head>

<body>
<div class="container py-4">
    <h2 class="text-center text-primary mb-4">?? Data Lengkap Jaminan & Spesifikasi</h2>

    <div class="table-container">
        <table class="table table-bordered table-striped align-middle">
            <thead class="table-dark text-center">
                <tr>
                    <th>No</th>
                    <th>Foto</th>
                    <th>Nama Barang</th>
                    <th>Jenis Barang</th>
                    <th>Spesifikasi</th>
                    <th>Nilai Taksir</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>

            <?php
            $no = 1;
            $data = mysqli_query($koneksi, "SELECT * FROM jaminan ORDER BY created_at DESC");
            while ($row = mysqli_fetch_assoc($data)) {

                $foto = $row['foto'] ? "simpan/uploads/".$row['foto'] : "https://via.placeholder.com/75";
                $jenis  = $row['jenis_barang'];

                // Ambil spesifikasi sesuai jenis barang
                $detail = "- Tidak ada detail -";

                if ($jenis == "kendaraan") {
                    $s = mysqli_fetch_assoc(mysqli_query($koneksi, "SELECT * FROM sp_kendaraan WHERE id_jaminan='{$row['id']}'"));
                    if ($s) {
                        $detail = "
                        <span class='value-detail'>Merk: {$s['merk']}</span><br>
                        <span class='text-label'>Tipe: {$s['tipe']}, Tahun: {$s['tahun']}, Warna: {$s['warna']}</span><br>
                        <span class='text-label'>No.Pol: {$s['no_polisi']}</span>";
                    }
                }

                if ($jenis == "hp") {
                    $s = mysqli_fetch_assoc(mysqli_query($koneksi, "SELECT * FROM sp_hp WHERE id_jaminan='{$row['id']}'"));
                    if ($s) {
                        $detail = "
                        <span class='value-detail'>Merk: {$s['merk']} | RAM: {$s['ram']} GB</span><br>
                        <span class='text-label'>IMEI: {$s['imei']} | Storage: {$s['storage']} GB</span>";
                    }
                }

                if ($jenis == "emas") {
                    $s = mysqli_fetch_assoc(mysqli_query($koneksi, "SELECT * FROM sp_emas WHERE id_jaminan='{$row['id']}'"));
                    if ($s) {
                        $detail = "
                        <span class='value-detail'>Karat: {$s['karat']}K</span><br>
                        <span class='text-label'>Berat: {$s['berat']} gram | Bentuk: {$s['bentuk']}</span>";
                    }
                }

                if ($jenis == "laptop") {
                    $s = mysqli_fetch_assoc(mysqli_query($koneksi, "SELECT * FROM sp_laptop WHERE id_jaminan='{$row['id']}'"));
                    if ($s) {
                        $detail = "
                        <span class='value-detail'>Merk: {$s['merk']} | CPU: {$s['processor']}</span><br>
                        <span class='text-label'>RAM: {$s['ram']} GB | Storage: {$s['storage']} GB</span>";
                    }
                }

                if ($jenis == "sertipikat") {
                    $s = mysqli_fetch_assoc(mysqli_query($koneksi, "SELECT * FROM sp_sertipikat WHERE id_jaminan='{$row['id']}'"));
                    if ($s) {
                        $alamat = strlen($s['alamat']) > 25 ? substr($s['alamat'],0,25)."..." : $s['alamat'];
                        $detail = "
                        <span class='value-detail'>Luas: {$s['luas']} m</span><br>
                        <span class='text-label'>{$alamat}</span>";
                    }
                }

                if ($jenis == "speaker") {
                    $s = mysqli_fetch_assoc(mysqli_query($koneksi, "SELECT * FROM sp_speaker WHERE id_jaminan='{$row['id']}'"));
                    if ($s) {
                        $detail = "
                        <span class='value-detail'>Merk: {$s['merk']}</span><br>
                        <span class='text-label'>Tipe: {$s['tipe']} | Watt: {$s['daya']}W</span>";
                    }
                }
            ?>

                <tr>
                    <td class="text-center fw-bold"><?= $no++; ?></td>
                    <td class="text-center">
                        <img src="<?= $foto; ?>" class="img-thumb">
                    </td>
                    <td><?= $row['nama_barang']; ?></td>
                    <td class="text-center">
                        <span class="badge bg-info badge-jenis"><?= strtoupper($jenis); ?></span>
                    </td>
                    <td><?= $detail; ?></td>
                    <td class="text-success fw-bold text-center">
                        Rp <?= number_format($row['nilai_taksir'], 0, ',', '.'); ?>
                    </td>
                    <td class="text-center">
                        <a href="detail_jaminan.php?id=<?= $row['id']; ?>" class="btn btn-primary btn-sm">Detail</a>
                    </td>
                </tr>

            <?php } ?>
            </tbody>
        </table>
    </div>
</div>
</body>
</html>
