<?php
error_reporting(E_ALL^(E_NOTICE|E_WARNING));
ini_set('display_errors',1);
error_reporting(0);
include 'koneksi.php';
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kartu Tabungan - MMU-A39</title>
    <!-- Bootstrap CSS -->
    <!-- <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"> -->
    <!-- Font Awesome -->
    <!-- <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet"> -->
    <!-- Google Fonts -->
    <!-- <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet"> -->
    
    <style>
        * {
            font-family: 'Poppins', sans-serif;
        }
        
        body {
            background: linear-gradient(135deg,rgb(185, 192, 227) 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px 0;
        }
        
        .main-container {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
            overflow: hidden;
        }
        
        .header-section {
            background: linear-gradient(135deg, #2c3e50 0%, #3498db 100%);
            color: white;
            padding: 30px;
            position: relative;
            overflow: hidden;
        }
        
        .header-section::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -50%;
            width: 200%;
            height: 200%;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="50" cy="50" r="1" fill="rgba(255,255,255,0.1)"/></pattern></defs><rect width="100%" height="100%" fill="url(%23grain)"/></svg>');
            animation: float 20s infinite linear;
        }
        
        @keyframes float {
            0% { transform: translate(-50%, -50%) rotate(0deg); }
            100% { transform: translate(-50%, -50%) rotate(360deg); }
        }
        
        .header-content {
            position: relative;
            z-index: 2;
        }
        
        .bank-logo {
            width: 60px;
            height: 60px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 15px;
        }
        
        .search-section {
            background: white;
            padding: 30px;
            border-bottom: 1px solid #eee;
        }
        
        .search-card {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            border-radius: 15px;
            padding: 25px;
            border: none;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
        }
        
        .form-control {
            border: 2px solid #e9ecef;
            border-radius: 10px;
            padding: 12px 15px;
            font-size: 16px;
            transition: all 0.3s ease;
        }
        
        .form-control:focus {
            border-color: #3498db;
            box-shadow: 0 0 0 0.2rem rgba(52, 152, 219, 0.25);
        }
        
        .btn-search {
            background: linear-gradient(135deg, #3498db 0%, #2980b9 100%);
            border: none;
            border-radius: 10px;
            padding: 12px 25px;
            font-weight: 600;
            transition: all 0.3s ease;
            box-shadow: 0 5px 15px rgba(52, 152, 219, 0.3);
        }
        
        .btn-search:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(52, 152, 219, 0.4);
        }
        
        .btn-pdf {
            background: linear-gradient(135deg, #e74c3c 0%, #c0392b 100%);
            border: none;
            border-radius: 10px;
            padding: 12px 25px;
            font-weight: 600;
            color: white;
            text-decoration: none;
            display: inline-block;
            transition: all 0.3s ease;
            box-shadow: 0 5px 15px rgba(231, 76, 60, 0.3);
        }
        
        .btn-pdf:hover {
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(231, 76, 60, 0.4);
        }
        
        .account-info {
            background: white;
            padding: 30px;
            border-bottom: 1px solid #eee;
        }
        
        .info-card {
            background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
            border-radius: 15px;
            padding: 25px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
            border-left: 5px solid #3498db;
        }
        
        .info-row {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 8px 0;
            border-bottom: 1px solid #eee;
        }
        
        .info-row:last-child {
            border-bottom: none;
        }
        
        .info-label {
            font-weight: 500;
            color: #6c757d;
            min-width: 120px;
        }
        
        .info-value {
            font-weight: 600;
            color: #2c3e50;
        }
        
        .balance-highlight {
            color: #27ae60 !important;
            font-size: 1.2em;
        }
        
        .status-active {
            color: #27ae60;
            background: rgba(39, 174, 96, 0.1);
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 0.9em;
        }
        
        .status-inactive {
            color: #e74c3c;
            background: rgba(231, 76, 60, 0.1);
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 0.9em;
        }
        
        .table-section {
            background: white;
            padding: 30px;
        }
        
        .table-modern {
            background: white;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
        }
        
        .table-modern thead th {
            background: linear-gradient(135deg, #34495e 0%, #2c3e50 100%);
            color: white;
            font-weight: 600;
            text-align: center;
            padding: 15px;
            border: none;
            font-size: 14px;
        }
        
        .table-modern tbody td {
            padding: 12px 15px;
            border-bottom: 1px solid #eee;
            vertical-align: middle;
        }
        
        .table-modern tbody tr:hover {
            background: rgba(52, 152, 219, 0.05);
            transition: all 0.3s ease;
        }
        
        .table-modern tbody tr:last-child td {
            border-bottom: none;
        }
        
        .amount-debet {
            color: #e74c3c;
            font-weight: 600;
        }
        
        .amount-kredit {
            color: #27ae60;
            font-weight: 600;
        }
        
        .amount-saldo {
            color: #2c3e50;
            font-weight: 600;
        }
        
        .no-data-message {
            text-align: center;
            padding: 50px;
            color: #6c757d;
            font-style: italic;
        }
        
        .no-data-icon {
            font-size: 4rem;
            margin-bottom: 20px;
            color: #dee2e6;
        }
        
        @media (max-width: 768px) {
            .main-container {
                margin: 10px;
                border-radius: 15px;
            }
            
            .header-section,
            .search-section,
            .account-info,
            .table-section {
                padding: 20px;
            }
            
            .table-responsive {
                font-size: 14px;
            }
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="main-container mx-auto" style="max-width: 1200px;">
            
            <!-- Header Section -->
            <div class="header-section">
                <div class="header-content">
                    <div class="d-flex align-items-center justify-content-between">
                        <div class="d-flex align-items-center">
                            <div class="bank-logo">
                                <i class="fas fa-wallet fa-2x"></i>
                            </div>
                            <div class="ms-3">
                                <h2 class="mb-1">Kartu Tabungan</h2>
                                <p class="mb-0 opacity-75">Murid MMU A-39</p>
                            </div>
                        </div>
                        <div class="text-end">
                            <p class="mb-0 opacity-75">Sistem Informasi</p>
                            <p class="mb-0">Keuangan Madrasah</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Search Section -->
            <div class="search-section">
                <div class="search-card">
                    <?php          
                    $kode=$_SESSION['kode'];
                    if(isset($_POST['rekening'])){
                        $rekening_parts = explode('.', $_POST['rekening']);
                        $rekening1 = $rekening_parts[0];
                        $rekening3 = isset($rekening_parts[1]) ? substr($rekening_parts[1], 0, 6) : '';
                        $rekening4 = $rekening_parts[2];
                        $rekening= $rekening1.".11.".sprintf("%06d",$rekening3).".".sprintf("%02d",$rekening4);
                        
                        if($_POST['rekening']=='Pilih')
                            $where="where rekening='0'";
                        else
                            $where="where a.rekening='$rekening' ";
                    }else{
                        $rekening="";
                        $where="where a.rekening='$rekening'";
                    }
                    ?>
                    
                    <form role="form" id="quickForm" action="" method="POST">
                        <div class="row align-items-end">
                            <div class="col-md-8">
                                <label for="rekening" class="form-label fw-semibold">
                                    <i class="fas fa-search me-2"></i>Nomor Rekening
                                </label>
                                <input type="text" 
                                       id="rekening" 
                                       name="rekening" 
                                       maxlength="16" 
                                       value="<?php echo isset($_POST['rekening']) ? $_POST['rekening'] : ''; ?>" 
                                       class="form-control" 
                                       placeholder="Masukkan nomor rekening..."
                                       autofocus>
                            </div>
                            <div class="col-md-4">
                                <button type="submit" name="proses" value="Cari" class="btn btn-search w-100">
                                    <i class="fas fa-search me-2"></i>Cari Data
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <?php 
            if(isset($_POST['rekening'])){
                $_SESSION['ktabungan']['judul']="KARTU TABUNGAN";
                $_SESSION['ktabungan']['unit']="MMU A-39";
                $_SESSION['ktabungan']['rekening']=$_POST['rekening'];
                
                if($_POST['rekening']=='Pilih')
                    $_SESSION['laporan']['rekening']='Pilih';
                else
                    $_SESSION['laporan']['rekening']="SELECT * FROM mutasitabungan where rekening='".$_POST['rekening']."'";

                // Function to format currency
                function buatrp($angka) {
                    if (is_null($angka) || !is_numeric($angka)) {
                        $angka = 0;
                    }
                    return number_format($angka, 0, ',', '.');
                }

                require './kalenderhijriah.php';
                $querya = "SELECT c.tgl as tgl,a.rekening as rekening, SUM(a.kredit-a.debet) AS saldotab,a.debet AS debet,a.kredit AS kredit,a.username AS username,b.nama AS nama,b.alamat AS alamat,b.rtrw as rtrw,c.blokir AS blokir,c.tutup AS tutup FROM mutasitabungan a LEFT JOIN registrasi b ON a.id=b.id LEFT JOIN bukutabungan c ON a.rekening=c.rekening $where ";
                
                $query = mysqli_query($koneksi,$querya);
                
                if(mysqli_num_rows($query)){
                    while ($data = mysqli_fetch_assoc($query)) {
                        $tgl = $data['tgl'];
                        $rekening = $data['rekening'];
                        $nama = $data['nama'];
                        $alamat = $data['alamat'];
                        $rtrw = $data['rtrw'];
                        $blokir = $data['blokir'];
                        $tutup = $data['tutup'];
                        $saldotab = $data['saldotab'];
                        $kredit = $data['kredit'];
                        $debet = $data['debet'];
                        $usersys = $data['username'];
                    }
                }
            ?>

            <!-- Account Information Section -->
            <div class="account-info">
                <div class="row">
                    <div class="col-md-8">
                        <div class="info-card">
                            <h5 class="mb-3 text-primary">
                                <i class="fas fa-user-circle me-2"></i>Informasi Nasabah
                            </h5>
                            <div class="info-row">
                                <span class="info-label">Nama</span>
                                <span class="info-value"><?php echo $nama; ?></span>
                            </div>
                            <div class="info-row">
                                <span class="info-label">Rekening</span>
                                <span class="info-value"><?php echo $_POST['rekening']; ?></span>
                            </div>
                            <div class="info-row">
                                <span class="info-label">Alamat</span>
                                <span class="info-value"><?php echo $alamat." ".$rtrw; ?></span>
                            </div>
                            <div class="info-row">
                                <span class="info-label">Tanggal</span>
                                <span class="info-value"><?php echo isset($hijri) ? sprintf('%02d', $hijri[1]) . '-' . $calendar->monthName($hijri[0]) . '-' . $hijri[2] : date('d-m-Y'); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="info-card">
                            <h5 class="mb-3 text-success">
                                <i class="fas fa-wallet me-2"></i>Status Rekening
                            </h5>
                            <div class="info-row">
                                <span class="info-label">Saldo</span>
                                <span class="info-value balance-highlight">Rp <?php echo buatrp($saldotab); ?></span>
                            </div>
                            <div class="info-row">
                                <span class="info-label">Blokir</span>
                                <span class="<?php echo $blokir == "1" ? 'status-inactive' : 'status-active'; ?>">
                                    <?php echo $blokir == "1" ? "Ya" : "Tidak"; ?>
                                </span>
                            </div>
                            <div class="info-row">
                                <span class="info-label">Status</span>
                                <span class="<?php echo $tutup == "1" ? 'status-inactive' : 'status-active'; ?>">
                                    <?php echo $tutup == "1" ? "Tutup" : "Aktif"; ?>
                                </span>
                            </div>
                            <div class="mt-3 text-center">
                                <a href="pdf/lap_kartu_tabungan_pdf.php" target="_blank" class="btn-pdf">
                                    <i class="fa fa-print me-2"></i>Cetak PDF
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Transaction Table Section -->
            <div class="table-section">
                <h5 class="mb-4 text-dark">
                    <i class="fas fa-history me-2"></i>Riwayat Transaksi
                </h5>
                
                <div class="table-responsive">
                    <table class="table table-modern">
                        <thead>
                            <tr>
                                <th style="width: 5%">No</th>
                                <th style="width: 12%">Tanggal</th>
                                <th style="width: 10%">No. Bukti</th>
                                <th style="width: 15%">Debet</th>
                                <th style="width: 15%">Kredit</th>
                                <th style="width: 15%">Saldo</th>
                                <th style="width: 28%">Keterangan</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            $no = 1;
                            $t_saldotab = 0;
                            $t_debet = 0;
                            $t_kredit = 0;
                            
                            $queryp = "SELECT tgl as tgl,no_bukti AS no_bukti,rekening as rekening,SUM(kredit-debet) AS saldotab,debet AS debet,kredit AS kredit, keterangan as keterangan FROM mutasitabungan WHERE rekening='$rekening' GROUP BY no ORDER BY no,tgl ASC ";
                            $query = mysqli_query($koneksi,$queryp);
                            
                            if(mysqli_num_rows($query)){
                                while ($data = mysqli_fetch_assoc($query)) {
                                    $tgl = $data['tgl'];
                                    $no_bukti = $data['no_bukti'];
                                    $rekening_row = $data['rekening'];
                                    $saldotab_row = $data['saldotab'];
                                    $keterangan = $data['keterangan'];
                                    $kredit = $data['kredit'];
                                    $debet = $data['debet'];
                                    
                                    $t_saldotab += $kredit - $debet;
                                    $t_debet += $debet;
                                    $t_kredit += $kredit;
                            ?>                     
                            <tr>
                                <td class="text-center"><?php echo $no++; ?></td>
                                <td class="text-center"><?php echo date('d-m-Y', strtotime($tgl)); ?></td>
                                <td class="text-center"><?php echo $no_bukti; ?></td>
                                <td class="text-end amount-debet"><?php echo $debet > 0 ? 'Rp ' . buatrp($debet) : '-'; ?></td>
                                <td class="text-end amount-kredit"><?php echo $kredit > 0 ? 'Rp ' . buatrp($kredit) : '-'; ?></td>
                                <td class="text-end amount-saldo">Rp <?php echo buatrp($t_saldotab); ?></td>
                                <td><?php echo $keterangan; ?></td>
                            </tr>  
                            <?php
                                }
                            } else {
                            ?>
                            <tr>
                                <td colspan="7" class="no-data-message">
                                    <div class="no-data-icon">
                                        <i class="fas fa-inbox"></i>
                                    </div>
                                    <p>Tidak ada data transaksi untuk rekening ini.</p>
                                </td>
                            </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <?php 
                $_SESSION['ktabungan']['sql1'] = $querya;
                $_SESSION['ktabungan']['sql2'] = $queryp;
            } else {
            ?>
            <!-- No Search Message -->
            <div class="account-info">
                <div class="text-center no-data-message">
                    <div class="no-data-icon">
                        <i class="fas fa-search"></i>
                    </div>
                    <h5>Cari Rekening Tabungan</h5>
                    <p>Silakan masukkan nomor rekening pada kolom pencarian di atas untuk melihat informasi kartu tabungan.</p>
                </div>
            </div>
            <?php } ?>

        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>