<?php
require './kalenderhijriah.php';
error_reporting(E_ALL^(E_NOTICE|E_WARNING));
ini_set('display_errors',1);
error_reporting(0);
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Laporan Rekap</title>
    <!-- Bootstrap 5 -->
   <!--  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"> -->
    <!-- Font Awesome -->
   <!--  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"> -->
    <!-- Google Fonts -->
    <!-- <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet"> -->
    <!-- DataTables -->
    <!-- <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css"> -->
    
    <style>
        :root {
            --primary-color: #2c3e50;
            --secondary-color: #3498db;
            --accent-color: #e74c3c;
            --success-color: #27ae60;
            --warning-color: #f39c12;
            --light-bg: #f8f9fa;
            --card-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
            --card-shadow-hover: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
        }

        /* body {
            font-family: 'Inter', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            color: #2c3e50;
        } */

        .main-container {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
            margin: 20px;
            overflow: hidden;
        }

        .header-section {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            color: white;
            padding: 2rem;
            position: relative;
            overflow: hidden;
        }

        .header-section::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
            animation: float 6s ease-in-out infinite;
        }

        @keyframes float {
            0%, 100% { transform: translateY(0px) rotate(0deg); }
            50% { transform: translateY(-20px) rotate(5deg); }
        }

        .header-content {
            position: relative;
            z-index: 2;
        }

        .page-title {
            font-size: 1.5rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.3);
        }

        .page-subtitle {
            font-size: 1.1rem;
            opacity: 0.9;
            font-weight: 300;
        }

        .search-card {
            background: white;
            border-radius: 15px;
            box-shadow: var(--card-shadow);
            border: none;
            margin: -30px 20px 30px 20px;
            position: relative;
            z-index: 3;
        }

        .search-card-header {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            border-radius: 15px 15px 0 0;
            border-bottom: 1px solid rgba(0, 0, 0, 0.05);
            padding: 1.5rem;
        }

        .search-card-body {
            padding: 2rem;
        }

        .form-control {
            border: 2px solid #e9ecef;
            border-radius: 10px;
            padding: 0.75rem 1rem;
            font-size: 0.95rem;
            transition: all 0.3s ease;
        }

        .form-control:focus {
            border-color: var(--secondary-color);
            box-shadow: 0 0 0 0.2rem rgba(52, 152, 219, 0.25);
        }

        .btn {
            border-radius: 10px;
            padding: 0.75rem 1.5rem;
            font-weight: 500;
            transition: all 0.3s ease;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .btn-search {
            background: linear-gradient(135deg, var(--secondary-color) 0%, #2980b9 100%);
            border: none;
            color: white;
        }

        .btn-search:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(52, 152, 219, 0.4);
            color: white;
        }

        .btn-pdf {
            background: linear-gradient(135deg, var(--success-color) 0%, #219a52 100%);
            border: none;
            color: white;
        }

        .btn-pdf:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(39, 174, 96, 0.4);
            color: white;
        }

        .data-card {
            background: white;
            border-radius: 15px;
            box-shadow: var(--card-shadow);
            border: none;
            margin: 20px;
        }

        .data-card-header {
            background: linear-gradient(135deg, var(--primary-color) 0%, #34495e 100%);
            color: white;
            border-radius: 15px 15px 0 0;
            padding: 1.5rem;
            border-bottom: none;
        }

        .table-responsive {
            border-radius: 0 0 15px 15px;
            overflow: hidden;
        }

        .table {
            margin-bottom: 0;
        }

        .table thead th {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            border: none;
            color: var(--primary-color);
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            font-size: 0.85rem;
            padding: 1rem;
        }

        .table tbody tr {
            transition: all 0.3s ease;
        }

        .table tbody tr:hover {
            background-color: rgba(52, 152, 219, 0.05);
            transform: scale(1.01);
        }

        .table tbody td {
            padding: 1rem;
            border-color: rgba(0, 0, 0, 0.05);
            vertical-align: middle;
        }

        .table-total {
            background: linear-gradient(135deg, var(--primary-color) 0%, #34495e 100%);
            color: white;
            font-weight: 600;
        }

        .table-total td {
            border-color: rgba(255, 255, 255, 0.2);
        }

        .badge-class {
            background: linear-gradient(135deg, var(--warning-color) 0%, #e67e22 100%);
            color: white;
            padding: 0.5rem 1rem;
            border-radius: 50px;
            font-size: 0.8rem;
            font-weight: 500;
        }

        .number-highlight {
            font-weight: 600;
            color: var(--success-color);
        }

        .date-picker-container {
            position: relative;
        }

        .calendar-icon {
            position: absolute;
            right: 10px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--secondary-color);
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .calendar-icon:hover {
            color: var(--primary-color);
            transform: translateY(-50%) scale(1.1);
        }

        .datepicker {
            position: absolute;
            z-index: 1000;
            background: white;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
            border: 1px solid rgba(0, 0, 0, 0.1);
        }

        .stats-card {
            background: white;
            border-radius: 15px;
            padding: 1.5rem;
            box-shadow: var(--card-shadow);
            transition: all 0.3s ease;
            margin-bottom: 20px;
        }

        .stats-card:hover {
            transform: translateY(-5px);
            box-shadow: var(--card-shadow-hover);
        }

        .stats-number {
            font-size: 2rem;
            font-weight: 700;
            color: var(--secondary-color);
        }

        .stats-label {
            color: #6c757d;
            font-size: 0.9rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .loading-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.9);
            display: none;
            justify-content: center;
            align-items: center;
            z-index: 9999;
        }

        .spinner {
            width: 50px;
            height: 50px;
            border: 5px solid #f3f3f3;
            border-top: 5px solid var(--secondary-color);
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        @media (max-width: 768px) {
            .main-container {
                margin: 10px;
                border-radius: 15px;
            }
            
            .page-title {
                font-size: 1.8rem;
            }
            
            .search-card {
                margin: -20px 10px 20px 10px;
            }
            
            .data-card {
                margin: 10px;
            }
            
            .table-responsive {
                font-size: 0.85rem;
            }
            
            .btn {
                padding: 0.5rem 1rem;
                font-size: 0.85rem;
            }
        }
    </style>
</head>

<body>
    <div class="loading-overlay" id="loadingOverlay">
        <div class="spinner"></div>
    </div>

    <div class="container-fluid">
        <div class="main-container">
            <!-- Header Section -->
            <div class="header-section">
                <div class="header-content">
                    <h1 class="page-title">
                        <i class="fas fa-chart-line me-3"></i>
                        Laporan Rekap Saldo Tabungan
                    </h1>
                    <!-- <p class="page-subtitle">
                        <i class="fas fa-calendar-alt me-2"></i>
                        Sistem Manajemen Keuangan - Dashboard Laporan
                    </p> -->
                </div>
            </div>

            <!-- Search Form Card -->
            <div class="card search-card">
                <!-- <div class="search-card-header">
                    <h5 class="mb-0">
                        <i class="fas fa-search me-2"></i>
                        Filter & Pencarian Data
                    </h5>
                </div> -->
                <div class="search-card-body">
                    <?php
                    $username = $_SESSION['username'];
                    $kode = $_SESSION['kode']; 
                    
                    if(isset($_POST['p_rekening'])){
                       /*  $par1 = date('Y-m-d',strtotime($_POST['par1'])); */
                        $par2 = date('Y-m-d',strtotime($_POST['par2']));
                        $id = $_POST['p_rekening'];

                        if($_POST['p_rekening'] !== '') {
                            $where = "WHERE a.rekening like '%".$id."%' OR b.nama like '%".$id."%' GROUP by a.rekening ";
                        } else {
                            $where = "WHERE a.tgl<='$par2' GROUP by a.rekening ";
                        }
                    } else {
                        $id = "";
                        $where = "where a.rekening='$id' ";
                    }
                    ?>
                    
                    <form role="form" id="searchForm" action="home.php?home=<?php echo md5("rekap_saldo_tabungan");?>" method="post">
                        <div class="row g-3 align-items-end">
                            <div class="col-md-4">
                                <label for="p_rekening" class="form-label fw-semibold">
                                    <i class="fas fa-user me-1"></i>
                                    Cari Data Nasabah
                                </label>
                                <input type="text" 
                                       name="p_rekening" 
                                       id="p_rekening" 
                                       class="form-control" 
                                       placeholder="Ketik Register/Nama/Alamat/No Register/Ayah"
                                       value="<?php echo isset($_POST['p_rekening']) ? $_POST['p_rekening'] : ''; ?>">
                            </div>
                            
                            <div class="col-md-3">
                                <label for="par2" class="form-label fw-semibold">
                                    <i class="fas fa-calendar me-1"></i>
                                    Tanggal Laporan
                                </label>
                                <div class="date-picker-container" id="datepicker">
                                    <input id="par2" 
                                           name="par2" 
                                           type="text" 
                                           class="form-control" 
                                           value="<?php 
                                               if(isset($_POST['par2'])){ 
                                                   echo $_POST['par2']; 
                                               } else { 
                                                   echo sprintf('%02d', $hijri[1]) . '-' . $calendar->monthName($hijri[0]) . '-' . $hijri[2];
                                               } 
                                           ?>" />
                                    <i class="fas fa-calendar-alt calendar-icon" id="pick-button"  alt="Pick Date" style="cursor: pointer; position: absolute; right: 10px; top: 50%; transform: translateY(-50%);" onclick="pickADate(event);"></i>
                                   
                                    <div id="calendar-popup2" class="datepicker" style="display:none;"></div>
                                </div>
                                <!-- <input id="par1" name="par1" type="hidden" value="<A?php 
                                    if(isset($_POST['par1'])){ 
                                        echo $_POST['par1']; 
                                    } else { 
                                        echo sprintf('%02d', $hijri[1]) . '-' . $calendar->monthName($hijri[0]) . '-' . $hijri[2];
                                    } 
                                ?>"/> -->
                            </div>
                            
                            <div class="col-md-2">
                                <button type="submit" class="btn btn-search w-100">
                                    <i class="fas fa-search me-2"></i>
                                    Cari
                                </button>
                            </div>
                            
                            <?php if(isset($_POST['par2'])){ ?>
                            <div class="col-md-3">
                                <?php
                                $_SESSION['tabungan']['periode'] = date('d-m-Y',strtotime($_POST['par2']));
                                $_SESSION['tabungan']['kantor'] = $_SESSION['kantor'];
                                ?>
                                <a href="pdf/lap_rekap_saldotabunganpdf.php" 
                                   target="_blank" 
                                   class="btn btn-pdf w-100">
                                    <i class="fas fa-file-pdf me-2"></i>
                                    Export PDF
                                </a>
                            </div>
                            <?php } ?>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Statistics Cards -->
            <?php if(isset($_POST['p_rekening'])){ ?>
            <div class="row mx-3">
                <div class="col-md-4">
                    <div class="stats-card">
                        <div class="stats-label">Total Rekening</div>
                        <div class="stats-number" id="totalRekening">0</div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="stats-card">
                        <div class="stats-label">Total Saldo</div>
                        <div class="stats-number text-success" id="totalSaldo">Rp 0</div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="stats-card">
                        <div class="stats-label">Periode Laporan</div>
                        <div class="stats-number" style="font-size: 1.2rem;">
                            <?php echo date('d M Y', strtotime($_POST['par2'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php } ?>

            <!-- Data Table Card -->
            <div class="card data-card">
                <div class="data-card-header">
                    <h5 class="mb-0">
                        <i class="fas fa-table me-2"></i>
                        Data Rekap Saldo Tabungan
                    </h5>
                </div>
                
                <div class="table-responsive">
                    <table class="table table-hover" id="dataTable">
                        <thead>
                            <tr>
                                <th style="width: 5%;">
                                    <i class="fas fa-hashtag me-1"></i>
                                    No
                                </th>
                              <!--   <th style="width: 12%;">
                                    <i class="fas fa-calendar me-1"></i>
                                    Tanggal
                                </th> -->
                                <th style="width: 15%;">
                                    <i class="fas fa-credit-card me-1"></i>
                                    Rekening
                                </th>
                                <th style="width: 25%;">
                                    <i class="fas fa-user me-1"></i>
                                    Nama Nasabah
                                </th>
                                <th style="width: 8%;">
                                    <i class="fas fa-layer-group me-1"></i>
                                    Kelas
                                </th>
                                <th style="width: 15%;">
                                    <i class="fas fa-money-bill-wave me-1"></i>
                                    Saldo
                                </th>
                                <th style="width: 12%;">
                                    <i class="fas fa-user-cog me-1"></i>
                                    User
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            include 'koneksi.php';
                            $queryp = "SELECT b.klsNow as kls,a.no_bukti AS no_bukti,a.rekening as id, a.rekening as rekening, a.tgl as tgl, b.nama as nama, SUM(kredit-debet) AS saldotab, a.keterangan AS keterangan, a.username as username FROM mutasitabungan a LEFT JOIN registrasi b ON a.id=b.id $where";
                            $querya = mysqli_query($koneksi, $queryp);
                            
                            if (mysqli_num_rows($querya)) {
                                $_SESSION['tabungan']['kode']['sqlp'] = $queryp;
                                $no = 0;
                                $t_saldotab = 0;
                                
                                while ($data = mysqli_fetch_assoc($querya)) {
                                    $tgl = $data['tgl'];
                                    $kls = $data['kls'];
                                    $rekening = $data['rekening'];
                                    $nama = $data['nama'];
                                    $saldotab = $data['saldotab'];
                                    $usersys = $data['username'];
                                    $t_saldotab += $saldotab;
                                    $no++;
                            ?>
                                    <tr>
                                        <td class="text-center fw-semibold"><?php echo $no; ?></td>
                                        <!-- <td>
                                            <span class="badge bg-light text-dark">
                                                <?php echo date('d-m-Y', strtotime($tgl)); ?>
                                            </span>
                                        </td> -->
                                        <td class="fw-semibold text-primary"><?php echo $rekening; ?></td>
                                        <td>
                                            <div class="fw-semibold"><?php echo $nama; ?></div>
                                        </td>
                                        <td>
                                            <span class="badge-class"><?php echo $kls; ?></span>
                                        </td>
                                        <td class="number-highlight">
                                            Rp <?php echo number_format($saldotab, 0, ',', '.'); ?>
                                        </td>
                                        <td>
                                            <span class="badge bg-secondary"><?php echo $usersys; ?></span>
                                        </td>
                                    </tr>
                            <?php
                                }
                            } else {
                                echo '<tr><td colspan="7" class="text-center text-muted py-4">
                                        <i class="fas fa-inbox fa-3x mb-3 d-block"></i>
                                        Tidak ada data yang ditemukan
                                      </td></tr>';
                            }
                            ?>
                        </tbody>
                        <?php if(isset($t_saldotab) && $t_saldotab > 0) { ?>
                        <tr class="table-total">
                            <td colspan="4" class="text-center fw-bold">
                                <i class="fas fa-calculator me-2"></i>
                                TOTAL KESELURUHAN
                            </td>
                            <td class="fw-bold fs-5">
                                <?php echo number_format($t_saldotab, 0, ',', '.'); ?>
                            </td>
                            <td></td>
                        </tr>
                        <?php } ?>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <!-- <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
     -->
    <!-- Calendar Scripts -->
    <link rel="stylesheet" href="calendar.css"/>
    <script type="text/javascript" src="hijri-date.js"></script>
    <script type="text/javascript" src="calendar.js"></script>
    <script type="text/javascript">
    var pickedTxt = document.getElementById('par2'),
        pickBtn = document.getElementById('pick-button'),
        datepicker = new Calendar(true, 0, false, true); // Siapkan sebagai kalender Hijriah
    
    // Tambahkan ID ke elemen datepicker untuk referensi
    datepicker.getElement().id = 'calendar-popup';
    document.getElementById('datepicker').appendChild(datepicker.getElement());

    // Set properti CSS untuk datepicker
    datepicker.getElement().style.position = 'absolute';
    datepicker.getElement().style.zIndex = '1000';
    datepicker.getElement().style.display = 'none'; // Sembunyikan kalender secara default

    datepicker.callback = function() {
        var selectedDate = datepicker.getDate();
        var day = selectedDate.getDate().toString().padStart(2, '0');
        var month = (selectedDate.getMonth() + 1).toString().padStart(2, '0');
        var year = selectedDate.getFullYear();
        pickedTxt.value = day + '-' + month + '-' + year;
        pickedTxt.focus();
        datepicker.hide();
    };

    function pickADate(event) {
        event.stopPropagation(); // Mencegah event bubbling
        datepicker.show();
        positionDatepicker(); // Atur posisi datepicker
    }

   /*  function positionDatepicker() {
        var rect = pickedTxt.getBoundingClientRect();
        datepicker.getElement().style.left = rect.left + "px";
        datepicker.getElement().style.top = (rect.bottom + 1) + "px"; // Tampilkan di bawah input dengan sedikit jarak
        
        // Cek apakah keluar dari viewport bawah
        var bottomSpace = window.innerHeight - rect.bottom;
        var calendarHeight = datepicker.getElement().offsetHeight;
        
        if (bottomSpace < calendarHeight + 10) {
            // Jika tidak cukup ruang di bawah, tampilkan di atas input
            datepicker.getElement().style.top = (rect.top - calendarHeight - 5) + "px";
        }
    } */

    // Event listener untuk menutup kalender ketika klik di luar
    document.addEventListener('click', function(event) {
        var calendarElement = datepicker.getElement();
        if (calendarElement.style.display !== 'none' && 
            event.target !== pickedTxt && 
            event.target !== pickBtn && 
            !calendarElement.contains(event.target)) {
            datepicker.hide();
        }
    });

    // Menambahkan kemampuan untuk menggeser datepicker
    var isDragging = false;
    var offsetX, offsetY;

    datepicker.getElement().addEventListener('mousedown', function(e) {
        // Pastikan event tidak terpicu pada tombol kalender atau elemen interaktif lainnya
        if (e.target.tagName.toLowerCase() === 'td' || e.target.closest('.calendar-header')) {
            isDragging = true;
            offsetX = e.clientX - datepicker.getElement().getBoundingClientRect().left;
            offsetY = e.clientY - datepicker.getElement().getBoundingClientRect().top;
            
            // Tambahkan cursor saat menggeser
            datepicker.getElement().style.cursor = 'move';
            
            // Mencegah event bubbling agar tidak memicu event klik di luar
            e.stopPropagation();
            e.preventDefault();
        }
    });

    document.addEventListener('mousemove', function(e) {
        if (isDragging) {
            datepicker.getElement().style.left = (e.clientX - offsetX) + "px";
            datepicker.getElement().style.top = (e.clientY - offsetY) + "px";
        }
    });

    document.addEventListener('mouseup', function() {
        if (isDragging) {
            isDragging = false;
            datepicker.getElement().style.cursor = 'default';
        }
    });

    // Untuk menangani resize window
    window.addEventListener('resize', function() {
        if (datepicker.getElement().style.display !== 'none') {
            positionDatepicker();
        }
    });
</script>

    <script type="text/javascript">
        // Initialize DataTable
        $(document).ready(function() {
            $('#dataTable').DataTable({
                "language": {
                    "url": "//cdn.datatables.net/plug-ins/1.13.6/i18n/id.json"
                },
                "pageLength": 25,
                "responsive": true,
                "dom": '<"top"lf>rt<"bottom"ip><"clear">',
                "columnDefs": [
                    { "orderable": false, "targets": 0 }
                ]
            });
            
            // Update statistics
            updateStatistics();
            
            // Show loading overlay on form submit
            $('#searchForm').on('submit', function() {
                $('#loadingOverlay').show();
            });
        });

        // Calendar functionality
        var pickedTxt2 = document.getElementById('par2'),
            datepicker2 = new Calendar(true, 0, false, true);
        document.getElementById('calendar-popup2').appendChild(datepicker2.getElement());
        
        datepicker2.callback = function() {
            var selectedDate = datepicker2.getDate();
            var day = selectedDate.getDate().toString().padStart(2, '0');
            var month = (selectedDate.getMonth() + 1).toString().padStart(2, '0');
            var year = selectedDate.getFullYear();
            pickedTxt2.value = day + '-' + month + '-' + year;
            pickedTxt2.selectionStart = 0;
            pickedTxt2.selectionEnd = pickedTxt2.value.length;
            pickedTxt2.focus();
            datepicker2.hide();
        };

        function pickADate2() {
            datepicker2.show();
            datepicker2.getElement().style.position = 'absolute';
        }

        // Click outside to close calendar
        document.addEventListener('click', function(event) {
            var popup = document.getElementById('calendar-popup2');
            var input = document.getElementById('par2');
            var icon = document.querySelector('.calendar-icon');
            
            if (popup && !popup.contains(event.target) && 
                !input.contains(event.target) && 
                !icon.contains(event.target) &&
                !datepicker2.getElement().contains(event.target)) {
                datepicker2.hide();
            }
        });

        // Update statistics function
        function updateStatistics() {
            var totalRows = $('#dataTable tbody tr').length;
            var totalSaldo = 0;
            
            $('#dataTable tbody tr').each(function() {
                var saldoText = $(this).find('td:eq(4)').text();// jml colum diganti jika dirubah biar saldo diatas berubah
                var saldo = parseInt(saldoText.replace(/[^0-9]/g, ''));
                if (!isNaN(saldo)) {
                    totalSaldo += saldo;
                }
            });
            
            if ($('#totalRekening').length) {
                $('#totalRekening').text(totalRows);
                $('#totalSaldo').text('Rp ' + totalSaldo.toLocaleString('id-ID'));
            }
        }

        // Add smooth scroll effect
        $('html').css('scroll-behavior', 'smooth');
        
        // Add hover effects
        $('.btn').hover(
            function() { $(this).addClass('shadow-lg'); },
            function() { $(this).removeClass('shadow-lg'); }
        );
    </script>

</body>
</html>