<?php 
session_start();
ob_start();
?>

<html>
<head>
  <title>Cetak PDF</title>
  <style>
    table {
      border-collapse: collapse; 
      width: 100%; 
      margin-top: 2%;
    }
    th, td {
      padding: 2px;
      font-size: 9px;
      text-align: left;
    }
    .s2 {  
      font-size: 9px;
      margin: 0;
    } 
    .s1 {  
      text-align: center;  
      font-size: 10px;
      margin: 0;
    }
  </style>
</head>

<body>

<?php
// Load file koneksi.php
include "./../koneksi.php";
error_reporting(1); // hide php errors

if(isset($_GET['no_bukti'])) {   
    $no_bukti = $_GET['no_bukti']; 
    
    $print = mysqli_query($koneksi, "SELECT 
        a.rekening AS rekening,
        a.no_bukti AS no_bukti,
        a.tgl AS tgl,
        a.taksasi,
        a.keterangan AS keterangan,
        b.nama AS nama,
        a.barang AS barang,
        a.jaminan AS jaminan,
        a.plafond AS plafond,
        a.noseri AS noseri,
        a.jtempo AS jatuhtempo 
        FROM pinjaman a 
        LEFT JOIN registrasi b ON b.id=SUBSTR(a.rekening,1,10) 
        WHERE a.no_bukti ='".$no_bukti."' OR a.rekening= '".$no_bukti."' ");

    if (!$print) {
        echo "Error fetching data: " . mysqli_error($koneksi);
        exit;
    }

    $data = mysqli_fetch_array($print);
    extract($data);

    $tglskrg = date('Y-m-d');
?>
  
<table border="0">
  <tr>
    <td><img src="./../img/angs.png" style="width:140px;height:72px;" /></td>
  </tr>
</table>

<table border="0">
  <tr>
    <td>Tanggal</td>
    <td>:</td>    
    <td class="s2" style="width: 80px;"><?php echo $tgl; ?></td>
  </tr>
  <tr>
    <td>No Kwitansi</td>
    <td>:</td>    
    <td class="s2" style="width: 80px;"><?php echo $no_bukti; ?></td>
  </tr>
  <tr>
    <td>No Rek</td>
    <td>:</td>    
    <td class="s2" style="width: 80px;"><?php echo $rekening; ?></td>
  </tr>
  <tr>
    <td>Nama</td>
    <td>:</td>    
    <td class="s2" style="width: 80px;"><?php echo $nama; ?></td>
  </tr>
  <tr>
    <td>Barang</td>
    <td>:</td>    
    <td class="s2" style="width: 80px;"><?php echo $barang; ?></td>
  </tr>
  <tr>
    <td>No Seri</td>
    <td>:</td>    
    <td class="s2" style="width: 80px;"><?php echo $noseri; ?></td>
  </tr>
  <tr>
    <td>Nilai Pinjaman</td>
    <td>:</td>    
    <td class="s2" style="width: 80px;"><?php echo number_format($plafond,0); ?></td>
  </tr>
  <tr>
    <td>Administrasi</td>
    <td>:</td>    
    <td class="s2" style="width: 80px;">-</td>
  </tr>
  <tr>
    <td>Asuransi</td>
    <td>:</td>    
    <td class="s2" style="width: 80px;"><?php echo isset($asuransi) ? $asuransi : '-'; ?></td>
  </tr>
  <tr>
    <td>Metode Cair</td>
    <td>:</td>    
    <td class="s2" style="width: 80px;"><?php echo "Tunai"; ?></td>
  </tr>
  <tr>
    <td>Rek Tujuan</td>
    <td>:</td>
    <td class="s2" style="width: 80px;">-</td>
  </tr>
  <tr>
    <td>Jatuh Tempo</td>
    <td>:</td>    
    <td class="s2" style="width: 80px;"><?php echo $jatuhtempo; ?></td>
  </tr>
</table>

<b><p class="s2"><?php echo "---------------------------------------------"; ?></p></b>
<p class="s2">
<?php echo "Apabila sampai dengan tanggal jatuh tempo nasabah tidak melunasi atau melakukan perpanjangan, maka nasabah memberikan kuasa kepada Pihak PT Gadai untuk menjual barang jaminan.<br>"; ?>
</p>

<?php
}
?>

</body>
</html>

<?php
$html = ob_get_contents();
ob_end_clean();

require '../html2pdf/autoload.php';
// Set custom page size in mm (5.2 cm and 11 cm)
$pdf = new Spipu\Html2Pdf\Html2Pdf('P', array(52, 110), 'en'); // Width: 52 mm, Height: 110 mm
$pdf->WriteHTML($html);
$pdf->Output('Nota Penerimaan Uang.pdf', 'D');
?>
