<?php
// check_noseri.php
header('Content-Type: application/json');

// Ambil noseri dari POST request
$noseri = isset($_POST['noseri']) ? $_POST['noseri'] : '';


// Koneksi ke database (sesuaikan dengan konfigurasi database Anda)
include '../koneksi.php'; // Gunakan file koneksi yang sudah ada

// Cek apakah noseri sudah ada di database dengan bakidebet > 0
$stmt = $koneksi->prepare("SELECT COUNT(*) AS noseri_count, IFNULL(bakidebet, 0) AS bakidebet FROM pinjaman WHERE noseri = ? AND bakidebet > 0");
$stmt->bind_param("s", $noseri);
$stmt->execute();
$result = $stmt->get_result();
$data = $result->fetch_assoc();

// Response
if ($data['noseri_count'] > 0) {
    echo json_encode(['exists' => true, 'bakidebet' => $data['noseri_count']]);
} else {
    echo json_encode(['exists' => false, 'bakidebet' => 0]);
}

$stmt->close();
$koneksi->close();
?>