<?php
session_start(); // Pastikan session dimulai
include '../koneksi.php';

// Cek apakah 'no' tersedia dalam $_POST
$checked_array = isset($_POST['no']) ? $_POST['no'] : []; // Menginisialisasi sebagai array kosong jika tidak ada

if (!empty($checked_array) || !empty($_POST['id']) || !empty($_POST['kls']) || !empty($_POST['tahun']) || !empty($_POST['keterangan'])) {

    // Persiapkan SQL statement untuk penyisipan
    $stmt = $koneksi->prepare("INSERT INTO kelas (no, id, tgl, no_kls, tahun, keterangan, tglmasehi, username) VALUES (NULL, ?, ?, ?, ?, ?, ?, ?)");

    if ($stmt) {
        foreach ($_POST['id'] as $key => $value) {
            if (in_array($value, $checked_array)) { // Periksa apakah ID ada di array yang dicek
                $id = $_POST['id'][$key];
                $tgl = date('Y-m-d');
                $kls = $_POST['kls'][$key];
                $tahun = $_POST['tahun'][$key];
                $keterangan = $_POST['keterangan'][$key];
                $tglmasehi = date('Y-m-d');
                $username = $_SESSION['username'];

                // Bind parameter dan eksekusi
                $stmt->bind_param("issssss", $id, $tgl, $kls, $tahun, $keterangan, $tglmasehi, $username);
                if ($stmt->execute()) {
                    echo "Data Berhasil Disimpan...!<br>";
                } else {
                    echo "Error: " . $stmt->error . "<br>";
                }
            }
        }
        // Tutup statement
        $stmt->close();
    } else {
        echo "Error: " . $koneksi->error; // Kesalahan saat mempersiapkan statement
    }
} else {
    echo "Semua data yang diperlukan harus terisi dan checkbox harus dipilih.";
}
?>
